/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentManagerImpl;
import androidx.lifecycle.Lifecycle;

final class FragmentState
implements Parcelable {
    public static final Parcelable.Creator<FragmentState> CREATOR = new Parcelable.Creator<FragmentState>(){

        public FragmentState createFromParcel(Parcel parcel) {
            return new FragmentState(parcel);
        }

        public FragmentState[] newArray(int n2) {
            return new FragmentState[n2];
        }
    };
    final Bundle mArguments;
    final String mClassName;
    final int mContainerId;
    final boolean mDetached;
    final int mFragmentId;
    final boolean mFromLayout;
    final boolean mHidden;
    Fragment mInstance;
    final int mMaxLifecycleState;
    final boolean mRemoving;
    final boolean mRetainInstance;
    Bundle mSavedFragmentState;
    final String mTag;
    final String mWho;

    FragmentState(Parcel parcel) {
        this.mClassName = parcel.readString();
        this.mWho = parcel.readString();
        int n2 = parcel.readInt();
        boolean bl = true;
        boolean bl2 = n2 != 0;
        this.mFromLayout = bl2;
        this.mFragmentId = parcel.readInt();
        this.mContainerId = parcel.readInt();
        this.mTag = parcel.readString();
        bl2 = parcel.readInt() != 0;
        this.mRetainInstance = bl2;
        bl2 = parcel.readInt() != 0;
        this.mRemoving = bl2;
        bl2 = parcel.readInt() != 0;
        this.mDetached = bl2;
        this.mArguments = parcel.readBundle();
        bl2 = parcel.readInt() != 0 ? bl : false;
        this.mHidden = bl2;
        this.mSavedFragmentState = parcel.readBundle();
        this.mMaxLifecycleState = parcel.readInt();
    }

    FragmentState(Fragment fragment) {
        this.mClassName = fragment.getClass().getName();
        this.mWho = fragment.mWho;
        this.mFromLayout = fragment.mFromLayout;
        this.mFragmentId = fragment.mFragmentId;
        this.mContainerId = fragment.mContainerId;
        this.mTag = fragment.mTag;
        this.mRetainInstance = fragment.mRetainInstance;
        this.mRemoving = fragment.mRemoving;
        this.mDetached = fragment.mDetached;
        this.mArguments = fragment.mArguments;
        this.mHidden = fragment.mHidden;
        this.mMaxLifecycleState = fragment.mMaxState.ordinal();
    }

    public int describeContents() {
        return 0;
    }

    public Fragment instantiate(ClassLoader object, FragmentFactory fragmentFactory) {
        if (this.mInstance == null) {
            Bundle bundle = this.mArguments;
            if (bundle != null) {
                bundle.setClassLoader((ClassLoader)object);
            }
            this.mInstance = fragmentFactory.instantiate((ClassLoader)object, this.mClassName);
            this.mInstance.setArguments(this.mArguments);
            fragmentFactory = this.mSavedFragmentState;
            if (fragmentFactory != null) {
                fragmentFactory.setClassLoader((ClassLoader)object);
                this.mInstance.mSavedFragmentState = this.mSavedFragmentState;
            } else {
                this.mInstance.mSavedFragmentState = new Bundle();
            }
            object = this.mInstance;
            ((Fragment)object).mWho = this.mWho;
            ((Fragment)object).mFromLayout = this.mFromLayout;
            ((Fragment)object).mRestored = true;
            ((Fragment)object).mFragmentId = this.mFragmentId;
            ((Fragment)object).mContainerId = this.mContainerId;
            ((Fragment)object).mTag = this.mTag;
            ((Fragment)object).mRetainInstance = this.mRetainInstance;
            ((Fragment)object).mRemoving = this.mRemoving;
            ((Fragment)object).mDetached = this.mDetached;
            ((Fragment)object).mHidden = this.mHidden;
            ((Fragment)object).mMaxState = Lifecycle.State.values()[this.mMaxLifecycleState];
            if (FragmentManagerImpl.DEBUG) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Instantiated fragment ");
                ((StringBuilder)object).append(this.mInstance);
                Log.v((String)"FragmentManager", (String)((StringBuilder)object).toString());
            }
        }
        return this.mInstance;
    }

    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("FragmentState{");
        stringBuilder.append(this.mClassName);
        stringBuilder.append(" (");
        stringBuilder.append(this.mWho);
        stringBuilder.append(")}:");
        if (this.mFromLayout) {
            stringBuilder.append(" fromLayout");
        }
        if (this.mContainerId != 0) {
            stringBuilder.append(" id=0x");
            stringBuilder.append(Integer.toHexString(this.mContainerId));
        }
        if ((string2 = this.mTag) != null && !string2.isEmpty()) {
            stringBuilder.append(" tag=");
            stringBuilder.append(this.mTag);
        }
        if (this.mRetainInstance) {
            stringBuilder.append(" retainInstance");
        }
        if (this.mRemoving) {
            stringBuilder.append(" removing");
        }
        if (this.mDetached) {
            stringBuilder.append(" detached");
        }
        if (this.mHidden) {
            stringBuilder.append(" hidden");
        }
        return stringBuilder.toString();
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.mClassName);
        parcel.writeString(this.mWho);
        parcel.writeInt(this.mFromLayout ? 1 : 0);
        parcel.writeInt(this.mFragmentId);
        parcel.writeInt(this.mContainerId);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.mRetainInstance ? 1 : 0);
        parcel.writeInt(this.mRemoving ? 1 : 0);
        parcel.writeInt(this.mDetached ? 1 : 0);
        parcel.writeBundle(this.mArguments);
        parcel.writeInt(this.mHidden ? 1 : 0);
        parcel.writeBundle(this.mSavedFragmentState);
        parcel.writeInt(this.mMaxLifecycleState);
    }
}

