/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.Transformation;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherOwner;
import androidx.collection.ArraySet;
import androidx.core.util.DebugUtils;
import androidx.core.util.LogWriter;
import androidx.core.view.OneShotPreDrawListener;
import androidx.fragment.app.BackStackRecord;
import androidx.fragment.app.BackStackState;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentHostCallback;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentManagerNonConfig;
import androidx.fragment.app.FragmentManagerState;
import androidx.fragment.app.FragmentManagerViewModel;
import androidx.fragment.app.FragmentState;
import androidx.fragment.app.FragmentTransaction;
import androidx.fragment.app.FragmentTransition;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

final class FragmentManagerImpl
extends FragmentManager
implements LayoutInflater.Factory2 {
    static final int ANIM_DUR = 220;
    public static final int ANIM_STYLE_CLOSE_ENTER = 3;
    public static final int ANIM_STYLE_CLOSE_EXIT = 4;
    public static final int ANIM_STYLE_FADE_ENTER = 5;
    public static final int ANIM_STYLE_FADE_EXIT = 6;
    public static final int ANIM_STYLE_OPEN_ENTER = 1;
    public static final int ANIM_STYLE_OPEN_EXIT = 2;
    static boolean DEBUG = false;
    static final Interpolator DECELERATE_CUBIC;
    static final Interpolator DECELERATE_QUINT;
    static final String TAG = "FragmentManager";
    static final String TARGET_REQUEST_CODE_STATE_TAG = "android:target_req_state";
    static final String TARGET_STATE_TAG = "android:target_state";
    static final String USER_VISIBLE_HINT_TAG = "android:user_visible_hint";
    static final String VIEW_STATE_TAG = "android:view_state";
    final HashMap<String, Fragment> mActive;
    final ArrayList<Fragment> mAdded = new ArrayList();
    ArrayList<Integer> mAvailBackStackIndices;
    ArrayList<BackStackRecord> mBackStack;
    ArrayList<FragmentManager.OnBackStackChangedListener> mBackStackChangeListeners;
    ArrayList<BackStackRecord> mBackStackIndices;
    FragmentContainer mContainer;
    ArrayList<Fragment> mCreatedMenus;
    int mCurState = 0;
    boolean mDestroyed;
    Runnable mExecCommit;
    boolean mExecutingActions;
    boolean mHavePendingDeferredStart;
    FragmentHostCallback mHost;
    private final CopyOnWriteArrayList<FragmentLifecycleCallbacksHolder> mLifecycleCallbacks;
    boolean mNeedMenuInvalidate;
    int mNextFragmentIndex = 0;
    private FragmentManagerViewModel mNonConfig;
    private final OnBackPressedCallback mOnBackPressedCallback;
    private OnBackPressedDispatcher mOnBackPressedDispatcher;
    Fragment mParent;
    ArrayList<OpGenerator> mPendingActions;
    ArrayList<StartEnterTransitionListener> mPostponedTransactions;
    Fragment mPrimaryNav;
    SparseArray<Parcelable> mStateArray = null;
    Bundle mStateBundle = null;
    boolean mStateSaved;
    boolean mStopped;
    ArrayList<Fragment> mTmpAddedFragments;
    ArrayList<Boolean> mTmpIsPop;
    ArrayList<BackStackRecord> mTmpRecords;

    static {
        DECELERATE_QUINT = new DecelerateInterpolator(2.5f);
        DECELERATE_CUBIC = new DecelerateInterpolator(1.5f);
    }

    FragmentManagerImpl() {
        this.mActive = new HashMap();
        this.mOnBackPressedCallback = new OnBackPressedCallback(false){

            public void handleOnBackPressed() {
                FragmentManagerImpl.this.handleOnBackPressed();
            }
        };
        this.mLifecycleCallbacks = new CopyOnWriteArrayList();
        this.mExecCommit = new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.execPendingActions();
            }
        };
    }

    private void addAddedFragments(ArraySet<Fragment> arraySet) {
        int n2 = this.mCurState;
        if (n2 < 1) {
            return;
        }
        int n3 = Math.min(n2, 3);
        int n4 = this.mAdded.size();
        for (n2 = 0; n2 < n4; ++n2) {
            Fragment fragment = this.mAdded.get(n2);
            if (fragment.mState >= n3) continue;
            this.moveToState(fragment, n3, fragment.getNextAnim(), fragment.getNextTransition(), false);
            if (fragment.mView == null || fragment.mHidden || !fragment.mIsNewlyAdded) continue;
            arraySet.add((Object)fragment);
        }
    }

    private void animateRemoveFragment(final Fragment fragment, AnimationOrAnimator object, int n2) {
        final View view = fragment.mView;
        final ViewGroup viewGroup = fragment.mContainer;
        viewGroup.startViewTransition(view);
        fragment.setStateAfterAnimating(n2);
        if (((AnimationOrAnimator)object).animation != null) {
            object = new EndViewTransitionAnimation(((AnimationOrAnimator)object).animation, viewGroup, view);
            fragment.setAnimatingAway(fragment.mView);
            object.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                    viewGroup.post(new Runnable(){

                        @Override
                        public void run() {
                            if (fragment.getAnimatingAway() != null) {
                                fragment.setAnimatingAway(null);
                                FragmentManagerImpl.this.moveToState(fragment, fragment.getStateAfterAnimating(), 0, 0, false);
                            }
                        }
                    });
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationStart(Animation animation) {
                }
            });
            fragment.mView.startAnimation((Animation)object);
        } else {
            Animator animator = ((AnimationOrAnimator)object).animator;
            fragment.setAnimator(((AnimationOrAnimator)object).animator);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator) {
                    viewGroup.endViewTransition(view);
                    animator = fragment.getAnimator();
                    fragment.setAnimator(null);
                    if (animator != null && viewGroup.indexOfChild(view) < 0) {
                        FragmentManagerImpl fragmentManagerImpl = FragmentManagerImpl.this;
                        animator = fragment;
                        fragmentManagerImpl.moveToState((Fragment)animator, animator.getStateAfterAnimating(), 0, 0, false);
                    }
                }
            });
            animator.setTarget((Object)fragment.mView);
            animator.start();
        }
    }

    private void burpActive() {
        this.mActive.values().removeAll(Collections.singleton(null));
    }

    private void checkStateLoss() {
        if (!this.isStateSaved()) {
            return;
        }
        throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
    }

    private void cleanupExec() {
        this.mExecutingActions = false;
        this.mTmpIsPop.clear();
        this.mTmpRecords.clear();
    }

    private void dispatchParentPrimaryNavigationFragmentChanged(Fragment fragment) {
        if (fragment != null && this.mActive.get(fragment.mWho) == fragment) {
            fragment.performPrimaryNavigationFragmentChanged();
        }
    }

    private void dispatchStateChange(int n2) {
        this.mExecutingActions = true;
        this.moveToState(n2, false);
        this.execPendingActions();
        return;
        finally {
            this.mExecutingActions = false;
        }
    }

    private void endAnimatingAwayFragments() {
        for (Fragment fragment : this.mActive.values()) {
            if (fragment == null) continue;
            if (fragment.getAnimatingAway() != null) {
                int n2 = fragment.getStateAfterAnimating();
                View view = fragment.getAnimatingAway();
                Animation animation = view.getAnimation();
                if (animation != null) {
                    animation.cancel();
                    view.clearAnimation();
                }
                fragment.setAnimatingAway(null);
                this.moveToState(fragment, n2, 0, 0, false);
                continue;
            }
            if (fragment.getAnimator() == null) continue;
            fragment.getAnimator().end();
        }
    }

    private void ensureExecReady(boolean bl) {
        if (!this.mExecutingActions) {
            if (this.mHost != null) {
                if (Looper.myLooper() == this.mHost.getHandler().getLooper()) {
                    if (!bl) {
                        this.checkStateLoss();
                    }
                    if (this.mTmpRecords == null) {
                        this.mTmpRecords = new ArrayList();
                        this.mTmpIsPop = new ArrayList();
                    }
                    this.mExecutingActions = true;
                    try {
                        this.executePostponedTransaction(null, null);
                        return;
                    }
                    finally {
                        this.mExecutingActions = false;
                    }
                }
                throw new IllegalStateException("Must be called from main thread of fragment host");
            }
            throw new IllegalStateException("Fragment host has been destroyed");
        }
        throw new IllegalStateException("FragmentManager is already executing transactions");
    }

    private static void executeOps(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2, int n2, int n3) {
        while (n2 < n3) {
            BackStackRecord backStackRecord = arrayList.get(n2);
            boolean bl = arrayList2.get(n2);
            boolean bl2 = true;
            if (bl) {
                backStackRecord.bumpBackStackNesting(-1);
                if (n2 != n3 - 1) {
                    bl2 = false;
                }
                backStackRecord.executePopOps(bl2);
            } else {
                backStackRecord.bumpBackStackNesting(1);
                backStackRecord.executeOps();
            }
            ++n2;
        }
    }

    private void executeOpsTogether(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2, int n2, int n3) {
        int n4;
        int n5 = n2;
        boolean bl = arrayList.get((int)n5).mReorderingAllowed;
        Fragment fragment = this.mTmpAddedFragments;
        if (fragment == null) {
            this.mTmpAddedFragments = new ArrayList();
        } else {
            fragment.clear();
        }
        this.mTmpAddedFragments.addAll(this.mAdded);
        fragment = this.getPrimaryNavigationFragment();
        boolean bl2 = false;
        for (n4 = n5; n4 < n3; ++n4) {
            BackStackRecord backStackRecord = arrayList.get(n4);
            fragment = arrayList2.get(n4) == false ? backStackRecord.expandOps(this.mTmpAddedFragments, fragment) : backStackRecord.trackAddedFragmentsInPop(this.mTmpAddedFragments, fragment);
            if (!bl2 && !backStackRecord.mAddToBackStack) {
                bl2 = false;
                continue;
            }
            bl2 = true;
        }
        this.mTmpAddedFragments.clear();
        if (!bl) {
            FragmentTransition.startTransitions((FragmentManagerImpl)this, arrayList, arrayList2, (int)n2, (int)n3, (boolean)false);
        }
        FragmentManagerImpl.executeOps(arrayList, arrayList2, n2, n3);
        if (bl) {
            fragment = new ArraySet();
            this.addAddedFragments((ArraySet<Fragment>)fragment);
            n4 = this.postponePostponableTransactions(arrayList, arrayList2, n2, n3, (ArraySet<Fragment>)fragment);
            this.makeRemovedFragmentsInvisible((ArraySet<Fragment>)fragment);
        } else {
            n4 = n3;
        }
        int n6 = n5;
        if (n4 != n5) {
            n6 = n5;
            if (bl) {
                FragmentTransition.startTransitions((FragmentManagerImpl)this, arrayList, arrayList2, (int)n2, (int)n4, (boolean)true);
                this.moveToState(this.mCurState, true);
                n6 = n5;
            }
        }
        while (n6 < n3) {
            fragment = arrayList.get(n6);
            if (arrayList2.get(n6).booleanValue() && fragment.mIndex >= 0) {
                this.freeBackStackIndex(fragment.mIndex);
                fragment.mIndex = -1;
            }
            fragment.runOnCommitRunnables();
            ++n6;
        }
        if (bl2) {
            this.reportBackStackChanged();
        }
    }

    private void executePostponedTransaction(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2) {
        ArrayList<StartEnterTransitionListener> arrayList3 = this.mPostponedTransactions;
        int n2 = arrayList3 == null ? 0 : arrayList3.size();
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            int n5;
            block7: {
                block8: {
                    block6: {
                        arrayList3 = this.mPostponedTransactions.get(n3);
                        if (arrayList == null || ((StartEnterTransitionListener)((Object)arrayList3)).mIsBack || (n2 = arrayList.indexOf(((StartEnterTransitionListener)((Object)arrayList3)).mRecord)) == -1 || !arrayList2.get(n2).booleanValue()) break block6;
                        this.mPostponedTransactions.remove(n3);
                        n2 = n3 - 1;
                        n5 = n4 - 1;
                        ((StartEnterTransitionListener)((Object)arrayList3)).cancelTransaction();
                        break block7;
                    }
                    if (((StartEnterTransitionListener)((Object)arrayList3)).isReady()) break block8;
                    n2 = n3;
                    n5 = n4;
                    if (arrayList == null) break block7;
                    n2 = n3;
                    n5 = n4;
                    if (!((StartEnterTransitionListener)((Object)arrayList3)).mRecord.interactsWith(arrayList, 0, arrayList.size())) break block7;
                }
                this.mPostponedTransactions.remove(n3);
                n2 = n3 - 1;
                n5 = n4 - 1;
                if (arrayList != null && !((StartEnterTransitionListener)((Object)arrayList3)).mIsBack && (n3 = arrayList.indexOf(((StartEnterTransitionListener)((Object)arrayList3)).mRecord)) != -1 && arrayList2.get(n3).booleanValue()) {
                    ((StartEnterTransitionListener)((Object)arrayList3)).cancelTransaction();
                } else {
                    ((StartEnterTransitionListener)((Object)arrayList3)).completeTransaction();
                }
            }
            n3 = n2 + 1;
            n4 = n5;
        }
    }

    private Fragment findFragmentUnder(Fragment fragment) {
        ViewGroup viewGroup = fragment.mContainer;
        View view = fragment.mView;
        if (viewGroup != null && view != null) {
            for (int i2 = this.mAdded.indexOf(fragment) - 1; i2 >= 0; --i2) {
                fragment = this.mAdded.get(i2);
                if (fragment.mContainer != viewGroup || fragment.mView == null) continue;
                return fragment;
            }
        }
        return null;
    }

    private void forcePostponedTransactions() {
        if (this.mPostponedTransactions != null) {
            while (!this.mPostponedTransactions.isEmpty()) {
                this.mPostponedTransactions.remove(0).completeTransaction();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generateOpsForPendingActions(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2) {
        synchronized (this) {
            block5: {
                ArrayList<OpGenerator> arrayList3 = this.mPendingActions;
                if (arrayList3 == null) return false;
                if (this.mPendingActions.size() == 0) break block5;
                int n2 = this.mPendingActions.size();
                boolean bl = false;
                for (int i2 = 0; i2 < n2; bl |= this.mPendingActions.get(i2).generateOps(arrayList, arrayList2), ++i2) {
                }
                this.mPendingActions.clear();
                this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                return bl;
            }
            return false;
        }
    }

    private boolean isMenuAvailable(Fragment fragment) {
        boolean bl = fragment.mHasMenu && fragment.mMenuVisible || fragment.mChildFragmentManager.checkForMenus();
        return bl;
    }

    static AnimationOrAnimator makeFadeAnimation(float f2, float f3) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(f2, f3);
        alphaAnimation.setInterpolator(DECELERATE_CUBIC);
        alphaAnimation.setDuration(220L);
        return new AnimationOrAnimator((Animation)alphaAnimation);
    }

    static AnimationOrAnimator makeOpenCloseAnimation(float f2, float f3, float f4, float f5) {
        AnimationSet animationSet = new AnimationSet(false);
        ScaleAnimation scaleAnimation = new ScaleAnimation(f2, f3, f2, f3, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setInterpolator(DECELERATE_QUINT);
        scaleAnimation.setDuration(220L);
        animationSet.addAnimation((Animation)scaleAnimation);
        scaleAnimation = new AlphaAnimation(f4, f5);
        scaleAnimation.setInterpolator(DECELERATE_CUBIC);
        scaleAnimation.setDuration(220L);
        animationSet.addAnimation((Animation)scaleAnimation);
        return new AnimationOrAnimator((Animation)animationSet);
    }

    private void makeRemovedFragmentsInvisible(ArraySet<Fragment> arraySet) {
        int n2 = arraySet.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fragment fragment = (Fragment)arraySet.valueAt(i2);
            if (fragment.mAdded) continue;
            View view = fragment.requireView();
            fragment.mPostponedAlpha = view.getAlpha();
            view.setAlpha(0.0f);
        }
    }

    private boolean popBackStackImmediate(String string2, int n2, int n3) {
        this.execPendingActions();
        this.ensureExecReady(true);
        Fragment fragment = this.mPrimaryNav;
        if (fragment != null && n2 < 0 && string2 == null && fragment.getChildFragmentManager().popBackStackImmediate()) {
            return true;
        }
        boolean bl = this.popBackStackState(this.mTmpRecords, this.mTmpIsPop, string2, n2, n3);
        if (bl) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.burpActive();
        return bl;
    }

    private int postponePostponableTransactions(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2, int n2, int n3, ArraySet<Fragment> arraySet) {
        int n4 = n3;
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            BackStackRecord backStackRecord = arrayList.get(i2);
            boolean bl = arrayList2.get(i2);
            boolean bl2 = backStackRecord.isPostponed() && !backStackRecord.interactsWith(arrayList, i2 + 1, n3);
            int n5 = n4;
            if (bl2) {
                if (this.mPostponedTransactions == null) {
                    this.mPostponedTransactions = new ArrayList();
                }
                StartEnterTransitionListener startEnterTransitionListener = new StartEnterTransitionListener(backStackRecord, bl);
                this.mPostponedTransactions.add(startEnterTransitionListener);
                backStackRecord.setOnStartPostponedListener((Fragment.OnStartEnterTransitionListener)startEnterTransitionListener);
                if (bl) {
                    backStackRecord.executeOps();
                } else {
                    backStackRecord.executePopOps(false);
                }
                n5 = n4 - 1;
                if (i2 != n5) {
                    arrayList.remove(i2);
                    arrayList.add(n5, backStackRecord);
                }
                this.addAddedFragments(arraySet);
            }
            n4 = n5;
        }
        return n4;
    }

    private void removeRedundantOperationsAndExecute(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2) {
        if (arrayList != null && !arrayList.isEmpty()) {
            if (arrayList2 != null && arrayList.size() == arrayList2.size()) {
                this.executePostponedTransaction(arrayList, arrayList2);
                int n2 = arrayList.size();
                int n3 = 0;
                int n4 = 0;
                while (n3 < n2) {
                    int n5 = n3;
                    int n6 = n4;
                    if (!arrayList.get((int)n3).mReorderingAllowed) {
                        if (n4 != n3) {
                            this.executeOpsTogether(arrayList, arrayList2, n4, n3);
                        }
                        n6 = n4 = n3 + 1;
                        if (arrayList2.get(n3).booleanValue()) {
                            while (true) {
                                n6 = n4;
                                if (n4 >= n2) break;
                                n6 = n4;
                                if (!arrayList2.get(n4).booleanValue()) break;
                                n6 = n4;
                                if (arrayList.get((int)n4).mReorderingAllowed) break;
                                ++n4;
                            }
                        }
                        this.executeOpsTogether(arrayList, arrayList2, n3, n6);
                        n5 = n6 - 1;
                    }
                    n3 = n5 + 1;
                    n4 = n6;
                }
                if (n4 != n2) {
                    this.executeOpsTogether(arrayList, arrayList2, n4, n2);
                }
                return;
            }
            throw new IllegalStateException("Internal error with the back stack records");
        }
    }

    public static int reverseTransit(int n2) {
        int n3 = 8194;
        if (n2 != 4097) {
            n3 = n2 != 4099 ? (n2 != 8194 ? 0 : 4097) : 4099;
        }
        return n3;
    }

    private void throwException(RuntimeException runtimeException) {
        Log.e((String)TAG, (String)runtimeException.getMessage());
        Log.e((String)TAG, (String)"Activity state:");
        PrintWriter printWriter = new PrintWriter((Writer)new LogWriter(TAG));
        FragmentHostCallback fragmentHostCallback = this.mHost;
        if (fragmentHostCallback != null) {
            try {
                fragmentHostCallback.onDump("  ", null, printWriter, new String[0]);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
            }
        } else {
            try {
                this.dump("  ", null, printWriter, new String[0]);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
            }
        }
        throw runtimeException;
    }

    public static int transitToStyleIndex(int n2, boolean bl) {
        n2 = n2 != 4097 ? (n2 != 4099 ? (n2 != 8194 ? -1 : (bl ? 3 : 4)) : (bl ? 5 : 6)) : (bl ? 1 : 2);
        return n2;
    }

    private void updateOnBackPressedCallbackEnabled() {
        OnBackPressedCallback onBackPressedCallback = this.mPendingActions;
        boolean bl = true;
        if (onBackPressedCallback != null && !onBackPressedCallback.isEmpty()) {
            this.mOnBackPressedCallback.setEnabled(true);
            return;
        }
        onBackPressedCallback = this.mOnBackPressedCallback;
        if (this.getBackStackEntryCount() <= 0 || !this.isPrimaryNavigation(this.mParent)) {
            bl = false;
        }
        onBackPressedCallback.setEnabled(bl);
    }

    void addBackStackState(BackStackRecord backStackRecord) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(backStackRecord);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFragment(Fragment fragment, boolean bl) {
        Serializable serializable;
        if (DEBUG) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("add: ");
            ((StringBuilder)serializable).append(fragment);
            Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
        }
        this.makeActive(fragment);
        if (fragment.mDetached) return;
        if (this.mAdded.contains(fragment)) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("Fragment already added: ");
            ((StringBuilder)serializable).append(fragment);
            throw new IllegalStateException(((StringBuilder)serializable).toString());
        }
        serializable = this.mAdded;
        synchronized (serializable) {
            this.mAdded.add(fragment);
        }
        fragment.mAdded = true;
        fragment.mRemoving = false;
        if (fragment.mView == null) {
            fragment.mHiddenChanged = false;
        }
        if (this.isMenuAvailable(fragment)) {
            this.mNeedMenuInvalidate = true;
        }
        if (!bl) return;
        this.moveToState(fragment);
    }

    @Override
    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(onBackStackChangedListener);
    }

    void addRetainedFragment(Fragment fragment) {
        if (this.isStateSaved()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)"Ignoring addRetainedFragment as the state is already saved");
            }
            return;
        }
        if (this.mNonConfig.addRetainedFragment(fragment) && DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Updating retained Fragments: Added ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int allocBackStackIndex(BackStackRecord backStackRecord) {
        synchronized (this) {
            Serializable serializable;
            if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
                int n2 = this.mAvailBackStackIndices.remove(this.mAvailBackStackIndices.size() - 1);
                if (DEBUG) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Adding back stack index ");
                    stringBuilder.append(n2);
                    stringBuilder.append(" with ");
                    stringBuilder.append(backStackRecord);
                    Log.v((String)TAG, (String)stringBuilder.toString());
                }
                this.mBackStackIndices.set(n2, backStackRecord);
                return n2;
            }
            if (this.mBackStackIndices == null) {
                serializable = new ArrayList();
                this.mBackStackIndices = serializable;
            }
            int n3 = this.mBackStackIndices.size();
            if (DEBUG) {
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("Setting back stack index ");
                ((StringBuilder)serializable).append(n3);
                ((StringBuilder)serializable).append(" to ");
                ((StringBuilder)serializable).append(backStackRecord);
                Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
            }
            this.mBackStackIndices.add(backStackRecord);
            return n3;
        }
    }

    public void attachController(FragmentHostCallback fragmentHostCallback, FragmentContainer object, Fragment fragment) {
        if (this.mHost == null) {
            this.mHost = fragmentHostCallback;
            this.mContainer = object;
            this.mParent = fragment;
            if (this.mParent != null) {
                this.updateOnBackPressedCallbackEnabled();
            }
            if (fragmentHostCallback instanceof OnBackPressedDispatcherOwner) {
                object = (OnBackPressedDispatcherOwner)fragmentHostCallback;
                this.mOnBackPressedDispatcher = object.getOnBackPressedDispatcher();
                if (fragment != null) {
                    object = fragment;
                }
                this.mOnBackPressedDispatcher.addCallback((LifecycleOwner)object, this.mOnBackPressedCallback);
            }
            this.mNonConfig = fragment != null ? fragment.mFragmentManager.getChildNonConfig(fragment) : (fragmentHostCallback instanceof ViewModelStoreOwner ? FragmentManagerViewModel.getInstance((ViewModelStore)((ViewModelStoreOwner)fragmentHostCallback).getViewModelStore()) : new FragmentManagerViewModel(false));
            return;
        }
        throw new IllegalStateException("Already attached");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void attachFragment(Fragment fragment) {
        Serializable serializable;
        if (DEBUG) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("attach: ");
            ((StringBuilder)serializable).append(fragment);
            Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
        }
        if (!fragment.mDetached) return;
        fragment.mDetached = false;
        if (fragment.mAdded) return;
        if (this.mAdded.contains(fragment)) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("Fragment already added: ");
            ((StringBuilder)serializable).append(fragment);
            throw new IllegalStateException(((StringBuilder)serializable).toString());
        }
        if (DEBUG) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("add from attach: ");
            ((StringBuilder)serializable).append(fragment);
            Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
        }
        serializable = this.mAdded;
        synchronized (serializable) {
            this.mAdded.add(fragment);
        }
        fragment.mAdded = true;
        if (!this.isMenuAvailable(fragment)) return;
        this.mNeedMenuInvalidate = true;
    }

    @Override
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    boolean checkForMenus() {
        Iterator<Fragment> iterator2 = this.mActive.values().iterator();
        boolean bl = false;
        while (iterator2.hasNext()) {
            Fragment fragment = iterator2.next();
            boolean bl2 = bl;
            if (fragment != null) {
                bl2 = this.isMenuAvailable(fragment);
            }
            bl = bl2;
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    void completeExecute(BackStackRecord backStackRecord, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            backStackRecord.executePopOps(bl3);
        } else {
            backStackRecord.executeOps();
        }
        Fragment fragment2 = new ArrayList(1);
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(1);
        fragment2.add(backStackRecord);
        arrayList.add(bl);
        if (bl2) {
            FragmentTransition.startTransitions((FragmentManagerImpl)this, fragment2, arrayList, (int)0, (int)1, (boolean)true);
        }
        if (bl3) {
            this.moveToState(this.mCurState, true);
        }
        for (Fragment fragment2 : this.mActive.values()) {
            if (fragment2 == null || fragment2.mView == null || !fragment2.mIsNewlyAdded || !backStackRecord.interactsWith(fragment2.mContainerId)) continue;
            if (fragment2.mPostponedAlpha > 0.0f) {
                fragment2.mView.setAlpha(fragment2.mPostponedAlpha);
            }
            if (bl3) {
                fragment2.mPostponedAlpha = 0.0f;
                continue;
            }
            fragment2.mPostponedAlpha = -1.0f;
            fragment2.mIsNewlyAdded = false;
        }
    }

    void completeShowHideFragment(final Fragment fragment) {
        if (fragment.mView != null) {
            AnimationOrAnimator animationOrAnimator = this.loadAnimation(fragment, fragment.getNextTransition(), fragment.mHidden ^ true, fragment.getNextTransitionStyle());
            if (animationOrAnimator != null && animationOrAnimator.animator != null) {
                animationOrAnimator.animator.setTarget((Object)fragment.mView);
                if (fragment.mHidden) {
                    if (fragment.isHideReplaced()) {
                        fragment.setHideReplaced(false);
                    } else {
                        final ViewGroup viewGroup = fragment.mContainer;
                        final View view = fragment.mView;
                        viewGroup.startViewTransition(view);
                        animationOrAnimator.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animator) {
                                viewGroup.endViewTransition(view);
                                animator.removeListener((Animator.AnimatorListener)this);
                                if (fragment.mView != null && fragment.mHidden) {
                                    fragment.mView.setVisibility(8);
                                }
                            }
                        });
                    }
                } else {
                    fragment.mView.setVisibility(0);
                }
                animationOrAnimator.animator.start();
            } else {
                if (animationOrAnimator != null) {
                    fragment.mView.startAnimation(animationOrAnimator.animation);
                    animationOrAnimator.animation.start();
                }
                int n2 = fragment.mHidden && !fragment.isHideReplaced() ? 8 : 0;
                fragment.mView.setVisibility(n2);
                if (fragment.isHideReplaced()) {
                    fragment.setHideReplaced(false);
                }
            }
        }
        if (fragment.mAdded && this.isMenuAvailable(fragment)) {
            this.mNeedMenuInvalidate = true;
        }
        fragment.mHiddenChanged = false;
        fragment.onHiddenChanged(fragment.mHidden);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void detachFragment(Fragment fragment) {
        Serializable serializable;
        if (DEBUG) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("detach: ");
            ((StringBuilder)serializable).append(fragment);
            Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
        }
        if (fragment.mDetached) return;
        fragment.mDetached = true;
        if (!fragment.mAdded) return;
        if (DEBUG) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("remove from detach: ");
            ((StringBuilder)serializable).append(fragment);
            Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
        }
        serializable = this.mAdded;
        // MONITORENTER : serializable
        this.mAdded.remove(fragment);
        // MONITOREXIT : serializable
        if (this.isMenuAvailable(fragment)) {
            this.mNeedMenuInvalidate = true;
        }
        fragment.mAdded = false;
    }

    public void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(2);
    }

    public void dispatchConfigurationChanged(Configuration configuration) {
        for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
            Fragment fragment = this.mAdded.get(i2);
            if (fragment == null) continue;
            fragment.performConfigurationChanged(configuration);
        }
    }

    public boolean dispatchContextItemSelected(MenuItem menuItem) {
        if (this.mCurState < 1) {
            return false;
        }
        for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
            Fragment fragment = this.mAdded.get(i2);
            if (fragment == null || !fragment.performContextItemSelected(menuItem)) continue;
            return true;
        }
        return false;
    }

    public void dispatchCreate() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(1);
    }

    public boolean dispatchCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        int n2 = this.mCurState;
        int n3 = 0;
        if (n2 < 1) {
            return false;
        }
        ArrayList<Fragment> arrayList = null;
        boolean bl = false;
        for (n2 = 0; n2 < this.mAdded.size(); ++n2) {
            Fragment fragment = this.mAdded.get(n2);
            ArrayList<Fragment> arrayList2 = arrayList;
            boolean bl2 = bl;
            if (fragment != null) {
                arrayList2 = arrayList;
                bl2 = bl;
                if (fragment.performCreateOptionsMenu(menu2, menuInflater)) {
                    arrayList2 = arrayList;
                    if (arrayList == null) {
                        arrayList2 = new ArrayList<Fragment>();
                    }
                    arrayList2.add(fragment);
                    bl2 = true;
                }
            }
            arrayList = arrayList2;
            bl = bl2;
        }
        if (this.mCreatedMenus != null) {
            for (n2 = n3; n2 < this.mCreatedMenus.size(); ++n2) {
                menu2 = this.mCreatedMenus.get(n2);
                if (arrayList != null && arrayList.contains(menu2)) continue;
                menu2.onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = arrayList;
        return bl;
    }

    public void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions();
        this.dispatchStateChange(0);
        this.mHost = null;
        this.mContainer = null;
        this.mParent = null;
        if (this.mOnBackPressedDispatcher != null) {
            this.mOnBackPressedCallback.remove();
            this.mOnBackPressedDispatcher = null;
        }
    }

    public void dispatchDestroyView() {
        this.dispatchStateChange(1);
    }

    public void dispatchLowMemory() {
        for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
            Fragment fragment = this.mAdded.get(i2);
            if (fragment == null) continue;
            fragment.performLowMemory();
        }
    }

    public void dispatchMultiWindowModeChanged(boolean bl) {
        for (int i2 = this.mAdded.size() - 1; i2 >= 0; --i2) {
            Fragment fragment = this.mAdded.get(i2);
            if (fragment == null) continue;
            fragment.performMultiWindowModeChanged(bl);
        }
    }

    void dispatchOnFragmentActivityCreated(Fragment fragment, Bundle bundle, boolean bl) {
        Object object = this.mParent;
        if (object != null && (object = object.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)object).dispatchOnFragmentActivityCreated(fragment, bundle, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentActivityCreated(this, fragment, bundle);
        }
    }

    void dispatchOnFragmentAttached(Fragment fragment, Context context, boolean bl) {
        FragmentManager fragmentManager;
        Fragment object2 = this.mParent;
        if (object2 != null && (fragmentManager = object2.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)fragmentManager).dispatchOnFragmentAttached(fragment, context, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentAttached(this, fragment, context);
        }
    }

    void dispatchOnFragmentCreated(Fragment fragment, Bundle bundle, boolean bl) {
        Object object = this.mParent;
        if (object != null && (object = object.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)object).dispatchOnFragmentCreated(fragment, bundle, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentCreated(this, fragment, bundle);
        }
    }

    void dispatchOnFragmentDestroyed(Fragment fragment, boolean bl) {
        FragmentManager fragmentManager;
        Fragment object2 = this.mParent;
        if (object2 != null && (fragmentManager = object2.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)fragmentManager).dispatchOnFragmentDestroyed(fragment, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentDestroyed(this, fragment);
        }
    }

    void dispatchOnFragmentDetached(Fragment fragment, boolean bl) {
        FragmentManager fragmentManager;
        Fragment object2 = this.mParent;
        if (object2 != null && (fragmentManager = object2.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)fragmentManager).dispatchOnFragmentDetached(fragment, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentDetached(this, fragment);
        }
    }

    void dispatchOnFragmentPaused(Fragment fragment, boolean bl) {
        Object object = this.mParent;
        if (object != null && (object = object.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)object).dispatchOnFragmentPaused(fragment, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentPaused(this, fragment);
        }
    }

    void dispatchOnFragmentPreAttached(Fragment fragment, Context context, boolean bl) {
        Object object = this.mParent;
        if (object != null && (object = object.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)object).dispatchOnFragmentPreAttached(fragment, context, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentPreAttached(this, fragment, context);
        }
    }

    void dispatchOnFragmentPreCreated(Fragment fragment, Bundle bundle, boolean bl) {
        Object object = this.mParent;
        if (object != null && (object = object.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)object).dispatchOnFragmentPreCreated(fragment, bundle, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentPreCreated(this, fragment, bundle);
        }
    }

    void dispatchOnFragmentResumed(Fragment fragment, boolean bl) {
        Object object = this.mParent;
        if (object != null && (object = object.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)object).dispatchOnFragmentResumed(fragment, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentResumed(this, fragment);
        }
    }

    void dispatchOnFragmentSaveInstanceState(Fragment fragment, Bundle bundle, boolean bl) {
        FragmentManager fragmentManager;
        Fragment object2 = this.mParent;
        if (object2 != null && (fragmentManager = object2.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)fragmentManager).dispatchOnFragmentSaveInstanceState(fragment, bundle, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentSaveInstanceState(this, fragment, bundle);
        }
    }

    void dispatchOnFragmentStarted(Fragment fragment, boolean bl) {
        FragmentManager fragmentManager;
        Fragment object2 = this.mParent;
        if (object2 != null && (fragmentManager = object2.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)fragmentManager).dispatchOnFragmentStarted(fragment, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentStarted(this, fragment);
        }
    }

    void dispatchOnFragmentStopped(Fragment fragment, boolean bl) {
        FragmentManager fragmentManager;
        Fragment object2 = this.mParent;
        if (object2 != null && (fragmentManager = object2.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)fragmentManager).dispatchOnFragmentStopped(fragment, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentStopped(this, fragment);
        }
    }

    void dispatchOnFragmentViewCreated(Fragment fragment, View view, Bundle bundle, boolean bl) {
        Object object = this.mParent;
        if (object != null && (object = object.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)object).dispatchOnFragmentViewCreated(fragment, view, bundle, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentViewCreated(this, fragment, view, bundle);
        }
    }

    void dispatchOnFragmentViewDestroyed(Fragment fragment, boolean bl) {
        Object object = this.mParent;
        if (object != null && (object = object.getFragmentManager()) instanceof FragmentManagerImpl) {
            ((FragmentManagerImpl)object).dispatchOnFragmentViewDestroyed(fragment, true);
        }
        for (FragmentLifecycleCallbacksHolder fragmentLifecycleCallbacksHolder : this.mLifecycleCallbacks) {
            if (bl && !fragmentLifecycleCallbacksHolder.mRecursive) continue;
            fragmentLifecycleCallbacksHolder.mCallback.onFragmentViewDestroyed(this, fragment);
        }
    }

    public boolean dispatchOptionsItemSelected(MenuItem menuItem) {
        if (this.mCurState < 1) {
            return false;
        }
        for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
            Fragment fragment = this.mAdded.get(i2);
            if (fragment == null || !fragment.performOptionsItemSelected(menuItem)) continue;
            return true;
        }
        return false;
    }

    public void dispatchOptionsMenuClosed(Menu menu2) {
        if (this.mCurState < 1) {
            return;
        }
        for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
            Fragment fragment = this.mAdded.get(i2);
            if (fragment == null) continue;
            fragment.performOptionsMenuClosed(menu2);
        }
    }

    public void dispatchPause() {
        this.dispatchStateChange(3);
    }

    public void dispatchPictureInPictureModeChanged(boolean bl) {
        for (int i2 = this.mAdded.size() - 1; i2 >= 0; --i2) {
            Fragment fragment = this.mAdded.get(i2);
            if (fragment == null) continue;
            fragment.performPictureInPictureModeChanged(bl);
        }
    }

    public boolean dispatchPrepareOptionsMenu(Menu menu2) {
        int n2 = this.mCurState;
        if (n2 < 1) {
            return false;
        }
        boolean bl = false;
        for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
            Fragment fragment = this.mAdded.get(i2);
            boolean bl2 = bl;
            if (fragment != null) {
                bl2 = bl;
                if (fragment.performPrepareOptionsMenu(menu2)) {
                    bl2 = true;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    void dispatchPrimaryNavigationFragmentChanged() {
        this.updateOnBackPressedCallbackEnabled();
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    public void dispatchResume() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(4);
    }

    public void dispatchStart() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.dispatchStateChange(3);
    }

    public void dispatchStop() {
        this.mStopped = true;
        this.dispatchStateChange(2);
    }

    void doPendingDeferredStart() {
        if (this.mHavePendingDeferredStart) {
            this.mHavePendingDeferredStart = false;
            this.startPendingDeferredFragments();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dump(String string2, FileDescriptor object, PrintWriter printWriter, String[] stringArray) {
        block18: {
            int n2;
            CharSequence charSequence = new StringBuilder();
            charSequence.append(string2);
            charSequence.append("    ");
            charSequence = charSequence.toString();
            if (!this.mActive.isEmpty()) {
                printWriter.print(string2);
                printWriter.print("Active Fragments in ");
                printWriter.print(Integer.toHexString(System.identityHashCode(this)));
                printWriter.println(":");
                for (Fragment fragment : this.mActive.values()) {
                    printWriter.print(string2);
                    printWriter.println(fragment);
                    if (fragment == null) continue;
                    fragment.dump((String)charSequence, (FileDescriptor)object, printWriter, stringArray);
                }
            }
            int n3 = this.mAdded.size();
            int n4 = 0;
            if (n3 > 0) {
                printWriter.print(string2);
                printWriter.println("Added Fragments:");
                for (n2 = 0; n2 < n3; ++n2) {
                    object = this.mAdded.get(n2);
                    printWriter.print(string2);
                    printWriter.print("  #");
                    printWriter.print(n2);
                    printWriter.print(": ");
                    printWriter.println(object.toString());
                }
            }
            if ((object = this.mCreatedMenus) != null && (n3 = ((ArrayList)object).size()) > 0) {
                printWriter.print(string2);
                printWriter.println("Fragments Created Menus:");
                for (n2 = 0; n2 < n3; ++n2) {
                    object = this.mCreatedMenus.get(n2);
                    printWriter.print(string2);
                    printWriter.print("  #");
                    printWriter.print(n2);
                    printWriter.print(": ");
                    printWriter.println(object.toString());
                }
            }
            if ((object = this.mBackStack) != null && (n3 = ((ArrayList)object).size()) > 0) {
                printWriter.print(string2);
                printWriter.println("Back Stack:");
                for (n2 = 0; n2 < n3; ++n2) {
                    object = this.mBackStack.get(n2);
                    printWriter.print(string2);
                    printWriter.print("  #");
                    printWriter.print(n2);
                    printWriter.print(": ");
                    printWriter.println(object.toString());
                    object.dump((String)charSequence, printWriter);
                }
            }
            synchronized (this) {
                if (this.mBackStackIndices != null && (n3 = this.mBackStackIndices.size()) > 0) {
                    printWriter.print(string2);
                    printWriter.println("Back Stack Indices:");
                    for (n2 = 0; n2 < n3; ++n2) {
                        object = this.mBackStackIndices.get(n2);
                        printWriter.print(string2);
                        printWriter.print("  #");
                        printWriter.print(n2);
                        printWriter.print(": ");
                        printWriter.println(object);
                    }
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
                        printWriter.print(string2);
                        printWriter.print("mAvailBackStackIndices: ");
                        printWriter.println(Arrays.toString(this.mAvailBackStackIndices.toArray()));
                    }
                    // MONITOREXIT @DISABLED, blocks:[1, 3] lbl78 : MonitorExitStatement: MONITOREXIT : this
                    object = this.mPendingActions;
                    if (object == null || (n3 = ((ArrayList)object).size()) <= 0) break block18;
                    printWriter.print(string2);
                    printWriter.println("Pending Actions:");
                }
            }
            for (n2 = n4; n2 < n3; ++n2) {
                object = this.mPendingActions.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(object);
            }
        }
        printWriter.print(string2);
        printWriter.println("FragmentManager misc state:");
        printWriter.print(string2);
        printWriter.print("  mHost=");
        printWriter.println(this.mHost);
        printWriter.print(string2);
        printWriter.print("  mContainer=");
        printWriter.println(this.mContainer);
        if (this.mParent != null) {
            printWriter.print(string2);
            printWriter.print("  mParent=");
            printWriter.println(this.mParent);
        }
        printWriter.print(string2);
        printWriter.print("  mCurState=");
        printWriter.print(this.mCurState);
        printWriter.print(" mStateSaved=");
        printWriter.print(this.mStateSaved);
        printWriter.print(" mStopped=");
        printWriter.print(this.mStopped);
        printWriter.print(" mDestroyed=");
        printWriter.println(this.mDestroyed);
        if (!this.mNeedMenuInvalidate) return;
        printWriter.print(string2);
        printWriter.print("  mNeedMenuInvalidate=");
        printWriter.println(this.mNeedMenuInvalidate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueueAction(OpGenerator object, boolean bl) {
        if (!bl) {
            this.checkStateLoss();
        }
        synchronized (this) {
            if (!this.mDestroyed && this.mHost != null) {
                if (this.mPendingActions == null) {
                    ArrayList arrayList = new ArrayList();
                    this.mPendingActions = arrayList;
                }
                this.mPendingActions.add((OpGenerator)object);
                this.scheduleCommit();
                return;
            }
            if (bl) {
                return;
            }
            object = new IllegalStateException("Activity has been destroyed");
            throw object;
        }
    }

    void ensureInflatedFragmentView(Fragment fragment) {
        if (fragment.mFromLayout && !fragment.mPerformedCreateView) {
            fragment.performCreateView(fragment.performGetLayoutInflater(fragment.mSavedFragmentState), null, fragment.mSavedFragmentState);
            if (fragment.mView != null) {
                fragment.mInnerView = fragment.mView;
                fragment.mView.setSaveFromParentEnabled(false);
                if (fragment.mHidden) {
                    fragment.mView.setVisibility(8);
                }
                fragment.onViewCreated(fragment.mView, fragment.mSavedFragmentState);
                this.dispatchOnFragmentViewCreated(fragment, fragment.mView, fragment.mSavedFragmentState, false);
            } else {
                fragment.mInnerView = null;
            }
        }
    }

    public boolean execPendingActions() {
        this.ensureExecReady(true);
        boolean bl = false;
        while (this.generateOpsForPendingActions(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
                bl = true;
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.burpActive();
        return bl;
    }

    public void execSingleAction(OpGenerator opGenerator, boolean bl) {
        if (bl && (this.mHost == null || this.mDestroyed)) {
            return;
        }
        this.ensureExecReady(bl);
        if (opGenerator.generateOps(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.burpActive();
    }

    @Override
    public boolean executePendingTransactions() {
        boolean bl = this.execPendingActions();
        this.forcePostponedTransactions();
        return bl;
    }

    @Override
    public Fragment findFragmentById(int n2) {
        for (int i2 = this.mAdded.size() - 1; i2 >= 0; --i2) {
            Fragment fragment = this.mAdded.get(i2);
            if (fragment == null || fragment.mFragmentId != n2) continue;
            return fragment;
        }
        for (Fragment fragment : this.mActive.values()) {
            if (fragment == null || fragment.mFragmentId != n2) continue;
            return fragment;
        }
        return null;
    }

    @Override
    public Fragment findFragmentByTag(String string2) {
        if (string2 != null) {
            for (int i2 = this.mAdded.size() - 1; i2 >= 0; --i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null || !string2.equals(fragment.mTag)) continue;
                return fragment;
            }
        }
        if (string2 != null) {
            for (Fragment fragment : this.mActive.values()) {
                if (fragment == null || !string2.equals(fragment.mTag)) continue;
                return fragment;
            }
        }
        return null;
    }

    public Fragment findFragmentByWho(String string2) {
        for (Fragment fragment : this.mActive.values()) {
            if (fragment == null || (fragment = fragment.findFragmentByWho(string2)) == null) continue;
            return fragment;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void freeBackStackIndex(int n2) {
        synchronized (this) {
            Serializable serializable;
            this.mBackStackIndices.set(n2, null);
            if (this.mAvailBackStackIndices == null) {
                serializable = new ArrayList();
                this.mAvailBackStackIndices = serializable;
            }
            if (DEBUG) {
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("Freeing back stack index ");
                ((StringBuilder)serializable).append(n2);
                Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
            }
            this.mAvailBackStackIndices.add(n2);
            return;
        }
    }

    int getActiveFragmentCount() {
        return this.mActive.size();
    }

    List<Fragment> getActiveFragments() {
        return new ArrayList<Fragment>(this.mActive.values());
    }

    @Override
    public FragmentManager.BackStackEntry getBackStackEntryAt(int n2) {
        return (FragmentManager.BackStackEntry)this.mBackStack.get(n2);
    }

    @Override
    public int getBackStackEntryCount() {
        ArrayList<BackStackRecord> arrayList = this.mBackStack;
        int n2 = arrayList != null ? arrayList.size() : 0;
        return n2;
    }

    FragmentManagerViewModel getChildNonConfig(Fragment fragment) {
        return this.mNonConfig.getChildNonConfig(fragment);
    }

    @Override
    public Fragment getFragment(Bundle object, String string2) {
        String string3 = object.getString(string2);
        if (string3 == null) {
            return null;
        }
        Fragment fragment = this.mActive.get(string3);
        if (fragment == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Fragment no longer exists for key ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(": unique id ");
            ((StringBuilder)object).append(string3);
            this.throwException(new IllegalStateException(((StringBuilder)object).toString()));
        }
        return fragment;
    }

    @Override
    public FragmentFactory getFragmentFactory() {
        if (super.getFragmentFactory() == DEFAULT_FACTORY) {
            Fragment fragment = this.mParent;
            if (fragment != null) {
                return fragment.mFragmentManager.getFragmentFactory();
            }
            this.setFragmentFactory(new FragmentFactory(){

                public Fragment instantiate(ClassLoader classLoader, String string2) {
                    return FragmentManagerImpl.this.mHost.instantiate(FragmentManagerImpl.this.mHost.getContext(), string2, null);
                }
            });
        }
        return super.getFragmentFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Fragment> getFragments() {
        if (this.mAdded.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> arrayList = this.mAdded;
        synchronized (arrayList) {
            return (List)this.mAdded.clone();
        }
    }

    LayoutInflater.Factory2 getLayoutInflaterFactory() {
        return this;
    }

    @Override
    public Fragment getPrimaryNavigationFragment() {
        return this.mPrimaryNav;
    }

    ViewModelStore getViewModelStore(Fragment fragment) {
        return this.mNonConfig.getViewModelStore(fragment);
    }

    void handleOnBackPressed() {
        this.execPendingActions();
        if (this.mOnBackPressedCallback.isEnabled()) {
            this.popBackStackImmediate();
        } else {
            this.mOnBackPressedDispatcher.onBackPressed();
        }
    }

    public void hideFragment(Fragment fragment) {
        if (DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("hide: ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            fragment.mHiddenChanged = true ^ fragment.mHiddenChanged;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    boolean isPrimaryNavigation(Fragment fragment) {
        boolean bl = true;
        if (fragment == null) {
            return true;
        }
        FragmentManagerImpl fragmentManagerImpl = fragment.mFragmentManager;
        if (fragment != fragmentManagerImpl.getPrimaryNavigationFragment() || !this.isPrimaryNavigation(fragmentManagerImpl.mParent)) {
            bl = false;
        }
        return bl;
    }

    boolean isStateAtLeast(int n2) {
        boolean bl = this.mCurState >= n2;
        return bl;
    }

    @Override
    public boolean isStateSaved() {
        boolean bl = this.mStateSaved || this.mStopped;
        return bl;
    }

    AnimationOrAnimator loadAnimation(Fragment object, int n2, boolean bl, int n3) {
        block27: {
            boolean bl2;
            boolean bl3;
            int n4;
            block26: {
                n4 = object.getNextAnim();
                boolean bl4 = false;
                object.setNextAnim(0);
                if (object.mContainer != null && object.mContainer.getLayoutTransition() != null) {
                    return null;
                }
                Animation animation = object.onCreateAnimation(n2, bl, n4);
                if (animation != null) {
                    return new AnimationOrAnimator(animation);
                }
                if ((object = object.onCreateAnimator(n2, bl, n4)) != null) {
                    return new AnimationOrAnimator((Animator)object);
                }
                if (n4 == 0) break block27;
                bl3 = "anim".equals(this.mHost.getContext().getResources().getResourceTypeName(n4));
                bl2 = bl4;
                if (bl3) {
                    block25: {
                        object = AnimationUtils.loadAnimation((Context)this.mHost.getContext(), (int)n4);
                        if (object == null) break block25;
                        try {
                            object = new AnimationOrAnimator((Animation)object);
                            return object;
                        }
                        catch (RuntimeException runtimeException) {
                            bl2 = bl4;
                            break block26;
                        }
                        catch (Resources.NotFoundException notFoundException) {
                            throw notFoundException;
                        }
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                object = AnimatorInflater.loadAnimator((Context)this.mHost.getContext(), (int)n4);
                if (object == null) break block27;
                try {
                    object = new AnimationOrAnimator((Animator)object);
                    return object;
                }
                catch (RuntimeException runtimeException) {
                    if (!bl3) {
                        Animation animation = AnimationUtils.loadAnimation((Context)this.mHost.getContext(), (int)n4);
                        if (animation != null) {
                            return new AnimationOrAnimator(animation);
                        }
                        break block27;
                    }
                    throw runtimeException;
                }
            }
        }
        if (n2 == 0) {
            return null;
        }
        if ((n2 = FragmentManagerImpl.transitToStyleIndex(n2, bl)) < 0) {
            return null;
        }
        switch (n2) {
            default: {
                n2 = n3;
                if (n3 != 0) break;
                n2 = n3;
                if (!this.mHost.onHasWindowAnimations()) break;
                n2 = this.mHost.onGetWindowAnimations();
                break;
            }
            case 6: {
                return FragmentManagerImpl.makeFadeAnimation(1.0f, 0.0f);
            }
            case 5: {
                return FragmentManagerImpl.makeFadeAnimation(0.0f, 1.0f);
            }
            case 4: {
                return FragmentManagerImpl.makeOpenCloseAnimation(1.0f, 1.075f, 1.0f, 0.0f);
            }
            case 3: {
                return FragmentManagerImpl.makeOpenCloseAnimation(0.975f, 1.0f, 0.0f, 1.0f);
            }
            case 2: {
                return FragmentManagerImpl.makeOpenCloseAnimation(1.0f, 0.975f, 1.0f, 0.0f);
            }
            case 1: {
                return FragmentManagerImpl.makeOpenCloseAnimation(1.125f, 1.0f, 0.0f, 1.0f);
            }
        }
        if (n2 == 0) {
            // empty if block
        }
        return null;
    }

    void makeActive(Fragment fragment) {
        if (this.mActive.get(fragment.mWho) != null) {
            return;
        }
        this.mActive.put(fragment.mWho, fragment);
        if (fragment.mRetainInstanceChangedWhileDetached) {
            if (fragment.mRetainInstance) {
                this.addRetainedFragment(fragment);
            } else {
                this.removeRetainedFragment(fragment);
            }
            fragment.mRetainInstanceChangedWhileDetached = false;
        }
        if (DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Added fragment to active set ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
    }

    void makeInactive(Fragment fragment) {
        if (this.mActive.get(fragment.mWho) == null) {
            return;
        }
        if (DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Removed fragment from active set ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
        for (Fragment fragment2 : this.mActive.values()) {
            if (fragment2 == null || !fragment.mWho.equals(fragment2.mTargetWho)) continue;
            fragment2.mTarget = fragment;
            fragment2.mTargetWho = null;
        }
        this.mActive.put(fragment.mWho, null);
        this.removeRetainedFragment(fragment);
        if (fragment.mTargetWho != null) {
            fragment.mTarget = this.mActive.get(fragment.mTargetWho);
        }
        fragment.initState();
    }

    void moveFragmentToExpectedState(Fragment fragment) {
        int n2;
        if (fragment == null) {
            return;
        }
        if (!this.mActive.containsKey(fragment.mWho)) {
            if (DEBUG) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Ignoring moving ");
                stringBuilder.append(fragment);
                stringBuilder.append(" to state ");
                stringBuilder.append(this.mCurState);
                stringBuilder.append("since it is not added to ");
                stringBuilder.append(this);
                Log.v((String)TAG, (String)stringBuilder.toString());
            }
            return;
        }
        int n3 = n2 = this.mCurState;
        if (fragment.mRemoving) {
            n3 = fragment.isInBackStack() ? Math.min(n2, 1) : Math.min(n2, 0);
        }
        this.moveToState(fragment, n3, fragment.getNextTransition(), fragment.getNextTransitionStyle(), false);
        if (fragment.mView != null) {
            Object object = this.findFragmentUnder(fragment);
            if (object != null) {
                object = object.mView;
                ViewGroup viewGroup = fragment.mContainer;
                n2 = viewGroup.indexOfChild((View)object);
                n3 = viewGroup.indexOfChild(fragment.mView);
                if (n3 < n2) {
                    viewGroup.removeViewAt(n3);
                    viewGroup.addView(fragment.mView, n2);
                }
            }
            if (fragment.mIsNewlyAdded && fragment.mContainer != null) {
                if (fragment.mPostponedAlpha > 0.0f) {
                    fragment.mView.setAlpha(fragment.mPostponedAlpha);
                }
                fragment.mPostponedAlpha = 0.0f;
                fragment.mIsNewlyAdded = false;
                object = this.loadAnimation(fragment, fragment.getNextTransition(), true, fragment.getNextTransitionStyle());
                if (object != null) {
                    if (object.animation != null) {
                        fragment.mView.startAnimation(object.animation);
                    } else {
                        object.animator.setTarget((Object)fragment.mView);
                        object.animator.start();
                    }
                }
            }
        }
        if (fragment.mHiddenChanged) {
            this.completeShowHideFragment(fragment);
        }
    }

    void moveToState(int n2, boolean bl) {
        Fragment fragment2;
        if (this.mHost == null && n2 != 0) {
            throw new IllegalStateException("No activity");
        }
        if (!bl && n2 == this.mCurState) {
            return;
        }
        this.mCurState = n2;
        int n3 = this.mAdded.size();
        for (n2 = 0; n2 < n3; ++n2) {
            this.moveFragmentToExpectedState(this.mAdded.get(n2));
        }
        for (Fragment fragment2 : this.mActive.values()) {
            if (fragment2 == null || !fragment2.mRemoving && !fragment2.mDetached || fragment2.mIsNewlyAdded) continue;
            this.moveFragmentToExpectedState(fragment2);
        }
        this.startPendingDeferredFragments();
        if (this.mNeedMenuInvalidate && (fragment2 = this.mHost) != null && this.mCurState == 4) {
            fragment2.onSupportInvalidateOptionsMenu();
            this.mNeedMenuInvalidate = false;
        }
    }

    void moveToState(Fragment fragment) {
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void moveToState(Fragment fragment, int n2, int n3, int n4, boolean bl) {
        Object object;
        int n5;
        block72: {
            int n6;
            block80: {
                block81: {
                    boolean bl2;
                    boolean bl3;
                    block76: {
                        block77: {
                            block78: {
                                block79: {
                                    block67: {
                                        block71: {
                                            block70: {
                                                block73: {
                                                    block75: {
                                                        block74: {
                                                            FragmentHostCallback fragmentHostCallback;
                                                            block69: {
                                                                block68: {
                                                                    boolean bl4 = fragment.mAdded;
                                                                    bl3 = true;
                                                                    n6 = 1;
                                                                    bl2 = true;
                                                                    if (bl4 && !fragment.mDetached) {
                                                                        n5 = n2;
                                                                    } else {
                                                                        n5 = n2;
                                                                        if (n2 > 1) {
                                                                            n5 = 1;
                                                                        }
                                                                    }
                                                                    n2 = n5;
                                                                    if (fragment.mRemoving) {
                                                                        n2 = n5;
                                                                        if (n5 > fragment.mState) {
                                                                            n2 = fragment.mState == 0 && fragment.isInBackStack() ? 1 : fragment.mState;
                                                                        }
                                                                    }
                                                                    n5 = n2;
                                                                    if (fragment.mDeferStart) {
                                                                        n5 = n2;
                                                                        if (fragment.mState < 3) {
                                                                            n5 = n2;
                                                                            if (n2 > 2) {
                                                                                n5 = 2;
                                                                            }
                                                                        }
                                                                    }
                                                                    if (fragment.mState > (n2 = fragment.mMaxState == Lifecycle.State.CREATED ? Math.min(n5, 1) : Math.min(n5, fragment.mMaxState.ordinal()))) break block67;
                                                                    if (fragment.mFromLayout && !fragment.mInLayout) {
                                                                        return;
                                                                    }
                                                                    if (fragment.getAnimatingAway() != null || fragment.getAnimator() != null) {
                                                                        fragment.setAnimatingAway(null);
                                                                        fragment.setAnimator(null);
                                                                        this.moveToState(fragment, fragment.getStateAfterAnimating(), 0, 0, true);
                                                                    }
                                                                    if ((n5 = fragment.mState) == 0) break block68;
                                                                    n4 = n2;
                                                                    if (n5 == 1) break block69;
                                                                    n3 = n2;
                                                                    if (n5 == 2) break block70;
                                                                    n4 = n2;
                                                                    if (n5 == 3) break block71;
                                                                    n5 = n2;
                                                                    break block72;
                                                                }
                                                                n4 = n2;
                                                                if (n2 > 0) {
                                                                    if (DEBUG) {
                                                                        object = new StringBuilder();
                                                                        ((StringBuilder)object).append("moveto CREATED: ");
                                                                        ((StringBuilder)object).append(fragment);
                                                                        Log.v((String)TAG, (String)((StringBuilder)object).toString());
                                                                    }
                                                                    n4 = n2;
                                                                    if (fragment.mSavedFragmentState != null) {
                                                                        fragment.mSavedFragmentState.setClassLoader(this.mHost.getContext().getClassLoader());
                                                                        fragment.mSavedViewState = fragment.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                                                                        object = this.getFragment(fragment.mSavedFragmentState, TARGET_STATE_TAG);
                                                                        object = object != null ? ((Fragment)object).mWho : null;
                                                                        fragment.mTargetWho = object;
                                                                        if (fragment.mTargetWho != null) {
                                                                            fragment.mTargetRequestCode = fragment.mSavedFragmentState.getInt(TARGET_REQUEST_CODE_STATE_TAG, 0);
                                                                        }
                                                                        if (fragment.mSavedUserVisibleHint != null) {
                                                                            fragment.mUserVisibleHint = fragment.mSavedUserVisibleHint;
                                                                            fragment.mSavedUserVisibleHint = null;
                                                                        } else {
                                                                            fragment.mUserVisibleHint = fragment.mSavedFragmentState.getBoolean(USER_VISIBLE_HINT_TAG, true);
                                                                        }
                                                                        n4 = n2;
                                                                        if (!fragment.mUserVisibleHint) {
                                                                            fragment.mDeferStart = true;
                                                                            n4 = n2;
                                                                            if (n2 > 2) {
                                                                                n4 = 2;
                                                                            }
                                                                        }
                                                                    }
                                                                    fragment.mHost = fragmentHostCallback = this.mHost;
                                                                    object = this.mParent;
                                                                    fragment.mParentFragment = object;
                                                                    object = object != null ? ((Fragment)object).mChildFragmentManager : fragmentHostCallback.mFragmentManager;
                                                                    fragment.mFragmentManager = object;
                                                                    if (fragment.mTarget != null) {
                                                                        if (this.mActive.get(fragment.mTarget.mWho) != fragment.mTarget) {
                                                                            object = new StringBuilder();
                                                                            ((StringBuilder)object).append("Fragment ");
                                                                            ((StringBuilder)object).append(fragment);
                                                                            ((StringBuilder)object).append(" declared target fragment ");
                                                                            ((StringBuilder)object).append(fragment.mTarget);
                                                                            ((StringBuilder)object).append(" that does not belong to this FragmentManager!");
                                                                            throw new IllegalStateException(((StringBuilder)object).toString());
                                                                        }
                                                                        if (fragment.mTarget.mState < 1) {
                                                                            this.moveToState(fragment.mTarget, 1, 0, 0, true);
                                                                        }
                                                                        fragment.mTargetWho = fragment.mTarget.mWho;
                                                                        fragment.mTarget = null;
                                                                    }
                                                                    if (fragment.mTargetWho != null) {
                                                                        object = this.mActive.get(fragment.mTargetWho);
                                                                        if (object == null) {
                                                                            object = new StringBuilder();
                                                                            ((StringBuilder)object).append("Fragment ");
                                                                            ((StringBuilder)object).append(fragment);
                                                                            ((StringBuilder)object).append(" declared target fragment ");
                                                                            ((StringBuilder)object).append(fragment.mTargetWho);
                                                                            ((StringBuilder)object).append(" that does not belong to this FragmentManager!");
                                                                            throw new IllegalStateException(((StringBuilder)object).toString());
                                                                        }
                                                                        if (((Fragment)object).mState < 1) {
                                                                            this.moveToState((Fragment)object, 1, 0, 0, true);
                                                                        }
                                                                    }
                                                                    this.dispatchOnFragmentPreAttached(fragment, this.mHost.getContext(), false);
                                                                    fragment.performAttach();
                                                                    if (fragment.mParentFragment == null) {
                                                                        this.mHost.onAttachFragment(fragment);
                                                                    } else {
                                                                        fragment.mParentFragment.onAttachFragment(fragment);
                                                                    }
                                                                    this.dispatchOnFragmentAttached(fragment, this.mHost.getContext(), false);
                                                                    if (!fragment.mIsCreated) {
                                                                        this.dispatchOnFragmentPreCreated(fragment, fragment.mSavedFragmentState, false);
                                                                        fragment.performCreate(fragment.mSavedFragmentState);
                                                                        this.dispatchOnFragmentCreated(fragment, fragment.mSavedFragmentState, false);
                                                                    } else {
                                                                        fragment.restoreChildFragmentState(fragment.mSavedFragmentState);
                                                                        fragment.mState = 1;
                                                                    }
                                                                }
                                                            }
                                                            if (n4 > 0) {
                                                                this.ensureInflatedFragmentView(fragment);
                                                            }
                                                            n3 = n4;
                                                            if (n4 <= 1) break block70;
                                                            if (DEBUG) {
                                                                object = new StringBuilder();
                                                                ((StringBuilder)object).append("moveto ACTIVITY_CREATED: ");
                                                                ((StringBuilder)object).append(fragment);
                                                                Log.v((String)TAG, (String)((StringBuilder)object).toString());
                                                            }
                                                            if (fragment.mFromLayout) break block73;
                                                            if (fragment.mContainerId == 0) break block74;
                                                            if (fragment.mContainerId == -1) {
                                                                object = new StringBuilder();
                                                                ((StringBuilder)object).append("Cannot create fragment ");
                                                                ((StringBuilder)object).append(fragment);
                                                                ((StringBuilder)object).append(" for a container view with no id");
                                                                this.throwException(new IllegalArgumentException(((StringBuilder)object).toString()));
                                                            }
                                                            fragmentHostCallback = (ViewGroup)this.mContainer.onFindViewById(fragment.mContainerId);
                                                            object = fragmentHostCallback;
                                                            if (fragmentHostCallback != null) break block75;
                                                            object = fragmentHostCallback;
                                                            if (!fragment.mRestored) {
                                                                try {
                                                                    object = fragment.getResources().getResourceName(fragment.mContainerId);
                                                                }
                                                                catch (Resources.NotFoundException notFoundException) {
                                                                    object = "unknown";
                                                                }
                                                                StringBuilder stringBuilder = new StringBuilder();
                                                                stringBuilder.append("No view found for id 0x");
                                                                stringBuilder.append(Integer.toHexString(fragment.mContainerId));
                                                                stringBuilder.append(" (");
                                                                stringBuilder.append((String)object);
                                                                stringBuilder.append(") for fragment ");
                                                                stringBuilder.append(fragment);
                                                                this.throwException(new IllegalArgumentException(stringBuilder.toString()));
                                                                object = fragmentHostCallback;
                                                            }
                                                            break block75;
                                                        }
                                                        object = null;
                                                    }
                                                    fragment.mContainer = object;
                                                    fragment.performCreateView(fragment.performGetLayoutInflater(fragment.mSavedFragmentState), (ViewGroup)object, fragment.mSavedFragmentState);
                                                    if (fragment.mView != null) {
                                                        fragment.mInnerView = fragment.mView;
                                                        fragment.mView.setSaveFromParentEnabled(false);
                                                        if (object != null) {
                                                            object.addView(fragment.mView);
                                                        }
                                                        if (fragment.mHidden) {
                                                            fragment.mView.setVisibility(8);
                                                        }
                                                        fragment.onViewCreated(fragment.mView, fragment.mSavedFragmentState);
                                                        this.dispatchOnFragmentViewCreated(fragment, fragment.mView, fragment.mSavedFragmentState, false);
                                                        bl = fragment.mView.getVisibility() == 0 && fragment.mContainer != null ? bl2 : false;
                                                        fragment.mIsNewlyAdded = bl;
                                                    } else {
                                                        fragment.mInnerView = null;
                                                    }
                                                }
                                                fragment.performActivityCreated(fragment.mSavedFragmentState);
                                                this.dispatchOnFragmentActivityCreated(fragment, fragment.mSavedFragmentState, false);
                                                if (fragment.mView != null) {
                                                    fragment.restoreViewState(fragment.mSavedFragmentState);
                                                }
                                                fragment.mSavedFragmentState = null;
                                                n3 = n4;
                                            }
                                            n4 = n3;
                                            if (n3 > 2) {
                                                if (DEBUG) {
                                                    object = new StringBuilder();
                                                    ((StringBuilder)object).append("moveto STARTED: ");
                                                    ((StringBuilder)object).append(fragment);
                                                    Log.v((String)TAG, (String)((StringBuilder)object).toString());
                                                }
                                                fragment.performStart();
                                                this.dispatchOnFragmentStarted(fragment, false);
                                                n4 = n3;
                                            }
                                        }
                                        n5 = n4;
                                        if (n4 > 3) {
                                            if (DEBUG) {
                                                object = new StringBuilder();
                                                ((StringBuilder)object).append("moveto RESUMED: ");
                                                ((StringBuilder)object).append(fragment);
                                                Log.v((String)TAG, (String)((StringBuilder)object).toString());
                                            }
                                            fragment.performResume();
                                            this.dispatchOnFragmentResumed(fragment, false);
                                            fragment.mSavedFragmentState = null;
                                            fragment.mSavedViewState = null;
                                            n5 = n4;
                                        }
                                        break block72;
                                    }
                                    n5 = n2;
                                    if (fragment.mState <= n2) break block72;
                                    n5 = fragment.mState;
                                    if (n5 == 1) break block76;
                                    if (n5 == 2) break block77;
                                    if (n5 == 3) break block78;
                                    if (n5 == 4) break block79;
                                    n5 = n2;
                                    break block72;
                                }
                                if (n2 < 4) {
                                    if (DEBUG) {
                                        object = new StringBuilder();
                                        ((StringBuilder)object).append("movefrom RESUMED: ");
                                        ((StringBuilder)object).append(fragment);
                                        Log.v((String)TAG, (String)((StringBuilder)object).toString());
                                    }
                                    fragment.performPause();
                                    this.dispatchOnFragmentPaused(fragment, false);
                                }
                            }
                            if (n2 < 3) {
                                if (DEBUG) {
                                    object = new StringBuilder();
                                    ((StringBuilder)object).append("movefrom STARTED: ");
                                    ((StringBuilder)object).append(fragment);
                                    Log.v((String)TAG, (String)((StringBuilder)object).toString());
                                }
                                fragment.performStop();
                                this.dispatchOnFragmentStopped(fragment, false);
                            }
                        }
                        if (n2 < 2) {
                            if (DEBUG) {
                                object = new StringBuilder();
                                ((StringBuilder)object).append("movefrom ACTIVITY_CREATED: ");
                                ((StringBuilder)object).append(fragment);
                                Log.v((String)TAG, (String)((StringBuilder)object).toString());
                            }
                            if (fragment.mView != null && this.mHost.onShouldSaveFragmentState(fragment) && fragment.mSavedViewState == null) {
                                this.saveFragmentViewState(fragment);
                            }
                            fragment.performDestroyView();
                            this.dispatchOnFragmentViewDestroyed(fragment, false);
                            if (fragment.mView != null && fragment.mContainer != null) {
                                fragment.mContainer.endViewTransition(fragment.mView);
                                fragment.mView.clearAnimation();
                                if (fragment.getParentFragment() == null || !fragment.getParentFragment().mRemoving) {
                                    object = this.mCurState > 0 && !this.mDestroyed && fragment.mView.getVisibility() == 0 && fragment.mPostponedAlpha >= 0.0f ? this.loadAnimation(fragment, n3, false, n4) : null;
                                    fragment.mPostponedAlpha = 0.0f;
                                    if (object != null) {
                                        this.animateRemoveFragment(fragment, (AnimationOrAnimator)object, n2);
                                    }
                                    fragment.mContainer.removeView(fragment.mView);
                                }
                            }
                            fragment.mContainer = null;
                            fragment.mView = null;
                            fragment.mViewLifecycleOwner = null;
                            fragment.mViewLifecycleOwnerLiveData.setValue(null);
                            fragment.mInnerView = null;
                            fragment.mInLayout = false;
                        }
                    }
                    n5 = n2;
                    if (n2 >= 1) break block72;
                    if (this.mDestroyed) {
                        if (fragment.getAnimatingAway() != null) {
                            object = fragment.getAnimatingAway();
                            fragment.setAnimatingAway(null);
                            object.clearAnimation();
                        } else if (fragment.getAnimator() != null) {
                            object = fragment.getAnimator();
                            fragment.setAnimator(null);
                            object.cancel();
                        }
                    }
                    if (fragment.getAnimatingAway() != null || fragment.getAnimator() != null) break block80;
                    if (DEBUG) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("movefrom CREATED: ");
                        ((StringBuilder)object).append(fragment);
                        Log.v((String)TAG, (String)((StringBuilder)object).toString());
                    }
                    if ((n3 = fragment.mRemoving && !fragment.isInBackStack() ? 1 : 0) == 0 && !this.mNonConfig.shouldDestroy(fragment)) {
                        fragment.mState = 0;
                    } else {
                        object = this.mHost;
                        if (object instanceof ViewModelStoreOwner) {
                            bl2 = this.mNonConfig.isCleared();
                        } else {
                            bl2 = bl3;
                            if (object.getContext() instanceof Activity) {
                                bl2 = true ^ ((Activity)this.mHost.getContext()).isChangingConfigurations();
                            }
                        }
                        if (n3 != 0 || bl2) {
                            this.mNonConfig.clearNonConfigState(fragment);
                        }
                        fragment.performDestroy();
                        this.dispatchOnFragmentDestroyed(fragment, false);
                    }
                    fragment.performDetach();
                    this.dispatchOnFragmentDetached(fragment, false);
                    n5 = n2;
                    if (bl) break block72;
                    if (n3 != 0 || this.mNonConfig.shouldDestroy(fragment)) break block81;
                    fragment.mHost = null;
                    fragment.mParentFragment = null;
                    fragment.mFragmentManager = null;
                    n5 = n2;
                    if (fragment.mTargetWho == null) break block72;
                    object = this.mActive.get(fragment.mTargetWho);
                    n5 = n2;
                    if (object != null) {
                        n5 = n2;
                        if (object.getRetainInstance()) {
                            fragment.mTarget = object;
                            n5 = n2;
                        }
                    }
                    break block72;
                }
                this.makeInactive(fragment);
                n5 = n2;
                break block72;
            }
            fragment.setStateAfterAnimating(n2);
            n5 = n6;
        }
        if (fragment.mState != n5) {
            object = new StringBuilder();
            ((StringBuilder)object).append("moveToState: Fragment state for ");
            ((StringBuilder)object).append(fragment);
            ((StringBuilder)object).append(" not updated inline; expected state ");
            ((StringBuilder)object).append(n5);
            ((StringBuilder)object).append(" found ");
            ((StringBuilder)object).append(fragment.mState);
            Log.w((String)TAG, (String)((StringBuilder)object).toString());
            fragment.mState = n5;
        }
    }

    public void noteStateNotSaved() {
        this.mStateSaved = false;
        this.mStopped = false;
        int n2 = this.mAdded.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fragment fragment = this.mAdded.get(i2);
            if (fragment == null) continue;
            fragment.noteStateNotSaved();
        }
    }

    public View onCreateView(View object, String charSequence, Context context, AttributeSet attributeSet) {
        block18: {
            int n2;
            String string2;
            int n3;
            String string3;
            block21: {
                block20: {
                    block19: {
                        boolean bl = "fragment".equals(charSequence);
                        charSequence = null;
                        if (!bl) {
                            return null;
                        }
                        string3 = attributeSet.getAttributeValue(null, "class");
                        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, FragmentTag.Fragment);
                        n3 = 0;
                        string2 = string3;
                        if (string3 == null) {
                            string2 = typedArray.getString(0);
                        }
                        n2 = typedArray.getResourceId(1, -1);
                        string3 = typedArray.getString(2);
                        typedArray.recycle();
                        if (string2 == null || !FragmentFactory.isFragmentClass((ClassLoader)context.getClassLoader(), (String)string2)) break block18;
                        if (object != null) {
                            n3 = object.getId();
                        }
                        if (n3 == -1 && n2 == -1 && string3 == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append(attributeSet.getPositionDescription());
                            ((StringBuilder)object).append(": Must specify unique android:id, android:tag, or have a parent with an id for ");
                            ((StringBuilder)object).append(string2);
                            throw new IllegalArgumentException(((StringBuilder)object).toString());
                        }
                        object = charSequence;
                        if (n2 != -1) {
                            object = this.findFragmentById(n2);
                        }
                        charSequence = object;
                        if (object == null) {
                            charSequence = object;
                            if (string3 != null) {
                                charSequence = this.findFragmentByTag(string3);
                            }
                        }
                        object = charSequence;
                        if (charSequence == null) {
                            object = charSequence;
                            if (n3 != -1) {
                                object = this.findFragmentById(n3);
                            }
                        }
                        if (DEBUG) {
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("onCreateView: id=0x");
                            ((StringBuilder)charSequence).append(Integer.toHexString(n2));
                            ((StringBuilder)charSequence).append(" fname=");
                            ((StringBuilder)charSequence).append(string2);
                            ((StringBuilder)charSequence).append(" existing=");
                            ((StringBuilder)charSequence).append(object);
                            Log.v((String)TAG, (String)((StringBuilder)charSequence).toString());
                        }
                        if (object != null) break block19;
                        object = this.getFragmentFactory().instantiate(context.getClassLoader(), string2);
                        ((Fragment)object).mFromLayout = true;
                        int n4 = n2 != 0 ? n2 : n3;
                        ((Fragment)object).mFragmentId = n4;
                        ((Fragment)object).mContainerId = n3;
                        ((Fragment)object).mTag = string3;
                        ((Fragment)object).mInLayout = true;
                        ((Fragment)object).mFragmentManager = this;
                        charSequence = this.mHost;
                        ((Fragment)object).mHost = charSequence;
                        object.onInflate(charSequence.getContext(), attributeSet, ((Fragment)object).mSavedFragmentState);
                        this.addFragment((Fragment)object, true);
                        break block20;
                    }
                    if (((Fragment)object).mInLayout) break block21;
                    ((Fragment)object).mInLayout = true;
                    charSequence = this.mHost;
                    ((Fragment)object).mHost = charSequence;
                    object.onInflate(charSequence.getContext(), attributeSet, ((Fragment)object).mSavedFragmentState);
                }
                if (this.mCurState < 1 && ((Fragment)object).mFromLayout) {
                    this.moveToState((Fragment)object, 1, 0, 0, false);
                } else {
                    this.moveToState((Fragment)object);
                }
                if (((Fragment)object).mView != null) {
                    if (n2 != 0) {
                        ((Fragment)object).mView.setId(n2);
                    }
                    if (((Fragment)object).mView.getTag() == null) {
                        ((Fragment)object).mView.setTag((Object)string3);
                    }
                    return ((Fragment)object).mView;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Fragment ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" did not create a view.");
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(attributeSet.getPositionDescription());
            ((StringBuilder)object).append(": Duplicate id 0x");
            ((StringBuilder)object).append(Integer.toHexString(n2));
            ((StringBuilder)object).append(", tag ");
            ((StringBuilder)object).append(string3);
            ((StringBuilder)object).append(", or parent id 0x");
            ((StringBuilder)object).append(Integer.toHexString(n3));
            ((StringBuilder)object).append(" with another fragment for ");
            ((StringBuilder)object).append(string2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        return null;
    }

    public View onCreateView(String string2, Context context, AttributeSet attributeSet) {
        return this.onCreateView(null, string2, context, attributeSet);
    }

    public void performPendingDeferredStart(Fragment fragment) {
        if (fragment.mDeferStart) {
            if (this.mExecutingActions) {
                this.mHavePendingDeferredStart = true;
                return;
            }
            fragment.mDeferStart = false;
            this.moveToState(fragment, this.mCurState, 0, 0, false);
        }
    }

    @Override
    public void popBackStack() {
        this.enqueueAction(new PopBackStackState(null, -1, 0), false);
    }

    @Override
    public void popBackStack(int n2, int n3) {
        if (n2 >= 0) {
            this.enqueueAction(new PopBackStackState(null, n2, n3), false);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bad id: ");
        stringBuilder.append(n2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public void popBackStack(String string2, int n2) {
        this.enqueueAction(new PopBackStackState(string2, -1, n2), false);
    }

    @Override
    public boolean popBackStackImmediate() {
        this.checkStateLoss();
        return this.popBackStackImmediate(null, -1, 0);
    }

    @Override
    public boolean popBackStackImmediate(int n2, int n3) {
        this.checkStateLoss();
        this.execPendingActions();
        if (n2 >= 0) {
            return this.popBackStackImmediate(null, n2, n3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bad id: ");
        stringBuilder.append(n2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public boolean popBackStackImmediate(String string2, int n2) {
        this.checkStateLoss();
        return this.popBackStackImmediate(string2, -1, n2);
    }

    boolean popBackStackState(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2, String string2, int n2, int n3) {
        BackStackRecord backStackRecord = this.mBackStack;
        if (backStackRecord == null) {
            return false;
        }
        if (string2 == null && n2 < 0 && (n3 & 1) == 0) {
            n2 = backStackRecord.size() - 1;
            if (n2 < 0) {
                return false;
            }
            arrayList.add(this.mBackStack.remove(n2));
            arrayList2.add(true);
        } else {
            int n4;
            if (string2 == null && n2 < 0) {
                n4 = -1;
            } else {
                int n5;
                for (n5 = this.mBackStack.size() - 1; n5 >= 0; --n5) {
                    backStackRecord = this.mBackStack.get(n5);
                    if (string2 != null && string2.equals(backStackRecord.getName()) || n2 >= 0 && n2 == backStackRecord.mIndex) break;
                }
                if (n5 < 0) {
                    return false;
                }
                n4 = n5;
                if ((n3 & 1) != 0) {
                    while (true) {
                        n4 = n3 = n5 - 1;
                        if (n3 < 0) break;
                        backStackRecord = this.mBackStack.get(n3);
                        if (string2 != null) {
                            n5 = n3;
                            if (string2.equals(backStackRecord.getName())) continue;
                        }
                        n4 = n3;
                        if (n2 < 0) break;
                        n4 = n3;
                        if (n2 != backStackRecord.mIndex) break;
                        n5 = n3;
                    }
                }
            }
            if (n4 == this.mBackStack.size() - 1) {
                return false;
            }
            for (n2 = this.mBackStack.size() - 1; n2 > n4; --n2) {
                arrayList.add(this.mBackStack.remove(n2));
                arrayList2.add(true);
            }
        }
        return true;
    }

    @Override
    public void putFragment(Bundle bundle, String string2, Fragment fragment) {
        if (fragment.mFragmentManager != this) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Fragment ");
            stringBuilder.append(fragment);
            stringBuilder.append(" is not currently in the FragmentManager");
            this.throwException(new IllegalStateException(stringBuilder.toString()));
        }
        bundle.putString(string2, fragment.mWho);
    }

    @Override
    public void registerFragmentLifecycleCallbacks(FragmentManager.FragmentLifecycleCallbacks fragmentLifecycleCallbacks, boolean bl) {
        this.mLifecycleCallbacks.add(new FragmentLifecycleCallbacksHolder(fragmentLifecycleCallbacks, bl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeFragment(Fragment fragment) {
        Serializable serializable;
        if (DEBUG) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("remove: ");
            ((StringBuilder)serializable).append(fragment);
            ((StringBuilder)serializable).append(" nesting=");
            ((StringBuilder)serializable).append(fragment.mBackStackNesting);
            Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
        }
        boolean bl = fragment.isInBackStack();
        if (fragment.mDetached) {
            if (!(bl ^ true)) return;
        }
        serializable = this.mAdded;
        // MONITORENTER : serializable
        this.mAdded.remove(fragment);
        // MONITOREXIT : serializable
        if (this.isMenuAvailable(fragment)) {
            this.mNeedMenuInvalidate = true;
        }
        fragment.mAdded = false;
        fragment.mRemoving = true;
    }

    @Override
    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        ArrayList<FragmentManager.OnBackStackChangedListener> arrayList = this.mBackStackChangeListeners;
        if (arrayList != null) {
            arrayList.remove(onBackStackChangedListener);
        }
    }

    void removeRetainedFragment(Fragment fragment) {
        if (this.isStateSaved()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)"Ignoring removeRetainedFragment as the state is already saved");
            }
            return;
        }
        if (this.mNonConfig.removeRetainedFragment(fragment) && DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Updating retained Fragments: Removed ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
    }

    void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i2 = 0; i2 < this.mBackStackChangeListeners.size(); ++i2) {
                this.mBackStackChangeListeners.get(i2).onBackStackChanged();
            }
        }
    }

    void restoreAllState(Parcelable parcelable, FragmentManagerNonConfig fragmentManagerNonConfig) {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You must use restoreSaveState when your FragmentHostCallback implements ViewModelStoreOwner"));
        }
        this.mNonConfig.restoreFromSnapshot(fragmentManagerNonConfig);
        this.restoreSaveState(parcelable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void restoreSaveState(Parcelable object4) {
        Object object22;
        Object object32;
        if (object4 == null) {
            return;
        }
        FragmentManagerState fragmentManagerState = (FragmentManagerState)object4;
        if (fragmentManagerState.mActive == null) {
            return;
        }
        for (Object object32 : this.mNonConfig.getRetainedFragments()) {
            block21: {
                if (DEBUG) {
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append("restoreSaveState: re-attaching retained ");
                    ((StringBuilder)object4).append(object32);
                    Log.v((String)TAG, (String)((StringBuilder)object4).toString());
                }
                for (Object object4 : fragmentManagerState.mActive) {
                    if (!((FragmentState)object4).mWho.equals(object32.mWho)) continue;
                    break block21;
                }
                object4 = null;
            }
            if (object4 == null) {
                if (DEBUG) {
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append("Discarding retained Fragment ");
                    ((StringBuilder)object4).append(object32);
                    ((StringBuilder)object4).append(" that was not found in the set of active Fragments ");
                    ((StringBuilder)object4).append(fragmentManagerState.mActive);
                    Log.v((String)TAG, (String)((StringBuilder)object4).toString());
                }
                this.moveToState((Fragment)object32, 1, 0, 0, false);
                object32.mRemoving = true;
                this.moveToState((Fragment)object32, 0, 0, 0, false);
                continue;
            }
            ((FragmentState)object4).mInstance = object32;
            object32.mSavedViewState = null;
            object32.mBackStackNesting = 0;
            object32.mInLayout = false;
            object32.mAdded = false;
            object22 = object32.mTarget != null ? object32.mTarget.mWho : null;
            object32.mTargetWho = object22;
            object32.mTarget = null;
            if (((FragmentState)object4).mSavedFragmentState == null) continue;
            ((FragmentState)object4).mSavedFragmentState.setClassLoader(this.mHost.getContext().getClassLoader());
            object32.mSavedViewState = ((FragmentState)object4).mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
            object32.mSavedFragmentState = ((FragmentState)object4).mSavedFragmentState;
        }
        this.mActive.clear();
        for (Object object22 : fragmentManagerState.mActive) {
            if (object22 == null) continue;
            object32 = ((FragmentState)object22).instantiate(this.mHost.getContext().getClassLoader(), this.getFragmentFactory());
            object32.mFragmentManager = this;
            if (DEBUG) {
                object4 = new StringBuilder();
                ((StringBuilder)object4).append("restoreSaveState: active (");
                ((StringBuilder)object4).append(object32.mWho);
                ((StringBuilder)object4).append("): ");
                ((StringBuilder)object4).append(object32);
                Log.v((String)TAG, (String)((StringBuilder)object4).toString());
            }
            this.mActive.put(object32.mWho, (Fragment)object32);
            ((FragmentState)object22).mInstance = null;
        }
        this.mAdded.clear();
        if (fragmentManagerState.mAdded != null) {
            object22 = fragmentManagerState.mAdded.iterator();
            while (object22.hasNext()) {
                Object object5;
                object32 = (String)object22.next();
                object4 = this.mActive.get(object32);
                if (object4 == null) {
                    object5 = new StringBuilder();
                    ((StringBuilder)object5).append("No instantiated fragment for (");
                    ((StringBuilder)object5).append((String)object32);
                    ((StringBuilder)object5).append(")");
                    this.throwException(new IllegalStateException(((StringBuilder)object5).toString()));
                }
                ((Fragment)object4).mAdded = true;
                if (DEBUG) {
                    object5 = new StringBuilder();
                    ((StringBuilder)object5).append("restoreSaveState: added (");
                    ((StringBuilder)object5).append((String)object32);
                    ((StringBuilder)object5).append("): ");
                    ((StringBuilder)object5).append(object4);
                    Log.v((String)TAG, (String)((StringBuilder)object5).toString());
                }
                if (this.mAdded.contains(object4)) {
                    object22 = new StringBuilder();
                    ((StringBuilder)object22).append("Already added ");
                    ((StringBuilder)object22).append(object4);
                    throw new IllegalStateException(((StringBuilder)object22).toString());
                }
                object32 = this.mAdded;
                synchronized (object32) {
                    this.mAdded.add((Fragment)object4);
                }
            }
        }
        if (fragmentManagerState.mBackStack != null) {
            this.mBackStack = new ArrayList(fragmentManagerState.mBackStack.length);
            for (int i2 = 0; i2 < fragmentManagerState.mBackStack.length; ++i2) {
                object4 = fragmentManagerState.mBackStack[i2].instantiate(this);
                if (DEBUG) {
                    object22 = new StringBuilder();
                    ((StringBuilder)object22).append("restoreAllState: back stack #");
                    ((StringBuilder)object22).append(i2);
                    ((StringBuilder)object22).append(" (index ");
                    ((StringBuilder)object22).append(((BackStackRecord)object4).mIndex);
                    ((StringBuilder)object22).append("): ");
                    ((StringBuilder)object22).append(object4);
                    Log.v((String)TAG, (String)((StringBuilder)object22).toString());
                    object22 = new PrintWriter((Writer)new LogWriter(TAG));
                    object4.dump("  ", (PrintWriter)object22, false);
                    ((PrintWriter)object22).close();
                }
                this.mBackStack.add((BackStackRecord)object4);
                if (((BackStackRecord)object4).mIndex < 0) continue;
                this.setBackStackIndex(((BackStackRecord)object4).mIndex, (BackStackRecord)object4);
            }
        } else {
            this.mBackStack = null;
        }
        if (fragmentManagerState.mPrimaryNavActiveWho != null) {
            this.mPrimaryNav = this.mActive.get(fragmentManagerState.mPrimaryNavActiveWho);
            this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
        }
        this.mNextFragmentIndex = fragmentManagerState.mNextFragmentIndex;
    }

    @Deprecated
    FragmentManagerNonConfig retainNonConfig() {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You cannot use retainNonConfig when your FragmentHostCallback implements ViewModelStoreOwner."));
        }
        return this.mNonConfig.getSnapshot();
    }

    Parcelable saveAllState() {
        StringBuilder stringBuilder;
        Iterator<Fragment> iterator2;
        Object object;
        this.forcePostponedTransactions();
        this.endAnimatingAwayFragments();
        this.execPendingActions();
        this.mStateSaved = true;
        boolean bl = this.mActive.isEmpty();
        BackStackState[] backStackStateArray = null;
        if (bl) {
            return null;
        }
        ArrayList<Iterator<Fragment>> arrayList = new ArrayList<Iterator<Fragment>>(this.mActive.size());
        Object object2 = this.mActive.values().iterator();
        int n2 = 0;
        int n3 = 0;
        while (object2.hasNext()) {
            object = object2.next();
            if (object == null) continue;
            if (((Fragment)object).mFragmentManager != this) {
                iterator2 = new StringBuilder();
                ((StringBuilder)((Object)iterator2)).append("Failure saving state: active ");
                ((StringBuilder)((Object)iterator2)).append(object);
                ((StringBuilder)((Object)iterator2)).append(" was removed from the FragmentManager");
                this.throwException(new IllegalStateException(((StringBuilder)((Object)iterator2)).toString()));
            }
            iterator2 = new FragmentState((Fragment)object);
            arrayList.add(iterator2);
            if (((Fragment)object).mState > 0 && ((FragmentState)((Object)iterator2)).mSavedFragmentState == null) {
                ((FragmentState)((Object)iterator2)).mSavedFragmentState = this.saveFragmentBasicState((Fragment)object);
                if (((Fragment)object).mTargetWho != null) {
                    Fragment fragment = this.mActive.get(((Fragment)object).mTargetWho);
                    if (fragment == null) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("Failure saving state: ");
                        stringBuilder.append(object);
                        stringBuilder.append(" has target not in fragment manager: ");
                        stringBuilder.append(((Fragment)object).mTargetWho);
                        this.throwException(new IllegalStateException(stringBuilder.toString()));
                    }
                    if (((FragmentState)((Object)iterator2)).mSavedFragmentState == null) {
                        ((FragmentState)((Object)iterator2)).mSavedFragmentState = new Bundle();
                    }
                    this.putFragment(((FragmentState)((Object)iterator2)).mSavedFragmentState, TARGET_STATE_TAG, fragment);
                    if (((Fragment)object).mTargetRequestCode != 0) {
                        ((FragmentState)((Object)iterator2)).mSavedFragmentState.putInt(TARGET_REQUEST_CODE_STATE_TAG, ((Fragment)object).mTargetRequestCode);
                    }
                }
            } else {
                ((FragmentState)((Object)iterator2)).mSavedFragmentState = ((Fragment)object).mSavedFragmentState;
            }
            if (DEBUG) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("Saved state of ");
                stringBuilder.append(object);
                stringBuilder.append(": ");
                stringBuilder.append(((FragmentState)((Object)iterator2)).mSavedFragmentState);
                Log.v((String)TAG, (String)stringBuilder.toString());
            }
            n3 = 1;
        }
        if (n3 == 0) {
            if (DEBUG) {
                Log.v((String)TAG, (String)"saveAllState: no fragments!");
            }
            return null;
        }
        n3 = this.mAdded.size();
        if (n3 > 0) {
            object = new ArrayList(n3);
            iterator2 = this.mAdded.iterator();
            while (true) {
                object2 = object;
                if (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    ((ArrayList)object).add(((Fragment)object2).mWho);
                    if (((Fragment)object2).mFragmentManager != this) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("Failure saving state: active ");
                        stringBuilder.append(object2);
                        stringBuilder.append(" was removed from the FragmentManager");
                        this.throwException(new IllegalStateException(stringBuilder.toString()));
                    }
                    if (!DEBUG) continue;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("saveAllState: adding fragment (");
                    stringBuilder.append(((Fragment)object2).mWho);
                    stringBuilder.append("): ");
                    stringBuilder.append(object2);
                    Log.v((String)TAG, (String)stringBuilder.toString());
                    continue;
                }
                break;
            }
        } else {
            object2 = null;
        }
        iterator2 = this.mBackStack;
        object = backStackStateArray;
        if (iterator2 != null) {
            int n4 = ((ArrayList)((Object)iterator2)).size();
            object = backStackStateArray;
            if (n4 > 0) {
                backStackStateArray = new BackStackState[n4];
                n3 = n2;
                while (true) {
                    object = backStackStateArray;
                    if (n3 >= n4) break;
                    backStackStateArray[n3] = new BackStackState(this.mBackStack.get(n3));
                    if (DEBUG) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("saveAllState: adding back stack #");
                        ((StringBuilder)object).append(n3);
                        ((StringBuilder)object).append(": ");
                        ((StringBuilder)object).append(this.mBackStack.get(n3));
                        Log.v((String)TAG, (String)((StringBuilder)object).toString());
                    }
                    ++n3;
                }
            }
        }
        backStackStateArray = new FragmentManagerState();
        backStackStateArray.mActive = arrayList;
        backStackStateArray.mAdded = object2;
        backStackStateArray.mBackStack = object;
        object2 = this.mPrimaryNav;
        if (object2 != null) {
            backStackStateArray.mPrimaryNavActiveWho = ((Fragment)object2).mWho;
        }
        backStackStateArray.mNextFragmentIndex = this.mNextFragmentIndex;
        return backStackStateArray;
    }

    Bundle saveFragmentBasicState(Fragment fragment) {
        Bundle bundle;
        if (this.mStateBundle == null) {
            this.mStateBundle = new Bundle();
        }
        fragment.performSaveInstanceState(this.mStateBundle);
        this.dispatchOnFragmentSaveInstanceState(fragment, this.mStateBundle, false);
        if (!this.mStateBundle.isEmpty()) {
            bundle = this.mStateBundle;
            this.mStateBundle = null;
        } else {
            bundle = null;
        }
        if (fragment.mView != null) {
            this.saveFragmentViewState(fragment);
        }
        Bundle bundle2 = bundle;
        if (fragment.mSavedViewState != null) {
            bundle2 = bundle;
            if (bundle == null) {
                bundle2 = new Bundle();
            }
            bundle2.putSparseParcelableArray(VIEW_STATE_TAG, fragment.mSavedViewState);
        }
        bundle = bundle2;
        if (!fragment.mUserVisibleHint) {
            bundle = bundle2;
            if (bundle2 == null) {
                bundle = new Bundle();
            }
            bundle.putBoolean(USER_VISIBLE_HINT_TAG, fragment.mUserVisibleHint);
        }
        return bundle;
    }

    @Override
    public Fragment.SavedState saveFragmentInstanceState(Fragment fragment) {
        StringBuilder stringBuilder;
        if (fragment.mFragmentManager != this) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("Fragment ");
            stringBuilder.append(fragment);
            stringBuilder.append(" is not currently in the FragmentManager");
            this.throwException(new IllegalStateException(stringBuilder.toString()));
        }
        int n2 = fragment.mState;
        Object var4_4 = null;
        stringBuilder = var4_4;
        if (n2 > 0) {
            fragment = this.saveFragmentBasicState(fragment);
            stringBuilder = var4_4;
            if (fragment != null) {
                stringBuilder = new Fragment.SavedState((Bundle)fragment);
            }
        }
        return stringBuilder;
    }

    void saveFragmentViewState(Fragment fragment) {
        if (fragment.mInnerView == null) {
            return;
        }
        SparseArray<Parcelable> sparseArray = this.mStateArray;
        if (sparseArray == null) {
            this.mStateArray = new SparseArray();
        } else {
            sparseArray.clear();
        }
        fragment.mInnerView.saveHierarchyState(this.mStateArray);
        if (this.mStateArray.size() > 0) {
            fragment.mSavedViewState = this.mStateArray;
            this.mStateArray = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void scheduleCommit() {
        synchronized (this) {
            ArrayList<StartEnterTransitionListener> arrayList = this.mPostponedTransactions;
            boolean bl = false;
            boolean bl2 = arrayList != null && !this.mPostponedTransactions.isEmpty();
            boolean bl3 = bl;
            if (this.mPendingActions != null) {
                bl3 = bl;
                if (this.mPendingActions.size() == 1) {
                    bl3 = true;
                }
            }
            if (bl2 || bl3) {
                this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                this.mHost.getHandler().post(this.mExecCommit);
                this.updateOnBackPressedCallbackEnabled();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBackStackIndex(int n2, BackStackRecord backStackRecord) {
        synchronized (this) {
            block11: {
                int n3;
                Serializable serializable;
                if (this.mBackStackIndices == null) {
                    serializable = new ArrayList();
                    this.mBackStackIndices = serializable;
                }
                if (n2 < n3) {
                    if (DEBUG) {
                        serializable = new StringBuilder();
                        ((StringBuilder)serializable).append("Setting back stack index ");
                        ((StringBuilder)serializable).append(n2);
                        ((StringBuilder)serializable).append(" to ");
                        ((StringBuilder)serializable).append(backStackRecord);
                        Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
                    }
                    this.mBackStackIndices.set(n2, backStackRecord);
                    break block11;
                }
                for (int i2 = n3 = this.mBackStackIndices.size(); i2 < n2; ++i2) {
                    this.mBackStackIndices.add(null);
                    if (this.mAvailBackStackIndices == null) {
                        serializable = new ArrayList();
                        this.mAvailBackStackIndices = serializable;
                    }
                    if (DEBUG) {
                        serializable = new StringBuilder();
                        ((StringBuilder)serializable).append("Adding available back stack index ");
                        ((StringBuilder)serializable).append(i2);
                        Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
                    }
                    this.mAvailBackStackIndices.add(i2);
                }
                if (DEBUG) {
                    serializable = new StringBuilder();
                    ((StringBuilder)serializable).append("Adding back stack index ");
                    ((StringBuilder)serializable).append(n2);
                    ((StringBuilder)serializable).append(" with ");
                    ((StringBuilder)serializable).append(backStackRecord);
                    Log.v((String)TAG, (String)((StringBuilder)serializable).toString());
                }
                this.mBackStackIndices.add(backStackRecord);
            }
            return;
        }
    }

    public void setMaxLifecycle(Fragment fragment, Lifecycle.State object) {
        if (this.mActive.get(fragment.mWho) == fragment && (fragment.mHost == null || fragment.getFragmentManager() == this)) {
            fragment.mMaxState = object;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Fragment ");
        ((StringBuilder)object).append(fragment);
        ((StringBuilder)object).append(" is not an active fragment of FragmentManager ");
        ((StringBuilder)object).append(this);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public void setPrimaryNavigationFragment(Fragment fragment) {
        if (fragment != null && (this.mActive.get(fragment.mWho) != fragment || fragment.mHost != null && fragment.getFragmentManager() != this)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Fragment ");
            stringBuilder.append(fragment);
            stringBuilder.append(" is not an active fragment of FragmentManager ");
            stringBuilder.append(this);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        Fragment fragment2 = this.mPrimaryNav;
        this.mPrimaryNav = fragment;
        this.dispatchParentPrimaryNavigationFragmentChanged(fragment2);
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    public void showFragment(Fragment fragment) {
        if (DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("show: ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            fragment.mHiddenChanged ^= true;
        }
    }

    void startPendingDeferredFragments() {
        for (Fragment fragment : this.mActive.values()) {
            if (fragment == null) continue;
            this.performPendingDeferredStart(fragment);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("FragmentManager{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" in ");
        Fragment fragment = this.mParent;
        if (fragment != null) {
            DebugUtils.buildShortClassTag((Object)fragment, (StringBuilder)stringBuilder);
        } else {
            DebugUtils.buildShortClassTag((Object)this.mHost, (StringBuilder)stringBuilder);
        }
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterFragmentLifecycleCallbacks(FragmentManager.FragmentLifecycleCallbacks fragmentLifecycleCallbacks) {
        CopyOnWriteArrayList<FragmentLifecycleCallbacksHolder> copyOnWriteArrayList = this.mLifecycleCallbacks;
        synchronized (copyOnWriteArrayList) {
            int n2 = this.mLifecycleCallbacks.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.mLifecycleCallbacks.get((int)i2).mCallback != fragmentLifecycleCallbacks) continue;
                this.mLifecycleCallbacks.remove(i2);
                return;
            }
            return;
        }
    }

    private static class AnimationOrAnimator {
        public final Animation animation;
        public final Animator animator;

        AnimationOrAnimator(Animator animator) {
            this.animation = null;
            this.animator = animator;
            if (animator != null) {
                return;
            }
            throw new IllegalStateException("Animator cannot be null");
        }

        AnimationOrAnimator(Animation animation) {
            this.animation = animation;
            this.animator = null;
            if (animation != null) {
                return;
            }
            throw new IllegalStateException("Animation cannot be null");
        }
    }

    private static class EndViewTransitionAnimation
    extends AnimationSet
    implements Runnable {
        private boolean mAnimating = true;
        private final View mChild;
        private boolean mEnded;
        private final ViewGroup mParent;
        private boolean mTransitionEnded;

        EndViewTransitionAnimation(Animation animation, ViewGroup viewGroup, View view) {
            super(false);
            this.mParent = viewGroup;
            this.mChild = view;
            this.addAnimation(animation);
            this.mParent.post((Runnable)this);
        }

        public boolean getTransformation(long l2, Transformation transformation) {
            this.mAnimating = true;
            if (this.mEnded) {
                return this.mTransitionEnded ^ true;
            }
            if (!super.getTransformation(l2, transformation)) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, (Runnable)this);
            }
            return true;
        }

        public boolean getTransformation(long l2, Transformation transformation, float f2) {
            this.mAnimating = true;
            if (this.mEnded) {
                return this.mTransitionEnded ^ true;
            }
            if (!super.getTransformation(l2, transformation, f2)) {
                this.mEnded = true;
                OneShotPreDrawListener.add((View)this.mParent, (Runnable)this);
            }
            return true;
        }

        @Override
        public void run() {
            if (!this.mEnded && this.mAnimating) {
                this.mAnimating = false;
                this.mParent.post((Runnable)this);
            } else {
                this.mParent.endViewTransition(this.mChild);
                this.mTransitionEnded = true;
            }
        }
    }

    private static final class FragmentLifecycleCallbacksHolder {
        final FragmentManager.FragmentLifecycleCallbacks mCallback;
        final boolean mRecursive;

        FragmentLifecycleCallbacksHolder(FragmentManager.FragmentLifecycleCallbacks fragmentLifecycleCallbacks, boolean bl) {
            this.mCallback = fragmentLifecycleCallbacks;
            this.mRecursive = bl;
        }
    }

    static class FragmentTag {
        public static final int[] Fragment = new int[]{0x1010003, 0x10100D0, 0x10100D1};
        public static final int Fragment_id = 1;
        public static final int Fragment_name = 0;
        public static final int Fragment_tag = 2;

        private FragmentTag() {
        }
    }

    static interface OpGenerator {
        public boolean generateOps(ArrayList<BackStackRecord> var1, ArrayList<Boolean> var2);
    }

    private class PopBackStackState
    implements OpGenerator {
        final int mFlags;
        final int mId;
        final String mName;

        PopBackStackState(String string2, int n2, int n3) {
            this.mName = string2;
            this.mId = n2;
            this.mFlags = n3;
        }

        @Override
        public boolean generateOps(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2) {
            if (FragmentManagerImpl.this.mPrimaryNav != null && this.mId < 0 && this.mName == null && FragmentManagerImpl.this.mPrimaryNav.getChildFragmentManager().popBackStackImmediate()) {
                return false;
            }
            return FragmentManagerImpl.this.popBackStackState(arrayList, arrayList2, this.mName, this.mId, this.mFlags);
        }
    }

    static class StartEnterTransitionListener
    implements Fragment.OnStartEnterTransitionListener {
        final boolean mIsBack;
        private int mNumPostponed;
        final BackStackRecord mRecord;

        StartEnterTransitionListener(BackStackRecord backStackRecord, boolean bl) {
            this.mIsBack = bl;
            this.mRecord = backStackRecord;
        }

        public void cancelTransaction() {
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, false, false);
        }

        public void completeTransaction() {
            int n2 = this.mNumPostponed;
            n2 = n2 > 0 ? 1 : 0;
            FragmentManagerImpl fragmentManagerImpl = this.mRecord.mManager;
            int n3 = fragmentManagerImpl.mAdded.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Fragment fragment = fragmentManagerImpl.mAdded.get(i2);
                fragment.setOnStartEnterTransitionListener(null);
                if (n2 == 0 || !fragment.isPostponed()) continue;
                fragment.startPostponedEnterTransition();
            }
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, (n2 ^ 1) != 0, true);
        }

        public boolean isReady() {
            boolean bl = this.mNumPostponed == 0;
            return bl;
        }

        public void onStartEnterTransition() {
            --this.mNumPostponed;
            if (this.mNumPostponed != 0) {
                return;
            }
            this.mRecord.mManager.scheduleCommit();
        }

        public void startListening() {
            ++this.mNumPostponed;
        }
    }
}

