/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.text.util;

import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.webkit.WebView;
import android.widget.TextView;
import androidx.core.text.util.FindAddress;
import androidx.core.util.PatternsCompat;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LinkifyCompat {
    private static final Comparator<LinkSpec> COMPARATOR;
    private static final String[] EMPTY_STRING;

    static {
        EMPTY_STRING = new String[0];
        COMPARATOR = new Comparator<LinkSpec>(){

            @Override
            public int compare(LinkSpec linkSpec, LinkSpec linkSpec2) {
                if (linkSpec.start < linkSpec2.start) {
                    return -1;
                }
                if (linkSpec.start > linkSpec2.start) {
                    return 1;
                }
                if (linkSpec.end < linkSpec2.end) {
                    return 1;
                }
                if (linkSpec.end > linkSpec2.end) {
                    return -1;
                }
                return 0;
            }
        };
    }

    private LinkifyCompat() {
    }

    private static void addLinkMovementMethod(TextView textView) {
        if (!(textView.getMovementMethod() instanceof LinkMovementMethod) && textView.getLinksClickable()) {
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    public static void addLinks(TextView textView, Pattern pattern, String string2) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            Linkify.addLinks((TextView)textView, (Pattern)pattern, (String)string2);
            return;
        }
        LinkifyCompat.addLinks(textView, pattern, string2, null, null, null);
    }

    public static void addLinks(TextView textView, Pattern pattern, String string2, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            Linkify.addLinks((TextView)textView, (Pattern)pattern, (String)string2, (Linkify.MatchFilter)matchFilter, (Linkify.TransformFilter)transformFilter);
            return;
        }
        LinkifyCompat.addLinks(textView, pattern, string2, null, matchFilter, transformFilter);
    }

    public static void addLinks(TextView textView, Pattern pattern, String string2, String[] stringArray, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            Linkify.addLinks((TextView)textView, (Pattern)pattern, (String)string2, (String[])stringArray, (Linkify.MatchFilter)matchFilter, (Linkify.TransformFilter)transformFilter);
            return;
        }
        SpannableString spannableString = SpannableString.valueOf((CharSequence)textView.getText());
        if (LinkifyCompat.addLinks((Spannable)spannableString, pattern, string2, stringArray, matchFilter, transformFilter)) {
            textView.setText((CharSequence)spannableString);
            LinkifyCompat.addLinkMovementMethod(textView);
        }
    }

    public static boolean addLinks(Spannable spannable, int n2) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            return Linkify.addLinks((Spannable)spannable, (int)n2);
        }
        if (n2 == 0) {
            return false;
        }
        Object object = (Linkify.MatchFilter)spannable.getSpans(0, spannable.length(), URLSpan.class);
        for (int i2 = ((URLSpan[])object).length - 1; i2 >= 0; --i2) {
            spannable.removeSpan((Object)object[i2]);
        }
        if ((n2 & 4) != 0) {
            Linkify.addLinks((Spannable)spannable, (int)4);
        }
        ArrayList<LinkSpec> arrayList = new ArrayList<LinkSpec>();
        if ((n2 & 1) != 0) {
            Pattern object2 = PatternsCompat.AUTOLINK_WEB_URL;
            object = Linkify.sUrlMatchFilter;
            LinkifyCompat.gatherLinks(arrayList, spannable, object2, new String[]{"http://", "https://", "rtsp://"}, (Linkify.MatchFilter)object, null);
        }
        if ((n2 & 2) != 0) {
            LinkifyCompat.gatherLinks(arrayList, spannable, PatternsCompat.AUTOLINK_EMAIL_ADDRESS, new String[]{"mailto:"}, null, null);
        }
        if ((n2 & 8) != 0) {
            LinkifyCompat.gatherMapLinks(arrayList, spannable);
        }
        LinkifyCompat.pruneOverlaps(arrayList, spannable);
        if (arrayList.size() == 0) {
            return false;
        }
        for (LinkSpec linkSpec : arrayList) {
            if (linkSpec.frameworkAddedSpan != null) continue;
            LinkifyCompat.applyLink(linkSpec.url, linkSpec.start, linkSpec.end, spannable);
        }
        return true;
    }

    public static boolean addLinks(Spannable spannable, Pattern pattern, String string2) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            return Linkify.addLinks((Spannable)spannable, (Pattern)pattern, (String)string2);
        }
        return LinkifyCompat.addLinks(spannable, pattern, string2, null, null, null);
    }

    public static boolean addLinks(Spannable spannable, Pattern pattern, String string2, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            return Linkify.addLinks((Spannable)spannable, (Pattern)pattern, (String)string2, (Linkify.MatchFilter)matchFilter, (Linkify.TransformFilter)transformFilter);
        }
        return LinkifyCompat.addLinks(spannable, pattern, string2, null, matchFilter, transformFilter);
    }

    public static boolean addLinks(Spannable spannable, Pattern object, String stringArray, String[] object2, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        String[] stringArray2;
        block8: {
            block7: {
                if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
                    return Linkify.addLinks((Spannable)spannable, (Pattern)object, (String)stringArray, (String[])object2, (Linkify.MatchFilter)matchFilter, (Linkify.TransformFilter)transformFilter);
                }
                stringArray2 = stringArray;
                if (stringArray == null) {
                    stringArray2 = "";
                }
                if (object2 == null) break block7;
                stringArray = object2;
                if (((String[])object2).length >= 1) break block8;
            }
            stringArray = EMPTY_STRING;
        }
        String[] stringArray3 = new String[stringArray.length + 1];
        stringArray3[0] = stringArray2.toLowerCase(Locale.ROOT);
        int n2 = 0;
        while (n2 < stringArray.length) {
            object2 = stringArray[n2];
            object2 = object2 == null ? "" : object2.toLowerCase(Locale.ROOT);
            stringArray3[++n2] = object2;
        }
        object = ((Pattern)object).matcher((CharSequence)spannable);
        boolean bl = false;
        while (((Matcher)object).find()) {
            int n3 = ((Matcher)object).start();
            n2 = ((Matcher)object).end();
            boolean bl2 = matchFilter != null ? matchFilter.acceptMatch((CharSequence)spannable, n3, n2) : true;
            if (!bl2) continue;
            LinkifyCompat.applyLink(LinkifyCompat.makeUrl(((Matcher)object).group(0), stringArray3, (Matcher)object, transformFilter), n3, n2, spannable);
            bl = true;
        }
        return bl;
    }

    public static boolean addLinks(TextView textView, int n2) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            return Linkify.addLinks((TextView)textView, (int)n2);
        }
        if (n2 == 0) {
            return false;
        }
        CharSequence charSequence = textView.getText();
        if (charSequence instanceof Spannable) {
            if (LinkifyCompat.addLinks((Spannable)charSequence, n2)) {
                LinkifyCompat.addLinkMovementMethod(textView);
                return true;
            }
            return false;
        }
        if (LinkifyCompat.addLinks((Spannable)(charSequence = SpannableString.valueOf((CharSequence)charSequence)), n2)) {
            LinkifyCompat.addLinkMovementMethod(textView);
            textView.setText(charSequence);
            return true;
        }
        return false;
    }

    private static void applyLink(String string2, int n2, int n3, Spannable spannable) {
        spannable.setSpan((Object)new URLSpan(string2), n2, n3, 33);
    }

    private static String findAddress(String string2) {
        if (Build.VERSION.SDK_INT >= 28) {
            return WebView.findAddress((String)string2);
        }
        return FindAddress.findAddress((String)string2);
    }

    private static void gatherLinks(ArrayList<LinkSpec> arrayList, Spannable spannable, Pattern object, String[] stringArray, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        Matcher matcher = ((Pattern)object).matcher((CharSequence)spannable);
        while (matcher.find()) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            if (matchFilter != null && !matchFilter.acceptMatch((CharSequence)spannable, n2, n3)) continue;
            object = new LinkSpec();
            ((LinkSpec)object).url = LinkifyCompat.makeUrl(matcher.group(0), stringArray, matcher, transformFilter);
            ((LinkSpec)object).start = n2;
            ((LinkSpec)object).end = n3;
            arrayList.add((LinkSpec)object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void gatherMapLinks(ArrayList<LinkSpec> arrayList, Spannable object) {
        object = object.toString();
        int n2 = 0;
        try {
            CharSequence charSequence;
            while ((charSequence = LinkifyCompat.findAddress((String)object)) != null) {
                String string2;
                int n3 = ((String)object).indexOf((String)charSequence);
                if (n3 < 0) {
                    return;
                }
                LinkSpec linkSpec = new LinkSpec();
                int n4 = ((String)charSequence).length() + n3;
                linkSpec.start = n3 + n2;
                linkSpec.end = n2 += n4;
                object = ((String)object).substring(n4);
                try {
                    string2 = URLEncoder.encode((String)charSequence, "UTF-8");
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("geo:0,0?q=");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    continue;
                }
                ((StringBuilder)charSequence).append(string2);
                linkSpec.url = ((StringBuilder)charSequence).toString();
                arrayList.add(linkSpec);
            }
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
    }

    private static String makeUrl(String charSequence, String[] stringArray, Matcher object, Linkify.TransformFilter transformFilter) {
        int n2;
        block6: {
            String string2 = charSequence;
            if (transformFilter != null) {
                string2 = transformFilter.transformUrl((Matcher)object, (String)charSequence);
            }
            int n3 = 0;
            while (true) {
                n2 = stringArray.length;
                int n4 = 1;
                if (n3 >= n2) break;
                if (string2.regionMatches(true, 0, stringArray[n3], 0, stringArray[n3].length())) {
                    n2 = n4;
                    charSequence = string2;
                    if (!string2.regionMatches(false, 0, stringArray[n3], 0, stringArray[n3].length())) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append(stringArray[n3]);
                        ((StringBuilder)charSequence).append(string2.substring(stringArray[n3].length()));
                        charSequence = ((StringBuilder)charSequence).toString();
                        n2 = n4;
                    }
                    break block6;
                }
                ++n3;
            }
            n2 = 0;
            charSequence = string2;
        }
        object = charSequence;
        if (n2 == 0) {
            object = charSequence;
            if (stringArray.length > 0) {
                object = new StringBuilder();
                ((StringBuilder)object).append(stringArray[0]);
                ((StringBuilder)object).append((String)charSequence);
                object = ((StringBuilder)object).toString();
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void pruneOverlaps(ArrayList<LinkSpec> arrayList, Spannable spannable) {
        LinkSpec linkSpec;
        int n2 = spannable.length();
        int n3 = 0;
        URLSpan[] uRLSpanArray = (URLSpan[])spannable.getSpans(0, n2, URLSpan.class);
        for (n2 = 0; n2 < uRLSpanArray.length; ++n2) {
            linkSpec = new LinkSpec();
            linkSpec.frameworkAddedSpan = uRLSpanArray[n2];
            linkSpec.start = spannable.getSpanStart((Object)uRLSpanArray[n2]);
            linkSpec.end = spannable.getSpanEnd((Object)uRLSpanArray[n2]);
            arrayList.add(linkSpec);
        }
        Collections.sort(arrayList, COMPARATOR);
        int n4 = arrayList.size();
        n2 = n3;
        while (n2 < n4 - 1) {
            linkSpec = arrayList.get(n2);
            int n5 = n2 + 1;
            LinkSpec linkSpec2 = arrayList.get(n5);
            if (linkSpec.start <= linkSpec2.start && linkSpec.end > linkSpec2.start && (n3 = linkSpec2.end <= linkSpec.end || linkSpec.end - linkSpec.start > linkSpec2.end - linkSpec2.start ? n5 : (linkSpec.end - linkSpec.start < linkSpec2.end - linkSpec2.start ? n2 : -1)) != -1) {
                linkSpec = arrayList.get((int)n3).frameworkAddedSpan;
                if (linkSpec != null) {
                    spannable.removeSpan((Object)linkSpec);
                }
                arrayList.remove(n3);
                --n4;
                continue;
            }
            n2 = n5;
        }
        return;
    }

    private static boolean shouldAddLinksFallbackToFramework() {
        boolean bl = Build.VERSION.SDK_INT >= 28;
        return bl;
    }

    private static class LinkSpec {
        int end;
        URLSpan frameworkAddedSpan;
        int start;
        String url;

        LinkSpec() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LinkifyMask {
    }
}

