/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Handler;
import android.provider.BaseColumns;
import androidx.collection.LruCache;
import androidx.collection.SimpleArrayMap;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.TypefaceCompat;
import androidx.core.graphics.TypefaceCompatUtil;
import androidx.core.provider.FontRequest;
import androidx.core.provider.SelfDestructiveThread;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class FontsContractCompat {
    private static final int BACKGROUND_THREAD_KEEP_ALIVE_DURATION_MS = 10000;
    public static final String PARCEL_FONT_RESULTS = "font_results";
    static final int RESULT_CODE_PROVIDER_NOT_FOUND = -1;
    static final int RESULT_CODE_WRONG_CERTIFICATES = -2;
    private static final SelfDestructiveThread sBackgroundThread;
    private static final Comparator<byte[]> sByteArrayComparator;
    static final Object sLock;
    static final SimpleArrayMap<String, ArrayList<SelfDestructiveThread.ReplyCallback<TypefaceResult>>> sPendingReplies;
    static final LruCache<String, Typeface> sTypefaceCache;

    static {
        sTypefaceCache = new LruCache(16);
        sBackgroundThread = new SelfDestructiveThread("fonts", 10, 10000);
        sLock = new Object();
        sPendingReplies = new SimpleArrayMap();
        sByteArrayComparator = new Comparator<byte[]>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                int n2;
                int n3;
                if (byArray.length != byArray2.length) {
                    n3 = byArray.length;
                    n2 = byArray2.length;
                    return n3 - n2;
                }
                for (n3 = 0; n3 < byArray.length; ++n3) {
                    if (byArray[n3] == byArray2[n3]) continue;
                    n2 = byArray[n3];
                    int n4 = byArray2[n3];
                    n3 = n2;
                    n2 = n4;
                    return n3 - n2;
                }
                return 0;
            }
        };
    }

    private FontsContractCompat() {
    }

    public static Typeface buildTypeface(Context context, CancellationSignal cancellationSignal, FontInfo[] fontInfoArray) {
        return TypefaceCompat.createFromFontInfo((Context)context, (CancellationSignal)cancellationSignal, (FontInfo[])fontInfoArray, (int)0);
    }

    private static List<byte[]> convertToByteArrayList(Signature[] signatureArray) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i2 = 0; i2 < signatureArray.length; ++i2) {
            arrayList.add(signatureArray[i2].toByteArray());
        }
        return arrayList;
    }

    private static boolean equalsByteArrayList(List<byte[]> list, List<byte[]> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (Arrays.equals(list.get(i2), list2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static FontFamilyResult fetchFonts(Context context, CancellationSignal cancellationSignal, FontRequest fontRequest) throws PackageManager.NameNotFoundException {
        ProviderInfo providerInfo = FontsContractCompat.getProvider(context.getPackageManager(), fontRequest, context.getResources());
        if (providerInfo == null) {
            return new FontFamilyResult(1, null);
        }
        return new FontFamilyResult(0, FontsContractCompat.getFontFromProvider(context, fontRequest, providerInfo.authority, cancellationSignal));
    }

    private static List<List<byte[]>> getCertificates(FontRequest fontRequest, Resources resources) {
        if (fontRequest.getCertificates() != null) {
            return fontRequest.getCertificates();
        }
        return FontResourcesParserCompat.readCerts(resources, fontRequest.getCertificatesArrayResId());
    }

    static FontInfo[] getFontFromProvider(Context context, FontRequest object, String string2, CancellationSignal object2) {
        block39: {
            Uri uri;
            Uri uri2;
            Object object3;
            block38: {
                Object var7_8;
                block37: {
                    object3 = new ArrayList();
                    uri2 = new Uri.Builder().scheme("content").authority(string2).build();
                    uri = new Uri.Builder().scheme("content").authority(string2).appendPath("file").build();
                    var7_8 = null;
                    string2 = var7_8;
                    if (Build.VERSION.SDK_INT <= 16) break block37;
                    string2 = var7_8;
                    context = context.getContentResolver();
                    string2 = var7_8;
                    object = object.getQuery();
                    string2 = var7_8;
                    context = context.query(uri2, new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"}, "query = ?", new String[]{object}, null, (CancellationSignal)object2);
                    break block38;
                }
                string2 = var7_8;
                context = context.getContentResolver();
                string2 = var7_8;
                object = object.getQuery();
                string2 = var7_8;
                try {
                    context = context.query(uri2, new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"}, "query = ?", new String[]{object}, null);
                }
                catch (Throwable throwable) {
                    block44: {
                        if (string2 == null) break block44;
                        string2.close();
                    }
                    throw throwable;
                }
            }
            object = object3;
            if (context != null) {
                object = object3;
                string2 = context;
                if (context.getCount() <= 0) break block39;
                string2 = context;
                int n2 = context.getColumnIndex("result_code");
                string2 = context;
                string2 = context;
                object2 = new ArrayList();
                string2 = context;
                int n3 = context.getColumnIndex("_id");
                string2 = context;
                int n4 = context.getColumnIndex("file_id");
                string2 = context;
                int n5 = context.getColumnIndex("font_ttc_index");
                string2 = context;
                int n6 = context.getColumnIndex("font_weight");
                string2 = context;
                int n7 = context.getColumnIndex("font_italic");
                while (true) {
                    boolean bl;
                    int n8;
                    int n9;
                    int n10;
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    string2 = context;
                                    if (!context.moveToNext()) break;
                                    if (n2 == -1) break block40;
                                    string2 = context;
                                    n10 = context.getInt(n2);
                                    break block41;
                                }
                                n10 = 0;
                            }
                            if (n5 != -1) {
                                string2 = context;
                                n9 = context.getInt(n5);
                            } else {
                                n9 = 0;
                            }
                            if (n4 == -1) {
                                string2 = context;
                                object = ContentUris.withAppendedId((Uri)uri2, (long)context.getLong(n3));
                            } else {
                                string2 = context;
                                object = ContentUris.withAppendedId((Uri)uri, (long)context.getLong(n4));
                            }
                            if (n6 != -1) {
                                string2 = context;
                                n8 = context.getInt(n6);
                            } else {
                                n8 = 400;
                            }
                            if (n7 != -1) {
                                string2 = context;
                                if (context.getInt(n7) != 1) break block42;
                                bl = true;
                                break block43;
                            }
                        }
                        bl = false;
                    }
                    string2 = context;
                    string2 = context;
                    object3 = new FontInfo((Uri)object, n9, n8, bl, n10);
                    string2 = context;
                    ((ArrayList)object2).add(object3);
                    continue;
                    break;
                }
                object = object2;
            }
        }
        if (context != null) {
            context.close();
        }
        return ((ArrayList)object).toArray(new FontInfo[0]);
    }

    static TypefaceResult getFontInternal(Context context, FontRequest object, int n2) {
        int n3;
        block4: {
            try {
                object = FontsContractCompat.fetchFonts(context, null, (FontRequest)object);
                int n4 = ((FontFamilyResult)object).getStatusCode();
                n3 = -3;
                if (n4 != 0) break block4;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return new TypefaceResult(null, -1);
            }
            if ((context = TypefaceCompat.createFromFontInfo((Context)context, null, (FontInfo[])((FontFamilyResult)object).getFonts(), (int)n2)) != null) {
                n3 = 0;
            }
            return new TypefaceResult((Typeface)context, n3);
        }
        if (((FontFamilyResult)object).getStatusCode() == 1) {
            n3 = -2;
        }
        return new TypefaceResult(null, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Typeface getFontSync(final Context object, final FontRequest object2, final ResourcesCompat.FontCallback object3, Handler object4, boolean bl, int n2, final int n3) {
        CharSequence charSequence = new StringBuilder();
        charSequence.append(object2.getIdentifier());
        charSequence.append("-");
        charSequence.append(n3);
        charSequence = charSequence.toString();
        Typeface typeface = (Typeface)sTypefaceCache.get((Object)charSequence);
        if (typeface != null) {
            if (object3 == null) return typeface;
            object3.onFontRetrieved(typeface);
            return typeface;
        }
        if (bl && n2 == -1) {
            object = FontsContractCompat.getFontInternal(object, object2, n3);
            if (object3 == null) return object.mTypeface;
            if (object.mResult == 0) {
                object3.callbackSuccessAsync(object.mTypeface, (Handler)object4);
                return object.mTypeface;
            }
            object3.callbackFailAsync(object.mResult, (Handler)object4);
            return object.mTypeface;
        }
        object2 = new Callable<TypefaceResult>((String)charSequence){
            final /* synthetic */ String val$id;
            {
                this.val$id = string2;
            }

            @Override
            public TypefaceResult call() throws Exception {
                TypefaceResult typefaceResult = FontsContractCompat.getFontInternal(object, object2, n3);
                if (typefaceResult.mTypeface != null) {
                    sTypefaceCache.put((Object)this.val$id, (Object)typefaceResult.mTypeface);
                }
                return typefaceResult;
            }
        };
        object = null;
        if (bl) {
            try {
                object2 = ((TypefaceResult)FontsContractCompat.sBackgroundThread.postAndWait(object2, (int)n2)).mTypeface;
                return object2;
            }
            catch (InterruptedException interruptedException) {
                return object;
            }
        }
        object = object3 == null ? null : new SelfDestructiveThread.ReplyCallback<TypefaceResult>((Handler)object4){
            final /* synthetic */ Handler val$handler;
            {
                this.val$handler = handler;
            }

            @Override
            public void onReply(TypefaceResult typefaceResult) {
                if (typefaceResult == null) {
                    object3.callbackFailAsync(1, this.val$handler);
                } else if (typefaceResult.mResult == 0) {
                    object3.callbackSuccessAsync(typefaceResult.mTypeface, this.val$handler);
                } else {
                    object3.callbackFailAsync(typefaceResult.mResult, this.val$handler);
                }
            }
        };
        object3 = sLock;
        synchronized (object3) {
            object4 = (ArrayList)sPendingReplies.get((Object)charSequence);
            if (object4 != null) {
                if (object == null) return null;
                ((ArrayList)object4).add(object);
                return null;
            }
            if (object != null) {
                object4 = new ArrayList();
                ((ArrayList)object4).add(object);
                sPendingReplies.put((Object)charSequence, object4);
            }
        }
        sBackgroundThread.postAndReply(object2, new SelfDestructiveThread.ReplyCallback<TypefaceResult>((String)charSequence){
            final /* synthetic */ String val$id;
            {
                this.val$id = string2;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onReply(TypefaceResult typefaceResult) {
                int n2;
                ArrayList arrayList;
                Object object = sLock;
                synchronized (object) {
                    arrayList = (ArrayList)sPendingReplies.get((Object)this.val$id);
                    if (arrayList == null) {
                        return;
                    }
                    sPendingReplies.remove((Object)this.val$id);
                    // MONITOREXIT @DISABLED, blocks:[0, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_3
                    n2 = 0;
                    {
                        catch (Throwable throwable) {}
                        {
                            throw throwable;
                        }
                    }
                }
                while (n2 < arrayList.size()) {
                    ((SelfDestructiveThread.ReplyCallback)arrayList.get(n2)).onReply(typefaceResult);
                    ++n2;
                }
            }
        });
        return null;
    }

    public static ProviderInfo getProvider(PackageManager object, FontRequest object2, Resources object3) throws PackageManager.NameNotFoundException {
        String string2 = object2.getProviderAuthority();
        ProviderInfo providerInfo = object.resolveContentProvider(string2, 0);
        if (providerInfo != null) {
            if (providerInfo.packageName.equals(object2.getProviderPackage())) {
                object = FontsContractCompat.convertToByteArrayList(object.getPackageInfo((String)providerInfo.packageName, (int)64).signatures);
                Collections.sort(object, sByteArrayComparator);
                object2 = FontsContractCompat.getCertificates((FontRequest)object2, object3);
                for (int i2 = 0; i2 < object2.size(); ++i2) {
                    object3 = new ArrayList((Collection)object2.get(i2));
                    Collections.sort(object3, sByteArrayComparator);
                    if (!FontsContractCompat.equalsByteArrayList((List<byte[]>)object, (List<byte[]>)object3)) continue;
                    return providerInfo;
                }
                return null;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Found content provider ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(", but package was not ");
            ((StringBuilder)object).append(object2.getProviderPackage());
            throw new PackageManager.NameNotFoundException(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("No package found for authority: ");
        ((StringBuilder)object).append(string2);
        object = new PackageManager.NameNotFoundException(((StringBuilder)object).toString());
        throw object;
    }

    public static Map<Uri, ByteBuffer> prepareFontData(Context context, FontInfo[] fontInfoArray, CancellationSignal cancellationSignal) {
        HashMap<FontInfo, ByteBuffer> hashMap = new HashMap<FontInfo, ByteBuffer>();
        for (FontInfo fontInfo : fontInfoArray) {
            if (fontInfo.getResultCode() != 0 || hashMap.containsKey(fontInfo = fontInfo.getUri())) continue;
            hashMap.put(fontInfo, TypefaceCompatUtil.mmap((Context)context, (CancellationSignal)cancellationSignal, (Uri)fontInfo));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static void requestFont(Context context, FontRequest fontRequest, FontRequestCallback fontRequestCallback, Handler handler) {
        FontsContractCompat.requestFontInternal(context.getApplicationContext(), fontRequest, fontRequestCallback, handler);
    }

    private static void requestFontInternal(final Context context, final FontRequest fontRequest, FontRequestCallback fontRequestCallback, Handler handler) {
        handler.post(new Runnable(new Handler(), fontRequestCallback){
            final /* synthetic */ FontRequestCallback val$callback;
            final /* synthetic */ Handler val$callerThreadHandler;
            {
                this.val$callerThreadHandler = handler;
                this.val$callback = fontRequestCallback;
            }

            @Override
            public void run() {
                Object object;
                block7: {
                    block8: {
                        block9: {
                            try {
                                object = FontsContractCompat.fetchFonts(context, null, fontRequest);
                                if (((FontFamilyResult)object).getStatusCode() == 0) break block7;
                                int n2 = ((FontFamilyResult)object).getStatusCode();
                                if (n2 == 1) break block8;
                                if (n2 == 2) break block9;
                            }
                            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                                this.val$callerThreadHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        val$callback.onTypefaceRequestFailed(-1);
                                    }
                                });
                                return;
                            }
                            this.val$callerThreadHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    val$callback.onTypefaceRequestFailed(-3);
                                }
                            });
                            return;
                        }
                        this.val$callerThreadHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                val$callback.onTypefaceRequestFailed(-3);
                            }
                        });
                        return;
                    }
                    this.val$callerThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            val$callback.onTypefaceRequestFailed(-2);
                        }
                    });
                    return;
                }
                FontInfo[] fontInfoArray = ((FontFamilyResult)object).getFonts();
                if (fontInfoArray != null && fontInfoArray.length != 0) {
                    int n3 = fontInfoArray.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        object = fontInfoArray[i2];
                        if (((FontInfo)object).getResultCode() == 0) continue;
                        i2 = ((FontInfo)object).getResultCode();
                        if (i2 < 0) {
                            this.val$callerThreadHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    val$callback.onTypefaceRequestFailed(-3);
                                }
                            });
                        } else {
                            this.val$callerThreadHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    val$callback.onTypefaceRequestFailed(i2);
                                }
                            });
                        }
                        return;
                    }
                    object = FontsContractCompat.buildTypeface(context, null, fontInfoArray);
                    if (object == null) {
                        this.val$callerThreadHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                val$callback.onTypefaceRequestFailed(-3);
                            }
                        });
                        return;
                    }
                    this.val$callerThreadHandler.post(new Runnable((Typeface)object){
                        final /* synthetic */ Typeface val$typeface;
                        {
                            this.val$typeface = typeface;
                        }

                        @Override
                        public void run() {
                            val$callback.onTypefaceRetrieved(this.val$typeface);
                        }
                    });
                    return;
                }
                this.val$callerThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        val$callback.onTypefaceRequestFailed(1);
                    }
                });
                return;
            }
        });
    }

    public static void resetCache() {
        sTypefaceCache.evictAll();
    }

    public static final class Columns
    implements BaseColumns {
        public static final String FILE_ID = "file_id";
        public static final String ITALIC = "font_italic";
        public static final String RESULT_CODE = "result_code";
        public static final int RESULT_CODE_FONT_NOT_FOUND = 1;
        public static final int RESULT_CODE_FONT_UNAVAILABLE = 2;
        public static final int RESULT_CODE_MALFORMED_QUERY = 3;
        public static final int RESULT_CODE_OK = 0;
        public static final String TTC_INDEX = "font_ttc_index";
        public static final String VARIATION_SETTINGS = "font_variation_settings";
        public static final String WEIGHT = "font_weight";
    }

    public static class FontFamilyResult {
        public static final int STATUS_OK = 0;
        public static final int STATUS_UNEXPECTED_DATA_PROVIDED = 2;
        public static final int STATUS_WRONG_CERTIFICATES = 1;
        private final FontInfo[] mFonts;
        private final int mStatusCode;

        public FontFamilyResult(int n2, FontInfo[] fontInfoArray) {
            this.mStatusCode = n2;
            this.mFonts = fontInfoArray;
        }

        public FontInfo[] getFonts() {
            return this.mFonts;
        }

        public int getStatusCode() {
            return this.mStatusCode;
        }
    }

    public static class FontInfo {
        private final boolean mItalic;
        private final int mResultCode;
        private final int mTtcIndex;
        private final Uri mUri;
        private final int mWeight;

        public FontInfo(Uri uri, int n2, int n3, boolean bl, int n4) {
            this.mUri = (Uri)Preconditions.checkNotNull((Object)uri);
            this.mTtcIndex = n2;
            this.mWeight = n3;
            this.mItalic = bl;
            this.mResultCode = n4;
        }

        public int getResultCode() {
            return this.mResultCode;
        }

        public int getTtcIndex() {
            return this.mTtcIndex;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public int getWeight() {
            return this.mWeight;
        }

        public boolean isItalic() {
            return this.mItalic;
        }
    }

    public static class FontRequestCallback {
        public static final int FAIL_REASON_FONT_LOAD_ERROR = -3;
        public static final int FAIL_REASON_FONT_NOT_FOUND = 1;
        public static final int FAIL_REASON_FONT_UNAVAILABLE = 2;
        public static final int FAIL_REASON_MALFORMED_QUERY = 3;
        public static final int FAIL_REASON_PROVIDER_NOT_FOUND = -1;
        public static final int FAIL_REASON_SECURITY_VIOLATION = -4;
        public static final int FAIL_REASON_WRONG_CERTIFICATES = -2;
        public static final int RESULT_OK = 0;

        public void onTypefaceRequestFailed(int n2) {
        }

        public void onTypefaceRetrieved(Typeface typeface) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface FontRequestFailReason {
        }
    }

    private static final class TypefaceResult {
        final int mResult;
        final Typeface mTypeface;

        TypefaceResult(Typeface typeface, int n2) {
            this.mTypeface = typeface;
            this.mResult = n2;
        }
    }
}

