/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.res;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.Base64;
import android.util.TypedValue;
import android.util.Xml;
import androidx.core.R;
import androidx.core.provider.FontRequest;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontResourcesParserCompat {
    private static final int DEFAULT_TIMEOUT_MILLIS = 500;
    public static final int FETCH_STRATEGY_ASYNC = 1;
    public static final int FETCH_STRATEGY_BLOCKING = 0;
    public static final int INFINITE_TIMEOUT_VALUE = -1;
    private static final int ITALIC = 1;
    private static final int NORMAL_WEIGHT = 400;

    private FontResourcesParserCompat() {
    }

    private static int getType(TypedArray typedArray, int n2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return typedArray.getType(n2);
        }
        TypedValue typedValue = new TypedValue();
        typedArray.getValue(n2, typedValue);
        return typedValue.type;
    }

    public static FamilyResourceEntry parse(XmlPullParser xmlPullParser, Resources resources) throws XmlPullParserException, IOException {
        int n2;
        while ((n2 = xmlPullParser.next()) != 2 && n2 != 1) {
        }
        if (n2 == 2) {
            return FontResourcesParserCompat.readFamilies(xmlPullParser, resources);
        }
        xmlPullParser = new XmlPullParserException("No start tag found");
        throw xmlPullParser;
    }

    public static List<List<byte[]>> readCerts(Resources object, int n2) {
        ArrayList<List<byte[]>> arrayList;
        TypedArray typedArray;
        block10: {
            block9: {
                block8: {
                    if (n2 == 0) {
                        return Collections.emptyList();
                    }
                    typedArray = object.obtainTypedArray(n2);
                    if (typedArray.length() != 0) break block8;
                    object = Collections.emptyList();
                    typedArray.recycle();
                    return object;
                }
                arrayList = new ArrayList<List<byte[]>>();
                if (FontResourcesParserCompat.getType(typedArray, 0) != 1) break block9;
                n2 = 0;
                while (true) {
                    block11: {
                        if (n2 >= typedArray.length()) break block10;
                        int n3 = typedArray.getResourceId(n2, 0);
                        if (n3 == 0) break block11;
                        arrayList.add(FontResourcesParserCompat.toByteArrayList(object.getStringArray(n3)));
                    }
                    ++n2;
                }
            }
            try {
                arrayList.add(FontResourcesParserCompat.toByteArrayList(object.getStringArray(n2)));
            }
            catch (Throwable throwable) {
                typedArray.recycle();
                throw throwable;
            }
        }
        typedArray.recycle();
        return arrayList;
    }

    private static FamilyResourceEntry readFamilies(XmlPullParser xmlPullParser, Resources resources) throws XmlPullParserException, IOException {
        xmlPullParser.require(2, null, "font-family");
        if (xmlPullParser.getName().equals("font-family")) {
            return FontResourcesParserCompat.readFamily(xmlPullParser, resources);
        }
        FontResourcesParserCompat.skip(xmlPullParser);
        return null;
    }

    private static FamilyResourceEntry readFamily(XmlPullParser xmlPullParser, Resources resources) throws XmlPullParserException, IOException {
        TypedArray typedArray = resources.obtainAttributes(Xml.asAttributeSet((XmlPullParser)xmlPullParser), R.styleable.FontFamily);
        String string2 = typedArray.getString(R.styleable.FontFamily_fontProviderAuthority);
        Object object = typedArray.getString(R.styleable.FontFamily_fontProviderPackage);
        String string3 = typedArray.getString(R.styleable.FontFamily_fontProviderQuery);
        int n2 = typedArray.getResourceId(R.styleable.FontFamily_fontProviderCerts, 0);
        int n3 = typedArray.getInteger(R.styleable.FontFamily_fontProviderFetchStrategy, 1);
        int n4 = typedArray.getInteger(R.styleable.FontFamily_fontProviderFetchTimeout, 500);
        typedArray.recycle();
        if (string2 != null && object != null && string3 != null) {
            while (xmlPullParser.next() != 3) {
                FontResourcesParserCompat.skip(xmlPullParser);
            }
            return new ProviderResourceEntry(new FontRequest(string2, (String)object, string3, FontResourcesParserCompat.readCerts(resources, n2)), n3, n4);
        }
        object = new ArrayList();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals("font")) {
                object.add(FontResourcesParserCompat.readFont(xmlPullParser, resources));
                continue;
            }
            FontResourcesParserCompat.skip(xmlPullParser);
        }
        if (object.isEmpty()) {
            return null;
        }
        return new FontFamilyFilesResourceEntry(object.toArray(new FontFileResourceEntry[object.size()]));
    }

    private static FontFileResourceEntry readFont(XmlPullParser xmlPullParser, Resources object) throws XmlPullParserException, IOException {
        TypedArray typedArray = object.obtainAttributes(Xml.asAttributeSet((XmlPullParser)xmlPullParser), R.styleable.FontFamilyFont);
        int n2 = typedArray.hasValue(R.styleable.FontFamilyFont_fontWeight) ? R.styleable.FontFamilyFont_fontWeight : R.styleable.FontFamilyFont_android_fontWeight;
        int n3 = typedArray.getInt(n2, 400);
        n2 = typedArray.hasValue(R.styleable.FontFamilyFont_fontStyle) ? R.styleable.FontFamilyFont_fontStyle : R.styleable.FontFamilyFont_android_fontStyle;
        boolean bl = 1 == typedArray.getInt(n2, 0);
        n2 = typedArray.hasValue(R.styleable.FontFamilyFont_ttcIndex) ? R.styleable.FontFamilyFont_ttcIndex : R.styleable.FontFamilyFont_android_ttcIndex;
        int n4 = typedArray.hasValue(R.styleable.FontFamilyFont_fontVariationSettings) ? R.styleable.FontFamilyFont_fontVariationSettings : R.styleable.FontFamilyFont_android_fontVariationSettings;
        object = typedArray.getString(n4);
        n4 = typedArray.getInt(n2, 0);
        n2 = typedArray.hasValue(R.styleable.FontFamilyFont_font) ? R.styleable.FontFamilyFont_font : R.styleable.FontFamilyFont_android_font;
        int n5 = typedArray.getResourceId(n2, 0);
        String string2 = typedArray.getString(n2);
        typedArray.recycle();
        while (xmlPullParser.next() != 3) {
            FontResourcesParserCompat.skip(xmlPullParser);
        }
        return new FontFileResourceEntry(string2, n3, bl, (String)object, n4, n5);
    }

    private static void skip(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n2 = 1;
        while (n2 > 0) {
            int n3 = xmlPullParser.next();
            if (n3 != 2) {
                if (n3 != 3) continue;
                --n2;
                continue;
            }
            ++n2;
        }
    }

    private static List<byte[]> toByteArrayList(String[] stringArray) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(Base64.decode((String)stringArray[i2], (int)0));
        }
        return arrayList;
    }

    public static interface FamilyResourceEntry {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FetchStrategy {
    }

    public static final class FontFamilyFilesResourceEntry
    implements FamilyResourceEntry {
        private final FontFileResourceEntry[] mEntries;

        public FontFamilyFilesResourceEntry(FontFileResourceEntry[] fontFileResourceEntryArray) {
            this.mEntries = fontFileResourceEntryArray;
        }

        public FontFileResourceEntry[] getEntries() {
            return this.mEntries;
        }
    }

    public static final class FontFileResourceEntry {
        private final String mFileName;
        private boolean mItalic;
        private int mResourceId;
        private int mTtcIndex;
        private String mVariationSettings;
        private int mWeight;

        public FontFileResourceEntry(String string2, int n2, boolean bl, String string3, int n3, int n4) {
            this.mFileName = string2;
            this.mWeight = n2;
            this.mItalic = bl;
            this.mVariationSettings = string3;
            this.mTtcIndex = n3;
            this.mResourceId = n4;
        }

        public String getFileName() {
            return this.mFileName;
        }

        public int getResourceId() {
            return this.mResourceId;
        }

        public int getTtcIndex() {
            return this.mTtcIndex;
        }

        public String getVariationSettings() {
            return this.mVariationSettings;
        }

        public int getWeight() {
            return this.mWeight;
        }

        public boolean isItalic() {
            return this.mItalic;
        }
    }

    public static final class ProviderResourceEntry
    implements FamilyResourceEntry {
        private final FontRequest mRequest;
        private final int mStrategy;
        private final int mTimeoutMs;

        public ProviderResourceEntry(FontRequest fontRequest, int n2, int n3) {
            this.mRequest = fontRequest;
            this.mStrategy = n2;
            this.mTimeoutMs = n3;
        }

        public int getFetchStrategy() {
            return this.mStrategy;
        }

        public FontRequest getRequest() {
            return this.mRequest;
        }

        public int getTimeout() {
            return this.mTimeoutMs;
        }
    }
}

