/*
 * Decompiled with CFR 0.152.
 */
package androidx.coordinatorlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.coordinatorlayout.R;
import androidx.coordinatorlayout.widget.DirectedAcyclicGraph;
import androidx.coordinatorlayout.widget.ViewGroupUtils;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Pools;
import androidx.core.view.GravityCompat;
import androidx.core.view.NestedScrollingParent2;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.customview.view.AbsSavedState;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoordinatorLayout
extends ViewGroup
implements NestedScrollingParent2 {
    static final Class<?>[] CONSTRUCTOR_PARAMS;
    static final int EVENT_NESTED_SCROLL = 1;
    static final int EVENT_PRE_DRAW = 0;
    static final int EVENT_VIEW_REMOVED = 2;
    static final String TAG = "CoordinatorLayout";
    static final Comparator<View> TOP_SORTED_CHILDREN_COMPARATOR;
    private static final int TYPE_ON_INTERCEPT = 0;
    private static final int TYPE_ON_TOUCH = 1;
    static final String WIDGET_PACKAGE_NAME;
    static final ThreadLocal<Map<String, Constructor<Behavior>>> sConstructors;
    private static final Pools.Pool<Rect> sRectPool;
    private OnApplyWindowInsetsListener mApplyWindowInsetsListener;
    private View mBehaviorTouchView;
    private final DirectedAcyclicGraph<View> mChildDag;
    private final List<View> mDependencySortedChildren = new ArrayList<View>();
    private boolean mDisallowInterceptReset;
    private boolean mDrawStatusBarBackground;
    private boolean mIsAttachedToWindow;
    private int[] mKeylines;
    private WindowInsetsCompat mLastInsets;
    private boolean mNeedsPreDrawListener;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private View mNestedScrollingTarget;
    ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;
    private OnPreDrawListener mOnPreDrawListener;
    private Paint mScrimPaint;
    private Drawable mStatusBarBackground;
    private final List<View> mTempDependenciesList;
    private final int[] mTempIntPair;
    private final List<View> mTempList1;

    static {
        Object object = CoordinatorLayout.class.getPackage();
        object = object != null ? ((Package)object).getName() : null;
        WIDGET_PACKAGE_NAME = object;
        TOP_SORTED_CHILDREN_COMPARATOR = Build.VERSION.SDK_INT >= 21 ? new ViewElevationComparator() : null;
        CONSTRUCTOR_PARAMS = new Class[]{Context.class, AttributeSet.class};
        sConstructors = new ThreadLocal();
        sRectPool = new Pools.SynchronizedPool(12);
    }

    public CoordinatorLayout(Context context) {
        this(context, null);
    }

    public CoordinatorLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.coordinatorLayoutStyle);
    }

    public CoordinatorLayout(Context object, AttributeSet attributeSet, int n2) {
        super(object, attributeSet, n2);
        this.mChildDag = new DirectedAcyclicGraph();
        this.mTempList1 = new ArrayList<View>();
        this.mTempDependenciesList = new ArrayList<View>();
        this.mTempIntPair = new int[2];
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        int n3 = 0;
        attributeSet = n2 == 0 ? object.obtainStyledAttributes(attributeSet, R.styleable.CoordinatorLayout, 0, R.style.Widget_Support_CoordinatorLayout) : object.obtainStyledAttributes(attributeSet, R.styleable.CoordinatorLayout, n2, 0);
        n2 = attributeSet.getResourceId(R.styleable.CoordinatorLayout_keylines, 0);
        if (n2 != 0) {
            object = object.getResources();
            this.mKeylines = object.getIntArray(n2);
            float f2 = object.getDisplayMetrics().density;
            int n4 = this.mKeylines.length;
            for (n2 = n3; n2 < n4; ++n2) {
                object = this.mKeylines;
                object[n2] = (Context)((int)((float)object[n2] * f2));
            }
        }
        this.mStatusBarBackground = attributeSet.getDrawable(R.styleable.CoordinatorLayout_statusBarBackground);
        attributeSet.recycle();
        this.setupForInsets();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)new HierarchyChangeListener());
    }

    private static Rect acquireTempRect() {
        Rect rect;
        Rect rect2 = rect = (Rect)sRectPool.acquire();
        if (rect == null) {
            rect2 = new Rect();
        }
        return rect2;
    }

    private static int clamp(int n2, int n3, int n4) {
        if (n2 < n3) {
            return n3;
        }
        if (n2 > n4) {
            return n4;
        }
        return n2;
    }

    private void constrainChildRect(LayoutParams layoutParams, Rect rect, int n2, int n3) {
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        n4 = Math.max(this.getPaddingLeft() + layoutParams.leftMargin, Math.min(rect.left, n4 - this.getPaddingRight() - n2 - layoutParams.rightMargin));
        n5 = Math.max(this.getPaddingTop() + layoutParams.topMargin, Math.min(rect.top, n5 - this.getPaddingBottom() - n3 - layoutParams.bottomMargin));
        rect.set(n4, n5, n2 + n4, n3 + n5);
    }

    private WindowInsetsCompat dispatchApplyWindowInsetsToBehaviors(WindowInsetsCompat windowInsetsCompat) {
        WindowInsetsCompat windowInsetsCompat2;
        if (windowInsetsCompat.isConsumed()) {
            return windowInsetsCompat;
        }
        int n2 = 0;
        int n3 = this.getChildCount();
        while (true) {
            windowInsetsCompat2 = windowInsetsCompat;
            if (n2 >= n3) break;
            View view = this.getChildAt(n2);
            windowInsetsCompat2 = windowInsetsCompat;
            if (ViewCompat.getFitsSystemWindows(view)) {
                Behavior behavior = ((LayoutParams)view.getLayoutParams()).getBehavior();
                windowInsetsCompat2 = windowInsetsCompat;
                if (behavior != null) {
                    windowInsetsCompat2 = windowInsetsCompat = behavior.onApplyWindowInsets(this, view, windowInsetsCompat);
                    if (windowInsetsCompat.isConsumed()) {
                        windowInsetsCompat2 = windowInsetsCompat;
                        break;
                    }
                }
            }
            ++n2;
            windowInsetsCompat = windowInsetsCompat2;
        }
        return windowInsetsCompat2;
    }

    private void getDesiredAnchoredChildRectWithoutConstraints(View view, int n2, Rect rect, Rect rect2, LayoutParams layoutParams, int n3, int n4) {
        int n5 = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveAnchoredChildGravity(layoutParams.gravity), (int)n2);
        n2 = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveGravity(layoutParams.anchorGravity), (int)n2);
        int n6 = n5 & 7;
        int n7 = n5 & 0x70;
        int n8 = n2 & 7;
        n5 = n2 & 0x70;
        n2 = n8 != 1 ? (n8 != 5 ? rect.left : rect.right) : rect.left + rect.width() / 2;
        n5 = n5 != 16 ? (n5 != 80 ? rect.top : rect.bottom) : rect.top + rect.height() / 2;
        if (n6 != 1) {
            n8 = n2;
            if (n6 != 5) {
                n8 = n2 - n3;
            }
        } else {
            n8 = n2 - n3 / 2;
        }
        if (n7 != 16) {
            n2 = n5;
            if (n7 != 80) {
                n2 = n5 - n4;
            }
        } else {
            n2 = n5 - n4 / 2;
        }
        rect2.set(n8, n2, n3 + n8, n4 + n2);
    }

    private int getKeyline(int n2) {
        Object object = this.mKeylines;
        if (object == null) {
            object = new StringBuilder();
            object.append("No keylines defined for ");
            object.append((Object)this);
            object.append(" - attempted index lookup ");
            object.append(n2);
            Log.e((String)TAG, (String)object.toString());
            return 0;
        }
        if (n2 >= 0 && n2 < ((int[])object).length) {
            return object[n2];
        }
        object = new StringBuilder();
        object.append("Keyline index ");
        object.append(n2);
        object.append(" out of range for ");
        object.append((Object)this);
        Log.e((String)TAG, (String)object.toString());
        return 0;
    }

    private void getTopSortedChildren(List<View> list) {
        list.clear();
        boolean bl = this.isChildrenDrawingOrderEnabled();
        int n2 = this.getChildCount();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = bl ? this.getChildDrawingOrder(n2, i2) : i2;
            list.add(this.getChildAt(n3));
        }
        Comparator<View> comparator = TOP_SORTED_CHILDREN_COMPARATOR;
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
    }

    private boolean hasDependencies(View view) {
        return this.mChildDag.hasOutgoingEdges((Object)view);
    }

    private void layoutChild(View view, int n2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        Rect rect = CoordinatorLayout.acquireTempRect();
        rect.set(this.getPaddingLeft() + layoutParams.leftMargin, this.getPaddingTop() + layoutParams.topMargin, this.getWidth() - this.getPaddingRight() - layoutParams.rightMargin, this.getHeight() - this.getPaddingBottom() - layoutParams.bottomMargin);
        if (this.mLastInsets != null && ViewCompat.getFitsSystemWindows((View)this) && !ViewCompat.getFitsSystemWindows(view)) {
            rect.left += this.mLastInsets.getSystemWindowInsetLeft();
            rect.top += this.mLastInsets.getSystemWindowInsetTop();
            rect.right -= this.mLastInsets.getSystemWindowInsetRight();
            rect.bottom -= this.mLastInsets.getSystemWindowInsetBottom();
        }
        Rect rect2 = CoordinatorLayout.acquireTempRect();
        GravityCompat.apply((int)CoordinatorLayout.resolveGravity(layoutParams.gravity), (int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Rect)rect, (Rect)rect2, (int)n2);
        view.layout(rect2.left, rect2.top, rect2.right, rect2.bottom);
        CoordinatorLayout.releaseTempRect(rect);
        CoordinatorLayout.releaseTempRect(rect2);
    }

    private void layoutChildWithAnchor(View view, View view2, int n2) {
        Rect rect = CoordinatorLayout.acquireTempRect();
        Rect rect2 = CoordinatorLayout.acquireTempRect();
        try {
            this.getDescendantRect(view2, rect);
            this.getDesiredAnchoredChildRect(view, n2, rect, rect2);
            view.layout(rect2.left, rect2.top, rect2.right, rect2.bottom);
            return;
        }
        finally {
            CoordinatorLayout.releaseTempRect(rect);
            CoordinatorLayout.releaseTempRect(rect2);
        }
    }

    private void layoutChildWithKeyline(View view, int n2, int n3) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n4 = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveKeylineGravity(layoutParams.gravity), (int)n3);
        int n5 = n4 & 7;
        int n6 = n4 & 0x70;
        int n7 = this.getWidth();
        int n8 = this.getHeight();
        int n9 = view.getMeasuredWidth();
        int n10 = view.getMeasuredHeight();
        n4 = n2;
        if (n3 == 1) {
            n4 = n7 - n2;
        }
        n2 = this.getKeyline(n4) - n9;
        n3 = 0;
        if (n5 != 1) {
            if (n5 == 5) {
                n2 += n9;
            }
        } else {
            n2 += n9 / 2;
        }
        if (n6 != 16) {
            if (n6 == 80) {
                n3 = n10 + 0;
            }
        } else {
            n3 = 0 + n10 / 2;
        }
        n2 = Math.max(this.getPaddingLeft() + layoutParams.leftMargin, Math.min(n2, n7 - this.getPaddingRight() - n9 - layoutParams.rightMargin));
        n3 = Math.max(this.getPaddingTop() + layoutParams.topMargin, Math.min(n3, n8 - this.getPaddingBottom() - n10 - layoutParams.bottomMargin));
        view.layout(n2, n3, n9 + n2, n10 + n3);
    }

    private void offsetChildByInset(View object, Rect rect, int n2) {
        if (!ViewCompat.isLaidOut((View)object)) {
            return;
        }
        if (object.getWidth() > 0 && object.getHeight() > 0) {
            LayoutParams layoutParams = (LayoutParams)object.getLayoutParams();
            Behavior behavior = layoutParams.getBehavior();
            Rect rect2 = CoordinatorLayout.acquireTempRect();
            Rect rect3 = CoordinatorLayout.acquireTempRect();
            rect3.set(object.getLeft(), object.getTop(), object.getRight(), object.getBottom());
            if (behavior != null && behavior.getInsetDodgeRect(this, object, rect2)) {
                if (!rect3.contains(rect2)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Rect should be within the child's bounds. Rect:");
                    ((StringBuilder)object).append(rect2.toShortString());
                    ((StringBuilder)object).append(" | Bounds:");
                    ((StringBuilder)object).append(rect3.toShortString());
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
            } else {
                rect2.set(rect3);
            }
            CoordinatorLayout.releaseTempRect(rect3);
            if (rect2.isEmpty()) {
                CoordinatorLayout.releaseTempRect(rect2);
                return;
            }
            int n3 = GravityCompat.getAbsoluteGravity((int)layoutParams.dodgeInsetEdges, (int)n2);
            if ((n3 & 0x30) == 48 && (n2 = rect2.top - layoutParams.topMargin - layoutParams.mInsetOffsetY) < rect.top) {
                this.setInsetOffsetY((View)object, rect.top - n2);
                n2 = 1;
            } else {
                n2 = 0;
            }
            int n4 = n2;
            if ((n3 & 0x50) == 80) {
                int n5 = this.getHeight() - rect2.bottom - layoutParams.bottomMargin + layoutParams.mInsetOffsetY;
                n4 = n2;
                if (n5 < rect.bottom) {
                    this.setInsetOffsetY((View)object, n5 - rect.bottom);
                    n4 = 1;
                }
            }
            if (n4 == 0) {
                this.setInsetOffsetY((View)object, 0);
            }
            if ((n3 & 3) == 3 && (n2 = rect2.left - layoutParams.leftMargin - layoutParams.mInsetOffsetX) < rect.left) {
                this.setInsetOffsetX((View)object, rect.left - n2);
                n2 = 1;
            } else {
                n2 = 0;
            }
            n4 = n2;
            if ((n3 & 5) == 5) {
                n3 = this.getWidth() - rect2.right - layoutParams.rightMargin + layoutParams.mInsetOffsetX;
                n4 = n2;
                if (n3 < rect.right) {
                    this.setInsetOffsetX((View)object, n3 - rect.right);
                    n4 = 1;
                }
            }
            if (n4 == 0) {
                this.setInsetOffsetX((View)object, 0);
            }
            CoordinatorLayout.releaseTempRect(rect2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Behavior parseBehavior(Context object, AttributeSet attributeSet, String hashMap) {
        Object object2;
        if (TextUtils.isEmpty(hashMap)) {
            return null;
        }
        if (((String)((Object)hashMap)).startsWith(".")) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(object.getPackageName());
            ((StringBuilder)object2).append((String)((Object)hashMap));
            object2 = ((StringBuilder)object2).toString();
        } else if (((String)((Object)hashMap)).indexOf(46) >= 0) {
            object2 = hashMap;
        } else {
            object2 = hashMap;
            if (!TextUtils.isEmpty((CharSequence)WIDGET_PACKAGE_NAME)) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(WIDGET_PACKAGE_NAME);
                ((StringBuilder)object2).append('.');
                ((StringBuilder)object2).append((String)((Object)hashMap));
                object2 = ((StringBuilder)object2).toString();
            }
        }
        try {
            Constructor<?> constructor = sConstructors.get();
            hashMap = constructor;
            if (constructor == null) {
                hashMap = new HashMap();
                sConstructors.set(hashMap);
            }
            Constructor<Object> constructor2 = hashMap.get(object2);
            constructor = constructor2;
            if (constructor2 == null) {
                constructor = object.getClassLoader().loadClass((String)object2).getConstructor(CONSTRUCTOR_PARAMS);
                constructor.setAccessible(true);
                hashMap.put(object2, constructor);
            }
            return (Behavior)constructor.newInstance(object, attributeSet);
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Could not inflate Behavior subclass ");
            ((StringBuilder)object).append((String)object2);
            throw new RuntimeException(((StringBuilder)object).toString(), exception);
        }
    }

    private boolean performIntercept(MotionEvent motionEvent, int n2) {
        boolean bl;
        int n3 = motionEvent.getActionMasked();
        List<View> list = this.mTempList1;
        this.getTopSortedChildren(list);
        int n4 = list.size();
        LayoutParams layoutParams = null;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (true) {
            bl = bl2;
            if (n5 >= n4) break;
            View view = list.get(n5);
            LayoutParams layoutParams2 = (LayoutParams)view.getLayoutParams();
            Behavior behavior = layoutParams2.getBehavior();
            boolean bl4 = true;
            if ((bl2 || bl3) && n3 != 0) {
                bl = bl2;
                bl4 = bl3;
                layoutParams2 = layoutParams;
                if (behavior != null) {
                    layoutParams2 = layoutParams;
                    if (layoutParams == null) {
                        long l2 = SystemClock.uptimeMillis();
                        layoutParams2 = MotionEvent.obtain((long)l2, (long)l2, (int)3, (float)0.0f, (float)0.0f, (int)0);
                    }
                    if (n2 != 0) {
                        if (n2 != 1) {
                            bl = bl2;
                            bl4 = bl3;
                        } else {
                            behavior.onTouchEvent(this, view, (MotionEvent)layoutParams2);
                            bl = bl2;
                            bl4 = bl3;
                        }
                    } else {
                        behavior.onInterceptTouchEvent(this, view, (MotionEvent)layoutParams2);
                        bl = bl2;
                        bl4 = bl3;
                    }
                }
            } else {
                bl = bl2;
                if (!bl2) {
                    bl = bl2;
                    if (behavior != null) {
                        if (n2 != 0) {
                            if (n2 == 1) {
                                bl2 = behavior.onTouchEvent(this, view, motionEvent);
                            }
                        } else {
                            bl2 = behavior.onInterceptTouchEvent(this, view, motionEvent);
                        }
                        bl = bl2;
                        if (bl2) {
                            this.mBehaviorTouchView = view;
                            bl = bl2;
                        }
                    }
                }
                boolean bl5 = layoutParams2.didBlockInteraction();
                bl2 = layoutParams2.isBlockingInteractionBelow(this, view);
                bl3 = bl2 && !bl5 ? bl4 : false;
                if (bl2 && !bl3) break;
                layoutParams2 = layoutParams;
                bl4 = bl3;
            }
            ++n5;
            bl2 = bl;
            bl3 = bl4;
            layoutParams = layoutParams2;
        }
        list.clear();
        return bl;
    }

    private void prepareChildren() {
        this.mDependencySortedChildren.clear();
        this.mChildDag.clear();
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            LayoutParams layoutParams = this.getResolvedLayoutParams(view);
            layoutParams.findAnchorView(this, view);
            this.mChildDag.addNode((Object)view);
            for (int i3 = 0; i3 < n2; ++i3) {
                View view2;
                if (i3 == i2 || !layoutParams.dependsOn(this, view, view2 = this.getChildAt(i3))) continue;
                if (!this.mChildDag.contains((Object)view2)) {
                    this.mChildDag.addNode((Object)view2);
                }
                this.mChildDag.addEdge((Object)view2, (Object)view);
            }
        }
        this.mDependencySortedChildren.addAll(this.mChildDag.getSortedList());
        Collections.reverse(this.mDependencySortedChildren);
    }

    private static void releaseTempRect(Rect rect) {
        rect.setEmpty();
        sRectPool.release((Object)rect);
    }

    private void resetTouchBehaviors(boolean bl) {
        int n2;
        int n3 = this.getChildCount();
        for (n2 = 0; n2 < n3; ++n2) {
            View view = this.getChildAt(n2);
            Behavior behavior = ((LayoutParams)view.getLayoutParams()).getBehavior();
            if (behavior == null) continue;
            long l2 = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)3, (float)0.0f, (float)0.0f, (int)0);
            if (bl) {
                behavior.onInterceptTouchEvent(this, view, motionEvent);
            } else {
                behavior.onTouchEvent(this, view, motionEvent);
            }
            motionEvent.recycle();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            ((LayoutParams)this.getChildAt(n2).getLayoutParams()).resetTouchBehaviorTracking();
        }
        this.mBehaviorTouchView = null;
        this.mDisallowInterceptReset = false;
    }

    private static int resolveAnchoredChildGravity(int n2) {
        int n3 = n2;
        if (n2 == 0) {
            n3 = 17;
        }
        return n3;
    }

    private static int resolveGravity(int n2) {
        int n3 = n2;
        if ((n2 & 7) == 0) {
            n3 = n2 | 0x800003;
        }
        n2 = n3;
        if ((n3 & 0x70) == 0) {
            n2 = n3 | 0x30;
        }
        return n2;
    }

    private static int resolveKeylineGravity(int n2) {
        int n3 = n2;
        if (n2 == 0) {
            n3 = 8388661;
        }
        return n3;
    }

    private void setInsetOffsetX(View view, int n2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams.mInsetOffsetX != n2) {
            ViewCompat.offsetLeftAndRight(view, n2 - layoutParams.mInsetOffsetX);
            layoutParams.mInsetOffsetX = n2;
        }
    }

    private void setInsetOffsetY(View view, int n2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams.mInsetOffsetY != n2) {
            ViewCompat.offsetTopAndBottom(view, n2 - layoutParams.mInsetOffsetY);
            layoutParams.mInsetOffsetY = n2;
        }
    }

    private void setupForInsets() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            if (this.mApplyWindowInsetsListener == null) {
                this.mApplyWindowInsetsListener = new OnApplyWindowInsetsListener(){

                    public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
                        return CoordinatorLayout.this.setWindowInsets(windowInsetsCompat);
                    }
                };
            }
            ViewCompat.setOnApplyWindowInsetsListener((View)this, this.mApplyWindowInsetsListener);
            this.setSystemUiVisibility(1280);
        } else {
            ViewCompat.setOnApplyWindowInsetsListener((View)this, null);
        }
    }

    void addPreDrawListener() {
        if (this.mIsAttachedToWindow) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new OnPreDrawListener();
            }
            this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = true;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        boolean bl = layoutParams instanceof LayoutParams && super.checkLayoutParams(layoutParams);
        return bl;
    }

    public void dispatchDependentViewsChanged(View view) {
        List list = this.mChildDag.getIncomingEdges((Object)view);
        if (list != null && !list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                View view2 = (View)list.get(i2);
                Behavior behavior = ((LayoutParams)view2.getLayoutParams()).getBehavior();
                if (behavior == null) continue;
                behavior.onDependentViewChanged(this, view2, view);
            }
        }
    }

    public boolean doViewsOverlap(View view, View view2) {
        int n2 = view.getVisibility();
        boolean bl = false;
        if (n2 == 0 && view2.getVisibility() == 0) {
            boolean bl2;
            Rect rect;
            block5: {
                rect = CoordinatorLayout.acquireTempRect();
                bl2 = view.getParent() != this;
                this.getChildRect(view, bl2, rect);
                view = CoordinatorLayout.acquireTempRect();
                bl2 = view2.getParent() != this;
                this.getChildRect(view2, bl2, (Rect)view);
                bl2 = bl;
                try {
                    if (rect.left > view.right) break block5;
                    bl2 = bl;
                }
                catch (Throwable throwable) {
                    CoordinatorLayout.releaseTempRect(rect);
                    CoordinatorLayout.releaseTempRect((Rect)view);
                    throw throwable;
                }
                if (rect.top > view.bottom) break block5;
                bl2 = bl;
                if (rect.right < view.left) break block5;
                int n3 = rect.bottom;
                n2 = view.top;
                bl2 = bl;
                if (n3 < n2) break block5;
                bl2 = true;
            }
            CoordinatorLayout.releaseTempRect(rect);
            CoordinatorLayout.releaseTempRect((Rect)view);
            return bl2;
        }
        return false;
    }

    protected boolean drawChild(Canvas canvas, View view, long l2) {
        float f2;
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams.mBehavior != null && (f2 = layoutParams.mBehavior.getScrimOpacity(this, view)) > 0.0f) {
            if (this.mScrimPaint == null) {
                this.mScrimPaint = new Paint();
            }
            this.mScrimPaint.setColor(layoutParams.mBehavior.getScrimColor(this, view));
            this.mScrimPaint.setAlpha(CoordinatorLayout.clamp(Math.round(f2 * 255.0f), 0, 255));
            int n2 = canvas.save();
            if (view.isOpaque()) {
                canvas.clipRect((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom(), Region.Op.DIFFERENCE);
            }
            canvas.drawRect((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()), this.mScrimPaint);
            canvas.restoreToCount(n2);
        }
        return super.drawChild(canvas, view, l2);
    }

    protected void drawableStateChanged() {
        boolean bl;
        super.drawableStateChanged();
        int[] nArray = this.getDrawableState();
        Drawable drawable2 = this.mStatusBarBackground;
        boolean bl2 = bl = false;
        if (drawable2 != null) {
            bl2 = bl;
            if (drawable2.isStateful()) {
                bl2 = false | drawable2.setState(nArray);
            }
        }
        if (bl2) {
            this.invalidate();
        }
    }

    void ensurePreDrawListener() {
        boolean bl;
        int n2 = this.getChildCount();
        boolean bl2 = false;
        int n3 = 0;
        while (true) {
            bl = bl2;
            if (n3 >= n2) break;
            if (this.hasDependencies(this.getChildAt(n3))) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (bl != this.mNeedsPreDrawListener) {
            if (bl) {
                this.addPreDrawListener();
            } else {
                this.removePreDrawListener();
            }
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    void getChildRect(View view, boolean bl, Rect rect) {
        if (!view.isLayoutRequested() && view.getVisibility() != 8) {
            if (bl) {
                this.getDescendantRect(view, rect);
            } else {
                rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            }
            return;
        }
        rect.setEmpty();
    }

    public List<View> getDependencies(View object) {
        object = this.mChildDag.getOutgoingEdges(object);
        this.mTempDependenciesList.clear();
        if (object != null) {
            this.mTempDependenciesList.addAll((Collection<View>)object);
        }
        return this.mTempDependenciesList;
    }

    final List<View> getDependencySortedChildren() {
        this.prepareChildren();
        return Collections.unmodifiableList(this.mDependencySortedChildren);
    }

    public List<View> getDependents(View object) {
        object = this.mChildDag.getIncomingEdges(object);
        this.mTempDependenciesList.clear();
        if (object != null) {
            this.mTempDependenciesList.addAll((Collection<View>)object);
        }
        return this.mTempDependenciesList;
    }

    void getDescendantRect(View view, Rect rect) {
        ViewGroupUtils.getDescendantRect((ViewGroup)this, (View)view, (Rect)rect);
    }

    void getDesiredAnchoredChildRect(View view, int n2, Rect rect, Rect rect2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n3 = view.getMeasuredWidth();
        int n4 = view.getMeasuredHeight();
        this.getDesiredAnchoredChildRectWithoutConstraints(view, n2, rect, rect2, layoutParams, n3, n4);
        this.constrainChildRect(layoutParams, rect2, n3, n4);
    }

    void getLastChildRect(View view, Rect rect) {
        rect.set(((LayoutParams)view.getLayoutParams()).getLastChildRect());
    }

    public final WindowInsetsCompat getLastWindowInsets() {
        return this.mLastInsets;
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    LayoutParams getResolvedLayoutParams(View object) {
        LayoutParams layoutParams = (LayoutParams)object.getLayoutParams();
        if (!layoutParams.mBehaviorResolved) {
            if (object instanceof AttachedBehavior) {
                if ((object = ((AttachedBehavior)object).getBehavior()) == null) {
                    Log.e((String)TAG, (String)"Attached behavior class is null");
                }
                layoutParams.setBehavior((Behavior)object);
                layoutParams.mBehaviorResolved = true;
            } else {
                Object object2;
                Class<?> clazz = object.getClass();
                object = null;
                while (clazz != null) {
                    object = object2 = clazz.getAnnotation(DefaultBehavior.class);
                    if (object2 != null) break;
                    clazz = clazz.getSuperclass();
                    object = object2;
                }
                if (object != null) {
                    try {
                        layoutParams.setBehavior(object.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Exception exception) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Default behavior class ");
                        ((StringBuilder)object2).append(object.value().getName());
                        ((StringBuilder)object2).append(" could not be instantiated. Did you forget");
                        ((StringBuilder)object2).append(" a default constructor?");
                        Log.e((String)TAG, (String)((StringBuilder)object2).toString(), (Throwable)exception);
                    }
                }
                layoutParams.mBehaviorResolved = true;
            }
        }
        return layoutParams;
    }

    public Drawable getStatusBarBackground() {
        return this.mStatusBarBackground;
    }

    protected int getSuggestedMinimumHeight() {
        return Math.max(super.getSuggestedMinimumHeight(), this.getPaddingTop() + this.getPaddingBottom());
    }

    protected int getSuggestedMinimumWidth() {
        return Math.max(super.getSuggestedMinimumWidth(), this.getPaddingLeft() + this.getPaddingRight());
    }

    public boolean isPointInChildBounds(View view, int n2, int n3) {
        Rect rect = CoordinatorLayout.acquireTempRect();
        this.getDescendantRect(view, rect);
        try {
            boolean bl = rect.contains(n2, n3);
            return bl;
        }
        finally {
            CoordinatorLayout.releaseTempRect(rect);
        }
    }

    void offsetChildToAnchor(View view, int n2) {
        block6: {
            Behavior behavior;
            int n3;
            int n4;
            int n5;
            Rect rect;
            Rect rect2;
            Rect rect3;
            LayoutParams layoutParams;
            block8: {
                block7: {
                    layoutParams = (LayoutParams)view.getLayoutParams();
                    if (layoutParams.mAnchorView == null) break block6;
                    rect3 = CoordinatorLayout.acquireTempRect();
                    rect2 = CoordinatorLayout.acquireTempRect();
                    rect = CoordinatorLayout.acquireTempRect();
                    this.getDescendantRect(layoutParams.mAnchorView, rect3);
                    n5 = 0;
                    this.getChildRect(view, false, rect2);
                    n4 = view.getMeasuredWidth();
                    n3 = view.getMeasuredHeight();
                    this.getDesiredAnchoredChildRectWithoutConstraints(view, n2, rect3, rect, layoutParams, n4, n3);
                    if (rect.left != rect2.left) break block7;
                    n2 = n5;
                    if (rect.top == rect2.top) break block8;
                }
                n2 = 1;
            }
            this.constrainChildRect(layoutParams, rect, n4, n3);
            n3 = rect.left - rect2.left;
            n5 = rect.top - rect2.top;
            if (n3 != 0) {
                ViewCompat.offsetLeftAndRight(view, n3);
            }
            if (n5 != 0) {
                ViewCompat.offsetTopAndBottom(view, n5);
            }
            if (n2 != 0 && (behavior = layoutParams.getBehavior()) != null) {
                behavior.onDependentViewChanged(this, view, layoutParams.mAnchorView);
            }
            CoordinatorLayout.releaseTempRect(rect3);
            CoordinatorLayout.releaseTempRect(rect2);
            CoordinatorLayout.releaseTempRect(rect);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.resetTouchBehaviors(false);
        if (this.mNeedsPreDrawListener) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new OnPreDrawListener();
            }
            this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        if (this.mLastInsets == null && ViewCompat.getFitsSystemWindows((View)this)) {
            ViewCompat.requestApplyInsets((View)this);
        }
        this.mIsAttachedToWindow = true;
    }

    final void onChildViewsChanged(int n2) {
        int n3 = ViewCompat.getLayoutDirection((View)this);
        int n4 = this.mDependencySortedChildren.size();
        Rect rect = CoordinatorLayout.acquireTempRect();
        Rect rect2 = CoordinatorLayout.acquireTempRect();
        Rect rect3 = CoordinatorLayout.acquireTempRect();
        for (int i2 = 0; i2 < n4; ++i2) {
            Object object;
            int n5;
            View view = this.mDependencySortedChildren.get(i2);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (n2 == 0 && view.getVisibility() == 8) continue;
            for (n5 = 0; n5 < i2; ++n5) {
                object = this.mDependencySortedChildren.get(n5);
                if (layoutParams.mAnchorDirectChild != object) continue;
                this.offsetChildToAnchor(view, n3);
            }
            this.getChildRect(view, true, rect2);
            if (layoutParams.insetEdge != 0 && !rect2.isEmpty()) {
                int n6 = GravityCompat.getAbsoluteGravity((int)layoutParams.insetEdge, (int)n3);
                n5 = n6 & 0x70;
                if (n5 != 48) {
                    if (n5 == 80) {
                        rect.bottom = Math.max(rect.bottom, this.getHeight() - rect2.top);
                    }
                } else {
                    rect.top = Math.max(rect.top, rect2.bottom);
                }
                n5 = n6 & 7;
                if (n5 != 3) {
                    if (n5 == 5) {
                        rect.right = Math.max(rect.right, this.getWidth() - rect2.left);
                    }
                } else {
                    rect.left = Math.max(rect.left, rect2.right);
                }
            }
            if (layoutParams.dodgeInsetEdges != 0 && view.getVisibility() == 0) {
                this.offsetChildByInset(view, rect, n3);
            }
            if (n2 != 2) {
                this.getLastChildRect(view, rect3);
                if (rect3.equals((Object)rect2)) continue;
                this.recordLastChildRect(view, rect2);
            }
            for (n5 = i2 + 1; n5 < n4; ++n5) {
                boolean bl;
                layoutParams = this.mDependencySortedChildren.get(n5);
                object = (LayoutParams)layoutParams.getLayoutParams();
                Behavior behavior = object.getBehavior();
                if (behavior == null || !behavior.layoutDependsOn(this, layoutParams, view)) continue;
                if (n2 == 0 && object.getChangedAfterNestedScroll()) {
                    object.resetChangedAfterNestedScroll();
                    continue;
                }
                if (n2 != 2) {
                    bl = behavior.onDependentViewChanged(this, layoutParams, view);
                } else {
                    behavior.onDependentViewRemoved(this, layoutParams, view);
                    bl = true;
                }
                if (n2 != 1) continue;
                object.setChangedAfterNestedScroll(bl);
            }
        }
        CoordinatorLayout.releaseTempRect(rect);
        CoordinatorLayout.releaseTempRect(rect2);
        CoordinatorLayout.releaseTempRect(rect3);
    }

    public void onDetachedFromWindow() {
        View view;
        super.onDetachedFromWindow();
        this.resetTouchBehaviors(false);
        if (this.mNeedsPreDrawListener && this.mOnPreDrawListener != null) {
            this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        if ((view = this.mNestedScrollingTarget) != null) {
            this.onStopNestedScroll(view);
        }
        this.mIsAttachedToWindow = false;
    }

    public void onDraw(Canvas canvas) {
        WindowInsetsCompat windowInsetsCompat;
        int n2;
        super.onDraw(canvas);
        if (this.mDrawStatusBarBackground && this.mStatusBarBackground != null && (n2 = (windowInsetsCompat = this.mLastInsets) != null ? windowInsetsCompat.getSystemWindowInsetTop() : 0) > 0) {
            this.mStatusBarBackground.setBounds(0, 0, this.getWidth(), n2);
            this.mStatusBarBackground.draw(canvas);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getActionMasked();
        if (n2 == 0) {
            this.resetTouchBehaviors(true);
        }
        boolean bl = this.performIntercept(motionEvent, 0);
        if (n2 == 1 || n2 == 3) {
            this.resetTouchBehaviors(true);
        }
        return bl;
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        n3 = ViewCompat.getLayoutDirection((View)this);
        n4 = this.mDependencySortedChildren.size();
        for (n2 = 0; n2 < n4; ++n2) {
            Behavior behavior;
            View view = this.mDependencySortedChildren.get(n2);
            if (view.getVisibility() == 8 || (behavior = ((LayoutParams)view.getLayoutParams()).getBehavior()) != null && behavior.onLayoutChild(this, view, n3)) continue;
            this.onLayoutChild(view, n3);
        }
    }

    public void onLayoutChild(View view, int n2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (!layoutParams.checkAnchorChanged()) {
            if (layoutParams.mAnchorView != null) {
                this.layoutChildWithAnchor(view, layoutParams.mAnchorView, n2);
            } else if (layoutParams.keyline >= 0) {
                this.layoutChildWithKeyline(view, layoutParams.keyline, n2);
            } else {
                this.layoutChild(view, n2);
            }
            return;
        }
        throw new IllegalStateException("An anchor may not be changed after CoordinatorLayout measurement begins before layout is complete.");
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        this.prepareChildren();
        this.ensurePreDrawListener();
        var3_3 = this.getPaddingLeft();
        var4_4 = this.getPaddingTop();
        var5_5 = this.getPaddingRight();
        var6_6 = this.getPaddingBottom();
        var7_7 = ViewCompat.getLayoutDirection((View)this);
        var8_8 = var7_7 == 1;
        var9_9 = View.MeasureSpec.getMode((int)var1_1);
        var10_10 = View.MeasureSpec.getSize((int)var1_1);
        var11_11 = View.MeasureSpec.getMode((int)var2_2);
        var12_12 = View.MeasureSpec.getSize((int)var2_2);
        var13_13 = this.getSuggestedMinimumWidth();
        var14_14 = this.getSuggestedMinimumHeight();
        var15_15 = this.mLastInsets != null && ViewCompat.getFitsSystemWindows((View)this) != false;
        var16_16 = this.mDependencySortedChildren.size();
        var17_17 = 0;
        for (var18_18 = 0; var18_18 < var16_16; ++var18_18) {
            var19_19 = this.mDependencySortedChildren.get(var18_18);
            if (var19_19.getVisibility() == 8) continue;
            var20_20 = (LayoutParams)var19_19.getLayoutParams();
            if (var20_20.keyline < 0 || var9_9 == 0) ** GOTO lbl-1000
            var21_21 = this.getKeyline(var20_20.keyline);
            var22_22 = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveKeylineGravity(var20_20.gravity), (int)var7_7) & 7;
            if (var22_22 == 3 && !var8_8 || var22_22 == 5 && var8_8) {
                var21_21 = Math.max(0, var10_10 - var5_5 - var21_21);
            } else if (var22_22 == 5 && !var8_8 || var22_22 == 3 && var8_8) {
                var21_21 = Math.max(0, var21_21 - var3_3);
            } else lbl-1000:
            // 2 sources

            {
                var21_21 = 0;
            }
            var23_23 = var14_14;
            if (var15_15 && !ViewCompat.getFitsSystemWindows(var19_19)) {
                var24_24 = this.mLastInsets.getSystemWindowInsetLeft();
                var14_14 = this.mLastInsets.getSystemWindowInsetRight();
                var22_22 = this.mLastInsets.getSystemWindowInsetTop();
                var25_25 = this.mLastInsets.getSystemWindowInsetBottom();
                var14_14 = View.MeasureSpec.makeMeasureSpec((int)(var10_10 - (var24_24 + var14_14)), (int)var9_9);
                var22_22 = View.MeasureSpec.makeMeasureSpec((int)(var12_12 - (var22_22 + var25_25)), (int)var11_11);
                var25_25 = var14_14;
                var14_14 = var22_22;
            } else {
                var25_25 = var1_1;
                var14_14 = var2_2;
            }
            var26_26 = var20_20.getBehavior();
            if (var26_26 == null || !var26_26.onMeasureChild(this, var19_19, var25_25, var21_21, var14_14, 0)) {
                this.onMeasureChild(var19_19, var25_25, var21_21, var14_14, 0);
            }
            var13_13 = Math.max(var13_13, var3_3 + var5_5 + var19_19.getMeasuredWidth() + var20_20.leftMargin + var20_20.rightMargin);
            var14_14 = Math.max(var23_23, var4_4 + var6_6 + var19_19.getMeasuredHeight() + var20_20.topMargin + var20_20.bottomMargin);
            var17_17 = View.combineMeasuredStates((int)var17_17, (int)var19_19.getMeasuredState());
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)var13_13, (int)var1_1, (int)(-16777216 & var17_17)), View.resolveSizeAndState((int)var14_14, (int)var2_2, (int)(var17_17 << 16)));
    }

    public void onMeasureChild(View view, int n2, int n3, int n4, int n5) {
        this.measureChildWithMargins(view, n2, n3, n4, n5);
    }

    public boolean onNestedFling(View view, float f2, float f3, boolean bl) {
        int n2 = this.getChildCount();
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl3;
            View view2 = this.getChildAt(i2);
            if (view2.getVisibility() == 8) {
                bl3 = bl2;
            } else {
                Object object = (LayoutParams)view2.getLayoutParams();
                if (!object.isNestedScrollAccepted(0)) {
                    bl3 = bl2;
                } else {
                    object = object.getBehavior();
                    bl3 = bl2;
                    if (object != null) {
                        bl3 = bl2 | ((Behavior)object).onNestedFling(this, view2, view, f2, f3, bl);
                    }
                }
            }
            bl2 = bl3;
        }
        if (bl2) {
            this.onChildViewsChanged(1);
        }
        return bl2;
    }

    public boolean onNestedPreFling(View view, float f2, float f3) {
        int n2 = this.getChildCount();
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            View view2 = this.getChildAt(i2);
            if (view2.getVisibility() == 8) {
                bl2 = bl;
            } else {
                Object object = (LayoutParams)view2.getLayoutParams();
                if (!object.isNestedScrollAccepted(0)) {
                    bl2 = bl;
                } else {
                    object = object.getBehavior();
                    bl2 = bl;
                    if (object != null) {
                        bl2 = bl | ((Behavior)object).onNestedPreFling(this, view2, view, f2, f3);
                    }
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public void onNestedPreScroll(View view, int n2, int n3, int[] nArray) {
        this.onNestedPreScroll(view, n2, n3, nArray, 0);
    }

    public void onNestedPreScroll(View view, int n2, int n3, int[] nArray, int n4) {
        int n5 = this.getChildCount();
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8;
            int n9;
            Object object = this.getChildAt(i2);
            if (object.getVisibility() == 8) {
                n9 = n6;
                n8 = n7;
            } else {
                Object object2 = (LayoutParams)object.getLayoutParams();
                if (!object2.isNestedScrollAccepted(n4)) {
                    n9 = n6;
                    n8 = n7;
                } else {
                    Behavior behavior = object2.getBehavior();
                    n9 = n6;
                    n8 = n7;
                    if (behavior != null) {
                        object2 = this.mTempIntPair;
                        object2[1] = (LayoutParams)false;
                        object2[0] = (LayoutParams)false;
                        behavior.onNestedPreScroll(this, object, view, n2, n3, (int[])object2, n4);
                        object = this.mTempIntPair;
                        n8 = n2 > 0 ? Math.max(n6, (int)object[0]) : Math.min(n6, (int)object[0]);
                        object = this.mTempIntPair;
                        n7 = n3 > 0 ? Math.max(n7, (int)object[1]) : Math.min(n7, (int)object[1]);
                        n9 = n8;
                        n8 = n7;
                        bl = true;
                    }
                }
            }
            n6 = n9;
            n7 = n8;
        }
        nArray[0] = n6;
        nArray[1] = n7;
        if (bl) {
            this.onChildViewsChanged(1);
        }
    }

    public void onNestedScroll(View view, int n2, int n3, int n4, int n5) {
        this.onNestedScroll(view, n2, n3, n4, n5, 0);
    }

    public void onNestedScroll(View view, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getChildCount();
        boolean bl = false;
        for (int i2 = 0; i2 < n7; ++i2) {
            Object object;
            View view2 = this.getChildAt(i2);
            if (view2.getVisibility() == 8 || !((LayoutParams)((Object)(object = (LayoutParams)view2.getLayoutParams()))).isNestedScrollAccepted(n6) || (object = ((LayoutParams)((Object)object)).getBehavior()) == null) continue;
            ((Behavior)object).onNestedScroll(this, view2, view, n2, n3, n4, n5, n6);
            bl = true;
        }
        if (bl) {
            this.onChildViewsChanged(1);
        }
    }

    public void onNestedScrollAccepted(View view, View view2, int n2) {
        this.onNestedScrollAccepted(view, view2, n2, 0);
    }

    public void onNestedScrollAccepted(View view, View view2, int n2, int n3) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(view, view2, n2, n3);
        this.mNestedScrollingTarget = view2;
        int n4 = this.getChildCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            View view3 = this.getChildAt(i2);
            Object object = (LayoutParams)view3.getLayoutParams();
            if (!object.isNestedScrollAccepted(n3) || (object = object.getBehavior()) == null) continue;
            ((Behavior)object).onNestedScrollAccepted(this, view3, view, view2, n2, n3);
        }
    }

    protected void onRestoreInstanceState(Parcelable sparseArray) {
        if (!(sparseArray instanceof SavedState)) {
            super.onRestoreInstanceState((Parcelable)sparseArray);
            return;
        }
        sparseArray = (SavedState)sparseArray;
        super.onRestoreInstanceState(sparseArray.getSuperState());
        sparseArray = sparseArray.behaviorStates;
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Parcelable parcelable;
            View view = this.getChildAt(i2);
            int n3 = view.getId();
            Behavior behavior = this.getResolvedLayoutParams(view).getBehavior();
            if (n3 == -1 || behavior == null || (parcelable = (Parcelable)sparseArray.get(n3)) == null) continue;
            behavior.onRestoreInstanceState(this, view, parcelable);
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        SparseArray sparseArray = new SparseArray();
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            int n3 = view.getId();
            Behavior behavior = ((LayoutParams)view.getLayoutParams()).getBehavior();
            if (n3 == -1 || behavior == null || (view = behavior.onSaveInstanceState(this, view)) == null) continue;
            sparseArray.append(n3, (Object)view);
        }
        savedState.behaviorStates = sparseArray;
        return savedState;
    }

    public boolean onStartNestedScroll(View view, View view2, int n2) {
        return this.onStartNestedScroll(view, view2, n2, 0);
    }

    public boolean onStartNestedScroll(View view, View view2, int n2, int n3) {
        int n4 = this.getChildCount();
        boolean bl = false;
        for (int i2 = 0; i2 < n4; ++i2) {
            View view3 = this.getChildAt(i2);
            if (view3.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view3.getLayoutParams();
            Behavior behavior = layoutParams.getBehavior();
            if (behavior != null) {
                boolean bl2 = behavior.onStartNestedScroll(this, view3, view, view2, n2, n3);
                layoutParams.setNestedScrollAccepted(n3, bl2);
                bl |= bl2;
                continue;
            }
            layoutParams.setNestedScrollAccepted(n3, false);
        }
        return bl;
    }

    public void onStopNestedScroll(View view) {
        this.onStopNestedScroll(view, 0);
    }

    public void onStopNestedScroll(View view, int n2) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(view, n2);
        int n3 = this.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            View view2 = this.getChildAt(i2);
            LayoutParams layoutParams = (LayoutParams)view2.getLayoutParams();
            if (!layoutParams.isNestedScrollAccepted(n2)) continue;
            Behavior behavior = layoutParams.getBehavior();
            if (behavior != null) {
                behavior.onStopNestedScroll(this, view2, view, n2);
            }
            layoutParams.resetNestedScroll(n2);
            layoutParams.resetChangedAfterNestedScroll();
        }
        this.mNestedScrollingTarget = null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block8: {
            block7: {
                var2_2 = var1_1 /* !! */ .getActionMasked();
                if (this.mBehaviorTouchView != null) break block7;
                var4_4 = var3_3 = this.performIntercept(var1_1 /* !! */ , 1);
                if (!var3_3) ** GOTO lbl-1000
                break block8;
            }
            var3_3 = false;
        }
        var5_5 = ((LayoutParams)this.mBehaviorTouchView.getLayoutParams()).getBehavior();
        var4_4 = var3_3;
        if (var5_5 != null) {
            var6_6 = var5_5.onTouchEvent(this, this.mBehaviorTouchView, var1_1 /* !! */ );
            var4_4 = var3_3;
            var3_3 = var6_6;
        } else lbl-1000:
        // 2 sources

        {
            var3_3 = false;
        }
        var7_7 = this.mBehaviorTouchView;
        var5_5 = null;
        if (var7_7 == null) {
            var6_6 = var3_3 | super.onTouchEvent(var1_1 /* !! */ );
            var1_1 /* !! */  = var5_5;
        } else {
            var6_6 = var3_3;
            var1_1 /* !! */  = var5_5;
            if (var4_4) {
                var8_8 = SystemClock.uptimeMillis();
                var1_1 /* !! */  = MotionEvent.obtain((long)var8_8, (long)var8_8, (int)3, (float)0.0f, (float)0.0f, (int)0);
                super.onTouchEvent(var1_1 /* !! */ );
                var6_6 = var3_3;
            }
        }
        if (var1_1 /* !! */  != null) {
            var1_1 /* !! */ .recycle();
        }
        if (var2_2 == 1 || var2_2 == 3) {
            this.resetTouchBehaviors(false);
        }
        return var6_6;
    }

    void recordLastChildRect(View view, Rect rect) {
        ((LayoutParams)view.getLayoutParams()).setLastChildRect(rect);
    }

    void removePreDrawListener() {
        if (this.mIsAttachedToWindow && this.mOnPreDrawListener != null) {
            this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = false;
    }

    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        Behavior behavior = ((LayoutParams)view.getLayoutParams()).getBehavior();
        if (behavior != null && behavior.onRequestChildRectangleOnScreen(this, view, rect, bl)) {
            return true;
        }
        return super.requestChildRectangleOnScreen(view, rect, bl);
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
        super.requestDisallowInterceptTouchEvent(bl);
        if (bl && !this.mDisallowInterceptReset) {
            this.resetTouchBehaviors(false);
            this.mDisallowInterceptReset = true;
        }
    }

    public void setFitsSystemWindows(boolean bl) {
        super.setFitsSystemWindows(bl);
        this.setupForInsets();
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mOnHierarchyChangeListener = onHierarchyChangeListener;
    }

    public void setStatusBarBackground(Drawable drawable2) {
        Drawable drawable3 = this.mStatusBarBackground;
        if (drawable3 != drawable2) {
            Drawable drawable4 = null;
            if (drawable3 != null) {
                drawable3.setCallback(null);
            }
            if (drawable2 != null) {
                drawable4 = drawable2.mutate();
            }
            if ((drawable2 = (this.mStatusBarBackground = drawable4)) != null) {
                if (drawable2.isStateful()) {
                    this.mStatusBarBackground.setState(this.getDrawableState());
                }
                DrawableCompat.setLayoutDirection((Drawable)this.mStatusBarBackground, (int)ViewCompat.getLayoutDirection((View)this));
                drawable2 = this.mStatusBarBackground;
                boolean bl = this.getVisibility() == 0;
                drawable2.setVisible(bl, false);
                this.mStatusBarBackground.setCallback((Drawable.Callback)this);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setStatusBarBackgroundColor(int n2) {
        this.setStatusBarBackground((Drawable)new ColorDrawable(n2));
    }

    public void setStatusBarBackgroundResource(int n2) {
        Drawable drawable2 = n2 != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)n2) : null;
        this.setStatusBarBackground(drawable2);
    }

    public void setVisibility(int n2) {
        super.setVisibility(n2);
        boolean bl = n2 == 0;
        Drawable drawable2 = this.mStatusBarBackground;
        if (drawable2 != null && drawable2.isVisible() != bl) {
            this.mStatusBarBackground.setVisible(bl, false);
        }
    }

    final WindowInsetsCompat setWindowInsets(WindowInsetsCompat windowInsetsCompat) {
        WindowInsetsCompat windowInsetsCompat2 = windowInsetsCompat;
        if (!ObjectsCompat.equals((Object)this.mLastInsets, (Object)windowInsetsCompat)) {
            this.mLastInsets = windowInsetsCompat;
            boolean bl = true;
            boolean bl2 = windowInsetsCompat != null && windowInsetsCompat.getSystemWindowInsetTop() > 0;
            this.mDrawStatusBarBackground = bl2;
            bl2 = !this.mDrawStatusBarBackground && this.getBackground() == null ? bl : false;
            this.setWillNotDraw(bl2);
            windowInsetsCompat2 = this.dispatchApplyWindowInsetsToBehaviors(windowInsetsCompat);
            this.requestLayout();
        }
        return windowInsetsCompat2;
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        boolean bl = super.verifyDrawable(drawable2) || drawable2 == this.mStatusBarBackground;
        return bl;
    }

    public static interface AttachedBehavior {
        public Behavior getBehavior();
    }

    public static abstract class Behavior<V extends View> {
        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attributeSet) {
        }

        public static Object getTag(View view) {
            return ((LayoutParams)view.getLayoutParams()).mBehaviorTag;
        }

        public static void setTag(View view, Object object) {
            ((LayoutParams)view.getLayoutParams()).mBehaviorTag = object;
        }

        public boolean blocksInteractionBelow(CoordinatorLayout coordinatorLayout, V v2) {
            boolean bl = this.getScrimOpacity(coordinatorLayout, v2) > 0.0f;
            return bl;
        }

        public boolean getInsetDodgeRect(CoordinatorLayout coordinatorLayout, V v2, Rect rect) {
            return false;
        }

        public int getScrimColor(CoordinatorLayout coordinatorLayout, V v2) {
            return -16777216;
        }

        public float getScrimOpacity(CoordinatorLayout coordinatorLayout, V v2) {
            return 0.0f;
        }

        public boolean layoutDependsOn(CoordinatorLayout coordinatorLayout, V v2, View view) {
            return false;
        }

        public WindowInsetsCompat onApplyWindowInsets(CoordinatorLayout coordinatorLayout, V v2, WindowInsetsCompat windowInsetsCompat) {
            return windowInsetsCompat;
        }

        public void onAttachedToLayoutParams(LayoutParams layoutParams) {
        }

        public boolean onDependentViewChanged(CoordinatorLayout coordinatorLayout, V v2, View view) {
            return false;
        }

        public void onDependentViewRemoved(CoordinatorLayout coordinatorLayout, V v2, View view) {
        }

        public void onDetachedFromLayoutParams() {
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, V v2, MotionEvent motionEvent) {
            return false;
        }

        public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, V v2, int n2) {
            return false;
        }

        public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, V v2, int n2, int n3, int n4, int n5) {
            return false;
        }

        public boolean onNestedFling(CoordinatorLayout coordinatorLayout, V v2, View view, float f2, float f3, boolean bl) {
            return false;
        }

        public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V v2, View view, float f2, float f3) {
            return false;
        }

        @Deprecated
        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v2, View view, int n2, int n3, int[] nArray) {
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v2, View view, int n2, int n3, int[] nArray, int n4) {
            if (n4 == 0) {
                this.onNestedPreScroll(coordinatorLayout, v2, view, n2, n3, nArray);
            }
        }

        @Deprecated
        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v2, View view, int n2, int n3, int n4, int n5) {
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v2, View view, int n2, int n3, int n4, int n5, int n6) {
            if (n6 == 0) {
                this.onNestedScroll(coordinatorLayout, v2, view, n2, n3, n4, n5);
            }
        }

        @Deprecated
        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V v2, View view, View view2, int n2) {
        }

        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V v2, View view, View view2, int n2, int n3) {
            if (n3 == 0) {
                this.onNestedScrollAccepted(coordinatorLayout, v2, view, view2, n2);
            }
        }

        public boolean onRequestChildRectangleOnScreen(CoordinatorLayout coordinatorLayout, V v2, Rect rect, boolean bl) {
            return false;
        }

        public void onRestoreInstanceState(CoordinatorLayout coordinatorLayout, V v2, Parcelable parcelable) {
        }

        public Parcelable onSaveInstanceState(CoordinatorLayout coordinatorLayout, V v2) {
            return View.BaseSavedState.EMPTY_STATE;
        }

        @Deprecated
        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v2, View view, View view2, int n2) {
            return false;
        }

        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v2, View view, View view2, int n2, int n3) {
            if (n3 == 0) {
                return this.onStartNestedScroll(coordinatorLayout, v2, view, view2, n2);
            }
            return false;
        }

        @Deprecated
        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v2, View view) {
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v2, View view, int n2) {
            if (n2 == 0) {
                this.onStopNestedScroll(coordinatorLayout, v2, view);
            }
        }

        public boolean onTouchEvent(CoordinatorLayout coordinatorLayout, V v2, MotionEvent motionEvent) {
            return false;
        }
    }

    @Deprecated
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DefaultBehavior {
        public Class<? extends Behavior> value();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DispatchChangeEvent {
    }

    private class HierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        HierarchyChangeListener() {
        }

        public void onChildViewAdded(View view, View view2) {
            if (CoordinatorLayout.this.mOnHierarchyChangeListener != null) {
                CoordinatorLayout.this.mOnHierarchyChangeListener.onChildViewAdded(view, view2);
            }
        }

        public void onChildViewRemoved(View view, View view2) {
            CoordinatorLayout.this.onChildViewsChanged(2);
            if (CoordinatorLayout.this.mOnHierarchyChangeListener != null) {
                CoordinatorLayout.this.mOnHierarchyChangeListener.onChildViewRemoved(view, view2);
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int anchorGravity = 0;
        public int dodgeInsetEdges = 0;
        public int gravity = 0;
        public int insetEdge = 0;
        public int keyline = -1;
        View mAnchorDirectChild;
        int mAnchorId = -1;
        View mAnchorView;
        Behavior mBehavior;
        boolean mBehaviorResolved = false;
        Object mBehaviorTag;
        private boolean mDidAcceptNestedScrollNonTouch;
        private boolean mDidAcceptNestedScrollTouch;
        private boolean mDidBlockInteraction;
        private boolean mDidChangeAfterNestedScroll;
        int mInsetOffsetX;
        int mInsetOffsetY;
        final Rect mLastChildRect = new Rect();

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        LayoutParams(Context object, AttributeSet attributeSet) {
            super((Context)object, attributeSet);
            TypedArray typedArray = object.obtainStyledAttributes(attributeSet, R.styleable.CoordinatorLayout_Layout);
            this.gravity = typedArray.getInteger(R.styleable.CoordinatorLayout_Layout_android_layout_gravity, 0);
            this.mAnchorId = typedArray.getResourceId(R.styleable.CoordinatorLayout_Layout_layout_anchor, -1);
            this.anchorGravity = typedArray.getInteger(R.styleable.CoordinatorLayout_Layout_layout_anchorGravity, 0);
            this.keyline = typedArray.getInteger(R.styleable.CoordinatorLayout_Layout_layout_keyline, -1);
            this.insetEdge = typedArray.getInt(R.styleable.CoordinatorLayout_Layout_layout_insetEdge, 0);
            this.dodgeInsetEdges = typedArray.getInt(R.styleable.CoordinatorLayout_Layout_layout_dodgeInsetEdges, 0);
            this.mBehaviorResolved = typedArray.hasValue(R.styleable.CoordinatorLayout_Layout_layout_behavior);
            if (this.mBehaviorResolved) {
                this.mBehavior = CoordinatorLayout.parseBehavior((Context)object, attributeSet, typedArray.getString(R.styleable.CoordinatorLayout_Layout_layout_behavior));
            }
            typedArray.recycle();
            object = this.mBehavior;
            if (object != null) {
                ((Behavior)object).onAttachedToLayoutParams(this);
            }
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
        }

        private void resolveAnchorView(View object, CoordinatorLayout coordinatorLayout) {
            this.mAnchorView = coordinatorLayout.findViewById(this.mAnchorId);
            View view = this.mAnchorView;
            if (view != null) {
                if (view == coordinatorLayout) {
                    if (coordinatorLayout.isInEditMode()) {
                        this.mAnchorDirectChild = null;
                        this.mAnchorView = null;
                        return;
                    }
                    throw new IllegalStateException("View can not be anchored to the the parent CoordinatorLayout");
                }
                for (ViewParent viewParent = view.getParent(); viewParent != coordinatorLayout && viewParent != null; viewParent = viewParent.getParent()) {
                    if (viewParent == object) {
                        if (coordinatorLayout.isInEditMode()) {
                            this.mAnchorDirectChild = null;
                            this.mAnchorView = null;
                            return;
                        }
                        throw new IllegalStateException("Anchor must not be a descendant of the anchored view");
                    }
                    if (!(viewParent instanceof View)) continue;
                    view = (View)viewParent;
                }
                this.mAnchorDirectChild = view;
                return;
            }
            if (coordinatorLayout.isInEditMode()) {
                this.mAnchorDirectChild = null;
                this.mAnchorView = null;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not find CoordinatorLayout descendant view with id ");
            stringBuilder.append(coordinatorLayout.getResources().getResourceName(this.mAnchorId));
            stringBuilder.append(" to anchor view ");
            stringBuilder.append(object);
            object = new IllegalStateException(stringBuilder.toString());
            throw object;
        }

        private boolean shouldDodge(View view, int n2) {
            int n3 = GravityCompat.getAbsoluteGravity((int)((LayoutParams)view.getLayoutParams()).insetEdge, (int)n2);
            boolean bl = n3 != 0 && (GravityCompat.getAbsoluteGravity((int)this.dodgeInsetEdges, (int)n2) & n3) == n3;
            return bl;
        }

        private boolean verifyAnchorView(View view, CoordinatorLayout coordinatorLayout) {
            if (this.mAnchorView.getId() != this.mAnchorId) {
                return false;
            }
            View view2 = this.mAnchorView;
            for (ViewParent viewParent = view2.getParent(); viewParent != coordinatorLayout; viewParent = viewParent.getParent()) {
                if (viewParent != null && viewParent != view) {
                    if (!(viewParent instanceof View)) continue;
                    view2 = (View)viewParent;
                    continue;
                }
                this.mAnchorDirectChild = null;
                this.mAnchorView = null;
                return false;
            }
            this.mAnchorDirectChild = view2;
            return true;
        }

        boolean checkAnchorChanged() {
            boolean bl = this.mAnchorView == null && this.mAnchorId != -1;
            return bl;
        }

        boolean dependsOn(CoordinatorLayout coordinatorLayout, View view, View view2) {
            Behavior behavior;
            boolean bl = view2 == this.mAnchorDirectChild || this.shouldDodge(view2, ViewCompat.getLayoutDirection((View)coordinatorLayout)) || (behavior = this.mBehavior) != null && behavior.layoutDependsOn(coordinatorLayout, view, view2);
            return bl;
        }

        boolean didBlockInteraction() {
            if (this.mBehavior == null) {
                this.mDidBlockInteraction = false;
            }
            return this.mDidBlockInteraction;
        }

        View findAnchorView(CoordinatorLayout coordinatorLayout, View view) {
            if (this.mAnchorId == -1) {
                this.mAnchorDirectChild = null;
                this.mAnchorView = null;
                return null;
            }
            if (this.mAnchorView == null || !this.verifyAnchorView(view, coordinatorLayout)) {
                this.resolveAnchorView(view, coordinatorLayout);
            }
            return this.mAnchorView;
        }

        public int getAnchorId() {
            return this.mAnchorId;
        }

        public Behavior getBehavior() {
            return this.mBehavior;
        }

        boolean getChangedAfterNestedScroll() {
            return this.mDidChangeAfterNestedScroll;
        }

        Rect getLastChildRect() {
            return this.mLastChildRect;
        }

        void invalidateAnchor() {
            this.mAnchorDirectChild = null;
            this.mAnchorView = null;
        }

        boolean isBlockingInteractionBelow(CoordinatorLayout coordinatorLayout, View view) {
            boolean bl = this.mDidBlockInteraction;
            if (bl) {
                return true;
            }
            Behavior behavior = this.mBehavior;
            boolean bl2 = behavior != null ? behavior.blocksInteractionBelow(coordinatorLayout, view) : false;
            this.mDidBlockInteraction = bl2 |= bl;
            return bl2;
        }

        boolean isNestedScrollAccepted(int n2) {
            if (n2 != 0) {
                if (n2 != 1) {
                    return false;
                }
                return this.mDidAcceptNestedScrollNonTouch;
            }
            return this.mDidAcceptNestedScrollTouch;
        }

        void resetChangedAfterNestedScroll() {
            this.mDidChangeAfterNestedScroll = false;
        }

        void resetNestedScroll(int n2) {
            this.setNestedScrollAccepted(n2, false);
        }

        void resetTouchBehaviorTracking() {
            this.mDidBlockInteraction = false;
        }

        public void setAnchorId(int n2) {
            this.invalidateAnchor();
            this.mAnchorId = n2;
        }

        public void setBehavior(Behavior behavior) {
            Behavior behavior2 = this.mBehavior;
            if (behavior2 != behavior) {
                if (behavior2 != null) {
                    behavior2.onDetachedFromLayoutParams();
                }
                this.mBehavior = behavior;
                this.mBehaviorTag = null;
                this.mBehaviorResolved = true;
                if (behavior != null) {
                    behavior.onAttachedToLayoutParams(this);
                }
            }
        }

        void setChangedAfterNestedScroll(boolean bl) {
            this.mDidChangeAfterNestedScroll = bl;
        }

        void setLastChildRect(Rect rect) {
            this.mLastChildRect.set(rect);
        }

        void setNestedScrollAccepted(int n2, boolean bl) {
            if (n2 != 0) {
                if (n2 == 1) {
                    this.mDidAcceptNestedScrollNonTouch = bl;
                }
            } else {
                this.mDidAcceptNestedScrollTouch = bl;
            }
        }
    }

    class OnPreDrawListener
    implements ViewTreeObserver.OnPreDrawListener {
        OnPreDrawListener() {
        }

        public boolean onPreDraw() {
            CoordinatorLayout.this.onChildViewsChanged(0);
            return true;
        }
    }

    protected static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        SparseArray<Parcelable> behaviorStates;

        public SavedState(Parcel parcelableArray, ClassLoader classLoader) {
            super((Parcel)parcelableArray, classLoader);
            int n2 = parcelableArray.readInt();
            int[] nArray = new int[n2];
            parcelableArray.readIntArray(nArray);
            parcelableArray = parcelableArray.readParcelableArray(classLoader);
            this.behaviorStates = new SparseArray(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.behaviorStates.append(nArray[i2], (Object)parcelableArray[i2]);
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            Parcelable[] parcelableArray = this.behaviorStates;
            int n3 = parcelableArray != null ? parcelableArray.size() : 0;
            parcel.writeInt(n3);
            int[] nArray = new int[n3];
            parcelableArray = new Parcelable[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                nArray[i2] = this.behaviorStates.keyAt(i2);
                parcelableArray[i2] = (Parcelable)this.behaviorStates.valueAt(i2);
            }
            parcel.writeIntArray(nArray);
            parcel.writeParcelableArray(parcelableArray, n2);
        }
    }

    static class ViewElevationComparator
    implements Comparator<View> {
        ViewElevationComparator() {
        }

        @Override
        public int compare(View view, View view2) {
            float f2;
            float f3 = ViewCompat.getZ(view);
            if (f3 > (f2 = ViewCompat.getZ(view2))) {
                return -1;
            }
            if (f3 < f2) {
                return 1;
            }
            return 0;
        }
    }
}

