/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.ContainerHelpers;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

abstract class MapCollections<K, V> {
    EntrySet mEntrySet;
    KeySet mKeySet;
    ValuesCollection mValues;

    MapCollections() {
    }

    public static <K, V> boolean containsAllHelper(Map<K, V> map, Collection<?> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (map.containsKey(object.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> boolean equalsSetHelper(Set<T> set, Object object) {
        boolean bl = true;
        if (set == object) {
            return true;
        }
        if (!(object instanceof Set)) return false;
        object = (Set)object;
        try {
            if (set.size() != object.size()) return false;
            boolean bl2 = set.containsAll((Collection<?>)object);
            if (!bl2) return false;
            return bl;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    public static <K, V> boolean removeAllHelper(Map<K, V> map, Collection<?> object) {
        int n2 = map.size();
        object = object.iterator();
        while (object.hasNext()) {
            map.remove(object.next());
        }
        boolean bl = n2 != map.size();
        return bl;
    }

    public static <K, V> boolean retainAllHelper(Map<K, V> map, Collection<?> collection) {
        int n2 = map.size();
        Iterator<K> iterator2 = map.keySet().iterator();
        while (iterator2.hasNext()) {
            if (collection.contains(iterator2.next())) continue;
            iterator2.remove();
        }
        boolean bl = n2 != map.size();
        return bl;
    }

    protected abstract void colClear();

    protected abstract Object colGetEntry(int var1, int var2);

    protected abstract Map<K, V> colGetMap();

    protected abstract int colGetSize();

    protected abstract int colIndexOfKey(Object var1);

    protected abstract int colIndexOfValue(Object var1);

    protected abstract void colPut(K var1, V var2);

    protected abstract void colRemoveAt(int var1);

    protected abstract V colSetValue(int var1, V var2);

    public Set<Map.Entry<K, V>> getEntrySet() {
        if (this.mEntrySet == null) {
            this.mEntrySet = new EntrySet();
        }
        return this.mEntrySet;
    }

    public Set<K> getKeySet() {
        if (this.mKeySet == null) {
            this.mKeySet = new KeySet();
        }
        return this.mKeySet;
    }

    public Collection<V> getValues() {
        if (this.mValues == null) {
            this.mValues = new ValuesCollection();
        }
        return this.mValues;
    }

    public Object[] toArrayHelper(int n2) {
        int n3 = this.colGetSize();
        Object[] objectArray = new Object[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            objectArray[i2] = this.colGetEntry(i2, n2);
        }
        return objectArray;
    }

    public <T> T[] toArrayHelper(T[] TArray, int n2) {
        int n3 = this.colGetSize();
        Object[] objectArray = TArray;
        if (TArray.length < n3) {
            objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n3);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            objectArray[i2] = this.colGetEntry(i2, n2);
        }
        if (objectArray.length > n3) {
            objectArray[n3] = null;
        }
        return objectArray;
    }

    final class ArrayIterator<T>
    implements Iterator<T> {
        boolean mCanRemove = false;
        int mIndex;
        final int mOffset;
        int mSize;

        ArrayIterator(int n2) {
            this.mOffset = n2;
            this.mSize = MapCollections.this.colGetSize();
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.mIndex < this.mSize;
            return bl;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                Object object = MapCollections.this.colGetEntry(this.mIndex, this.mOffset);
                ++this.mIndex;
                this.mCanRemove = true;
                return (T)object;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.mCanRemove) {
                --this.mIndex;
                --this.mSize;
                this.mCanRemove = false;
                MapCollections.this.colRemoveAt(this.mIndex);
                return;
            }
            throw new IllegalStateException();
        }
    }

    final class EntrySet
    implements Set<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> object) {
            int n2 = MapCollections.this.colGetSize();
            object = object.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                MapCollections.this.colPut(entry.getKey(), entry.getValue());
            }
            boolean bl = n2 != MapCollections.this.colGetSize();
            return bl;
        }

        @Override
        public void clear() {
            MapCollections.this.colClear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            int n2 = MapCollections.this.colIndexOfKey((object = (Map.Entry)object).getKey());
            if (n2 < 0) {
                return false;
            }
            return ContainerHelpers.equal((Object)MapCollections.this.colGetEntry(n2, 1), object.getValue());
        }

        @Override
        public boolean containsAll(Collection<?> object) {
            object = object.iterator();
            while (object.hasNext()) {
                if (this.contains(object.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object object) {
            return MapCollections.equalsSetHelper(this, object);
        }

        @Override
        public int hashCode() {
            int n2 = 0;
            for (int i2 = MapCollections.this.colGetSize() - 1; i2 >= 0; --i2) {
                Object object = MapCollections.this.colGetEntry(i2, 0);
                Object object2 = MapCollections.this.colGetEntry(i2, 1);
                int n3 = object == null ? 0 : object.hashCode();
                int n4 = object2 == null ? 0 : object2.hashCode();
                n2 += n3 ^ n4;
            }
            return n2;
        }

        @Override
        public boolean isEmpty() {
            boolean bl = MapCollections.this.colGetSize() == 0;
            return bl;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return MapCollections.this.colGetSize();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            throw new UnsupportedOperationException();
        }
    }

    final class KeySet
    implements Set<K> {
        KeySet() {
        }

        @Override
        public boolean add(K k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            MapCollections.this.colClear();
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = MapCollections.this.colIndexOfKey(object) >= 0;
            return bl;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return MapCollections.containsAllHelper(MapCollections.this.colGetMap(), collection);
        }

        @Override
        public boolean equals(Object object) {
            return MapCollections.equalsSetHelper(this, object);
        }

        @Override
        public int hashCode() {
            int n2 = 0;
            for (int i2 = MapCollections.this.colGetSize() - 1; i2 >= 0; --i2) {
                Object object = MapCollections.this.colGetEntry(i2, 0);
                int n3 = object == null ? 0 : object.hashCode();
                n2 += n3;
            }
            return n2;
        }

        @Override
        public boolean isEmpty() {
            boolean bl = MapCollections.this.colGetSize() == 0;
            return bl;
        }

        @Override
        public Iterator<K> iterator() {
            return new ArrayIterator(0);
        }

        @Override
        public boolean remove(Object object) {
            int n2 = MapCollections.this.colIndexOfKey(object);
            if (n2 >= 0) {
                MapCollections.this.colRemoveAt(n2);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return MapCollections.removeAllHelper(MapCollections.this.colGetMap(), collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return MapCollections.retainAllHelper(MapCollections.this.colGetMap(), collection);
        }

        @Override
        public int size() {
            return MapCollections.this.colGetSize();
        }

        @Override
        public Object[] toArray() {
            return MapCollections.this.toArrayHelper(0);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return MapCollections.this.toArrayHelper(TArray, 0);
        }
    }

    final class MapIterator
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        int mEnd;
        boolean mEntryValid = false;
        int mIndex;

        MapIterator() {
            this.mEnd = MapCollections.this.colGetSize() - 1;
            this.mIndex = -1;
        }

        @Override
        public boolean equals(Object object) {
            if (this.mEntryValid) {
                boolean bl = object instanceof Map.Entry;
                boolean bl2 = false;
                if (!bl) {
                    return false;
                }
                object = (Map.Entry)object;
                bl = bl2;
                if (ContainerHelpers.equal(object.getKey(), (Object)MapCollections.this.colGetEntry(this.mIndex, 0))) {
                    bl = bl2;
                    if (ContainerHelpers.equal(object.getValue(), (Object)MapCollections.this.colGetEntry(this.mIndex, 1))) {
                        bl = true;
                    }
                }
                return bl;
            }
            throw new IllegalStateException("This container does not support retaining Map.Entry objects");
        }

        @Override
        public K getKey() {
            if (this.mEntryValid) {
                return MapCollections.this.colGetEntry(this.mIndex, 0);
            }
            throw new IllegalStateException("This container does not support retaining Map.Entry objects");
        }

        @Override
        public V getValue() {
            if (this.mEntryValid) {
                return MapCollections.this.colGetEntry(this.mIndex, 1);
            }
            throw new IllegalStateException("This container does not support retaining Map.Entry objects");
        }

        @Override
        public boolean hasNext() {
            boolean bl = this.mIndex < this.mEnd;
            return bl;
        }

        @Override
        public int hashCode() {
            if (this.mEntryValid) {
                Object object = MapCollections.this;
                int n2 = this.mIndex;
                int n3 = 0;
                object = ((MapCollections)object).colGetEntry(n2, 0);
                Object object2 = MapCollections.this.colGetEntry(this.mIndex, 1);
                n2 = object == null ? 0 : object.hashCode();
                if (object2 != null) {
                    n3 = object2.hashCode();
                }
                return n2 ^ n3;
            }
            throw new IllegalStateException("This container does not support retaining Map.Entry objects");
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.hasNext()) {
                ++this.mIndex;
                this.mEntryValid = true;
                return this;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.mEntryValid) {
                MapCollections.this.colRemoveAt(this.mIndex);
                --this.mIndex;
                --this.mEnd;
                this.mEntryValid = false;
                return;
            }
            throw new IllegalStateException();
        }

        @Override
        public V setValue(V v2) {
            if (this.mEntryValid) {
                return MapCollections.this.colSetValue(this.mIndex, v2);
            }
            throw new IllegalStateException("This container does not support retaining Map.Entry objects");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getKey());
            stringBuilder.append("=");
            stringBuilder.append(this.getValue());
            return stringBuilder.toString();
        }
    }

    final class ValuesCollection
    implements Collection<V> {
        ValuesCollection() {
        }

        @Override
        public boolean add(V v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            MapCollections.this.colClear();
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = MapCollections.this.colIndexOfValue(object) >= 0;
            return bl;
        }

        @Override
        public boolean containsAll(Collection<?> object) {
            object = object.iterator();
            while (object.hasNext()) {
                if (this.contains(object.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            boolean bl = MapCollections.this.colGetSize() == 0;
            return bl;
        }

        @Override
        public Iterator<V> iterator() {
            return new ArrayIterator(1);
        }

        @Override
        public boolean remove(Object object) {
            int n2 = MapCollections.this.colIndexOfValue(object);
            if (n2 >= 0) {
                MapCollections.this.colRemoveAt(n2);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int n2 = MapCollections.this.colGetSize();
            int n3 = 0;
            boolean bl = false;
            while (n3 < n2) {
                int n4 = n2;
                int n5 = n3;
                if (collection.contains(MapCollections.this.colGetEntry(n3, 1))) {
                    MapCollections.this.colRemoveAt(n3);
                    n5 = n3 - 1;
                    n4 = n2 - 1;
                    bl = true;
                }
                n3 = n5 + 1;
                n2 = n4;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int n2 = MapCollections.this.colGetSize();
            int n3 = 0;
            boolean bl = false;
            while (n3 < n2) {
                int n4 = n2;
                int n5 = n3;
                if (!collection.contains(MapCollections.this.colGetEntry(n3, 1))) {
                    MapCollections.this.colRemoveAt(n3);
                    n5 = n3 - 1;
                    n4 = n2 - 1;
                    bl = true;
                }
                n3 = n5 + 1;
                n2 = n4;
            }
            return bl;
        }

        @Override
        public int size() {
            return MapCollections.this.colGetSize();
        }

        @Override
        public Object[] toArray() {
            return MapCollections.this.toArrayHelper(1);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return MapCollections.this.toArrayHelper(TArray, 1);
        }
    }
}

