/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.customtabs;

import android.app.Service;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.customtabs.ICustomTabsCallback;
import android.support.customtabs.ICustomTabsService;
import androidx.browser.customtabs.CustomTabsSessionToken;
import androidx.collection.ArrayMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class CustomTabsService
extends Service {
    public static final String ACTION_CUSTOM_TABS_CONNECTION = "android.support.customtabs.action.CustomTabsService";
    public static final String KEY_URL = "android.support.customtabs.otherurls.URL";
    public static final int RELATION_HANDLE_ALL_URLS = 2;
    public static final int RELATION_USE_AS_ORIGIN = 1;
    public static final int RESULT_FAILURE_DISALLOWED = -1;
    public static final int RESULT_FAILURE_MESSAGING_ERROR = -3;
    public static final int RESULT_FAILURE_REMOTE_ERROR = -2;
    public static final int RESULT_SUCCESS = 0;
    private ICustomTabsService.Stub mBinder;
    final Map<IBinder, IBinder.DeathRecipient> mDeathRecipientMap = new ArrayMap();

    public CustomTabsService() {
        this.mBinder = new ICustomTabsService.Stub(){

            public Bundle extraCommand(String string2, Bundle bundle) {
                return CustomTabsService.this.extraCommand(string2, bundle);
            }

            public boolean mayLaunchUrl(ICustomTabsCallback iCustomTabsCallback, Uri uri, Bundle bundle, List<Bundle> list) {
                return CustomTabsService.this.mayLaunchUrl(new CustomTabsSessionToken(iCustomTabsCallback), uri, bundle, list);
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean newSession(ICustomTabsCallback iCustomTabsCallback) {
                IBinder.DeathRecipient deathRecipient;
                final CustomTabsSessionToken customTabsSessionToken = new CustomTabsSessionToken(iCustomTabsCallback);
                try {
                    deathRecipient = new IBinder.DeathRecipient(){

                        public void binderDied() {
                            CustomTabsService.this.cleanUpSession(customTabsSessionToken);
                        }
                    };
                    Map<IBinder, IBinder.DeathRecipient> map = CustomTabsService.this.mDeathRecipientMap;
                    synchronized (map) {
                    }
                }
                catch (RemoteException remoteException) {
                    return false;
                }
                {
                    iCustomTabsCallback.asBinder().linkToDeath(deathRecipient, 0);
                    CustomTabsService.this.mDeathRecipientMap.put(iCustomTabsCallback.asBinder(), deathRecipient);
                    return CustomTabsService.this.newSession(customTabsSessionToken);
                }
            }

            public int postMessage(ICustomTabsCallback iCustomTabsCallback, String string2, Bundle bundle) {
                return CustomTabsService.this.postMessage(new CustomTabsSessionToken(iCustomTabsCallback), string2, bundle);
            }

            public boolean requestPostMessageChannel(ICustomTabsCallback iCustomTabsCallback, Uri uri) {
                return CustomTabsService.this.requestPostMessageChannel(new CustomTabsSessionToken(iCustomTabsCallback), uri);
            }

            public boolean updateVisuals(ICustomTabsCallback iCustomTabsCallback, Bundle bundle) {
                return CustomTabsService.this.updateVisuals(new CustomTabsSessionToken(iCustomTabsCallback), bundle);
            }

            public boolean validateRelationship(ICustomTabsCallback iCustomTabsCallback, int n2, Uri uri, Bundle bundle) {
                return CustomTabsService.this.validateRelationship(new CustomTabsSessionToken(iCustomTabsCallback), n2, uri, bundle);
            }

            public boolean warmup(long l2) {
                return CustomTabsService.this.warmup(l2);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean cleanUpSession(CustomTabsSessionToken customTabsSessionToken) {
        try {
            Map<IBinder, IBinder.DeathRecipient> map = this.mDeathRecipientMap;
            synchronized (map) {
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        {
            customTabsSessionToken = customTabsSessionToken.getCallbackBinder();
            customTabsSessionToken.unlinkToDeath(this.mDeathRecipientMap.get(customTabsSessionToken), 0);
            this.mDeathRecipientMap.remove(customTabsSessionToken);
            return true;
        }
    }

    protected abstract Bundle extraCommand(String var1, Bundle var2);

    protected abstract boolean mayLaunchUrl(CustomTabsSessionToken var1, Uri var2, Bundle var3, List<Bundle> var4);

    protected abstract boolean newSession(CustomTabsSessionToken var1);

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    protected abstract int postMessage(CustomTabsSessionToken var1, String var2, Bundle var3);

    protected abstract boolean requestPostMessageChannel(CustomTabsSessionToken var1, Uri var2);

    protected abstract boolean updateVisuals(CustomTabsSessionToken var1, Bundle var2);

    protected abstract boolean validateRelationship(CustomTabsSessionToken var1, int var2, Uri var3, Bundle var4);

    protected abstract boolean warmup(long var1);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Relation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Result {
    }
}

