/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.browseractions;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.browser.browseractions.BrowserActionItem;
import androidx.browser.browseractions.BrowserActionsFallbackMenuUi;
import androidx.core.content.ContextCompat;
import com.safedk.android.utils.Logger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BrowserActionsIntent {
    public static final String ACTION_BROWSER_ACTIONS_OPEN = "androidx.browser.browseractions.browser_action_open";
    public static final String EXTRA_APP_ID = "androidx.browser.browseractions.APP_ID";
    public static final String EXTRA_MENU_ITEMS = "androidx.browser.browseractions.extra.MENU_ITEMS";
    public static final String EXTRA_SELECTED_ACTION_PENDING_INTENT = "androidx.browser.browseractions.extra.SELECTED_ACTION_PENDING_INTENT";
    public static final String EXTRA_TYPE = "androidx.browser.browseractions.extra.TYPE";
    public static final int ITEM_COPY = 3;
    public static final int ITEM_DOWNLOAD = 2;
    public static final int ITEM_INVALID_ITEM = -1;
    public static final int ITEM_OPEN_IN_INCOGNITO = 1;
    public static final int ITEM_OPEN_IN_NEW_TAB = 0;
    public static final int ITEM_SHARE = 4;
    public static final String KEY_ACTION = "androidx.browser.browseractions.ACTION";
    public static final String KEY_ICON_ID = "androidx.browser.browseractions.ICON_ID";
    public static final String KEY_TITLE = "androidx.browser.browseractions.TITLE";
    public static final int MAX_CUSTOM_ITEMS = 5;
    private static final String TAG = "BrowserActions";
    private static final String TEST_URL = "https://www.example.com";
    public static final int URL_TYPE_AUDIO = 3;
    public static final int URL_TYPE_FILE = 4;
    public static final int URL_TYPE_IMAGE = 1;
    public static final int URL_TYPE_NONE = 0;
    public static final int URL_TYPE_PLUGIN = 5;
    public static final int URL_TYPE_VIDEO = 2;
    private static BrowserActionsFallDialogListener sDialogListenter;
    private final Intent mIntent;

    BrowserActionsIntent(Intent intent) {
        this.mIntent = intent;
    }

    private static List<ResolveInfo> getBrowserActionsIntentHandlers(Context context) {
        Intent intent = new Intent(ACTION_BROWSER_ACTIONS_OPEN, Uri.parse((String)TEST_URL));
        return context.getPackageManager().queryIntentActivities(intent, 131072);
    }

    public static String getCreatorPackageName(Intent intent) {
        if ((intent = (PendingIntent)intent.getParcelableExtra(EXTRA_APP_ID)) != null) {
            if (Build.VERSION.SDK_INT >= 17) {
                return intent.getCreatorPackage();
            }
            return intent.getTargetPackage();
        }
        return null;
    }

    public static void launchIntent(Context context, Intent intent) {
        BrowserActionsIntent.launchIntent(context, intent, BrowserActionsIntent.getBrowserActionsIntentHandlers(context));
    }

    static void launchIntent(Context context, Intent intent, List<ResolveInfo> list) {
        if (list != null && list.size() != 0) {
            int n2 = list.size();
            if (n2 == 1) {
                intent.setPackage(list.get((int)0).activityInfo.packageName);
            } else {
                Object object = new Intent("android.intent.action.VIEW", Uri.parse((String)TEST_URL));
                object = context.getPackageManager().resolveActivity((Intent)object, 65536);
                if (object != null) {
                    object = ((ResolveInfo)object).activityInfo.packageName;
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        if (!((String)object).equals(list.get((int)i2).activityInfo.packageName)) continue;
                        intent.setPackage((String)object);
                        break;
                    }
                }
            }
            BrowserActionsIntent.safedk_ContextCompat_startActivity_f482d8446b01c5580049a261a99b538c(context, intent, null);
            return;
        }
        BrowserActionsIntent.openFallbackBrowserActionsMenu(context, intent);
    }

    public static void openBrowserAction(Context context, Uri uri) {
        BrowserActionsIntent.launchIntent(context, new Builder(context, uri).build().getIntent());
    }

    public static void openBrowserAction(Context context, Uri uri, int n2, ArrayList<BrowserActionItem> arrayList, PendingIntent pendingIntent) {
        BrowserActionsIntent.launchIntent(context, new Builder(context, uri).setUrlType(n2).setCustomItems(arrayList).setOnItemSelectedAction(pendingIntent).build().getIntent());
    }

    private static void openFallbackBrowserActionsMenu(Context context, Intent object) {
        Uri uri = object.getData();
        int n2 = object.getIntExtra(EXTRA_TYPE, 0);
        object = (object = object.getParcelableArrayListExtra(EXTRA_MENU_ITEMS)) != null ? BrowserActionsIntent.parseBrowserActionItems((ArrayList<Bundle>)object) : null;
        BrowserActionsIntent.openFallbackBrowserActionsMenu(context, uri, n2, (List<BrowserActionItem>)object);
    }

    private static void openFallbackBrowserActionsMenu(Context object, Uri uri, int n2, List<BrowserActionItem> list) {
        new BrowserActionsFallbackMenuUi((Context)object, uri, list).displayMenu();
        object = sDialogListenter;
        if (object != null) {
            object.onDialogShown();
        }
    }

    public static List<BrowserActionItem> parseBrowserActionItems(ArrayList<Bundle> arrayList) {
        ArrayList<BrowserActionItem> arrayList2 = new ArrayList<BrowserActionItem>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Bundle bundle = arrayList.get(i2);
            String string2 = bundle.getString(KEY_TITLE);
            PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable(KEY_ACTION);
            int n2 = bundle.getInt(KEY_ICON_ID);
            if (!TextUtils.isEmpty((CharSequence)string2) && pendingIntent != null) {
                arrayList2.add(new BrowserActionItem(string2, pendingIntent, n2));
                continue;
            }
            throw new IllegalArgumentException("Custom item should contain a non-empty title and non-null intent.");
        }
        return arrayList2;
    }

    public static void safedk_ContextCompat_startActivity_f482d8446b01c5580049a261a99b538c(Context context, Intent intent, Bundle bundle) {
        Logger.d("SafeDK-Special|SafeDK: Call> Landroidx/core/content/ContextCompat;->startActivity(Landroid/content/Context;Landroid/content/Intent;Landroid/os/Bundle;)V");
        if (intent == null) {
            return;
        }
        ContextCompat.startActivity((Context)context, (Intent)intent, (Bundle)bundle);
    }

    static void setDialogShownListenter(BrowserActionsFallDialogListener browserActionsFallDialogListener) {
        sDialogListenter = browserActionsFallDialogListener;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    static interface BrowserActionsFallDialogListener {
        public void onDialogShown();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BrowserActionsItemId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BrowserActionsUrlType {
    }

    public static final class Builder {
        private Context mContext;
        private final Intent mIntent = new Intent("androidx.browser.browseractions.browser_action_open");
        private ArrayList<Bundle> mMenuItems = null;
        private PendingIntent mOnItemSelectedPendingIntent = null;
        private int mType;
        private Uri mUri;

        public Builder(Context context, Uri uri) {
            this.mContext = context;
            this.mUri = uri;
            this.mType = 0;
            this.mMenuItems = new ArrayList();
        }

        private Bundle getBundleFromItem(BrowserActionItem browserActionItem) {
            Bundle bundle = new Bundle();
            bundle.putString(BrowserActionsIntent.KEY_TITLE, browserActionItem.getTitle());
            bundle.putParcelable(BrowserActionsIntent.KEY_ACTION, (Parcelable)browserActionItem.getAction());
            if (browserActionItem.getIconId() != 0) {
                bundle.putInt(BrowserActionsIntent.KEY_ICON_ID, browserActionItem.getIconId());
            }
            return bundle;
        }

        public BrowserActionsIntent build() {
            this.mIntent.setData(this.mUri);
            this.mIntent.putExtra(BrowserActionsIntent.EXTRA_TYPE, this.mType);
            this.mIntent.putParcelableArrayListExtra(BrowserActionsIntent.EXTRA_MENU_ITEMS, this.mMenuItems);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)new Intent(), (int)0);
            this.mIntent.putExtra(BrowserActionsIntent.EXTRA_APP_ID, (Parcelable)pendingIntent);
            pendingIntent = this.mOnItemSelectedPendingIntent;
            if (pendingIntent != null) {
                this.mIntent.putExtra(BrowserActionsIntent.EXTRA_SELECTED_ACTION_PENDING_INTENT, (Parcelable)pendingIntent);
            }
            return new BrowserActionsIntent(this.mIntent);
        }

        public Builder setCustomItems(ArrayList<BrowserActionItem> serializable) {
            if (((ArrayList)serializable).size() <= 5) {
                for (int i2 = 0; i2 < ((ArrayList)serializable).size(); ++i2) {
                    if (!TextUtils.isEmpty((CharSequence)((BrowserActionItem)((ArrayList)serializable).get(i2)).getTitle()) && ((BrowserActionItem)((ArrayList)serializable).get(i2)).getAction() != null) {
                        this.mMenuItems.add(this.getBundleFromItem((BrowserActionItem)((ArrayList)serializable).get(i2)));
                        continue;
                    }
                    throw new IllegalArgumentException("Custom item should contain a non-empty title and non-null intent.");
                }
                return this;
            }
            serializable = new IllegalStateException("Exceeded maximum toolbar item count of 5");
            throw serializable;
        }

        public Builder setCustomItems(BrowserActionItem ... browserActionItemArray) {
            return this.setCustomItems(new ArrayList<BrowserActionItem>(Arrays.asList(browserActionItemArray)));
        }

        public Builder setOnItemSelectedAction(PendingIntent pendingIntent) {
            this.mOnItemSelectedPendingIntent = pendingIntent;
            return this;
        }

        public Builder setUrlType(int n2) {
            this.mType = n2;
            return this;
        }
    }
}

