/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.app.PendingIntent;
import android.app.SearchableInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.appcompat.R;
import androidx.appcompat.view.CollapsibleActionView;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.appcompat.widget.SuggestionsAdapter;
import androidx.appcompat.widget.TintTypedArray;
import androidx.appcompat.widget.TooltipCompat;
import androidx.appcompat.widget.ViewUtils;
import androidx.core.view.ViewCompat;
import androidx.cursoradapter.widget.CursorAdapter;
import androidx.customview.view.AbsSavedState;
import com.safedk.android.utils.Logger;
import java.lang.reflect.Method;
import java.util.WeakHashMap;

public class SearchView
extends LinearLayoutCompat
implements CollapsibleActionView {
    static final boolean DBG = false;
    private static final String IME_OPTION_NO_MICROPHONE = "nm";
    static final String LOG_TAG = "SearchView";
    static final PreQAutoCompleteTextViewReflector PRE_API_29_HIDDEN_METHOD_INVOKER;
    private Bundle mAppSearchData;
    private boolean mClearingFocus;
    final ImageView mCloseButton;
    private final ImageView mCollapsedIcon;
    private int mCollapsedImeOptions;
    private final CharSequence mDefaultQueryHint;
    private final View mDropDownAnchor;
    private boolean mExpandedInActionView;
    final ImageView mGoButton;
    private boolean mIconified;
    private boolean mIconifiedByDefault;
    private int mMaxWidth;
    private CharSequence mOldQueryText;
    private final View.OnClickListener mOnClickListener;
    private OnCloseListener mOnCloseListener;
    private final TextView.OnEditorActionListener mOnEditorActionListener;
    private final AdapterView.OnItemClickListener mOnItemClickListener;
    private final AdapterView.OnItemSelectedListener mOnItemSelectedListener;
    private OnQueryTextListener mOnQueryChangeListener;
    View.OnFocusChangeListener mOnQueryTextFocusChangeListener;
    private View.OnClickListener mOnSearchClickListener;
    private OnSuggestionListener mOnSuggestionListener;
    private final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private CharSequence mQueryHint;
    private boolean mQueryRefinement;
    private Runnable mReleaseCursorRunnable;
    final ImageView mSearchButton;
    private final View mSearchEditFrame;
    private final Drawable mSearchHintIcon;
    private final View mSearchPlate;
    final SearchAutoComplete mSearchSrcTextView;
    private Rect mSearchSrcTextViewBounds = new Rect();
    private Rect mSearchSrtTextViewBoundsExpanded = new Rect();
    SearchableInfo mSearchable;
    private final View mSubmitArea;
    private boolean mSubmitButtonEnabled;
    private final int mSuggestionCommitIconResId;
    private final int mSuggestionRowLayout;
    CursorAdapter mSuggestionsAdapter;
    private int[] mTemp = new int[2];
    private int[] mTemp2 = new int[2];
    View.OnKeyListener mTextKeyListener;
    private TextWatcher mTextWatcher;
    private UpdatableTouchDelegate mTouchDelegate;
    private final Runnable mUpdateDrawableStateRunnable = new Runnable(){

        @Override
        public void run() {
            SearchView.this.updateFocusedState();
        }
    };
    private CharSequence mUserQuery;
    private final Intent mVoiceAppSearchIntent;
    final ImageView mVoiceButton;
    private boolean mVoiceButtonEnabled;
    private final Intent mVoiceWebSearchIntent;

    static {
        PreQAutoCompleteTextViewReflector preQAutoCompleteTextViewReflector = Build.VERSION.SDK_INT < 29 ? new PreQAutoCompleteTextViewReflector() : null;
        PRE_API_29_HIDDEN_METHOD_INVOKER = preQAutoCompleteTextViewReflector;
    }

    public SearchView(Context context) {
        this(context, null);
    }

    public SearchView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.searchViewStyle);
    }

    public SearchView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.mReleaseCursorRunnable = new Runnable(){

            @Override
            public void run() {
                if (SearchView.this.mSuggestionsAdapter instanceof SuggestionsAdapter) {
                    SearchView.this.mSuggestionsAdapter.changeCursor(null);
                }
            }
        };
        this.mOutsideDrawablesCache = new WeakHashMap();
        this.mOnClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (view == SearchView.this.mSearchButton) {
                    SearchView.this.onSearchClicked();
                } else if (view == SearchView.this.mCloseButton) {
                    SearchView.this.onCloseClicked();
                } else if (view == SearchView.this.mGoButton) {
                    SearchView.this.onSubmitQuery();
                } else if (view == SearchView.this.mVoiceButton) {
                    SearchView.this.onVoiceClicked();
                } else if (view == SearchView.this.mSearchSrcTextView) {
                    SearchView.this.forceSuggestionQuery();
                }
            }
        };
        this.mTextKeyListener = new View.OnKeyListener(){

            public boolean onKey(View object, int n2, KeyEvent keyEvent) {
                if (SearchView.this.mSearchable == null) {
                    return false;
                }
                if (SearchView.this.mSearchSrcTextView.isPopupShowing() && SearchView.this.mSearchSrcTextView.getListSelection() != -1) {
                    return SearchView.this.onSuggestionsKey((View)object, n2, keyEvent);
                }
                if (!SearchView.this.mSearchSrcTextView.isEmpty() && keyEvent.hasNoModifiers() && keyEvent.getAction() == 1 && n2 == 66) {
                    object.cancelLongPress();
                    object = SearchView.this;
                    ((SearchView)((Object)object)).launchQuerySearch(0, null, ((SearchView)((Object)object)).mSearchSrcTextView.getText().toString());
                    return true;
                }
                return false;
            }
        };
        this.mOnEditorActionListener = new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int n2, KeyEvent keyEvent) {
                SearchView.this.onSubmitQuery();
                return true;
            }
        };
        this.mOnItemClickListener = new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n2, long l2) {
                SearchView.this.onItemClicked(n2, 0, null);
            }
        };
        this.mOnItemSelectedListener = new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int n2, long l2) {
                SearchView.this.onItemSelected(n2);
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        };
        this.mTextWatcher = new TextWatcher(){

            public void afterTextChanged(Editable editable) {
            }

            public void beforeTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
            }

            public void onTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
                SearchView.this.onTextChanged(charSequence);
            }
        };
        attributeSet = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attributeSet, (int[])R.styleable.SearchView, (int)n2, (int)0);
        LayoutInflater.from((Context)context).inflate(attributeSet.getResourceId(R.styleable.SearchView_layout, R.layout.abc_search_view), (ViewGroup)this, true);
        this.mSearchSrcTextView = (SearchAutoComplete)this.findViewById(R.id.search_src_text);
        this.mSearchSrcTextView.setSearchView(this);
        this.mSearchEditFrame = this.findViewById(R.id.search_edit_frame);
        this.mSearchPlate = this.findViewById(R.id.search_plate);
        this.mSubmitArea = this.findViewById(R.id.submit_area);
        this.mSearchButton = (ImageView)this.findViewById(R.id.search_button);
        this.mGoButton = (ImageView)this.findViewById(R.id.search_go_btn);
        this.mCloseButton = (ImageView)this.findViewById(R.id.search_close_btn);
        this.mVoiceButton = (ImageView)this.findViewById(R.id.search_voice_btn);
        this.mCollapsedIcon = (ImageView)this.findViewById(R.id.search_mag_icon);
        ViewCompat.setBackground(this.mSearchPlate, attributeSet.getDrawable(R.styleable.SearchView_queryBackground));
        ViewCompat.setBackground(this.mSubmitArea, attributeSet.getDrawable(R.styleable.SearchView_submitBackground));
        this.mSearchButton.setImageDrawable(attributeSet.getDrawable(R.styleable.SearchView_searchIcon));
        this.mGoButton.setImageDrawable(attributeSet.getDrawable(R.styleable.SearchView_goIcon));
        this.mCloseButton.setImageDrawable(attributeSet.getDrawable(R.styleable.SearchView_closeIcon));
        this.mVoiceButton.setImageDrawable(attributeSet.getDrawable(R.styleable.SearchView_voiceIcon));
        this.mCollapsedIcon.setImageDrawable(attributeSet.getDrawable(R.styleable.SearchView_searchIcon));
        this.mSearchHintIcon = attributeSet.getDrawable(R.styleable.SearchView_searchHintIcon);
        TooltipCompat.setTooltipText((View)this.mSearchButton, (CharSequence)this.getResources().getString(R.string.abc_searchview_description_search));
        this.mSuggestionRowLayout = attributeSet.getResourceId(R.styleable.SearchView_suggestionRowLayout, R.layout.abc_search_dropdown_item_icons_2line);
        this.mSuggestionCommitIconResId = attributeSet.getResourceId(R.styleable.SearchView_commitIcon, 0);
        this.mSearchButton.setOnClickListener(this.mOnClickListener);
        this.mCloseButton.setOnClickListener(this.mOnClickListener);
        this.mGoButton.setOnClickListener(this.mOnClickListener);
        this.mVoiceButton.setOnClickListener(this.mOnClickListener);
        this.mSearchSrcTextView.setOnClickListener(this.mOnClickListener);
        this.mSearchSrcTextView.addTextChangedListener(this.mTextWatcher);
        this.mSearchSrcTextView.setOnEditorActionListener(this.mOnEditorActionListener);
        this.mSearchSrcTextView.setOnItemClickListener(this.mOnItemClickListener);
        this.mSearchSrcTextView.setOnItemSelectedListener(this.mOnItemSelectedListener);
        this.mSearchSrcTextView.setOnKeyListener(this.mTextKeyListener);
        this.mSearchSrcTextView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                if (SearchView.this.mOnQueryTextFocusChangeListener != null) {
                    SearchView.this.mOnQueryTextFocusChangeListener.onFocusChange((View)SearchView.this, bl);
                }
            }
        });
        this.setIconifiedByDefault(attributeSet.getBoolean(R.styleable.SearchView_iconifiedByDefault, true));
        n2 = attributeSet.getDimensionPixelSize(R.styleable.SearchView_android_maxWidth, -1);
        if (n2 != -1) {
            this.setMaxWidth(n2);
        }
        this.mDefaultQueryHint = attributeSet.getText(R.styleable.SearchView_defaultQueryHint);
        this.mQueryHint = attributeSet.getText(R.styleable.SearchView_queryHint);
        n2 = attributeSet.getInt(R.styleable.SearchView_android_imeOptions, -1);
        if (n2 != -1) {
            this.setImeOptions(n2);
        }
        if ((n2 = attributeSet.getInt(R.styleable.SearchView_android_inputType, -1)) != -1) {
            this.setInputType(n2);
        }
        this.setFocusable(attributeSet.getBoolean(R.styleable.SearchView_android_focusable, true));
        attributeSet.recycle();
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
        this.mDropDownAnchor = this.findViewById(this.mSearchSrcTextView.getDropDownAnchor());
        context = this.mDropDownAnchor;
        if (context != null) {
            context.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
                    SearchView.this.adjustDropDownSizeAndPosition();
                }
            });
        }
        this.updateViewsVisibility(this.mIconifiedByDefault);
        this.updateQueryHint();
    }

    private Intent createIntent(String string2, Uri uri, String string3, String string4, int n2, String string5) {
        string2 = new Intent(string2);
        string2.addFlags(0x10000000);
        if (uri != null) {
            string2.setData(uri);
        }
        string2.putExtra("user_query", this.mUserQuery);
        if (string4 != null) {
            string2.putExtra("query", string4);
        }
        if (string3 != null) {
            string2.putExtra("intent_extra_data_key", string3);
        }
        if ((uri = this.mAppSearchData) != null) {
            string2.putExtra("app_data", (Bundle)uri);
        }
        if (n2 != 0) {
            string2.putExtra("action_key", n2);
            string2.putExtra("action_msg", string5);
        }
        string2.setComponent(this.mSearchable.getSearchActivity());
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Intent createIntentFromSuggestion(Cursor object, int n2, String string2) {
        try {
            String string3;
            String string4 = string3 = SuggestionsAdapter.getColumnString((Cursor)object, (String)"suggest_intent_action");
            if (string3 == null) {
                string4 = this.mSearchable.getSuggestIntentAction();
            }
            string3 = string4;
            if (string4 == null) {
                string3 = "android.intent.action.SEARCH";
            }
            CharSequence charSequence = SuggestionsAdapter.getColumnString((Cursor)object, (String)"suggest_intent_data");
            string4 = charSequence;
            if (charSequence == null) {
                string4 = this.mSearchable.getSuggestIntentData();
            }
            charSequence = string4;
            if (string4 != null) {
                String string5 = SuggestionsAdapter.getColumnString((Cursor)object, (String)"suggest_intent_data_id");
                charSequence = string4;
                if (string5 != null) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(string4);
                    ((StringBuilder)charSequence).append("/");
                    ((StringBuilder)charSequence).append(Uri.encode((String)string5));
                    charSequence = ((StringBuilder)charSequence).toString();
                }
            }
            string4 = charSequence == null ? null : Uri.parse((String)charSequence);
            charSequence = SuggestionsAdapter.getColumnString((Cursor)object, (String)"suggest_intent_query");
            return this.createIntent(string3, (Uri)string4, SuggestionsAdapter.getColumnString((Cursor)object, (String)"suggest_intent_extra_data"), (String)charSequence, n2, string2);
        }
        catch (RuntimeException runtimeException) {
            try {
                n2 = object.getPosition();
            }
            catch (RuntimeException runtimeException2) {
                n2 = -1;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Search suggestions cursor at row ");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(" returned exception.");
            Log.w((String)LOG_TAG, (String)((StringBuilder)object).toString(), (Throwable)runtimeException);
            return null;
        }
    }

    private Intent createVoiceAppSearchIntent(Intent object, SearchableInfo searchableInfo) {
        ComponentName componentName = searchableInfo.getSearchActivity();
        Object object2 = new Intent("android.intent.action.SEARCH");
        object2.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.getContext(), (int)0, (Intent)object2, (int)0x40000000);
        Bundle bundle = new Bundle();
        object2 = this.mAppSearchData;
        if (object2 != null) {
            bundle.putParcelable("app_data", (Parcelable)object2);
        }
        Intent intent = new Intent(object);
        int n2 = 1;
        Object object3 = this.getResources();
        object = searchableInfo.getVoiceLanguageModeId() != 0 ? object3.getString(searchableInfo.getVoiceLanguageModeId()) : "free_form";
        int n3 = searchableInfo.getVoicePromptTextId();
        Object var11_11 = null;
        object2 = n3 != 0 ? object3.getString(searchableInfo.getVoicePromptTextId()) : null;
        object3 = searchableInfo.getVoiceLanguageId() != 0 ? object3.getString(searchableInfo.getVoiceLanguageId()) : null;
        if (searchableInfo.getVoiceMaxResults() != 0) {
            n2 = searchableInfo.getVoiceMaxResults();
        }
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", (String)object);
        intent.putExtra("android.speech.extra.PROMPT", (String)object2);
        intent.putExtra("android.speech.extra.LANGUAGE", (String)object3);
        intent.putExtra("android.speech.extra.MAX_RESULTS", n2);
        object = componentName == null ? var11_11 : componentName.flattenToShortString();
        intent.putExtra("calling_package", (String)object);
        intent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", (Parcelable)pendingIntent);
        intent.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", bundle);
        return intent;
    }

    private Intent createVoiceWebSearchIntent(Intent object, SearchableInfo searchableInfo) {
        Intent intent = new Intent(object);
        object = searchableInfo.getSearchActivity();
        object = object == null ? null : object.flattenToShortString();
        intent.putExtra("calling_package", (String)object);
        return intent;
    }

    private void dismissSuggestions() {
        this.mSearchSrcTextView.dismissDropDown();
    }

    private void getChildBoundsWithinSearchView(View view, Rect rect) {
        view.getLocationInWindow(this.mTemp);
        this.getLocationInWindow(this.mTemp2);
        int[] nArray = this.mTemp;
        int n2 = nArray[1];
        int[] nArray2 = this.mTemp2;
        int n3 = nArray[0] - nArray2[0];
        rect.set(n3, n2 -= nArray2[1], view.getWidth() + n3, view.getHeight() + n2);
    }

    private CharSequence getDecoratedHint(CharSequence charSequence) {
        if (this.mIconifiedByDefault && this.mSearchHintIcon != null) {
            double d2 = this.mSearchSrcTextView.getTextSize();
            Double.isNaN(d2);
            int n2 = (int)(d2 * 1.25);
            this.mSearchHintIcon.setBounds(0, 0, n2, n2);
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)"   ");
            spannableStringBuilder.setSpan((Object)new ImageSpan(this.mSearchHintIcon), 1, 2, 33);
            spannableStringBuilder.append(charSequence);
            return spannableStringBuilder;
        }
        return charSequence;
    }

    private int getPreferredHeight() {
        return this.getContext().getResources().getDimensionPixelSize(R.dimen.abc_search_view_preferred_height);
    }

    private int getPreferredWidth() {
        return this.getContext().getResources().getDimensionPixelSize(R.dimen.abc_search_view_preferred_width);
    }

    private boolean hasVoiceSearch() {
        boolean bl;
        SearchableInfo searchableInfo = this.mSearchable;
        boolean bl2 = bl = false;
        if (searchableInfo != null) {
            bl2 = bl;
            if (searchableInfo.getVoiceSearchEnabled()) {
                searchableInfo = null;
                if (this.mSearchable.getVoiceSearchLaunchWebSearch()) {
                    searchableInfo = this.mVoiceWebSearchIntent;
                } else if (this.mSearchable.getVoiceSearchLaunchRecognizer()) {
                    searchableInfo = this.mVoiceAppSearchIntent;
                }
                bl2 = bl;
                if (searchableInfo != null) {
                    bl2 = bl;
                    if (this.getContext().getPackageManager().resolveActivity((Intent)searchableInfo, 65536) != null) {
                        bl2 = true;
                    }
                }
            }
        }
        return bl2;
    }

    static boolean isLandscapeMode(Context context) {
        boolean bl = context.getResources().getConfiguration().orientation == 2;
        return bl;
    }

    private boolean isSubmitAreaEnabled() {
        boolean bl = (this.mSubmitButtonEnabled || this.mVoiceButtonEnabled) && !this.isIconified();
        return bl;
    }

    private void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            SearchView.safedk_Context_startActivity_97cb3195734cf5c9cc3418feeafa6dd6(this.getContext(), intent);
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed launch activity: ");
            stringBuilder.append(intent);
            Log.e((String)LOG_TAG, (String)stringBuilder.toString(), (Throwable)runtimeException);
        }
    }

    private boolean launchSuggestion(int n2, int n3, String string2) {
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (cursor != null && cursor.moveToPosition(n2)) {
            this.launchIntent(this.createIntentFromSuggestion(cursor, n3, string2));
            return true;
        }
        return false;
    }

    private void postUpdateFocusedState() {
        this.post(this.mUpdateDrawableStateRunnable);
    }

    private void rewriteQueryFromSuggestion(int n2) {
        Editable editable = this.mSearchSrcTextView.getText();
        Object object = this.mSuggestionsAdapter.getCursor();
        if (object == null) {
            return;
        }
        if (object.moveToPosition(n2)) {
            if ((object = this.mSuggestionsAdapter.convertToString(object)) != null) {
                this.setQuery((CharSequence)object);
            } else {
                this.setQuery((CharSequence)editable);
            }
        } else {
            this.setQuery((CharSequence)editable);
        }
    }

    public static void safedk_Context_startActivity_97cb3195734cf5c9cc3418feeafa6dd6(Context context, Intent intent) {
        Logger.d("SafeDK-Special|SafeDK: Call> Landroid/content/Context;->startActivity(Landroid/content/Intent;)V");
        if (intent == null) {
            return;
        }
        context.startActivity(intent);
    }

    private void setQuery(CharSequence charSequence) {
        this.mSearchSrcTextView.setText(charSequence);
        SearchAutoComplete searchAutoComplete = this.mSearchSrcTextView;
        int n2 = TextUtils.isEmpty((CharSequence)charSequence) ? 0 : charSequence.length();
        searchAutoComplete.setSelection(n2);
    }

    private void updateCloseButton() {
        boolean bl = TextUtils.isEmpty((CharSequence)this.mSearchSrcTextView.getText());
        int n2 = 1;
        boolean bl2 = bl ^ true;
        int n3 = 0;
        int n4 = n2;
        if (!bl2) {
            n4 = this.mIconifiedByDefault && !this.mExpandedInActionView ? n2 : 0;
        }
        Object object = this.mCloseButton;
        n4 = n4 != 0 ? n3 : 8;
        object.setVisibility(n4);
        Drawable drawable2 = this.mCloseButton.getDrawable();
        if (drawable2 != null) {
            object = bl2 ? (Object)ENABLED_STATE_SET : (Object)EMPTY_STATE_SET;
            drawable2.setState((int[])object);
        }
    }

    private void updateQueryHint() {
        CharSequence charSequence = this.getQueryHint();
        SearchAutoComplete searchAutoComplete = this.mSearchSrcTextView;
        CharSequence charSequence2 = charSequence;
        if (charSequence == null) {
            charSequence2 = "";
        }
        searchAutoComplete.setHint(this.getDecoratedHint(charSequence2));
    }

    private void updateSearchAutoComplete() {
        this.mSearchSrcTextView.setThreshold(this.mSearchable.getSuggestThreshold());
        this.mSearchSrcTextView.setImeOptions(this.mSearchable.getImeOptions());
        int n2 = this.mSearchable.getInputType();
        int n3 = 1;
        int n4 = n2;
        if ((n2 & 0xF) == 1) {
            n4 = n2 &= 0xFFFEFFFF;
            if (this.mSearchable.getSuggestAuthority() != null) {
                n4 = n2 | 0x10000 | 0x80000;
            }
        }
        this.mSearchSrcTextView.setInputType(n4);
        CursorAdapter cursorAdapter = this.mSuggestionsAdapter;
        if (cursorAdapter != null) {
            cursorAdapter.changeCursor(null);
        }
        if (this.mSearchable.getSuggestAuthority() != null) {
            this.mSuggestionsAdapter = new SuggestionsAdapter(this.getContext(), this, this.mSearchable, this.mOutsideDrawablesCache);
            this.mSearchSrcTextView.setAdapter((ListAdapter)this.mSuggestionsAdapter);
            cursorAdapter = (SuggestionsAdapter)this.mSuggestionsAdapter;
            n4 = n3;
            if (this.mQueryRefinement) {
                n4 = 2;
            }
            cursorAdapter.setQueryRefinement(n4);
        }
    }

    private void updateSubmitArea() {
        int n2 = this.isSubmitAreaEnabled() && (this.mGoButton.getVisibility() == 0 || this.mVoiceButton.getVisibility() == 0) ? 0 : 8;
        this.mSubmitArea.setVisibility(n2);
    }

    private void updateSubmitButton(boolean bl) {
        int n2 = this.mSubmitButtonEnabled && this.isSubmitAreaEnabled() && this.hasFocus() && (bl || !this.mVoiceButtonEnabled) ? 0 : 8;
        this.mGoButton.setVisibility(n2);
    }

    private void updateViewsVisibility(boolean bl) {
        boolean bl2;
        int n2;
        block3: {
            block2: {
                this.mIconified = bl;
                int n3 = 0;
                n2 = bl ? 0 : 8;
                bl2 = TextUtils.isEmpty((CharSequence)this.mSearchSrcTextView.getText()) ^ true;
                this.mSearchButton.setVisibility(n2);
                this.updateSubmitButton(bl2);
                View view = this.mSearchEditFrame;
                n2 = bl ? 8 : 0;
                view.setVisibility(n2);
                if (this.mCollapsedIcon.getDrawable() == null) break block2;
                n2 = n3;
                if (!this.mIconifiedByDefault) break block3;
            }
            n2 = 8;
        }
        this.mCollapsedIcon.setVisibility(n2);
        this.updateCloseButton();
        this.updateVoiceButton(bl2 ^ true);
        this.updateSubmitArea();
    }

    private void updateVoiceButton(boolean bl) {
        int n2;
        if (this.mVoiceButtonEnabled && !this.isIconified() && bl) {
            n2 = 0;
            this.mGoButton.setVisibility(8);
        } else {
            n2 = 8;
        }
        this.mVoiceButton.setVisibility(n2);
    }

    void adjustDropDownSizeAndPosition() {
        if (this.mDropDownAnchor.getWidth() > 1) {
            Resources resources = this.getContext().getResources();
            int n2 = this.mSearchPlate.getPaddingLeft();
            Rect rect = new Rect();
            boolean bl = ViewUtils.isLayoutRtl((View)this);
            int n3 = this.mIconifiedByDefault ? resources.getDimensionPixelSize(R.dimen.abc_dropdownitem_icon_width) + resources.getDimensionPixelSize(R.dimen.abc_dropdownitem_text_padding_left) : 0;
            this.mSearchSrcTextView.getDropDownBackground().getPadding(rect);
            int n4 = bl ? -rect.left : n2 - (rect.left + n3);
            this.mSearchSrcTextView.setDropDownHorizontalOffset(n4);
            int n5 = this.mDropDownAnchor.getWidth();
            int n6 = rect.left;
            n4 = rect.right;
            this.mSearchSrcTextView.setDropDownWidth(n5 + n6 + n4 + n3 - n2);
        }
    }

    public void clearFocus() {
        this.mClearingFocus = true;
        super.clearFocus();
        this.mSearchSrcTextView.clearFocus();
        this.mSearchSrcTextView.setImeVisibility(false);
        this.mClearingFocus = false;
    }

    void forceSuggestionQuery() {
        if (Build.VERSION.SDK_INT >= 29) {
            this.mSearchSrcTextView.refreshAutoCompleteResults();
        } else {
            PRE_API_29_HIDDEN_METHOD_INVOKER.doBeforeTextChanged((AutoCompleteTextView)this.mSearchSrcTextView);
            PRE_API_29_HIDDEN_METHOD_INVOKER.doAfterTextChanged((AutoCompleteTextView)this.mSearchSrcTextView);
        }
    }

    public int getImeOptions() {
        return this.mSearchSrcTextView.getImeOptions();
    }

    public int getInputType() {
        return this.mSearchSrcTextView.getInputType();
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public CharSequence getQuery() {
        return this.mSearchSrcTextView.getText();
    }

    public CharSequence getQueryHint() {
        CharSequence charSequence = this.mQueryHint;
        if (charSequence == null) {
            charSequence = this.mSearchable;
            charSequence = charSequence != null && charSequence.getHintId() != 0 ? this.getContext().getText(this.mSearchable.getHintId()) : this.mDefaultQueryHint;
        }
        return charSequence;
    }

    int getSuggestionCommitIconResId() {
        return this.mSuggestionCommitIconResId;
    }

    int getSuggestionRowLayout() {
        return this.mSuggestionRowLayout;
    }

    public CursorAdapter getSuggestionsAdapter() {
        return this.mSuggestionsAdapter;
    }

    public boolean isIconfiedByDefault() {
        return this.mIconifiedByDefault;
    }

    public boolean isIconified() {
        return this.mIconified;
    }

    public boolean isQueryRefinementEnabled() {
        return this.mQueryRefinement;
    }

    public boolean isSubmitButtonEnabled() {
        return this.mSubmitButtonEnabled;
    }

    void launchQuerySearch(int n2, String string2, String string3) {
        string2 = this.createIntent("android.intent.action.SEARCH", null, null, string3, n2, string2);
        SearchView.safedk_Context_startActivity_97cb3195734cf5c9cc3418feeafa6dd6(this.getContext(), (Intent)string2);
    }

    public void onActionViewCollapsed() {
        this.setQuery("", false);
        this.clearFocus();
        this.updateViewsVisibility(true);
        this.mSearchSrcTextView.setImeOptions(this.mCollapsedImeOptions);
        this.mExpandedInActionView = false;
    }

    public void onActionViewExpanded() {
        if (this.mExpandedInActionView) {
            return;
        }
        this.mExpandedInActionView = true;
        this.mCollapsedImeOptions = this.mSearchSrcTextView.getImeOptions();
        this.mSearchSrcTextView.setImeOptions(this.mCollapsedImeOptions | 0x2000000);
        this.mSearchSrcTextView.setText("");
        this.setIconified(false);
    }

    void onCloseClicked() {
        if (TextUtils.isEmpty((CharSequence)this.mSearchSrcTextView.getText())) {
            OnCloseListener onCloseListener;
            if (this.mIconifiedByDefault && ((onCloseListener = this.mOnCloseListener) == null || !onCloseListener.onClose())) {
                this.clearFocus();
                this.updateViewsVisibility(true);
            }
        } else {
            this.mSearchSrcTextView.setText("");
            this.mSearchSrcTextView.requestFocus();
            this.mSearchSrcTextView.setImeVisibility(true);
        }
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mUpdateDrawableStateRunnable);
        this.post(this.mReleaseCursorRunnable);
        super.onDetachedFromWindow();
    }

    boolean onItemClicked(int n2, int n3, String object) {
        object = this.mOnSuggestionListener;
        if (object != null && object.onSuggestionClick(n2)) {
            return false;
        }
        this.launchSuggestion(n2, 0, null);
        this.mSearchSrcTextView.setImeVisibility(false);
        this.dismissSuggestions();
        return true;
    }

    boolean onItemSelected(int n2) {
        OnSuggestionListener onSuggestionListener = this.mOnSuggestionListener;
        if (onSuggestionListener != null && onSuggestionListener.onSuggestionSelect(n2)) {
            return false;
        }
        this.rewriteQueryFromSuggestion(n2);
        return true;
    }

    @Override
    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        if (bl) {
            this.getChildBoundsWithinSearchView((View)this.mSearchSrcTextView, this.mSearchSrcTextViewBounds);
            this.mSearchSrtTextViewBoundsExpanded.set(this.mSearchSrcTextViewBounds.left, 0, this.mSearchSrcTextViewBounds.right, n5 - n3);
            UpdatableTouchDelegate updatableTouchDelegate = this.mTouchDelegate;
            if (updatableTouchDelegate == null) {
                this.mTouchDelegate = new UpdatableTouchDelegate(this.mSearchSrtTextViewBoundsExpanded, this.mSearchSrcTextViewBounds, (View)this.mSearchSrcTextView);
                this.setTouchDelegate(this.mTouchDelegate);
            } else {
                updatableTouchDelegate.setBounds(this.mSearchSrtTextViewBoundsExpanded, this.mSearchSrcTextViewBounds);
            }
        }
    }

    @Override
    protected void onMeasure(int n2, int n3) {
        if (this.isIconified()) {
            super.onMeasure(n2, n3);
            return;
        }
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n2);
        if (n4 != Integer.MIN_VALUE) {
            if (n4 != 0) {
                if (n4 != 0x40000000) {
                    n2 = n5;
                } else {
                    n4 = this.mMaxWidth;
                    n2 = n5;
                    if (n4 > 0) {
                        n2 = Math.min(n4, n5);
                    }
                }
            } else {
                n2 = this.mMaxWidth;
                if (n2 <= 0) {
                    n2 = this.getPreferredWidth();
                }
            }
        } else {
            n2 = this.mMaxWidth;
            n2 = n2 > 0 ? Math.min(n2, n5) : Math.min(this.getPreferredWidth(), n5);
        }
        n5 = View.MeasureSpec.getMode((int)n3);
        n3 = View.MeasureSpec.getSize((int)n3);
        if (n5 != Integer.MIN_VALUE) {
            if (n5 == 0) {
                n3 = this.getPreferredHeight();
            }
        } else {
            n3 = Math.min(this.getPreferredHeight(), n3);
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000));
    }

    void onQueryRefine(CharSequence charSequence) {
        this.setQuery(charSequence);
    }

    protected void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.updateViewsVisibility(object.isIconified);
        this.requestLayout();
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.isIconified = this.isIconified();
        return savedState;
    }

    void onSearchClicked() {
        this.updateViewsVisibility(false);
        this.mSearchSrcTextView.requestFocus();
        this.mSearchSrcTextView.setImeVisibility(true);
        View.OnClickListener onClickListener = this.mOnSearchClickListener;
        if (onClickListener != null) {
            onClickListener.onClick((View)this);
        }
    }

    void onSubmitQuery() {
        OnQueryTextListener onQueryTextListener;
        Editable editable = this.mSearchSrcTextView.getText();
        if (!(editable == null || TextUtils.getTrimmedLength((CharSequence)editable) <= 0 || (onQueryTextListener = this.mOnQueryChangeListener) != null && onQueryTextListener.onQueryTextSubmit(editable.toString()))) {
            if (this.mSearchable != null) {
                this.launchQuerySearch(0, null, editable.toString());
            }
            this.mSearchSrcTextView.setImeVisibility(false);
            this.dismissSuggestions();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean onSuggestionsKey(View view, int n2, KeyEvent keyEvent) {
        if (this.mSearchable == null) {
            return false;
        }
        if (this.mSuggestionsAdapter == null) {
            return false;
        }
        if (keyEvent.getAction() != 0 || !keyEvent.hasNoModifiers()) return false;
        if (n2 == 66 || n2 == 84 || n2 == 61) return this.onItemClicked(this.mSearchSrcTextView.getListSelection(), 0, null);
        if (n2 != 21 && n2 != 22) {
            if (n2 != 19 || this.mSearchSrcTextView.getListSelection() != 0) return false;
            return false;
        }
        n2 = n2 == 21 ? 0 : this.mSearchSrcTextView.length();
        this.mSearchSrcTextView.setSelection(n2);
        this.mSearchSrcTextView.setListSelection(0);
        this.mSearchSrcTextView.clearListSelection();
        this.mSearchSrcTextView.ensureImeVisible();
        return true;
    }

    void onTextChanged(CharSequence charSequence) {
        Editable editable = this.mSearchSrcTextView.getText();
        this.mUserQuery = editable;
        boolean bl = TextUtils.isEmpty((CharSequence)editable) ^ true;
        this.updateSubmitButton(bl);
        this.updateVoiceButton(bl ^ true);
        this.updateCloseButton();
        this.updateSubmitArea();
        if (this.mOnQueryChangeListener != null && !TextUtils.equals((CharSequence)charSequence, (CharSequence)this.mOldQueryText)) {
            this.mOnQueryChangeListener.onQueryTextChange(charSequence.toString());
        }
        this.mOldQueryText = charSequence.toString();
    }

    void onTextFocusChanged() {
        this.updateViewsVisibility(this.isIconified());
        this.postUpdateFocusedState();
        if (this.mSearchSrcTextView.hasFocus()) {
            this.forceSuggestionQuery();
        }
    }

    void onVoiceClicked() {
        SearchableInfo searchableInfo = this.mSearchable;
        if (searchableInfo == null) {
            return;
        }
        try {
            if (searchableInfo.getVoiceSearchLaunchWebSearch()) {
                searchableInfo = this.createVoiceWebSearchIntent(this.mVoiceWebSearchIntent, searchableInfo);
                SearchView.safedk_Context_startActivity_97cb3195734cf5c9cc3418feeafa6dd6(this.getContext(), (Intent)searchableInfo);
            } else if (searchableInfo.getVoiceSearchLaunchRecognizer()) {
                searchableInfo = this.createVoiceAppSearchIntent(this.mVoiceAppSearchIntent, searchableInfo);
                SearchView.safedk_Context_startActivity_97cb3195734cf5c9cc3418feeafa6dd6(this.getContext(), (Intent)searchableInfo);
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w((String)LOG_TAG, (String)"Could not find voice search activity");
        }
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        this.postUpdateFocusedState();
    }

    public boolean requestFocus(int n2, Rect rect) {
        if (this.mClearingFocus) {
            return false;
        }
        if (!this.isFocusable()) {
            return false;
        }
        if (!this.isIconified()) {
            boolean bl = this.mSearchSrcTextView.requestFocus(n2, rect);
            if (bl) {
                this.updateViewsVisibility(false);
            }
            return bl;
        }
        return super.requestFocus(n2, rect);
    }

    public void setAppSearchData(Bundle bundle) {
        this.mAppSearchData = bundle;
    }

    public void setIconified(boolean bl) {
        if (bl) {
            this.onCloseClicked();
        } else {
            this.onSearchClicked();
        }
    }

    public void setIconifiedByDefault(boolean bl) {
        if (this.mIconifiedByDefault == bl) {
            return;
        }
        this.mIconifiedByDefault = bl;
        this.updateViewsVisibility(bl);
        this.updateQueryHint();
    }

    public void setImeOptions(int n2) {
        this.mSearchSrcTextView.setImeOptions(n2);
    }

    public void setInputType(int n2) {
        this.mSearchSrcTextView.setInputType(n2);
    }

    public void setMaxWidth(int n2) {
        this.mMaxWidth = n2;
        this.requestLayout();
    }

    public void setOnCloseListener(OnCloseListener onCloseListener) {
        this.mOnCloseListener = onCloseListener;
    }

    public void setOnQueryTextFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mOnQueryTextFocusChangeListener = onFocusChangeListener;
    }

    public void setOnQueryTextListener(OnQueryTextListener onQueryTextListener) {
        this.mOnQueryChangeListener = onQueryTextListener;
    }

    public void setOnSearchClickListener(View.OnClickListener onClickListener) {
        this.mOnSearchClickListener = onClickListener;
    }

    public void setOnSuggestionListener(OnSuggestionListener onSuggestionListener) {
        this.mOnSuggestionListener = onSuggestionListener;
    }

    public void setQuery(CharSequence charSequence, boolean bl) {
        this.mSearchSrcTextView.setText(charSequence);
        if (charSequence != null) {
            SearchAutoComplete searchAutoComplete = this.mSearchSrcTextView;
            searchAutoComplete.setSelection(searchAutoComplete.length());
            this.mUserQuery = charSequence;
        }
        if (bl && !TextUtils.isEmpty((CharSequence)charSequence)) {
            this.onSubmitQuery();
        }
    }

    public void setQueryHint(CharSequence charSequence) {
        this.mQueryHint = charSequence;
        this.updateQueryHint();
    }

    public void setQueryRefinementEnabled(boolean bl) {
        this.mQueryRefinement = bl;
        CursorAdapter cursorAdapter = this.mSuggestionsAdapter;
        if (cursorAdapter instanceof SuggestionsAdapter) {
            cursorAdapter = (SuggestionsAdapter)cursorAdapter;
            int n2 = bl ? 2 : 1;
            cursorAdapter.setQueryRefinement(n2);
        }
    }

    public void setSearchableInfo(SearchableInfo searchableInfo) {
        this.mSearchable = searchableInfo;
        if (this.mSearchable != null) {
            this.updateSearchAutoComplete();
            this.updateQueryHint();
        }
        this.mVoiceButtonEnabled = this.hasVoiceSearch();
        if (this.mVoiceButtonEnabled) {
            this.mSearchSrcTextView.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
        }
        this.updateViewsVisibility(this.isIconified());
    }

    public void setSubmitButtonEnabled(boolean bl) {
        this.mSubmitButtonEnabled = bl;
        this.updateViewsVisibility(this.isIconified());
    }

    public void setSuggestionsAdapter(CursorAdapter cursorAdapter) {
        this.mSuggestionsAdapter = cursorAdapter;
        this.mSearchSrcTextView.setAdapter((ListAdapter)this.mSuggestionsAdapter);
    }

    void updateFocusedState() {
        int[] nArray = this.mSearchSrcTextView.hasFocus() ? FOCUSED_STATE_SET : EMPTY_STATE_SET;
        Drawable drawable2 = this.mSearchPlate.getBackground();
        if (drawable2 != null) {
            drawable2.setState(nArray);
        }
        if ((drawable2 = this.mSubmitArea.getBackground()) != null) {
            drawable2.setState(nArray);
        }
        this.invalidate();
    }

    public static interface OnCloseListener {
        public boolean onClose();
    }

    public static interface OnQueryTextListener {
        public boolean onQueryTextChange(String var1);

        public boolean onQueryTextSubmit(String var1);
    }

    public static interface OnSuggestionListener {
        public boolean onSuggestionClick(int var1);

        public boolean onSuggestionSelect(int var1);
    }

    private static class PreQAutoCompleteTextViewReflector {
        private Method mDoAfterTextChanged = null;
        private Method mDoBeforeTextChanged = null;
        private Method mEnsureImeVisible = null;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        PreQAutoCompleteTextViewReflector() {
            PreQAutoCompleteTextViewReflector.preApi29Check();
            try {
                this.mDoBeforeTextChanged = AutoCompleteTextView.class.getDeclaredMethod("doBeforeTextChanged", new Class[0]);
                this.mDoBeforeTextChanged.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                this.mDoAfterTextChanged = AutoCompleteTextView.class.getDeclaredMethod("doAfterTextChanged", new Class[0]);
                this.mDoAfterTextChanged.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                this.mEnsureImeVisible = AutoCompleteTextView.class.getMethod("ensureImeVisible", Boolean.TYPE);
                this.mEnsureImeVisible.setAccessible(true);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }

        private static void preApi29Check() {
            if (Build.VERSION.SDK_INT < 29) {
                return;
            }
            throw new UnsupportedClassVersionError("This function can only be used for API Level < 29.");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doAfterTextChanged(AutoCompleteTextView autoCompleteTextView) {
            PreQAutoCompleteTextViewReflector.preApi29Check();
            Method method = this.mDoAfterTextChanged;
            if (method == null) return;
            try {
                method.invoke((Object)autoCompleteTextView, new Object[0]);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doBeforeTextChanged(AutoCompleteTextView autoCompleteTextView) {
            PreQAutoCompleteTextViewReflector.preApi29Check();
            Method method = this.mDoBeforeTextChanged;
            if (method == null) return;
            try {
                method.invoke((Object)autoCompleteTextView, new Object[0]);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void ensureImeVisible(AutoCompleteTextView autoCompleteTextView) {
            PreQAutoCompleteTextViewReflector.preApi29Check();
            Method method = this.mEnsureImeVisible;
            if (method == null) return;
            try {
                method.invoke((Object)autoCompleteTextView, true);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        boolean isIconified;

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.isIconified = (Boolean)parcel.readValue(null);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SearchView.SavedState{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode((Object)this)));
            stringBuilder.append(" isIconified=");
            stringBuilder.append(this.isIconified);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeValue((Object)this.isIconified);
        }
    }

    public static class SearchAutoComplete
    extends AppCompatAutoCompleteTextView {
        private boolean mHasPendingShowSoftInputRequest;
        final Runnable mRunShowSoftInputIfNecessary = new Runnable(){

            @Override
            public void run() {
                SearchAutoComplete.this.showSoftInputIfNecessary();
            }
        };
        private SearchView mSearchView;
        private int mThreshold = this.getThreshold();

        public SearchAutoComplete(Context context) {
            this(context, null);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet) {
            this(context, attributeSet, R.attr.autoCompleteTextViewStyle);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet, int n2) {
            super(context, attributeSet, n2);
        }

        private int getSearchViewTextMinWidthDp() {
            Configuration configuration = this.getResources().getConfiguration();
            int n2 = configuration.screenWidthDp;
            int n3 = configuration.screenHeightDp;
            if (n2 >= 960 && n3 >= 720 && configuration.orientation == 2) {
                return 256;
            }
            if (n2 < 600 && (n2 < 640 || n3 < 480)) {
                return 160;
            }
            return 192;
        }

        public boolean enoughToFilter() {
            boolean bl = this.mThreshold <= 0 || super.enoughToFilter();
            return bl;
        }

        void ensureImeVisible() {
            if (Build.VERSION.SDK_INT >= 29) {
                this.setInputMethodMode(1);
                if (this.enoughToFilter()) {
                    this.showDropDown();
                }
            } else {
                PRE_API_29_HIDDEN_METHOD_INVOKER.ensureImeVisible((AutoCompleteTextView)this);
            }
        }

        boolean isEmpty() {
            boolean bl = TextUtils.getTrimmedLength((CharSequence)this.getText()) == 0;
            return bl;
        }

        public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
            editorInfo = super.onCreateInputConnection(editorInfo);
            if (this.mHasPendingShowSoftInputRequest) {
                this.removeCallbacks(this.mRunShowSoftInputIfNecessary);
                this.post(this.mRunShowSoftInputIfNecessary);
            }
            return editorInfo;
        }

        protected void onFinishInflate() {
            super.onFinishInflate();
            DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
            this.setMinWidth((int)TypedValue.applyDimension((int)1, (float)this.getSearchViewTextMinWidthDp(), (DisplayMetrics)displayMetrics));
        }

        protected void onFocusChanged(boolean bl, int n2, Rect rect) {
            super.onFocusChanged(bl, n2, rect);
            this.mSearchView.onTextFocusChanged();
        }

        public boolean onKeyPreIme(int n2, KeyEvent keyEvent) {
            if (n2 == 4) {
                if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                    if (dispatcherState != null) {
                        dispatcherState.startTracking(keyEvent, (Object)this);
                    }
                    return true;
                }
                if (keyEvent.getAction() == 1) {
                    KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                    if (dispatcherState != null) {
                        dispatcherState.handleUpEvent(keyEvent);
                    }
                    if (keyEvent.isTracking() && !keyEvent.isCanceled()) {
                        this.mSearchView.clearFocus();
                        this.setImeVisibility(false);
                        return true;
                    }
                }
            }
            return super.onKeyPreIme(n2, keyEvent);
        }

        public void onWindowFocusChanged(boolean bl) {
            super.onWindowFocusChanged(bl);
            if (bl && this.mSearchView.hasFocus() && this.getVisibility() == 0) {
                this.mHasPendingShowSoftInputRequest = true;
                if (SearchView.isLandscapeMode(this.getContext())) {
                    this.ensureImeVisible();
                }
            }
        }

        public void performCompletion() {
        }

        protected void replaceText(CharSequence charSequence) {
        }

        void setImeVisibility(boolean bl) {
            InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
            if (!bl) {
                this.mHasPendingShowSoftInputRequest = false;
                this.removeCallbacks(this.mRunShowSoftInputIfNecessary);
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
                return;
            }
            if (inputMethodManager.isActive((View)this)) {
                this.mHasPendingShowSoftInputRequest = false;
                this.removeCallbacks(this.mRunShowSoftInputIfNecessary);
                inputMethodManager.showSoftInput((View)this, 0);
                return;
            }
            this.mHasPendingShowSoftInputRequest = true;
        }

        void setSearchView(SearchView searchView) {
            this.mSearchView = searchView;
        }

        public void setThreshold(int n2) {
            super.setThreshold(n2);
            this.mThreshold = n2;
        }

        void showSoftInputIfNecessary() {
            if (this.mHasPendingShowSoftInputRequest) {
                ((InputMethodManager)this.getContext().getSystemService("input_method")).showSoftInput((View)this, 0);
                this.mHasPendingShowSoftInputRequest = false;
            }
        }
    }

    private static class UpdatableTouchDelegate
    extends TouchDelegate {
        private final Rect mActualBounds;
        private boolean mDelegateTargeted;
        private final View mDelegateView;
        private final int mSlop;
        private final Rect mSlopBounds;
        private final Rect mTargetBounds;

        public UpdatableTouchDelegate(Rect rect, Rect rect2, View view) {
            super(rect, view);
            this.mSlop = ViewConfiguration.get((Context)view.getContext()).getScaledTouchSlop();
            this.mTargetBounds = new Rect();
            this.mSlopBounds = new Rect();
            this.mActualBounds = new Rect();
            this.setBounds(rect, rect2);
            this.mDelegateView = view;
        }

        /*
         * Unable to fully structure code
         */
        public boolean onTouchEvent(MotionEvent var1_1) {
            block9: {
                block7: {
                    block8: {
                        var2_2 = (int)var1_1.getX();
                        var3_3 = (int)var1_1.getY();
                        var4_4 = var1_1.getAction();
                        var5_5 = 1;
                        var6_6 = false;
                        if (var4_4 == 0) break block7;
                        if (var4_4 == 1 || var4_4 == 2) break block8;
                        if (var4_4 != 3) ** GOTO lbl-1000
                        var7_7 = this.mDelegateTargeted;
                        this.mDelegateTargeted = false;
                        var4_4 = var5_5;
                        break block9;
                    }
                    var7_7 = var8_8 = this.mDelegateTargeted;
                    var4_4 = var5_5;
                    if (var8_8) {
                        var7_7 = var8_8;
                        var4_4 = var5_5;
                        if (!this.mSlopBounds.contains(var2_2, var3_3)) {
                            var4_4 = 0;
                            var7_7 = var8_8;
                        }
                    }
                    break block9;
                }
                if (this.mTargetBounds.contains(var2_2, var3_3)) {
                    this.mDelegateTargeted = true;
                    var7_7 = true;
                    var4_4 = var5_5;
                } else lbl-1000:
                // 2 sources

                {
                    var7_7 = false;
                    var4_4 = var5_5;
                }
            }
            if (var7_7) {
                if (var4_4 != 0 && !this.mActualBounds.contains(var2_2, var3_3)) {
                    var1_1.setLocation((float)(this.mDelegateView.getWidth() / 2), (float)(this.mDelegateView.getHeight() / 2));
                } else {
                    var1_1.setLocation((float)(var2_2 - this.mActualBounds.left), (float)(var3_3 - this.mActualBounds.top));
                }
                var6_6 = this.mDelegateView.dispatchTouchEvent(var1_1);
            }
            return var6_6;
        }

        public void setBounds(Rect rect, Rect rect2) {
            this.mTargetBounds.set(rect);
            this.mSlopBounds.set(rect);
            rect = this.mSlopBounds;
            int n2 = this.mSlop;
            rect.inset(-n2, -n2);
            this.mActualBounds.set(rect2);
        }
    }
}

