/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.appcompat.R;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.view.ActionBarPolicy;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatSpinner;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.appcompat.widget.TintTypedArray;
import androidx.appcompat.widget.TooltipCompat;

public class ScrollingTabContainerView
extends HorizontalScrollView
implements AdapterView.OnItemSelectedListener {
    private static final int FADE_DURATION = 200;
    private static final String TAG = "ScrollingTabContainerView";
    private static final Interpolator sAlphaInterpolator = new DecelerateInterpolator();
    private boolean mAllowCollapse;
    private int mContentHeight;
    int mMaxTabWidth;
    private int mSelectedTabIndex;
    int mStackedTabMaxWidth;
    private TabClickListener mTabClickListener;
    LinearLayoutCompat mTabLayout;
    Runnable mTabSelector;
    private Spinner mTabSpinner;
    protected final VisibilityAnimListener mVisAnimListener = new VisibilityAnimListener();
    protected ViewPropertyAnimator mVisibilityAnim;

    public ScrollingTabContainerView(Context context) {
        super(context);
        this.setHorizontalScrollBarEnabled(false);
        context = ActionBarPolicy.get((Context)context);
        this.setContentHeight(context.getTabContainerHeight());
        this.mStackedTabMaxWidth = context.getStackedTabMaxWidth();
        this.mTabLayout = this.createTabLayout();
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
    }

    private Spinner createSpinner() {
        AppCompatSpinner appCompatSpinner = new AppCompatSpinner(this.getContext(), null, R.attr.actionDropDownStyle);
        appCompatSpinner.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(-2, -1));
        appCompatSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        return appCompatSpinner;
    }

    private LinearLayoutCompat createTabLayout() {
        LinearLayoutCompat linearLayoutCompat = new LinearLayoutCompat(this.getContext(), null, R.attr.actionBarTabBarStyle);
        linearLayoutCompat.setMeasureWithLargestChildEnabled(true);
        linearLayoutCompat.setGravity(17);
        linearLayoutCompat.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(-2, -1));
        return linearLayoutCompat;
    }

    private boolean isCollapsed() {
        Spinner spinner = this.mTabSpinner;
        boolean bl = spinner != null && spinner.getParent() == this;
        return bl;
    }

    private void performCollapse() {
        Runnable runnable2;
        if (this.isCollapsed()) {
            return;
        }
        if (this.mTabSpinner == null) {
            this.mTabSpinner = this.createSpinner();
        }
        this.removeView((View)this.mTabLayout);
        this.addView((View)this.mTabSpinner, new ViewGroup.LayoutParams(-2, -1));
        if (this.mTabSpinner.getAdapter() == null) {
            this.mTabSpinner.setAdapter((SpinnerAdapter)new TabAdapter());
        }
        if ((runnable2 = this.mTabSelector) != null) {
            this.removeCallbacks(runnable2);
            this.mTabSelector = null;
        }
        this.mTabSpinner.setSelection(this.mSelectedTabIndex);
    }

    private boolean performExpand() {
        if (!this.isCollapsed()) {
            return false;
        }
        this.removeView((View)this.mTabSpinner);
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
        this.setTabSelected(this.mTabSpinner.getSelectedItemPosition());
        return false;
    }

    public void addTab(ActionBar.Tab tab, int n2, boolean bl) {
        TabView tabView = this.createTabView(tab, false);
        this.mTabLayout.addView((View)tabView, n2, (ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(0, -1, 1.0f));
        tab = this.mTabSpinner;
        if (tab != null) {
            ((TabAdapter)tab.getAdapter()).notifyDataSetChanged();
        }
        if (bl) {
            tabView.setSelected(true);
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    public void addTab(ActionBar.Tab tab, boolean bl) {
        TabView tabView = this.createTabView(tab, false);
        this.mTabLayout.addView((View)tabView, (ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(0, -1, 1.0f));
        tab = this.mTabSpinner;
        if (tab != null) {
            ((TabAdapter)tab.getAdapter()).notifyDataSetChanged();
        }
        if (bl) {
            tabView.setSelected(true);
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    public void animateToTab(int n2) {
        final View view = this.mTabLayout.getChildAt(n2);
        Runnable runnable2 = this.mTabSelector;
        if (runnable2 != null) {
            this.removeCallbacks(runnable2);
        }
        this.mTabSelector = new Runnable(){

            @Override
            public void run() {
                int n2 = view.getLeft();
                int n3 = (ScrollingTabContainerView.this.getWidth() - view.getWidth()) / 2;
                ScrollingTabContainerView.this.smoothScrollTo(n2 - n3, 0);
                ScrollingTabContainerView.this.mTabSelector = null;
            }
        };
        this.post(this.mTabSelector);
    }

    public void animateToVisibility(int n2) {
        ViewPropertyAnimator viewPropertyAnimator = this.mVisibilityAnim;
        if (viewPropertyAnimator != null) {
            viewPropertyAnimator.cancel();
        }
        if (n2 == 0) {
            if (this.getVisibility() != 0) {
                this.setAlpha(0.0f);
            }
            viewPropertyAnimator = this.animate().alpha(1.0f);
            viewPropertyAnimator.setDuration(200L);
            viewPropertyAnimator.setInterpolator((TimeInterpolator)sAlphaInterpolator);
            viewPropertyAnimator.setListener((Animator.AnimatorListener)this.mVisAnimListener.withFinalVisibility(viewPropertyAnimator, n2));
            viewPropertyAnimator.start();
        } else {
            viewPropertyAnimator = this.animate().alpha(0.0f);
            viewPropertyAnimator.setDuration(200L);
            viewPropertyAnimator.setInterpolator((TimeInterpolator)sAlphaInterpolator);
            viewPropertyAnimator.setListener((Animator.AnimatorListener)this.mVisAnimListener.withFinalVisibility(viewPropertyAnimator, n2));
            viewPropertyAnimator.start();
        }
    }

    TabView createTabView(ActionBar.Tab object, boolean bl) {
        object = new TabView(this.getContext(), (ActionBar.Tab)object, bl);
        if (bl) {
            object.setBackgroundDrawable(null);
            object.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, this.mContentHeight));
        } else {
            object.setFocusable(true);
            if (this.mTabClickListener == null) {
                this.mTabClickListener = new TabClickListener();
            }
            object.setOnClickListener(this.mTabClickListener);
        }
        return object;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Runnable runnable2 = this.mTabSelector;
        if (runnable2 != null) {
            this.post(runnable2);
        }
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        configuration = ActionBarPolicy.get((Context)this.getContext());
        this.setContentHeight(configuration.getTabContainerHeight());
        this.mStackedTabMaxWidth = configuration.getStackedTabMaxWidth();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Runnable runnable2 = this.mTabSelector;
        if (runnable2 != null) {
            this.removeCallbacks(runnable2);
        }
    }

    public void onItemSelected(AdapterView<?> adapterView, View view, int n2, long l2) {
        ((TabView)view).getTab().select();
    }

    public void onMeasure(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        n3 = 1;
        boolean bl = n4 == 0x40000000;
        this.setFillViewport(bl);
        int n5 = this.mTabLayout.getChildCount();
        if (n5 > 1 && (n4 == 0x40000000 || n4 == Integer.MIN_VALUE)) {
            this.mMaxTabWidth = n5 > 2 ? (int)((float)View.MeasureSpec.getSize((int)n2) * 0.4f) : View.MeasureSpec.getSize((int)n2) / 2;
            this.mMaxTabWidth = Math.min(this.mMaxTabWidth, this.mStackedTabMaxWidth);
        } else {
            this.mMaxTabWidth = -1;
        }
        n4 = View.MeasureSpec.makeMeasureSpec((int)this.mContentHeight, (int)0x40000000);
        if (bl || !this.mAllowCollapse) {
            n3 = 0;
        }
        if (n3 != 0) {
            this.mTabLayout.measure(0, n4);
            if (this.mTabLayout.getMeasuredWidth() > View.MeasureSpec.getSize((int)n2)) {
                this.performCollapse();
            } else {
                this.performExpand();
            }
        } else {
            this.performExpand();
        }
        n3 = this.getMeasuredWidth();
        super.onMeasure(n2, n4);
        n2 = this.getMeasuredWidth();
        if (bl && n3 != n2) {
            this.setTabSelected(this.mSelectedTabIndex);
        }
    }

    public void onNothingSelected(AdapterView<?> adapterView) {
    }

    public void removeAllTabs() {
        this.mTabLayout.removeAllViews();
        Spinner spinner = this.mTabSpinner;
        if (spinner != null) {
            ((TabAdapter)spinner.getAdapter()).notifyDataSetChanged();
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    public void removeTabAt(int n2) {
        this.mTabLayout.removeViewAt(n2);
        Spinner spinner = this.mTabSpinner;
        if (spinner != null) {
            ((TabAdapter)spinner.getAdapter()).notifyDataSetChanged();
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    public void setAllowCollapse(boolean bl) {
        this.mAllowCollapse = bl;
    }

    public void setContentHeight(int n2) {
        this.mContentHeight = n2;
        this.requestLayout();
    }

    public void setTabSelected(int n2) {
        Spinner spinner;
        this.mSelectedTabIndex = n2;
        int n3 = this.mTabLayout.getChildCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            spinner = this.mTabLayout.getChildAt(i2);
            boolean bl = i2 == n2;
            spinner.setSelected(bl);
            if (!bl) continue;
            this.animateToTab(n2);
        }
        spinner = this.mTabSpinner;
        if (spinner != null && n2 >= 0) {
            spinner.setSelection(n2);
        }
    }

    public void updateTab(int n2) {
        ((TabView)this.mTabLayout.getChildAt(n2)).update();
        Spinner spinner = this.mTabSpinner;
        if (spinner != null) {
            ((TabAdapter)spinner.getAdapter()).notifyDataSetChanged();
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    private class TabAdapter
    extends BaseAdapter {
        TabAdapter() {
        }

        public int getCount() {
            return ScrollingTabContainerView.this.mTabLayout.getChildCount();
        }

        public Object getItem(int n2) {
            return ((TabView)ScrollingTabContainerView.this.mTabLayout.getChildAt(n2)).getTab();
        }

        public long getItemId(int n2) {
            return n2;
        }

        public View getView(int n2, View object, ViewGroup viewGroup) {
            if (object == null) {
                object = ScrollingTabContainerView.this.createTabView((ActionBar.Tab)this.getItem(n2), true);
            } else {
                ((TabView)((Object)object)).bindTab((ActionBar.Tab)this.getItem(n2));
            }
            return object;
        }
    }

    private class TabClickListener
    implements View.OnClickListener {
        TabClickListener() {
        }

        public void onClick(View view) {
            ((TabView)view).getTab().select();
            int n2 = ScrollingTabContainerView.this.mTabLayout.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view2 = ScrollingTabContainerView.this.mTabLayout.getChildAt(i2);
                boolean bl = view2 == view;
                view2.setSelected(bl);
            }
        }
    }

    private class TabView
    extends LinearLayout {
        private static final String ACCESSIBILITY_CLASS_NAME = "androidx.appcompat.app.ActionBar$Tab";
        private final int[] BG_ATTRS;
        private View mCustomView;
        private ImageView mIconView;
        private ActionBar.Tab mTab;
        private TextView mTextView;

        public TabView(Context context, ActionBar.Tab tab, boolean bl) {
            super(context, null, R.attr.actionBarTabStyle);
            this.BG_ATTRS = new int[]{16842964};
            this.mTab = tab;
            ScrollingTabContainerView.this = TintTypedArray.obtainStyledAttributes((Context)context, null, (int[])this.BG_ATTRS, (int)R.attr.actionBarTabStyle, (int)0);
            if (ScrollingTabContainerView.this.hasValue(0)) {
                this.setBackgroundDrawable(ScrollingTabContainerView.this.getDrawable(0));
            }
            ScrollingTabContainerView.this.recycle();
            if (bl) {
                this.setGravity(8388627);
            }
            this.update();
        }

        public void bindTab(ActionBar.Tab tab) {
            this.mTab = tab;
            this.update();
        }

        public ActionBar.Tab getTab() {
            return this.mTab;
        }

        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
        }

        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
            super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
            accessibilityNodeInfo.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
        }

        public void onMeasure(int n2, int n3) {
            super.onMeasure(n2, n3);
            if (ScrollingTabContainerView.this.mMaxTabWidth > 0 && this.getMeasuredWidth() > ScrollingTabContainerView.this.mMaxTabWidth) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)ScrollingTabContainerView.this.mMaxTabWidth, (int)0x40000000), n3);
            }
        }

        public void setSelected(boolean bl) {
            boolean bl2 = this.isSelected() != bl;
            super.setSelected(bl);
            if (bl2 && bl) {
                this.sendAccessibilityEvent(4);
            }
        }

        public void update() {
            ActionBar.Tab tab = this.mTab;
            Object object = tab.getCustomView();
            Object object2 = null;
            if (object != null) {
                object2 = object.getParent();
                if (object2 != this) {
                    if (object2 != null) {
                        ((ViewGroup)object2).removeView(object);
                    }
                    this.addView((View)object);
                }
                this.mCustomView = object;
                object2 = this.mTextView;
                if (object2 != null) {
                    object2.setVisibility(8);
                }
                if ((object2 = this.mIconView) != null) {
                    object2.setVisibility(8);
                    this.mIconView.setImageDrawable(null);
                }
            } else {
                LinearLayout.LayoutParams layoutParams;
                ImageView imageView;
                object = this.mCustomView;
                if (object != null) {
                    this.removeView((View)object);
                    this.mCustomView = null;
                }
                Drawable drawable2 = tab.getIcon();
                object = tab.getText();
                if (drawable2 != null) {
                    if (this.mIconView == null) {
                        imageView = new AppCompatImageView(this.getContext());
                        layoutParams = new LinearLayout.LayoutParams(-2, -2);
                        layoutParams.gravity = 16;
                        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        this.addView((View)imageView, 0);
                        this.mIconView = imageView;
                    }
                    this.mIconView.setImageDrawable(drawable2);
                    this.mIconView.setVisibility(0);
                } else {
                    imageView = this.mIconView;
                    if (imageView != null) {
                        imageView.setVisibility(8);
                        this.mIconView.setImageDrawable(null);
                    }
                }
                boolean bl = TextUtils.isEmpty((CharSequence)object) ^ true;
                if (bl) {
                    if (this.mTextView == null) {
                        imageView = new AppCompatTextView(this.getContext(), null, R.attr.actionBarTabTextStyle);
                        imageView.setEllipsize(TextUtils.TruncateAt.END);
                        layoutParams = new LinearLayout.LayoutParams(-2, -2);
                        layoutParams.gravity = 16;
                        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        this.addView((View)imageView);
                        this.mTextView = imageView;
                    }
                    this.mTextView.setText((CharSequence)object);
                    this.mTextView.setVisibility(0);
                } else {
                    object = this.mTextView;
                    if (object != null) {
                        object.setVisibility(8);
                        this.mTextView.setText(null);
                    }
                }
                object = this.mIconView;
                if (object != null) {
                    object.setContentDescription(tab.getContentDescription());
                }
                if (!bl) {
                    object2 = tab.getContentDescription();
                }
                TooltipCompat.setTooltipText((View)this, (CharSequence)object2);
            }
        }
    }

    protected class VisibilityAnimListener
    extends AnimatorListenerAdapter {
        private boolean mCanceled = false;
        private int mFinalVisibility;

        protected VisibilityAnimListener() {
        }

        public void onAnimationCancel(Animator animator) {
            this.mCanceled = true;
        }

        public void onAnimationEnd(Animator object) {
            if (this.mCanceled) {
                return;
            }
            object = ScrollingTabContainerView.this;
            object.mVisibilityAnim = null;
            object.setVisibility(this.mFinalVisibility);
        }

        public void onAnimationStart(Animator animator) {
            ScrollingTabContainerView.this.setVisibility(0);
            this.mCanceled = false;
        }

        public VisibilityAnimListener withFinalVisibility(ViewPropertyAnimator viewPropertyAnimator, int n2) {
            this.mFinalVisibility = n2;
            ScrollingTabContainerView.this.mVisibilityAnim = viewPropertyAnimator;
            return this;
        }
    }
}

