/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import androidx.appcompat.graphics.drawable.AnimatedStateListDrawableCompat;
import androidx.appcompat.resources.R;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintInfo;
import androidx.appcompat.widget.VectorEnabledTintResources;
import androidx.collection.LongSparseArray;
import androidx.collection.LruCache;
import androidx.collection.SimpleArrayMap;
import androidx.collection.SparseArrayCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResourceManagerInternal {
    private static final ColorFilterLruCache COLOR_FILTER_CACHE;
    private static final boolean DEBUG = false;
    private static final PorterDuff.Mode DEFAULT_MODE;
    private static ResourceManagerInternal INSTANCE;
    private static final String PLATFORM_VD_CLAZZ = "android.graphics.drawable.VectorDrawable";
    private static final String SKIP_DRAWABLE_TAG = "appcompat_skip_skip";
    private static final String TAG = "ResourceManagerInternal";
    private SimpleArrayMap<String, InflateDelegate> mDelegates;
    private final WeakHashMap<Context, LongSparseArray<WeakReference<Drawable.ConstantState>>> mDrawableCaches = new WeakHashMap(0);
    private boolean mHasCheckedVectorDrawableSetup;
    private ResourceManagerHooks mHooks;
    private SparseArrayCompat<String> mKnownDrawableIdTags;
    private WeakHashMap<Context, SparseArrayCompat<ColorStateList>> mTintLists;
    private TypedValue mTypedValue;

    static {
        DEFAULT_MODE = PorterDuff.Mode.SRC_IN;
        COLOR_FILTER_CACHE = new ColorFilterLruCache(6);
    }

    private void addDelegate(String string2, InflateDelegate inflateDelegate) {
        if (this.mDelegates == null) {
            this.mDelegates = new SimpleArrayMap();
        }
        this.mDelegates.put((Object)string2, (Object)inflateDelegate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addDrawableToCache(Context object, long l2, Drawable longSparseArray) {
        synchronized (this) {
            LongSparseArray longSparseArray2;
            Drawable.ConstantState constantState = longSparseArray.getConstantState();
            if (constantState == null) {
                return false;
            }
            longSparseArray = longSparseArray2 = this.mDrawableCaches.get(object);
            if (longSparseArray2 == null) {
                longSparseArray = new LongSparseArray();
                this.mDrawableCaches.put((Context)object, (LongSparseArray<WeakReference<Drawable.ConstantState>>)longSparseArray);
            }
            WeakReference<Drawable.ConstantState> weakReference = new WeakReference<Drawable.ConstantState>(constantState);
            longSparseArray.put(l2, weakReference);
            return true;
        }
    }

    private void addTintListToCache(Context context, int n2, ColorStateList colorStateList) {
        SparseArrayCompat sparseArrayCompat;
        if (this.mTintLists == null) {
            this.mTintLists = new WeakHashMap();
        }
        SparseArrayCompat sparseArrayCompat2 = sparseArrayCompat = this.mTintLists.get(context);
        if (sparseArrayCompat == null) {
            sparseArrayCompat2 = new SparseArrayCompat();
            this.mTintLists.put(context, (SparseArrayCompat<ColorStateList>)sparseArrayCompat2);
        }
        sparseArrayCompat2.append(n2, (Object)colorStateList);
    }

    private void checkVectorDrawableSetup(Context context) {
        if (this.mHasCheckedVectorDrawableSetup) {
            return;
        }
        this.mHasCheckedVectorDrawableSetup = true;
        if ((context = this.getDrawable(context, R.drawable.abc_vector_test)) != null && ResourceManagerInternal.isVectorDrawable((Drawable)context)) {
            return;
        }
        this.mHasCheckedVectorDrawableSetup = false;
        throw new IllegalStateException("This app has been built with an incorrect configuration. Please configure your build for VectorDrawableCompat.");
    }

    private static long createCacheKey(TypedValue typedValue) {
        return (long)typedValue.assetCookie << 32 | (long)typedValue.data;
    }

    private Drawable createDrawableIfNeeded(Context context, int n2) {
        if (this.mTypedValue == null) {
            this.mTypedValue = new TypedValue();
        }
        TypedValue typedValue = this.mTypedValue;
        context.getResources().getValue(n2, typedValue, true);
        long l2 = ResourceManagerInternal.createCacheKey(typedValue);
        Object object = this.getCachedDrawable(context, l2);
        if (object != null) {
            return object;
        }
        object = this.mHooks;
        object = object == null ? null : object.createDrawableFor(this, context, n2);
        if (object != null) {
            object.setChangingConfigurations(typedValue.changingConfigurations);
            this.addDrawableToCache(context, l2, (Drawable)object);
        }
        return object;
    }

    private static PorterDuffColorFilter createTintFilter(ColorStateList colorStateList, PorterDuff.Mode mode, int[] nArray) {
        if (colorStateList != null && mode != null) {
            return ResourceManagerInternal.getPorterDuffColorFilter(colorStateList.getColorForState(nArray, 0), mode);
        }
        return null;
    }

    public static ResourceManagerInternal get() {
        synchronized (ResourceManagerInternal.class) {
            ResourceManagerInternal resourceManagerInternal;
            if (INSTANCE == null) {
                INSTANCE = resourceManagerInternal = new ResourceManagerInternal();
                ResourceManagerInternal.installDefaultInflateDelegates(INSTANCE);
            }
            resourceManagerInternal = INSTANCE;
            return resourceManagerInternal;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getCachedDrawable(Context context, long l2) {
        synchronized (this) {
            LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray;
            block8: {
                block7: {
                    longSparseArray = this.mDrawableCaches.get(context);
                    if (longSparseArray != null) break block7;
                    return null;
                }
                WeakReference weakReference = (WeakReference)longSparseArray.get(l2);
                if (weakReference == null) return null;
                weakReference = (Drawable.ConstantState)weakReference.get();
                if (weakReference == null) break block8;
                return weakReference.newDrawable(context.getResources());
            }
            longSparseArray.remove(l2);
            return null;
        }
    }

    public static PorterDuffColorFilter getPorterDuffColorFilter(int n2, PorterDuff.Mode mode) {
        synchronized (ResourceManagerInternal.class) {
            PorterDuffColorFilter porterDuffColorFilter;
            block5: {
                PorterDuffColorFilter porterDuffColorFilter2;
                porterDuffColorFilter = porterDuffColorFilter2 = COLOR_FILTER_CACHE.get(n2, mode);
                if (porterDuffColorFilter2 != null) break block5;
                porterDuffColorFilter = new PorterDuffColorFilter(n2, mode);
                COLOR_FILTER_CACHE.put(n2, mode, porterDuffColorFilter);
            }
            return porterDuffColorFilter;
            finally {
            }
        }
    }

    private ColorStateList getTintListFromCache(Context sparseArrayCompat, int n2) {
        ColorStateList colorStateList;
        WeakHashMap<Context, SparseArrayCompat<ColorStateList>> weakHashMap = this.mTintLists;
        ColorStateList colorStateList2 = colorStateList = null;
        if (weakHashMap != null) {
            sparseArrayCompat = weakHashMap.get(sparseArrayCompat);
            colorStateList2 = colorStateList;
            if (sparseArrayCompat != null) {
                colorStateList2 = (ColorStateList)sparseArrayCompat.get(n2);
            }
        }
        return colorStateList2;
    }

    private static void installDefaultInflateDelegates(ResourceManagerInternal resourceManagerInternal) {
        if (Build.VERSION.SDK_INT < 24) {
            resourceManagerInternal.addDelegate("vector", new VdcInflateDelegate());
            resourceManagerInternal.addDelegate("animated-vector", new AvdcInflateDelegate());
            resourceManagerInternal.addDelegate("animated-selector", new AsldcInflateDelegate());
        }
    }

    private static boolean isVectorDrawable(Drawable drawable2) {
        boolean bl = drawable2 instanceof VectorDrawableCompat || PLATFORM_VD_CLAZZ.equals(drawable2.getClass().getName());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable loadDrawableFromDelegates(Context context, int n2) {
        Object object = this.mDelegates;
        if (object != null && !object.isEmpty()) {
            object = this.mKnownDrawableIdTags;
            if (object != null) {
                if (SKIP_DRAWABLE_TAG.equals(object = (String)object.get(n2)) || object != null && this.mDelegates.get(object) == null) {
                    return null;
                }
            } else {
                this.mKnownDrawableIdTags = new SparseArrayCompat();
            }
            if (this.mTypedValue == null) {
                this.mTypedValue = new TypedValue();
            }
            TypedValue typedValue = this.mTypedValue;
            object = context.getResources();
            object.getValue(n2, typedValue, true);
            long l2 = ResourceManagerInternal.createCacheKey(typedValue);
            Drawable drawable2 = this.getCachedDrawable(context, l2);
            if (drawable2 != null) {
                return drawable2;
            }
            Drawable drawable3 = drawable2;
            if (typedValue.string != null) {
                drawable3 = drawable2;
                if (typedValue.string.toString().endsWith(".xml")) {
                    drawable3 = drawable2;
                    try {
                        int n3;
                        XmlResourceParser xmlResourceParser = object.getXml(n2);
                        drawable3 = drawable2;
                        AttributeSet attributeSet = Xml.asAttributeSet((XmlPullParser)xmlResourceParser);
                        do {
                            drawable3 = drawable2;
                        } while ((n3 = xmlResourceParser.next()) != 2 && n3 != 1);
                        if (n3 != 2) {
                            drawable3 = drawable2;
                            drawable3 = drawable2;
                            context = new XmlPullParserException("No start tag found");
                            drawable3 = drawable2;
                            throw context;
                        }
                        drawable3 = drawable2;
                        object = xmlResourceParser.getName();
                        drawable3 = drawable2;
                        this.mKnownDrawableIdTags.append(n2, object);
                        drawable3 = drawable2;
                        InflateDelegate inflateDelegate = (InflateDelegate)this.mDelegates.get(object);
                        object = drawable2;
                        if (inflateDelegate != null) {
                            drawable3 = drawable2;
                            object = inflateDelegate.createFromXmlInner(context, (XmlPullParser)xmlResourceParser, attributeSet, context.getTheme());
                        }
                        drawable3 = object;
                        if (object != null) {
                            drawable3 = object;
                            object.setChangingConfigurations(typedValue.changingConfigurations);
                            drawable3 = object;
                            this.addDrawableToCache(context, l2, (Drawable)object);
                            drawable3 = object;
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)"Exception while inflating drawable", (Throwable)exception);
                    }
                }
            }
            if (drawable3 == null) {
                this.mKnownDrawableIdTags.append(n2, (Object)SKIP_DRAWABLE_TAG);
            }
            return drawable3;
        }
        return null;
    }

    private Drawable tintDrawable(Context context, int n2, boolean bl, Drawable drawable2) {
        Object object = this.getTintList(context, n2);
        if (object != null) {
            context = drawable2;
            if (DrawableUtils.canSafelyMutateDrawable((Drawable)drawable2)) {
                context = drawable2.mutate();
            }
            context = DrawableCompat.wrap((Drawable)context);
            DrawableCompat.setTintList((Drawable)context, (ColorStateList)object);
            drawable2 = this.getTintMode(n2);
            object = context;
            if (drawable2 != null) {
                DrawableCompat.setTintMode((Drawable)context, (PorterDuff.Mode)drawable2);
                object = context;
            }
        } else {
            object = this.mHooks;
            if (object != null && object.tintDrawable(context, n2, drawable2)) {
                object = drawable2;
            } else {
                object = drawable2;
                if (!this.tintDrawableUsingColorFilter(context, n2, drawable2)) {
                    object = drawable2;
                    if (bl) {
                        object = null;
                    }
                }
            }
        }
        return object;
    }

    static void tintDrawable(Drawable drawable2, TintInfo tintInfo, int[] nArray) {
        if (DrawableUtils.canSafelyMutateDrawable((Drawable)drawable2) && drawable2.mutate() != drawable2) {
            Log.d((String)TAG, (String)"Mutated drawable is not the same instance as the input.");
            return;
        }
        if (!tintInfo.mHasTintList && !tintInfo.mHasTintMode) {
            drawable2.clearColorFilter();
        } else {
            ColorStateList colorStateList = tintInfo.mHasTintList ? tintInfo.mTintList : null;
            tintInfo = tintInfo.mHasTintMode ? tintInfo.mTintMode : DEFAULT_MODE;
            drawable2.setColorFilter((ColorFilter)ResourceManagerInternal.createTintFilter(colorStateList, (PorterDuff.Mode)tintInfo, nArray));
        }
        if (Build.VERSION.SDK_INT <= 23) {
            drawable2.invalidateSelf();
        }
    }

    public Drawable getDrawable(Context context, int n2) {
        synchronized (this) {
            context = this.getDrawable(context, n2, false);
            return context;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Drawable getDrawable(Context context, int n2, boolean bl) {
        synchronized (this) {
            void var2_2;
            Drawable drawable2;
            this.checkVectorDrawableSetup(context);
            Drawable drawable3 = drawable2 = this.loadDrawableFromDelegates(context, (int)var2_2);
            if (drawable2 == null) {
                drawable3 = this.createDrawableIfNeeded(context, (int)var2_2);
            }
            drawable2 = drawable3;
            if (drawable3 == null) {
                drawable2 = ContextCompat.getDrawable((Context)context, (int)var2_2);
            }
            drawable3 = drawable2;
            if (drawable2 != null) {
                void var3_3;
                drawable3 = this.tintDrawable(context, (int)var2_2, (boolean)var3_3, drawable2);
            }
            if (drawable3 != null) {
                DrawableUtils.fixDrawable((Drawable)drawable3);
            }
            return drawable3;
        }
    }

    ColorStateList getTintList(Context context, int n2) {
        synchronized (this) {
            ColorStateList colorStateList;
            block7: {
                ColorStateList colorStateList2;
                block9: {
                    block8: {
                        colorStateList = colorStateList2 = this.getTintListFromCache(context, n2);
                        if (colorStateList2 != null) break block7;
                        if (this.mHooks != null) break block8;
                        colorStateList2 = null;
                        break block9;
                    }
                    colorStateList2 = this.mHooks.getTintListForDrawableRes(context, n2);
                }
                colorStateList = colorStateList2;
                if (colorStateList2 != null) {
                    this.addTintListToCache(context, n2, colorStateList2);
                    colorStateList = colorStateList2;
                }
            }
            return colorStateList;
        }
    }

    PorterDuff.Mode getTintMode(int n2) {
        ResourceManagerHooks resourceManagerHooks = this.mHooks;
        resourceManagerHooks = resourceManagerHooks == null ? null : resourceManagerHooks.getTintModeForDrawableRes(n2);
        return resourceManagerHooks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onConfigurationChanged(Context longSparseArray) {
        synchronized (this) {
            longSparseArray = this.mDrawableCaches.get(longSparseArray);
            if (longSparseArray != null) {
                longSparseArray.clear();
            }
            return;
        }
    }

    Drawable onDrawableLoadedFromResources(Context context, VectorEnabledTintResources vectorEnabledTintResources, int n2) {
        synchronized (this) {
            Drawable drawable2;
            block6: {
                Drawable drawable3;
                drawable2 = drawable3 = this.loadDrawableFromDelegates(context, n2);
                if (drawable3 != null) break block6;
                drawable2 = vectorEnabledTintResources.superGetDrawable(n2);
            }
            if (drawable2 != null) {
                context = this.tintDrawable(context, n2, false, drawable2);
                return context;
            }
            return null;
        }
    }

    public void setHooks(ResourceManagerHooks resourceManagerHooks) {
        synchronized (this) {
            this.mHooks = resourceManagerHooks;
            return;
        }
    }

    boolean tintDrawableUsingColorFilter(Context context, int n2, Drawable drawable2) {
        ResourceManagerHooks resourceManagerHooks = this.mHooks;
        boolean bl = resourceManagerHooks != null && resourceManagerHooks.tintDrawableUsingColorFilter(context, n2, drawable2);
        return bl;
    }

    static class AsldcInflateDelegate
    implements InflateDelegate {
        AsldcInflateDelegate() {
        }

        @Override
        public Drawable createFromXmlInner(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
            try {
                context = AnimatedStateListDrawableCompat.createFromXmlInner((Context)context, (Resources)context.getResources(), (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (Resources.Theme)theme);
                return context;
            }
            catch (Exception exception) {
                Log.e((String)"AsldcInflateDelegate", (String)"Exception while inflating <animated-selector>", (Throwable)exception);
                return null;
            }
        }
    }

    private static class AvdcInflateDelegate
    implements InflateDelegate {
        AvdcInflateDelegate() {
        }

        @Override
        public Drawable createFromXmlInner(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
            try {
                context = AnimatedVectorDrawableCompat.createFromXmlInner((Context)context, (Resources)context.getResources(), (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (Resources.Theme)theme);
                return context;
            }
            catch (Exception exception) {
                Log.e((String)"AvdcInflateDelegate", (String)"Exception while inflating <animated-vector>", (Throwable)exception);
                return null;
            }
        }
    }

    private static class ColorFilterLruCache
    extends LruCache<Integer, PorterDuffColorFilter> {
        public ColorFilterLruCache(int n2) {
            super(n2);
        }

        private static int generateCacheKey(int n2, PorterDuff.Mode mode) {
            return (n2 + 31) * 31 + mode.hashCode();
        }

        PorterDuffColorFilter get(int n2, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter)this.get(ColorFilterLruCache.generateCacheKey(n2, mode));
        }

        PorterDuffColorFilter put(int n2, PorterDuff.Mode mode, PorterDuffColorFilter porterDuffColorFilter) {
            return (PorterDuffColorFilter)this.put(ColorFilterLruCache.generateCacheKey(n2, mode), porterDuffColorFilter);
        }
    }

    private static interface InflateDelegate {
        public Drawable createFromXmlInner(Context var1, XmlPullParser var2, AttributeSet var3, Resources.Theme var4);
    }

    static interface ResourceManagerHooks {
        public Drawable createDrawableFor(ResourceManagerInternal var1, Context var2, int var3);

        public ColorStateList getTintListForDrawableRes(Context var1, int var2);

        public PorterDuff.Mode getTintModeForDrawableRes(int var1);

        public boolean tintDrawable(Context var1, int var2, Drawable var3);

        public boolean tintDrawableUsingColorFilter(Context var1, int var2, Drawable var3);
    }

    private static class VdcInflateDelegate
    implements InflateDelegate {
        VdcInflateDelegate() {
        }

        @Override
        public Drawable createFromXmlInner(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
            try {
                context = VectorDrawableCompat.createFromXmlInner((Resources)context.getResources(), (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (Resources.Theme)theme);
                return context;
            }
            catch (Exception exception) {
                Log.e((String)"VdcInflateDelegate", (String)"Exception while inflating <vector>", (Throwable)exception);
                return null;
            }
        }
    }
}

