/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import androidx.appcompat.R;
import androidx.appcompat.view.menu.ShowableListMenu;
import androidx.appcompat.widget.AppCompatPopupWindow;
import androidx.appcompat.widget.DropDownListView;
import androidx.appcompat.widget.ForwardingListener;
import androidx.core.view.ViewCompat;
import androidx.core.widget.PopupWindowCompat;
import java.lang.reflect.Method;

public class ListPopupWindow
implements ShowableListMenu {
    private static final boolean DEBUG = false;
    static final int EXPAND_LIST_TIMEOUT = 250;
    public static final int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static final int INPUT_METHOD_NEEDED = 1;
    public static final int INPUT_METHOD_NOT_NEEDED = 2;
    public static final int MATCH_PARENT = -1;
    public static final int POSITION_PROMPT_ABOVE = 0;
    public static final int POSITION_PROMPT_BELOW = 1;
    private static final String TAG = "ListPopupWindow";
    public static final int WRAP_CONTENT = -2;
    private static Method sGetMaxAvailableHeightMethod;
    private static Method sSetClipToWindowEnabledMethod;
    private static Method sSetEpicenterBoundsMethod;
    private ListAdapter mAdapter;
    private Context mContext;
    private boolean mDropDownAlwaysVisible = false;
    private View mDropDownAnchorView;
    private int mDropDownGravity = 0;
    private int mDropDownHeight = -2;
    private int mDropDownHorizontalOffset;
    DropDownListView mDropDownList;
    private Drawable mDropDownListHighlight;
    private int mDropDownVerticalOffset;
    private boolean mDropDownVerticalOffsetSet;
    private int mDropDownWidth = -2;
    private int mDropDownWindowLayoutType = 1002;
    private Rect mEpicenterBounds;
    private boolean mForceIgnoreOutsideTouch = false;
    final Handler mHandler;
    private final ListSelectorHider mHideSelector;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    int mListItemExpandMaximum = Integer.MAX_VALUE;
    private boolean mModal;
    private DataSetObserver mObserver;
    private boolean mOverlapAnchor;
    private boolean mOverlapAnchorSet;
    PopupWindow mPopup;
    private int mPromptPosition = 0;
    private View mPromptView;
    final ResizePopupRunnable mResizePopupRunnable = new ResizePopupRunnable();
    private final PopupScrollListener mScrollListener;
    private Runnable mShowDropDownRunnable;
    private final Rect mTempRect;
    private final PopupTouchInterceptor mTouchInterceptor = new PopupTouchInterceptor();

    static {
        if (Build.VERSION.SDK_INT <= 28) {
            try {
                sSetClipToWindowEnabledMethod = PopupWindow.class.getDeclaredMethod("setClipToScreenEnabled", Boolean.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.i((String)TAG, (String)"Could not find method setClipToScreenEnabled() on PopupWindow. Oh well.");
            }
            try {
                sSetEpicenterBoundsMethod = PopupWindow.class.getDeclaredMethod("setEpicenterBounds", Rect.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.i((String)TAG, (String)"Could not find method setEpicenterBounds(Rect) on PopupWindow. Oh well.");
            }
        }
        if (Build.VERSION.SDK_INT <= 23) {
            try {
                sGetMaxAvailableHeightMethod = PopupWindow.class.getDeclaredMethod("getMaxAvailableHeight", View.class, Integer.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.i((String)TAG, (String)"Could not find method getMaxAvailableHeight(View, int, boolean) on PopupWindow. Oh well.");
            }
        }
    }

    public ListPopupWindow(Context context) {
        this(context, null, R.attr.listPopupWindowStyle);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.listPopupWindowStyle);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int n2) {
        this(context, attributeSet, n2, 0);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int n2, int n3) {
        this.mScrollListener = new PopupScrollListener();
        this.mHideSelector = new ListSelectorHider();
        this.mTempRect = new Rect();
        this.mContext = context;
        this.mHandler = new Handler(context.getMainLooper());
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ListPopupWindow, n2, n3);
        this.mDropDownHorizontalOffset = typedArray.getDimensionPixelOffset(R.styleable.ListPopupWindow_android_dropDownHorizontalOffset, 0);
        this.mDropDownVerticalOffset = typedArray.getDimensionPixelOffset(R.styleable.ListPopupWindow_android_dropDownVerticalOffset, 0);
        if (this.mDropDownVerticalOffset != 0) {
            this.mDropDownVerticalOffsetSet = true;
        }
        typedArray.recycle();
        this.mPopup = new AppCompatPopupWindow(context, attributeSet, n2, n3);
        this.mPopup.setInputMethodMode(1);
    }

    private int buildDropDown() {
        int n2;
        int n3;
        int n4;
        DropDownListView dropDownListView = this.mDropDownList;
        boolean bl = true;
        if (dropDownListView == null) {
            dropDownListView = this.mContext;
            this.mShowDropDownRunnable = new Runnable(){

                @Override
                public void run() {
                    View view = ListPopupWindow.this.getAnchorView();
                    if (view != null && view.getWindowToken() != null) {
                        ListPopupWindow.this.show();
                    }
                }
            };
            this.mDropDownList = this.createDropDownListView((Context)dropDownListView, this.mModal ^ true);
            Object object = this.mDropDownListHighlight;
            if (object != null) {
                this.mDropDownList.setSelector((Drawable)object);
            }
            this.mDropDownList.setAdapter(this.mAdapter);
            this.mDropDownList.setOnItemClickListener(this.mItemClickListener);
            this.mDropDownList.setFocusable(true);
            this.mDropDownList.setFocusableInTouchMode(true);
            this.mDropDownList.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> dropDownListView, View view, int n2, long l2) {
                    if (n2 != -1 && (dropDownListView = ListPopupWindow.this.mDropDownList) != null) {
                        dropDownListView.setListSelectionHidden(false);
                    }
                }

                public void onNothingSelected(AdapterView<?> adapterView) {
                }
            });
            this.mDropDownList.setOnScrollListener((AbsListView.OnScrollListener)this.mScrollListener);
            object = this.mItemSelectedListener;
            if (object != null) {
                this.mDropDownList.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)object);
            }
            object = this.mDropDownList;
            View view = this.mPromptView;
            if (view != null) {
                dropDownListView = new LinearLayout((Context)dropDownListView);
                dropDownListView.setOrientation(1);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                n4 = this.mPromptPosition;
                if (n4 != 0) {
                    if (n4 != 1) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Invalid hint position ");
                        ((StringBuilder)object).append(this.mPromptPosition);
                        Log.e((String)TAG, (String)((StringBuilder)object).toString());
                    } else {
                        dropDownListView.addView((View)object, (ViewGroup.LayoutParams)layoutParams);
                        dropDownListView.addView(view);
                    }
                } else {
                    dropDownListView.addView(view);
                    dropDownListView.addView((View)object, (ViewGroup.LayoutParams)layoutParams);
                }
                n4 = this.mDropDownWidth;
                if (n4 >= 0) {
                    n3 = Integer.MIN_VALUE;
                } else {
                    n4 = 0;
                    n3 = 0;
                }
                view.measure(View.MeasureSpec.makeMeasureSpec((int)n4, (int)n3), 0);
                object = (LinearLayout.LayoutParams)view.getLayoutParams();
                n4 = view.getMeasuredHeight() + ((LinearLayout.LayoutParams)object).topMargin + ((LinearLayout.LayoutParams)object).bottomMargin;
            } else {
                n4 = 0;
                dropDownListView = object;
            }
            this.mPopup.setContentView((View)dropDownListView);
        } else {
            dropDownListView = (ViewGroup)this.mPopup.getContentView();
            View view = this.mPromptView;
            if (view != null) {
                dropDownListView = (LinearLayout.LayoutParams)view.getLayoutParams();
                n4 = view.getMeasuredHeight() + dropDownListView.topMargin + dropDownListView.bottomMargin;
            } else {
                n4 = 0;
            }
        }
        dropDownListView = this.mPopup.getBackground();
        if (dropDownListView != null) {
            dropDownListView.getPadding(this.mTempRect);
            n2 = n3 = this.mTempRect.top + this.mTempRect.bottom;
            if (!this.mDropDownVerticalOffsetSet) {
                this.mDropDownVerticalOffset = -this.mTempRect.top;
                n2 = n3;
            }
        } else {
            this.mTempRect.setEmpty();
            n2 = 0;
        }
        if (this.mPopup.getInputMethodMode() != 2) {
            bl = false;
        }
        int n5 = this.getMaxAvailableHeight(this.getAnchorView(), this.mDropDownVerticalOffset, bl);
        if (!this.mDropDownAlwaysVisible && this.mDropDownHeight != -1) {
            n3 = this.mDropDownWidth;
            n3 = n3 != -2 ? (n3 != -1 ? View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right)), (int)0x40000000)) : View.MeasureSpec.makeMeasureSpec((int)(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right)), (int)Integer.MIN_VALUE);
            n5 = this.mDropDownList.measureHeightOfChildrenCompat(n3, 0, -1, n5 - n4, -1);
            n3 = n4;
            if (n5 > 0) {
                n3 = n4 + (n2 + (this.mDropDownList.getPaddingTop() + this.mDropDownList.getPaddingBottom()));
            }
            return n5 + n3;
        }
        return n5 + n2;
    }

    private int getMaxAvailableHeight(View view, int n2, boolean bl) {
        if (Build.VERSION.SDK_INT <= 23) {
            Method method = sGetMaxAvailableHeightMethod;
            if (method != null) {
                try {
                    int n3 = (Integer)method.invoke((Object)this.mPopup, view, n2, bl);
                    return n3;
                }
                catch (Exception exception) {
                    Log.i((String)TAG, (String)"Could not call getMaxAvailableHeightMethod(View, int, boolean) on PopupWindow. Using the public version.");
                }
            }
            return this.mPopup.getMaxAvailableHeight(view, n2);
        }
        return this.mPopup.getMaxAvailableHeight(view, n2, bl);
    }

    private static boolean isConfirmKey(int n2) {
        boolean bl = n2 == 66 || n2 == 23;
        return bl;
    }

    private void removePromptView() {
        View view = this.mPromptView;
        if (view != null && (view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.mPromptView);
        }
    }

    private void setPopupClipToScreenEnabled(boolean bl) {
        if (Build.VERSION.SDK_INT <= 28) {
            Method method = sSetClipToWindowEnabledMethod;
            if (method != null) {
                try {
                    method.invoke((Object)this.mPopup, bl);
                }
                catch (Exception exception) {
                    Log.i((String)TAG, (String)"Could not call setClipToScreenEnabled() on PopupWindow. Oh well.");
                }
            }
        } else {
            this.mPopup.setIsClippedToScreen(bl);
        }
    }

    public void clearListSelection() {
        DropDownListView dropDownListView = this.mDropDownList;
        if (dropDownListView != null) {
            dropDownListView.setListSelectionHidden(true);
            dropDownListView.requestLayout();
        }
    }

    public View.OnTouchListener createDragToOpenListener(View view) {
        return new ForwardingListener(view){

            public ListPopupWindow getPopup() {
                return ListPopupWindow.this;
            }
        };
    }

    DropDownListView createDropDownListView(Context context, boolean bl) {
        return new DropDownListView(context, bl);
    }

    public void dismiss() {
        this.mPopup.dismiss();
        this.removePromptView();
        this.mPopup.setContentView(null);
        this.mDropDownList = null;
        this.mHandler.removeCallbacks((Runnable)this.mResizePopupRunnable);
    }

    public View getAnchorView() {
        return this.mDropDownAnchorView;
    }

    public int getAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    public Drawable getBackground() {
        return this.mPopup.getBackground();
    }

    public Rect getEpicenterBounds() {
        Object object = this.mEpicenterBounds;
        object = object != null ? new Rect(object) : null;
        return object;
    }

    public int getHeight() {
        return this.mDropDownHeight;
    }

    public int getHorizontalOffset() {
        return this.mDropDownHorizontalOffset;
    }

    public int getInputMethodMode() {
        return this.mPopup.getInputMethodMode();
    }

    public ListView getListView() {
        return this.mDropDownList;
    }

    public int getPromptPosition() {
        return this.mPromptPosition;
    }

    public Object getSelectedItem() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedItem();
    }

    public long getSelectedItemId() {
        if (!this.isShowing()) {
            return Long.MIN_VALUE;
        }
        return this.mDropDownList.getSelectedItemId();
    }

    public int getSelectedItemPosition() {
        if (!this.isShowing()) {
            return -1;
        }
        return this.mDropDownList.getSelectedItemPosition();
    }

    public View getSelectedView() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedView();
    }

    public int getSoftInputMode() {
        return this.mPopup.getSoftInputMode();
    }

    public int getVerticalOffset() {
        if (!this.mDropDownVerticalOffsetSet) {
            return 0;
        }
        return this.mDropDownVerticalOffset;
    }

    public int getWidth() {
        return this.mDropDownWidth;
    }

    public boolean isDropDownAlwaysVisible() {
        return this.mDropDownAlwaysVisible;
    }

    public boolean isInputMethodNotNeeded() {
        boolean bl = this.mPopup.getInputMethodMode() == 2;
        return bl;
    }

    public boolean isModal() {
        return this.mModal;
    }

    public boolean isShowing() {
        return this.mPopup.isShowing();
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (this.isShowing() && n2 != 62 && (this.mDropDownList.getSelectedItemPosition() >= 0 || !ListPopupWindow.isConfirmKey(n2))) {
            int n3;
            int n4 = this.mDropDownList.getSelectedItemPosition();
            boolean bl = this.mPopup.isAboveAnchor() ^ true;
            ListAdapter listAdapter = this.mAdapter;
            int n5 = Integer.MAX_VALUE;
            if (listAdapter != null) {
                boolean bl2 = listAdapter.areAllItemsEnabled();
                n5 = bl2 ? 0 : this.mDropDownList.lookForSelectablePosition(0, true);
                n3 = bl2 ? listAdapter.getCount() - 1 : this.mDropDownList.lookForSelectablePosition(listAdapter.getCount() - 1, false);
            } else {
                n3 = Integer.MIN_VALUE;
            }
            if (bl && n2 == 19 && n4 <= n5 || !bl && n2 == 20 && n4 >= n3) {
                this.clearListSelection();
                this.mPopup.setInputMethodMode(1);
                this.show();
                return true;
            }
            this.mDropDownList.setListSelectionHidden(false);
            if (this.mDropDownList.onKeyDown(n2, keyEvent)) {
                this.mPopup.setInputMethodMode(2);
                this.mDropDownList.requestFocusFromTouch();
                this.show();
                if (n2 == 19 || n2 == 20 || n2 == 23 || n2 == 66) {
                    return true;
                }
            } else if (bl && n2 == 20 ? n4 == n3 : !bl && n2 == 19 && n4 == n5) {
                return true;
            }
        }
        return false;
    }

    public boolean onKeyPreIme(int n2, KeyEvent keyEvent) {
        if (n2 == 4 && this.isShowing()) {
            View view = this.mDropDownAnchorView;
            if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                if ((view = view.getKeyDispatcherState()) != null) {
                    view.startTracking(keyEvent, (Object)this);
                }
                return true;
            }
            if (keyEvent.getAction() == 1) {
                if ((view = view.getKeyDispatcherState()) != null) {
                    view.handleUpEvent(keyEvent);
                }
                if (keyEvent.isTracking() && !keyEvent.isCanceled()) {
                    this.dismiss();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        if (this.isShowing() && this.mDropDownList.getSelectedItemPosition() >= 0) {
            boolean bl = this.mDropDownList.onKeyUp(n2, keyEvent);
            if (bl && ListPopupWindow.isConfirmKey(n2)) {
                this.dismiss();
            }
            return bl;
        }
        return false;
    }

    public boolean performItemClick(int n2) {
        if (this.isShowing()) {
            if (this.mItemClickListener != null) {
                DropDownListView dropDownListView = this.mDropDownList;
                View view = dropDownListView.getChildAt(n2 - dropDownListView.getFirstVisiblePosition());
                ListAdapter listAdapter = dropDownListView.getAdapter();
                this.mItemClickListener.onItemClick((AdapterView)dropDownListView, view, n2, listAdapter.getItemId(n2));
            }
            return true;
        }
        return false;
    }

    public void postShow() {
        this.mHandler.post(this.mShowDropDownRunnable);
    }

    public void setAdapter(ListAdapter listAdapter) {
        DataSetObserver dataSetObserver = this.mObserver;
        if (dataSetObserver == null) {
            this.mObserver = new PopupDataSetObserver();
        } else {
            ListAdapter listAdapter2 = this.mAdapter;
            if (listAdapter2 != null) {
                listAdapter2.unregisterDataSetObserver(dataSetObserver);
            }
        }
        this.mAdapter = listAdapter;
        if (listAdapter != null) {
            listAdapter.registerDataSetObserver(this.mObserver);
        }
        if ((listAdapter = this.mDropDownList) != null) {
            listAdapter.setAdapter(this.mAdapter);
        }
    }

    public void setAnchorView(View view) {
        this.mDropDownAnchorView = view;
    }

    public void setAnimationStyle(int n2) {
        this.mPopup.setAnimationStyle(n2);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.mPopup.setBackgroundDrawable(drawable2);
    }

    public void setContentWidth(int n2) {
        Drawable drawable2 = this.mPopup.getBackground();
        if (drawable2 != null) {
            drawable2.getPadding(this.mTempRect);
            this.mDropDownWidth = this.mTempRect.left + this.mTempRect.right + n2;
        } else {
            this.setWidth(n2);
        }
    }

    public void setDropDownAlwaysVisible(boolean bl) {
        this.mDropDownAlwaysVisible = bl;
    }

    public void setDropDownGravity(int n2) {
        this.mDropDownGravity = n2;
    }

    public void setEpicenterBounds(Rect object) {
        object = object != null ? new Rect(object) : null;
        this.mEpicenterBounds = object;
    }

    public void setForceIgnoreOutsideTouch(boolean bl) {
        this.mForceIgnoreOutsideTouch = bl;
    }

    public void setHeight(int n2) {
        if (n2 < 0 && -2 != n2 && -1 != n2) {
            throw new IllegalArgumentException("Invalid height. Must be a positive value, MATCH_PARENT, or WRAP_CONTENT.");
        }
        this.mDropDownHeight = n2;
    }

    public void setHorizontalOffset(int n2) {
        this.mDropDownHorizontalOffset = n2;
    }

    public void setInputMethodMode(int n2) {
        this.mPopup.setInputMethodMode(n2);
    }

    void setListItemExpandMax(int n2) {
        this.mListItemExpandMaximum = n2;
    }

    public void setListSelector(Drawable drawable2) {
        this.mDropDownListHighlight = drawable2;
    }

    public void setModal(boolean bl) {
        this.mModal = bl;
        this.mPopup.setFocusable(bl);
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.mPopup.setOnDismissListener(onDismissListener);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.mItemClickListener = onItemClickListener;
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        this.mItemSelectedListener = onItemSelectedListener;
    }

    public void setOverlapAnchor(boolean bl) {
        this.mOverlapAnchorSet = true;
        this.mOverlapAnchor = bl;
    }

    public void setPromptPosition(int n2) {
        this.mPromptPosition = n2;
    }

    public void setPromptView(View view) {
        boolean bl = this.isShowing();
        if (bl) {
            this.removePromptView();
        }
        this.mPromptView = view;
        if (bl) {
            this.show();
        }
    }

    public void setSelection(int n2) {
        DropDownListView dropDownListView = this.mDropDownList;
        if (this.isShowing() && dropDownListView != null) {
            dropDownListView.setListSelectionHidden(false);
            dropDownListView.setSelection(n2);
            if (dropDownListView.getChoiceMode() != 0) {
                dropDownListView.setItemChecked(n2, true);
            }
        }
    }

    public void setSoftInputMode(int n2) {
        this.mPopup.setSoftInputMode(n2);
    }

    public void setVerticalOffset(int n2) {
        this.mDropDownVerticalOffset = n2;
        this.mDropDownVerticalOffsetSet = true;
    }

    public void setWidth(int n2) {
        this.mDropDownWidth = n2;
    }

    public void setWindowLayoutType(int n2) {
        this.mDropDownWindowLayoutType = n2;
    }

    public void show() {
        int n2 = this.buildDropDown();
        boolean bl = this.isInputMethodNotNeeded();
        PopupWindowCompat.setWindowLayoutType((PopupWindow)this.mPopup, (int)this.mDropDownWindowLayoutType);
        boolean bl2 = this.mPopup.isShowing();
        boolean bl3 = true;
        if (bl2) {
            PopupWindow popupWindow;
            int n3;
            if (!ViewCompat.isAttachedToWindow(this.getAnchorView())) {
                return;
            }
            int n4 = this.mDropDownWidth;
            if (n4 == -1) {
                n3 = -1;
            } else {
                n3 = n4;
                if (n4 == -2) {
                    n3 = this.getAnchorView().getWidth();
                }
            }
            n4 = this.mDropDownHeight;
            if (n4 == -1) {
                if (!bl) {
                    n2 = -1;
                }
                if (bl) {
                    popupWindow = this.mPopup;
                    n4 = this.mDropDownWidth == -1 ? -1 : 0;
                    popupWindow.setWidth(n4);
                    this.mPopup.setHeight(0);
                } else {
                    popupWindow = this.mPopup;
                    n4 = this.mDropDownWidth == -1 ? -1 : 0;
                    popupWindow.setWidth(n4);
                    this.mPopup.setHeight(-1);
                }
            } else if (n4 != -2) {
                n2 = n4;
            }
            popupWindow = this.mPopup;
            if (this.mForceIgnoreOutsideTouch || this.mDropDownAlwaysVisible) {
                bl3 = false;
            }
            popupWindow.setOutsideTouchable(bl3);
            popupWindow = this.mPopup;
            View view = this.getAnchorView();
            int n5 = this.mDropDownHorizontalOffset;
            n4 = this.mDropDownVerticalOffset;
            if (n3 < 0) {
                n3 = -1;
            }
            if (n2 < 0) {
                n2 = -1;
            }
            popupWindow.update(view, n5, n4, n3, n2);
        } else {
            int n6;
            int n7 = this.mDropDownWidth;
            if (n7 == -1) {
                n6 = -1;
            } else {
                n6 = n7;
                if (n7 == -2) {
                    n6 = this.getAnchorView().getWidth();
                }
            }
            n7 = this.mDropDownHeight;
            if (n7 == -1) {
                n2 = -1;
            } else if (n7 != -2) {
                n2 = n7;
            }
            this.mPopup.setWidth(n6);
            this.mPopup.setHeight(n2);
            this.setPopupClipToScreenEnabled(true);
            Object object = this.mPopup;
            bl3 = !this.mForceIgnoreOutsideTouch && !this.mDropDownAlwaysVisible;
            object.setOutsideTouchable(bl3);
            this.mPopup.setTouchInterceptor((View.OnTouchListener)this.mTouchInterceptor);
            if (this.mOverlapAnchorSet) {
                PopupWindowCompat.setOverlapAnchor((PopupWindow)this.mPopup, (boolean)this.mOverlapAnchor);
            }
            if (Build.VERSION.SDK_INT <= 28) {
                object = sSetEpicenterBoundsMethod;
                if (object != null) {
                    try {
                        ((Method)object).invoke((Object)this.mPopup, this.mEpicenterBounds);
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)"Could not invoke setEpicenterBounds on PopupWindow", (Throwable)exception);
                    }
                }
            } else {
                this.mPopup.setEpicenterBounds(this.mEpicenterBounds);
            }
            PopupWindowCompat.showAsDropDown((PopupWindow)this.mPopup, (View)this.getAnchorView(), (int)this.mDropDownHorizontalOffset, (int)this.mDropDownVerticalOffset, (int)this.mDropDownGravity);
            this.mDropDownList.setSelection(-1);
            if (!this.mModal || this.mDropDownList.isInTouchMode()) {
                this.clearListSelection();
            }
            if (!this.mModal) {
                this.mHandler.post((Runnable)this.mHideSelector);
            }
        }
    }

    private class ListSelectorHider
    implements Runnable {
        ListSelectorHider() {
        }

        @Override
        public void run() {
            ListPopupWindow.this.clearListSelection();
        }
    }

    private class PopupDataSetObserver
    extends DataSetObserver {
        PopupDataSetObserver() {
        }

        public void onChanged() {
            if (ListPopupWindow.this.isShowing()) {
                ListPopupWindow.this.show();
            }
        }

        public void onInvalidated() {
            ListPopupWindow.this.dismiss();
        }
    }

    private class PopupScrollListener
    implements AbsListView.OnScrollListener {
        PopupScrollListener() {
        }

        public void onScroll(AbsListView absListView, int n2, int n3, int n4) {
        }

        public void onScrollStateChanged(AbsListView absListView, int n2) {
            if (n2 == 1 && !ListPopupWindow.this.isInputMethodNotNeeded() && ListPopupWindow.this.mPopup.getContentView() != null) {
                ListPopupWindow.this.mHandler.removeCallbacks((Runnable)ListPopupWindow.this.mResizePopupRunnable);
                ListPopupWindow.this.mResizePopupRunnable.run();
            }
        }
    }

    private class PopupTouchInterceptor
    implements View.OnTouchListener {
        PopupTouchInterceptor() {
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            int n2 = motionEvent.getAction();
            int n3 = (int)motionEvent.getX();
            int n4 = (int)motionEvent.getY();
            if (n2 == 0 && ListPopupWindow.this.mPopup != null && ListPopupWindow.this.mPopup.isShowing() && n3 >= 0 && n3 < ListPopupWindow.this.mPopup.getWidth() && n4 >= 0 && n4 < ListPopupWindow.this.mPopup.getHeight()) {
                ListPopupWindow.this.mHandler.postDelayed((Runnable)ListPopupWindow.this.mResizePopupRunnable, 250L);
            } else if (n2 == 1) {
                ListPopupWindow.this.mHandler.removeCallbacks((Runnable)ListPopupWindow.this.mResizePopupRunnable);
            }
            return false;
        }
    }

    private class ResizePopupRunnable
    implements Runnable {
        ResizePopupRunnable() {
        }

        @Override
        public void run() {
            if (ListPopupWindow.this.mDropDownList != null && ViewCompat.isAttachedToWindow((View)ListPopupWindow.this.mDropDownList) && ListPopupWindow.this.mDropDownList.getCount() > ListPopupWindow.this.mDropDownList.getChildCount() && ListPopupWindow.this.mDropDownList.getChildCount() <= ListPopupWindow.this.mListItemExpandMaximum) {
                ListPopupWindow.this.mPopup.setInputMethodMode(2);
                ListPopupWindow.this.show();
            }
        }
    }
}

