/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.appcompat.R;
import androidx.appcompat.widget.TintTypedArray;
import androidx.appcompat.widget.ViewUtils;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LinearLayoutCompat
extends ViewGroup {
    private static final String ACCESSIBILITY_CLASS_NAME = "androidx.appcompat.widget.LinearLayoutCompat";
    public static final int HORIZONTAL = 0;
    private static final int INDEX_BOTTOM = 2;
    private static final int INDEX_CENTER_VERTICAL = 0;
    private static final int INDEX_FILL = 3;
    private static final int INDEX_TOP = 1;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_END = 4;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int VERTICAL = 1;
    private static final int VERTICAL_GRAVITY_COUNT = 4;
    private boolean mBaselineAligned = true;
    private int mBaselineAlignedChildIndex = -1;
    private int mBaselineChildTop = 0;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mDividerPadding;
    private int mDividerWidth;
    private int mGravity = 0x800033;
    private int[] mMaxAscent;
    private int[] mMaxDescent;
    private int mOrientation;
    private int mShowDividers;
    private int mTotalLength;
    private boolean mUseLargestChild;
    private float mWeightSum;

    public LinearLayoutCompat(Context context) {
        this(context, null);
    }

    public LinearLayoutCompat(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LinearLayoutCompat(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        boolean bl;
        TintTypedArray tintTypedArray = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attributeSet, (int[])R.styleable.LinearLayoutCompat, (int)n2, (int)0);
        ViewCompat.saveAttributeDataForStyleable((View)this, context, R.styleable.LinearLayoutCompat, attributeSet, tintTypedArray.getWrappedTypeArray(), n2, 0);
        n2 = tintTypedArray.getInt(R.styleable.LinearLayoutCompat_android_orientation, -1);
        if (n2 >= 0) {
            this.setOrientation(n2);
        }
        if ((n2 = tintTypedArray.getInt(R.styleable.LinearLayoutCompat_android_gravity, -1)) >= 0) {
            this.setGravity(n2);
        }
        if (!(bl = tintTypedArray.getBoolean(R.styleable.LinearLayoutCompat_android_baselineAligned, true))) {
            this.setBaselineAligned(bl);
        }
        this.mWeightSum = tintTypedArray.getFloat(R.styleable.LinearLayoutCompat_android_weightSum, -1.0f);
        this.mBaselineAlignedChildIndex = tintTypedArray.getInt(R.styleable.LinearLayoutCompat_android_baselineAlignedChildIndex, -1);
        this.mUseLargestChild = tintTypedArray.getBoolean(R.styleable.LinearLayoutCompat_measureWithLargestChild, false);
        this.setDividerDrawable(tintTypedArray.getDrawable(R.styleable.LinearLayoutCompat_divider));
        this.mShowDividers = tintTypedArray.getInt(R.styleable.LinearLayoutCompat_showDividers, 0);
        this.mDividerPadding = tintTypedArray.getDimensionPixelSize(R.styleable.LinearLayoutCompat_dividerPadding, 0);
        tintTypedArray.recycle();
    }

    private void forceUniformHeight(int n2, int n3) {
        int n4 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000);
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getVirtualChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.height != -1) continue;
            int n5 = layoutParams.width;
            layoutParams.width = view.getMeasuredWidth();
            this.measureChildWithMargins(view, n3, 0, n4, 0);
            layoutParams.width = n5;
        }
    }

    private void forceUniformWidth(int n2, int n3) {
        int n4 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getVirtualChildAt(i2);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.width != -1) continue;
            int n5 = layoutParams.height;
            layoutParams.height = view.getMeasuredHeight();
            this.measureChildWithMargins(view, n4, 0, n3, 0);
            layoutParams.height = n5;
        }
    }

    private void setChildFrame(View view, int n2, int n3, int n4, int n5) {
        view.layout(n2, n3, n4 + n2, n5 + n3);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void drawDividersHorizontal(Canvas var1_1) {
        block3: {
            block6: {
                block4: {
                    block5: {
                        var2_2 = this.getVirtualChildCount();
                        var3_3 = ViewUtils.isLayoutRtl((View)this);
                        for (var4_4 = 0; var4_4 < var2_2; ++var4_4) {
                            var5_5 /* !! */  = this.getVirtualChildAt(var4_4);
                            if (var5_5 /* !! */  == null || var5_5 /* !! */ .getVisibility() == 8 || !this.hasDividerBeforeChildAt(var4_4)) continue;
                            var6_6 /* !! */  = (LayoutParams)var5_5 /* !! */ .getLayoutParams();
                            var7_7 = var3_3 != false ? var5_5 /* !! */ .getRight() + var6_6 /* !! */ .rightMargin : var5_5 /* !! */ .getLeft() - var6_6 /* !! */ .leftMargin - this.mDividerWidth;
                            this.drawVerticalDivider(var1_1, var7_7);
                        }
                        if (!this.hasDividerBeforeChildAt(var2_2)) break block3;
                        var6_6 /* !! */  = this.getVirtualChildAt(var2_2 - 1);
                        if (var6_6 /* !! */  != null) break block4;
                        if (!var3_3) break block5;
                        var4_4 = this.getPaddingLeft();
                        break block6;
                    }
                    var4_4 = this.getWidth() - this.getPaddingRight();
                    var7_7 = this.mDividerWidth;
                    ** GOTO lbl25
                }
                var5_5 /* !! */  = (LayoutParams)var6_6 /* !! */ .getLayoutParams();
                if (var3_3) {
                    var4_4 = var6_6 /* !! */ .getLeft() - var5_5 /* !! */ .leftMargin;
                    var7_7 = this.mDividerWidth;
lbl25:
                    // 2 sources

                    var4_4 -= var7_7;
                } else {
                    var4_4 = var6_6 /* !! */ .getRight() + var5_5 /* !! */ .rightMargin;
                }
            }
            this.drawVerticalDivider(var1_1, var4_4);
        }
    }

    void drawDividersVertical(Canvas canvas) {
        LayoutParams layoutParams;
        View view;
        int n2;
        int n3 = this.getVirtualChildCount();
        for (n2 = 0; n2 < n3; ++n2) {
            view = this.getVirtualChildAt(n2);
            if (view == null || view.getVisibility() == 8 || !this.hasDividerBeforeChildAt(n2)) continue;
            layoutParams = (LayoutParams)view.getLayoutParams();
            this.drawHorizontalDivider(canvas, view.getTop() - layoutParams.topMargin - this.mDividerHeight);
        }
        if (this.hasDividerBeforeChildAt(n3)) {
            view = this.getVirtualChildAt(n3 - 1);
            if (view == null) {
                n2 = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
            } else {
                layoutParams = (LayoutParams)view.getLayoutParams();
                n2 = view.getBottom() + layoutParams.bottomMargin;
            }
            this.drawHorizontalDivider(canvas, n2);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int n2) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, n2, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, this.mDividerHeight + n2);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int n2) {
        this.mDivider.setBounds(n2, this.getPaddingTop() + this.mDividerPadding, this.mDividerWidth + n2, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        int n2 = this.mOrientation;
        if (n2 == 0) {
            return new LayoutParams(-2, -2);
        }
        if (n2 == 1) {
            return new LayoutParams(-1, -2);
        }
        return null;
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public int getBaseline() {
        int n2;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        int n3 = this.getChildCount();
        if (n3 > (n2 = this.mBaselineAlignedChildIndex)) {
            View view = this.getChildAt(n2);
            int n4 = view.getBaseline();
            if (n4 == -1) {
                if (this.mBaselineAlignedChildIndex == 0) {
                    return -1;
                }
                throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
            }
            n2 = n3 = this.mBaselineChildTop;
            if (this.mOrientation == 1) {
                int n5 = this.mGravity & 0x70;
                n2 = n3;
                if (n5 != 48) {
                    n2 = n5 != 16 ? (n5 != 80 ? n3 : this.getBottom() - this.getTop() - this.getPaddingBottom() - this.mTotalLength) : n3 + (this.getBottom() - this.getTop() - this.getPaddingTop() - this.getPaddingBottom() - this.mTotalLength) / 2;
                }
            }
            return n2 + ((LayoutParams)view.getLayoutParams()).topMargin + n4;
        }
        throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    int getChildrenSkipCount(View view, int n2) {
        return 0;
    }

    public Drawable getDividerDrawable() {
        return this.mDivider;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public int getGravity() {
        return this.mGravity;
    }

    int getLocationOffset(View view) {
        return 0;
    }

    int getNextLocationOffset(View view) {
        return 0;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    View getVirtualChildAt(int n2) {
        return this.getChildAt(n2);
    }

    int getVirtualChildCount() {
        return this.getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    protected boolean hasDividerBeforeChildAt(int n2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 == 0) {
            if ((this.mShowDividers & 1) != 0) {
                bl3 = true;
            }
            return bl3;
        }
        if (n2 == this.getChildCount()) {
            bl3 = bl;
            if ((this.mShowDividers & 4) != 0) {
                bl3 = true;
            }
            return bl3;
        }
        bl3 = bl2;
        if ((this.mShowDividers & 2) != 0) {
            --n2;
            while (true) {
                bl3 = bl2;
                if (n2 < 0) break;
                if (this.getChildAt(n2).getVisibility() != 8) {
                    bl3 = true;
                    break;
                }
                --n2;
            }
        }
        return bl3;
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    void layoutHorizontal(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        boolean bl = ViewUtils.isLayoutRtl((View)this);
        int n8 = this.getPaddingTop();
        int n9 = n5 - n3;
        int n10 = this.getPaddingBottom();
        int n11 = this.getPaddingBottom();
        int n12 = this.getVirtualChildCount();
        n5 = this.mGravity;
        n3 = n5 & 0x70;
        boolean bl2 = this.mBaselineAligned;
        int[] nArray = this.mMaxAscent;
        int[] nArray2 = this.mMaxDescent;
        n2 = (n5 = GravityCompat.getAbsoluteGravity((int)(0x800007 & n5), (int)ViewCompat.getLayoutDirection((View)this))) != 1 ? (n5 != 5 ? this.getPaddingLeft() : this.getPaddingLeft() + n4 - n2 - this.mTotalLength) : this.getPaddingLeft() + (n4 - n2 - this.mTotalLength) / 2;
        if (bl) {
            n7 = n12 - 1;
            n6 = -1;
        } else {
            n7 = 0;
            n6 = 1;
        }
        n4 = n8;
        for (n5 = 0; n5 < n12; ++n5) {
            int n13;
            int n14 = n7 + n6 * n5;
            View view = this.getVirtualChildAt(n14);
            if (view == null) {
                n2 += this.measureNullChild(n14);
                continue;
            }
            if (view.getVisibility() == 8) continue;
            int n15 = view.getMeasuredWidth();
            int n16 = view.getMeasuredHeight();
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n17 = bl2 && layoutParams.height != -1 ? view.getBaseline() : -1;
            int n18 = n13 = layoutParams.gravity;
            if (n13 < 0) {
                n18 = n3;
            }
            if ((n18 &= 0x70) != 16) {
                if (n18 != 48) {
                    if (n18 != 80) {
                        n18 = n4;
                    } else {
                        n18 = n13 = n9 - n10 - n16 - layoutParams.bottomMargin;
                        if (n17 != -1) {
                            n18 = view.getMeasuredHeight();
                            n18 = n13 - (nArray2[2] - (n18 - n17));
                        }
                    }
                } else {
                    n18 = n13 = layoutParams.topMargin + n4;
                    if (n17 != -1) {
                        n18 = n13 + (nArray[1] - n17);
                    }
                }
            } else {
                n18 = (n9 - n8 - n11 - n16) / 2 + n4 + layoutParams.topMargin - layoutParams.bottomMargin;
            }
            n17 = n2;
            if (this.hasDividerBeforeChildAt(n14)) {
                n17 = n2 + this.mDividerWidth;
            }
            n2 = layoutParams.leftMargin + n17;
            this.setChildFrame(view, n2 + this.getLocationOffset(view), n18, n15, n16);
            n17 = layoutParams.rightMargin;
            n18 = this.getNextLocationOffset(view);
            n5 += this.getChildrenSkipCount(view, n14);
            n2 += n15 + n17 + n18;
        }
    }

    void layoutVertical(int n2, int n3, int n4, int n5) {
        int n6 = this.getPaddingLeft();
        int n7 = n4 - n2;
        int n8 = this.getPaddingRight();
        int n9 = this.getPaddingRight();
        int n10 = this.getVirtualChildCount();
        int n11 = this.mGravity;
        n2 = n11 & 0x70;
        n2 = n2 != 16 ? (n2 != 80 ? this.getPaddingTop() : this.getPaddingTop() + n5 - n3 - this.mTotalLength) : this.getPaddingTop() + (n5 - n3 - this.mTotalLength) / 2;
        n3 = 0;
        while (n3 < n10) {
            block4: {
                LayoutParams layoutParams;
                int n12;
                int n13;
                View view;
                block7: {
                    block8: {
                        block5: {
                            block6: {
                                block3: {
                                    view = this.getVirtualChildAt(n3);
                                    if (view != null) break block3;
                                    n4 = n2 + this.measureNullChild(n3);
                                    n5 = n3;
                                    break block4;
                                }
                                n4 = n2;
                                n5 = n3;
                                if (view.getVisibility() == 8) break block4;
                                n13 = view.getMeasuredWidth();
                                n12 = view.getMeasuredHeight();
                                layoutParams = (LayoutParams)view.getLayoutParams();
                                n4 = n5 = layoutParams.gravity;
                                if (n5 < 0) {
                                    n4 = n11 & 0x800007;
                                }
                                if ((n4 = GravityCompat.getAbsoluteGravity((int)n4, (int)ViewCompat.getLayoutDirection((View)this)) & 7) == 1) break block5;
                                if (n4 == 5) break block6;
                                n4 = layoutParams.leftMargin + n6;
                                break block7;
                            }
                            n5 = n7 - n8 - n13;
                            n4 = layoutParams.rightMargin;
                            break block8;
                        }
                        n5 = (n7 - n6 - n9 - n13) / 2 + n6 + layoutParams.leftMargin;
                        n4 = layoutParams.rightMargin;
                    }
                    n4 = n5 - n4;
                }
                n5 = n2;
                if (this.hasDividerBeforeChildAt(n3)) {
                    n5 = n2 + this.mDividerHeight;
                }
                n2 = n5 + layoutParams.topMargin;
                this.setChildFrame(view, n4, n2 + this.getLocationOffset(view), n13, n12);
                n13 = layoutParams.bottomMargin;
                n4 = this.getNextLocationOffset(view);
                n5 = n3 + this.getChildrenSkipCount(view, n3);
                n4 = n2 + (n12 + n13 + n4);
            }
            n3 = n5 + 1;
            n2 = n4;
        }
    }

    void measureChildBeforeLayout(View view, int n2, int n3, int n4, int n5, int n6) {
        this.measureChildWithMargins(view, n3, n4, n5, n6);
    }

    void measureHorizontal(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        LayoutParams layoutParams;
        Object object;
        int n7;
        boolean bl;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        float f2;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Object object2;
        int[] nArray;
        int n15;
        int n16;
        int n17;
        block51: {
            block52: {
                this.mTotalLength = 0;
                n17 = this.getVirtualChildCount();
                n16 = View.MeasureSpec.getMode((int)n2);
                n15 = View.MeasureSpec.getMode((int)n3);
                if (this.mMaxAscent == null || this.mMaxDescent == null) {
                    this.mMaxAscent = new int[4];
                    this.mMaxDescent = new int[4];
                }
                nArray = this.mMaxAscent;
                object2 = this.mMaxDescent;
                nArray[3] = -1;
                nArray[2] = -1;
                nArray[1] = -1;
                nArray[0] = -1;
                object2[3] = -1;
                object2[2] = -1;
                object2[1] = -1;
                object2[0] = -1;
                bl4 = this.mBaselineAligned;
                bl3 = this.mUseLargestChild;
                bl2 = n16 == 0x40000000;
                f2 = 0.0f;
                n14 = 0;
                n13 = 0;
                n12 = 0;
                n11 = 0;
                n10 = 0;
                n9 = 0;
                n8 = 1;
                bl = false;
                for (n7 = 0; n7 < n17; ++n7) {
                    int n18;
                    block50: {
                        block49: {
                            block47: {
                                block48: {
                                    object = this.getVirtualChildAt(n7);
                                    if (object == null) {
                                        this.mTotalLength += this.measureNullChild(n7);
                                        continue;
                                    }
                                    if (object.getVisibility() == 8) {
                                        n7 += this.getChildrenSkipCount((View)object, n7);
                                        continue;
                                    }
                                    if (this.hasDividerBeforeChildAt(n7)) {
                                        this.mTotalLength += this.mDividerWidth;
                                    }
                                    layoutParams = (LayoutParams)object.getLayoutParams();
                                    f2 += layoutParams.weight;
                                    if (n16 != 0x40000000 || layoutParams.width != 0 || !(layoutParams.weight > 0.0f)) break block47;
                                    if (bl2) {
                                        this.mTotalLength += layoutParams.leftMargin + layoutParams.rightMargin;
                                    } else {
                                        n6 = this.mTotalLength;
                                        this.mTotalLength = Math.max(n6, layoutParams.leftMargin + n6 + layoutParams.rightMargin);
                                    }
                                    if (!bl4) break block48;
                                    n6 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                                    object.measure(n6, n6);
                                    n6 = n14;
                                    break block49;
                                }
                                n10 = 1;
                                break block50;
                            }
                            if (layoutParams.width == 0 && layoutParams.weight > 0.0f) {
                                layoutParams.width = -2;
                                n6 = 0;
                            } else {
                                n6 = Integer.MIN_VALUE;
                            }
                            n5 = f2 == 0.0f ? this.mTotalLength : 0;
                            this.measureChildBeforeLayout((View)object, n7, n2, n5, n3, 0);
                            if (n6 != Integer.MIN_VALUE) {
                                layoutParams.width = n6;
                            }
                            n5 = object.getMeasuredWidth();
                            if (bl2) {
                                this.mTotalLength += layoutParams.leftMargin + n5 + layoutParams.rightMargin + this.getNextLocationOffset((View)object);
                            } else {
                                n6 = this.mTotalLength;
                                this.mTotalLength = Math.max(n6, n6 + n5 + layoutParams.leftMargin + layoutParams.rightMargin + this.getNextLocationOffset((View)object));
                            }
                            n6 = n14;
                            if (bl3) {
                                n6 = Math.max(n5, n14);
                            }
                        }
                        n14 = n6;
                    }
                    n4 = n7;
                    if (n15 != 0x40000000 && layoutParams.height == -1) {
                        n7 = 1;
                        bl = true;
                    } else {
                        n7 = 0;
                    }
                    n6 = layoutParams.topMargin + layoutParams.bottomMargin;
                    n5 = object.getMeasuredHeight() + n6;
                    int n19 = View.combineMeasuredStates((int)n9, (int)object.getMeasuredState());
                    if (bl4 && (n18 = object.getBaseline()) != -1) {
                        n9 = layoutParams.gravity < 0 ? this.mGravity : layoutParams.gravity;
                        n9 = ((n9 & 0x70) >> 4 & 0xFFFFFFFE) >> 1;
                        nArray[n9] = Math.max(nArray[n9], n18);
                        object2[n9] = Math.max(object2[n9], n5 - n18);
                    }
                    n13 = Math.max(n13, n5);
                    n8 = n8 != 0 && layoutParams.height == -1 ? 1 : 0;
                    if (layoutParams.weight > 0.0f) {
                        if (n7 == 0) {
                            n6 = n5;
                        }
                        n7 = Math.max(n11, n6);
                    } else {
                        if (n7 != 0) {
                            n5 = n6;
                        }
                        n12 = Math.max(n12, n5);
                        n7 = n11;
                    }
                    n11 = this.getChildrenSkipCount((View)object, n4);
                    n9 = n19;
                    n6 = n11 + n4;
                    n11 = n7;
                    n7 = n6;
                }
                n7 = n13;
                if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(n17)) {
                    this.mTotalLength += this.mDividerWidth;
                }
                if (nArray[1] != -1 || nArray[0] != -1 || nArray[2] != -1 || nArray[3] != -1) {
                    n7 = Math.max(n7, Math.max(nArray[3], Math.max(nArray[0], Math.max(nArray[1], nArray[2]))) + Math.max(object2[3], Math.max(object2[0], Math.max(object2[1], object2[2]))));
                }
                n13 = n9;
                n6 = n7;
                if (!bl3) break block51;
                if (n16 == Integer.MIN_VALUE) break block52;
                n6 = n7;
                if (n16 != 0) break block51;
            }
            this.mTotalLength = 0;
            n9 = 0;
            while (true) {
                n6 = n7;
                if (n9 >= n17) break;
                object = this.getVirtualChildAt(n9);
                if (object == null) {
                    this.mTotalLength += this.measureNullChild(n9);
                } else if (object.getVisibility() == 8) {
                    n9 += this.getChildrenSkipCount((View)object, n9);
                } else {
                    layoutParams = (LayoutParams)object.getLayoutParams();
                    if (bl2) {
                        this.mTotalLength += layoutParams.leftMargin + n14 + layoutParams.rightMargin + this.getNextLocationOffset((View)object);
                    } else {
                        n6 = this.mTotalLength;
                        this.mTotalLength = Math.max(n6, n6 + n14 + layoutParams.leftMargin + layoutParams.rightMargin + this.getNextLocationOffset((View)object));
                    }
                }
                ++n9;
            }
        }
        this.mTotalLength += this.getPaddingLeft() + this.getPaddingRight();
        n4 = View.resolveSizeAndState((int)Math.max(this.mTotalLength, this.getSuggestedMinimumWidth()), (int)n2, (int)0);
        n5 = (0xFFFFFF & n4) - this.mTotalLength;
        if (!(n10 != 0 || n5 != 0 && f2 > 0.0f)) {
            n9 = Math.max(n12, n11);
            if (bl3 && n16 != 0x40000000) {
                for (n12 = 0; n12 < n17; ++n12) {
                    object2 = this.getVirtualChildAt(n12);
                    if (object2 == null || object2.getVisibility() == 8 || !(((LayoutParams)object2.getLayoutParams()).weight > 0.0f)) continue;
                    object2.measure(View.MeasureSpec.makeMeasureSpec((int)n14, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)object2.getMeasuredHeight(), (int)0x40000000));
                }
            }
            n7 = n17;
            n14 = n6;
            n12 = n9;
        } else {
            float f3 = this.mWeightSum;
            if (f3 > 0.0f) {
                f2 = f3;
            }
            nArray[3] = -1;
            nArray[2] = -1;
            nArray[1] = -1;
            nArray[0] = -1;
            object2[3] = -1;
            object2[2] = -1;
            object2[1] = -1;
            object2[0] = -1;
            this.mTotalLength = 0;
            n11 = -1;
            n10 = 0;
            n7 = n8;
            n14 = n17;
            n9 = n12;
            n8 = n13;
            n12 = n5;
            for (n13 = n10; n13 < n14; ++n13) {
                layoutParams = this.getVirtualChildAt(n13);
                if (layoutParams == null || layoutParams.getVisibility() == 8) continue;
                object = (LayoutParams)layoutParams.getLayoutParams();
                f3 = object.weight;
                if (f3 > 0.0f) {
                    n6 = (int)((float)n12 * f3 / f2);
                    n5 = LinearLayoutCompat.getChildMeasureSpec((int)n3, (int)(this.getPaddingTop() + this.getPaddingBottom() + object.topMargin + object.bottomMargin), (int)object.height);
                    if (object.width == 0 && n16 == 0x40000000) {
                        n10 = n6 > 0 ? n6 : 0;
                        layoutParams.measure(View.MeasureSpec.makeMeasureSpec((int)n10, (int)0x40000000), n5);
                    } else {
                        n10 = n17 = layoutParams.getMeasuredWidth() + n6;
                        if (n17 < 0) {
                            n10 = 0;
                        }
                        layoutParams.measure(View.MeasureSpec.makeMeasureSpec((int)n10, (int)0x40000000), n5);
                    }
                    n8 = View.combineMeasuredStates((int)n8, (int)(layoutParams.getMeasuredState() & 0xFF000000));
                    f2 -= f3;
                    n12 -= n6;
                }
                if (bl2) {
                    this.mTotalLength += layoutParams.getMeasuredWidth() + object.leftMargin + object.rightMargin + this.getNextLocationOffset((View)layoutParams);
                } else {
                    n10 = this.mTotalLength;
                    this.mTotalLength = Math.max(n10, layoutParams.getMeasuredWidth() + n10 + object.leftMargin + object.rightMargin + this.getNextLocationOffset((View)layoutParams));
                }
                n10 = n15 != 0x40000000 && object.height == -1 ? 1 : 0;
                n5 = object.topMargin + object.bottomMargin;
                n17 = layoutParams.getMeasuredHeight() + n5;
                n6 = Math.max(n11, n17);
                n11 = n10 != 0 ? n5 : n17;
                n11 = Math.max(n9, n11);
                n7 = n7 != 0 && object.height == -1 ? 1 : 0;
                if (bl4 && (n10 = layoutParams.getBaseline()) != -1) {
                    n9 = object.gravity < 0 ? this.mGravity : object.gravity;
                    n9 = ((n9 & 0x70) >> 4 & 0xFFFFFFFE) >> 1;
                    nArray[n9] = Math.max(nArray[n9], n10);
                    object2[n9] = Math.max(object2[n9], n17 - n10);
                }
                n9 = n11;
                n11 = n6;
            }
            this.mTotalLength += this.getPaddingLeft() + this.getPaddingRight();
            n12 = nArray[1] == -1 && nArray[0] == -1 && nArray[2] == -1 && nArray[3] == -1 ? n11 : Math.max(n11, Math.max(nArray[3], Math.max(nArray[0], Math.max(nArray[1], nArray[2]))) + Math.max(object2[3], Math.max(object2[0], Math.max(object2[1], object2[2]))));
            n13 = n8;
            n8 = n7;
            n7 = n14;
            n14 = n12;
            n12 = n9;
        }
        if (n8 != 0 || n15 == 0x40000000) {
            n12 = n14;
        }
        this.setMeasuredDimension(n4 | n13 & 0xFF000000, View.resolveSizeAndState((int)Math.max(n12 + (this.getPaddingTop() + this.getPaddingBottom()), this.getSuggestedMinimumHeight()), (int)n3, (int)(n13 << 16)));
        if (bl) {
            this.forceUniformHeight(n7, n2);
        }
    }

    int measureNullChild(int n2) {
        return 0;
    }

    void measureVertical(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        LayoutParams layoutParams;
        View view;
        int n8;
        this.mTotalLength = 0;
        int n9 = this.getVirtualChildCount();
        int n10 = View.MeasureSpec.getMode((int)n2);
        int n11 = View.MeasureSpec.getMode((int)n3);
        int n12 = this.mBaselineAlignedChildIndex;
        boolean bl = this.mUseLargestChild;
        float f2 = 0.0f;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 1;
        boolean bl2 = false;
        for (n8 = 0; n8 < n9; ++n8) {
            view = this.getVirtualChildAt(n8);
            if (view == null) {
                this.mTotalLength += this.measureNullChild(n8);
                continue;
            }
            if (view.getVisibility() == 8) {
                n8 += this.getChildrenSkipCount(view, n8);
                continue;
            }
            if (this.hasDividerBeforeChildAt(n8)) {
                this.mTotalLength += this.mDividerHeight;
            }
            layoutParams = (LayoutParams)view.getLayoutParams();
            f2 += layoutParams.weight;
            if (n11 == 0x40000000 && layoutParams.height == 0 && layoutParams.weight > 0.0f) {
                n18 = this.mTotalLength;
                this.mTotalLength = Math.max(n18, layoutParams.topMargin + n18 + layoutParams.bottomMargin);
                n18 = 1;
            } else {
                if (layoutParams.height == 0 && layoutParams.weight > 0.0f) {
                    layoutParams.height = -2;
                    n7 = 0;
                } else {
                    n7 = Integer.MIN_VALUE;
                }
                n6 = f2 == 0.0f ? this.mTotalLength : 0;
                this.measureChildBeforeLayout(view, n8, n2, 0, n3, n6);
                if (n7 != Integer.MIN_VALUE) {
                    layoutParams.height = n7;
                }
                n6 = view.getMeasuredHeight();
                n7 = this.mTotalLength;
                this.mTotalLength = Math.max(n7, n7 + n6 + layoutParams.topMargin + layoutParams.bottomMargin + this.getNextLocationOffset(view));
                if (bl) {
                    n15 = Math.max(n6, n15);
                }
            }
            n5 = n8;
            if (n12 >= 0 && n12 == n5 + 1) {
                this.mBaselineChildTop = this.mTotalLength;
            }
            if (n5 < n12 && layoutParams.weight > 0.0f) {
                throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
            }
            if (n10 != 0x40000000 && layoutParams.width == -1) {
                n8 = 1;
                bl2 = true;
            } else {
                n8 = 0;
            }
            n6 = layoutParams.leftMargin + layoutParams.rightMargin;
            n7 = view.getMeasuredWidth() + n6;
            n14 = Math.max(n14, n7);
            n4 = View.combineMeasuredStates((int)n13, (int)view.getMeasuredState());
            n13 = n19 != 0 && layoutParams.width == -1 ? 1 : 0;
            if (layoutParams.weight > 0.0f) {
                if (n8 != 0) {
                    n7 = n6;
                }
                n16 = Math.max(n16, n7);
                n19 = n17;
                n17 = n16;
            } else {
                if (n8 != 0) {
                    n7 = n6;
                }
                n19 = Math.max(n17, n7);
                n17 = n16;
            }
            n7 = this.getChildrenSkipCount(view, n5);
            n8 = n13;
            n16 = n17;
            n17 = n19;
            n13 = n4;
            n19 = n8;
            n8 = n7 += n5;
        }
        if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(n9)) {
            this.mTotalLength += this.mDividerHeight;
        }
        if (bl && (n11 == Integer.MIN_VALUE || n11 == 0)) {
            this.mTotalLength = 0;
            for (n8 = 0; n8 < n9; ++n8) {
                view = this.getVirtualChildAt(n8);
                if (view == null) {
                    this.mTotalLength += this.measureNullChild(n8);
                    continue;
                }
                if (view.getVisibility() == 8) {
                    n8 += this.getChildrenSkipCount(view, n8);
                    continue;
                }
                layoutParams = (LayoutParams)view.getLayoutParams();
                n7 = this.mTotalLength;
                this.mTotalLength = Math.max(n7, n7 + n15 + layoutParams.topMargin + layoutParams.bottomMargin + this.getNextLocationOffset(view));
            }
        }
        this.mTotalLength += this.getPaddingTop() + this.getPaddingBottom();
        n6 = View.resolveSizeAndState((int)Math.max(this.mTotalLength, this.getSuggestedMinimumHeight()), (int)n3, (int)0);
        n7 = (0xFFFFFF & n6) - this.mTotalLength;
        if (!(n18 != 0 || n7 != 0 && f2 > 0.0f)) {
            n16 = Math.max(n17, n16);
            if (bl && n11 != 0x40000000) {
                for (n17 = 0; n17 < n9; ++n17) {
                    view = this.getVirtualChildAt(n17);
                    if (view == null || view.getVisibility() == 8 || !(((LayoutParams)view.getLayoutParams()).weight > 0.0f)) continue;
                    view.measure(View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n15, (int)0x40000000));
                }
            }
            n17 = n13;
            n13 = n16;
            n16 = n14;
        } else {
            float f3 = this.mWeightSum;
            if (f3 > 0.0f) {
                f2 = f3;
            }
            this.mTotalLength = 0;
            n15 = n7;
            n16 = n14;
            for (n8 = 0; n8 < n9; ++n8) {
                view = this.getVirtualChildAt(n8);
                if (view.getVisibility() == 8) continue;
                layoutParams = (LayoutParams)view.getLayoutParams();
                f3 = layoutParams.weight;
                if (f3 > 0.0f) {
                    n14 = (int)((float)n15 * f3 / f2);
                    n7 = this.getPaddingLeft();
                    n5 = this.getPaddingRight();
                    n18 = n15 - n14;
                    n15 = layoutParams.leftMargin;
                    n4 = layoutParams.rightMargin;
                    n12 = layoutParams.width;
                    f2 -= f3;
                    n7 = LinearLayoutCompat.getChildMeasureSpec((int)n2, (int)(n7 + n5 + n15 + n4), (int)n12);
                    if (layoutParams.height == 0 && n11 == 0x40000000) {
                        n15 = n14 > 0 ? n14 : 0;
                        view.measure(n7, View.MeasureSpec.makeMeasureSpec((int)n15, (int)0x40000000));
                    } else {
                        n15 = n14 = view.getMeasuredHeight() + n14;
                        if (n14 < 0) {
                            n15 = 0;
                        }
                        view.measure(n7, View.MeasureSpec.makeMeasureSpec((int)n15, (int)0x40000000));
                    }
                    n13 = View.combineMeasuredStates((int)n13, (int)(view.getMeasuredState() & 0xFFFFFF00));
                    n15 = n18;
                }
                n7 = layoutParams.leftMargin + layoutParams.rightMargin;
                n14 = view.getMeasuredWidth() + n7;
                n18 = Math.max(n16, n14);
                n16 = n10 != 0x40000000 && layoutParams.width == -1 ? 1 : 0;
                n16 = n16 != 0 ? n7 : n14;
                n17 = Math.max(n17, n16);
                n19 = n19 != 0 && layoutParams.width == -1 ? 1 : 0;
                n16 = this.mTotalLength;
                this.mTotalLength = Math.max(n16, view.getMeasuredHeight() + n16 + layoutParams.topMargin + layoutParams.bottomMargin + this.getNextLocationOffset(view));
                n16 = n18;
            }
            this.mTotalLength += this.getPaddingTop() + this.getPaddingBottom();
            n15 = n17;
            n17 = n13;
            n13 = n15;
        }
        if (n19 != 0 || n10 == 0x40000000) {
            n13 = n16;
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)Math.max(n13 + (this.getPaddingLeft() + this.getPaddingRight()), this.getSuggestedMinimumWidth()), (int)n2, (int)n17), n6);
        if (bl2) {
            this.forceUniformWidth(n9, n3);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.drawDividersVertical(canvas);
        } else {
            this.drawDividersHorizontal(canvas);
        }
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        if (this.mOrientation == 1) {
            this.layoutVertical(n2, n3, n4, n5);
        } else {
            this.layoutHorizontal(n2, n3, n4, n5);
        }
    }

    protected void onMeasure(int n2, int n3) {
        if (this.mOrientation == 1) {
            this.measureVertical(n2, n3);
        } else {
            this.measureHorizontal(n2, n3);
        }
    }

    public void setBaselineAligned(boolean bl) {
        this.mBaselineAligned = bl;
    }

    public void setBaselineAlignedChildIndex(int n2) {
        if (n2 >= 0 && n2 < this.getChildCount()) {
            this.mBaselineAlignedChildIndex = n2;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("base aligned child index out of range (0, ");
        stringBuilder.append(this.getChildCount());
        stringBuilder.append(")");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void setDividerDrawable(Drawable drawable2) {
        if (drawable2 == this.mDivider) {
            return;
        }
        this.mDivider = drawable2;
        boolean bl = false;
        if (drawable2 != null) {
            this.mDividerWidth = drawable2.getIntrinsicWidth();
            this.mDividerHeight = drawable2.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        if (drawable2 == null) {
            bl = true;
        }
        this.setWillNotDraw(bl);
        this.requestLayout();
    }

    public void setDividerPadding(int n2) {
        this.mDividerPadding = n2;
    }

    public void setGravity(int n2) {
        if (this.mGravity != n2) {
            int n3 = n2;
            if ((0x800007 & n2) == 0) {
                n3 = n2 | 0x800003;
            }
            n2 = n3;
            if ((n3 & 0x70) == 0) {
                n2 = n3 | 0x30;
            }
            this.mGravity = n2;
            this.requestLayout();
        }
    }

    public void setHorizontalGravity(int n2) {
        int n3 = this.mGravity;
        if ((0x800007 & n3) != (n2 &= 0x800007)) {
            this.mGravity = n2 | 0xFF7FFFF8 & n3;
            this.requestLayout();
        }
    }

    public void setMeasureWithLargestChildEnabled(boolean bl) {
        this.mUseLargestChild = bl;
    }

    public void setOrientation(int n2) {
        if (this.mOrientation != n2) {
            this.mOrientation = n2;
            this.requestLayout();
        }
    }

    public void setShowDividers(int n2) {
        if (n2 != this.mShowDividers) {
            this.requestLayout();
        }
        this.mShowDividers = n2;
    }

    public void setVerticalGravity(int n2) {
        int n3 = this.mGravity;
        if ((n3 & 0x70) != (n2 &= 0x70)) {
            this.mGravity = n2 | n3 & 0xFFFFFF8F;
            this.requestLayout();
        }
    }

    public void setWeightSum(float f2) {
        this.mWeightSum = Math.max(0.0f, f2);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerMode {
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = -1;
        public float weight;

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
            this.weight = 0.0f;
        }

        public LayoutParams(int n2, int n3, float f2) {
            super(n2, n3);
            this.weight = f2;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, R.styleable.LinearLayoutCompat_Layout);
            this.weight = context.getFloat(R.styleable.LinearLayoutCompat_Layout_android_layout_weight, 0.0f);
            this.gravity = context.getInt(R.styleable.LinearLayoutCompat_Layout_android_layout_gravity, -1);
            context.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
            this.weight = layoutParams.weight;
            this.gravity = layoutParams.gravity;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

