/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.view.menu;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.view.menu.SubMenuBuilder;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.internal.view.SupportMenuItem;
import androidx.core.view.ActionProvider;
import com.safedk.android.utils.Logger;

public final class MenuItemImpl
implements SupportMenuItem {
    private static final int CHECKABLE = 1;
    private static final int CHECKED = 2;
    private static final int ENABLED = 16;
    private static final int EXCLUSIVE = 4;
    private static final int HIDDEN = 8;
    private static final int IS_ACTION = 32;
    static final int NO_ICON = 0;
    private static final int SHOW_AS_ACTION_MASK = 3;
    private static final String TAG = "MenuItemImpl";
    private androidx.core.view.ActionProvider mActionProvider;
    private View mActionView;
    private final int mCategoryOrder;
    private MenuItem.OnMenuItemClickListener mClickListener;
    private CharSequence mContentDescription;
    private int mFlags = 16;
    private final int mGroup;
    private boolean mHasIconTint = false;
    private boolean mHasIconTintMode = false;
    private Drawable mIconDrawable;
    private int mIconResId = 0;
    private ColorStateList mIconTintList = null;
    private PorterDuff.Mode mIconTintMode = null;
    private final int mId;
    private Intent mIntent;
    private boolean mIsActionViewExpanded = false;
    private Runnable mItemCallback;
    MenuBuilder mMenu;
    private ContextMenu.ContextMenuInfo mMenuInfo;
    private boolean mNeedToApplyIconTint = false;
    private MenuItem.OnActionExpandListener mOnActionExpandListener;
    private final int mOrdering;
    private char mShortcutAlphabeticChar;
    private int mShortcutAlphabeticModifiers = 4096;
    private char mShortcutNumericChar;
    private int mShortcutNumericModifiers = 4096;
    private int mShowAsAction = 0;
    private SubMenuBuilder mSubMenu;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;
    private CharSequence mTooltipText;

    MenuItemImpl(MenuBuilder menuBuilder, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6) {
        this.mMenu = menuBuilder;
        this.mId = n3;
        this.mGroup = n2;
        this.mCategoryOrder = n4;
        this.mOrdering = n5;
        this.mTitle = charSequence;
        this.mShowAsAction = n6;
    }

    private static void appendModifier(StringBuilder stringBuilder, int n2, int n3, String string2) {
        if ((n2 & n3) == n3) {
            stringBuilder.append(string2);
        }
    }

    private Drawable applyIconTintIfNecessary(Drawable drawable2) {
        Drawable drawable3;
        block5: {
            block6: {
                drawable3 = drawable2;
                if (drawable2 == null) break block5;
                drawable3 = drawable2;
                if (!this.mNeedToApplyIconTint) break block5;
                if (this.mHasIconTint) break block6;
                drawable3 = drawable2;
                if (!this.mHasIconTintMode) break block5;
            }
            drawable3 = DrawableCompat.wrap((Drawable)drawable2).mutate();
            if (this.mHasIconTint) {
                DrawableCompat.setTintList((Drawable)drawable3, (ColorStateList)this.mIconTintList);
            }
            if (this.mHasIconTintMode) {
                DrawableCompat.setTintMode((Drawable)drawable3, (PorterDuff.Mode)this.mIconTintMode);
            }
            this.mNeedToApplyIconTint = false;
        }
        return drawable3;
    }

    public static void safedk_Context_startActivity_97cb3195734cf5c9cc3418feeafa6dd6(Context context, Intent intent) {
        Logger.d("SafeDK-Special|SafeDK: Call> Landroid/content/Context;->startActivity(Landroid/content/Intent;)V");
        if (intent == null) {
            return;
        }
        context.startActivity(intent);
    }

    public void actionFormatChanged() {
        this.mMenu.onItemActionRequestChanged(this);
    }

    public boolean collapseActionView() {
        if ((this.mShowAsAction & 8) == 0) {
            return false;
        }
        if (this.mActionView == null) {
            return true;
        }
        MenuItem.OnActionExpandListener onActionExpandListener = this.mOnActionExpandListener;
        if (onActionExpandListener != null && !onActionExpandListener.onMenuItemActionCollapse((MenuItem)this)) {
            return false;
        }
        return this.mMenu.collapseItemActionView(this);
    }

    public boolean expandActionView() {
        if (!this.hasCollapsibleActionView()) {
            return false;
        }
        MenuItem.OnActionExpandListener onActionExpandListener = this.mOnActionExpandListener;
        if (onActionExpandListener != null && !onActionExpandListener.onMenuItemActionExpand((MenuItem)this)) {
            return false;
        }
        return this.mMenu.expandItemActionView(this);
    }

    public ActionProvider getActionProvider() {
        throw new UnsupportedOperationException("This is not supported, use MenuItemCompat.getActionProvider()");
    }

    public View getActionView() {
        View view = this.mActionView;
        if (view != null) {
            return view;
        }
        view = this.mActionProvider;
        if (view != null) {
            this.mActionView = view.onCreateActionView((MenuItem)this);
            return this.mActionView;
        }
        return null;
    }

    public int getAlphabeticModifiers() {
        return this.mShortcutAlphabeticModifiers;
    }

    public char getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    Runnable getCallback() {
        return this.mItemCallback;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public int getGroupId() {
        return this.mGroup;
    }

    public Drawable getIcon() {
        Drawable drawable2 = this.mIconDrawable;
        if (drawable2 != null) {
            return this.applyIconTintIfNecessary(drawable2);
        }
        if (this.mIconResId != 0) {
            drawable2 = AppCompatResources.getDrawable((Context)this.mMenu.getContext(), (int)this.mIconResId);
            this.mIconResId = 0;
            this.mIconDrawable = drawable2;
            return this.applyIconTintIfNecessary(drawable2);
        }
        return null;
    }

    public ColorStateList getIconTintList() {
        return this.mIconTintList;
    }

    public PorterDuff.Mode getIconTintMode() {
        return this.mIconTintMode;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    @ViewDebug.CapturedViewProperty
    public int getItemId() {
        return this.mId;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return this.mMenuInfo;
    }

    public int getNumericModifiers() {
        return this.mShortcutNumericModifiers;
    }

    public char getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    public int getOrder() {
        return this.mCategoryOrder;
    }

    public int getOrdering() {
        return this.mOrdering;
    }

    char getShortcut() {
        char c2;
        char c3;
        char c4 = this.mMenu.isQwertyMode() ? (c3 = this.mShortcutAlphabeticChar) : (c2 = this.mShortcutNumericChar);
        return c4;
    }

    String getShortcutLabel() {
        char c2 = this.getShortcut();
        if (c2 == '\u0000') {
            return "";
        }
        Resources resources = this.mMenu.getContext().getResources();
        StringBuilder stringBuilder = new StringBuilder();
        if (ViewConfiguration.get((Context)this.mMenu.getContext()).hasPermanentMenuKey()) {
            stringBuilder.append(resources.getString(R.string.abc_prepend_shortcut_label));
        }
        int n2 = this.mMenu.isQwertyMode() ? this.mShortcutAlphabeticModifiers : this.mShortcutNumericModifiers;
        MenuItemImpl.appendModifier(stringBuilder, n2, 65536, resources.getString(R.string.abc_menu_meta_shortcut_label));
        MenuItemImpl.appendModifier(stringBuilder, n2, 4096, resources.getString(R.string.abc_menu_ctrl_shortcut_label));
        MenuItemImpl.appendModifier(stringBuilder, n2, 2, resources.getString(R.string.abc_menu_alt_shortcut_label));
        MenuItemImpl.appendModifier(stringBuilder, n2, 1, resources.getString(R.string.abc_menu_shift_shortcut_label));
        MenuItemImpl.appendModifier(stringBuilder, n2, 4, resources.getString(R.string.abc_menu_sym_shortcut_label));
        MenuItemImpl.appendModifier(stringBuilder, n2, 8, resources.getString(R.string.abc_menu_function_shortcut_label));
        if (c2 != '\b') {
            if (c2 != '\n') {
                if (c2 != ' ') {
                    stringBuilder.append(c2);
                } else {
                    stringBuilder.append(resources.getString(R.string.abc_menu_space_shortcut_label));
                }
            } else {
                stringBuilder.append(resources.getString(R.string.abc_menu_enter_shortcut_label));
            }
        } else {
            stringBuilder.append(resources.getString(R.string.abc_menu_delete_shortcut_label));
        }
        return stringBuilder.toString();
    }

    public SubMenu getSubMenu() {
        return this.mSubMenu;
    }

    public androidx.core.view.ActionProvider getSupportActionProvider() {
        return this.mActionProvider;
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getTitleCondensed() {
        CharSequence charSequence = this.mTitleCondensed;
        if (charSequence == null) {
            charSequence = this.mTitle;
        }
        CharSequence charSequence2 = charSequence;
        if (Build.VERSION.SDK_INT < 18) {
            charSequence2 = charSequence;
            if (charSequence != null) {
                charSequence2 = charSequence;
                if (!(charSequence instanceof String)) {
                    charSequence2 = charSequence.toString();
                }
            }
        }
        return charSequence2;
    }

    CharSequence getTitleForItemView(MenuView.ItemView object) {
        object = object != null && object.prefersCondensedTitle() ? this.getTitleCondensed() : this.getTitle();
        return object;
    }

    public CharSequence getTooltipText() {
        return this.mTooltipText;
    }

    public boolean hasCollapsibleActionView() {
        boolean bl;
        int n2 = this.mShowAsAction;
        boolean bl2 = bl = false;
        if ((n2 & 8) != 0) {
            androidx.core.view.ActionProvider actionProvider;
            if (this.mActionView == null && (actionProvider = this.mActionProvider) != null) {
                this.mActionView = actionProvider.onCreateActionView((MenuItem)this);
            }
            bl2 = bl;
            if (this.mActionView != null) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean hasSubMenu() {
        boolean bl = this.mSubMenu != null;
        return bl;
    }

    public boolean invoke() {
        Object object = this.mClickListener;
        if (object != null && object.onMenuItemClick((MenuItem)this)) {
            return true;
        }
        object = this.mMenu;
        if (object.dispatchMenuItemSelected((MenuBuilder)object, (MenuItem)this)) {
            return true;
        }
        object = this.mItemCallback;
        if (object != null) {
            object.run();
            return true;
        }
        if (this.mIntent != null) {
            try {
                MenuItemImpl.safedk_Context_startActivity_97cb3195734cf5c9cc3418feeafa6dd6(this.mMenu.getContext(), this.mIntent);
                return true;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                Log.e((String)TAG, (String)"Can't find activity to handle intent; ignoring", (Throwable)activityNotFoundException);
            }
        }
        return (object = this.mActionProvider) != null && object.onPerformDefaultAction();
    }

    public boolean isActionButton() {
        boolean bl = (this.mFlags & 0x20) == 32;
        return bl;
    }

    public boolean isActionViewExpanded() {
        return this.mIsActionViewExpanded;
    }

    public boolean isCheckable() {
        int n2 = this.mFlags;
        boolean bl = true;
        if ((n2 & 1) != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean isChecked() {
        boolean bl = (this.mFlags & 2) == 2;
        return bl;
    }

    public boolean isEnabled() {
        boolean bl = (this.mFlags & 0x10) != 0;
        return bl;
    }

    public boolean isExclusiveCheckable() {
        boolean bl = (this.mFlags & 4) != 0;
        return bl;
    }

    public boolean isVisible() {
        androidx.core.view.ActionProvider actionProvider = this.mActionProvider;
        boolean bl = true;
        boolean bl2 = true;
        if (actionProvider != null && actionProvider.overridesItemVisibility()) {
            if ((this.mFlags & 8) != 0 || !this.mActionProvider.isVisible()) {
                bl2 = false;
            }
            return bl2;
        }
        bl2 = (this.mFlags & 8) == 0 ? bl : false;
        return bl2;
    }

    public boolean requestsActionButton() {
        int n2 = this.mShowAsAction;
        boolean bl = true;
        if ((n2 & 1) != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean requiresActionButton() {
        boolean bl = (this.mShowAsAction & 2) == 2;
        return bl;
    }

    public boolean requiresOverflow() {
        boolean bl = !this.requiresActionButton() && !this.requestsActionButton();
        return bl;
    }

    public MenuItem setActionProvider(ActionProvider actionProvider) {
        throw new UnsupportedOperationException("This is not supported, use MenuItemCompat.setActionProvider()");
    }

    public SupportMenuItem setActionView(int n2) {
        Context context = this.mMenu.getContext();
        this.setActionView(LayoutInflater.from((Context)context).inflate(n2, (ViewGroup)new LinearLayout(context), false));
        return this;
    }

    public SupportMenuItem setActionView(View view) {
        int n2;
        this.mActionView = view;
        this.mActionProvider = null;
        if (view != null && view.getId() == -1 && (n2 = this.mId) > 0) {
            view.setId(n2);
        }
        this.mMenu.onItemActionRequestChanged(this);
        return this;
    }

    public void setActionViewExpanded(boolean bl) {
        this.mIsActionViewExpanded = bl;
        this.mMenu.onItemsChanged(false);
    }

    public MenuItem setAlphabeticShortcut(char c2) {
        if (this.mShortcutAlphabeticChar == c2) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(c2);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setAlphabeticShortcut(char c2, int n2) {
        if (this.mShortcutAlphabeticChar == c2 && this.mShortcutAlphabeticModifiers == n2) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(c2);
        this.mShortcutAlphabeticModifiers = KeyEvent.normalizeMetaState((int)n2);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setCallback(Runnable runnable2) {
        this.mItemCallback = runnable2;
        return this;
    }

    public MenuItem setCheckable(boolean bl) {
        int n2 = this.mFlags;
        this.mFlags = bl | n2 & 0xFFFFFFFE;
        if (n2 != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
        return this;
    }

    public MenuItem setChecked(boolean bl) {
        if ((this.mFlags & 4) != 0) {
            this.mMenu.setExclusiveItemChecked((MenuItem)this);
        } else {
            this.setCheckedInt(bl);
        }
        return this;
    }

    void setCheckedInt(boolean bl) {
        int n2 = this.mFlags;
        int n3 = bl ? 2 : 0;
        this.mFlags = n3 | n2 & 0xFFFFFFFD;
        if (n2 != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
    }

    public SupportMenuItem setContentDescription(CharSequence charSequence) {
        this.mContentDescription = charSequence;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setEnabled(boolean bl) {
        this.mFlags = bl ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public void setExclusiveCheckable(boolean bl) {
        int n2 = this.mFlags;
        int n3 = bl ? 4 : 0;
        this.mFlags = n3 | n2 & 0xFFFFFFFB;
    }

    public MenuItem setIcon(int n2) {
        this.mIconDrawable = null;
        this.mIconResId = n2;
        this.mNeedToApplyIconTint = true;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setIcon(Drawable drawable2) {
        this.mIconResId = 0;
        this.mIconDrawable = drawable2;
        this.mNeedToApplyIconTint = true;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setIconTintList(ColorStateList colorStateList) {
        this.mIconTintList = colorStateList;
        this.mHasIconTint = true;
        this.mNeedToApplyIconTint = true;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setIconTintMode(PorterDuff.Mode mode) {
        this.mIconTintMode = mode;
        this.mHasIconTintMode = true;
        this.mNeedToApplyIconTint = true;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    public void setIsActionButton(boolean bl) {
        this.mFlags = bl ? (this.mFlags |= 0x20) : (this.mFlags &= 0xFFFFFFDF);
    }

    void setMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mMenuInfo = contextMenuInfo;
    }

    public MenuItem setNumericShortcut(char c2) {
        if (this.mShortcutNumericChar == c2) {
            return this;
        }
        this.mShortcutNumericChar = c2;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setNumericShortcut(char c2, int n2) {
        if (this.mShortcutNumericChar == c2 && this.mShortcutNumericModifiers == n2) {
            return this;
        }
        this.mShortcutNumericChar = c2;
        this.mShortcutNumericModifiers = KeyEvent.normalizeMetaState((int)n2);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        this.mOnActionExpandListener = onActionExpandListener;
        return this;
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        this.mClickListener = onMenuItemClickListener;
        return this;
    }

    public MenuItem setShortcut(char c2, char c3) {
        this.mShortcutNumericChar = c2;
        this.mShortcutAlphabeticChar = Character.toLowerCase(c3);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setShortcut(char c2, char c3, int n2, int n3) {
        this.mShortcutNumericChar = c2;
        this.mShortcutNumericModifiers = KeyEvent.normalizeMetaState((int)n2);
        this.mShortcutAlphabeticChar = Character.toLowerCase(c3);
        this.mShortcutAlphabeticModifiers = KeyEvent.normalizeMetaState((int)n3);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public void setShowAsAction(int n2) {
        int n3 = n2 & 3;
        if (n3 != 0 && n3 != 1 && n3 != 2) {
            throw new IllegalArgumentException("SHOW_AS_ACTION_ALWAYS, SHOW_AS_ACTION_IF_ROOM, and SHOW_AS_ACTION_NEVER are mutually exclusive.");
        }
        this.mShowAsAction = n2;
        this.mMenu.onItemActionRequestChanged(this);
    }

    public SupportMenuItem setShowAsActionFlags(int n2) {
        this.setShowAsAction(n2);
        return this;
    }

    public void setSubMenu(SubMenuBuilder subMenuBuilder) {
        this.mSubMenu = subMenuBuilder;
        subMenuBuilder.setHeaderTitle(this.getTitle());
    }

    public SupportMenuItem setSupportActionProvider(androidx.core.view.ActionProvider actionProvider) {
        androidx.core.view.ActionProvider actionProvider2 = this.mActionProvider;
        if (actionProvider2 != null) {
            actionProvider2.reset();
        }
        this.mActionView = null;
        this.mActionProvider = actionProvider;
        this.mMenu.onItemsChanged(true);
        actionProvider = this.mActionProvider;
        if (actionProvider != null) {
            actionProvider.setVisibilityListener(new ActionProvider.VisibilityListener(){

                public void onActionProviderVisibilityChanged(boolean bl) {
                    MenuItemImpl.this.mMenu.onItemVisibleChanged(MenuItemImpl.this);
                }
            });
        }
        return this;
    }

    public MenuItem setTitle(int n2) {
        return this.setTitle(this.mMenu.getContext().getString(n2));
    }

    public MenuItem setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.mMenu.onItemsChanged(false);
        SubMenuBuilder subMenuBuilder = this.mSubMenu;
        if (subMenuBuilder != null) {
            subMenuBuilder.setHeaderTitle(charSequence);
        }
        return this;
    }

    public MenuItem setTitleCondensed(CharSequence charSequence) {
        this.mTitleCondensed = charSequence;
        if (charSequence == null) {
            charSequence = this.mTitle;
        }
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public SupportMenuItem setTooltipText(CharSequence charSequence) {
        this.mTooltipText = charSequence;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setVisible(boolean bl) {
        if (this.setVisibleInt(bl)) {
            this.mMenu.onItemVisibleChanged(this);
        }
        return this;
    }

    boolean setVisibleInt(boolean bl) {
        int n2 = this.mFlags;
        boolean bl2 = false;
        int n3 = bl ? 0 : 8;
        this.mFlags = n3 | n2 & 0xFFFFFFF7;
        bl = bl2;
        if (n2 != this.mFlags) {
            bl = true;
        }
        return bl;
    }

    public boolean shouldShowIcon() {
        return this.mMenu.getOptionalIconsVisible();
    }

    boolean shouldShowShortcut() {
        boolean bl = this.mMenu.isShortcutsVisible() && this.getShortcut() != '\u0000';
        return bl;
    }

    public boolean showsTextAsAction() {
        boolean bl = (this.mShowAsAction & 4) == 4;
        return bl;
    }

    public String toString() {
        CharSequence charSequence = this.mTitle;
        charSequence = charSequence != null ? charSequence.toString() : null;
        return charSequence;
    }
}

