/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.view.menu;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import androidx.appcompat.view.menu.ListMenuItemView;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuView;
import java.util.ArrayList;

public class MenuAdapter
extends BaseAdapter {
    MenuBuilder mAdapterMenu;
    private int mExpandedIndex = -1;
    private boolean mForceShowIcon;
    private final LayoutInflater mInflater;
    private final int mItemLayoutRes;
    private final boolean mOverflowOnly;

    public MenuAdapter(MenuBuilder menuBuilder, LayoutInflater layoutInflater, boolean bl, int n2) {
        this.mOverflowOnly = bl;
        this.mInflater = layoutInflater;
        this.mAdapterMenu = menuBuilder;
        this.mItemLayoutRes = n2;
        this.findExpandedIndex();
    }

    void findExpandedIndex() {
        MenuItemImpl menuItemImpl = this.mAdapterMenu.getExpandedItem();
        if (menuItemImpl != null) {
            ArrayList arrayList = this.mAdapterMenu.getNonActionItems();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if ((MenuItemImpl)arrayList.get(i2) != menuItemImpl) continue;
                this.mExpandedIndex = i2;
                return;
            }
        }
        this.mExpandedIndex = -1;
    }

    public MenuBuilder getAdapterMenu() {
        return this.mAdapterMenu;
    }

    public int getCount() {
        ArrayList arrayList = this.mOverflowOnly ? this.mAdapterMenu.getNonActionItems() : this.mAdapterMenu.getVisibleItems();
        if (this.mExpandedIndex < 0) {
            return arrayList.size();
        }
        return arrayList.size() - 1;
    }

    public boolean getForceShowIcon() {
        return this.mForceShowIcon;
    }

    public MenuItemImpl getItem(int n2) {
        ArrayList arrayList = this.mOverflowOnly ? this.mAdapterMenu.getNonActionItems() : this.mAdapterMenu.getVisibleItems();
        int n3 = this.mExpandedIndex;
        int n4 = n2;
        if (n3 >= 0) {
            n4 = n2;
            if (n2 >= n3) {
                n4 = n2 + 1;
            }
        }
        return (MenuItemImpl)arrayList.get(n4);
    }

    public long getItemId(int n2) {
        return n2;
    }

    public View getView(int n2, View view, ViewGroup viewGroup) {
        View view2 = view;
        if (view == null) {
            view2 = this.mInflater.inflate(this.mItemLayoutRes, viewGroup, false);
        }
        int n3 = this.getItem(n2).getGroupId();
        int n4 = n2 - 1;
        n4 = n4 >= 0 ? this.getItem(n4).getGroupId() : n3;
        viewGroup = (ListMenuItemView)view2;
        boolean bl = this.mAdapterMenu.isGroupDividerEnabled() && n3 != n4;
        viewGroup.setGroupDividerEnabled(bl);
        view = (MenuView.ItemView)view2;
        if (this.mForceShowIcon) {
            viewGroup.setForceShowIcon(true);
        }
        view.initialize(this.getItem(n2), 0);
        return view2;
    }

    public void notifyDataSetChanged() {
        this.findExpandedIndex();
        super.notifyDataSetChanged();
    }

    public void setForceShowIcon(boolean bl) {
        this.mForceShowIcon = bl;
    }
}

