/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.app;

import android.app.Activity;
import android.app.Dialog;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.appcompat.R;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatCallback;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.app.AppCompatDialog;
import androidx.appcompat.app.AppCompatViewInflater;
import androidx.appcompat.app.ResourcesFlusher;
import androidx.appcompat.app.ToolbarActionBar;
import androidx.appcompat.app.TwilightManager;
import androidx.appcompat.app.WindowDecorActionBar;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.view.ActionMode;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.view.StandaloneActionMode;
import androidx.appcompat.view.SupportActionModeWrapper;
import androidx.appcompat.view.SupportMenuInflater;
import androidx.appcompat.view.WindowCallbackWrapper;
import androidx.appcompat.view.menu.ListMenuPresenter;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.widget.ActionBarContextView;
import androidx.appcompat.widget.AppCompatDrawableManager;
import androidx.appcompat.widget.ContentFrameLayout;
import androidx.appcompat.widget.DecorContentParent;
import androidx.appcompat.widget.FitWindowsViewGroup;
import androidx.appcompat.widget.TintTypedArray;
import androidx.appcompat.widget.Toolbar;
import androidx.appcompat.widget.VectorEnabledTintResources;
import androidx.appcompat.widget.ViewStubCompat;
import androidx.appcompat.widget.ViewUtils;
import androidx.collection.SimpleArrayMap;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NavUtils;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.util.ObjectsCompat;
import androidx.core.view.KeyEventDispatcher;
import androidx.core.view.LayoutInflaterCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorCompat;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.core.view.ViewPropertyAnimatorListenerAdapter;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.widget.PopupWindowCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

class AppCompatDelegateImpl
extends AppCompatDelegate
implements MenuBuilder.Callback,
LayoutInflater.Factory2 {
    static final String EXCEPTION_HANDLER_MESSAGE_SUFFIX = ". If the resource you are trying to use is a vector resource, you may be referencing it in an unsupported way. See AppCompatDelegate.setCompatVectorFromResourcesEnabled() for more info.";
    private static final boolean IS_PRE_LOLLIPOP;
    private static final boolean sCanApplyOverrideConfiguration;
    private static final boolean sCanReturnDifferentContext;
    private static boolean sInstalledExceptionHandler;
    private static final SimpleArrayMap<String, Integer> sLocalNightModes;
    private static final int[] sWindowBackgroundStyleable;
    ActionBar mActionBar;
    private ActionMenuPresenterCallback mActionMenuPresenterCallback;
    ActionMode mActionMode;
    PopupWindow mActionModePopup;
    ActionBarContextView mActionModeView;
    private boolean mActivityHandlesUiMode;
    private boolean mActivityHandlesUiModeChecked;
    final AppCompatCallback mAppCompatCallback;
    private AppCompatViewInflater mAppCompatViewInflater;
    private AppCompatWindowCallback mAppCompatWindowCallback;
    private AutoNightModeManager mAutoBatteryNightModeManager;
    private AutoNightModeManager mAutoTimeNightModeManager;
    private boolean mBaseContextAttached;
    private boolean mClosingActionMenu;
    final Context mContext;
    private boolean mCreated;
    private DecorContentParent mDecorContentParent;
    private boolean mEnableDefaultActionBarUp;
    ViewPropertyAnimatorCompat mFadeAnim = null;
    private boolean mFeatureIndeterminateProgress;
    private boolean mFeatureProgress;
    private boolean mHandleNativeActionModes = true;
    boolean mHasActionBar;
    final Object mHost;
    int mInvalidatePanelMenuFeatures;
    boolean mInvalidatePanelMenuPosted;
    private final Runnable mInvalidatePanelMenuRunnable = new Runnable(){

        @Override
        public void run() {
            if ((AppCompatDelegateImpl.this.mInvalidatePanelMenuFeatures & 1) != 0) {
                AppCompatDelegateImpl.this.doInvalidatePanelMenu(0);
            }
            if ((AppCompatDelegateImpl.this.mInvalidatePanelMenuFeatures & 0x1000) != 0) {
                AppCompatDelegateImpl.this.doInvalidatePanelMenu(108);
            }
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            appCompatDelegateImpl.mInvalidatePanelMenuPosted = false;
            appCompatDelegateImpl.mInvalidatePanelMenuFeatures = 0;
        }
    };
    boolean mIsDestroyed;
    boolean mIsFloating;
    private int mLocalNightMode = -100;
    private boolean mLongPressBackDown;
    MenuInflater mMenuInflater;
    boolean mOverlayActionBar;
    boolean mOverlayActionMode;
    private PanelMenuPresenterCallback mPanelMenuPresenterCallback;
    private PanelFeatureState[] mPanels;
    private PanelFeatureState mPreparedPanel;
    Runnable mShowActionModePopup;
    private boolean mStarted;
    private View mStatusGuard;
    ViewGroup mSubDecor;
    private boolean mSubDecorInstalled;
    private Rect mTempRect1;
    private Rect mTempRect2;
    private int mThemeResId;
    private CharSequence mTitle;
    private TextView mTitleView;
    Window mWindow;
    boolean mWindowNoTitle;

    static {
        sLocalNightModes = new SimpleArrayMap();
        int n2 = Build.VERSION.SDK_INT;
        boolean bl = false;
        boolean bl2 = n2 < 21;
        IS_PRE_LOLLIPOP = bl2;
        sWindowBackgroundStyleable = new int[]{16842836};
        sCanReturnDifferentContext = "robolectric".equals(Build.FINGERPRINT) ^ true;
        bl2 = bl;
        if (Build.VERSION.SDK_INT >= 17) {
            bl2 = true;
        }
        sCanApplyOverrideConfiguration = bl2;
        if (IS_PRE_LOLLIPOP && !sInstalledExceptionHandler) {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(Thread.getDefaultUncaughtExceptionHandler()){
                final /* synthetic */ Thread.UncaughtExceptionHandler val$defHandler;
                {
                    this.val$defHandler = uncaughtExceptionHandler;
                }

                private boolean shouldWrapException(Throwable object) {
                    boolean bl;
                    block2: {
                        block3: {
                            boolean bl2;
                            boolean bl3 = object instanceof Resources.NotFoundException;
                            bl = bl2 = false;
                            if (!bl3) break block2;
                            object = ((Throwable)object).getMessage();
                            bl = bl2;
                            if (object == null) break block2;
                            if (((String)object).contains("drawable")) break block3;
                            bl = bl2;
                            if (!((String)object).contains("Drawable")) break block2;
                        }
                        bl = true;
                    }
                    return bl;
                }

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    if (this.shouldWrapException(throwable)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(throwable.getMessage());
                        stringBuilder.append(AppCompatDelegateImpl.EXCEPTION_HANDLER_MESSAGE_SUFFIX);
                        stringBuilder = new Resources.NotFoundException(stringBuilder.toString());
                        ((Throwable)((Object)stringBuilder)).initCause(throwable.getCause());
                        ((Throwable)((Object)stringBuilder)).setStackTrace(throwable.getStackTrace());
                        this.val$defHandler.uncaughtException(thread, (Throwable)((Object)stringBuilder));
                    } else {
                        this.val$defHandler.uncaughtException(thread, throwable);
                    }
                }
            });
            sInstalledExceptionHandler = true;
        }
    }

    AppCompatDelegateImpl(Activity activity, AppCompatCallback appCompatCallback) {
        this((Context)activity, null, appCompatCallback, activity);
    }

    AppCompatDelegateImpl(Dialog dialog, AppCompatCallback appCompatCallback) {
        this(dialog.getContext(), dialog.getWindow(), appCompatCallback, dialog);
    }

    AppCompatDelegateImpl(Context context, Activity activity, AppCompatCallback appCompatCallback) {
        this(context, null, appCompatCallback, activity);
    }

    AppCompatDelegateImpl(Context context, Window window, AppCompatCallback appCompatCallback) {
        this(context, window, appCompatCallback, context);
    }

    private AppCompatDelegateImpl(Context object, Window window, AppCompatCallback appCompatCallback, Object object2) {
        this.mContext = object;
        this.mAppCompatCallback = appCompatCallback;
        this.mHost = object2;
        if (this.mLocalNightMode == -100 && this.mHost instanceof Dialog && (object = this.tryUnwrapContext()) != null) {
            this.mLocalNightMode = object.getDelegate().getLocalNightMode();
        }
        if (this.mLocalNightMode == -100 && (object = (Integer)sLocalNightModes.get((Object)this.mHost.getClass().getName())) != null) {
            this.mLocalNightMode = (Integer)object;
            sLocalNightModes.remove((Object)this.mHost.getClass().getName());
        }
        if (window != null) {
            this.attachToWindow(window);
        }
        AppCompatDrawableManager.preload();
    }

    private boolean applyDayNight(boolean bl) {
        AutoNightModeManager autoNightModeManager;
        if (this.mIsDestroyed) {
            return false;
        }
        int n2 = this.calculateNightMode();
        bl = this.updateForNightMode(this.mapNightMode(this.mContext, n2), bl);
        if (n2 == 0) {
            this.getAutoTimeNightModeManager(this.mContext).setup();
        } else {
            autoNightModeManager = this.mAutoTimeNightModeManager;
            if (autoNightModeManager != null) {
                autoNightModeManager.cleanup();
            }
        }
        if (n2 == 3) {
            this.getAutoBatteryNightModeManager(this.mContext).setup();
        } else {
            autoNightModeManager = this.mAutoBatteryNightModeManager;
            if (autoNightModeManager != null) {
                autoNightModeManager.cleanup();
            }
        }
        return bl;
    }

    private void applyFixedSizeWindow() {
        ContentFrameLayout contentFrameLayout = (ContentFrameLayout)this.mSubDecor.findViewById(0x1020002);
        View view = this.mWindow.getDecorView();
        contentFrameLayout.setDecorPadding(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
        view = this.mContext.obtainStyledAttributes(R.styleable.AppCompatTheme);
        view.getValue(R.styleable.AppCompatTheme_windowMinWidthMajor, contentFrameLayout.getMinWidthMajor());
        view.getValue(R.styleable.AppCompatTheme_windowMinWidthMinor, contentFrameLayout.getMinWidthMinor());
        if (view.hasValue(R.styleable.AppCompatTheme_windowFixedWidthMajor)) {
            view.getValue(R.styleable.AppCompatTheme_windowFixedWidthMajor, contentFrameLayout.getFixedWidthMajor());
        }
        if (view.hasValue(R.styleable.AppCompatTheme_windowFixedWidthMinor)) {
            view.getValue(R.styleable.AppCompatTheme_windowFixedWidthMinor, contentFrameLayout.getFixedWidthMinor());
        }
        if (view.hasValue(R.styleable.AppCompatTheme_windowFixedHeightMajor)) {
            view.getValue(R.styleable.AppCompatTheme_windowFixedHeightMajor, contentFrameLayout.getFixedHeightMajor());
        }
        if (view.hasValue(R.styleable.AppCompatTheme_windowFixedHeightMinor)) {
            view.getValue(R.styleable.AppCompatTheme_windowFixedHeightMinor, contentFrameLayout.getFixedHeightMinor());
        }
        view.recycle();
        contentFrameLayout.requestLayout();
    }

    private void attachToWindow(Window window) {
        if (this.mWindow == null) {
            Window.Callback callback2 = window.getCallback();
            if (!(callback2 instanceof AppCompatWindowCallback)) {
                this.mAppCompatWindowCallback = new AppCompatWindowCallback(callback2);
                window.setCallback((Window.Callback)this.mAppCompatWindowCallback);
                callback2 = TintTypedArray.obtainStyledAttributes((Context)this.mContext, null, (int[])sWindowBackgroundStyleable);
                Drawable drawable2 = callback2.getDrawableIfKnown(0);
                if (drawable2 != null) {
                    window.setBackgroundDrawable(drawable2);
                }
                callback2.recycle();
                this.mWindow = window;
                return;
            }
            throw new IllegalStateException("AppCompat has already installed itself into the Window");
        }
        throw new IllegalStateException("AppCompat has already installed itself into the Window");
    }

    private int calculateNightMode() {
        int n2 = this.mLocalNightMode;
        if (n2 == -100) {
            n2 = AppCompatDelegateImpl.getDefaultNightMode();
        }
        return n2;
    }

    private void cleanupAutoManagers() {
        AutoNightModeManager autoNightModeManager = this.mAutoTimeNightModeManager;
        if (autoNightModeManager != null) {
            autoNightModeManager.cleanup();
        }
        if ((autoNightModeManager = this.mAutoBatteryNightModeManager) != null) {
            autoNightModeManager.cleanup();
        }
    }

    private Configuration createOverrideConfigurationForDayNight(Context context, int n2, Configuration configuration) {
        n2 = n2 != 1 ? (n2 != 2 ? context.getApplicationContext().getResources().getConfiguration().uiMode & 0x30 : 32) : 16;
        context = new Configuration();
        context.fontScale = 0.0f;
        if (configuration != null) {
            context.setTo(configuration);
        }
        context.uiMode = n2 | context.uiMode & 0xFFFFFFCF;
        return context;
    }

    private ViewGroup createSubDecor() {
        Object object = this.mContext.obtainStyledAttributes(R.styleable.AppCompatTheme);
        if (object.hasValue(R.styleable.AppCompatTheme_windowActionBar)) {
            ViewGroup viewGroup;
            if (object.getBoolean(R.styleable.AppCompatTheme_windowNoTitle, false)) {
                this.requestWindowFeature(1);
            } else if (object.getBoolean(R.styleable.AppCompatTheme_windowActionBar, false)) {
                this.requestWindowFeature(108);
            }
            if (object.getBoolean(R.styleable.AppCompatTheme_windowActionBarOverlay, false)) {
                this.requestWindowFeature(109);
            }
            if (object.getBoolean(R.styleable.AppCompatTheme_windowActionModeOverlay, false)) {
                this.requestWindowFeature(10);
            }
            this.mIsFloating = object.getBoolean(R.styleable.AppCompatTheme_android_windowIsFloating, false);
            object.recycle();
            this.ensureWindow();
            this.mWindow.getDecorView();
            object = LayoutInflater.from((Context)this.mContext);
            if (!this.mWindowNoTitle) {
                if (this.mIsFloating) {
                    object = (ViewGroup)object.inflate(R.layout.abc_dialog_title_material, null);
                    this.mOverlayActionBar = false;
                    this.mHasActionBar = false;
                } else if (this.mHasActionBar) {
                    object = new TypedValue();
                    this.mContext.getTheme().resolveAttribute(R.attr.actionBarTheme, (TypedValue)object, true);
                    object = ((TypedValue)object).resourceId != 0 ? new ContextThemeWrapper(this.mContext, ((TypedValue)object).resourceId) : this.mContext;
                    viewGroup = (ViewGroup)LayoutInflater.from((Context)object).inflate(R.layout.abc_screen_toolbar, null);
                    this.mDecorContentParent = (DecorContentParent)viewGroup.findViewById(R.id.decor_content_parent);
                    this.mDecorContentParent.setWindowCallback(this.getWindowCallback());
                    if (this.mOverlayActionBar) {
                        this.mDecorContentParent.initFeature(109);
                    }
                    if (this.mFeatureProgress) {
                        this.mDecorContentParent.initFeature(2);
                    }
                    object = viewGroup;
                    if (this.mFeatureIndeterminateProgress) {
                        this.mDecorContentParent.initFeature(5);
                        object = viewGroup;
                    }
                } else {
                    object = null;
                }
            } else {
                object = this.mOverlayActionMode ? (ViewGroup)object.inflate(R.layout.abc_screen_simple_overlay_action_mode, null) : (ViewGroup)object.inflate(R.layout.abc_screen_simple, null);
            }
            if (object != null) {
                if (Build.VERSION.SDK_INT >= 21) {
                    ViewCompat.setOnApplyWindowInsetsListener((View)object, new OnApplyWindowInsetsListener(){

                        public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
                            int n2 = windowInsetsCompat.getSystemWindowInsetTop();
                            int n3 = AppCompatDelegateImpl.this.updateStatusGuard(windowInsetsCompat, null);
                            WindowInsetsCompat windowInsetsCompat2 = windowInsetsCompat;
                            if (n2 != n3) {
                                windowInsetsCompat2 = windowInsetsCompat.replaceSystemWindowInsets(windowInsetsCompat.getSystemWindowInsetLeft(), n3, windowInsetsCompat.getSystemWindowInsetRight(), windowInsetsCompat.getSystemWindowInsetBottom());
                            }
                            return ViewCompat.onApplyWindowInsets(view, windowInsetsCompat2);
                        }
                    });
                } else if (object instanceof FitWindowsViewGroup) {
                    ((FitWindowsViewGroup)object).setOnFitSystemWindowsListener(new FitWindowsViewGroup.OnFitSystemWindowsListener(){

                        public void onFitSystemWindows(Rect rect) {
                            rect.top = AppCompatDelegateImpl.this.updateStatusGuard(null, rect);
                        }
                    });
                }
                if (this.mDecorContentParent == null) {
                    this.mTitleView = (TextView)object.findViewById(R.id.title);
                }
                ViewUtils.makeOptionalFitsSystemWindows((View)object);
                ContentFrameLayout contentFrameLayout = (ContentFrameLayout)object.findViewById(R.id.action_bar_activity_content);
                viewGroup = (ViewGroup)this.mWindow.findViewById(0x1020002);
                if (viewGroup != null) {
                    while (viewGroup.getChildCount() > 0) {
                        View view = viewGroup.getChildAt(0);
                        viewGroup.removeViewAt(0);
                        contentFrameLayout.addView(view);
                    }
                    viewGroup.setId(-1);
                    contentFrameLayout.setId(0x1020002);
                    if (viewGroup instanceof FrameLayout) {
                        ((FrameLayout)viewGroup).setForeground(null);
                    }
                }
                this.mWindow.setContentView((View)object);
                contentFrameLayout.setAttachListener(new ContentFrameLayout.OnAttachListener(){

                    public void onAttachedFromWindow() {
                    }

                    public void onDetachedFromWindow() {
                        AppCompatDelegateImpl.this.dismissPopups();
                    }
                });
                return object;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("AppCompat does not support the current theme features: { windowActionBar: ");
            ((StringBuilder)object).append(this.mHasActionBar);
            ((StringBuilder)object).append(", windowActionBarOverlay: ");
            ((StringBuilder)object).append(this.mOverlayActionBar);
            ((StringBuilder)object).append(", android:windowIsFloating: ");
            ((StringBuilder)object).append(this.mIsFloating);
            ((StringBuilder)object).append(", windowActionModeOverlay: ");
            ((StringBuilder)object).append(this.mOverlayActionMode);
            ((StringBuilder)object).append(", windowNoTitle: ");
            ((StringBuilder)object).append(this.mWindowNoTitle);
            ((StringBuilder)object).append(" }");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        object.recycle();
        object = new IllegalStateException("You need to use a Theme.AppCompat theme (or descendant) with this activity.");
        throw object;
    }

    private void ensureSubDecor() {
        if (!this.mSubDecorInstalled) {
            this.mSubDecor = this.createSubDecor();
            Object object = this.getTitle();
            if (!TextUtils.isEmpty((CharSequence)object)) {
                DecorContentParent decorContentParent = this.mDecorContentParent;
                if (decorContentParent != null) {
                    decorContentParent.setWindowTitle((CharSequence)object);
                } else if (this.peekSupportActionBar() != null) {
                    this.peekSupportActionBar().setWindowTitle((CharSequence)object);
                } else {
                    decorContentParent = this.mTitleView;
                    if (decorContentParent != null) {
                        decorContentParent.setText((CharSequence)object);
                    }
                }
            }
            this.applyFixedSizeWindow();
            this.onSubDecorInstalled(this.mSubDecor);
            this.mSubDecorInstalled = true;
            object = this.getPanelState(0, false);
            if (!(this.mIsDestroyed || object != null && ((PanelFeatureState)object).menu != null)) {
                this.invalidatePanelMenu(108);
            }
        }
    }

    private void ensureWindow() {
        Object object;
        if (this.mWindow == null && (object = this.mHost) instanceof Activity) {
            this.attachToWindow(((Activity)object).getWindow());
        }
        if (this.mWindow != null) {
            return;
        }
        throw new IllegalStateException("We have not been given a Window");
    }

    private static Configuration generateConfigDelta(Configuration configuration, Configuration configuration2) {
        Configuration configuration3 = new Configuration();
        configuration3.fontScale = 0.0f;
        if (configuration2 != null && configuration.diff(configuration2) != 0) {
            if (configuration.fontScale != configuration2.fontScale) {
                configuration3.fontScale = configuration2.fontScale;
            }
            if (configuration.mcc != configuration2.mcc) {
                configuration3.mcc = configuration2.mcc;
            }
            if (configuration.mnc != configuration2.mnc) {
                configuration3.mnc = configuration2.mnc;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                ConfigurationImplApi24.generateConfigDelta_locale(configuration, configuration2, configuration3);
            } else if (!ObjectsCompat.equals((Object)configuration.locale, (Object)configuration2.locale)) {
                configuration3.locale = configuration2.locale;
            }
            if (configuration.touchscreen != configuration2.touchscreen) {
                configuration3.touchscreen = configuration2.touchscreen;
            }
            if (configuration.keyboard != configuration2.keyboard) {
                configuration3.keyboard = configuration2.keyboard;
            }
            if (configuration.keyboardHidden != configuration2.keyboardHidden) {
                configuration3.keyboardHidden = configuration2.keyboardHidden;
            }
            if (configuration.navigation != configuration2.navigation) {
                configuration3.navigation = configuration2.navigation;
            }
            if (configuration.navigationHidden != configuration2.navigationHidden) {
                configuration3.navigationHidden = configuration2.navigationHidden;
            }
            if (configuration.orientation != configuration2.orientation) {
                configuration3.orientation = configuration2.orientation;
            }
            if ((configuration.screenLayout & 0xF) != (configuration2.screenLayout & 0xF)) {
                configuration3.screenLayout |= configuration2.screenLayout & 0xF;
            }
            if ((configuration.screenLayout & 0xC0) != (configuration2.screenLayout & 0xC0)) {
                configuration3.screenLayout |= configuration2.screenLayout & 0xC0;
            }
            if ((configuration.screenLayout & 0x30) != (configuration2.screenLayout & 0x30)) {
                configuration3.screenLayout |= configuration2.screenLayout & 0x30;
            }
            if ((configuration.screenLayout & 0x300) != (configuration2.screenLayout & 0x300)) {
                configuration3.screenLayout |= configuration2.screenLayout & 0x300;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                ConfigurationImplApi26.generateConfigDelta_colorMode(configuration, configuration2, configuration3);
            }
            if ((configuration.uiMode & 0xF) != (configuration2.uiMode & 0xF)) {
                configuration3.uiMode |= configuration2.uiMode & 0xF;
            }
            if ((configuration.uiMode & 0x30) != (configuration2.uiMode & 0x30)) {
                configuration3.uiMode |= configuration2.uiMode & 0x30;
            }
            if (configuration.screenWidthDp != configuration2.screenWidthDp) {
                configuration3.screenWidthDp = configuration2.screenWidthDp;
            }
            if (configuration.screenHeightDp != configuration2.screenHeightDp) {
                configuration3.screenHeightDp = configuration2.screenHeightDp;
            }
            if (configuration.smallestScreenWidthDp != configuration2.smallestScreenWidthDp) {
                configuration3.smallestScreenWidthDp = configuration2.smallestScreenWidthDp;
            }
            if (Build.VERSION.SDK_INT >= 17) {
                ConfigurationImplApi17.generateConfigDelta_densityDpi(configuration, configuration2, configuration3);
            }
        }
        return configuration3;
    }

    private AutoNightModeManager getAutoBatteryNightModeManager(Context context) {
        if (this.mAutoBatteryNightModeManager == null) {
            this.mAutoBatteryNightModeManager = new AutoBatteryNightModeManager(context);
        }
        return this.mAutoBatteryNightModeManager;
    }

    private AutoNightModeManager getAutoTimeNightModeManager(Context context) {
        if (this.mAutoTimeNightModeManager == null) {
            this.mAutoTimeNightModeManager = new AutoTimeNightModeManager(TwilightManager.getInstance((Context)context));
        }
        return this.mAutoTimeNightModeManager;
    }

    private void initWindowDecorActionBar() {
        this.ensureSubDecor();
        if (this.mHasActionBar && this.mActionBar == null) {
            Object object = this.mHost;
            if (object instanceof Activity) {
                this.mActionBar = new WindowDecorActionBar((Activity)object, this.mOverlayActionBar);
            } else if (object instanceof Dialog) {
                this.mActionBar = new WindowDecorActionBar((Dialog)object);
            }
            object = this.mActionBar;
            if (object != null) {
                ((ActionBar)object).setDefaultDisplayHomeAsUpEnabled(this.mEnableDefaultActionBarUp);
            }
        }
    }

    private boolean initializePanelContent(PanelFeatureState panelFeatureState) {
        View view = panelFeatureState.createdPanelView;
        boolean bl = true;
        if (view != null) {
            panelFeatureState.shownPanelView = panelFeatureState.createdPanelView;
            return true;
        }
        if (panelFeatureState.menu == null) {
            return false;
        }
        if (this.mPanelMenuPresenterCallback == null) {
            this.mPanelMenuPresenterCallback = new PanelMenuPresenterCallback();
        }
        panelFeatureState.shownPanelView = (View)panelFeatureState.getListMenuView(this.mPanelMenuPresenterCallback);
        if (panelFeatureState.shownPanelView == null) {
            bl = false;
        }
        return bl;
    }

    private boolean initializePanelDecor(PanelFeatureState panelFeatureState) {
        panelFeatureState.setStyle(this.getActionBarThemedContext());
        panelFeatureState.decorView = new ListMenuDecorView(panelFeatureState.listPresenterContext);
        panelFeatureState.gravity = 81;
        return true;
    }

    private boolean initializePanelMenu(PanelFeatureState panelFeatureState) {
        Context context;
        block10: {
            Context context2;
            block9: {
                context2 = this.mContext;
                if (panelFeatureState.featureId == 0) break block9;
                context = context2;
                if (panelFeatureState.featureId != 108) break block10;
            }
            context = context2;
            if (this.mDecorContentParent != null) {
                TypedValue typedValue = new TypedValue();
                Resources.Theme theme = context2.getTheme();
                theme.resolveAttribute(R.attr.actionBarTheme, typedValue, true);
                context = null;
                if (typedValue.resourceId != 0) {
                    context = context2.getResources().newTheme();
                    context.setTo(theme);
                    context.applyStyle(typedValue.resourceId, true);
                    context.resolveAttribute(R.attr.actionBarWidgetTheme, typedValue, true);
                } else {
                    theme.resolveAttribute(R.attr.actionBarWidgetTheme, typedValue, true);
                }
                Context context3 = context;
                if (typedValue.resourceId != 0) {
                    context3 = context;
                    if (context == null) {
                        context3 = context2.getResources().newTheme();
                        context3.setTo(theme);
                    }
                    context3.applyStyle(typedValue.resourceId, true);
                }
                context = context2;
                if (context3 != null) {
                    context = new ContextThemeWrapper(context2, 0);
                    context.getTheme().setTo((Resources.Theme)context3);
                }
            }
        }
        context = new MenuBuilder(context);
        context.setCallback((MenuBuilder.Callback)this);
        panelFeatureState.setMenu((MenuBuilder)context);
        return true;
    }

    private void invalidatePanelMenu(int n2) {
        this.mInvalidatePanelMenuFeatures = 1 << n2 | this.mInvalidatePanelMenuFeatures;
        if (!this.mInvalidatePanelMenuPosted) {
            ViewCompat.postOnAnimation(this.mWindow.getDecorView(), this.mInvalidatePanelMenuRunnable);
            this.mInvalidatePanelMenuPosted = true;
        }
    }

    private boolean isActivityManifestHandlingUiMode() {
        if (!this.mActivityHandlesUiModeChecked && this.mHost instanceof Activity) {
            boolean bl;
            block11: {
                block10: {
                    int n2;
                    PackageManager packageManager;
                    block9: {
                        block8: {
                            packageManager = this.mContext.getPackageManager();
                            if (packageManager == null) {
                                return false;
                            }
                            if (Build.VERSION.SDK_INT < 29) break block8;
                            n2 = 0x100C0000;
                            break block9;
                        }
                        n2 = Build.VERSION.SDK_INT >= 24 ? 786432 : 0;
                    }
                    ComponentName componentName = new ComponentName(this.mContext, this.mHost.getClass());
                    packageManager = packageManager.getActivityInfo(componentName, n2);
                    if (packageManager == null) break block10;
                    if ((packageManager.configChanges & 0x200) == 0) break block10;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            try {
                this.mActivityHandlesUiMode = bl;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.d((String)"AppCompatDelegate", (String)"Exception while getting ActivityInfo", (Throwable)nameNotFoundException);
                this.mActivityHandlesUiMode = false;
            }
        }
        this.mActivityHandlesUiModeChecked = true;
        return this.mActivityHandlesUiMode;
    }

    private boolean onKeyDownPanel(int n2, KeyEvent keyEvent) {
        if (keyEvent.getRepeatCount() == 0) {
            PanelFeatureState panelFeatureState = this.getPanelState(n2, true);
            if (!panelFeatureState.isOpen) {
                return this.preparePanel(panelFeatureState, keyEvent);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean onKeyUpPanel(int n2, KeyEvent keyEvent) {
        boolean bl;
        DecorContentParent decorContentParent;
        if (this.mActionMode != null) {
            return false;
        }
        PanelFeatureState panelFeatureState = this.getPanelState(n2, true);
        if (n2 == 0 && (decorContentParent = this.mDecorContentParent) != null && decorContentParent.canShowOverflowMenu() && !ViewConfiguration.get((Context)this.mContext).hasPermanentMenuKey()) {
            if (!this.mDecorContentParent.isOverflowMenuShowing()) {
                if (this.mIsDestroyed) return false;
                if (!this.preparePanel(panelFeatureState, keyEvent)) return false;
                bl = this.mDecorContentParent.showOverflowMenu();
            } else {
                bl = this.mDecorContentParent.hideOverflowMenu();
            }
        } else if (!panelFeatureState.isOpen && !panelFeatureState.isHandled) {
            if (!panelFeatureState.isPrepared) return false;
            if (panelFeatureState.refreshMenuContent) {
                panelFeatureState.isPrepared = false;
                bl = this.preparePanel(panelFeatureState, keyEvent);
            } else {
                bl = true;
            }
            if (!bl) return false;
            this.openPanel(panelFeatureState, keyEvent);
            bl = true;
        } else {
            bl = panelFeatureState.isOpen;
            this.closePanel(panelFeatureState, true);
        }
        if (!bl) return bl;
        keyEvent = (AudioManager)this.mContext.getApplicationContext().getSystemService("audio");
        if (keyEvent != null) {
            keyEvent.playSoundEffect(0);
            return bl;
        } else {
            Log.w((String)"AppCompatDelegate", (String)"Couldn't get audio manager");
        }
        return bl;
    }

    private void openPanel(PanelFeatureState panelFeatureState, KeyEvent keyEvent) {
        block15: {
            block19: {
                WindowManager windowManager;
                int n2;
                block18: {
                    block17: {
                        Window.Callback callback2;
                        block16: {
                            if (panelFeatureState.isOpen || this.mIsDestroyed) break block15;
                            if (panelFeatureState.featureId == 0 && (n2 = (this.mContext.getResources().getConfiguration().screenLayout & 0xF) == 4 ? 1 : 0) != 0) {
                                return;
                            }
                            callback2 = this.getWindowCallback();
                            if (callback2 != null && !callback2.onMenuOpened(panelFeatureState.featureId, (Menu)panelFeatureState.menu)) {
                                this.closePanel(panelFeatureState, true);
                                return;
                            }
                            windowManager = (WindowManager)this.mContext.getSystemService("window");
                            if (windowManager == null) {
                                return;
                            }
                            if (!this.preparePanel(panelFeatureState, keyEvent)) {
                                return;
                            }
                            if (panelFeatureState.decorView == null || panelFeatureState.refreshDecorView) break block16;
                            if (panelFeatureState.createdPanelView == null || (keyEvent = panelFeatureState.createdPanelView.getLayoutParams()) == null || keyEvent.width != -1) break block17;
                            n2 = -1;
                            break block18;
                        }
                        if (panelFeatureState.decorView == null) {
                            if (!this.initializePanelDecor(panelFeatureState) || panelFeatureState.decorView == null) {
                                return;
                            }
                        } else if (panelFeatureState.refreshDecorView && panelFeatureState.decorView.getChildCount() > 0) {
                            panelFeatureState.decorView.removeAllViews();
                        }
                        if (!this.initializePanelContent(panelFeatureState) || !panelFeatureState.hasPanelItems()) break block19;
                        callback2 = panelFeatureState.shownPanelView.getLayoutParams();
                        keyEvent = callback2;
                        if (callback2 == null) {
                            keyEvent = new ViewGroup.LayoutParams(-2, -2);
                        }
                        n2 = panelFeatureState.background;
                        panelFeatureState.decorView.setBackgroundResource(n2);
                        callback2 = panelFeatureState.shownPanelView.getParent();
                        if (callback2 instanceof ViewGroup) {
                            ((ViewGroup)callback2).removeView(panelFeatureState.shownPanelView);
                        }
                        panelFeatureState.decorView.addView(panelFeatureState.shownPanelView, (ViewGroup.LayoutParams)keyEvent);
                        if (!panelFeatureState.shownPanelView.hasFocus()) {
                            panelFeatureState.shownPanelView.requestFocus();
                        }
                    }
                    n2 = -2;
                }
                panelFeatureState.isHandled = false;
                keyEvent = new WindowManager.LayoutParams(n2, -2, panelFeatureState.x, panelFeatureState.y, 1002, 0x820000, -3);
                keyEvent.gravity = panelFeatureState.gravity;
                keyEvent.windowAnimations = panelFeatureState.windowAnimations;
                windowManager.addView((View)panelFeatureState.decorView, (ViewGroup.LayoutParams)keyEvent);
                panelFeatureState.isOpen = true;
                return;
            }
            panelFeatureState.refreshDecorView = true;
        }
    }

    private boolean performPanelShortcut(PanelFeatureState panelFeatureState, int n2, KeyEvent keyEvent, int n3) {
        boolean bl;
        block7: {
            boolean bl2;
            block6: {
                bl = keyEvent.isSystem();
                bl2 = false;
                if (bl) {
                    return false;
                }
                if (panelFeatureState.isPrepared) break block6;
                bl = bl2;
                if (!this.preparePanel(panelFeatureState, keyEvent)) break block7;
            }
            bl = bl2;
            if (panelFeatureState.menu != null) {
                bl = panelFeatureState.menu.performShortcut(n2, keyEvent, n3);
            }
        }
        if (bl && (n3 & 1) == 0 && this.mDecorContentParent == null) {
            this.closePanel(panelFeatureState, true);
        }
        return bl;
    }

    private boolean preparePanel(PanelFeatureState panelFeatureState, KeyEvent keyEvent) {
        DecorContentParent decorContentParent;
        if (this.mIsDestroyed) {
            return false;
        }
        if (panelFeatureState.isPrepared) {
            return true;
        }
        PanelFeatureState panelFeatureState2 = this.mPreparedPanel;
        if (panelFeatureState2 != null && panelFeatureState2 != panelFeatureState) {
            this.closePanel(panelFeatureState2, false);
        }
        if ((panelFeatureState2 = this.getWindowCallback()) != null) {
            panelFeatureState.createdPanelView = panelFeatureState2.onCreatePanelView(panelFeatureState.featureId);
        }
        int n2 = panelFeatureState.featureId != 0 && panelFeatureState.featureId != 108 ? 0 : 1;
        if (n2 != 0 && (decorContentParent = this.mDecorContentParent) != null) {
            decorContentParent.setMenuPrepared();
        }
        if (!(panelFeatureState.createdPanelView != null || n2 != 0 && this.peekSupportActionBar() instanceof ToolbarActionBar)) {
            if (panelFeatureState.menu == null || panelFeatureState.refreshMenuContent) {
                if (!(panelFeatureState.menu != null || this.initializePanelMenu(panelFeatureState) && panelFeatureState.menu != null)) {
                    return false;
                }
                if (n2 != 0 && this.mDecorContentParent != null) {
                    if (this.mActionMenuPresenterCallback == null) {
                        this.mActionMenuPresenterCallback = new ActionMenuPresenterCallback();
                    }
                    this.mDecorContentParent.setMenu((Menu)panelFeatureState.menu, (MenuPresenter.Callback)this.mActionMenuPresenterCallback);
                }
                panelFeatureState.menu.stopDispatchingItemsChanged();
                if (!panelFeatureState2.onCreatePanelMenu(panelFeatureState.featureId, (Menu)panelFeatureState.menu)) {
                    panelFeatureState.setMenu(null);
                    if (n2 != 0 && (panelFeatureState = this.mDecorContentParent) != null) {
                        panelFeatureState.setMenu(null, this.mActionMenuPresenterCallback);
                    }
                    return false;
                }
                panelFeatureState.refreshMenuContent = false;
            }
            panelFeatureState.menu.stopDispatchingItemsChanged();
            if (panelFeatureState.frozenActionViewState != null) {
                panelFeatureState.menu.restoreActionViewStates(panelFeatureState.frozenActionViewState);
                panelFeatureState.frozenActionViewState = null;
            }
            if (!panelFeatureState2.onPreparePanel(0, panelFeatureState.createdPanelView, (Menu)panelFeatureState.menu)) {
                if (n2 != 0 && (keyEvent = this.mDecorContentParent) != null) {
                    keyEvent.setMenu(null, (MenuPresenter.Callback)this.mActionMenuPresenterCallback);
                }
                panelFeatureState.menu.startDispatchingItemsChanged();
                return false;
            }
            n2 = keyEvent != null ? keyEvent.getDeviceId() : -1;
            boolean bl = KeyCharacterMap.load((int)n2).getKeyboardType() != 1;
            panelFeatureState.qwertyMode = bl;
            panelFeatureState.menu.setQwertyMode(panelFeatureState.qwertyMode);
            panelFeatureState.menu.startDispatchingItemsChanged();
        }
        panelFeatureState.isPrepared = true;
        panelFeatureState.isHandled = false;
        this.mPreparedPanel = panelFeatureState;
        return true;
    }

    private void reopenMenu(boolean bl) {
        Object object = this.mDecorContentParent;
        if (object != null && object.canShowOverflowMenu() && (!ViewConfiguration.get((Context)this.mContext).hasPermanentMenuKey() || this.mDecorContentParent.isOverflowMenuShowPending())) {
            object = this.getWindowCallback();
            if (this.mDecorContentParent.isOverflowMenuShowing() && bl) {
                this.mDecorContentParent.hideOverflowMenu();
                if (!this.mIsDestroyed) {
                    object.onPanelClosed(108, (Menu)this.getPanelState((int)0, (boolean)true).menu);
                }
            } else if (object != null && !this.mIsDestroyed) {
                if (this.mInvalidatePanelMenuPosted && (this.mInvalidatePanelMenuFeatures & 1) != 0) {
                    this.mWindow.getDecorView().removeCallbacks(this.mInvalidatePanelMenuRunnable);
                    this.mInvalidatePanelMenuRunnable.run();
                }
                PanelFeatureState panelFeatureState = this.getPanelState(0, true);
                if (panelFeatureState.menu != null && !panelFeatureState.refreshMenuContent && object.onPreparePanel(0, panelFeatureState.createdPanelView, (Menu)panelFeatureState.menu)) {
                    object.onMenuOpened(108, (Menu)panelFeatureState.menu);
                    this.mDecorContentParent.showOverflowMenu();
                }
            }
            return;
        }
        object = this.getPanelState(0, true);
        object.refreshDecorView = true;
        this.closePanel((PanelFeatureState)object, false);
        this.openPanel((PanelFeatureState)object, null);
    }

    private int sanitizeWindowFeatureId(int n2) {
        if (n2 == 8) {
            Log.i((String)"AppCompatDelegate", (String)"You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR id when requesting this feature.");
            return 108;
        }
        int n3 = n2;
        if (n2 == 9) {
            Log.i((String)"AppCompatDelegate", (String)"You should now use the AppCompatDelegate.FEATURE_SUPPORT_ACTION_BAR_OVERLAY id when requesting this feature.");
            n3 = 109;
        }
        return n3;
    }

    private boolean shouldInheritContext(ViewParent viewParent) {
        if (viewParent == null) {
            return false;
        }
        View view = this.mWindow.getDecorView();
        while (true) {
            if (viewParent == null) {
                return true;
            }
            if (viewParent == view || !(viewParent instanceof View) || ViewCompat.isAttachedToWindow((View)viewParent)) break;
            viewParent = viewParent.getParent();
        }
        return false;
    }

    private void throwFeatureRequestIfSubDecorInstalled() {
        if (!this.mSubDecorInstalled) {
            return;
        }
        throw new AndroidRuntimeException("Window feature must be requested before adding content");
    }

    private AppCompatActivity tryUnwrapContext() {
        Context context = this.mContext;
        while (context != null) {
            if (context instanceof AppCompatActivity) {
                return (AppCompatActivity)context;
            }
            if (!(context instanceof ContextWrapper)) break;
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    private boolean updateForNightMode(int n2, boolean bl) {
        Object object = this.createOverrideConfigurationForDayNight(this.mContext, n2, null);
        boolean bl2 = this.isActivityManifestHandlingUiMode();
        int n3 = this.mContext.getResources().getConfiguration().uiMode & 0x30;
        int n4 = object.uiMode & 0x30;
        if (n3 != n4 && bl && !bl2 && this.mBaseContextAttached && (sCanReturnDifferentContext || this.mCreated) && (object = this.mHost) instanceof Activity && !((Activity)object).isChild()) {
            ActivityCompat.recreate((Activity)((Activity)this.mHost));
            bl = true;
        } else {
            bl = false;
        }
        boolean bl3 = bl;
        if (!bl) {
            bl3 = bl;
            if (n3 != n4) {
                this.updateResourcesConfigurationForNightMode(n4, bl2, null);
                bl3 = true;
            }
        }
        if (bl3 && (object = this.mHost) instanceof AppCompatActivity) {
            ((AppCompatActivity)object).onNightModeChanged(n2);
        }
        return bl3;
    }

    private void updateResourcesConfigurationForNightMode(int n2, boolean bl, Configuration object) {
        Resources resources = this.mContext.getResources();
        Configuration configuration = new Configuration(resources.getConfiguration());
        if (object != null) {
            configuration.updateFrom(object);
        }
        configuration.uiMode = n2 | resources.getConfiguration().uiMode & 0xFFFFFFCF;
        resources.updateConfiguration(configuration, null);
        if (Build.VERSION.SDK_INT < 26) {
            ResourcesFlusher.flush((Resources)resources);
        }
        if ((n2 = this.mThemeResId) != 0) {
            this.mContext.setTheme(n2);
            if (Build.VERSION.SDK_INT >= 23) {
                this.mContext.getTheme().applyStyle(this.mThemeResId, true);
            }
        }
        if (bl && (object = this.mHost) instanceof Activity) {
            if ((object = (Activity)object) instanceof LifecycleOwner) {
                if (((LifecycleOwner)object).getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
                    object.onConfigurationChanged(configuration);
                }
            } else if (this.mStarted) {
                object.onConfigurationChanged(configuration);
            }
        }
    }

    private void updateStatusGuardColor(View view) {
        int n2 = (ViewCompat.getWindowSystemUiVisibility(view) & 0x2000) != 0 ? 1 : 0;
        n2 = n2 != 0 ? ContextCompat.getColor((Context)this.mContext, (int)R.color.abc_decor_view_status_guard_light) : ContextCompat.getColor((Context)this.mContext, (int)R.color.abc_decor_view_status_guard);
        view.setBackgroundColor(n2);
    }

    @Override
    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.ensureSubDecor();
        ((ViewGroup)this.mSubDecor.findViewById(0x1020002)).addView(view, layoutParams);
        this.mAppCompatWindowCallback.getWrapped().onContentChanged();
    }

    @Override
    public boolean applyDayNight() {
        return this.applyDayNight(true);
    }

    @Override
    public Context attachBaseContext2(Context context) {
        Configuration configuration;
        this.mBaseContextAttached = true;
        int n2 = this.mapNightMode(context, this.calculateNightMode());
        boolean bl = sCanApplyOverrideConfiguration;
        Configuration configuration2 = null;
        if (bl && context instanceof android.view.ContextThemeWrapper) {
            Configuration configuration3 = this.createOverrideConfigurationForDayNight(context, n2, null);
            try {
                ContextThemeWrapperCompatApi17Impl.applyOverrideConfiguration((android.view.ContextThemeWrapper)context, configuration3);
                return context;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (context instanceof ContextThemeWrapper) {
            Configuration configuration4 = this.createOverrideConfigurationForDayNight(context, n2, null);
            try {
                ((ContextThemeWrapper)context).applyOverrideConfiguration(configuration4);
                return context;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (!sCanReturnDifferentContext) {
            return super.attachBaseContext2(context);
        }
        try {
            configuration = context.getPackageManager().getResourcesForApplication(context.getApplicationInfo()).getConfiguration();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new RuntimeException("Application failed to obtain resources from itself", nameNotFoundException);
        }
        Configuration configuration5 = context.getResources().getConfiguration();
        if (!configuration.equals(configuration5)) {
            configuration2 = AppCompatDelegateImpl.generateConfigDelta(configuration, configuration5);
        }
        configuration = this.createOverrideConfigurationForDayNight(context, n2, configuration2);
        configuration2 = new ContextThemeWrapper(context, R.style.Theme_AppCompat_Empty);
        configuration2.applyOverrideConfiguration(configuration);
        n2 = 0;
        try {
            context = context.getTheme();
            if (context != null) {
                n2 = 1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (n2 != 0) {
            ResourcesCompat.ThemeCompat.rebase((Resources.Theme)configuration2.getTheme());
        }
        return super.attachBaseContext2((Context)configuration2);
    }

    void callOnPanelClosed(int n2, PanelFeatureState panelFeatureStateArray, Menu menu2) {
        PanelFeatureState[] panelFeatureStateArray2 = panelFeatureStateArray;
        Menu menu3 = menu2;
        if (menu2 == null) {
            Object object = panelFeatureStateArray;
            if (panelFeatureStateArray == null) {
                object = panelFeatureStateArray;
                if (n2 >= 0) {
                    panelFeatureStateArray2 = this.mPanels;
                    object = panelFeatureStateArray;
                    if (n2 < panelFeatureStateArray2.length) {
                        object = panelFeatureStateArray2[n2];
                    }
                }
            }
            panelFeatureStateArray2 = object;
            menu3 = menu2;
            if (object != null) {
                menu3 = object.menu;
                panelFeatureStateArray2 = object;
            }
        }
        if (panelFeatureStateArray2 != null && !panelFeatureStateArray2.isOpen) {
            return;
        }
        if (!this.mIsDestroyed) {
            this.mAppCompatWindowCallback.getWrapped().onPanelClosed(n2, menu3);
        }
    }

    void checkCloseActionMenu(MenuBuilder menuBuilder) {
        if (this.mClosingActionMenu) {
            return;
        }
        this.mClosingActionMenu = true;
        this.mDecorContentParent.dismissPopups();
        Window.Callback callback2 = this.getWindowCallback();
        if (callback2 != null && !this.mIsDestroyed) {
            callback2.onPanelClosed(108, (Menu)menuBuilder);
        }
        this.mClosingActionMenu = false;
    }

    void closePanel(int n2) {
        this.closePanel(this.getPanelState(n2, true), true);
    }

    void closePanel(PanelFeatureState panelFeatureState, boolean bl) {
        DecorContentParent decorContentParent;
        if (bl && panelFeatureState.featureId == 0 && (decorContentParent = this.mDecorContentParent) != null && decorContentParent.isOverflowMenuShowing()) {
            this.checkCloseActionMenu(panelFeatureState.menu);
            return;
        }
        decorContentParent = (WindowManager)this.mContext.getSystemService("window");
        if (decorContentParent != null && panelFeatureState.isOpen && panelFeatureState.decorView != null) {
            decorContentParent.removeView((View)panelFeatureState.decorView);
            if (bl) {
                this.callOnPanelClosed(panelFeatureState.featureId, panelFeatureState, null);
            }
        }
        panelFeatureState.isPrepared = false;
        panelFeatureState.isHandled = false;
        panelFeatureState.isOpen = false;
        panelFeatureState.shownPanelView = null;
        panelFeatureState.refreshDecorView = true;
        if (this.mPreparedPanel == panelFeatureState) {
            this.mPreparedPanel = null;
        }
    }

    @Override
    public View createView(View view, String string2, Context context, AttributeSet attributeSet) {
        Object object = this.mAppCompatViewInflater;
        boolean bl = false;
        if (object == null) {
            String string3 = this.mContext.obtainStyledAttributes(R.styleable.AppCompatTheme).getString(R.styleable.AppCompatTheme_viewInflaterClass);
            if (string3 == null) {
                this.mAppCompatViewInflater = new AppCompatViewInflater();
            } else {
                try {
                    this.mAppCompatViewInflater = (AppCompatViewInflater)Class.forName(string3).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable throwable) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Failed to instantiate custom view inflater ");
                    ((StringBuilder)object).append(string3);
                    ((StringBuilder)object).append(". Falling back to default.");
                    Log.i((String)"AppCompatDelegate", (String)((StringBuilder)object).toString(), (Throwable)throwable);
                    this.mAppCompatViewInflater = new AppCompatViewInflater();
                }
            }
        }
        if (IS_PRE_LOLLIPOP) {
            if (attributeSet instanceof XmlPullParser) {
                if (((XmlPullParser)attributeSet).getDepth() > 1) {
                    bl = true;
                }
            } else {
                bl = this.shouldInheritContext((ViewParent)view);
            }
        } else {
            bl = false;
        }
        return this.mAppCompatViewInflater.createView(view, string2, context, attributeSet, bl, IS_PRE_LOLLIPOP, true, VectorEnabledTintResources.shouldBeUsed());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dismissPopups() {
        DecorContentParent decorContentParent = this.mDecorContentParent;
        if (decorContentParent != null) {
            decorContentParent.dismissPopups();
        }
        if (this.mActionModePopup != null) {
            this.mWindow.getDecorView().removeCallbacks(this.mShowActionModePopup);
            if (this.mActionModePopup.isShowing()) {
                try {
                    this.mActionModePopup.dismiss();
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.mActionModePopup = null;
        }
        this.endOnGoingFadeAnimation();
        PanelFeatureState panelFeatureState = this.getPanelState(0, false);
        if (panelFeatureState != null && panelFeatureState.menu != null) {
            panelFeatureState.menu.close();
        }
    }

    boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Object object = this.mHost;
        boolean bl = object instanceof KeyEventDispatcher.Component;
        boolean bl2 = true;
        if ((bl || object instanceof AppCompatDialog) && (object = this.mWindow.getDecorView()) != null && KeyEventDispatcher.dispatchBeforeHierarchy((View)object, keyEvent)) {
            return true;
        }
        if (keyEvent.getKeyCode() == 82 && this.mAppCompatWindowCallback.getWrapped().dispatchKeyEvent(keyEvent)) {
            return true;
        }
        int n2 = keyEvent.getKeyCode();
        if (keyEvent.getAction() != 0) {
            bl2 = false;
        }
        bl = bl2 ? this.onKeyDown(n2, keyEvent) : this.onKeyUp(n2, keyEvent);
        return bl;
    }

    void doInvalidatePanelMenu(int n2) {
        PanelFeatureState panelFeatureState = this.getPanelState(n2, true);
        if (panelFeatureState.menu != null) {
            Bundle bundle = new Bundle();
            panelFeatureState.menu.saveActionViewStates(bundle);
            if (bundle.size() > 0) {
                panelFeatureState.frozenActionViewState = bundle;
            }
            panelFeatureState.menu.stopDispatchingItemsChanged();
            panelFeatureState.menu.clear();
        }
        panelFeatureState.refreshMenuContent = true;
        panelFeatureState.refreshDecorView = true;
        if ((n2 == 108 || n2 == 0) && this.mDecorContentParent != null && (panelFeatureState = this.getPanelState(0, false)) != null) {
            panelFeatureState.isPrepared = false;
            this.preparePanel(panelFeatureState, null);
        }
    }

    void endOnGoingFadeAnimation() {
        ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = this.mFadeAnim;
        if (viewPropertyAnimatorCompat != null) {
            viewPropertyAnimatorCompat.cancel();
        }
    }

    PanelFeatureState findMenuPanel(Menu menu2) {
        PanelFeatureState[] panelFeatureStateArray = this.mPanels;
        int n2 = panelFeatureStateArray != null ? panelFeatureStateArray.length : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            PanelFeatureState panelFeatureState = panelFeatureStateArray[i2];
            if (panelFeatureState == null || panelFeatureState.menu != menu2) continue;
            return panelFeatureState;
        }
        return null;
    }

    @Override
    public <T extends View> T findViewById(int n2) {
        this.ensureSubDecor();
        return (T)this.mWindow.findViewById(n2);
    }

    final Context getActionBarThemedContext() {
        ActionBar actionBar = this.getSupportActionBar();
        actionBar = actionBar != null ? actionBar.getThemedContext() : null;
        ActionBar actionBar2 = actionBar;
        if (actionBar == null) {
            actionBar2 = this.mContext;
        }
        return actionBar2;
    }

    final AutoNightModeManager getAutoTimeNightModeManager() {
        return this.getAutoTimeNightModeManager(this.mContext);
    }

    @Override
    public final ActionBarDrawerToggle.Delegate getDrawerToggleDelegate() {
        return new ActionBarDrawableToggleImpl();
    }

    @Override
    public int getLocalNightMode() {
        return this.mLocalNightMode;
    }

    @Override
    public MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.initWindowDecorActionBar();
            ActionBar actionBar = this.mActionBar;
            actionBar = actionBar != null ? actionBar.getThemedContext() : this.mContext;
            this.mMenuInflater = new SupportMenuInflater((Context)actionBar);
        }
        return this.mMenuInflater;
    }

    protected PanelFeatureState getPanelState(int n2, boolean bl) {
        PanelFeatureState[] panelFeatureStateArray;
        Object object;
        block6: {
            block5: {
                object = this.mPanels;
                if (object == null) break block5;
                panelFeatureStateArray = object;
                if (((PanelFeatureState[])object).length > n2) break block6;
            }
            panelFeatureStateArray = new PanelFeatureState[n2 + 1];
            if (object != null) {
                System.arraycopy(object, 0, panelFeatureStateArray, 0, ((PanelFeatureState[])object).length);
            }
            this.mPanels = panelFeatureStateArray;
        }
        PanelFeatureState panelFeatureState = panelFeatureStateArray[n2];
        object = panelFeatureState;
        if (panelFeatureState == null) {
            panelFeatureStateArray[n2] = object = new PanelFeatureState(n2);
        }
        return object;
    }

    ViewGroup getSubDecor() {
        return this.mSubDecor;
    }

    @Override
    public ActionBar getSupportActionBar() {
        this.initWindowDecorActionBar();
        return this.mActionBar;
    }

    final CharSequence getTitle() {
        Object object = this.mHost;
        if (object instanceof Activity) {
            return ((Activity)object).getTitle();
        }
        return this.mTitle;
    }

    final Window.Callback getWindowCallback() {
        return this.mWindow.getCallback();
    }

    @Override
    public boolean hasWindowFeature(int n2) {
        int n3 = this.sanitizeWindowFeatureId(n2);
        boolean bl = true;
        boolean bl2 = n3 != 1 ? (n3 != 2 ? (n3 != 5 ? (n3 != 10 ? (n3 != 108 ? (n3 != 109 ? false : this.mOverlayActionBar) : this.mHasActionBar) : this.mOverlayActionMode) : this.mFeatureIndeterminateProgress) : this.mFeatureProgress) : this.mWindowNoTitle;
        boolean bl3 = bl;
        if (!bl2) {
            bl3 = this.mWindow.hasFeature(n2) ? bl : false;
        }
        return bl3;
    }

    @Override
    public void installViewFactory() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        if (layoutInflater.getFactory() == null) {
            LayoutInflaterCompat.setFactory2((LayoutInflater)layoutInflater, (LayoutInflater.Factory2)this);
        } else if (!(layoutInflater.getFactory2() instanceof AppCompatDelegateImpl)) {
            Log.i((String)"AppCompatDelegate", (String)"The Activity's LayoutInflater already has a Factory installed so we can not install AppCompat's");
        }
    }

    @Override
    public void invalidateOptionsMenu() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null && actionBar.invalidateOptionsMenu()) {
            return;
        }
        this.invalidatePanelMenu(0);
    }

    @Override
    public boolean isHandleNativeActionModesEnabled() {
        return this.mHandleNativeActionModes;
    }

    int mapNightMode(Context context, int n2) {
        if (n2 != -100) {
            if (n2 != -1) {
                if (n2 != 0) {
                    if (n2 != 1 && n2 != 2) {
                        if (n2 == 3) {
                            return this.getAutoBatteryNightModeManager(context).getApplyableNightMode();
                        }
                        throw new IllegalStateException("Unknown value set for night mode. Please use one of the MODE_NIGHT values from AppCompatDelegate.");
                    }
                } else {
                    if (Build.VERSION.SDK_INT >= 23 && ((UiModeManager)context.getApplicationContext().getSystemService(UiModeManager.class)).getNightMode() == 0) {
                        return -1;
                    }
                    return this.getAutoTimeNightModeManager(context).getApplyableNightMode();
                }
            }
            return n2;
        }
        return -1;
    }

    boolean onBackPressed() {
        Object object = this.mActionMode;
        if (object != null) {
            object.finish();
            return true;
        }
        object = this.getSupportActionBar();
        return object != null && ((ActionBar)object).collapseActionView();
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        ActionBar actionBar;
        if (this.mHasActionBar && this.mSubDecorInstalled && (actionBar = this.getSupportActionBar()) != null) {
            actionBar.onConfigurationChanged(configuration);
        }
        AppCompatDrawableManager.get().onConfigurationChanged(this.mContext);
        this.applyDayNight(false);
    }

    @Override
    public void onCreate(Bundle object) {
        this.mBaseContextAttached = true;
        this.applyDayNight(false);
        this.ensureWindow();
        Object object2 = this.mHost;
        if (object2 instanceof Activity) {
            object = null;
            try {
                object = object2 = NavUtils.getParentActivityName((Activity)object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (object != null) {
                object = this.peekSupportActionBar();
                if (object == null) {
                    this.mEnableDefaultActionBarUp = true;
                } else {
                    ((ActionBar)object).setDefaultDisplayHomeAsUpEnabled(true);
                }
            }
            AppCompatDelegateImpl.addActiveDelegate(this);
        }
        this.mCreated = true;
    }

    public final View onCreateView(View view, String string2, Context context, AttributeSet attributeSet) {
        return this.createView(view, string2, context, attributeSet);
    }

    public View onCreateView(String string2, Context context, AttributeSet attributeSet) {
        return this.onCreateView(null, string2, context, attributeSet);
    }

    @Override
    public void onDestroy() {
        Object object;
        if (this.mHost instanceof Activity) {
            AppCompatDelegateImpl.removeActivityDelegate(this);
        }
        if (this.mInvalidatePanelMenuPosted) {
            this.mWindow.getDecorView().removeCallbacks(this.mInvalidatePanelMenuRunnable);
        }
        this.mStarted = false;
        this.mIsDestroyed = true;
        if (this.mLocalNightMode != -100 && (object = this.mHost) instanceof Activity && ((Activity)object).isChangingConfigurations()) {
            sLocalNightModes.put((Object)this.mHost.getClass().getName(), (Object)this.mLocalNightMode);
        } else {
            sLocalNightModes.remove((Object)this.mHost.getClass().getName());
        }
        object = this.mActionBar;
        if (object != null) {
            ((ActionBar)object).onDestroy();
        }
        this.cleanupAutoManagers();
    }

    boolean onKeyDown(int n2, KeyEvent keyEvent) {
        boolean bl = true;
        if (n2 != 4) {
            if (n2 == 82) {
                this.onKeyDownPanel(0, keyEvent);
                return true;
            }
        } else {
            if ((keyEvent.getFlags() & 0x80) == 0) {
                bl = false;
            }
            this.mLongPressBackDown = bl;
        }
        return false;
    }

    boolean onKeyShortcut(int n2, KeyEvent object) {
        Object object2 = this.getSupportActionBar();
        if (object2 != null && ((ActionBar)object2).onKeyShortcut(n2, (KeyEvent)object)) {
            return true;
        }
        object2 = this.mPreparedPanel;
        if (object2 != null && this.performPanelShortcut((PanelFeatureState)object2, object.getKeyCode(), (KeyEvent)object, 1)) {
            object = this.mPreparedPanel;
            if (object != null) {
                object.isHandled = true;
            }
            return true;
        }
        if (this.mPreparedPanel == null) {
            object2 = this.getPanelState(0, true);
            this.preparePanel((PanelFeatureState)object2, (KeyEvent)object);
            boolean bl = this.performPanelShortcut((PanelFeatureState)object2, object.getKeyCode(), (KeyEvent)object, 1);
            ((PanelFeatureState)object2).isPrepared = false;
            if (bl) {
                return true;
            }
        }
        return false;
    }

    boolean onKeyUp(int n2, KeyEvent object) {
        if (n2 != 4) {
            if (n2 == 82) {
                this.onKeyUpPanel(0, (KeyEvent)object);
                return true;
            }
        } else {
            boolean bl = this.mLongPressBackDown;
            this.mLongPressBackDown = false;
            object = this.getPanelState(0, false);
            if (object != null && object.isOpen) {
                if (!bl) {
                    this.closePanel((PanelFeatureState)object, true);
                }
                return true;
            }
            if (this.onBackPressed()) {
                return true;
            }
        }
        return false;
    }

    public boolean onMenuItemSelected(MenuBuilder object, MenuItem menuItem) {
        Window.Callback callback2 = this.getWindowCallback();
        if (callback2 != null && !this.mIsDestroyed && (object = this.findMenuPanel((Menu)object.getRootMenu())) != null) {
            return callback2.onMenuItemSelected(object.featureId, menuItem);
        }
        return false;
    }

    public void onMenuModeChange(MenuBuilder menuBuilder) {
        this.reopenMenu(true);
    }

    void onMenuOpened(int n2) {
        ActionBar actionBar;
        if (n2 == 108 && (actionBar = this.getSupportActionBar()) != null) {
            actionBar.dispatchMenuVisibilityChanged(true);
        }
    }

    void onPanelClosed(int n2) {
        if (n2 == 108) {
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar != null) {
                actionBar.dispatchMenuVisibilityChanged(false);
            }
        } else if (n2 == 0) {
            PanelFeatureState panelFeatureState = this.getPanelState(n2, true);
            if (panelFeatureState.isOpen) {
                this.closePanel(panelFeatureState, false);
            }
        }
    }

    @Override
    public void onPostCreate(Bundle bundle) {
        this.ensureSubDecor();
    }

    @Override
    public void onPostResume() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setShowHideAnimationEnabled(true);
        }
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
    }

    @Override
    public void onStart() {
        this.mStarted = true;
        this.applyDayNight();
    }

    @Override
    public void onStop() {
        this.mStarted = false;
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setShowHideAnimationEnabled(false);
        }
    }

    void onSubDecorInstalled(ViewGroup viewGroup) {
    }

    final ActionBar peekSupportActionBar() {
        return this.mActionBar;
    }

    @Override
    public boolean requestWindowFeature(int n2) {
        n2 = this.sanitizeWindowFeatureId(n2);
        if (this.mWindowNoTitle && n2 == 108) {
            return false;
        }
        if (this.mHasActionBar && n2 == 1) {
            this.mHasActionBar = false;
        }
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 5) {
                    if (n2 != 10) {
                        if (n2 != 108) {
                            if (n2 != 109) {
                                return this.mWindow.requestFeature(n2);
                            }
                            this.throwFeatureRequestIfSubDecorInstalled();
                            this.mOverlayActionBar = true;
                            return true;
                        }
                        this.throwFeatureRequestIfSubDecorInstalled();
                        this.mHasActionBar = true;
                        return true;
                    }
                    this.throwFeatureRequestIfSubDecorInstalled();
                    this.mOverlayActionMode = true;
                    return true;
                }
                this.throwFeatureRequestIfSubDecorInstalled();
                this.mFeatureIndeterminateProgress = true;
                return true;
            }
            this.throwFeatureRequestIfSubDecorInstalled();
            this.mFeatureProgress = true;
            return true;
        }
        this.throwFeatureRequestIfSubDecorInstalled();
        this.mWindowNoTitle = true;
        return true;
    }

    @Override
    public void setContentView(int n2) {
        this.ensureSubDecor();
        ViewGroup viewGroup = (ViewGroup)this.mSubDecor.findViewById(0x1020002);
        viewGroup.removeAllViews();
        LayoutInflater.from((Context)this.mContext).inflate(n2, viewGroup);
        this.mAppCompatWindowCallback.getWrapped().onContentChanged();
    }

    @Override
    public void setContentView(View view) {
        this.ensureSubDecor();
        ViewGroup viewGroup = (ViewGroup)this.mSubDecor.findViewById(0x1020002);
        viewGroup.removeAllViews();
        viewGroup.addView(view);
        this.mAppCompatWindowCallback.getWrapped().onContentChanged();
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.ensureSubDecor();
        ViewGroup viewGroup = (ViewGroup)this.mSubDecor.findViewById(0x1020002);
        viewGroup.removeAllViews();
        viewGroup.addView(view, layoutParams);
        this.mAppCompatWindowCallback.getWrapped().onContentChanged();
    }

    @Override
    public void setHandleNativeActionModesEnabled(boolean bl) {
        this.mHandleNativeActionModes = bl;
    }

    @Override
    public void setLocalNightMode(int n2) {
        if (this.mLocalNightMode != n2) {
            this.mLocalNightMode = n2;
            if (this.mBaseContextAttached) {
                this.applyDayNight();
            }
        }
    }

    @Override
    public void setSupportActionBar(Toolbar toolbar) {
        if (!(this.mHost instanceof Activity)) {
            return;
        }
        ActionBar actionBar = this.getSupportActionBar();
        if (!(actionBar instanceof WindowDecorActionBar)) {
            this.mMenuInflater = null;
            if (actionBar != null) {
                actionBar.onDestroy();
            }
            if (toolbar != null) {
                toolbar = new ToolbarActionBar(toolbar, this.getTitle(), (Window.Callback)this.mAppCompatWindowCallback);
                this.mActionBar = toolbar;
                this.mWindow.setCallback(toolbar.getWrappedWindowCallback());
            } else {
                this.mActionBar = null;
                this.mWindow.setCallback((Window.Callback)this.mAppCompatWindowCallback);
            }
            this.invalidateOptionsMenu();
            return;
        }
        throw new IllegalStateException("This Activity already has an action bar supplied by the window decor. Do not request Window.FEATURE_SUPPORT_ACTION_BAR and set windowActionBar to false in your theme to use a Toolbar instead.");
    }

    @Override
    public void setTheme(int n2) {
        this.mThemeResId = n2;
    }

    @Override
    public final void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        DecorContentParent decorContentParent = this.mDecorContentParent;
        if (decorContentParent != null) {
            decorContentParent.setWindowTitle(charSequence);
        } else if (this.peekSupportActionBar() != null) {
            this.peekSupportActionBar().setWindowTitle(charSequence);
        } else {
            decorContentParent = this.mTitleView;
            if (decorContentParent != null) {
                decorContentParent.setText(charSequence);
            }
        }
    }

    final boolean shouldAnimateActionModeView() {
        ViewGroup viewGroup;
        boolean bl = this.mSubDecorInstalled && (viewGroup = this.mSubDecor) != null && ViewCompat.isLaidOut((View)viewGroup);
        return bl;
    }

    @Override
    public ActionMode startSupportActionMode(ActionMode.Callback callback2) {
        if (callback2 != null) {
            ActionMode actionMode;
            Object object = this.mActionMode;
            if (object != null) {
                object.finish();
            }
            callback2 = new ActionModeCallbackWrapperV9(callback2);
            object = this.getSupportActionBar();
            if (object != null && (actionMode = (this.mActionMode = ((ActionBar)object).startActionMode(callback2))) != null && (object = this.mAppCompatCallback) != null) {
                object.onSupportActionModeStarted(actionMode);
            }
            if (this.mActionMode == null) {
                this.mActionMode = this.startSupportActionModeFromWindow(callback2);
            }
            return this.mActionMode;
        }
        throw new IllegalArgumentException("ActionMode callback can not be null.");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ActionMode startSupportActionModeFromWindow(ActionMode.Callback callback2) {
        void var2_6;
        this.endOnGoingFadeAnimation();
        ActionMode actionMode = this.mActionMode;
        if (actionMode != null) {
            actionMode.finish();
        }
        ActionMode.Callback callback3 = callback2;
        if (!(callback2 instanceof ActionModeCallbackWrapperV9)) {
            ActionModeCallbackWrapperV9 actionModeCallbackWrapperV9 = new ActionModeCallbackWrapperV9(callback2);
        }
        if ((callback2 = this.mAppCompatCallback) != null && !this.mIsDestroyed) {
            try {
                callback2 = callback2.onWindowStartingSupportActionMode((ActionMode.Callback)var2_6);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        callback2 = null;
        if (callback2 != null) {
            this.mActionMode = callback2;
        } else {
            TypedValue typedValue;
            callback2 = this.mActionModeView;
            boolean bl = true;
            if (callback2 == null) {
                if (this.mIsFloating) {
                    typedValue = new TypedValue();
                    callback2 = this.mContext.getTheme();
                    callback2.resolveAttribute(R.attr.actionBarTheme, typedValue, true);
                    if (typedValue.resourceId != 0) {
                        Resources.Theme theme = this.mContext.getResources().newTheme();
                        theme.setTo((Resources.Theme)callback2);
                        theme.applyStyle(typedValue.resourceId, true);
                        callback2 = new ContextThemeWrapper(this.mContext, 0);
                        callback2.getTheme().setTo(theme);
                    } else {
                        callback2 = this.mContext;
                    }
                    this.mActionModeView = new ActionBarContextView((Context)callback2);
                    this.mActionModePopup = new PopupWindow((Context)callback2, null, R.attr.actionModePopupWindowStyle);
                    PopupWindowCompat.setWindowLayoutType((PopupWindow)this.mActionModePopup, (int)2);
                    this.mActionModePopup.setContentView((View)this.mActionModeView);
                    this.mActionModePopup.setWidth(-1);
                    callback2.getTheme().resolveAttribute(R.attr.actionBarSize, typedValue, true);
                    int n2 = TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)callback2.getResources().getDisplayMetrics());
                    this.mActionModeView.setContentHeight(n2);
                    this.mActionModePopup.setHeight(-2);
                    this.mShowActionModePopup = new Runnable(){

                        @Override
                        public void run() {
                            AppCompatDelegateImpl.this.mActionModePopup.showAtLocation((View)AppCompatDelegateImpl.this.mActionModeView, 55, 0, 0);
                            AppCompatDelegateImpl.this.endOnGoingFadeAnimation();
                            if (AppCompatDelegateImpl.this.shouldAnimateActionModeView()) {
                                AppCompatDelegateImpl.this.mActionModeView.setAlpha(0.0f);
                                AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
                                appCompatDelegateImpl.mFadeAnim = ViewCompat.animate((View)appCompatDelegateImpl.mActionModeView).alpha(1.0f);
                                AppCompatDelegateImpl.this.mFadeAnim.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                                    public void onAnimationEnd(View view) {
                                        AppCompatDelegateImpl.this.mActionModeView.setAlpha(1.0f);
                                        AppCompatDelegateImpl.this.mFadeAnim.setListener(null);
                                        AppCompatDelegateImpl.this.mFadeAnim = null;
                                    }

                                    public void onAnimationStart(View view) {
                                        AppCompatDelegateImpl.this.mActionModeView.setVisibility(0);
                                    }
                                });
                            } else {
                                AppCompatDelegateImpl.this.mActionModeView.setAlpha(1.0f);
                                AppCompatDelegateImpl.this.mActionModeView.setVisibility(0);
                            }
                        }
                    };
                } else {
                    callback2 = (ViewStubCompat)this.mSubDecor.findViewById(R.id.action_mode_bar_stub);
                    if (callback2 != null) {
                        callback2.setLayoutInflater(LayoutInflater.from((Context)this.getActionBarThemedContext()));
                        this.mActionModeView = (ActionBarContextView)callback2.inflate();
                    }
                }
            }
            if (this.mActionModeView != null) {
                this.endOnGoingFadeAnimation();
                this.mActionModeView.killMode();
                typedValue = this.mActionModeView.getContext();
                callback2 = this.mActionModeView;
                if (this.mActionModePopup != null) {
                    bl = false;
                }
                callback2 = new StandaloneActionMode((Context)typedValue, (ActionBarContextView)callback2, (ActionMode.Callback)var2_6, bl);
                if (var2_6.onCreateActionMode((ActionMode)callback2, callback2.getMenu())) {
                    callback2.invalidate();
                    this.mActionModeView.initForMode((ActionMode)callback2);
                    this.mActionMode = callback2;
                    if (this.shouldAnimateActionModeView()) {
                        this.mActionModeView.setAlpha(0.0f);
                        this.mFadeAnim = ViewCompat.animate((View)this.mActionModeView).alpha(1.0f);
                        this.mFadeAnim.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                            public void onAnimationEnd(View view) {
                                AppCompatDelegateImpl.this.mActionModeView.setAlpha(1.0f);
                                AppCompatDelegateImpl.this.mFadeAnim.setListener(null);
                                AppCompatDelegateImpl.this.mFadeAnim = null;
                            }

                            public void onAnimationStart(View view) {
                                AppCompatDelegateImpl.this.mActionModeView.setVisibility(0);
                                AppCompatDelegateImpl.this.mActionModeView.sendAccessibilityEvent(32);
                                if (AppCompatDelegateImpl.this.mActionModeView.getParent() instanceof View) {
                                    ViewCompat.requestApplyInsets((View)AppCompatDelegateImpl.this.mActionModeView.getParent());
                                }
                            }
                        });
                    } else {
                        this.mActionModeView.setAlpha(1.0f);
                        this.mActionModeView.setVisibility(0);
                        this.mActionModeView.sendAccessibilityEvent(32);
                        if (this.mActionModeView.getParent() instanceof View) {
                            ViewCompat.requestApplyInsets((View)this.mActionModeView.getParent());
                        }
                    }
                    if (this.mActionModePopup != null) {
                        this.mWindow.getDecorView().post(this.mShowActionModePopup);
                    }
                } else {
                    this.mActionMode = null;
                }
            }
        }
        ActionMode actionMode2 = this.mActionMode;
        if (actionMode2 != null && (callback2 = this.mAppCompatCallback) != null) {
            callback2.onSupportActionModeStarted(actionMode2);
        }
        return this.mActionMode;
    }

    final int updateStatusGuard(WindowInsetsCompat windowInsetsCompat, Rect rect) {
        int n2;
        int n3 = 0;
        int n4 = windowInsetsCompat != null ? windowInsetsCompat.getSystemWindowInsetTop() : (rect != null ? rect.top : 0);
        ActionBarContextView actionBarContextView = this.mActionModeView;
        if (actionBarContextView != null && actionBarContextView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            int n5;
            int n6;
            int n7;
            actionBarContextView = (ViewGroup.MarginLayoutParams)this.mActionModeView.getLayoutParams();
            boolean bl = this.mActionModeView.isShown();
            int n8 = 1;
            if (bl) {
                if (this.mTempRect1 == null) {
                    this.mTempRect1 = new Rect();
                    this.mTempRect2 = new Rect();
                }
                Rect rect2 = this.mTempRect1;
                Rect rect3 = this.mTempRect2;
                if (windowInsetsCompat == null) {
                    rect2.set(rect);
                } else {
                    rect2.set(windowInsetsCompat.getSystemWindowInsetLeft(), windowInsetsCompat.getSystemWindowInsetTop(), windowInsetsCompat.getSystemWindowInsetRight(), windowInsetsCompat.getSystemWindowInsetBottom());
                }
                ViewUtils.computeFitSystemWindows((View)this.mSubDecor, (Rect)rect2, (Rect)rect3);
                n7 = rect2.top;
                n2 = rect2.left;
                int n9 = rect2.right;
                windowInsetsCompat = ViewCompat.getRootWindowInsets((View)this.mSubDecor);
                n6 = windowInsetsCompat == null ? 0 : windowInsetsCompat.getSystemWindowInsetLeft();
                n5 = windowInsetsCompat == null ? 0 : windowInsetsCompat.getSystemWindowInsetRight();
                if (actionBarContextView.topMargin == n7 && actionBarContextView.leftMargin == n2 && actionBarContextView.rightMargin == n9) {
                    n2 = 0;
                } else {
                    actionBarContextView.topMargin = n7;
                    actionBarContextView.leftMargin = n2;
                    actionBarContextView.rightMargin = n9;
                    n2 = 1;
                }
                if (n7 > 0 && this.mStatusGuard == null) {
                    this.mStatusGuard = new View(this.mContext);
                    this.mStatusGuard.setVisibility(8);
                    windowInsetsCompat = new FrameLayout.LayoutParams(-1, actionBarContextView.topMargin, 51);
                    ((FrameLayout.LayoutParams)windowInsetsCompat).leftMargin = n6;
                    ((FrameLayout.LayoutParams)windowInsetsCompat).rightMargin = n5;
                    this.mSubDecor.addView(this.mStatusGuard, -1, (ViewGroup.LayoutParams)windowInsetsCompat);
                } else {
                    windowInsetsCompat = this.mStatusGuard;
                    if (windowInsetsCompat != null) {
                        windowInsetsCompat = (ViewGroup.MarginLayoutParams)windowInsetsCompat.getLayoutParams();
                        if (((ViewGroup.MarginLayoutParams)windowInsetsCompat).height != actionBarContextView.topMargin || ((ViewGroup.MarginLayoutParams)windowInsetsCompat).leftMargin != n6 || ((ViewGroup.MarginLayoutParams)windowInsetsCompat).rightMargin != n5) {
                            ((ViewGroup.MarginLayoutParams)windowInsetsCompat).height = actionBarContextView.topMargin;
                            ((ViewGroup.MarginLayoutParams)windowInsetsCompat).leftMargin = n6;
                            ((ViewGroup.MarginLayoutParams)windowInsetsCompat).rightMargin = n5;
                            this.mStatusGuard.setLayoutParams((ViewGroup.LayoutParams)windowInsetsCompat);
                        }
                    }
                }
                if (this.mStatusGuard == null) {
                    n8 = 0;
                }
                if (n8 != 0 && this.mStatusGuard.getVisibility() != 0) {
                    this.updateStatusGuardColor(this.mStatusGuard);
                }
                n5 = n4;
                n6 = n8;
                n7 = n2;
                if (!this.mOverlayActionMode) {
                    n5 = n4;
                    n6 = n8;
                    n7 = n2;
                    if (n8 != 0) {
                        n5 = 0;
                        n6 = n8;
                        n7 = n2;
                    }
                }
            } else {
                if (actionBarContextView.topMargin != 0) {
                    actionBarContextView.topMargin = 0;
                    n2 = 1;
                } else {
                    n2 = 0;
                }
                n6 = 0;
                n7 = n2;
                n5 = n4;
            }
            n4 = n5;
            n2 = n6;
            if (n7 != 0) {
                this.mActionModeView.setLayoutParams((ViewGroup.LayoutParams)actionBarContextView);
                n4 = n5;
                n2 = n6;
            }
        } else {
            n2 = 0;
        }
        if ((windowInsetsCompat = this.mStatusGuard) != null) {
            n2 = n2 != 0 ? n3 : 8;
            windowInsetsCompat.setVisibility(n2);
        }
        return n4;
    }

    private class ActionBarDrawableToggleImpl
    implements ActionBarDrawerToggle.Delegate {
        ActionBarDrawableToggleImpl() {
        }

        public Context getActionBarThemedContext() {
            return AppCompatDelegateImpl.this.getActionBarThemedContext();
        }

        public Drawable getThemeUpIndicator() {
            TintTypedArray tintTypedArray = TintTypedArray.obtainStyledAttributes((Context)this.getActionBarThemedContext(), null, (int[])new int[]{R.attr.homeAsUpIndicator});
            Drawable drawable2 = tintTypedArray.getDrawable(0);
            tintTypedArray.recycle();
            return drawable2;
        }

        public boolean isNavigationVisible() {
            ActionBar actionBar = AppCompatDelegateImpl.this.getSupportActionBar();
            boolean bl = actionBar != null && (actionBar.getDisplayOptions() & 4) != 0;
            return bl;
        }

        public void setActionBarDescription(int n2) {
            ActionBar actionBar = AppCompatDelegateImpl.this.getSupportActionBar();
            if (actionBar != null) {
                actionBar.setHomeActionContentDescription(n2);
            }
        }

        public void setActionBarUpIndicator(Drawable drawable2, int n2) {
            ActionBar actionBar = AppCompatDelegateImpl.this.getSupportActionBar();
            if (actionBar != null) {
                actionBar.setHomeAsUpIndicator(drawable2);
                actionBar.setHomeActionContentDescription(n2);
            }
        }
    }

    private final class ActionMenuPresenterCallback
    implements MenuPresenter.Callback {
        ActionMenuPresenterCallback() {
        }

        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            AppCompatDelegateImpl.this.checkCloseActionMenu(menuBuilder);
        }

        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            Window.Callback callback2 = AppCompatDelegateImpl.this.getWindowCallback();
            if (callback2 != null) {
                callback2.onMenuOpened(108, (Menu)menuBuilder);
            }
            return true;
        }
    }

    class ActionModeCallbackWrapperV9
    implements ActionMode.Callback {
        private ActionMode.Callback mWrapped;

        public ActionModeCallbackWrapperV9(ActionMode.Callback callback2) {
            this.mWrapped = callback2;
        }

        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            return this.mWrapped.onActionItemClicked(actionMode, menuItem);
        }

        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            return this.mWrapped.onCreateActionMode(actionMode, menu2);
        }

        public void onDestroyActionMode(ActionMode object) {
            this.mWrapped.onDestroyActionMode(object);
            if (AppCompatDelegateImpl.this.mActionModePopup != null) {
                AppCompatDelegateImpl.this.mWindow.getDecorView().removeCallbacks(AppCompatDelegateImpl.this.mShowActionModePopup);
            }
            if (AppCompatDelegateImpl.this.mActionModeView != null) {
                AppCompatDelegateImpl.this.endOnGoingFadeAnimation();
                object = AppCompatDelegateImpl.this;
                object.mFadeAnim = ViewCompat.animate((View)object.mActionModeView).alpha(0.0f);
                AppCompatDelegateImpl.this.mFadeAnim.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                    public void onAnimationEnd(View view) {
                        AppCompatDelegateImpl.this.mActionModeView.setVisibility(8);
                        if (AppCompatDelegateImpl.this.mActionModePopup != null) {
                            AppCompatDelegateImpl.this.mActionModePopup.dismiss();
                        } else if (AppCompatDelegateImpl.this.mActionModeView.getParent() instanceof View) {
                            ViewCompat.requestApplyInsets((View)AppCompatDelegateImpl.this.mActionModeView.getParent());
                        }
                        AppCompatDelegateImpl.this.mActionModeView.removeAllViews();
                        AppCompatDelegateImpl.this.mFadeAnim.setListener(null);
                        AppCompatDelegateImpl.this.mFadeAnim = null;
                        ViewCompat.requestApplyInsets((View)AppCompatDelegateImpl.this.mSubDecor);
                    }
                });
            }
            if (AppCompatDelegateImpl.this.mAppCompatCallback != null) {
                AppCompatDelegateImpl.this.mAppCompatCallback.onSupportActionModeFinished(AppCompatDelegateImpl.this.mActionMode);
            }
            object = AppCompatDelegateImpl.this;
            object.mActionMode = null;
            ViewCompat.requestApplyInsets((View)object.mSubDecor);
        }

        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            ViewCompat.requestApplyInsets((View)AppCompatDelegateImpl.this.mSubDecor);
            return this.mWrapped.onPrepareActionMode(actionMode, menu2);
        }
    }

    class AppCompatWindowCallback
    extends WindowCallbackWrapper {
        AppCompatWindowCallback(Window.Callback callback2) {
            super(callback2);
        }

        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            boolean bl = AppCompatDelegateImpl.this.dispatchKeyEvent(keyEvent) || super.dispatchKeyEvent(keyEvent);
            return bl;
        }

        public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
            boolean bl = super.dispatchKeyShortcutEvent(keyEvent) || AppCompatDelegateImpl.this.onKeyShortcut(keyEvent.getKeyCode(), keyEvent);
            return bl;
        }

        public void onContentChanged() {
        }

        public boolean onCreatePanelMenu(int n2, Menu menu2) {
            if (n2 == 0 && !(menu2 instanceof MenuBuilder)) {
                return false;
            }
            return super.onCreatePanelMenu(n2, menu2);
        }

        public boolean onMenuOpened(int n2, Menu menu2) {
            super.onMenuOpened(n2, menu2);
            AppCompatDelegateImpl.this.onMenuOpened(n2);
            return true;
        }

        public void onPanelClosed(int n2, Menu menu2) {
            super.onPanelClosed(n2, menu2);
            AppCompatDelegateImpl.this.onPanelClosed(n2);
        }

        public boolean onPreparePanel(int n2, View view, Menu menu2) {
            MenuBuilder menuBuilder = menu2 instanceof MenuBuilder ? (MenuBuilder)menu2 : null;
            if (n2 == 0 && menuBuilder == null) {
                return false;
            }
            if (menuBuilder != null) {
                menuBuilder.setOverrideVisibleItems(true);
            }
            boolean bl = super.onPreparePanel(n2, view, menu2);
            if (menuBuilder != null) {
                menuBuilder.setOverrideVisibleItems(false);
            }
            return bl;
        }

        public void onProvideKeyboardShortcuts(List<KeyboardShortcutGroup> list, Menu menu2, int n2) {
            PanelFeatureState panelFeatureState = AppCompatDelegateImpl.this.getPanelState(0, true);
            if (panelFeatureState != null && panelFeatureState.menu != null) {
                super.onProvideKeyboardShortcuts(list, (Menu)panelFeatureState.menu, n2);
            } else {
                super.onProvideKeyboardShortcuts(list, menu2, n2);
            }
        }

        public android.view.ActionMode onWindowStartingActionMode(ActionMode.Callback callback2) {
            if (Build.VERSION.SDK_INT >= 23) {
                return null;
            }
            if (AppCompatDelegateImpl.this.isHandleNativeActionModesEnabled()) {
                return this.startAsSupportActionMode(callback2);
            }
            return super.onWindowStartingActionMode(callback2);
        }

        public android.view.ActionMode onWindowStartingActionMode(ActionMode.Callback callback2, int n2) {
            if (AppCompatDelegateImpl.this.isHandleNativeActionModesEnabled() && n2 == 0) {
                return this.startAsSupportActionMode(callback2);
            }
            return super.onWindowStartingActionMode(callback2, n2);
        }

        final android.view.ActionMode startAsSupportActionMode(ActionMode.Callback callback2) {
            SupportActionModeWrapper.CallbackWrapper callbackWrapper = new SupportActionModeWrapper.CallbackWrapper(AppCompatDelegateImpl.this.mContext, callback2);
            if ((callback2 = AppCompatDelegateImpl.this.startSupportActionMode((ActionMode.Callback)callbackWrapper)) != null) {
                return callbackWrapper.getActionModeWrapper((ActionMode)callback2);
            }
            return null;
        }
    }

    private class AutoBatteryNightModeManager
    extends AutoNightModeManager {
        private final PowerManager mPowerManager;

        AutoBatteryNightModeManager(Context context) {
            this.mPowerManager = (PowerManager)context.getApplicationContext().getSystemService("power");
        }

        @Override
        IntentFilter createIntentFilterForBroadcastReceiver() {
            if (Build.VERSION.SDK_INT >= 21) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
                return intentFilter;
            }
            return null;
        }

        @Override
        public int getApplyableNightMode() {
            int n2;
            int n3 = Build.VERSION.SDK_INT;
            int n4 = n2 = 1;
            if (n3 >= 21) {
                n4 = n2;
                if (this.mPowerManager.isPowerSaveMode()) {
                    n4 = 2;
                }
            }
            return n4;
        }

        @Override
        public void onChange() {
            AppCompatDelegateImpl.this.applyDayNight();
        }
    }

    abstract class AutoNightModeManager {
        private BroadcastReceiver mReceiver;

        AutoNightModeManager() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void cleanup() {
            if (this.mReceiver != null) {
                try {
                    AppCompatDelegateImpl.this.mContext.unregisterReceiver(this.mReceiver);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                this.mReceiver = null;
            }
        }

        abstract IntentFilter createIntentFilterForBroadcastReceiver();

        abstract int getApplyableNightMode();

        boolean isListening() {
            boolean bl = this.mReceiver != null;
            return bl;
        }

        abstract void onChange();

        void setup() {
            this.cleanup();
            IntentFilter intentFilter = this.createIntentFilterForBroadcastReceiver();
            if (intentFilter != null && intentFilter.countActions() != 0) {
                if (this.mReceiver == null) {
                    this.mReceiver = new BroadcastReceiver(){

                        public void onReceive(Context context, Intent intent) {
                            AutoNightModeManager.this.onChange();
                        }
                    };
                }
                AppCompatDelegateImpl.this.mContext.registerReceiver(this.mReceiver, intentFilter);
            }
        }
    }

    private class AutoTimeNightModeManager
    extends AutoNightModeManager {
        private final TwilightManager mTwilightManager;

        AutoTimeNightModeManager(TwilightManager twilightManager) {
            this.mTwilightManager = twilightManager;
        }

        @Override
        IntentFilter createIntentFilterForBroadcastReceiver() {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            intentFilter.addAction("android.intent.action.TIME_TICK");
            return intentFilter;
        }

        @Override
        public int getApplyableNightMode() {
            int n2 = this.mTwilightManager.isNight() ? 2 : 1;
            return n2;
        }

        @Override
        public void onChange() {
            AppCompatDelegateImpl.this.applyDayNight();
        }
    }

    static class ConfigurationImplApi17 {
        private ConfigurationImplApi17() {
        }

        static void generateConfigDelta_densityDpi(Configuration configuration, Configuration configuration2, Configuration configuration3) {
            if (configuration.densityDpi != configuration2.densityDpi) {
                configuration3.densityDpi = configuration2.densityDpi;
            }
        }
    }

    static class ConfigurationImplApi24 {
        private ConfigurationImplApi24() {
        }

        static void generateConfigDelta_locale(Configuration configuration, Configuration configuration2, Configuration configuration3) {
            LocaleList localeList = configuration.getLocales();
            if (!localeList.equals((Object)(configuration = configuration2.getLocales()))) {
                configuration3.setLocales((LocaleList)configuration);
                configuration3.locale = configuration2.locale;
            }
        }
    }

    static class ConfigurationImplApi26 {
        private ConfigurationImplApi26() {
        }

        static void generateConfigDelta_colorMode(Configuration configuration, Configuration configuration2, Configuration configuration3) {
            if ((configuration.colorMode & 3) != (configuration2.colorMode & 3)) {
                configuration3.colorMode |= configuration2.colorMode & 3;
            }
            if ((configuration.colorMode & 0xC) != (configuration2.colorMode & 0xC)) {
                configuration3.colorMode |= configuration2.colorMode & 0xC;
            }
        }
    }

    private static class ContextThemeWrapperCompatApi17Impl {
        private ContextThemeWrapperCompatApi17Impl() {
        }

        static void applyOverrideConfiguration(android.view.ContextThemeWrapper contextThemeWrapper, Configuration configuration) {
            contextThemeWrapper.applyOverrideConfiguration(configuration);
        }
    }

    private class ListMenuDecorView
    extends ContentFrameLayout {
        public ListMenuDecorView(Context context) {
            super(context);
        }

        private boolean isOutOfBounds(int n2, int n3) {
            boolean bl = n2 < -5 || n3 < -5 || n2 > this.getWidth() + 5 || n3 > this.getHeight() + 5;
            return bl;
        }

        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            boolean bl = AppCompatDelegateImpl.this.dispatchKeyEvent(keyEvent) || super.dispatchKeyEvent(keyEvent);
            return bl;
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (motionEvent.getAction() == 0 && this.isOutOfBounds((int)motionEvent.getX(), (int)motionEvent.getY())) {
                AppCompatDelegateImpl.this.closePanel(0);
                return true;
            }
            return super.onInterceptTouchEvent(motionEvent);
        }

        public void setBackgroundResource(int n2) {
            this.setBackgroundDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)n2));
        }
    }

    protected static final class PanelFeatureState {
        int background;
        View createdPanelView;
        ViewGroup decorView;
        int featureId;
        Bundle frozenActionViewState;
        Bundle frozenMenuState;
        int gravity;
        boolean isHandled;
        boolean isOpen;
        boolean isPrepared;
        ListMenuPresenter listMenuPresenter;
        Context listPresenterContext;
        MenuBuilder menu;
        public boolean qwertyMode;
        boolean refreshDecorView;
        boolean refreshMenuContent;
        View shownPanelView;
        boolean wasLastOpen;
        int windowAnimations;
        int x;
        int y;

        PanelFeatureState(int n2) {
            this.featureId = n2;
            this.refreshDecorView = false;
        }

        void applyFrozenState() {
            Bundle bundle;
            MenuBuilder menuBuilder = this.menu;
            if (menuBuilder != null && (bundle = this.frozenMenuState) != null) {
                menuBuilder.restorePresenterStates(bundle);
                this.frozenMenuState = null;
            }
        }

        public void clearMenuPresenters() {
            MenuBuilder menuBuilder = this.menu;
            if (menuBuilder != null) {
                menuBuilder.removeMenuPresenter((MenuPresenter)this.listMenuPresenter);
            }
            this.listMenuPresenter = null;
        }

        MenuView getListMenuView(MenuPresenter.Callback callback2) {
            if (this.menu == null) {
                return null;
            }
            if (this.listMenuPresenter == null) {
                this.listMenuPresenter = new ListMenuPresenter(this.listPresenterContext, R.layout.abc_list_menu_item_layout);
                this.listMenuPresenter.setCallback(callback2);
                this.menu.addMenuPresenter((MenuPresenter)this.listMenuPresenter);
            }
            return this.listMenuPresenter.getMenuView(this.decorView);
        }

        public boolean hasPanelItems() {
            View view = this.shownPanelView;
            boolean bl = false;
            if (view == null) {
                return false;
            }
            if (this.createdPanelView != null) {
                return true;
            }
            if (this.listMenuPresenter.getAdapter().getCount() > 0) {
                bl = true;
            }
            return bl;
        }

        void onRestoreInstanceState(Parcelable parcelable) {
            parcelable = (SavedState)parcelable;
            this.featureId = parcelable.featureId;
            this.wasLastOpen = parcelable.isOpen;
            this.frozenMenuState = parcelable.menuState;
            this.shownPanelView = null;
            this.decorView = null;
        }

        Parcelable onSaveInstanceState() {
            SavedState savedState = new SavedState();
            savedState.featureId = this.featureId;
            savedState.isOpen = this.isOpen;
            if (this.menu != null) {
                savedState.menuState = new Bundle();
                this.menu.savePresenterStates(savedState.menuState);
            }
            return savedState;
        }

        void setMenu(MenuBuilder menuBuilder) {
            MenuBuilder menuBuilder2 = this.menu;
            if (menuBuilder == menuBuilder2) {
                return;
            }
            if (menuBuilder2 != null) {
                menuBuilder2.removeMenuPresenter((MenuPresenter)this.listMenuPresenter);
            }
            this.menu = menuBuilder;
            if (menuBuilder != null && (menuBuilder2 = this.listMenuPresenter) != null) {
                menuBuilder.addMenuPresenter((MenuPresenter)menuBuilder2);
            }
        }

        void setStyle(Context context) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = context.getResources().newTheme();
            theme.setTo(context.getTheme());
            theme.resolveAttribute(R.attr.actionBarPopupTheme, typedValue, true);
            if (typedValue.resourceId != 0) {
                theme.applyStyle(typedValue.resourceId, true);
            }
            theme.resolveAttribute(R.attr.panelMenuListTheme, typedValue, true);
            if (typedValue.resourceId != 0) {
                theme.applyStyle(typedValue.resourceId, true);
            } else {
                theme.applyStyle(R.style.Theme_AppCompat_CompactMenu, true);
            }
            context = new ContextThemeWrapper(context, 0);
            context.getTheme().setTo(theme);
            this.listPresenterContext = context;
            context = context.obtainStyledAttributes(R.styleable.AppCompatTheme);
            this.background = context.getResourceId(R.styleable.AppCompatTheme_panelBackground, 0);
            this.windowAnimations = context.getResourceId(R.styleable.AppCompatTheme_android_windowAnimationStyle, 0);
            context.recycle();
        }

        private static class SavedState
        implements Parcelable {
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

                public SavedState createFromParcel(Parcel parcel) {
                    return SavedState.readFromParcel(parcel, null);
                }

                public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                    return SavedState.readFromParcel(parcel, classLoader);
                }

                public SavedState[] newArray(int n2) {
                    return new SavedState[n2];
                }
            };
            int featureId;
            boolean isOpen;
            Bundle menuState;

            SavedState() {
            }

            static SavedState readFromParcel(Parcel parcel, ClassLoader classLoader) {
                SavedState savedState = new SavedState();
                savedState.featureId = parcel.readInt();
                int n2 = parcel.readInt();
                boolean bl = true;
                if (n2 != 1) {
                    bl = false;
                }
                savedState.isOpen = bl;
                if (savedState.isOpen) {
                    savedState.menuState = parcel.readBundle(classLoader);
                }
                return savedState;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel parcel, int n2) {
                parcel.writeInt(this.featureId);
                parcel.writeInt(this.isOpen ? 1 : 0);
                if (this.isOpen) {
                    parcel.writeBundle(this.menuState);
                }
            }
        }
    }

    private final class PanelMenuPresenterCallback
    implements MenuPresenter.Callback {
        PanelMenuPresenterCallback() {
        }

        public void onCloseMenu(MenuBuilder object, boolean bl) {
            MenuBuilder menuBuilder = object.getRootMenu();
            boolean bl2 = menuBuilder != object;
            AppCompatDelegateImpl appCompatDelegateImpl = AppCompatDelegateImpl.this;
            if (bl2) {
                object = menuBuilder;
            }
            if ((object = appCompatDelegateImpl.findMenuPanel((Menu)object)) != null) {
                if (bl2) {
                    AppCompatDelegateImpl.this.callOnPanelClosed(object.featureId, (PanelFeatureState)object, (Menu)menuBuilder);
                    AppCompatDelegateImpl.this.closePanel((PanelFeatureState)object, true);
                } else {
                    AppCompatDelegateImpl.this.closePanel((PanelFeatureState)object, bl);
                }
            }
        }

        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            Window.Callback callback2;
            if (menuBuilder == menuBuilder.getRootMenu() && AppCompatDelegateImpl.this.mHasActionBar && (callback2 = AppCompatDelegateImpl.this.getWindowCallback()) != null && !AppCompatDelegateImpl.this.mIsDestroyed) {
                callback2.onMenuOpened(108, (Menu)menuBuilder);
            }
            return true;
        }
    }
}

