/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.MediaDescription;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.RemoteControlClient;
import android.media.VolumeProvider;
import android.media.session.MediaSession;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.IMediaControllerCallback;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.ParcelableVolumeInfo;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.ViewConfiguration;
import androidx.core.app.BundleCompat;
import androidx.media.MediaSessionManager;
import androidx.media.VolumeProviderCompat;
import androidx.media.session.MediaButtonReceiver;
import androidx.versionedparcelable.ParcelUtils;
import androidx.versionedparcelable.VersionedParcelable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MediaSessionCompat {
    public static final String ACTION_ARGUMENT_CAPTIONING_ENABLED = "android.support.v4.media.session.action.ARGUMENT_CAPTIONING_ENABLED";
    public static final String ACTION_ARGUMENT_EXTRAS = "android.support.v4.media.session.action.ARGUMENT_EXTRAS";
    public static final String ACTION_ARGUMENT_MEDIA_ID = "android.support.v4.media.session.action.ARGUMENT_MEDIA_ID";
    public static final String ACTION_ARGUMENT_PLAYBACK_SPEED = "android.support.v4.media.session.action.ARGUMENT_PLAYBACK_SPEED";
    public static final String ACTION_ARGUMENT_QUERY = "android.support.v4.media.session.action.ARGUMENT_QUERY";
    public static final String ACTION_ARGUMENT_RATING = "android.support.v4.media.session.action.ARGUMENT_RATING";
    public static final String ACTION_ARGUMENT_REPEAT_MODE = "android.support.v4.media.session.action.ARGUMENT_REPEAT_MODE";
    public static final String ACTION_ARGUMENT_SHUFFLE_MODE = "android.support.v4.media.session.action.ARGUMENT_SHUFFLE_MODE";
    public static final String ACTION_ARGUMENT_URI = "android.support.v4.media.session.action.ARGUMENT_URI";
    public static final String ACTION_FLAG_AS_INAPPROPRIATE = "android.support.v4.media.session.action.FLAG_AS_INAPPROPRIATE";
    public static final String ACTION_FOLLOW = "android.support.v4.media.session.action.FOLLOW";
    public static final String ACTION_PLAY_FROM_URI = "android.support.v4.media.session.action.PLAY_FROM_URI";
    public static final String ACTION_PREPARE = "android.support.v4.media.session.action.PREPARE";
    public static final String ACTION_PREPARE_FROM_MEDIA_ID = "android.support.v4.media.session.action.PREPARE_FROM_MEDIA_ID";
    public static final String ACTION_PREPARE_FROM_SEARCH = "android.support.v4.media.session.action.PREPARE_FROM_SEARCH";
    public static final String ACTION_PREPARE_FROM_URI = "android.support.v4.media.session.action.PREPARE_FROM_URI";
    public static final String ACTION_SET_CAPTIONING_ENABLED = "android.support.v4.media.session.action.SET_CAPTIONING_ENABLED";
    public static final String ACTION_SET_PLAYBACK_SPEED = "android.support.v4.media.session.action.SET_PLAYBACK_SPEED";
    public static final String ACTION_SET_RATING = "android.support.v4.media.session.action.SET_RATING";
    public static final String ACTION_SET_REPEAT_MODE = "android.support.v4.media.session.action.SET_REPEAT_MODE";
    public static final String ACTION_SET_SHUFFLE_MODE = "android.support.v4.media.session.action.SET_SHUFFLE_MODE";
    public static final String ACTION_SKIP_AD = "android.support.v4.media.session.action.SKIP_AD";
    public static final String ACTION_UNFOLLOW = "android.support.v4.media.session.action.UNFOLLOW";
    public static final String ARGUMENT_MEDIA_ATTRIBUTE = "android.support.v4.media.session.ARGUMENT_MEDIA_ATTRIBUTE";
    public static final String ARGUMENT_MEDIA_ATTRIBUTE_VALUE = "android.support.v4.media.session.ARGUMENT_MEDIA_ATTRIBUTE_VALUE";
    private static final String DATA_CALLING_PACKAGE = "data_calling_pkg";
    private static final String DATA_CALLING_PID = "data_calling_pid";
    private static final String DATA_CALLING_UID = "data_calling_uid";
    private static final String DATA_EXTRAS = "data_extras";
    @Deprecated
    public static final int FLAG_HANDLES_MEDIA_BUTTONS = 1;
    public static final int FLAG_HANDLES_QUEUE_COMMANDS = 4;
    @Deprecated
    public static final int FLAG_HANDLES_TRANSPORT_CONTROLS = 2;
    public static final String KEY_EXTRA_BINDER = "android.support.v4.media.session.EXTRA_BINDER";
    public static final String KEY_SESSION2_TOKEN = "android.support.v4.media.session.SESSION_TOKEN2";
    public static final String KEY_TOKEN = "android.support.v4.media.session.TOKEN";
    private static final int MAX_BITMAP_SIZE_IN_DP = 320;
    public static final int MEDIA_ATTRIBUTE_ALBUM = 1;
    public static final int MEDIA_ATTRIBUTE_ARTIST = 0;
    public static final int MEDIA_ATTRIBUTE_PLAYLIST = 2;
    static final String TAG = "MediaSessionCompat";
    static int sMaxBitmapSize;
    private final ArrayList<OnActiveChangeListener> mActiveListeners = new ArrayList();
    private final MediaControllerCompat mController;
    private final MediaSessionImpl mImpl;

    private MediaSessionCompat(Context context, MediaSessionImpl mediaSessionImpl) {
        this.mImpl = mediaSessionImpl;
        this.mController = new MediaControllerCompat(context, this);
    }

    public MediaSessionCompat(Context context, String string2) {
        this(context, string2, null, null);
    }

    public MediaSessionCompat(Context context, String string2, ComponentName componentName, PendingIntent pendingIntent) {
        this(context, string2, componentName, pendingIntent, null);
    }

    public MediaSessionCompat(Context context, String string2, ComponentName componentName, PendingIntent pendingIntent, Bundle bundle) {
        this(context, string2, componentName, pendingIntent, bundle, null);
    }

    public MediaSessionCompat(Context context, String string2, ComponentName componentName, PendingIntent pendingIntent, Bundle bundle, VersionedParcelable versionedParcelable) {
        if (context != null) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                ComponentName componentName2 = componentName;
                if (componentName == null) {
                    componentName2 = componentName = MediaButtonReceiver.getMediaButtonReceiverComponent((Context)context);
                    if (componentName == null) {
                        Log.w((String)TAG, (String)"Couldn't find a unique registered media button receiver in the given context.");
                        componentName2 = componentName;
                    }
                }
                componentName = pendingIntent;
                if (componentName2 != null) {
                    componentName = pendingIntent;
                    if (pendingIntent == null) {
                        componentName = new Intent("android.intent.action.MEDIA_BUTTON");
                        componentName.setComponent(componentName2);
                        componentName = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)componentName, (int)0);
                    }
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    string2 = this.createFwkMediaSession(context, string2, bundle);
                    this.mImpl = Build.VERSION.SDK_INT >= 29 ? new MediaSessionImplApi29((MediaSession)string2, versionedParcelable, bundle) : (Build.VERSION.SDK_INT >= 28 ? new MediaSessionImplApi28((MediaSession)string2, versionedParcelable, bundle) : new MediaSessionImplApi21((MediaSession)string2, versionedParcelable, bundle));
                    string2 = Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper();
                    string2 = new Handler((Looper)string2);
                    this.setCallback(new Callback(){}, (Handler)string2);
                    this.mImpl.setMediaButtonReceiver((PendingIntent)componentName);
                } else {
                    this.mImpl = Build.VERSION.SDK_INT >= 19 ? new MediaSessionImplApi19(context, string2, componentName2, (PendingIntent)componentName, versionedParcelable, bundle) : (Build.VERSION.SDK_INT >= 18 ? new MediaSessionImplApi18(context, string2, componentName2, (PendingIntent)componentName, versionedParcelable, bundle) : new MediaSessionImplBase(context, string2, componentName2, (PendingIntent)componentName, versionedParcelable, bundle));
                }
                this.mController = new MediaControllerCompat(context, this);
                if (sMaxBitmapSize == 0) {
                    sMaxBitmapSize = (int)(TypedValue.applyDimension((int)1, (float)320.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
                }
                return;
            }
            throw new IllegalArgumentException("tag must not be null or empty");
        }
        throw new IllegalArgumentException("context must not be null");
    }

    private MediaSession createFwkMediaSession(Context context, String string2, Bundle bundle) {
        if (Build.VERSION.SDK_INT >= 29) {
            return new MediaSession(context, string2, bundle);
        }
        return new MediaSession(context, string2);
    }

    public static void ensureClassLoader(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(MediaSessionCompat.class.getClassLoader());
        }
    }

    public static MediaSessionCompat fromMediaSession(Context context, Object object) {
        if (Build.VERSION.SDK_INT >= 21 && context != null && object != null) {
            object = Build.VERSION.SDK_INT >= 29 ? new MediaSessionImplApi29(object) : (Build.VERSION.SDK_INT >= 28 ? new MediaSessionImplApi28(object) : new MediaSessionImplApi21(object));
            return new MediaSessionCompat(context, (MediaSessionImpl)object);
        }
        return null;
    }

    static PlaybackStateCompat getStateWithUpdatedPosition(PlaybackStateCompat playbackStateCompat, MediaMetadataCompat mediaMetadataCompat) {
        PlaybackStateCompat playbackStateCompat2;
        block7: {
            long l2;
            long l3;
            block9: {
                block8: {
                    playbackStateCompat2 = playbackStateCompat;
                    if (playbackStateCompat == null) break block7;
                    l3 = playbackStateCompat.getPosition();
                    l2 = -1L;
                    if (l3 != -1L) break block8;
                    playbackStateCompat2 = playbackStateCompat;
                    break block7;
                }
                if (playbackStateCompat.getState() == 3 || playbackStateCompat.getState() == 4) break block9;
                playbackStateCompat2 = playbackStateCompat;
                if (playbackStateCompat.getState() != 5) break block7;
            }
            l3 = playbackStateCompat.getLastPositionUpdateTime();
            playbackStateCompat2 = playbackStateCompat;
            if (l3 > 0L) {
                long l4 = SystemClock.elapsedRealtime();
                long l5 = (long)(playbackStateCompat.getPlaybackSpeed() * (float)(l4 - l3)) + playbackStateCompat.getPosition();
                l3 = l2;
                if (mediaMetadataCompat != null) {
                    l3 = l2;
                    if (mediaMetadataCompat.containsKey("android.media.metadata.DURATION")) {
                        l3 = mediaMetadataCompat.getLong("android.media.metadata.DURATION");
                    }
                }
                if (l3 < 0L || l5 <= l3) {
                    l3 = l5 < 0L ? 0L : l5;
                }
                playbackStateCompat2 = new PlaybackStateCompat.Builder(playbackStateCompat).setState(playbackStateCompat.getState(), l3, playbackStateCompat.getPlaybackSpeed(), l4).build();
            }
        }
        return playbackStateCompat2;
    }

    public static Bundle unparcelWithClassLoader(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        MediaSessionCompat.ensureClassLoader(bundle);
        try {
            bundle.isEmpty();
            return bundle;
        }
        catch (BadParcelableException badParcelableException) {
            Log.e((String)TAG, (String)"Could not unparcel the data.");
            return null;
        }
    }

    public void addOnActiveChangeListener(OnActiveChangeListener onActiveChangeListener) {
        if (onActiveChangeListener != null) {
            this.mActiveListeners.add(onActiveChangeListener);
            return;
        }
        throw new IllegalArgumentException("Listener may not be null");
    }

    public String getCallingPackage() {
        return this.mImpl.getCallingPackage();
    }

    public MediaControllerCompat getController() {
        return this.mController;
    }

    public final MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
        return this.mImpl.getCurrentControllerInfo();
    }

    public Object getMediaSession() {
        return this.mImpl.getMediaSession();
    }

    public Object getRemoteControlClient() {
        return this.mImpl.getRemoteControlClient();
    }

    public Token getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public boolean isActive() {
        return this.mImpl.isActive();
    }

    public void release() {
        this.mImpl.release();
    }

    public void removeOnActiveChangeListener(OnActiveChangeListener onActiveChangeListener) {
        if (onActiveChangeListener != null) {
            this.mActiveListeners.remove(onActiveChangeListener);
            return;
        }
        throw new IllegalArgumentException("Listener may not be null");
    }

    public void sendSessionEvent(String string2, Bundle bundle) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mImpl.sendSessionEvent(string2, bundle);
            return;
        }
        throw new IllegalArgumentException("event cannot be null or empty");
    }

    public void setActive(boolean bl) {
        this.mImpl.setActive(bl);
        Iterator<OnActiveChangeListener> iterator2 = this.mActiveListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onActiveChanged();
        }
    }

    public void setCallback(Callback callback2) {
        this.setCallback(callback2, null);
    }

    public void setCallback(Callback callback2, Handler handler) {
        if (callback2 == null) {
            this.mImpl.setCallback(null, null);
        } else {
            MediaSessionImpl mediaSessionImpl = this.mImpl;
            if (handler == null) {
                handler = new Handler();
            }
            mediaSessionImpl.setCallback(callback2, handler);
        }
    }

    public void setCaptioningEnabled(boolean bl) {
        this.mImpl.setCaptioningEnabled(bl);
    }

    public void setExtras(Bundle bundle) {
        this.mImpl.setExtras(bundle);
    }

    public void setFlags(int n2) {
        this.mImpl.setFlags(n2);
    }

    public void setMediaButtonReceiver(PendingIntent pendingIntent) {
        this.mImpl.setMediaButtonReceiver(pendingIntent);
    }

    public void setMetadata(MediaMetadataCompat mediaMetadataCompat) {
        this.mImpl.setMetadata(mediaMetadataCompat);
    }

    public void setPlaybackState(PlaybackStateCompat playbackStateCompat) {
        this.mImpl.setPlaybackState(playbackStateCompat);
    }

    public void setPlaybackToLocal(int n2) {
        this.mImpl.setPlaybackToLocal(n2);
    }

    public void setPlaybackToRemote(VolumeProviderCompat volumeProviderCompat) {
        if (volumeProviderCompat != null) {
            this.mImpl.setPlaybackToRemote(volumeProviderCompat);
            return;
        }
        throw new IllegalArgumentException("volumeProvider may not be null!");
    }

    public void setQueue(List<QueueItem> list) {
        if (list != null) {
            HashSet<Long> hashSet = new HashSet<Long>();
            for (QueueItem queueItem : list) {
                if (queueItem != null) {
                    if (hashSet.contains(queueItem.getQueueId())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Found duplicate queue id: ");
                        stringBuilder.append(queueItem.getQueueId());
                        Log.e((String)TAG, (String)stringBuilder.toString(), (Throwable)new IllegalArgumentException("id of each queue item should be unique"));
                    }
                    hashSet.add(queueItem.getQueueId());
                    continue;
                }
                throw new IllegalArgumentException("queue shouldn't have null items");
            }
        }
        this.mImpl.setQueue(list);
    }

    public void setQueueTitle(CharSequence charSequence) {
        this.mImpl.setQueueTitle(charSequence);
    }

    public void setRatingType(int n2) {
        this.mImpl.setRatingType(n2);
    }

    public void setRepeatMode(int n2) {
        this.mImpl.setRepeatMode(n2);
    }

    public void setSessionActivity(PendingIntent pendingIntent) {
        this.mImpl.setSessionActivity(pendingIntent);
    }

    public void setShuffleMode(int n2) {
        this.mImpl.setShuffleMode(n2);
    }

    public static abstract class Callback {
        final MediaSession.Callback mCallbackFwk;
        CallbackHandler mCallbackHandler;
        final Object mLock = new Object();
        private boolean mMediaPlayPausePendingOnHandler;
        WeakReference<MediaSessionImpl> mSessionImpl;

        public Callback() {
            this.mCallbackFwk = Build.VERSION.SDK_INT >= 21 ? new MediaSessionCallbackApi21() : null;
            this.mSessionImpl = new WeakReference<Object>(null);
        }

        void handleMediaPlayPauseIfPendingOnHandler(MediaSessionImpl object, Handler handler) {
            if (!this.mMediaPlayPausePendingOnHandler) {
                return;
            }
            boolean bl = false;
            this.mMediaPlayPausePendingOnHandler = false;
            handler.removeMessages(1);
            object = object.getPlaybackState();
            long l2 = object == null ? 0L : ((PlaybackStateCompat)object).getActions();
            boolean bl2 = object != null && ((PlaybackStateCompat)object).getState() == 3;
            boolean bl3 = (0x204L & l2) != 0L;
            if ((l2 & 0x202L) != 0L) {
                bl = true;
            }
            if (bl2 && bl) {
                this.onPause();
            } else if (!bl2 && bl3) {
                this.onPlay();
            }
        }

        public void onAddQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
        }

        public void onAddQueueItem(MediaDescriptionCompat mediaDescriptionCompat, int n2) {
        }

        public void onCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
        }

        public void onCustomAction(String string2, Bundle bundle) {
        }

        public void onFastForward() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean onMediaButtonEvent(Intent object) {
            CallbackHandler callbackHandler;
            MediaSessionImpl mediaSessionImpl;
            if (Build.VERSION.SDK_INT >= 27) {
                return false;
            }
            Object object2 = this.mLock;
            synchronized (object2) {
                mediaSessionImpl = (MediaSessionImpl)this.mSessionImpl.get();
                callbackHandler = this.mCallbackHandler;
            }
            if (mediaSessionImpl == null) return false;
            if (callbackHandler == null) {
                return false;
            }
            object2 = (KeyEvent)object.getParcelableExtra("android.intent.extra.KEY_EVENT");
            if (object2 == null) return false;
            if (object2.getAction() != 0) {
                return false;
            }
            object = mediaSessionImpl.getCurrentControllerInfo();
            int n2 = object2.getKeyCode();
            if (n2 != 79 && n2 != 85) {
                this.handleMediaPlayPauseIfPendingOnHandler(mediaSessionImpl, callbackHandler);
                return false;
            }
            if (object2.getRepeatCount() != 0) {
                this.handleMediaPlayPauseIfPendingOnHandler(mediaSessionImpl, callbackHandler);
                return true;
            }
            if (!this.mMediaPlayPausePendingOnHandler) {
                this.mMediaPlayPausePendingOnHandler = true;
                callbackHandler.sendMessageDelayed(callbackHandler.obtainMessage(1, object), ViewConfiguration.getDoubleTapTimeout());
                return true;
            }
            callbackHandler.removeMessages(1);
            this.mMediaPlayPausePendingOnHandler = false;
            object = mediaSessionImpl.getPlaybackState();
            long l2 = object == null ? 0L : ((PlaybackStateCompat)object).getActions();
            if ((l2 & 0x20L) == 0L) return true;
            this.onSkipToNext();
            return true;
        }

        public void onPause() {
        }

        public void onPlay() {
        }

        public void onPlayFromMediaId(String string2, Bundle bundle) {
        }

        public void onPlayFromSearch(String string2, Bundle bundle) {
        }

        public void onPlayFromUri(Uri uri, Bundle bundle) {
        }

        public void onPrepare() {
        }

        public void onPrepareFromMediaId(String string2, Bundle bundle) {
        }

        public void onPrepareFromSearch(String string2, Bundle bundle) {
        }

        public void onPrepareFromUri(Uri uri, Bundle bundle) {
        }

        public void onRemoveQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
        }

        @Deprecated
        public void onRemoveQueueItemAt(int n2) {
        }

        public void onRewind() {
        }

        public void onSeekTo(long l2) {
        }

        public void onSetCaptioningEnabled(boolean bl) {
        }

        public void onSetPlaybackSpeed(float f2) {
        }

        public void onSetRating(RatingCompat ratingCompat) {
        }

        public void onSetRating(RatingCompat ratingCompat, Bundle bundle) {
        }

        public void onSetRepeatMode(int n2) {
        }

        public void onSetShuffleMode(int n2) {
        }

        public void onSkipToNext() {
        }

        public void onSkipToPrevious() {
        }

        public void onSkipToQueueItem(long l2) {
        }

        public void onStop() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void setSessionImpl(MediaSessionImpl mediaSessionImpl, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                Object object2 = new Object(mediaSessionImpl);
                this.mSessionImpl = object2;
                object2 = this.mCallbackHandler;
                Object var5_5 = null;
                if (object2 != null) {
                    this.mCallbackHandler.removeCallbacksAndMessages(null);
                }
                object2 = var5_5;
                if (mediaSessionImpl != null) {
                    object2 = handler == null ? var5_5 : new CallbackHandler(handler.getLooper());
                }
                this.mCallbackHandler = object2;
                return;
            }
        }

        private class CallbackHandler
        extends Handler {
            private static final int MSG_MEDIA_PLAY_PAUSE_KEY_DOUBLE_TAP_TIMEOUT = 1;

            CallbackHandler(Looper looper) {
                super(looper);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handleMessage(Message message) {
                CallbackHandler callbackHandler;
                MediaSessionImpl mediaSessionImpl;
                if (message.what != 1) return;
                Object object = Callback.this.mLock;
                synchronized (object) {
                    mediaSessionImpl = (MediaSessionImpl)Callback.this.mSessionImpl.get();
                    callbackHandler = Callback.this.mCallbackHandler;
                }
                if (mediaSessionImpl == null) return;
                if (Callback.this != mediaSessionImpl.getCallback()) return;
                if (callbackHandler == null) {
                    return;
                }
                mediaSessionImpl.setCurrentControllerInfo((MediaSessionManager.RemoteUserInfo)message.obj);
                Callback.this.handleMediaPlayPauseIfPendingOnHandler(mediaSessionImpl, callbackHandler);
                mediaSessionImpl.setCurrentControllerInfo(null);
            }
        }

        private class MediaSessionCallbackApi21
        extends MediaSession.Callback {
            MediaSessionCallbackApi21() {
            }

            private void clearCurrentControllerInfo(MediaSessionImpl mediaSessionImpl) {
                mediaSessionImpl.setCurrentControllerInfo(null);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private MediaSessionImplApi21 getSessionImplIfCallbackIsSet() {
                MediaSessionImplApi21 mediaSessionImplApi21;
                Object object = Callback.this.mLock;
                synchronized (object) {
                    mediaSessionImplApi21 = (MediaSessionImplApi21)Callback.this.mSessionImpl.get();
                }
                if (Callback.this != mediaSessionImplApi21.getCallback()) return null;
                return mediaSessionImplApi21;
            }

            private void setCurrentControllerInfo(MediaSessionImpl mediaSessionImpl) {
                String string2;
                if (Build.VERSION.SDK_INT >= 28) {
                    return;
                }
                String string3 = string2 = mediaSessionImpl.getCallingPackage();
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    string3 = "android.media.session.MediaController";
                }
                mediaSessionImpl.setCurrentControllerInfo(new MediaSessionManager.RemoteUserInfo(string3, -1, -1));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onCommand(String object, Bundle bundle, ResultReceiver resultReceiver) {
                MediaSessionImplApi21 mediaSessionImplApi21;
                block11: {
                    mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                    if (mediaSessionImplApi21 == null) {
                        return;
                    }
                    MediaSessionCompat.ensureClassLoader(bundle);
                    this.setCurrentControllerInfo(mediaSessionImplApi21);
                    try {
                        boolean bl = ((String)object).equals("android.support.v4.media.session.command.GET_EXTRA_BINDER");
                        Token token = null;
                        Object var7_8 = null;
                        if (bl) {
                            bundle = new Bundle();
                            token = mediaSessionImplApi21.getSessionToken();
                            object = token.getExtraBinder();
                            object = object == null ? var7_8 : object.asBinder();
                            BundleCompat.putBinder((Bundle)bundle, (String)MediaSessionCompat.KEY_EXTRA_BINDER, (IBinder)object);
                            ParcelUtils.putVersionedParcelable((Bundle)bundle, (String)MediaSessionCompat.KEY_SESSION2_TOKEN, (VersionedParcelable)token.getSession2Token());
                            resultReceiver.send(0, bundle);
                            break block11;
                        }
                        bl = ((String)object).equals("android.support.v4.media.session.command.ADD_QUEUE_ITEM");
                        if (bl) {
                            Callback.this.onAddQueueItem((MediaDescriptionCompat)bundle.getParcelable("android.support.v4.media.session.command.ARGUMENT_MEDIA_DESCRIPTION"));
                            break block11;
                        }
                        bl = ((String)object).equals("android.support.v4.media.session.command.ADD_QUEUE_ITEM_AT");
                        if (bl) {
                            Callback.this.onAddQueueItem((MediaDescriptionCompat)bundle.getParcelable("android.support.v4.media.session.command.ARGUMENT_MEDIA_DESCRIPTION"), bundle.getInt("android.support.v4.media.session.command.ARGUMENT_INDEX"));
                            break block11;
                        }
                        if (((String)object).equals("android.support.v4.media.session.command.REMOVE_QUEUE_ITEM")) {
                            Callback.this.onRemoveQueueItem((MediaDescriptionCompat)bundle.getParcelable("android.support.v4.media.session.command.ARGUMENT_MEDIA_DESCRIPTION"));
                            break block11;
                        }
                        if (((String)object).equals("android.support.v4.media.session.command.REMOVE_QUEUE_ITEM_AT")) {
                            if (mediaSessionImplApi21.mQueue == null) break block11;
                            int n2 = bundle.getInt("android.support.v4.media.session.command.ARGUMENT_INDEX", -1);
                            object = token;
                            if (n2 >= 0) {
                                object = token;
                                if (n2 < mediaSessionImplApi21.mQueue.size()) {
                                    object = mediaSessionImplApi21.mQueue.get(n2);
                                }
                            }
                            if (object != null) {
                                Callback.this.onRemoveQueueItem(((QueueItem)object).getDescription());
                            }
                            break block11;
                        }
                        Callback.this.onCommand((String)object, bundle, resultReceiver);
                    }
                    catch (BadParcelableException badParcelableException) {
                        Log.e((String)MediaSessionCompat.TAG, (String)"Could not unparcel the extra data.");
                    }
                }
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onCustomAction(String object, Bundle bundle) {
                MediaSessionImplApi21 mediaSessionImplApi21;
                block14: {
                    mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                    if (mediaSessionImplApi21 == null) {
                        return;
                    }
                    MediaSessionCompat.ensureClassLoader(bundle);
                    this.setCurrentControllerInfo(mediaSessionImplApi21);
                    try {
                        boolean bl = ((String)object).equals(MediaSessionCompat.ACTION_PLAY_FROM_URI);
                        if (bl) {
                            object = (Uri)bundle.getParcelable(MediaSessionCompat.ACTION_ARGUMENT_URI);
                            bundle = bundle.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                            MediaSessionCompat.ensureClassLoader(bundle);
                            Callback.this.onPlayFromUri((Uri)object, bundle);
                            break block14;
                        }
                        if (((String)object).equals(MediaSessionCompat.ACTION_PREPARE)) {
                            Callback.this.onPrepare();
                            break block14;
                        }
                        if (((String)object).equals(MediaSessionCompat.ACTION_PREPARE_FROM_MEDIA_ID)) {
                            object = bundle.getString(MediaSessionCompat.ACTION_ARGUMENT_MEDIA_ID);
                            bundle = bundle.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                            MediaSessionCompat.ensureClassLoader(bundle);
                            Callback.this.onPrepareFromMediaId((String)object, bundle);
                            break block14;
                        }
                        if (((String)object).equals(MediaSessionCompat.ACTION_PREPARE_FROM_SEARCH)) {
                            object = bundle.getString(MediaSessionCompat.ACTION_ARGUMENT_QUERY);
                            bundle = bundle.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                            MediaSessionCompat.ensureClassLoader(bundle);
                            Callback.this.onPrepareFromSearch((String)object, bundle);
                            break block14;
                        }
                        if (((String)object).equals(MediaSessionCompat.ACTION_PREPARE_FROM_URI)) {
                            object = (Uri)bundle.getParcelable(MediaSessionCompat.ACTION_ARGUMENT_URI);
                            bundle = bundle.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                            MediaSessionCompat.ensureClassLoader(bundle);
                            Callback.this.onPrepareFromUri((Uri)object, bundle);
                            break block14;
                        }
                        if (((String)object).equals(MediaSessionCompat.ACTION_SET_CAPTIONING_ENABLED)) {
                            bl = bundle.getBoolean(MediaSessionCompat.ACTION_ARGUMENT_CAPTIONING_ENABLED);
                            Callback.this.onSetCaptioningEnabled(bl);
                            break block14;
                        }
                        if (((String)object).equals(MediaSessionCompat.ACTION_SET_REPEAT_MODE)) {
                            int n2 = bundle.getInt(MediaSessionCompat.ACTION_ARGUMENT_REPEAT_MODE);
                            Callback.this.onSetRepeatMode(n2);
                            break block14;
                        }
                        if (((String)object).equals(MediaSessionCompat.ACTION_SET_SHUFFLE_MODE)) {
                            int n3 = bundle.getInt(MediaSessionCompat.ACTION_ARGUMENT_SHUFFLE_MODE);
                            Callback.this.onSetShuffleMode(n3);
                            break block14;
                        }
                        if (((String)object).equals(MediaSessionCompat.ACTION_SET_RATING)) {
                            object = (RatingCompat)bundle.getParcelable(MediaSessionCompat.ACTION_ARGUMENT_RATING);
                            bundle = bundle.getBundle(MediaSessionCompat.ACTION_ARGUMENT_EXTRAS);
                            MediaSessionCompat.ensureClassLoader(bundle);
                            Callback.this.onSetRating((RatingCompat)object, bundle);
                            break block14;
                        }
                        if (((String)object).equals(MediaSessionCompat.ACTION_SET_PLAYBACK_SPEED)) {
                            float f2 = bundle.getFloat(MediaSessionCompat.ACTION_ARGUMENT_PLAYBACK_SPEED, 1.0f);
                            Callback.this.onSetPlaybackSpeed(f2);
                        } else {
                            Callback.this.onCustomAction((String)object, bundle);
                        }
                    }
                    catch (BadParcelableException badParcelableException) {
                        Log.e((String)MediaSessionCompat.TAG, (String)"Could not unparcel the data.");
                    }
                }
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onFastForward() {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onFastForward();
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public boolean onMediaButtonEvent(Intent intent) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                boolean bl = false;
                if (mediaSessionImplApi21 == null) {
                    return false;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                boolean bl2 = Callback.this.onMediaButtonEvent(intent);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
                if (bl2 || super.onMediaButtonEvent(intent)) {
                    bl = true;
                }
                return bl;
            }

            public void onPause() {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onPause();
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onPlay() {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onPlay();
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onPlayFromMediaId(String string2, Bundle bundle) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(bundle);
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onPlayFromMediaId(string2, bundle);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onPlayFromSearch(String string2, Bundle bundle) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(bundle);
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onPlayFromSearch(string2, bundle);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onPlayFromUri(Uri uri, Bundle bundle) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(bundle);
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onPlayFromUri(uri, bundle);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onPrepare() {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onPrepare();
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onPrepareFromMediaId(String string2, Bundle bundle) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(bundle);
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onPrepareFromMediaId(string2, bundle);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onPrepareFromSearch(String string2, Bundle bundle) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(bundle);
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onPrepareFromSearch(string2, bundle);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onPrepareFromUri(Uri uri, Bundle bundle) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                MediaSessionCompat.ensureClassLoader(bundle);
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onPrepareFromUri(uri, bundle);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onRewind() {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onRewind();
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onSeekTo(long l2) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onSeekTo(l2);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onSetPlaybackSpeed(float f2) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onSetPlaybackSpeed(f2);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onSetRating(Rating rating) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onSetRating(RatingCompat.fromRating(rating));
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onSetRating(Rating rating, Bundle bundle) {
            }

            public void onSkipToNext() {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onSkipToNext();
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onSkipToPrevious() {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onSkipToPrevious();
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onSkipToQueueItem(long l2) {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onSkipToQueueItem(l2);
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }

            public void onStop() {
                MediaSessionImplApi21 mediaSessionImplApi21 = this.getSessionImplIfCallbackIsSet();
                if (mediaSessionImplApi21 == null) {
                    return;
                }
                this.setCurrentControllerInfo(mediaSessionImplApi21);
                Callback.this.onStop();
                this.clearCurrentControllerInfo(mediaSessionImplApi21);
            }
        }
    }

    static interface MediaSessionImpl {
        public Callback getCallback();

        public String getCallingPackage();

        public MediaSessionManager.RemoteUserInfo getCurrentControllerInfo();

        public Object getMediaSession();

        public PlaybackStateCompat getPlaybackState();

        public Object getRemoteControlClient();

        public Token getSessionToken();

        public boolean isActive();

        public void release();

        public void sendSessionEvent(String var1, Bundle var2);

        public void setActive(boolean var1);

        public void setCallback(Callback var1, Handler var2);

        public void setCaptioningEnabled(boolean var1);

        public void setCurrentControllerInfo(MediaSessionManager.RemoteUserInfo var1);

        public void setExtras(Bundle var1);

        public void setFlags(int var1);

        public void setMediaButtonReceiver(PendingIntent var1);

        public void setMetadata(MediaMetadataCompat var1);

        public void setPlaybackState(PlaybackStateCompat var1);

        public void setPlaybackToLocal(int var1);

        public void setPlaybackToRemote(VolumeProviderCompat var1);

        public void setQueue(List<QueueItem> var1);

        public void setQueueTitle(CharSequence var1);

        public void setRatingType(int var1);

        public void setRepeatMode(int var1);

        public void setSessionActivity(PendingIntent var1);

        public void setShuffleMode(int var1);
    }

    static class MediaSessionImplApi18
    extends MediaSessionImplBase {
        private static boolean sIsMbrPendingIntentSupported = true;

        MediaSessionImplApi18(Context context, String string2, ComponentName componentName, PendingIntent pendingIntent, VersionedParcelable versionedParcelable, Bundle bundle) {
            super(context, string2, componentName, pendingIntent, versionedParcelable, bundle);
        }

        @Override
        int getRccTransportControlFlagsFromActions(long l2) {
            int n2;
            int n3 = n2 = super.getRccTransportControlFlagsFromActions(l2);
            if ((l2 & 0x100L) != 0L) {
                n3 = n2 | 0x100;
            }
            return n3;
        }

        @Override
        void registerMediaButtonEventReceiver(PendingIntent pendingIntent, ComponentName componentName) {
            if (sIsMbrPendingIntentSupported) {
                try {
                    this.mAudioManager.registerMediaButtonEventReceiver(pendingIntent);
                }
                catch (NullPointerException nullPointerException) {
                    Log.w((String)MediaSessionCompat.TAG, (String)"Unable to register media button event receiver with PendingIntent, falling back to ComponentName.");
                    sIsMbrPendingIntentSupported = false;
                }
            }
            if (!sIsMbrPendingIntentSupported) {
                super.registerMediaButtonEventReceiver(pendingIntent, componentName);
            }
        }

        @Override
        public void setCallback(Callback object, Handler handler) {
            super.setCallback((Callback)object, handler);
            if (object == null) {
                this.mRcc.setPlaybackPositionUpdateListener(null);
            } else {
                object = new RemoteControlClient.OnPlaybackPositionUpdateListener(){

                    public void onPlaybackPositionUpdate(long l2) {
                        MediaSessionImplApi18.this.postToHandler(18, -1, -1, l2, null);
                    }
                };
                this.mRcc.setPlaybackPositionUpdateListener((RemoteControlClient.OnPlaybackPositionUpdateListener)object);
            }
        }

        @Override
        void setRccState(PlaybackStateCompat playbackStateCompat) {
            long l2 = playbackStateCompat.getPosition();
            float f2 = playbackStateCompat.getPlaybackSpeed();
            long l3 = playbackStateCompat.getLastPositionUpdateTime();
            long l4 = SystemClock.elapsedRealtime();
            long l5 = l2;
            if (playbackStateCompat.getState() == 3) {
                long l6 = 0L;
                l5 = l2;
                if (l2 > 0L) {
                    l5 = l6;
                    if (l3 > 0L) {
                        l5 = l6 = l4 - l3;
                        if (f2 > 0.0f) {
                            l5 = l6;
                            if (f2 != 1.0f) {
                                l5 = (long)((float)l6 * f2);
                            }
                        }
                    }
                    l5 = l2 + l5;
                }
            }
            this.mRcc.setPlaybackState(this.getRccStateFromState(playbackStateCompat.getState()), l5, f2);
        }

        @Override
        void unregisterMediaButtonEventReceiver(PendingIntent pendingIntent, ComponentName componentName) {
            if (sIsMbrPendingIntentSupported) {
                this.mAudioManager.unregisterMediaButtonEventReceiver(pendingIntent);
            } else {
                super.unregisterMediaButtonEventReceiver(pendingIntent, componentName);
            }
        }
    }

    static class MediaSessionImplApi19
    extends MediaSessionImplApi18 {
        MediaSessionImplApi19(Context context, String string2, ComponentName componentName, PendingIntent pendingIntent, VersionedParcelable versionedParcelable, Bundle bundle) {
            super(context, string2, componentName, pendingIntent, versionedParcelable, bundle);
        }

        @Override
        RemoteControlClient.MetadataEditor buildRccMetadata(Bundle bundle) {
            RemoteControlClient.MetadataEditor metadataEditor = super.buildRccMetadata(bundle);
            long l2 = this.mState == null ? 0L : this.mState.getActions();
            if ((l2 & 0x80L) != 0L) {
                metadataEditor.addEditableKey(0x10000001);
            }
            if (bundle == null) {
                return metadataEditor;
            }
            if (bundle.containsKey("android.media.metadata.YEAR")) {
                metadataEditor.putLong(8, bundle.getLong("android.media.metadata.YEAR"));
            }
            if (bundle.containsKey("android.media.metadata.RATING")) {
                metadataEditor.putObject(101, (Object)bundle.getParcelable("android.media.metadata.RATING"));
            }
            if (bundle.containsKey("android.media.metadata.USER_RATING")) {
                metadataEditor.putObject(0x10000001, (Object)bundle.getParcelable("android.media.metadata.USER_RATING"));
            }
            return metadataEditor;
        }

        @Override
        int getRccTransportControlFlagsFromActions(long l2) {
            int n2;
            int n3 = n2 = super.getRccTransportControlFlagsFromActions(l2);
            if ((l2 & 0x80L) != 0L) {
                n3 = n2 | 0x200;
            }
            return n3;
        }

        @Override
        public void setCallback(Callback object, Handler handler) {
            super.setCallback((Callback)object, handler);
            if (object == null) {
                this.mRcc.setMetadataUpdateListener(null);
            } else {
                object = new RemoteControlClient.OnMetadataUpdateListener(){

                    public void onMetadataUpdate(int n2, Object object) {
                        if (n2 == 0x10000001 && object instanceof Rating) {
                            MediaSessionImplApi19.this.postToHandler(19, -1, -1, RatingCompat.fromRating(object), null);
                        }
                    }
                };
                this.mRcc.setMetadataUpdateListener((RemoteControlClient.OnMetadataUpdateListener)object);
            }
        }
    }

    static class MediaSessionImplApi21
    implements MediaSessionImpl {
        Callback mCallback;
        boolean mCaptioningEnabled;
        boolean mDestroyed = false;
        final RemoteCallbackList<IMediaControllerCallback> mExtraControllerCallbacks;
        final Object mLock = new Object();
        MediaMetadataCompat mMetadata;
        PlaybackStateCompat mPlaybackState;
        List<QueueItem> mQueue;
        int mRatingType;
        MediaSessionManager.RemoteUserInfo mRemoteUserInfo;
        int mRepeatMode;
        final MediaSession mSessionFwk;
        Bundle mSessionInfo;
        int mShuffleMode;
        final Token mToken;

        MediaSessionImplApi21(MediaSession mediaSession, VersionedParcelable versionedParcelable, Bundle bundle) {
            this.mExtraControllerCallbacks = new RemoteCallbackList();
            this.mSessionFwk = mediaSession;
            this.mToken = new Token(this.mSessionFwk.getSessionToken(), (IMediaSession)new ExtraSession(), versionedParcelable);
            this.mSessionInfo = bundle;
            this.setFlags(3);
        }

        MediaSessionImplApi21(Object object) {
            this.mExtraControllerCallbacks = new RemoteCallbackList();
            if (object instanceof MediaSession) {
                this.mSessionFwk = (MediaSession)object;
                this.mToken = new Token(this.mSessionFwk.getSessionToken(), (IMediaSession)new ExtraSession());
                this.mSessionInfo = null;
                this.setFlags(3);
                return;
            }
            throw new IllegalArgumentException("mediaSession is not a valid MediaSession object");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Callback getCallback() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mCallback;
            }
        }

        @Override
        public String getCallingPackage() {
            if (Build.VERSION.SDK_INT < 24) {
                return null;
            }
            try {
                String string2 = (String)this.mSessionFwk.getClass().getMethod("getCallingPackage", new Class[0]).invoke((Object)this.mSessionFwk, new Object[0]);
                return string2;
            }
            catch (Exception exception) {
                Log.e((String)MediaSessionCompat.TAG, (String)"Cannot execute MediaSession.getCallingPackage()", (Throwable)exception);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mRemoteUserInfo;
            }
        }

        @Override
        public Object getMediaSession() {
            return this.mSessionFwk;
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            return this.mPlaybackState;
        }

        @Override
        public Object getRemoteControlClient() {
            return null;
        }

        @Override
        public Token getSessionToken() {
            return this.mToken;
        }

        @Override
        public boolean isActive() {
            return this.mSessionFwk.isActive();
        }

        @Override
        public void release() {
            block4: {
                this.mDestroyed = true;
                this.mExtraControllerCallbacks.kill();
                if (Build.VERSION.SDK_INT == 27) {
                    Field field = this.mSessionFwk.getClass().getDeclaredField("mCallback");
                    field.setAccessible(true);
                    field = (Handler)field.get(this.mSessionFwk);
                    if (field == null) break block4;
                    try {
                        field.removeCallbacksAndMessages(null);
                    }
                    catch (Exception exception) {
                        Log.w((String)MediaSessionCompat.TAG, (String)"Exception happened while accessing MediaSession.mCallback.", (Throwable)exception);
                    }
                }
            }
            this.mSessionFwk.setCallback(null);
            this.mSessionFwk.release();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void sendSessionEvent(String var1_1, Bundle var2_2) {
            if (Build.VERSION.SDK_INT < 23) {
                block2: for (var3_3 = this.mExtraControllerCallbacks.beginBroadcast() - 1; var3_3 >= 0; --var3_3) {
                    var4_4 = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(var3_3);
                    var4_4.onEvent(var1_1, var2_2);
lbl6:
                    // 2 sources

                    continue block2;
                }
                this.mExtraControllerCallbacks.finishBroadcast();
            }
            this.mSessionFwk.sendSessionEvent(var1_1, var2_2);
            return;
            catch (RemoteException var4_5) {
                ** continue;
            }
        }

        @Override
        public void setActive(boolean bl) {
            this.mSessionFwk.setActive(bl);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setCallback(Callback callback2, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                this.mCallback = callback2;
                MediaSession mediaSession = this.mSessionFwk;
                MediaSession.Callback callback3 = callback2 == null ? null : callback2.mCallbackFwk;
                mediaSession.setCallback(callback3, handler);
                if (callback2 != null) {
                    callback2.setSessionImpl(this, handler);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        @Override
        public void setCaptioningEnabled(boolean bl) {
            if (this.mCaptioningEnabled == bl) return;
            this.mCaptioningEnabled = bl;
            int n2 = this.mExtraControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mExtraControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onCaptioningEnabledChanged(bl);
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setCurrentControllerInfo(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRemoteUserInfo = remoteUserInfo;
                return;
            }
        }

        @Override
        public void setExtras(Bundle bundle) {
            this.mSessionFwk.setExtras(bundle);
        }

        @Override
        public void setFlags(int n2) {
            this.mSessionFwk.setFlags(n2 | 1 | 2);
        }

        @Override
        public void setMediaButtonReceiver(PendingIntent pendingIntent) {
            this.mSessionFwk.setMediaButtonReceiver(pendingIntent);
        }

        @Override
        public void setMetadata(MediaMetadataCompat object) {
            this.mMetadata = object;
            MediaSession mediaSession = this.mSessionFwk;
            object = object == null ? null : (MediaMetadata)object.getMediaMetadata();
            mediaSession.setMetadata((MediaMetadata)object);
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setPlaybackState(PlaybackStateCompat playbackStateCompat) {
            this.mPlaybackState = playbackStateCompat;
            int n2 = this.mExtraControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                IMediaControllerCallback iMediaControllerCallback;
                if (n2 >= 0) {
                    iMediaControllerCallback = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(n2);
                    iMediaControllerCallback.onPlaybackStateChanged(playbackStateCompat);
                } else {
                    void var1_4;
                    this.mExtraControllerCallbacks.finishBroadcast();
                    iMediaControllerCallback = this.mSessionFwk;
                    if (playbackStateCompat == null) {
                        Object var1_2 = null;
                    } else {
                        PlaybackState playbackState = (PlaybackState)playbackStateCompat.getPlaybackState();
                    }
                    iMediaControllerCallback.setPlaybackState((PlaybackState)var1_4);
                    return;
                    catch (RemoteException remoteException) {}
                }
                --n2;
            }
        }

        @Override
        public void setPlaybackToLocal(int n2) {
            AudioAttributes.Builder builder = new AudioAttributes.Builder();
            builder.setLegacyStreamType(n2);
            this.mSessionFwk.setPlaybackToLocal(builder.build());
        }

        @Override
        public void setPlaybackToRemote(VolumeProviderCompat volumeProviderCompat) {
            this.mSessionFwk.setPlaybackToRemote((VolumeProvider)volumeProviderCompat.getVolumeProvider());
        }

        @Override
        public void setQueue(List<QueueItem> object) {
            this.mQueue = object;
            if (object == null) {
                this.mSessionFwk.setQueue(null);
                return;
            }
            ArrayList<MediaSession.QueueItem> arrayList = new ArrayList<MediaSession.QueueItem>();
            object = object.iterator();
            while (object.hasNext()) {
                arrayList.add((MediaSession.QueueItem)((QueueItem)object.next()).getQueueItem());
            }
            this.mSessionFwk.setQueue(arrayList);
        }

        @Override
        public void setQueueTitle(CharSequence charSequence) {
            this.mSessionFwk.setQueueTitle(charSequence);
        }

        @Override
        public void setRatingType(int n2) {
            if (Build.VERSION.SDK_INT < 22) {
                this.mRatingType = n2;
            } else {
                this.mSessionFwk.setRatingType(n2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        @Override
        public void setRepeatMode(int n2) {
            if (this.mRepeatMode == n2) return;
            this.mRepeatMode = n2;
            int n3 = this.mExtraControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n3 < 0) {
                    this.mExtraControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(n3);
                try {
                    iMediaControllerCallback.onRepeatModeChanged(n2);
                }
                catch (RemoteException remoteException) {}
                --n3;
            }
        }

        @Override
        public void setSessionActivity(PendingIntent pendingIntent) {
            this.mSessionFwk.setSessionActivity(pendingIntent);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        @Override
        public void setShuffleMode(int n2) {
            if (this.mShuffleMode == n2) return;
            this.mShuffleMode = n2;
            int n3 = this.mExtraControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n3 < 0) {
                    this.mExtraControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mExtraControllerCallbacks.getBroadcastItem(n3);
                try {
                    iMediaControllerCallback.onShuffleModeChanged(n2);
                }
                catch (RemoteException remoteException) {}
                --n3;
            }
        }

        class ExtraSession
        extends IMediaSession.Stub {
            ExtraSession() {
            }

            public void addQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
                throw new AssertionError();
            }

            public void addQueueItemAt(MediaDescriptionCompat mediaDescriptionCompat, int n2) {
                throw new AssertionError();
            }

            public void adjustVolume(int n2, int n3, String string2) {
                throw new AssertionError();
            }

            public void fastForward() throws RemoteException {
                throw new AssertionError();
            }

            public Bundle getExtras() {
                throw new AssertionError();
            }

            public long getFlags() {
                throw new AssertionError();
            }

            public PendingIntent getLaunchPendingIntent() {
                throw new AssertionError();
            }

            public MediaMetadataCompat getMetadata() {
                throw new AssertionError();
            }

            public String getPackageName() {
                throw new AssertionError();
            }

            public PlaybackStateCompat getPlaybackState() {
                return MediaSessionCompat.getStateWithUpdatedPosition(MediaSessionImplApi21.this.mPlaybackState, MediaSessionImplApi21.this.mMetadata);
            }

            public List<QueueItem> getQueue() {
                return null;
            }

            public CharSequence getQueueTitle() {
                throw new AssertionError();
            }

            public int getRatingType() {
                return MediaSessionImplApi21.this.mRatingType;
            }

            public int getRepeatMode() {
                return MediaSessionImplApi21.this.mRepeatMode;
            }

            public Bundle getSessionInfo() {
                Bundle bundle = MediaSessionImplApi21.this.mSessionInfo == null ? null : new Bundle(MediaSessionImplApi21.this.mSessionInfo);
                return bundle;
            }

            public int getShuffleMode() {
                return MediaSessionImplApi21.this.mShuffleMode;
            }

            public String getTag() {
                throw new AssertionError();
            }

            public ParcelableVolumeInfo getVolumeAttributes() {
                throw new AssertionError();
            }

            public boolean isCaptioningEnabled() {
                return MediaSessionImplApi21.this.mCaptioningEnabled;
            }

            public boolean isShuffleModeEnabledRemoved() {
                return false;
            }

            public boolean isTransportControlEnabled() {
                throw new AssertionError();
            }

            public void next() throws RemoteException {
                throw new AssertionError();
            }

            public void pause() throws RemoteException {
                throw new AssertionError();
            }

            public void play() throws RemoteException {
                throw new AssertionError();
            }

            public void playFromMediaId(String string2, Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            public void playFromSearch(String string2, Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            public void playFromUri(Uri uri, Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            public void prepare() throws RemoteException {
                throw new AssertionError();
            }

            public void prepareFromMediaId(String string2, Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            public void prepareFromSearch(String string2, Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            public void prepareFromUri(Uri uri, Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            public void previous() throws RemoteException {
                throw new AssertionError();
            }

            public void rate(RatingCompat ratingCompat) throws RemoteException {
                throw new AssertionError();
            }

            public void rateWithExtras(RatingCompat ratingCompat, Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            public void registerCallbackListener(IMediaControllerCallback iMediaControllerCallback) {
                if (!MediaSessionImplApi21.this.mDestroyed) {
                    MediaSessionManager.RemoteUserInfo remoteUserInfo = new MediaSessionManager.RemoteUserInfo("android.media.session.MediaController", ExtraSession.getCallingPid(), ExtraSession.getCallingUid());
                    MediaSessionImplApi21.this.mExtraControllerCallbacks.register((IInterface)iMediaControllerCallback, (Object)remoteUserInfo);
                }
            }

            public void removeQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
                throw new AssertionError();
            }

            public void removeQueueItemAt(int n2) {
                throw new AssertionError();
            }

            public void rewind() throws RemoteException {
                throw new AssertionError();
            }

            public void seekTo(long l2) throws RemoteException {
                throw new AssertionError();
            }

            public void sendCommand(String string2, Bundle bundle, ResultReceiverWrapper resultReceiverWrapper) {
                throw new AssertionError();
            }

            public void sendCustomAction(String string2, Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            public boolean sendMediaButton(KeyEvent keyEvent) {
                throw new AssertionError();
            }

            public void setCaptioningEnabled(boolean bl) throws RemoteException {
                throw new AssertionError();
            }

            public void setPlaybackSpeed(float f2) throws RemoteException {
                throw new AssertionError();
            }

            public void setRepeatMode(int n2) throws RemoteException {
                throw new AssertionError();
            }

            public void setShuffleMode(int n2) throws RemoteException {
                throw new AssertionError();
            }

            public void setShuffleModeEnabledRemoved(boolean bl) throws RemoteException {
            }

            public void setVolumeTo(int n2, int n3, String string2) {
                throw new AssertionError();
            }

            public void skipToQueueItem(long l2) {
                throw new AssertionError();
            }

            public void stop() throws RemoteException {
                throw new AssertionError();
            }

            public void unregisterCallbackListener(IMediaControllerCallback iMediaControllerCallback) {
                MediaSessionImplApi21.this.mExtraControllerCallbacks.unregister((IInterface)iMediaControllerCallback);
            }
        }
    }

    static class MediaSessionImplApi28
    extends MediaSessionImplApi21 {
        MediaSessionImplApi28(MediaSession mediaSession, VersionedParcelable versionedParcelable, Bundle bundle) {
            super(mediaSession, versionedParcelable, bundle);
        }

        MediaSessionImplApi28(Object object) {
            super(object);
        }

        @Override
        public final MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
            return new MediaSessionManager.RemoteUserInfo(this.mSessionFwk.getCurrentControllerInfo());
        }

        @Override
        public void setCurrentControllerInfo(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
        }
    }

    static class MediaSessionImplApi29
    extends MediaSessionImplApi28 {
        MediaSessionImplApi29(MediaSession mediaSession, VersionedParcelable versionedParcelable, Bundle bundle) {
            super(mediaSession, versionedParcelable, bundle);
        }

        MediaSessionImplApi29(Object object) {
            super(object);
            this.mSessionInfo = ((MediaSession)object).getController().getSessionInfo();
        }
    }

    static class MediaSessionImplBase
    implements MediaSessionImpl {
        static final int RCC_PLAYSTATE_NONE = 0;
        final AudioManager mAudioManager;
        volatile Callback mCallback;
        boolean mCaptioningEnabled;
        private final Context mContext;
        final RemoteCallbackList<IMediaControllerCallback> mControllerCallbacks;
        boolean mDestroyed = false;
        Bundle mExtras;
        int mFlags = 3;
        private MessageHandler mHandler;
        boolean mIsActive = false;
        int mLocalStream;
        final Object mLock = new Object();
        private final ComponentName mMediaButtonReceiverComponentName;
        private final PendingIntent mMediaButtonReceiverIntent;
        MediaMetadataCompat mMetadata;
        final String mPackageName;
        List<QueueItem> mQueue;
        CharSequence mQueueTitle;
        int mRatingType;
        final RemoteControlClient mRcc;
        private MediaSessionManager.RemoteUserInfo mRemoteUserInfo;
        int mRepeatMode;
        PendingIntent mSessionActivity;
        final Bundle mSessionInfo;
        int mShuffleMode;
        PlaybackStateCompat mState;
        private final MediaSessionStub mStub;
        final String mTag;
        private final Token mToken;
        private VolumeProviderCompat.Callback mVolumeCallback;
        VolumeProviderCompat mVolumeProvider;
        int mVolumeType;

        public MediaSessionImplBase(Context context, String string2, ComponentName componentName, PendingIntent pendingIntent, VersionedParcelable versionedParcelable, Bundle bundle) {
            this.mControllerCallbacks = new RemoteCallbackList();
            this.mVolumeCallback = new VolumeProviderCompat.Callback(){

                @Override
                public void onVolumeChanged(VolumeProviderCompat volumeProviderCompat) {
                    if (MediaSessionImplBase.this.mVolumeProvider != volumeProviderCompat) {
                        return;
                    }
                    volumeProviderCompat = new ParcelableVolumeInfo(MediaSessionImplBase.this.mVolumeType, MediaSessionImplBase.this.mLocalStream, volumeProviderCompat.getVolumeControl(), volumeProviderCompat.getMaxVolume(), volumeProviderCompat.getCurrentVolume());
                    MediaSessionImplBase.this.sendVolumeInfoChanged((ParcelableVolumeInfo)volumeProviderCompat);
                }
            };
            if (componentName != null) {
                this.mContext = context;
                this.mPackageName = context.getPackageName();
                this.mSessionInfo = bundle;
                this.mAudioManager = (AudioManager)context.getSystemService("audio");
                this.mTag = string2;
                this.mMediaButtonReceiverComponentName = componentName;
                this.mMediaButtonReceiverIntent = pendingIntent;
                this.mStub = new MediaSessionStub();
                this.mToken = new Token((Object)this.mStub, null, versionedParcelable);
                this.mRatingType = 0;
                this.mVolumeType = 1;
                this.mLocalStream = 3;
                this.mRcc = new RemoteControlClient(pendingIntent);
                return;
            }
            throw new IllegalArgumentException("MediaButtonReceiver component may not be null");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendCaptioningEnabled(boolean bl) {
            int n2 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onCaptioningEnabledChanged(bl);
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendEvent(String string2, Bundle bundle) {
            int n2 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onEvent(string2, bundle);
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendExtras(Bundle bundle) {
            int n2 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onExtrasChanged(bundle);
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendMetadata(MediaMetadataCompat mediaMetadataCompat) {
            int n2 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onMetadataChanged(mediaMetadataCompat);
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendQueue(List<QueueItem> list) {
            int n2 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onQueueChanged(list);
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendQueueTitle(CharSequence charSequence) {
            int n2 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onQueueTitleChanged(charSequence);
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendRepeatMode(int n2) {
            int n3 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n3 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n3);
                try {
                    iMediaControllerCallback.onRepeatModeChanged(n2);
                }
                catch (RemoteException remoteException) {}
                --n3;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendSessionDestroyed() {
            int n2 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    this.mControllerCallbacks.kill();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onSessionDestroyed();
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendShuffleMode(int n2) {
            int n3 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n3 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n3);
                try {
                    iMediaControllerCallback.onShuffleModeChanged(n2);
                }
                catch (RemoteException remoteException) {}
                --n3;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendState(PlaybackStateCompat playbackStateCompat) {
            int n2 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onPlaybackStateChanged(playbackStateCompat);
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        void adjustVolume(int n2, int n3) {
            if (this.mVolumeType == 2) {
                VolumeProviderCompat volumeProviderCompat = this.mVolumeProvider;
                if (volumeProviderCompat != null) {
                    volumeProviderCompat.onAdjustVolume(n2);
                }
            } else {
                this.mAudioManager.adjustStreamVolume(this.mLocalStream, n2, n3);
            }
        }

        RemoteControlClient.MetadataEditor buildRccMetadata(Bundle bundle) {
            RemoteControlClient.MetadataEditor metadataEditor = this.mRcc.editMetadata(true);
            if (bundle == null) {
                return metadataEditor;
            }
            if (bundle.containsKey("android.media.metadata.ART")) {
                Bitmap bitmap;
                Bitmap bitmap2 = bitmap = (Bitmap)bundle.getParcelable("android.media.metadata.ART");
                if (bitmap != null) {
                    bitmap2 = bitmap.copy(bitmap.getConfig(), false);
                }
                metadataEditor.putBitmap(100, bitmap2);
            } else if (bundle.containsKey("android.media.metadata.ALBUM_ART")) {
                Bitmap bitmap;
                Bitmap bitmap3 = bitmap = (Bitmap)bundle.getParcelable("android.media.metadata.ALBUM_ART");
                if (bitmap != null) {
                    bitmap3 = bitmap.copy(bitmap.getConfig(), false);
                }
                metadataEditor.putBitmap(100, bitmap3);
            }
            if (bundle.containsKey("android.media.metadata.ALBUM")) {
                metadataEditor.putString(1, bundle.getString("android.media.metadata.ALBUM"));
            }
            if (bundle.containsKey("android.media.metadata.ALBUM_ARTIST")) {
                metadataEditor.putString(13, bundle.getString("android.media.metadata.ALBUM_ARTIST"));
            }
            if (bundle.containsKey("android.media.metadata.ARTIST")) {
                metadataEditor.putString(2, bundle.getString("android.media.metadata.ARTIST"));
            }
            if (bundle.containsKey("android.media.metadata.AUTHOR")) {
                metadataEditor.putString(3, bundle.getString("android.media.metadata.AUTHOR"));
            }
            if (bundle.containsKey("android.media.metadata.COMPILATION")) {
                metadataEditor.putString(15, bundle.getString("android.media.metadata.COMPILATION"));
            }
            if (bundle.containsKey("android.media.metadata.COMPOSER")) {
                metadataEditor.putString(4, bundle.getString("android.media.metadata.COMPOSER"));
            }
            if (bundle.containsKey("android.media.metadata.DATE")) {
                metadataEditor.putString(5, bundle.getString("android.media.metadata.DATE"));
            }
            if (bundle.containsKey("android.media.metadata.DISC_NUMBER")) {
                metadataEditor.putLong(14, bundle.getLong("android.media.metadata.DISC_NUMBER"));
            }
            if (bundle.containsKey("android.media.metadata.DURATION")) {
                metadataEditor.putLong(9, bundle.getLong("android.media.metadata.DURATION"));
            }
            if (bundle.containsKey("android.media.metadata.GENRE")) {
                metadataEditor.putString(6, bundle.getString("android.media.metadata.GENRE"));
            }
            if (bundle.containsKey("android.media.metadata.TITLE")) {
                metadataEditor.putString(7, bundle.getString("android.media.metadata.TITLE"));
            }
            if (bundle.containsKey("android.media.metadata.TRACK_NUMBER")) {
                metadataEditor.putLong(0, bundle.getLong("android.media.metadata.TRACK_NUMBER"));
            }
            if (bundle.containsKey("android.media.metadata.WRITER")) {
                metadataEditor.putString(11, bundle.getString("android.media.metadata.WRITER"));
            }
            return metadataEditor;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Callback getCallback() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mCallback;
            }
        }

        @Override
        public String getCallingPackage() {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public MediaSessionManager.RemoteUserInfo getCurrentControllerInfo() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mRemoteUserInfo;
            }
        }

        @Override
        public Object getMediaSession() {
            return null;
        }

        String getPackageNameForUid(int n2) {
            String string2;
            String string3 = string2 = this.mContext.getPackageManager().getNameForUid(n2);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string3 = "android.media.session.MediaController";
            }
            return string3;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public PlaybackStateCompat getPlaybackState() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mState;
            }
        }

        int getRccStateFromState(int n2) {
            switch (n2) {
                default: {
                    return -1;
                }
                case 10: 
                case 11: {
                    return 6;
                }
                case 9: {
                    return 7;
                }
                case 7: {
                    return 9;
                }
                case 6: 
                case 8: {
                    return 8;
                }
                case 5: {
                    return 5;
                }
                case 4: {
                    return 4;
                }
                case 3: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case 0: 
            }
            return 0;
        }

        int getRccTransportControlFlagsFromActions(long l2) {
            int n2 = (1L & l2) != 0L ? 32 : 0;
            int n3 = n2;
            if ((2L & l2) != 0L) {
                n3 = n2 | 0x10;
            }
            n2 = n3;
            if ((4L & l2) != 0L) {
                n2 = n3 | 4;
            }
            int n4 = n2;
            if ((8L & l2) != 0L) {
                n4 = n2 | 2;
            }
            n3 = n4;
            if ((0x10L & l2) != 0L) {
                n3 = n4 | 1;
            }
            n2 = n3;
            if ((0x20L & l2) != 0L) {
                n2 = n3 | 0x80;
            }
            n3 = n2;
            if ((0x40L & l2) != 0L) {
                n3 = n2 | 0x40;
            }
            n2 = n3;
            if ((l2 & 0x200L) != 0L) {
                n2 = n3 | 8;
            }
            return n2;
        }

        @Override
        public Object getRemoteControlClient() {
            return null;
        }

        @Override
        public Token getSessionToken() {
            return this.mToken;
        }

        @Override
        public boolean isActive() {
            return this.mIsActive;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void postToHandler(int n2, int n3, int n4, Object object, Bundle bundle) {
            Object object2 = this.mLock;
            synchronized (object2) {
                if (this.mHandler != null) {
                    object = this.mHandler.obtainMessage(n2, n3, n4, object);
                    Bundle bundle2 = new Bundle();
                    n2 = Binder.getCallingUid();
                    bundle2.putInt(MediaSessionCompat.DATA_CALLING_UID, n2);
                    bundle2.putString(MediaSessionCompat.DATA_CALLING_PACKAGE, this.getPackageNameForUid(n2));
                    n2 = Binder.getCallingPid();
                    if (n2 > 0) {
                        bundle2.putInt(MediaSessionCompat.DATA_CALLING_PID, n2);
                    } else {
                        bundle2.putInt(MediaSessionCompat.DATA_CALLING_PID, -1);
                    }
                    if (bundle != null) {
                        bundle2.putBundle(MediaSessionCompat.DATA_EXTRAS, bundle);
                    }
                    object.setData(bundle2);
                    object.sendToTarget();
                }
                return;
            }
        }

        void registerMediaButtonEventReceiver(PendingIntent pendingIntent, ComponentName componentName) {
            this.mAudioManager.registerMediaButtonEventReceiver(componentName);
        }

        @Override
        public void release() {
            this.mIsActive = false;
            this.mDestroyed = true;
            this.updateMbrAndRcc();
            this.sendSessionDestroyed();
            this.setCallback(null, null);
        }

        @Override
        public void sendSessionEvent(String string2, Bundle bundle) {
            this.sendEvent(string2, bundle);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void sendVolumeInfoChanged(ParcelableVolumeInfo parcelableVolumeInfo) {
            int n2 = this.mControllerCallbacks.beginBroadcast() - 1;
            while (true) {
                if (n2 < 0) {
                    this.mControllerCallbacks.finishBroadcast();
                    return;
                }
                IMediaControllerCallback iMediaControllerCallback = (IMediaControllerCallback)this.mControllerCallbacks.getBroadcastItem(n2);
                try {
                    iMediaControllerCallback.onVolumeInfoChanged(parcelableVolumeInfo);
                }
                catch (RemoteException remoteException) {}
                --n2;
            }
        }

        @Override
        public void setActive(boolean bl) {
            if (bl == this.mIsActive) {
                return;
            }
            this.mIsActive = bl;
            this.updateMbrAndRcc();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setCallback(Callback callback2, Handler handler) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHandler != null) {
                    this.mHandler.removeCallbacksAndMessages(null);
                }
                MessageHandler messageHandler = callback2 != null && handler != null ? new MessageHandler(handler.getLooper()) : null;
                this.mHandler = messageHandler;
                if (this.mCallback != callback2 && this.mCallback != null) {
                    this.mCallback.setSessionImpl(null, null);
                }
                this.mCallback = callback2;
                if (this.mCallback != null) {
                    this.mCallback.setSessionImpl(this, handler);
                }
                return;
            }
        }

        @Override
        public void setCaptioningEnabled(boolean bl) {
            if (this.mCaptioningEnabled != bl) {
                this.mCaptioningEnabled = bl;
                this.sendCaptioningEnabled(bl);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setCurrentControllerInfo(MediaSessionManager.RemoteUserInfo remoteUserInfo) {
            Object object = this.mLock;
            synchronized (object) {
                this.mRemoteUserInfo = remoteUserInfo;
                return;
            }
        }

        @Override
        public void setExtras(Bundle bundle) {
            this.mExtras = bundle;
            this.sendExtras(bundle);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setFlags(int n2) {
            Object object = this.mLock;
            synchronized (object) {
                this.mFlags = n2 | 1 | 2;
                return;
            }
        }

        @Override
        public void setMediaButtonReceiver(PendingIntent pendingIntent) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setMetadata(MediaMetadataCompat object) {
            MediaMetadataCompat mediaMetadataCompat = object;
            if (object != null) {
                mediaMetadataCompat = new MediaMetadataCompat.Builder(object, sMaxBitmapSize).build();
            }
            object = this.mLock;
            synchronized (object) {
                this.mMetadata = mediaMetadataCompat;
            }
            this.sendMetadata(mediaMetadataCompat);
            if (!this.mIsActive) {
                return;
            }
            object = mediaMetadataCompat == null ? null : mediaMetadataCompat.getBundle();
            this.buildRccMetadata((Bundle)object).apply();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setPlaybackState(PlaybackStateCompat playbackStateCompat) {
            Object object = this.mLock;
            synchronized (object) {
                this.mState = playbackStateCompat;
            }
            this.sendState(playbackStateCompat);
            if (!this.mIsActive) {
                return;
            }
            if (playbackStateCompat == null) {
                this.mRcc.setPlaybackState(0);
                this.mRcc.setTransportControlFlags(0);
                return;
            }
            this.setRccState(playbackStateCompat);
            this.mRcc.setTransportControlFlags(this.getRccTransportControlFlagsFromActions(playbackStateCompat.getActions()));
        }

        @Override
        public void setPlaybackToLocal(int n2) {
            VolumeProviderCompat volumeProviderCompat = this.mVolumeProvider;
            if (volumeProviderCompat != null) {
                volumeProviderCompat.setCallback(null);
            }
            this.mLocalStream = n2;
            n2 = this.mVolumeType = 1;
            int n3 = this.mLocalStream;
            this.sendVolumeInfoChanged(new ParcelableVolumeInfo(n2, n3, 2, this.mAudioManager.getStreamMaxVolume(n3), this.mAudioManager.getStreamVolume(this.mLocalStream)));
        }

        @Override
        public void setPlaybackToRemote(VolumeProviderCompat volumeProviderCompat) {
            if (volumeProviderCompat != null) {
                VolumeProviderCompat volumeProviderCompat2 = this.mVolumeProvider;
                if (volumeProviderCompat2 != null) {
                    volumeProviderCompat2.setCallback(null);
                }
                this.mVolumeType = 2;
                this.mVolumeProvider = volumeProviderCompat;
                this.sendVolumeInfoChanged(new ParcelableVolumeInfo(this.mVolumeType, this.mLocalStream, this.mVolumeProvider.getVolumeControl(), this.mVolumeProvider.getMaxVolume(), this.mVolumeProvider.getCurrentVolume()));
                volumeProviderCompat.setCallback(this.mVolumeCallback);
                return;
            }
            throw new IllegalArgumentException("volumeProvider may not be null");
        }

        @Override
        public void setQueue(List<QueueItem> list) {
            this.mQueue = list;
            this.sendQueue(list);
        }

        @Override
        public void setQueueTitle(CharSequence charSequence) {
            this.mQueueTitle = charSequence;
            this.sendQueueTitle(charSequence);
        }

        @Override
        public void setRatingType(int n2) {
            this.mRatingType = n2;
        }

        void setRccState(PlaybackStateCompat playbackStateCompat) {
            this.mRcc.setPlaybackState(this.getRccStateFromState(playbackStateCompat.getState()));
        }

        @Override
        public void setRepeatMode(int n2) {
            if (this.mRepeatMode != n2) {
                this.mRepeatMode = n2;
                this.sendRepeatMode(n2);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setSessionActivity(PendingIntent pendingIntent) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSessionActivity = pendingIntent;
                return;
            }
        }

        @Override
        public void setShuffleMode(int n2) {
            if (this.mShuffleMode != n2) {
                this.mShuffleMode = n2;
                this.sendShuffleMode(n2);
            }
        }

        void setVolumeTo(int n2, int n3) {
            if (this.mVolumeType == 2) {
                VolumeProviderCompat volumeProviderCompat = this.mVolumeProvider;
                if (volumeProviderCompat != null) {
                    volumeProviderCompat.onSetVolumeTo(n2);
                }
            } else {
                this.mAudioManager.setStreamVolume(this.mLocalStream, n2, n3);
            }
        }

        void unregisterMediaButtonEventReceiver(PendingIntent pendingIntent, ComponentName componentName) {
            this.mAudioManager.unregisterMediaButtonEventReceiver(componentName);
        }

        void updateMbrAndRcc() {
            if (this.mIsActive) {
                this.registerMediaButtonEventReceiver(this.mMediaButtonReceiverIntent, this.mMediaButtonReceiverComponentName);
                this.mAudioManager.registerRemoteControlClient(this.mRcc);
                this.setMetadata(this.mMetadata);
                this.setPlaybackState(this.mState);
            } else {
                this.unregisterMediaButtonEventReceiver(this.mMediaButtonReceiverIntent, this.mMediaButtonReceiverComponentName);
                this.mRcc.setPlaybackState(0);
                this.mAudioManager.unregisterRemoteControlClient(this.mRcc);
            }
        }

        private static final class Command {
            public final String command;
            public final Bundle extras;
            public final ResultReceiver stub;

            public Command(String string2, Bundle bundle, ResultReceiver resultReceiver) {
                this.command = string2;
                this.extras = bundle;
                this.stub = resultReceiver;
            }
        }

        class MediaSessionStub
        extends IMediaSession.Stub {
            MediaSessionStub() {
            }

            public void addQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
                this.postToHandler(25, mediaDescriptionCompat);
            }

            public void addQueueItemAt(MediaDescriptionCompat mediaDescriptionCompat, int n2) {
                this.postToHandler(26, (Object)mediaDescriptionCompat, n2);
            }

            public void adjustVolume(int n2, int n3, String string2) {
                MediaSessionImplBase.this.adjustVolume(n2, n3);
            }

            public void fastForward() throws RemoteException {
                this.postToHandler(16);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Bundle getExtras() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mExtras;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public long getFlags() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mFlags;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public PendingIntent getLaunchPendingIntent() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mSessionActivity;
                }
            }

            public MediaMetadataCompat getMetadata() {
                return MediaSessionImplBase.this.mMetadata;
            }

            public String getPackageName() {
                return MediaSessionImplBase.this.mPackageName;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public PlaybackStateCompat getPlaybackState() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    PlaybackStateCompat playbackStateCompat = MediaSessionImplBase.this.mState;
                    MediaMetadataCompat mediaMetadataCompat = MediaSessionImplBase.this.mMetadata;
                    return MediaSessionCompat.getStateWithUpdatedPosition(playbackStateCompat, mediaMetadataCompat);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public List<QueueItem> getQueue() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    return MediaSessionImplBase.this.mQueue;
                }
            }

            public CharSequence getQueueTitle() {
                return MediaSessionImplBase.this.mQueueTitle;
            }

            public int getRatingType() {
                return MediaSessionImplBase.this.mRatingType;
            }

            public int getRepeatMode() {
                return MediaSessionImplBase.this.mRepeatMode;
            }

            public Bundle getSessionInfo() {
                Bundle bundle = MediaSessionImplBase.this.mSessionInfo == null ? null : new Bundle(MediaSessionImplBase.this.mSessionInfo);
                return bundle;
            }

            public int getShuffleMode() {
                return MediaSessionImplBase.this.mShuffleMode;
            }

            public String getTag() {
                return MediaSessionImplBase.this.mTag;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public ParcelableVolumeInfo getVolumeAttributes() {
                Object object = MediaSessionImplBase.this.mLock;
                synchronized (object) {
                    int n2;
                    int n3;
                    int n4;
                    int n5 = MediaSessionImplBase.this.mVolumeType;
                    int n6 = MediaSessionImplBase.this.mLocalStream;
                    VolumeProviderCompat volumeProviderCompat = MediaSessionImplBase.this.mVolumeProvider;
                    if (n5 == 2) {
                        n4 = volumeProviderCompat.getVolumeControl();
                        n3 = volumeProviderCompat.getMaxVolume();
                        n2 = volumeProviderCompat.getCurrentVolume();
                    } else {
                        n4 = MediaSessionImplBase.this.mAudioManager.getStreamMaxVolume(n6);
                        n2 = MediaSessionImplBase.this.mAudioManager.getStreamVolume(n6);
                        int n7 = 2;
                        n3 = n4;
                        n4 = n7;
                    }
                    return new ParcelableVolumeInfo(n5, n6, n4, n3, n2);
                }
            }

            public boolean isCaptioningEnabled() {
                return MediaSessionImplBase.this.mCaptioningEnabled;
            }

            public boolean isShuffleModeEnabledRemoved() {
                return false;
            }

            public boolean isTransportControlEnabled() {
                return true;
            }

            public void next() throws RemoteException {
                this.postToHandler(14);
            }

            public void pause() throws RemoteException {
                this.postToHandler(12);
            }

            public void play() throws RemoteException {
                this.postToHandler(7);
            }

            public void playFromMediaId(String string2, Bundle bundle) throws RemoteException {
                this.postToHandler(8, (Object)string2, bundle);
            }

            public void playFromSearch(String string2, Bundle bundle) throws RemoteException {
                this.postToHandler(9, (Object)string2, bundle);
            }

            public void playFromUri(Uri uri, Bundle bundle) throws RemoteException {
                this.postToHandler(10, (Object)uri, bundle);
            }

            void postToHandler(int n2) {
                MediaSessionImplBase.this.postToHandler(n2, 0, 0, null, null);
            }

            void postToHandler(int n2, int n3) {
                MediaSessionImplBase.this.postToHandler(n2, n3, 0, null, null);
            }

            void postToHandler(int n2, Object object) {
                MediaSessionImplBase.this.postToHandler(n2, 0, 0, object, null);
            }

            void postToHandler(int n2, Object object, int n3) {
                MediaSessionImplBase.this.postToHandler(n2, n3, 0, object, null);
            }

            void postToHandler(int n2, Object object, Bundle bundle) {
                MediaSessionImplBase.this.postToHandler(n2, 0, 0, object, bundle);
            }

            public void prepare() throws RemoteException {
                this.postToHandler(3);
            }

            public void prepareFromMediaId(String string2, Bundle bundle) throws RemoteException {
                this.postToHandler(4, (Object)string2, bundle);
            }

            public void prepareFromSearch(String string2, Bundle bundle) throws RemoteException {
                this.postToHandler(5, (Object)string2, bundle);
            }

            public void prepareFromUri(Uri uri, Bundle bundle) throws RemoteException {
                this.postToHandler(6, (Object)uri, bundle);
            }

            public void previous() throws RemoteException {
                this.postToHandler(15);
            }

            public void rate(RatingCompat ratingCompat) throws RemoteException {
                this.postToHandler(19, ratingCompat);
            }

            public void rateWithExtras(RatingCompat ratingCompat, Bundle bundle) throws RemoteException {
                this.postToHandler(31, (Object)ratingCompat, bundle);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void registerCallbackListener(IMediaControllerCallback iMediaControllerCallback) {
                if (!MediaSessionImplBase.this.mDestroyed) {
                    int n2 = MediaSessionStub.getCallingUid();
                    MediaSessionManager.RemoteUserInfo remoteUserInfo = new MediaSessionManager.RemoteUserInfo(MediaSessionImplBase.this.getPackageNameForUid(n2), MediaSessionStub.getCallingPid(), MediaSessionStub.getCallingUid());
                    MediaSessionImplBase.this.mControllerCallbacks.register((IInterface)iMediaControllerCallback, (Object)remoteUserInfo);
                    return;
                }
                try {
                    iMediaControllerCallback.onSessionDestroyed();
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }

            public void removeQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
                this.postToHandler(27, mediaDescriptionCompat);
            }

            public void removeQueueItemAt(int n2) {
                this.postToHandler(28, n2);
            }

            public void rewind() throws RemoteException {
                this.postToHandler(17);
            }

            public void seekTo(long l2) throws RemoteException {
                this.postToHandler(18, l2);
            }

            public void sendCommand(String string2, Bundle bundle, ResultReceiverWrapper resultReceiverWrapper) {
                resultReceiverWrapper = resultReceiverWrapper == null ? null : resultReceiverWrapper.mResultReceiver;
                this.postToHandler(1, new Command(string2, bundle, (ResultReceiver)resultReceiverWrapper));
            }

            public void sendCustomAction(String string2, Bundle bundle) throws RemoteException {
                this.postToHandler(20, (Object)string2, bundle);
            }

            public boolean sendMediaButton(KeyEvent keyEvent) {
                this.postToHandler(21, keyEvent);
                return true;
            }

            public void setCaptioningEnabled(boolean bl) throws RemoteException {
                this.postToHandler(29, bl);
            }

            public void setPlaybackSpeed(float f2) throws RemoteException {
                this.postToHandler(32, Float.valueOf(f2));
            }

            public void setRepeatMode(int n2) throws RemoteException {
                this.postToHandler(23, n2);
            }

            public void setShuffleMode(int n2) throws RemoteException {
                this.postToHandler(30, n2);
            }

            public void setShuffleModeEnabledRemoved(boolean bl) throws RemoteException {
            }

            public void setVolumeTo(int n2, int n3, String string2) {
                MediaSessionImplBase.this.setVolumeTo(n2, n3);
            }

            public void skipToQueueItem(long l2) {
                this.postToHandler(11, l2);
            }

            public void stop() throws RemoteException {
                this.postToHandler(13);
            }

            public void unregisterCallbackListener(IMediaControllerCallback iMediaControllerCallback) {
                MediaSessionImplBase.this.mControllerCallbacks.unregister((IInterface)iMediaControllerCallback);
            }
        }

        class MessageHandler
        extends Handler {
            private static final int KEYCODE_MEDIA_PAUSE = 127;
            private static final int KEYCODE_MEDIA_PLAY = 126;
            private static final int MSG_ADD_QUEUE_ITEM = 25;
            private static final int MSG_ADD_QUEUE_ITEM_AT = 26;
            private static final int MSG_ADJUST_VOLUME = 2;
            private static final int MSG_COMMAND = 1;
            private static final int MSG_CUSTOM_ACTION = 20;
            private static final int MSG_FAST_FORWARD = 16;
            private static final int MSG_MEDIA_BUTTON = 21;
            private static final int MSG_NEXT = 14;
            private static final int MSG_PAUSE = 12;
            private static final int MSG_PLAY = 7;
            private static final int MSG_PLAY_MEDIA_ID = 8;
            private static final int MSG_PLAY_SEARCH = 9;
            private static final int MSG_PLAY_URI = 10;
            private static final int MSG_PREPARE = 3;
            private static final int MSG_PREPARE_MEDIA_ID = 4;
            private static final int MSG_PREPARE_SEARCH = 5;
            private static final int MSG_PREPARE_URI = 6;
            private static final int MSG_PREVIOUS = 15;
            private static final int MSG_RATE = 19;
            private static final int MSG_RATE_EXTRA = 31;
            private static final int MSG_REMOVE_QUEUE_ITEM = 27;
            private static final int MSG_REMOVE_QUEUE_ITEM_AT = 28;
            private static final int MSG_REWIND = 17;
            private static final int MSG_SEEK_TO = 18;
            private static final int MSG_SET_CAPTIONING_ENABLED = 29;
            private static final int MSG_SET_PLAYBACK_SPEED = 32;
            private static final int MSG_SET_REPEAT_MODE = 23;
            private static final int MSG_SET_SHUFFLE_MODE = 30;
            private static final int MSG_SET_VOLUME = 22;
            private static final int MSG_SKIP_TO_ITEM = 11;
            private static final int MSG_STOP = 13;

            public MessageHandler(Looper looper) {
                super(looper);
            }

            /*
             * Unable to fully structure code
             */
            private void onMediaButtonEvent(KeyEvent var1_1, Callback var2_2) {
                block8: {
                    if (var1_1 == null || var1_1.getAction() != 0) break block8;
                    var3_3 = MediaSessionImplBase.this.mState == null ? 0L : MediaSessionImplBase.this.mState.getActions();
                    var5_4 = var1_1.getKeyCode();
                    if (var5_4 == 79) ** GOTO lbl-1000
                    if (var5_4 == 126) ** GOTO lbl33
                    if (var5_4 == 127) ** GOTO lbl30
                    switch (var5_4) {
                        default: {
                            break;
                        }
                        case 90: {
                            if ((var3_3 & 64L) == 0L) break;
                            var2_2.onFastForward();
                            break;
                        }
                        case 89: {
                            if ((var3_3 & 8L) == 0L) break;
                            var2_2.onRewind();
                            break;
                        }
                        case 88: {
                            if ((var3_3 & 16L) == 0L) break;
                            var2_2.onSkipToPrevious();
                            break;
                        }
                        case 87: {
                            if ((var3_3 & 32L) == 0L) break;
                            var2_2.onSkipToNext();
                            break;
                        }
                        case 86: {
                            if ((var3_3 & 1L) == 0L) break;
                            var2_2.onStop();
                            break;
                        }
lbl30:
                        // 1 sources

                        if ((var3_3 & 2L) == 0L) break;
                        var2_2.onPause();
                        break;
lbl33:
                        // 1 sources

                        if ((var3_3 & 4L) == 0L) break;
                        var2_2.onPlay();
                        break;
                        case 85: lbl-1000:
                        // 2 sources

                        {
                            Log.w((String)"MediaSessionCompat", (String)"KEYCODE_MEDIA_PLAY_PAUSE and KEYCODE_HEADSETHOOK are handled already");
                        }
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handleMessage(Message object) {
                Callback callback2 = MediaSessionImplBase.this.mCallback;
                if (callback2 == null) {
                    return;
                }
                Bundle bundle = object.getData();
                MediaSessionCompat.ensureClassLoader(bundle);
                MediaSessionImplBase.this.setCurrentControllerInfo(new MediaSessionManager.RemoteUserInfo(bundle.getString(MediaSessionCompat.DATA_CALLING_PACKAGE), bundle.getInt(MediaSessionCompat.DATA_CALLING_PID), bundle.getInt(MediaSessionCompat.DATA_CALLING_UID)));
                bundle = bundle.getBundle(MediaSessionCompat.DATA_EXTRAS);
                MediaSessionCompat.ensureClassLoader(bundle);
                try {
                    switch (((Message)object).what) {
                        default: {
                            return;
                        }
                        case 32: {
                            callback2.onSetPlaybackSpeed(((Float)((Message)object).obj).floatValue());
                            return;
                        }
                        case 31: {
                            callback2.onSetRating((RatingCompat)((Message)object).obj, bundle);
                            return;
                        }
                        case 30: {
                            callback2.onSetShuffleMode(((Message)object).arg1);
                            return;
                        }
                        case 29: {
                            callback2.onSetCaptioningEnabled((Boolean)((Message)object).obj);
                            return;
                        }
                        case 28: {
                            if (MediaSessionImplBase.this.mQueue == null) return;
                            object = ((Message)object).arg1 >= 0 && ((Message)object).arg1 < MediaSessionImplBase.this.mQueue.size() ? MediaSessionImplBase.this.mQueue.get(((Message)object).arg1) : null;
                            if (object == null) return;
                            callback2.onRemoveQueueItem(((QueueItem)object).getDescription());
                            return;
                        }
                        case 27: {
                            callback2.onRemoveQueueItem((MediaDescriptionCompat)((Message)object).obj);
                            return;
                        }
                        case 26: {
                            callback2.onAddQueueItem((MediaDescriptionCompat)((Message)object).obj, ((Message)object).arg1);
                            return;
                        }
                        case 25: {
                            callback2.onAddQueueItem((MediaDescriptionCompat)((Message)object).obj);
                            return;
                        }
                        case 23: {
                            callback2.onSetRepeatMode(((Message)object).arg1);
                            return;
                        }
                        case 22: {
                            MediaSessionImplBase.this.setVolumeTo(((Message)object).arg1, 0);
                            return;
                        }
                        case 21: {
                            object = (KeyEvent)((Message)object).obj;
                            bundle = new Intent("android.intent.action.MEDIA_BUTTON");
                            bundle.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)object);
                            if (callback2.onMediaButtonEvent((Intent)bundle)) return;
                            this.onMediaButtonEvent((KeyEvent)object, callback2);
                            return;
                        }
                        case 20: {
                            callback2.onCustomAction((String)((Message)object).obj, bundle);
                            return;
                        }
                        case 19: {
                            callback2.onSetRating((RatingCompat)((Message)object).obj);
                            return;
                        }
                        case 18: {
                            callback2.onSeekTo((Long)((Message)object).obj);
                            return;
                        }
                        case 17: {
                            callback2.onRewind();
                            return;
                        }
                        case 16: {
                            callback2.onFastForward();
                            return;
                        }
                        case 15: {
                            callback2.onSkipToPrevious();
                            return;
                        }
                        case 14: {
                            callback2.onSkipToNext();
                            return;
                        }
                        case 13: {
                            callback2.onStop();
                            return;
                        }
                        case 12: {
                            callback2.onPause();
                            return;
                        }
                        case 11: {
                            callback2.onSkipToQueueItem((Long)((Message)object).obj);
                            return;
                        }
                        case 10: {
                            callback2.onPlayFromUri((Uri)((Message)object).obj, bundle);
                            return;
                        }
                        case 9: {
                            callback2.onPlayFromSearch((String)((Message)object).obj, bundle);
                            return;
                        }
                        case 8: {
                            callback2.onPlayFromMediaId((String)((Message)object).obj, bundle);
                            return;
                        }
                        case 7: {
                            callback2.onPlay();
                            return;
                        }
                        case 6: {
                            callback2.onPrepareFromUri((Uri)((Message)object).obj, bundle);
                            return;
                        }
                        case 5: {
                            callback2.onPrepareFromSearch((String)((Message)object).obj, bundle);
                            return;
                        }
                        case 4: {
                            callback2.onPrepareFromMediaId((String)((Message)object).obj, bundle);
                            return;
                        }
                        case 3: {
                            callback2.onPrepare();
                            return;
                        }
                        case 2: {
                            MediaSessionImplBase.this.adjustVolume(((Message)object).arg1, 0);
                            return;
                        }
                        case 1: 
                    }
                    object = (Command)((Message)object).obj;
                    callback2.onCommand(((Command)object).command, ((Command)object).extras, ((Command)object).stub);
                    return;
                }
                finally {
                    MediaSessionImplBase.this.setCurrentControllerInfo(null);
                }
            }
        }
    }

    public static interface OnActiveChangeListener {
        public void onActiveChanged();
    }

    public static final class QueueItem
    implements Parcelable {
        public static final Parcelable.Creator<QueueItem> CREATOR = new Parcelable.Creator<QueueItem>(){

            public QueueItem createFromParcel(Parcel parcel) {
                return new QueueItem(parcel);
            }

            public QueueItem[] newArray(int n2) {
                return new QueueItem[n2];
            }
        };
        public static final int UNKNOWN_ID = -1;
        private final MediaDescriptionCompat mDescription;
        private final long mId;
        private MediaSession.QueueItem mItemFwk;

        private QueueItem(MediaSession.QueueItem queueItem, MediaDescriptionCompat mediaDescriptionCompat, long l2) {
            if (mediaDescriptionCompat != null) {
                if (l2 != -1L) {
                    this.mDescription = mediaDescriptionCompat;
                    this.mId = l2;
                    this.mItemFwk = queueItem;
                    return;
                }
                throw new IllegalArgumentException("Id cannot be QueueItem.UNKNOWN_ID");
            }
            throw new IllegalArgumentException("Description cannot be null");
        }

        QueueItem(Parcel parcel) {
            this.mDescription = (MediaDescriptionCompat)MediaDescriptionCompat.CREATOR.createFromParcel(parcel);
            this.mId = parcel.readLong();
        }

        public QueueItem(MediaDescriptionCompat mediaDescriptionCompat, long l2) {
            this(null, mediaDescriptionCompat, l2);
        }

        public static QueueItem fromQueueItem(Object object) {
            if (object != null && Build.VERSION.SDK_INT >= 21) {
                object = (MediaSession.QueueItem)object;
                return new QueueItem((MediaSession.QueueItem)object, MediaDescriptionCompat.fromMediaDescription((Object)object.getDescription()), object.getQueueId());
            }
            return null;
        }

        public static List<QueueItem> fromQueueItemList(List<?> object) {
            if (object != null && Build.VERSION.SDK_INT >= 21) {
                ArrayList<QueueItem> arrayList = new ArrayList<QueueItem>();
                object = object.iterator();
                while (object.hasNext()) {
                    arrayList.add(QueueItem.fromQueueItem(object.next()));
                }
                return arrayList;
            }
            return null;
        }

        public int describeContents() {
            return 0;
        }

        public MediaDescriptionCompat getDescription() {
            return this.mDescription;
        }

        public long getQueueId() {
            return this.mId;
        }

        public Object getQueueItem() {
            if (this.mItemFwk == null && Build.VERSION.SDK_INT >= 21) {
                this.mItemFwk = new MediaSession.QueueItem((MediaDescription)this.mDescription.getMediaDescription(), this.mId);
                return this.mItemFwk;
            }
            return this.mItemFwk;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("MediaSession.QueueItem {Description=");
            stringBuilder.append(this.mDescription);
            stringBuilder.append(", Id=");
            stringBuilder.append(this.mId);
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }

        public void writeToParcel(Parcel parcel, int n2) {
            this.mDescription.writeToParcel(parcel, n2);
            parcel.writeLong(this.mId);
        }
    }

    static final class ResultReceiverWrapper
    implements Parcelable {
        public static final Parcelable.Creator<ResultReceiverWrapper> CREATOR = new Parcelable.Creator<ResultReceiverWrapper>(){

            public ResultReceiverWrapper createFromParcel(Parcel parcel) {
                return new ResultReceiverWrapper(parcel);
            }

            public ResultReceiverWrapper[] newArray(int n2) {
                return new ResultReceiverWrapper[n2];
            }
        };
        ResultReceiver mResultReceiver;

        ResultReceiverWrapper(Parcel parcel) {
            this.mResultReceiver = (ResultReceiver)ResultReceiver.CREATOR.createFromParcel(parcel);
        }

        public ResultReceiverWrapper(ResultReceiver resultReceiver) {
            this.mResultReceiver = resultReceiver;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            this.mResultReceiver.writeToParcel(parcel, n2);
        }
    }

    public static final class Token
    implements Parcelable {
        public static final Parcelable.Creator<Token> CREATOR = new Parcelable.Creator<Token>(){

            public Token createFromParcel(Parcel object) {
                object = Build.VERSION.SDK_INT >= 21 ? object.readParcelable(null) : object.readStrongBinder();
                return new Token(object);
            }

            public Token[] newArray(int n2) {
                return new Token[n2];
            }
        };
        private IMediaSession mExtraBinder;
        private final Object mInner;
        private final Object mLock = new Object();
        private VersionedParcelable mSession2Token;

        Token(Object object) {
            this(object, null, null);
        }

        Token(Object object, IMediaSession iMediaSession) {
            this(object, iMediaSession, null);
        }

        Token(Object object, IMediaSession iMediaSession, VersionedParcelable versionedParcelable) {
            this.mInner = object;
            this.mExtraBinder = iMediaSession;
            this.mSession2Token = versionedParcelable;
        }

        public static Token fromBundle(Bundle object) {
            Object var1_1 = null;
            if (object == null) {
                return null;
            }
            IMediaSession iMediaSession = IMediaSession.Stub.asInterface((IBinder)BundleCompat.getBinder((Bundle)object, (String)MediaSessionCompat.KEY_EXTRA_BINDER));
            VersionedParcelable versionedParcelable = ParcelUtils.getVersionedParcelable((Bundle)object, (String)MediaSessionCompat.KEY_SESSION2_TOKEN);
            object = (object = (Token)object.getParcelable(MediaSessionCompat.KEY_TOKEN)) == null ? var1_1 : new Token(object.mInner, iMediaSession, versionedParcelable);
            return object;
        }

        public static Token fromToken(Object object) {
            return Token.fromToken(object, null);
        }

        public static Token fromToken(Object object, IMediaSession iMediaSession) {
            if (object != null && Build.VERSION.SDK_INT >= 21) {
                if (object instanceof MediaSession.Token) {
                    return new Token(object, iMediaSession);
                }
                throw new IllegalArgumentException("token is not a valid MediaSession.Token object");
            }
            return null;
        }

        public int describeContents() {
            return 0;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (!(object instanceof Token)) {
                return false;
            }
            Object object2 = (Token)object;
            object = this.mInner;
            if (object == null) {
                if (((Token)object2).mInner != null) {
                    bl = false;
                }
                return bl;
            }
            object2 = ((Token)object2).mInner;
            if (object2 == null) {
                return false;
            }
            return object.equals(object2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IMediaSession getExtraBinder() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mExtraBinder;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public VersionedParcelable getSession2Token() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mSession2Token;
            }
        }

        public Object getToken() {
            return this.mInner;
        }

        public int hashCode() {
            Object object = this.mInner;
            if (object == null) {
                return 0;
            }
            return object.hashCode();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setExtraBinder(IMediaSession iMediaSession) {
            Object object = this.mLock;
            synchronized (object) {
                this.mExtraBinder = iMediaSession;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setSession2Token(VersionedParcelable versionedParcelable) {
            Object object = this.mLock;
            synchronized (object) {
                this.mSession2Token = versionedParcelable;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putParcelable(MediaSessionCompat.KEY_TOKEN, (Parcelable)this);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExtraBinder != null) {
                    BundleCompat.putBinder((Bundle)bundle, (String)MediaSessionCompat.KEY_EXTRA_BINDER, (IBinder)this.mExtraBinder.asBinder());
                }
                if (this.mSession2Token != null) {
                    ParcelUtils.putVersionedParcelable((Bundle)bundle, (String)MediaSessionCompat.KEY_SESSION2_TOKEN, (VersionedParcelable)this.mSession2Token);
                }
                return bundle;
            }
        }

        public void writeToParcel(Parcel parcel, int n2) {
            if (Build.VERSION.SDK_INT >= 21) {
                parcel.writeParcelable((Parcelable)this.mInner, n2);
            } else {
                parcel.writeStrongBinder((IBinder)this.mInner);
            }
        }
    }
}

