/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.session;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.RatingCompat;
import android.support.v4.media.session.IMediaControllerCallback;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.ParcelableVolumeInfo;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import androidx.core.app.BundleCompat;
import androidx.media.AudioAttributesCompat;
import androidx.media.R;
import androidx.versionedparcelable.ParcelUtils;
import androidx.versionedparcelable.VersionedParcelable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class MediaControllerCompat {
    public static final String COMMAND_ADD_QUEUE_ITEM = "android.support.v4.media.session.command.ADD_QUEUE_ITEM";
    public static final String COMMAND_ADD_QUEUE_ITEM_AT = "android.support.v4.media.session.command.ADD_QUEUE_ITEM_AT";
    public static final String COMMAND_ARGUMENT_INDEX = "android.support.v4.media.session.command.ARGUMENT_INDEX";
    public static final String COMMAND_ARGUMENT_MEDIA_DESCRIPTION = "android.support.v4.media.session.command.ARGUMENT_MEDIA_DESCRIPTION";
    public static final String COMMAND_GET_EXTRA_BINDER = "android.support.v4.media.session.command.GET_EXTRA_BINDER";
    public static final String COMMAND_REMOVE_QUEUE_ITEM = "android.support.v4.media.session.command.REMOVE_QUEUE_ITEM";
    public static final String COMMAND_REMOVE_QUEUE_ITEM_AT = "android.support.v4.media.session.command.REMOVE_QUEUE_ITEM_AT";
    static final String TAG = "MediaControllerCompat";
    private final MediaControllerImpl mImpl;
    private final ConcurrentHashMap<Callback, Boolean> mRegisteredCallbacks = new ConcurrentHashMap();
    private final MediaSessionCompat.Token mToken;

    public MediaControllerCompat(Context context, MediaSessionCompat.Token token) {
        if (token != null) {
            this.mToken = token;
            this.mImpl = Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, token) : new MediaControllerImplBase(token);
            return;
        }
        throw new IllegalArgumentException("sessionToken must not be null");
    }

    public MediaControllerCompat(Context context, MediaSessionCompat mediaSessionCompat) {
        if (mediaSessionCompat != null) {
            this.mToken = mediaSessionCompat.getSessionToken();
            this.mImpl = Build.VERSION.SDK_INT >= 21 ? new MediaControllerImplApi21(context, this.mToken) : new MediaControllerImplBase(this.mToken);
            return;
        }
        throw new IllegalArgumentException("session must not be null");
    }

    public static MediaControllerCompat getMediaController(Activity activity) {
        Object object = activity.getWindow().getDecorView().getTag(R.id.media_controller_compat_view_tag);
        if (object instanceof MediaControllerCompat) {
            return (MediaControllerCompat)object;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            object = activity.getMediaController();
            if (object == null) {
                return null;
            }
            return new MediaControllerCompat((Context)activity, MediaSessionCompat.Token.fromToken(object.getSessionToken()));
        }
        return null;
    }

    public static void setMediaController(Activity activity, MediaControllerCompat mediaControllerCompat) {
        activity.getWindow().getDecorView().setTag(R.id.media_controller_compat_view_tag, (Object)mediaControllerCompat);
        if (Build.VERSION.SDK_INT >= 21) {
            MediaController mediaController = null;
            if (mediaControllerCompat != null) {
                mediaController = new MediaController((Context)activity, (MediaSession.Token)mediaControllerCompat.getSessionToken().getToken());
            }
            activity.setMediaController(mediaController);
        }
    }

    static void validateCustomAction(String string2, Bundle object) {
        if (string2 == null) {
            return;
        }
        int n2 = -1;
        int n3 = string2.hashCode();
        if (n3 != -1348483723) {
            if (n3 == 503011406 && string2.equals("android.support.v4.media.session.action.UNFOLLOW")) {
                n2 = 1;
            }
        } else if (string2.equals("android.support.v4.media.session.action.FOLLOW")) {
            n2 = 0;
        }
        if (n2 != 0 && n2 != 1 || object != null && object.containsKey("android.support.v4.media.session.ARGUMENT_MEDIA_ATTRIBUTE")) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("An extra field android.support.v4.media.session.ARGUMENT_MEDIA_ATTRIBUTE is required for this action ");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(".");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public void addQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
        this.mImpl.addQueueItem(mediaDescriptionCompat);
    }

    public void addQueueItem(MediaDescriptionCompat mediaDescriptionCompat, int n2) {
        this.mImpl.addQueueItem(mediaDescriptionCompat, n2);
    }

    public void adjustVolume(int n2, int n3) {
        this.mImpl.adjustVolume(n2, n3);
    }

    public boolean dispatchMediaButtonEvent(KeyEvent keyEvent) {
        if (keyEvent != null) {
            return this.mImpl.dispatchMediaButtonEvent(keyEvent);
        }
        throw new IllegalArgumentException("KeyEvent may not be null");
    }

    public Bundle getExtras() {
        return this.mImpl.getExtras();
    }

    public long getFlags() {
        return this.mImpl.getFlags();
    }

    public Object getMediaController() {
        return this.mImpl.getMediaController();
    }

    public MediaMetadataCompat getMetadata() {
        return this.mImpl.getMetadata();
    }

    public String getPackageName() {
        return this.mImpl.getPackageName();
    }

    public PlaybackInfo getPlaybackInfo() {
        return this.mImpl.getPlaybackInfo();
    }

    public PlaybackStateCompat getPlaybackState() {
        return this.mImpl.getPlaybackState();
    }

    public List<MediaSessionCompat.QueueItem> getQueue() {
        return this.mImpl.getQueue();
    }

    public CharSequence getQueueTitle() {
        return this.mImpl.getQueueTitle();
    }

    public int getRatingType() {
        return this.mImpl.getRatingType();
    }

    public int getRepeatMode() {
        return this.mImpl.getRepeatMode();
    }

    public VersionedParcelable getSession2Token() {
        return this.mToken.getSession2Token();
    }

    public PendingIntent getSessionActivity() {
        return this.mImpl.getSessionActivity();
    }

    public Bundle getSessionInfo() {
        return this.mImpl.getSessionInfo();
    }

    public MediaSessionCompat.Token getSessionToken() {
        return this.mToken;
    }

    public int getShuffleMode() {
        return this.mImpl.getShuffleMode();
    }

    public TransportControls getTransportControls() {
        return this.mImpl.getTransportControls();
    }

    public boolean isCaptioningEnabled() {
        return this.mImpl.isCaptioningEnabled();
    }

    public boolean isSessionReady() {
        return this.mImpl.isSessionReady();
    }

    public void registerCallback(Callback callback2) {
        this.registerCallback(callback2, null);
    }

    public void registerCallback(Callback callback2, Handler handler) {
        if (callback2 != null) {
            if (this.mRegisteredCallbacks.putIfAbsent(callback2, true) != null) {
                Log.w((String)TAG, (String)"the callback has already been registered");
                return;
            }
            Handler handler2 = handler;
            if (handler == null) {
                handler2 = new Handler();
            }
            callback2.setHandler(handler2);
            this.mImpl.registerCallback(callback2, handler2);
            return;
        }
        throw new IllegalArgumentException("callback must not be null");
    }

    public void removeQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
        this.mImpl.removeQueueItem(mediaDescriptionCompat);
    }

    @Deprecated
    public void removeQueueItemAt(int n2) {
        List<MediaSessionCompat.QueueItem> list = this.getQueue();
        if (list != null && n2 >= 0 && n2 < list.size() && (list = list.get(n2)) != null) {
            this.removeQueueItem(((MediaSessionCompat.QueueItem)((Object)list)).getDescription());
        }
    }

    public void sendCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mImpl.sendCommand(string2, bundle, resultReceiver);
            return;
        }
        throw new IllegalArgumentException("command must neither be null nor empty");
    }

    public void setVolumeTo(int n2, int n3) {
        this.mImpl.setVolumeTo(n2, n3);
    }

    public void unregisterCallback(Callback callback2) {
        if (callback2 != null) {
            if (this.mRegisteredCallbacks.remove(callback2) == null) {
                Log.w((String)TAG, (String)"the callback has never been registered");
                return;
            }
            try {
                this.mImpl.unregisterCallback(callback2);
                return;
            }
            finally {
                callback2.setHandler(null);
            }
        }
        throw new IllegalArgumentException("callback must not be null");
    }

    public static abstract class Callback
    implements IBinder.DeathRecipient {
        final MediaController.Callback mCallbackFwk;
        MessageHandler mHandler;
        IMediaControllerCallback mIControllerCallback;

        public Callback() {
            if (Build.VERSION.SDK_INT >= 21) {
                this.mCallbackFwk = new MediaControllerCallbackApi21(this);
            } else {
                this.mCallbackFwk = null;
                this.mIControllerCallback = new StubCompat(this);
            }
        }

        public void binderDied() {
            this.postToHandler(8, null, null);
        }

        public IMediaControllerCallback getIControllerCallback() {
            return this.mIControllerCallback;
        }

        public void onAudioInfoChanged(PlaybackInfo playbackInfo) {
        }

        public void onCaptioningEnabledChanged(boolean bl) {
        }

        public void onExtrasChanged(Bundle bundle) {
        }

        public void onMetadataChanged(MediaMetadataCompat mediaMetadataCompat) {
        }

        public void onPlaybackStateChanged(PlaybackStateCompat playbackStateCompat) {
        }

        public void onQueueChanged(List<MediaSessionCompat.QueueItem> list) {
        }

        public void onQueueTitleChanged(CharSequence charSequence) {
        }

        public void onRepeatModeChanged(int n2) {
        }

        public void onSessionDestroyed() {
        }

        public void onSessionEvent(String string2, Bundle bundle) {
        }

        public void onSessionReady() {
        }

        public void onShuffleModeChanged(int n2) {
        }

        void postToHandler(int n2, Object object, Bundle bundle) {
            MessageHandler messageHandler = this.mHandler;
            if (messageHandler != null) {
                object = messageHandler.obtainMessage(n2, object);
                object.setData(bundle);
                object.sendToTarget();
            }
        }

        void setHandler(Handler handler) {
            if (handler == null) {
                handler = this.mHandler;
                if (handler != null) {
                    handler.mRegistered = false;
                    handler.removeCallbacksAndMessages(null);
                    this.mHandler = null;
                }
            } else {
                this.mHandler = new MessageHandler(handler.getLooper());
                this.mHandler.mRegistered = true;
            }
        }

        private static class MediaControllerCallbackApi21
        extends MediaController.Callback {
            private final WeakReference<Callback> mCallback;

            MediaControllerCallbackApi21(Callback callback2) {
                this.mCallback = new WeakReference<Callback>(callback2);
            }

            public void onAudioInfoChanged(MediaController.PlaybackInfo playbackInfo) {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.onAudioInfoChanged(new PlaybackInfo(playbackInfo.getPlaybackType(), AudioAttributesCompat.wrap(playbackInfo.getAudioAttributes()), playbackInfo.getVolumeControl(), playbackInfo.getMaxVolume(), playbackInfo.getCurrentVolume()));
                }
            }

            public void onExtrasChanged(Bundle bundle) {
                MediaSessionCompat.ensureClassLoader(bundle);
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.onExtrasChanged(bundle);
                }
            }

            public void onMetadataChanged(MediaMetadata mediaMetadata) {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.onMetadataChanged(MediaMetadataCompat.fromMediaMetadata((Object)mediaMetadata));
                }
            }

            public void onPlaybackStateChanged(PlaybackState playbackState) {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null && callback2.mIControllerCallback == null) {
                    callback2.onPlaybackStateChanged(PlaybackStateCompat.fromPlaybackState(playbackState));
                }
            }

            public void onQueueChanged(List<MediaSession.QueueItem> list) {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.onQueueChanged(MediaSessionCompat.QueueItem.fromQueueItemList(list));
                }
            }

            public void onQueueTitleChanged(CharSequence charSequence) {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.onQueueTitleChanged(charSequence);
                }
            }

            public void onSessionDestroyed() {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.onSessionDestroyed();
                }
            }

            public void onSessionEvent(String string2, Bundle bundle) {
                MediaSessionCompat.ensureClassLoader(bundle);
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null && (callback2.mIControllerCallback == null || Build.VERSION.SDK_INT >= 23)) {
                    callback2.onSessionEvent(string2, bundle);
                }
            }
        }

        private class MessageHandler
        extends Handler {
            private static final int MSG_DESTROYED = 8;
            private static final int MSG_EVENT = 1;
            private static final int MSG_SESSION_READY = 13;
            private static final int MSG_UPDATE_CAPTIONING_ENABLED = 11;
            private static final int MSG_UPDATE_EXTRAS = 7;
            private static final int MSG_UPDATE_METADATA = 3;
            private static final int MSG_UPDATE_PLAYBACK_STATE = 2;
            private static final int MSG_UPDATE_QUEUE = 5;
            private static final int MSG_UPDATE_QUEUE_TITLE = 6;
            private static final int MSG_UPDATE_REPEAT_MODE = 9;
            private static final int MSG_UPDATE_SHUFFLE_MODE = 12;
            private static final int MSG_UPDATE_VOLUME = 4;
            boolean mRegistered;

            MessageHandler(Looper looper) {
                super(looper);
                this.mRegistered = false;
            }

            public void handleMessage(Message message) {
                if (!this.mRegistered) {
                    return;
                }
                switch (message.what) {
                    default: {
                        break;
                    }
                    case 13: {
                        Callback.this.onSessionReady();
                        break;
                    }
                    case 12: {
                        Callback.this.onShuffleModeChanged((Integer)message.obj);
                        break;
                    }
                    case 11: {
                        Callback.this.onCaptioningEnabledChanged((Boolean)message.obj);
                        break;
                    }
                    case 9: {
                        Callback.this.onRepeatModeChanged((Integer)message.obj);
                        break;
                    }
                    case 8: {
                        Callback.this.onSessionDestroyed();
                        break;
                    }
                    case 7: {
                        message = (Bundle)message.obj;
                        MediaSessionCompat.ensureClassLoader((Bundle)message);
                        Callback.this.onExtrasChanged((Bundle)message);
                        break;
                    }
                    case 6: {
                        Callback.this.onQueueTitleChanged((CharSequence)message.obj);
                        break;
                    }
                    case 5: {
                        Callback.this.onQueueChanged((List)message.obj);
                        break;
                    }
                    case 4: {
                        Callback.this.onAudioInfoChanged((PlaybackInfo)message.obj);
                        break;
                    }
                    case 3: {
                        Callback.this.onMetadataChanged((MediaMetadataCompat)message.obj);
                        break;
                    }
                    case 2: {
                        Callback.this.onPlaybackStateChanged((PlaybackStateCompat)message.obj);
                        break;
                    }
                    case 1: {
                        Bundle bundle = message.getData();
                        MediaSessionCompat.ensureClassLoader(bundle);
                        Callback.this.onSessionEvent((String)message.obj, bundle);
                    }
                }
            }
        }

        private static class StubCompat
        extends IMediaControllerCallback.Stub {
            private final WeakReference<Callback> mCallback;

            StubCompat(Callback callback2) {
                this.mCallback = new WeakReference<Callback>(callback2);
            }

            public void onCaptioningEnabledChanged(boolean bl) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(11, bl, null);
                }
            }

            public void onEvent(String string2, Bundle bundle) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(1, string2, bundle);
                }
            }

            public void onExtrasChanged(Bundle bundle) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(7, bundle, null);
                }
            }

            public void onMetadataChanged(MediaMetadataCompat mediaMetadataCompat) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(3, mediaMetadataCompat, null);
                }
            }

            public void onPlaybackStateChanged(PlaybackStateCompat playbackStateCompat) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(2, playbackStateCompat, null);
                }
            }

            public void onQueueChanged(List<MediaSessionCompat.QueueItem> list) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(5, list, null);
                }
            }

            public void onQueueTitleChanged(CharSequence charSequence) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(6, charSequence, null);
                }
            }

            public void onRepeatModeChanged(int n2) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(9, n2, null);
                }
            }

            public void onSessionDestroyed() throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(8, null, null);
                }
            }

            public void onSessionReady() throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(13, null, null);
                }
            }

            public void onShuffleModeChanged(int n2) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    callback2.postToHandler(12, n2, null);
                }
            }

            public void onShuffleModeChangedRemoved(boolean bl) throws RemoteException {
            }

            public void onVolumeInfoChanged(ParcelableVolumeInfo object) throws RemoteException {
                Callback callback2 = (Callback)this.mCallback.get();
                if (callback2 != null) {
                    object = object != null ? new PlaybackInfo(object.volumeType, object.audioStream, object.controlType, object.maxVolume, object.currentVolume) : null;
                    callback2.postToHandler(4, object, null);
                }
            }
        }
    }

    static interface MediaControllerImpl {
        public void addQueueItem(MediaDescriptionCompat var1);

        public void addQueueItem(MediaDescriptionCompat var1, int var2);

        public void adjustVolume(int var1, int var2);

        public boolean dispatchMediaButtonEvent(KeyEvent var1);

        public Bundle getExtras();

        public long getFlags();

        public Object getMediaController();

        public MediaMetadataCompat getMetadata();

        public String getPackageName();

        public PlaybackInfo getPlaybackInfo();

        public PlaybackStateCompat getPlaybackState();

        public List<MediaSessionCompat.QueueItem> getQueue();

        public CharSequence getQueueTitle();

        public int getRatingType();

        public int getRepeatMode();

        public PendingIntent getSessionActivity();

        public Bundle getSessionInfo();

        public int getShuffleMode();

        public TransportControls getTransportControls();

        public boolean isCaptioningEnabled();

        public boolean isSessionReady();

        public void registerCallback(Callback var1, Handler var2);

        public void removeQueueItem(MediaDescriptionCompat var1);

        public void sendCommand(String var1, Bundle var2, ResultReceiver var3);

        public void setVolumeTo(int var1, int var2);

        public void unregisterCallback(Callback var1);
    }

    static class MediaControllerImplApi21
    implements MediaControllerImpl {
        private HashMap<Callback, ExtraCallback> mCallbackMap;
        protected final MediaController mControllerFwk;
        final Object mLock = new Object();
        private final List<Callback> mPendingCallbacks = new ArrayList<Callback>();
        private Bundle mSessionInfo;
        final MediaSessionCompat.Token mSessionToken;

        MediaControllerImplApi21(Context context, MediaSessionCompat.Token token) {
            this.mCallbackMap = new HashMap();
            this.mSessionToken = token;
            this.mControllerFwk = new MediaController(context, (MediaSession.Token)this.mSessionToken.getToken());
            if (this.mSessionToken.getExtraBinder() == null) {
                this.requestExtraBinder();
            }
        }

        private void requestExtraBinder() {
            this.sendCommand(MediaControllerCompat.COMMAND_GET_EXTRA_BINDER, null, new ExtraBinderRequestResultReceiver(this));
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
            if ((this.getFlags() & 4L) != 0L) {
                Bundle bundle = new Bundle();
                bundle.putParcelable(MediaControllerCompat.COMMAND_ARGUMENT_MEDIA_DESCRIPTION, (Parcelable)mediaDescriptionCompat);
                this.sendCommand(MediaControllerCompat.COMMAND_ADD_QUEUE_ITEM, bundle, null);
                return;
            }
            throw new UnsupportedOperationException("This session doesn't support queue management operations");
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat mediaDescriptionCompat, int n2) {
            if ((this.getFlags() & 4L) != 0L) {
                Bundle bundle = new Bundle();
                bundle.putParcelable(MediaControllerCompat.COMMAND_ARGUMENT_MEDIA_DESCRIPTION, (Parcelable)mediaDescriptionCompat);
                bundle.putInt(MediaControllerCompat.COMMAND_ARGUMENT_INDEX, n2);
                this.sendCommand(MediaControllerCompat.COMMAND_ADD_QUEUE_ITEM_AT, bundle, null);
                return;
            }
            throw new UnsupportedOperationException("This session doesn't support queue management operations");
        }

        @Override
        public void adjustVolume(int n2, int n3) {
            this.mControllerFwk.adjustVolume(n2, n3);
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent keyEvent) {
            return this.mControllerFwk.dispatchMediaButtonEvent(keyEvent);
        }

        @Override
        public Bundle getExtras() {
            return this.mControllerFwk.getExtras();
        }

        @Override
        public long getFlags() {
            return this.mControllerFwk.getFlags();
        }

        @Override
        public Object getMediaController() {
            return this.mControllerFwk;
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            Object object = this.mControllerFwk.getMetadata();
            object = object != null ? MediaMetadataCompat.fromMediaMetadata((Object)object) : null;
            return object;
        }

        @Override
        public String getPackageName() {
            return this.mControllerFwk.getPackageName();
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            Object object = this.mControllerFwk.getPlaybackInfo();
            object = object != null ? new PlaybackInfo(object.getPlaybackType(), AudioAttributesCompat.wrap(object.getAudioAttributes()), object.getVolumeControl(), object.getMaxVolume(), object.getCurrentVolume()) : null;
            return object;
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            Object object;
            if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    PlaybackStateCompat playbackStateCompat = this.mSessionToken.getExtraBinder().getPlaybackState();
                    return playbackStateCompat;
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPlaybackState.", (Throwable)remoteException);
                }
            }
            object = (object = this.mControllerFwk.getPlaybackState()) != null ? PlaybackStateCompat.fromPlaybackState(object) : null;
            return object;
        }

        @Override
        public List<MediaSessionCompat.QueueItem> getQueue() {
            List<MediaSessionCompat.QueueItem> list = this.mControllerFwk.getQueue();
            list = list != null ? MediaSessionCompat.QueueItem.fromQueueItemList(list) : null;
            return list;
        }

        @Override
        public CharSequence getQueueTitle() {
            return this.mControllerFwk.getQueueTitle();
        }

        @Override
        public int getRatingType() {
            if (Build.VERSION.SDK_INT < 22 && this.mSessionToken.getExtraBinder() != null) {
                try {
                    int n2 = this.mSessionToken.getExtraBinder().getRatingType();
                    return n2;
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRatingType.", (Throwable)remoteException);
                }
            }
            return this.mControllerFwk.getRatingType();
        }

        @Override
        public int getRepeatMode() {
            if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    int n2 = this.mSessionToken.getExtraBinder().getRepeatMode();
                    return n2;
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRepeatMode.", (Throwable)remoteException);
                }
            }
            return -1;
        }

        @Override
        public PendingIntent getSessionActivity() {
            return this.mControllerFwk.getSessionActivity();
        }

        @Override
        public Bundle getSessionInfo() {
            Bundle bundle = this.mSessionInfo;
            if (bundle != null) {
                return new Bundle(bundle);
            }
            if (Build.VERSION.SDK_INT >= 29) {
                this.mSessionInfo = this.mControllerFwk.getSessionInfo();
            } else if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    this.mSessionInfo = this.mSessionToken.getExtraBinder().getSessionInfo();
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getSessionInfo.", (Throwable)remoteException);
                    this.mSessionInfo = Bundle.EMPTY;
                }
            }
            bundle = this.mSessionInfo = MediaSessionCompat.unparcelWithClassLoader(this.mSessionInfo);
            bundle = bundle == null ? Bundle.EMPTY : new Bundle(bundle);
            return bundle;
        }

        @Override
        public int getShuffleMode() {
            if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    int n2 = this.mSessionToken.getExtraBinder().getShuffleMode();
                    return n2;
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getShuffleMode.", (Throwable)remoteException);
                }
            }
            return -1;
        }

        @Override
        public TransportControls getTransportControls() {
            return new TransportControlsApi21(this.mControllerFwk.getTransportControls());
        }

        @Override
        public boolean isCaptioningEnabled() {
            if (this.mSessionToken.getExtraBinder() != null) {
                try {
                    boolean bl = this.mSessionToken.getExtraBinder().isCaptioningEnabled();
                    return bl;
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in isCaptioningEnabled.", (Throwable)remoteException);
                }
            }
            return false;
        }

        @Override
        public boolean isSessionReady() {
            boolean bl = this.mSessionToken.getExtraBinder() != null;
            return bl;
        }

        void processPendingCallbacksLocked() {
            if (this.mSessionToken.getExtraBinder() == null) {
                return;
            }
            for (Callback callback2 : this.mPendingCallbacks) {
                ExtraCallback extraCallback = new ExtraCallback(callback2);
                this.mCallbackMap.put(callback2, extraCallback);
                callback2.mIControllerCallback = extraCallback;
                try {
                    this.mSessionToken.getExtraBinder().registerCallbackListener((IMediaControllerCallback)extraCallback);
                    callback2.postToHandler(13, null, null);
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in registerCallback.", (Throwable)remoteException);
                    break;
                }
            }
            this.mPendingCallbacks.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void registerCallback(Callback callback2, Handler object) {
            this.mControllerFwk.registerCallback(callback2.mCallbackFwk, object);
            object = this.mLock;
            synchronized (object) {
                if (this.mSessionToken.getExtraBinder() != null) {
                    ExtraCallback extraCallback = new ExtraCallback(callback2);
                    this.mCallbackMap.put(callback2, extraCallback);
                    callback2.mIControllerCallback = extraCallback;
                    try {
                        this.mSessionToken.getExtraBinder().registerCallbackListener((IMediaControllerCallback)extraCallback);
                        callback2.postToHandler(13, null, null);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in registerCallback.", (Throwable)remoteException);
                    }
                } else {
                    callback2.mIControllerCallback = null;
                    this.mPendingCallbacks.add(callback2);
                }
                return;
            }
        }

        @Override
        public void removeQueueItem(MediaDescriptionCompat mediaDescriptionCompat) {
            if ((this.getFlags() & 4L) != 0L) {
                Bundle bundle = new Bundle();
                bundle.putParcelable(MediaControllerCompat.COMMAND_ARGUMENT_MEDIA_DESCRIPTION, (Parcelable)mediaDescriptionCompat);
                this.sendCommand(MediaControllerCompat.COMMAND_REMOVE_QUEUE_ITEM, bundle, null);
                return;
            }
            throw new UnsupportedOperationException("This session doesn't support queue management operations");
        }

        @Override
        public void sendCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            this.mControllerFwk.sendCommand(string2, bundle, resultReceiver);
        }

        @Override
        public void setVolumeTo(int n2, int n3) {
            this.mControllerFwk.setVolumeTo(n2, n3);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void unregisterCallback(Callback callback2) {
            this.mControllerFwk.unregisterCallback(callback2.mCallbackFwk);
            Object object = this.mLock;
            synchronized (object) {
                Object object2 = this.mSessionToken.getExtraBinder();
                if (object2 != null) {
                    try {
                        object2 = this.mCallbackMap.remove(callback2);
                        if (object2 != null) {
                            callback2.mIControllerCallback = null;
                            this.mSessionToken.getExtraBinder().unregisterCallbackListener((IMediaControllerCallback)object2);
                        }
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in unregisterCallback.", (Throwable)remoteException);
                    }
                } else {
                    this.mPendingCallbacks.remove(callback2);
                }
                return;
            }
        }

        private static class ExtraBinderRequestResultReceiver
        extends ResultReceiver {
            private WeakReference<MediaControllerImplApi21> mMediaControllerImpl;

            ExtraBinderRequestResultReceiver(MediaControllerImplApi21 mediaControllerImplApi21) {
                super(null);
                this.mMediaControllerImpl = new WeakReference<MediaControllerImplApi21>(mediaControllerImplApi21);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void onReceiveResult(int n2, Bundle bundle) {
                MediaControllerImplApi21 mediaControllerImplApi21 = (MediaControllerImplApi21)this.mMediaControllerImpl.get();
                if (mediaControllerImplApi21 == null) return;
                if (bundle == null) {
                    return;
                }
                Object object = mediaControllerImplApi21.mLock;
                synchronized (object) {
                    mediaControllerImplApi21.mSessionToken.setExtraBinder(IMediaSession.Stub.asInterface((IBinder)BundleCompat.getBinder((Bundle)bundle, (String)"android.support.v4.media.session.EXTRA_BINDER")));
                    mediaControllerImplApi21.mSessionToken.setSession2Token(ParcelUtils.getVersionedParcelable((Bundle)bundle, (String)"android.support.v4.media.session.SESSION_TOKEN2"));
                    mediaControllerImplApi21.processPendingCallbacksLocked();
                    return;
                }
            }
        }

        private static class ExtraCallback
        extends Callback.StubCompat {
            ExtraCallback(Callback callback2) {
                super(callback2);
            }

            @Override
            public void onExtrasChanged(Bundle bundle) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onMetadataChanged(MediaMetadataCompat mediaMetadataCompat) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onQueueChanged(List<MediaSessionCompat.QueueItem> list) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onQueueTitleChanged(CharSequence charSequence) throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onSessionDestroyed() throws RemoteException {
                throw new AssertionError();
            }

            @Override
            public void onVolumeInfoChanged(ParcelableVolumeInfo parcelableVolumeInfo) throws RemoteException {
                throw new AssertionError();
            }
        }
    }

    static class MediaControllerImplBase
    implements MediaControllerImpl {
        private IMediaSession mBinder;
        private Bundle mSessionInfo;
        private TransportControls mTransportControls;

        MediaControllerImplBase(MediaSessionCompat.Token token) {
            this.mBinder = IMediaSession.Stub.asInterface((IBinder)((IBinder)token.getToken()));
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat object) {
            try {
                if ((this.mBinder.getFlags() & 4L) == 0L) {
                    object = new UnsupportedOperationException("This session doesn't support queue management operations");
                    throw object;
                }
                this.mBinder.addQueueItem(object);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in addQueueItem.", (Throwable)remoteException);
            }
        }

        @Override
        public void addQueueItem(MediaDescriptionCompat object, int n2) {
            try {
                if ((this.mBinder.getFlags() & 4L) == 0L) {
                    object = new UnsupportedOperationException("This session doesn't support queue management operations");
                    throw object;
                }
                this.mBinder.addQueueItemAt(object, n2);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in addQueueItemAt.", (Throwable)remoteException);
            }
        }

        @Override
        public void adjustVolume(int n2, int n3) {
            try {
                this.mBinder.adjustVolume(n2, n3, null);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in adjustVolume.", (Throwable)remoteException);
            }
        }

        @Override
        public boolean dispatchMediaButtonEvent(KeyEvent keyEvent) {
            if (keyEvent != null) {
                try {
                    this.mBinder.sendMediaButton(keyEvent);
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in dispatchMediaButtonEvent.", (Throwable)remoteException);
                }
                return false;
            }
            throw new IllegalArgumentException("event may not be null.");
        }

        @Override
        public Bundle getExtras() {
            try {
                Bundle bundle = this.mBinder.getExtras();
                return bundle;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getExtras.", (Throwable)remoteException);
                return null;
            }
        }

        @Override
        public long getFlags() {
            try {
                long l2 = this.mBinder.getFlags();
                return l2;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getFlags.", (Throwable)remoteException);
                return 0L;
            }
        }

        @Override
        public Object getMediaController() {
            return null;
        }

        @Override
        public MediaMetadataCompat getMetadata() {
            try {
                MediaMetadataCompat mediaMetadataCompat = this.mBinder.getMetadata();
                return mediaMetadataCompat;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getMetadata.", (Throwable)remoteException);
                return null;
            }
        }

        @Override
        public String getPackageName() {
            try {
                String string2 = this.mBinder.getPackageName();
                return string2;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPackageName.", (Throwable)remoteException);
                return null;
            }
        }

        @Override
        public PlaybackInfo getPlaybackInfo() {
            try {
                Object object = this.mBinder.getVolumeAttributes();
                object = new PlaybackInfo(object.volumeType, object.audioStream, object.controlType, object.maxVolume, object.currentVolume);
                return object;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPlaybackInfo.", (Throwable)remoteException);
                return null;
            }
        }

        @Override
        public PlaybackStateCompat getPlaybackState() {
            try {
                PlaybackStateCompat playbackStateCompat = this.mBinder.getPlaybackState();
                return playbackStateCompat;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getPlaybackState.", (Throwable)remoteException);
                return null;
            }
        }

        @Override
        public List<MediaSessionCompat.QueueItem> getQueue() {
            try {
                List list = this.mBinder.getQueue();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getQueue.", (Throwable)remoteException);
                return null;
            }
        }

        @Override
        public CharSequence getQueueTitle() {
            try {
                CharSequence charSequence = this.mBinder.getQueueTitle();
                return charSequence;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getQueueTitle.", (Throwable)remoteException);
                return null;
            }
        }

        @Override
        public int getRatingType() {
            try {
                int n2 = this.mBinder.getRatingType();
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRatingType.", (Throwable)remoteException);
                return 0;
            }
        }

        @Override
        public int getRepeatMode() {
            try {
                int n2 = this.mBinder.getRepeatMode();
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getRepeatMode.", (Throwable)remoteException);
                return -1;
            }
        }

        @Override
        public PendingIntent getSessionActivity() {
            try {
                PendingIntent pendingIntent = this.mBinder.getLaunchPendingIntent();
                return pendingIntent;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getSessionActivity.", (Throwable)remoteException);
                return null;
            }
        }

        @Override
        public Bundle getSessionInfo() {
            try {
                this.mSessionInfo = this.mBinder.getSessionInfo();
            }
            catch (RemoteException remoteException) {
                Log.d((String)MediaControllerCompat.TAG, (String)"Dead object in getSessionInfo.", (Throwable)remoteException);
            }
            Bundle bundle = this.mSessionInfo = MediaSessionCompat.unparcelWithClassLoader(this.mSessionInfo);
            bundle = bundle == null ? Bundle.EMPTY : new Bundle(bundle);
            return bundle;
        }

        @Override
        public int getShuffleMode() {
            try {
                int n2 = this.mBinder.getShuffleMode();
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in getShuffleMode.", (Throwable)remoteException);
                return -1;
            }
        }

        @Override
        public TransportControls getTransportControls() {
            if (this.mTransportControls == null) {
                this.mTransportControls = new TransportControlsBase(this.mBinder);
            }
            return this.mTransportControls;
        }

        @Override
        public boolean isCaptioningEnabled() {
            try {
                boolean bl = this.mBinder.isCaptioningEnabled();
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in isCaptioningEnabled.", (Throwable)remoteException);
                return false;
            }
        }

        @Override
        public boolean isSessionReady() {
            return true;
        }

        @Override
        public void registerCallback(Callback callback2, Handler handler) {
            if (callback2 != null) {
                try {
                    this.mBinder.asBinder().linkToDeath((IBinder.DeathRecipient)callback2, 0);
                    this.mBinder.registerCallbackListener(callback2.mIControllerCallback);
                    callback2.postToHandler(13, null, null);
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in registerCallback.", (Throwable)remoteException);
                    callback2.postToHandler(8, null, null);
                }
                return;
            }
            throw new IllegalArgumentException("callback may not be null.");
        }

        @Override
        public void removeQueueItem(MediaDescriptionCompat object) {
            try {
                if ((this.mBinder.getFlags() & 4L) == 0L) {
                    object = new UnsupportedOperationException("This session doesn't support queue management operations");
                    throw object;
                }
                this.mBinder.removeQueueItem(object);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in removeQueueItem.", (Throwable)remoteException);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void sendCommand(String string2, Bundle bundle, ResultReceiver object) {
            try {
                void var3_7;
                IMediaSession iMediaSession = this.mBinder;
                if (object == null) {
                    Object var3_5 = null;
                } else {
                    MediaSessionCompat.ResultReceiverWrapper resultReceiverWrapper = new MediaSessionCompat.ResultReceiverWrapper((ResultReceiver)object);
                }
                iMediaSession.sendCommand(string2, bundle, (MediaSessionCompat.ResultReceiverWrapper)var3_7);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in sendCommand.", (Throwable)remoteException);
            }
        }

        @Override
        public void setVolumeTo(int n2, int n3) {
            try {
                this.mBinder.setVolumeTo(n2, n3, null);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setVolumeTo.", (Throwable)remoteException);
            }
        }

        @Override
        public void unregisterCallback(Callback callback2) {
            if (callback2 != null) {
                try {
                    this.mBinder.unregisterCallbackListener(callback2.mIControllerCallback);
                    this.mBinder.asBinder().unlinkToDeath((IBinder.DeathRecipient)callback2, 0);
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in unregisterCallback.", (Throwable)remoteException);
                }
                return;
            }
            throw new IllegalArgumentException("callback may not be null.");
        }
    }

    public static final class PlaybackInfo {
        public static final int PLAYBACK_TYPE_LOCAL = 1;
        public static final int PLAYBACK_TYPE_REMOTE = 2;
        private final AudioAttributesCompat mAudioAttrsCompat;
        private final int mCurrentVolume;
        private final int mMaxVolume;
        private final int mPlaybackType;
        private final int mVolumeControl;

        PlaybackInfo(int n2, int n3, int n4, int n5, int n6) {
            this(n2, new AudioAttributesCompat.Builder().setLegacyStreamType(n3).build(), n4, n5, n6);
        }

        PlaybackInfo(int n2, AudioAttributesCompat audioAttributesCompat, int n3, int n4, int n5) {
            this.mPlaybackType = n2;
            this.mAudioAttrsCompat = audioAttributesCompat;
            this.mVolumeControl = n3;
            this.mMaxVolume = n4;
            this.mCurrentVolume = n5;
        }

        public AudioAttributesCompat getAudioAttributes() {
            return this.mAudioAttrsCompat;
        }

        @Deprecated
        public int getAudioStream() {
            return this.mAudioAttrsCompat.getLegacyStreamType();
        }

        public int getCurrentVolume() {
            return this.mCurrentVolume;
        }

        public int getMaxVolume() {
            return this.mMaxVolume;
        }

        public int getPlaybackType() {
            return this.mPlaybackType;
        }

        public int getVolumeControl() {
            return this.mVolumeControl;
        }
    }

    public static abstract class TransportControls {
        public static final String EXTRA_LEGACY_STREAM_TYPE = "android.media.session.extra.LEGACY_STREAM_TYPE";

        TransportControls() {
        }

        public abstract void fastForward();

        public abstract void pause();

        public abstract void play();

        public abstract void playFromMediaId(String var1, Bundle var2);

        public abstract void playFromSearch(String var1, Bundle var2);

        public abstract void playFromUri(Uri var1, Bundle var2);

        public abstract void prepare();

        public abstract void prepareFromMediaId(String var1, Bundle var2);

        public abstract void prepareFromSearch(String var1, Bundle var2);

        public abstract void prepareFromUri(Uri var1, Bundle var2);

        public abstract void rewind();

        public abstract void seekTo(long var1);

        public abstract void sendCustomAction(PlaybackStateCompat.CustomAction var1, Bundle var2);

        public abstract void sendCustomAction(String var1, Bundle var2);

        public abstract void setCaptioningEnabled(boolean var1);

        public void setPlaybackSpeed(float f2) {
        }

        public abstract void setRating(RatingCompat var1);

        public abstract void setRating(RatingCompat var1, Bundle var2);

        public abstract void setRepeatMode(int var1);

        public abstract void setShuffleMode(int var1);

        public abstract void skipToNext();

        public abstract void skipToPrevious();

        public abstract void skipToQueueItem(long var1);

        public abstract void stop();
    }

    static class TransportControlsApi21
    extends TransportControls {
        protected final MediaController.TransportControls mControlsFwk;

        TransportControlsApi21(MediaController.TransportControls transportControls) {
            this.mControlsFwk = transportControls;
        }

        @Override
        public void fastForward() {
            this.mControlsFwk.fastForward();
        }

        @Override
        public void pause() {
            this.mControlsFwk.pause();
        }

        @Override
        public void play() {
            this.mControlsFwk.play();
        }

        @Override
        public void playFromMediaId(String string2, Bundle bundle) {
            this.mControlsFwk.playFromMediaId(string2, bundle);
        }

        @Override
        public void playFromSearch(String string2, Bundle bundle) {
            this.mControlsFwk.playFromSearch(string2, bundle);
        }

        @Override
        public void playFromUri(Uri uri, Bundle bundle) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.mControlsFwk.playFromUri(uri, bundle);
                return;
            }
            if (uri != null && !Uri.EMPTY.equals((Object)uri)) {
                Bundle bundle2 = new Bundle();
                bundle2.putParcelable("android.support.v4.media.session.action.ARGUMENT_URI", (Parcelable)uri);
                bundle2.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", bundle);
                this.sendCustomAction("android.support.v4.media.session.action.PLAY_FROM_URI", bundle2);
                return;
            }
            throw new IllegalArgumentException("You must specify a non-empty Uri for playFromUri.");
        }

        @Override
        public void prepare() {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mControlsFwk.prepare();
                return;
            }
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE", null);
        }

        @Override
        public void prepareFromMediaId(String string2, Bundle bundle) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mControlsFwk.prepareFromMediaId(string2, bundle);
                return;
            }
            Bundle bundle2 = new Bundle();
            bundle2.putString("android.support.v4.media.session.action.ARGUMENT_MEDIA_ID", string2);
            bundle2.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", bundle);
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE_FROM_MEDIA_ID", bundle2);
        }

        @Override
        public void prepareFromSearch(String string2, Bundle bundle) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mControlsFwk.prepareFromSearch(string2, bundle);
                return;
            }
            Bundle bundle2 = new Bundle();
            bundle2.putString("android.support.v4.media.session.action.ARGUMENT_QUERY", string2);
            bundle2.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", bundle);
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE_FROM_SEARCH", bundle2);
        }

        @Override
        public void prepareFromUri(Uri uri, Bundle bundle) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mControlsFwk.prepareFromUri(uri, bundle);
                return;
            }
            Bundle bundle2 = new Bundle();
            bundle2.putParcelable("android.support.v4.media.session.action.ARGUMENT_URI", (Parcelable)uri);
            bundle2.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", bundle);
            this.sendCustomAction("android.support.v4.media.session.action.PREPARE_FROM_URI", bundle2);
        }

        @Override
        public void rewind() {
            this.mControlsFwk.rewind();
        }

        @Override
        public void seekTo(long l2) {
            this.mControlsFwk.seekTo(l2);
        }

        @Override
        public void sendCustomAction(PlaybackStateCompat.CustomAction customAction, Bundle bundle) {
            MediaControllerCompat.validateCustomAction(customAction.getAction(), bundle);
            this.mControlsFwk.sendCustomAction(customAction.getAction(), bundle);
        }

        @Override
        public void sendCustomAction(String string2, Bundle bundle) {
            MediaControllerCompat.validateCustomAction(string2, bundle);
            this.mControlsFwk.sendCustomAction(string2, bundle);
        }

        @Override
        public void setCaptioningEnabled(boolean bl) {
            Bundle bundle = new Bundle();
            bundle.putBoolean("android.support.v4.media.session.action.ARGUMENT_CAPTIONING_ENABLED", bl);
            this.sendCustomAction("android.support.v4.media.session.action.SET_CAPTIONING_ENABLED", bundle);
        }

        @Override
        public void setPlaybackSpeed(float f2) {
            if (f2 != 0.0f) {
                if (Build.VERSION.SDK_INT >= 29) {
                    this.mControlsFwk.setPlaybackSpeed(f2);
                    return;
                }
                Bundle bundle = new Bundle();
                bundle.putFloat("android.support.v4.media.session.action.ARGUMENT_PLAYBACK_SPEED", f2);
                this.sendCustomAction("android.support.v4.media.session.action.SET_PLAYBACK_SPEED", bundle);
                return;
            }
            throw new IllegalArgumentException("speed must not be zero");
        }

        @Override
        public void setRating(RatingCompat ratingCompat) {
            MediaController.TransportControls transportControls = this.mControlsFwk;
            ratingCompat = ratingCompat != null ? (Rating)ratingCompat.getRating() : null;
            transportControls.setRating((Rating)ratingCompat);
        }

        @Override
        public void setRating(RatingCompat ratingCompat, Bundle bundle) {
            Bundle bundle2 = new Bundle();
            bundle2.putParcelable("android.support.v4.media.session.action.ARGUMENT_RATING", (Parcelable)ratingCompat);
            bundle2.putBundle("android.support.v4.media.session.action.ARGUMENT_EXTRAS", bundle);
            this.sendCustomAction("android.support.v4.media.session.action.SET_RATING", bundle2);
        }

        @Override
        public void setRepeatMode(int n2) {
            Bundle bundle = new Bundle();
            bundle.putInt("android.support.v4.media.session.action.ARGUMENT_REPEAT_MODE", n2);
            this.sendCustomAction("android.support.v4.media.session.action.SET_REPEAT_MODE", bundle);
        }

        @Override
        public void setShuffleMode(int n2) {
            Bundle bundle = new Bundle();
            bundle.putInt("android.support.v4.media.session.action.ARGUMENT_SHUFFLE_MODE", n2);
            this.sendCustomAction("android.support.v4.media.session.action.SET_SHUFFLE_MODE", bundle);
        }

        @Override
        public void skipToNext() {
            this.mControlsFwk.skipToNext();
        }

        @Override
        public void skipToPrevious() {
            this.mControlsFwk.skipToPrevious();
        }

        @Override
        public void skipToQueueItem(long l2) {
            this.mControlsFwk.skipToQueueItem(l2);
        }

        @Override
        public void stop() {
            this.mControlsFwk.stop();
        }
    }

    static class TransportControlsBase
    extends TransportControls {
        private IMediaSession mBinder;

        public TransportControlsBase(IMediaSession iMediaSession) {
            this.mBinder = iMediaSession;
        }

        @Override
        public void fastForward() {
            try {
                this.mBinder.fastForward();
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in fastForward.", (Throwable)remoteException);
            }
        }

        @Override
        public void pause() {
            try {
                this.mBinder.pause();
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in pause.", (Throwable)remoteException);
            }
        }

        @Override
        public void play() {
            try {
                this.mBinder.play();
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in play.", (Throwable)remoteException);
            }
        }

        @Override
        public void playFromMediaId(String string2, Bundle bundle) {
            try {
                this.mBinder.playFromMediaId(string2, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in playFromMediaId.", (Throwable)remoteException);
            }
        }

        @Override
        public void playFromSearch(String string2, Bundle bundle) {
            try {
                this.mBinder.playFromSearch(string2, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in playFromSearch.", (Throwable)remoteException);
            }
        }

        @Override
        public void playFromUri(Uri uri, Bundle bundle) {
            try {
                this.mBinder.playFromUri(uri, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in playFromUri.", (Throwable)remoteException);
            }
        }

        @Override
        public void prepare() {
            try {
                this.mBinder.prepare();
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepare.", (Throwable)remoteException);
            }
        }

        @Override
        public void prepareFromMediaId(String string2, Bundle bundle) {
            try {
                this.mBinder.prepareFromMediaId(string2, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepareFromMediaId.", (Throwable)remoteException);
            }
        }

        @Override
        public void prepareFromSearch(String string2, Bundle bundle) {
            try {
                this.mBinder.prepareFromSearch(string2, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepareFromSearch.", (Throwable)remoteException);
            }
        }

        @Override
        public void prepareFromUri(Uri uri, Bundle bundle) {
            try {
                this.mBinder.prepareFromUri(uri, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in prepareFromUri.", (Throwable)remoteException);
            }
        }

        @Override
        public void rewind() {
            try {
                this.mBinder.rewind();
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in rewind.", (Throwable)remoteException);
            }
        }

        @Override
        public void seekTo(long l2) {
            try {
                this.mBinder.seekTo(l2);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in seekTo.", (Throwable)remoteException);
            }
        }

        @Override
        public void sendCustomAction(PlaybackStateCompat.CustomAction customAction, Bundle bundle) {
            this.sendCustomAction(customAction.getAction(), bundle);
        }

        @Override
        public void sendCustomAction(String string2, Bundle bundle) {
            MediaControllerCompat.validateCustomAction(string2, bundle);
            try {
                this.mBinder.sendCustomAction(string2, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in sendCustomAction.", (Throwable)remoteException);
            }
        }

        @Override
        public void setCaptioningEnabled(boolean bl) {
            try {
                this.mBinder.setCaptioningEnabled(bl);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setCaptioningEnabled.", (Throwable)remoteException);
            }
        }

        @Override
        public void setPlaybackSpeed(float f2) {
            if (f2 != 0.0f) {
                try {
                    this.mBinder.setPlaybackSpeed(f2);
                }
                catch (RemoteException remoteException) {
                    Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setPlaybackSpeed.", (Throwable)remoteException);
                }
                return;
            }
            throw new IllegalArgumentException("speed must not be zero");
        }

        @Override
        public void setRating(RatingCompat ratingCompat) {
            try {
                this.mBinder.rate(ratingCompat);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setRating.", (Throwable)remoteException);
            }
        }

        @Override
        public void setRating(RatingCompat ratingCompat, Bundle bundle) {
            try {
                this.mBinder.rateWithExtras(ratingCompat, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setRating.", (Throwable)remoteException);
            }
        }

        @Override
        public void setRepeatMode(int n2) {
            try {
                this.mBinder.setRepeatMode(n2);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setRepeatMode.", (Throwable)remoteException);
            }
        }

        @Override
        public void setShuffleMode(int n2) {
            try {
                this.mBinder.setShuffleMode(n2);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in setShuffleMode.", (Throwable)remoteException);
            }
        }

        @Override
        public void skipToNext() {
            try {
                this.mBinder.next();
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in skipToNext.", (Throwable)remoteException);
            }
        }

        @Override
        public void skipToPrevious() {
            try {
                this.mBinder.previous();
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in skipToPrevious.", (Throwable)remoteException);
            }
        }

        @Override
        public void skipToQueueItem(long l2) {
            try {
                this.mBinder.skipToQueueItem(l2);
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in skipToQueueItem.", (Throwable)remoteException);
            }
        }

        @Override
        public void stop() {
            try {
                this.mBinder.stop();
            }
            catch (RemoteException remoteException) {
                Log.e((String)MediaControllerCompat.TAG, (String)"Dead object in stop.", (Throwable)remoteException);
            }
        }
    }
}

