/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.media.Rating;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class RatingCompat
implements Parcelable {
    public static final Parcelable.Creator<RatingCompat> CREATOR = new Parcelable.Creator<RatingCompat>(){

        public RatingCompat createFromParcel(Parcel parcel) {
            return new RatingCompat(parcel.readInt(), parcel.readFloat());
        }

        public RatingCompat[] newArray(int n2) {
            return new RatingCompat[n2];
        }
    };
    public static final int RATING_3_STARS = 3;
    public static final int RATING_4_STARS = 4;
    public static final int RATING_5_STARS = 5;
    public static final int RATING_HEART = 1;
    public static final int RATING_NONE = 0;
    private static final float RATING_NOT_RATED = -1.0f;
    public static final int RATING_PERCENTAGE = 6;
    public static final int RATING_THUMB_UP_DOWN = 2;
    private static final String TAG = "Rating";
    private Object mRatingObj;
    private final int mRatingStyle;
    private final float mRatingValue;

    RatingCompat(int n2, float f2) {
        this.mRatingStyle = n2;
        this.mRatingValue = f2;
    }

    public static RatingCompat fromRating(Object object) {
        Rating rating;
        Object object2 = rating = null;
        if (object != null) {
            object2 = rating;
            if (Build.VERSION.SDK_INT >= 19) {
                object2 = (Rating)object;
                int n2 = object2.getRatingStyle();
                if (object2.isRated()) {
                    switch (n2) {
                        default: {
                            return null;
                        }
                        case 6: {
                            object2 = RatingCompat.newPercentageRating(object2.getPercentRating());
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            object2 = RatingCompat.newStarRating(n2, object2.getStarRating());
                            break;
                        }
                        case 2: {
                            object2 = RatingCompat.newThumbRating(object2.isThumbUp());
                            break;
                        }
                        case 1: {
                            object2 = RatingCompat.newHeartRating(object2.hasHeart());
                            break;
                        }
                    }
                } else {
                    object2 = RatingCompat.newUnratedRating(n2);
                }
                object2.mRatingObj = object;
            }
        }
        return object2;
    }

    public static RatingCompat newHeartRating(boolean bl) {
        float f2 = bl ? 1.0f : 0.0f;
        return new RatingCompat(1, f2);
    }

    public static RatingCompat newPercentageRating(float f2) {
        if (!(f2 < 0.0f) && !(f2 > 100.0f)) {
            return new RatingCompat(6, f2);
        }
        Log.e((String)TAG, (String)"Invalid percentage-based rating value");
        return null;
    }

    public static RatingCompat newStarRating(int n2, float f2) {
        float f3;
        if (n2 != 3) {
            if (n2 != 4) {
                if (n2 != 5) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Invalid rating style (");
                    stringBuilder.append(n2);
                    stringBuilder.append(") for a star rating");
                    Log.e((String)TAG, (String)stringBuilder.toString());
                    return null;
                }
                f3 = 5.0f;
            } else {
                f3 = 4.0f;
            }
        } else {
            f3 = 3.0f;
        }
        if (!(f2 < 0.0f) && !(f2 > f3)) {
            return new RatingCompat(n2, f2);
        }
        Log.e((String)TAG, (String)"Trying to set out of range star-based rating");
        return null;
    }

    public static RatingCompat newThumbRating(boolean bl) {
        float f2 = bl ? 1.0f : 0.0f;
        return new RatingCompat(2, f2);
    }

    public static RatingCompat newUnratedRating(int n2) {
        switch (n2) {
            default: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
        }
        return new RatingCompat(n2, -1.0f);
    }

    public int describeContents() {
        return this.mRatingStyle;
    }

    public float getPercentRating() {
        if (this.mRatingStyle == 6 && this.isRated()) {
            return this.mRatingValue;
        }
        return -1.0f;
    }

    public Object getRating() {
        if (this.mRatingObj == null && Build.VERSION.SDK_INT >= 19) {
            if (this.isRated()) {
                int n2 = this.mRatingStyle;
                switch (n2) {
                    default: {
                        return null;
                    }
                    case 6: {
                        this.mRatingObj = Rating.newPercentageRating((float)this.getPercentRating());
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.mRatingObj = Rating.newStarRating((int)n2, (float)this.getStarRating());
                        break;
                    }
                    case 2: {
                        this.mRatingObj = Rating.newThumbRating((boolean)this.isThumbUp());
                        break;
                    }
                    case 1: {
                        this.mRatingObj = Rating.newHeartRating((boolean)this.hasHeart());
                        break;
                    }
                }
            } else {
                this.mRatingObj = Rating.newUnratedRating((int)this.mRatingStyle);
            }
        }
        return this.mRatingObj;
    }

    public int getRatingStyle() {
        return this.mRatingStyle;
    }

    public float getStarRating() {
        int n2 = this.mRatingStyle;
        if ((n2 == 3 || n2 == 4 || n2 == 5) && this.isRated()) {
            return this.mRatingValue;
        }
        return -1.0f;
    }

    public boolean hasHeart() {
        int n2 = this.mRatingStyle;
        boolean bl = false;
        if (n2 != 1) {
            return false;
        }
        if (this.mRatingValue == 1.0f) {
            bl = true;
        }
        return bl;
    }

    public boolean isRated() {
        boolean bl = this.mRatingValue >= 0.0f;
        return bl;
    }

    public boolean isThumbUp() {
        int n2 = this.mRatingStyle;
        boolean bl = false;
        if (n2 != 2) {
            return false;
        }
        if (this.mRatingValue == 1.0f) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Rating:style=");
        stringBuilder.append(this.mRatingStyle);
        stringBuilder.append(" rating=");
        float f2 = this.mRatingValue;
        String string2 = f2 < 0.0f ? "unrated" : String.valueOf(f2);
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.mRatingStyle);
        parcel.writeFloat(this.mRatingValue);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StarStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Style {
    }
}

