/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.browse.MediaBrowser;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.IMediaSession;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import androidx.collection.ArrayMap;
import androidx.core.app.BundleCompat;
import androidx.media.MediaBrowserCompatUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MediaBrowserCompat {
    public static final String CUSTOM_ACTION_DOWNLOAD = "android.support.v4.media.action.DOWNLOAD";
    public static final String CUSTOM_ACTION_REMOVE_DOWNLOADED_FILE = "android.support.v4.media.action.REMOVE_DOWNLOADED_FILE";
    static final boolean DEBUG = Log.isLoggable((String)"MediaBrowserCompat", (int)3);
    public static final String EXTRA_DOWNLOAD_PROGRESS = "android.media.browse.extra.DOWNLOAD_PROGRESS";
    public static final String EXTRA_MEDIA_ID = "android.media.browse.extra.MEDIA_ID";
    public static final String EXTRA_PAGE = "android.media.browse.extra.PAGE";
    public static final String EXTRA_PAGE_SIZE = "android.media.browse.extra.PAGE_SIZE";
    static final String TAG = "MediaBrowserCompat";
    private final MediaBrowserImpl mImpl;

    public MediaBrowserCompat(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
        this.mImpl = Build.VERSION.SDK_INT >= 26 ? new MediaBrowserImplApi26(context, componentName, connectionCallback, bundle) : (Build.VERSION.SDK_INT >= 23 ? new MediaBrowserImplApi23(context, componentName, connectionCallback, bundle) : (Build.VERSION.SDK_INT >= 21 ? new MediaBrowserImplApi21(context, componentName, connectionCallback, bundle) : new MediaBrowserImplBase(context, componentName, connectionCallback, bundle)));
    }

    public void connect() {
        Log.d((String)TAG, (String)"Connecting to a MediaBrowserService.");
        this.mImpl.connect();
    }

    public void disconnect() {
        this.mImpl.disconnect();
    }

    public Bundle getExtras() {
        return this.mImpl.getExtras();
    }

    public void getItem(String string2, ItemCallback itemCallback) {
        this.mImpl.getItem(string2, itemCallback);
    }

    public Bundle getNotifyChildrenChangedOptions() {
        return this.mImpl.getNotifyChildrenChangedOptions();
    }

    public String getRoot() {
        return this.mImpl.getRoot();
    }

    public ComponentName getServiceComponent() {
        return this.mImpl.getServiceComponent();
    }

    public MediaSessionCompat.Token getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public boolean isConnected() {
        return this.mImpl.isConnected();
    }

    public void search(String string2, Bundle bundle, SearchCallback searchCallback) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (searchCallback != null) {
                this.mImpl.search(string2, bundle, searchCallback);
                return;
            }
            throw new IllegalArgumentException("callback cannot be null");
        }
        throw new IllegalArgumentException("query cannot be empty");
    }

    public void sendCustomAction(String string2, Bundle bundle, CustomActionCallback customActionCallback) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mImpl.sendCustomAction(string2, bundle, customActionCallback);
            return;
        }
        throw new IllegalArgumentException("action cannot be empty");
    }

    public void subscribe(String string2, Bundle bundle, SubscriptionCallback subscriptionCallback) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (subscriptionCallback != null) {
                if (bundle != null) {
                    this.mImpl.subscribe(string2, bundle, subscriptionCallback);
                    return;
                }
                throw new IllegalArgumentException("options are null");
            }
            throw new IllegalArgumentException("callback is null");
        }
        throw new IllegalArgumentException("parentId is empty");
    }

    public void subscribe(String string2, SubscriptionCallback subscriptionCallback) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (subscriptionCallback != null) {
                this.mImpl.subscribe(string2, null, subscriptionCallback);
                return;
            }
            throw new IllegalArgumentException("callback is null");
        }
        throw new IllegalArgumentException("parentId is empty");
    }

    public void unsubscribe(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mImpl.unsubscribe(string2, null);
            return;
        }
        throw new IllegalArgumentException("parentId is empty");
    }

    public void unsubscribe(String string2, SubscriptionCallback subscriptionCallback) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (subscriptionCallback != null) {
                this.mImpl.unsubscribe(string2, subscriptionCallback);
                return;
            }
            throw new IllegalArgumentException("callback is null");
        }
        throw new IllegalArgumentException("parentId is empty");
    }

    private static class CallbackHandler
    extends Handler {
        private final WeakReference<MediaBrowserServiceCallbackImpl> mCallbackImplRef;
        private WeakReference<Messenger> mCallbacksMessengerRef;

        CallbackHandler(MediaBrowserServiceCallbackImpl mediaBrowserServiceCallbackImpl) {
            this.mCallbackImplRef = new WeakReference<MediaBrowserServiceCallbackImpl>(mediaBrowserServiceCallbackImpl);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message message) {
            WeakReference<Messenger> weakReference = this.mCallbacksMessengerRef;
            if (weakReference == null) return;
            if (weakReference.get() == null) return;
            if (this.mCallbackImplRef.get() == null) {
                return;
            }
            Object object = message.getData();
            MediaSessionCompat.ensureClassLoader((Bundle)object);
            weakReference = (MediaBrowserServiceCallbackImpl)this.mCallbackImplRef.get();
            Messenger messenger = (Messenger)this.mCallbacksMessengerRef.get();
            try {
                int n2 = message.what;
                if (n2 == 1) {
                    Bundle bundle = object.getBundle("data_root_hints");
                    MediaSessionCompat.ensureClassLoader(bundle);
                    weakReference.onServiceConnected(messenger, object.getString("data_media_item_id"), (MediaSessionCompat.Token)object.getParcelable("data_media_session_token"), bundle);
                    return;
                }
                if (n2 == 2) {
                    weakReference.onConnectionFailed(messenger);
                    return;
                }
                if (n2 != 3) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unhandled message: ");
                    ((StringBuilder)object).append(message);
                    ((StringBuilder)object).append("\n  Client version: ");
                    ((StringBuilder)object).append(1);
                    ((StringBuilder)object).append("\n  Service version: ");
                    ((StringBuilder)object).append(message.arg1);
                    Log.w((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object).toString());
                    return;
                }
                Bundle bundle = object.getBundle("data_options");
                MediaSessionCompat.ensureClassLoader(bundle);
                Bundle bundle2 = object.getBundle("data_notify_children_changed_options");
                MediaSessionCompat.ensureClassLoader(bundle2);
                weakReference.onLoadChildren(messenger, object.getString("data_media_item_id"), object.getParcelableArrayList("data_media_item_list"), bundle, bundle2);
                return;
            }
            catch (BadParcelableException badParcelableException) {
                Log.e((String)MediaBrowserCompat.TAG, (String)"Could not unparcel the data.");
                if (message.what != 1) return;
                weakReference.onConnectionFailed(messenger);
            }
        }

        void setCallbacksMessenger(Messenger messenger) {
            this.mCallbacksMessengerRef = new WeakReference<Messenger>(messenger);
        }
    }

    public static class ConnectionCallback {
        final MediaBrowser.ConnectionCallback mConnectionCallbackFwk = Build.VERSION.SDK_INT >= 21 ? new ConnectionCallbackApi21() : null;
        ConnectionCallbackInternal mConnectionCallbackInternal;

        public void onConnected() {
        }

        public void onConnectionFailed() {
        }

        public void onConnectionSuspended() {
        }

        void setInternalConnectionCallback(ConnectionCallbackInternal connectionCallbackInternal) {
            this.mConnectionCallbackInternal = connectionCallbackInternal;
        }

        private class ConnectionCallbackApi21
        extends MediaBrowser.ConnectionCallback {
            ConnectionCallbackApi21() {
            }

            public void onConnected() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnected();
                }
                ConnectionCallback.this.onConnected();
            }

            public void onConnectionFailed() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnectionFailed();
                }
                ConnectionCallback.this.onConnectionFailed();
            }

            public void onConnectionSuspended() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnectionSuspended();
                }
                ConnectionCallback.this.onConnectionSuspended();
            }
        }

        static interface ConnectionCallbackInternal {
            public void onConnected();

            public void onConnectionFailed();

            public void onConnectionSuspended();
        }
    }

    public static abstract class CustomActionCallback {
        public void onError(String string2, Bundle bundle, Bundle bundle2) {
        }

        public void onProgressUpdate(String string2, Bundle bundle, Bundle bundle2) {
        }

        public void onResult(String string2, Bundle bundle, Bundle bundle2) {
        }
    }

    private static class CustomActionResultReceiver
    extends ResultReceiver {
        private final String mAction;
        private final CustomActionCallback mCallback;
        private final Bundle mExtras;

        CustomActionResultReceiver(String string2, Bundle bundle, CustomActionCallback customActionCallback, Handler handler) {
            super(handler);
            this.mAction = string2;
            this.mExtras = bundle;
            this.mCallback = customActionCallback;
        }

        protected void onReceiveResult(int n2, Bundle bundle) {
            if (this.mCallback == null) {
                return;
            }
            MediaSessionCompat.ensureClassLoader(bundle);
            if (n2 != -1) {
                if (n2 != 0) {
                    if (n2 != 1) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Unknown result code: ");
                        stringBuilder.append(n2);
                        stringBuilder.append(" (extras=");
                        stringBuilder.append(this.mExtras);
                        stringBuilder.append(", resultData=");
                        stringBuilder.append(bundle);
                        stringBuilder.append(")");
                        Log.w((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                    } else {
                        this.mCallback.onProgressUpdate(this.mAction, this.mExtras, bundle);
                    }
                } else {
                    this.mCallback.onResult(this.mAction, this.mExtras, bundle);
                }
            } else {
                this.mCallback.onError(this.mAction, this.mExtras, bundle);
            }
        }
    }

    public static abstract class ItemCallback {
        final MediaBrowser.ItemCallback mItemCallbackFwk = Build.VERSION.SDK_INT >= 23 ? new ItemCallbackApi23() : null;

        public void onError(String string2) {
        }

        public void onItemLoaded(MediaItem mediaItem) {
        }

        private class ItemCallbackApi23
        extends MediaBrowser.ItemCallback {
            ItemCallbackApi23() {
            }

            public void onError(String string2) {
                ItemCallback.this.onError(string2);
            }

            public void onItemLoaded(MediaBrowser.MediaItem mediaItem) {
                ItemCallback.this.onItemLoaded(MediaItem.fromMediaItem(mediaItem));
            }
        }
    }

    private static class ItemReceiver
    extends ResultReceiver {
        private final ItemCallback mCallback;
        private final String mMediaId;

        ItemReceiver(String string2, ItemCallback itemCallback, Handler handler) {
            super(handler);
            this.mMediaId = string2;
            this.mCallback = itemCallback;
        }

        protected void onReceiveResult(int n2, Bundle bundle) {
            Bundle bundle2 = bundle;
            if (bundle != null) {
                bundle2 = MediaSessionCompat.unparcelWithClassLoader(bundle);
            }
            if (n2 == 0 && bundle2 != null && bundle2.containsKey("media_item")) {
                bundle = bundle2.getParcelable("media_item");
                if (bundle != null && !(bundle instanceof MediaItem)) {
                    this.mCallback.onError(this.mMediaId);
                } else {
                    this.mCallback.onItemLoaded((MediaItem)bundle);
                }
                return;
            }
            this.mCallback.onError(this.mMediaId);
        }
    }

    static interface MediaBrowserImpl {
        public void connect();

        public void disconnect();

        public Bundle getExtras();

        public void getItem(String var1, ItemCallback var2);

        public Bundle getNotifyChildrenChangedOptions();

        public String getRoot();

        public ComponentName getServiceComponent();

        public MediaSessionCompat.Token getSessionToken();

        public boolean isConnected();

        public void search(String var1, Bundle var2, SearchCallback var3);

        public void sendCustomAction(String var1, Bundle var2, CustomActionCallback var3);

        public void subscribe(String var1, Bundle var2, SubscriptionCallback var3);

        public void unsubscribe(String var1, SubscriptionCallback var2);
    }

    static class MediaBrowserImplApi21
    implements MediaBrowserImpl,
    MediaBrowserServiceCallbackImpl,
    ConnectionCallback.ConnectionCallbackInternal {
        protected final MediaBrowser mBrowserFwk;
        protected Messenger mCallbacksMessenger;
        final Context mContext;
        protected final CallbackHandler mHandler = new CallbackHandler(this);
        private MediaSessionCompat.Token mMediaSessionToken;
        private Bundle mNotifyChildrenChangedOptions;
        protected final Bundle mRootHints;
        protected ServiceBinderWrapper mServiceBinderWrapper;
        protected int mServiceVersion;
        private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();

        MediaBrowserImplApi21(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
            this.mContext = context;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            this.mRootHints = bundle2;
            this.mRootHints.putInt("extra_client_version", 1);
            this.mRootHints.putInt("extra_calling_pid", Process.myPid());
            connectionCallback.setInternalConnectionCallback(this);
            this.mBrowserFwk = new MediaBrowser(context, componentName, connectionCallback.mConnectionCallbackFwk, this.mRootHints);
        }

        @Override
        public void connect() {
            this.mBrowserFwk.connect();
        }

        @Override
        public void disconnect() {
            Messenger messenger;
            ServiceBinderWrapper serviceBinderWrapper = this.mServiceBinderWrapper;
            if (serviceBinderWrapper != null && (messenger = this.mCallbacksMessenger) != null) {
                try {
                    serviceBinderWrapper.unregisterCallbackMessenger(messenger);
                }
                catch (RemoteException remoteException) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)"Remote error unregistering client messenger.");
                }
            }
            this.mBrowserFwk.disconnect();
        }

        @Override
        public Bundle getExtras() {
            return this.mBrowserFwk.getExtras();
        }

        @Override
        public void getItem(final String string2, final ItemCallback itemCallback) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                if (itemCallback != null) {
                    if (!this.mBrowserFwk.isConnected()) {
                        Log.i((String)MediaBrowserCompat.TAG, (String)"Not connected, unable to retrieve the MediaItem.");
                        this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                itemCallback.onError(string2);
                            }
                        });
                        return;
                    }
                    if (this.mServiceBinderWrapper == null) {
                        this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                itemCallback.onError(string2);
                            }
                        });
                        return;
                    }
                    ItemReceiver itemReceiver = new ItemReceiver(string2, itemCallback, this.mHandler);
                    try {
                        this.mServiceBinderWrapper.getMediaItem(string2, itemReceiver, this.mCallbacksMessenger);
                    }
                    catch (RemoteException remoteException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Remote error getting media item: ");
                        stringBuilder.append(string2);
                        Log.i((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                        this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                itemCallback.onError(string2);
                            }
                        });
                    }
                    return;
                }
                throw new IllegalArgumentException("cb is null");
            }
            throw new IllegalArgumentException("mediaId is empty");
        }

        @Override
        public Bundle getNotifyChildrenChangedOptions() {
            return this.mNotifyChildrenChangedOptions;
        }

        @Override
        public String getRoot() {
            return this.mBrowserFwk.getRoot();
        }

        @Override
        public ComponentName getServiceComponent() {
            return this.mBrowserFwk.getServiceComponent();
        }

        @Override
        public MediaSessionCompat.Token getSessionToken() {
            if (this.mMediaSessionToken == null) {
                this.mMediaSessionToken = MediaSessionCompat.Token.fromToken(this.mBrowserFwk.getSessionToken());
            }
            return this.mMediaSessionToken;
        }

        @Override
        public boolean isConnected() {
            return this.mBrowserFwk.isConnected();
        }

        @Override
        public void onConnected() {
            Bundle bundle;
            block6: {
                try {
                    bundle = this.mBrowserFwk.getExtras();
                    if (bundle != null) break block6;
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    Log.e((String)MediaBrowserCompat.TAG, (String)"Unexpected IllegalStateException", (Throwable)illegalStateException);
                    return;
                }
            }
            this.mServiceVersion = bundle.getInt("extra_service_version", 0);
            IBinder iBinder = BundleCompat.getBinder((Bundle)bundle, (String)"extra_messenger");
            if (iBinder != null) {
                this.mServiceBinderWrapper = new ServiceBinderWrapper(iBinder, this.mRootHints);
                this.mCallbacksMessenger = new Messenger((Handler)this.mHandler);
                this.mHandler.setCallbacksMessenger(this.mCallbacksMessenger);
                try {
                    this.mServiceBinderWrapper.registerCallbackMessenger(this.mContext, this.mCallbacksMessenger);
                }
                catch (RemoteException remoteException) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)"Remote error registering client messenger.");
                }
            }
            if ((bundle = IMediaSession.Stub.asInterface((IBinder)BundleCompat.getBinder((Bundle)bundle, (String)"extra_session_binder"))) != null) {
                this.mMediaSessionToken = MediaSessionCompat.Token.fromToken(this.mBrowserFwk.getSessionToken(), (IMediaSession)bundle);
            }
        }

        @Override
        public void onConnectionFailed() {
        }

        @Override
        public void onConnectionFailed(Messenger messenger) {
        }

        @Override
        public void onConnectionSuspended() {
            this.mServiceBinderWrapper = null;
            this.mCallbacksMessenger = null;
            this.mMediaSessionToken = null;
            this.mHandler.setCallbacksMessenger(null);
        }

        @Override
        public void onLoadChildren(Messenger object, String string2, List<MediaItem> list, Bundle bundle, Bundle bundle2) {
            if (this.mCallbacksMessenger != object) {
                return;
            }
            object = (Subscription)this.mSubscriptions.get((Object)string2);
            if (object == null) {
                if (DEBUG) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onLoadChildren for id that isn't subscribed id=");
                    ((StringBuilder)object).append(string2);
                    Log.d((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object).toString());
                }
                return;
            }
            if ((object = ((Subscription)object).getCallback(bundle)) != null) {
                if (bundle == null) {
                    if (list == null) {
                        ((SubscriptionCallback)object).onError(string2);
                    } else {
                        this.mNotifyChildrenChangedOptions = bundle2;
                        ((SubscriptionCallback)object).onChildrenLoaded(string2, list);
                        this.mNotifyChildrenChangedOptions = null;
                    }
                } else if (list == null) {
                    ((SubscriptionCallback)object).onError(string2, bundle);
                } else {
                    this.mNotifyChildrenChangedOptions = bundle2;
                    ((SubscriptionCallback)object).onChildrenLoaded(string2, list, bundle);
                    this.mNotifyChildrenChangedOptions = null;
                }
            }
        }

        @Override
        public void onServiceConnected(Messenger messenger, String string2, MediaSessionCompat.Token token, Bundle bundle) {
        }

        @Override
        public void search(final String string2, final Bundle bundle, final SearchCallback searchCallback) {
            if (this.isConnected()) {
                if (this.mServiceBinderWrapper == null) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)"The connected service doesn't support search.");
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            searchCallback.onError(string2, bundle);
                        }
                    });
                    return;
                }
                Object object = new SearchResultReceiver(string2, bundle, searchCallback, this.mHandler);
                try {
                    this.mServiceBinderWrapper.search(string2, bundle, (ResultReceiver)object, this.mCallbacksMessenger);
                }
                catch (RemoteException remoteException) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Remote error searching items with query: ");
                    ((StringBuilder)object).append(string2);
                    Log.i((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object).toString(), (Throwable)remoteException);
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            searchCallback.onError(string2, bundle);
                        }
                    });
                }
                return;
            }
            throw new IllegalStateException("search() called while not connected");
        }

        @Override
        public void sendCustomAction(String string2, Bundle bundle, CustomActionCallback object) {
            if (this.isConnected()) {
                block5: {
                    if (this.mServiceBinderWrapper == null) {
                        Log.i((String)MediaBrowserCompat.TAG, (String)"The connected service doesn't support sendCustomAction.");
                        if (object != null) {
                            this.mHandler.post(new Runnable((CustomActionCallback)object, string2, bundle){
                                final /* synthetic */ String val$action;
                                final /* synthetic */ CustomActionCallback val$callback;
                                final /* synthetic */ Bundle val$extras;
                                {
                                    this.val$callback = customActionCallback;
                                    this.val$action = string2;
                                    this.val$extras = bundle;
                                }

                                @Override
                                public void run() {
                                    this.val$callback.onError(this.val$action, this.val$extras, null);
                                }
                            });
                        }
                    }
                    Object object2 = new CustomActionResultReceiver(string2, bundle, (CustomActionCallback)object, this.mHandler);
                    try {
                        this.mServiceBinderWrapper.sendCustomAction(string2, bundle, (ResultReceiver)object2, this.mCallbacksMessenger);
                    }
                    catch (RemoteException remoteException) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Remote error sending a custom action: action=");
                        ((StringBuilder)object2).append(string2);
                        ((StringBuilder)object2).append(", extras=");
                        ((StringBuilder)object2).append(bundle);
                        Log.i((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object2).toString(), (Throwable)remoteException);
                        if (object == null) break block5;
                        this.mHandler.post(new Runnable((CustomActionCallback)object, string2, bundle){
                            final /* synthetic */ String val$action;
                            final /* synthetic */ CustomActionCallback val$callback;
                            final /* synthetic */ Bundle val$extras;
                            {
                                this.val$callback = customActionCallback;
                                this.val$action = string2;
                                this.val$extras = bundle;
                            }

                            @Override
                            public void run() {
                                this.val$callback.onError(this.val$action, this.val$extras, null);
                            }
                        });
                    }
                }
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot send a custom action (");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(") with extras ");
            ((StringBuilder)object).append(bundle);
            ((StringBuilder)object).append(" because the browser is not connected to the service.");
            throw new IllegalStateException(((StringBuilder)object).toString());
        }

        @Override
        public void subscribe(String string2, Bundle object, SubscriptionCallback subscriptionCallback) {
            Subscription subscription = (Subscription)this.mSubscriptions.get((Object)string2);
            Object object2 = subscription;
            if (subscription == null) {
                object2 = new Subscription();
                this.mSubscriptions.put((Object)string2, object2);
            }
            subscriptionCallback.setSubscription((Subscription)object2);
            object = object == null ? null : new Bundle(object);
            ((Subscription)object2).putCallback((Bundle)object, subscriptionCallback);
            object2 = this.mServiceBinderWrapper;
            if (object2 == null) {
                this.mBrowserFwk.subscribe(string2, subscriptionCallback.mSubscriptionCallbackFwk);
            } else {
                try {
                    ((ServiceBinderWrapper)object2).addSubscription(string2, subscriptionCallback.mToken, (Bundle)object, this.mCallbacksMessenger);
                }
                catch (RemoteException remoteException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Remote error subscribing media item: ");
                    stringBuilder.append(string2);
                    Log.i((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                }
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void unsubscribe(String var1_1, SubscriptionCallback var2_2) {
            block9: {
                block10: {
                    var3_3 = (Subscription)this.mSubscriptions.get((Object)var1_1);
                    if (var3_3 == null) {
                        return;
                    }
                    var4_4 = this.mServiceBinderWrapper;
                    if (var4_4 != null) break block10;
                    if (var2_2 == null) {
                        this.mBrowserFwk.unsubscribe(var1_1);
                        break block9;
                    } else {
                        var5_7 = var3_3.getCallbacks();
                        var4_4 = var3_3.getOptionsList();
                        for (var6_9 = var5_7.size() - 1; var6_9 >= 0; --var6_9) {
                            if (var5_7.get(var6_9) != var2_2) continue;
                            var5_7.remove(var6_9);
                            var4_4.remove(var6_9);
                        }
                        if (var5_7.size() == 0) {
                            this.mBrowserFwk.unsubscribe(var1_1);
                        }
                    }
                    break block9;
                }
                if (var2_2 != null) ** GOTO lbl26
                try {
                    var4_4.removeSubscription(var1_1, null, this.mCallbacksMessenger);
                    break block9;
lbl26:
                    // 1 sources

                    var5_8 = var3_3.getCallbacks();
                    var4_4 = var3_3.getOptionsList();
                    for (var6_10 = var5_8.size() - 1; var6_10 >= 0; --var6_10) {
                        if (var5_8.get(var6_10) != var2_2) continue;
                        this.mServiceBinderWrapper.removeSubscription(var1_1, var2_2.mToken, this.mCallbacksMessenger);
                        var5_8.remove(var6_10);
                        var4_4.remove(var6_10);
                    }
                }
                catch (RemoteException var4_5) {
                    var4_6 = new StringBuilder();
                    var4_6.append("removeSubscription failed with RemoteException parentId=");
                    var4_6.append(var1_1);
                    Log.d((String)"MediaBrowserCompat", (String)var4_6.toString());
                }
            }
            if (var3_3.isEmpty() || var2_2 == null) {
                this.mSubscriptions.remove((Object)var1_1);
            }
        }
    }

    static class MediaBrowserImplApi23
    extends MediaBrowserImplApi21 {
        MediaBrowserImplApi23(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
            super(context, componentName, connectionCallback, bundle);
        }

        @Override
        public void getItem(String string2, ItemCallback itemCallback) {
            if (this.mServiceBinderWrapper == null) {
                this.mBrowserFwk.getItem(string2, itemCallback.mItemCallbackFwk);
            } else {
                super.getItem(string2, itemCallback);
            }
        }
    }

    static class MediaBrowserImplApi26
    extends MediaBrowserImplApi23 {
        MediaBrowserImplApi26(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
            super(context, componentName, connectionCallback, bundle);
        }

        @Override
        public void subscribe(String string2, Bundle bundle, SubscriptionCallback subscriptionCallback) {
            if (this.mServiceBinderWrapper != null && this.mServiceVersion >= 2) {
                super.subscribe(string2, bundle, subscriptionCallback);
            } else if (bundle == null) {
                this.mBrowserFwk.subscribe(string2, subscriptionCallback.mSubscriptionCallbackFwk);
            } else {
                this.mBrowserFwk.subscribe(string2, bundle, subscriptionCallback.mSubscriptionCallbackFwk);
            }
        }

        @Override
        public void unsubscribe(String string2, SubscriptionCallback subscriptionCallback) {
            if (this.mServiceBinderWrapper != null && this.mServiceVersion >= 2) {
                super.unsubscribe(string2, subscriptionCallback);
            } else if (subscriptionCallback == null) {
                this.mBrowserFwk.unsubscribe(string2);
            } else {
                this.mBrowserFwk.unsubscribe(string2, subscriptionCallback.mSubscriptionCallbackFwk);
            }
        }
    }

    static class MediaBrowserImplBase
    implements MediaBrowserImpl,
    MediaBrowserServiceCallbackImpl {
        static final int CONNECT_STATE_CONNECTED = 3;
        static final int CONNECT_STATE_CONNECTING = 2;
        static final int CONNECT_STATE_DISCONNECTED = 1;
        static final int CONNECT_STATE_DISCONNECTING = 0;
        static final int CONNECT_STATE_SUSPENDED = 4;
        final ConnectionCallback mCallback;
        Messenger mCallbacksMessenger;
        final Context mContext;
        private Bundle mExtras;
        final CallbackHandler mHandler = new CallbackHandler(this);
        private MediaSessionCompat.Token mMediaSessionToken;
        private Bundle mNotifyChildrenChangedOptions;
        final Bundle mRootHints;
        private String mRootId;
        ServiceBinderWrapper mServiceBinderWrapper;
        final ComponentName mServiceComponent;
        MediaServiceConnection mServiceConnection;
        int mState = 1;
        private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();

        public MediaBrowserImplBase(Context object, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
            if (object != null) {
                if (componentName != null) {
                    if (connectionCallback != null) {
                        this.mContext = object;
                        this.mServiceComponent = componentName;
                        this.mCallback = connectionCallback;
                        object = bundle == null ? null : new Bundle(bundle);
                        this.mRootHints = object;
                        return;
                    }
                    throw new IllegalArgumentException("connection callback must not be null");
                }
                throw new IllegalArgumentException("service component must not be null");
            }
            throw new IllegalArgumentException("context must not be null");
        }

        private static String getStateLabel(int n2) {
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 != 3) {
                            if (n2 != 4) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("UNKNOWN/");
                                stringBuilder.append(n2);
                                return stringBuilder.toString();
                            }
                            return "CONNECT_STATE_SUSPENDED";
                        }
                        return "CONNECT_STATE_CONNECTED";
                    }
                    return "CONNECT_STATE_CONNECTING";
                }
                return "CONNECT_STATE_DISCONNECTED";
            }
            return "CONNECT_STATE_DISCONNECTING";
        }

        private boolean isCurrent(Messenger object, String string2) {
            int n2;
            if (this.mCallbacksMessenger == object && (n2 = this.mState) != 0 && n2 != 1) {
                return true;
            }
            n2 = this.mState;
            if (n2 != 0 && n2 != 1) {
                object = new StringBuilder();
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" for ");
                ((StringBuilder)object).append(this.mServiceComponent);
                ((StringBuilder)object).append(" with mCallbacksMessenger=");
                ((StringBuilder)object).append(this.mCallbacksMessenger);
                ((StringBuilder)object).append(" this=");
                ((StringBuilder)object).append(this);
                Log.i((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object).toString());
            }
            return false;
        }

        @Override
        public void connect() {
            int n2 = this.mState;
            if (n2 != 0 && n2 != 1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("connect() called while neigther disconnecting nor disconnected (state=");
                stringBuilder.append(MediaBrowserImplBase.getStateLabel(this.mState));
                stringBuilder.append(")");
                throw new IllegalStateException(stringBuilder.toString());
            }
            this.mState = 2;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (MediaBrowserImplBase.this.mState == 0) {
                        return;
                    }
                    MediaBrowserImplBase.this.mState = 2;
                    if (DEBUG && MediaBrowserImplBase.this.mServiceConnection != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("mServiceConnection should be null. Instead it is ");
                        stringBuilder.append(MediaBrowserImplBase.this.mServiceConnection);
                        throw new RuntimeException(stringBuilder.toString());
                    }
                    if (MediaBrowserImplBase.this.mServiceBinderWrapper == null) {
                        if (MediaBrowserImplBase.this.mCallbacksMessenger == null) {
                            boolean bl;
                            Intent intent = new Intent("android.media.browse.MediaBrowserService");
                            intent.setComponent(MediaBrowserImplBase.this.mServiceComponent);
                            MediaBrowserImplBase mediaBrowserImplBase = MediaBrowserImplBase.this;
                            mediaBrowserImplBase.mServiceConnection = mediaBrowserImplBase.new MediaServiceConnection();
                            boolean bl2 = false;
                            try {
                                bl = MediaBrowserImplBase.this.mContext.bindService(intent, (ServiceConnection)MediaBrowserImplBase.this.mServiceConnection, 1);
                            }
                            catch (Exception exception) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("Failed binding to service ");
                                stringBuilder.append(MediaBrowserImplBase.this.mServiceComponent);
                                Log.e((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                                bl = bl2;
                            }
                            if (!bl) {
                                MediaBrowserImplBase.this.forceCloseConnection();
                                MediaBrowserImplBase.this.mCallback.onConnectionFailed();
                            }
                            if (DEBUG) {
                                Log.d((String)MediaBrowserCompat.TAG, (String)"connect...");
                                MediaBrowserImplBase.this.dump();
                            }
                            return;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("mCallbacksMessenger should be null. Instead it is ");
                        stringBuilder.append(MediaBrowserImplBase.this.mCallbacksMessenger);
                        throw new RuntimeException(stringBuilder.toString());
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("mServiceBinderWrapper should be null. Instead it is ");
                    stringBuilder.append(MediaBrowserImplBase.this.mServiceBinderWrapper);
                    throw new RuntimeException(stringBuilder.toString());
                }
            });
        }

        @Override
        public void disconnect() {
            this.mState = 0;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (MediaBrowserImplBase.this.mCallbacksMessenger != null) {
                        try {
                            MediaBrowserImplBase.this.mServiceBinderWrapper.disconnect(MediaBrowserImplBase.this.mCallbacksMessenger);
                        }
                        catch (RemoteException remoteException) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("RemoteException during connect for ");
                            stringBuilder.append(MediaBrowserImplBase.this.mServiceComponent);
                            Log.w((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                        }
                    }
                    int n2 = MediaBrowserImplBase.this.mState;
                    MediaBrowserImplBase.this.forceCloseConnection();
                    if (n2 != 0) {
                        MediaBrowserImplBase.this.mState = n2;
                    }
                    if (DEBUG) {
                        Log.d((String)MediaBrowserCompat.TAG, (String)"disconnect...");
                        MediaBrowserImplBase.this.dump();
                    }
                }
            });
        }

        void dump() {
            Log.d((String)MediaBrowserCompat.TAG, (String)"MediaBrowserCompat...");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  mServiceComponent=");
            stringBuilder.append(this.mServiceComponent);
            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("  mCallback=");
            stringBuilder.append(this.mCallback);
            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("  mRootHints=");
            stringBuilder.append(this.mRootHints);
            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("  mState=");
            stringBuilder.append(MediaBrowserImplBase.getStateLabel(this.mState));
            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("  mServiceConnection=");
            stringBuilder.append(this.mServiceConnection);
            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("  mServiceBinderWrapper=");
            stringBuilder.append(this.mServiceBinderWrapper);
            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("  mCallbacksMessenger=");
            stringBuilder.append(this.mCallbacksMessenger);
            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("  mRootId=");
            stringBuilder.append(this.mRootId);
            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("  mMediaSessionToken=");
            stringBuilder.append(this.mMediaSessionToken);
            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
        }

        void forceCloseConnection() {
            MediaServiceConnection mediaServiceConnection = this.mServiceConnection;
            if (mediaServiceConnection != null) {
                this.mContext.unbindService((ServiceConnection)mediaServiceConnection);
            }
            this.mState = 1;
            this.mServiceConnection = null;
            this.mServiceBinderWrapper = null;
            this.mCallbacksMessenger = null;
            this.mHandler.setCallbacksMessenger(null);
            this.mRootId = null;
            this.mMediaSessionToken = null;
        }

        @Override
        public Bundle getExtras() {
            if (this.isConnected()) {
                return this.mExtras;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("getExtras() called while not connected (state=");
            stringBuilder.append(MediaBrowserImplBase.getStateLabel(this.mState));
            stringBuilder.append(")");
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public void getItem(final String string2, final ItemCallback itemCallback) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                if (itemCallback != null) {
                    if (!this.isConnected()) {
                        Log.i((String)MediaBrowserCompat.TAG, (String)"Not connected, unable to retrieve the MediaItem.");
                        this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                itemCallback.onError(string2);
                            }
                        });
                        return;
                    }
                    ItemReceiver itemReceiver = new ItemReceiver(string2, itemCallback, this.mHandler);
                    try {
                        this.mServiceBinderWrapper.getMediaItem(string2, itemReceiver, this.mCallbacksMessenger);
                    }
                    catch (RemoteException remoteException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Remote error getting media item: ");
                        stringBuilder.append(string2);
                        Log.i((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                        this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                itemCallback.onError(string2);
                            }
                        });
                    }
                    return;
                }
                throw new IllegalArgumentException("cb is null");
            }
            throw new IllegalArgumentException("mediaId is empty");
        }

        @Override
        public Bundle getNotifyChildrenChangedOptions() {
            return this.mNotifyChildrenChangedOptions;
        }

        @Override
        public String getRoot() {
            if (this.isConnected()) {
                return this.mRootId;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("getRoot() called while not connected(state=");
            stringBuilder.append(MediaBrowserImplBase.getStateLabel(this.mState));
            stringBuilder.append(")");
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public ComponentName getServiceComponent() {
            if (this.isConnected()) {
                return this.mServiceComponent;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("getServiceComponent() called while not connected (state=");
            stringBuilder.append(this.mState);
            stringBuilder.append(")");
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public MediaSessionCompat.Token getSessionToken() {
            if (this.isConnected()) {
                return this.mMediaSessionToken;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("getSessionToken() called while not connected(state=");
            stringBuilder.append(this.mState);
            stringBuilder.append(")");
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public boolean isConnected() {
            boolean bl = this.mState == 3;
            return bl;
        }

        @Override
        public void onConnectionFailed(Messenger object) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("onConnectFailed for ");
            stringBuilder.append(this.mServiceComponent);
            Log.e((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
            if (!this.isCurrent((Messenger)object, "onConnectFailed")) {
                return;
            }
            if (this.mState != 2) {
                object = new StringBuilder();
                ((StringBuilder)object).append("onConnect from service while mState=");
                ((StringBuilder)object).append(MediaBrowserImplBase.getStateLabel(this.mState));
                ((StringBuilder)object).append("... ignoring");
                Log.w((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object).toString());
                return;
            }
            this.forceCloseConnection();
            this.mCallback.onConnectionFailed();
        }

        @Override
        public void onLoadChildren(Messenger object, String string2, List<MediaItem> list, Bundle bundle, Bundle bundle2) {
            if (!this.isCurrent((Messenger)object, "onLoadChildren")) {
                return;
            }
            if (DEBUG) {
                object = new StringBuilder();
                ((StringBuilder)object).append("onLoadChildren for ");
                ((StringBuilder)object).append(this.mServiceComponent);
                ((StringBuilder)object).append(" id=");
                ((StringBuilder)object).append(string2);
                Log.d((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object).toString());
            }
            if ((object = (Subscription)this.mSubscriptions.get((Object)string2)) == null) {
                if (DEBUG) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onLoadChildren for id that isn't subscribed id=");
                    ((StringBuilder)object).append(string2);
                    Log.d((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object).toString());
                }
                return;
            }
            if ((object = ((Subscription)object).getCallback(bundle)) != null) {
                if (bundle == null) {
                    if (list == null) {
                        ((SubscriptionCallback)object).onError(string2);
                    } else {
                        this.mNotifyChildrenChangedOptions = bundle2;
                        ((SubscriptionCallback)object).onChildrenLoaded(string2, list);
                        this.mNotifyChildrenChangedOptions = null;
                    }
                } else if (list == null) {
                    ((SubscriptionCallback)object).onError(string2, bundle);
                } else {
                    this.mNotifyChildrenChangedOptions = bundle2;
                    ((SubscriptionCallback)object).onChildrenLoaded(string2, list, bundle);
                    this.mNotifyChildrenChangedOptions = null;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onServiceConnected(Messenger object, String iterator2, MediaSessionCompat.Token list2, Bundle object2) {
            if (!this.isCurrent((Messenger)object, "onConnect")) {
                return;
            }
            if (this.mState != 2) {
                object = new StringBuilder();
                ((StringBuilder)object).append("onConnect from service while mState=");
                ((StringBuilder)object).append(MediaBrowserImplBase.getStateLabel(this.mState));
                ((StringBuilder)object).append("... ignoring");
                Log.w((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object).toString());
                return;
            }
            this.mRootId = iterator2;
            this.mMediaSessionToken = list2;
            this.mExtras = object2;
            this.mState = 3;
            if (DEBUG) {
                Log.d((String)MediaBrowserCompat.TAG, (String)"ServiceCallbacks.onConnect...");
                this.dump();
            }
            this.mCallback.onConnected();
            try {
                for (List<SubscriptionCallback> list2 : this.mSubscriptions.entrySet()) {
                    object = (String)list2.getKey();
                    object2 = (Subscription)list2.getValue();
                    list2 = ((Subscription)object2).getCallbacks();
                    object2 = ((Subscription)object2).getOptionsList();
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        this.mServiceBinderWrapper.addSubscription((String)object, list2.get((int)i2).mToken, (Bundle)object2.get(i2), this.mCallbacksMessenger);
                    }
                }
                return;
            }
            catch (RemoteException remoteException) {
                Log.d((String)MediaBrowserCompat.TAG, (String)"addSubscription failed with RemoteException.");
            }
        }

        @Override
        public void search(String charSequence, Bundle bundle, final SearchCallback searchCallback) {
            if (this.isConnected()) {
                Object object = new SearchResultReceiver((String)charSequence, bundle, searchCallback, this.mHandler);
                try {
                    this.mServiceBinderWrapper.search((String)charSequence, bundle, (ResultReceiver)object, this.mCallbacksMessenger);
                }
                catch (RemoteException remoteException) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Remote error searching items with query: ");
                    ((StringBuilder)object).append((String)charSequence);
                    Log.i((String)MediaBrowserCompat.TAG, (String)((StringBuilder)object).toString(), (Throwable)remoteException);
                    this.mHandler.post(new Runnable((String)charSequence, bundle){
                        final /* synthetic */ Bundle val$extras;
                        final /* synthetic */ String val$query;
                        {
                            this.val$query = string2;
                            this.val$extras = bundle;
                        }

                        @Override
                        public void run() {
                            searchCallback.onError(this.val$query, this.val$extras);
                        }
                    });
                }
                return;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("search() called while not connected (state=");
            ((StringBuilder)charSequence).append(MediaBrowserImplBase.getStateLabel(this.mState));
            ((StringBuilder)charSequence).append(")");
            throw new IllegalStateException(((StringBuilder)charSequence).toString());
        }

        @Override
        public void sendCustomAction(String string2, Bundle bundle, CustomActionCallback object) {
            if (this.isConnected()) {
                block3: {
                    CustomActionResultReceiver customActionResultReceiver = new CustomActionResultReceiver(string2, bundle, (CustomActionCallback)object, this.mHandler);
                    try {
                        this.mServiceBinderWrapper.sendCustomAction(string2, bundle, customActionResultReceiver, this.mCallbacksMessenger);
                    }
                    catch (RemoteException remoteException) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Remote error sending a custom action: action=");
                        stringBuilder.append(string2);
                        stringBuilder.append(", extras=");
                        stringBuilder.append(bundle);
                        Log.i((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString(), (Throwable)remoteException);
                        if (object == null) break block3;
                        this.mHandler.post(new Runnable((CustomActionCallback)object, string2, bundle){
                            final /* synthetic */ String val$action;
                            final /* synthetic */ CustomActionCallback val$callback;
                            final /* synthetic */ Bundle val$extras;
                            {
                                this.val$callback = customActionCallback;
                                this.val$action = string2;
                                this.val$extras = bundle;
                            }

                            @Override
                            public void run() {
                                this.val$callback.onError(this.val$action, this.val$extras, null);
                            }
                        });
                    }
                }
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot send a custom action (");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(") with extras ");
            ((StringBuilder)object).append(bundle);
            ((StringBuilder)object).append(" because the browser is not connected to the service.");
            throw new IllegalStateException(((StringBuilder)object).toString());
        }

        @Override
        public void subscribe(String string2, Bundle object, SubscriptionCallback subscriptionCallback) {
            Subscription subscription;
            Subscription subscription2 = subscription = (Subscription)this.mSubscriptions.get((Object)string2);
            if (subscription == null) {
                subscription2 = new Subscription();
                this.mSubscriptions.put((Object)string2, (Object)subscription2);
            }
            object = object == null ? null : new Bundle(object);
            subscription2.putCallback((Bundle)object, subscriptionCallback);
            if (this.isConnected()) {
                try {
                    this.mServiceBinderWrapper.addSubscription(string2, subscriptionCallback.mToken, (Bundle)object, this.mCallbacksMessenger);
                }
                catch (RemoteException remoteException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("addSubscription failed with RemoteException parentId=");
                    stringBuilder.append(string2);
                    Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void unsubscribe(String var1_1, SubscriptionCallback var2_2) {
            block7: {
                var3_3 = (Subscription)this.mSubscriptions.get((Object)var1_1);
                if (var3_3 == null) {
                    return;
                }
                if (var2_2 != null) ** GOTO lbl9
                if (!this.isConnected()) break block7;
                this.mServiceBinderWrapper.removeSubscription(var1_1, null, this.mCallbacksMessenger);
                break block7;
lbl9:
                // 1 sources

                var4_4 = var3_3.getCallbacks();
                var5_5 = var3_3.getOptionsList();
                for (var6_8 = var4_4.size() - 1; var6_8 >= 0; --var6_8) {
                    try {
                        if (var4_4.get(var6_8) != var2_2) continue;
                        if (this.isConnected()) {
                            this.mServiceBinderWrapper.removeSubscription(var1_1, var2_2.mToken, this.mCallbacksMessenger);
                        }
                        var4_4.remove(var6_8);
                        var5_5.remove(var6_8);
                        continue;
                    }
                    catch (RemoteException var5_6) {
                        var5_7 = new StringBuilder();
                        var5_7.append("removeSubscription failed with RemoteException parentId=");
                        var5_7.append(var1_1);
                        Log.d((String)"MediaBrowserCompat", (String)var5_7.toString());
                        break;
                    }
                }
            }
            if (var3_3.isEmpty() || var2_2 == null) {
                this.mSubscriptions.remove((Object)var1_1);
            }
        }

        private class MediaServiceConnection
        implements ServiceConnection {
            MediaServiceConnection() {
            }

            private void postOrRun(Runnable runnable2) {
                if (Thread.currentThread() == MediaBrowserImplBase.this.mHandler.getLooper().getThread()) {
                    runnable2.run();
                } else {
                    MediaBrowserImplBase.this.mHandler.post(runnable2);
                }
            }

            boolean isCurrent(String string2) {
                if (MediaBrowserImplBase.this.mServiceConnection == this && MediaBrowserImplBase.this.mState != 0 && MediaBrowserImplBase.this.mState != 1) {
                    return true;
                }
                if (MediaBrowserImplBase.this.mState != 0 && MediaBrowserImplBase.this.mState != 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string2);
                    stringBuilder.append(" for ");
                    stringBuilder.append(MediaBrowserImplBase.this.mServiceComponent);
                    stringBuilder.append(" with mServiceConnection=");
                    stringBuilder.append(MediaBrowserImplBase.this.mServiceConnection);
                    stringBuilder.append(" this=");
                    stringBuilder.append(this);
                    Log.i((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                }
                return false;
            }

            public void onServiceConnected(final ComponentName componentName, final IBinder iBinder) {
                this.postOrRun(new Runnable(){

                    @Override
                    public void run() {
                        block5: {
                            if (DEBUG) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("MediaServiceConnection.onServiceConnected name=");
                                stringBuilder.append(componentName);
                                stringBuilder.append(" binder=");
                                stringBuilder.append(iBinder);
                                Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                                MediaBrowserImplBase.this.dump();
                            }
                            if (!MediaServiceConnection.this.isCurrent("onServiceConnected")) {
                                return;
                            }
                            MediaBrowserImplBase.this.mServiceBinderWrapper = new ServiceBinderWrapper(iBinder, MediaBrowserImplBase.this.mRootHints);
                            MediaBrowserImplBase.this.mCallbacksMessenger = new Messenger((Handler)MediaBrowserImplBase.this.mHandler);
                            MediaBrowserImplBase.this.mHandler.setCallbacksMessenger(MediaBrowserImplBase.this.mCallbacksMessenger);
                            MediaBrowserImplBase.this.mState = 2;
                            try {
                                if (DEBUG) {
                                    Log.d((String)MediaBrowserCompat.TAG, (String)"ServiceCallbacks.onConnect...");
                                    MediaBrowserImplBase.this.dump();
                                }
                                MediaBrowserImplBase.this.mServiceBinderWrapper.connect(MediaBrowserImplBase.this.mContext, MediaBrowserImplBase.this.mCallbacksMessenger);
                            }
                            catch (RemoteException remoteException) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("RemoteException during connect for ");
                                stringBuilder.append(MediaBrowserImplBase.this.mServiceComponent);
                                Log.w((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                                if (!DEBUG) break block5;
                                Log.d((String)MediaBrowserCompat.TAG, (String)"ServiceCallbacks.onConnect...");
                                MediaBrowserImplBase.this.dump();
                            }
                        }
                    }
                });
            }

            public void onServiceDisconnected(final ComponentName componentName) {
                this.postOrRun(new Runnable(){

                    @Override
                    public void run() {
                        if (DEBUG) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("MediaServiceConnection.onServiceDisconnected name=");
                            stringBuilder.append(componentName);
                            stringBuilder.append(" this=");
                            stringBuilder.append(this);
                            stringBuilder.append(" mServiceConnection=");
                            stringBuilder.append(MediaBrowserImplBase.this.mServiceConnection);
                            Log.d((String)MediaBrowserCompat.TAG, (String)stringBuilder.toString());
                            MediaBrowserImplBase.this.dump();
                        }
                        if (!MediaServiceConnection.this.isCurrent("onServiceDisconnected")) {
                            return;
                        }
                        MediaBrowserImplBase.this.mServiceBinderWrapper = null;
                        MediaBrowserImplBase.this.mCallbacksMessenger = null;
                        MediaBrowserImplBase.this.mHandler.setCallbacksMessenger(null);
                        MediaBrowserImplBase.this.mState = 4;
                        MediaBrowserImplBase.this.mCallback.onConnectionSuspended();
                    }
                });
            }
        }
    }

    static interface MediaBrowserServiceCallbackImpl {
        public void onConnectionFailed(Messenger var1);

        public void onLoadChildren(Messenger var1, String var2, List<MediaItem> var3, Bundle var4, Bundle var5);

        public void onServiceConnected(Messenger var1, String var2, MediaSessionCompat.Token var3, Bundle var4);
    }

    public static class MediaItem
    implements Parcelable {
        public static final Parcelable.Creator<MediaItem> CREATOR = new Parcelable.Creator<MediaItem>(){

            public MediaItem createFromParcel(Parcel parcel) {
                return new MediaItem(parcel);
            }

            public MediaItem[] newArray(int n2) {
                return new MediaItem[n2];
            }
        };
        public static final int FLAG_BROWSABLE = 1;
        public static final int FLAG_PLAYABLE = 2;
        private final MediaDescriptionCompat mDescription;
        private final int mFlags;

        MediaItem(Parcel parcel) {
            this.mFlags = parcel.readInt();
            this.mDescription = (MediaDescriptionCompat)MediaDescriptionCompat.CREATOR.createFromParcel(parcel);
        }

        public MediaItem(MediaDescriptionCompat mediaDescriptionCompat, int n2) {
            if (mediaDescriptionCompat != null) {
                if (!TextUtils.isEmpty((CharSequence)mediaDescriptionCompat.getMediaId())) {
                    this.mFlags = n2;
                    this.mDescription = mediaDescriptionCompat;
                    return;
                }
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            throw new IllegalArgumentException("description cannot be null");
        }

        public static MediaItem fromMediaItem(Object object) {
            if (object != null && Build.VERSION.SDK_INT >= 21) {
                object = (MediaBrowser.MediaItem)object;
                int n2 = object.getFlags();
                return new MediaItem(MediaDescriptionCompat.fromMediaDescription((Object)object.getDescription()), n2);
            }
            return null;
        }

        public static List<MediaItem> fromMediaItemList(List<?> object) {
            if (object != null && Build.VERSION.SDK_INT >= 21) {
                ArrayList<MediaItem> arrayList = new ArrayList<MediaItem>(object.size());
                object = object.iterator();
                while (object.hasNext()) {
                    arrayList.add(MediaItem.fromMediaItem(object.next()));
                }
                return arrayList;
            }
            return null;
        }

        public int describeContents() {
            return 0;
        }

        public MediaDescriptionCompat getDescription() {
            return this.mDescription;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public String getMediaId() {
            return this.mDescription.getMediaId();
        }

        public boolean isBrowsable() {
            int n2 = this.mFlags;
            boolean bl = true;
            if ((n2 & 1) == 0) {
                bl = false;
            }
            return bl;
        }

        public boolean isPlayable() {
            boolean bl = (this.mFlags & 2) != 0;
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("MediaItem{");
            stringBuilder.append("mFlags=");
            stringBuilder.append(this.mFlags);
            stringBuilder.append(", mDescription=");
            stringBuilder.append(this.mDescription);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        public void writeToParcel(Parcel parcel, int n2) {
            parcel.writeInt(this.mFlags);
            this.mDescription.writeToParcel(parcel, n2);
        }
    }

    public static abstract class SearchCallback {
        public void onError(String string2, Bundle bundle) {
        }

        public void onSearchResult(String string2, Bundle bundle, List<MediaItem> list) {
        }
    }

    private static class SearchResultReceiver
    extends ResultReceiver {
        private final SearchCallback mCallback;
        private final Bundle mExtras;
        private final String mQuery;

        SearchResultReceiver(String string2, Bundle bundle, SearchCallback searchCallback, Handler handler) {
            super(handler);
            this.mQuery = string2;
            this.mExtras = bundle;
            this.mCallback = searchCallback;
        }

        protected void onReceiveResult(int n2, Bundle parcelableArray) {
            Object object = parcelableArray;
            if (parcelableArray != null) {
                object = MediaSessionCompat.unparcelWithClassLoader((Bundle)parcelableArray);
            }
            if (n2 == 0 && object != null && object.containsKey("search_results")) {
                parcelableArray = object.getParcelableArray("search_results");
                if (parcelableArray != null) {
                    object = new ArrayList();
                    int n3 = parcelableArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object.add((MediaItem)parcelableArray[n2]);
                    }
                    this.mCallback.onSearchResult(this.mQuery, this.mExtras, (List<MediaItem>)object);
                } else {
                    this.mCallback.onError(this.mQuery, this.mExtras);
                }
                return;
            }
            this.mCallback.onError(this.mQuery, this.mExtras);
        }
    }

    private static class ServiceBinderWrapper {
        private Messenger mMessenger;
        private Bundle mRootHints;

        public ServiceBinderWrapper(IBinder iBinder, Bundle bundle) {
            this.mMessenger = new Messenger(iBinder);
            this.mRootHints = bundle;
        }

        private void sendRequest(int n2, Bundle bundle, Messenger messenger) throws RemoteException {
            Message message = Message.obtain();
            message.what = n2;
            message.arg1 = 1;
            message.setData(bundle);
            message.replyTo = messenger;
            this.mMessenger.send(message);
        }

        void addSubscription(String string2, IBinder iBinder, Bundle bundle, Messenger messenger) throws RemoteException {
            Bundle bundle2 = new Bundle();
            bundle2.putString("data_media_item_id", string2);
            BundleCompat.putBinder((Bundle)bundle2, (String)"data_callback_token", (IBinder)iBinder);
            bundle2.putBundle("data_options", bundle);
            this.sendRequest(3, bundle2, messenger);
        }

        void connect(Context context, Messenger messenger) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putString("data_package_name", context.getPackageName());
            bundle.putInt("data_calling_pid", Process.myPid());
            bundle.putBundle("data_root_hints", this.mRootHints);
            this.sendRequest(1, bundle, messenger);
        }

        void disconnect(Messenger messenger) throws RemoteException {
            this.sendRequest(2, null, messenger);
        }

        void getMediaItem(String string2, ResultReceiver resultReceiver, Messenger messenger) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putString("data_media_item_id", string2);
            bundle.putParcelable("data_result_receiver", (Parcelable)resultReceiver);
            this.sendRequest(5, bundle, messenger);
        }

        void registerCallbackMessenger(Context context, Messenger messenger) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putString("data_package_name", context.getPackageName());
            bundle.putInt("data_calling_pid", Process.myPid());
            bundle.putBundle("data_root_hints", this.mRootHints);
            this.sendRequest(6, bundle, messenger);
        }

        void removeSubscription(String string2, IBinder iBinder, Messenger messenger) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putString("data_media_item_id", string2);
            BundleCompat.putBinder((Bundle)bundle, (String)"data_callback_token", (IBinder)iBinder);
            this.sendRequest(4, bundle, messenger);
        }

        void search(String string2, Bundle bundle, ResultReceiver resultReceiver, Messenger messenger) throws RemoteException {
            Bundle bundle2 = new Bundle();
            bundle2.putString("data_search_query", string2);
            bundle2.putBundle("data_search_extras", bundle);
            bundle2.putParcelable("data_result_receiver", (Parcelable)resultReceiver);
            this.sendRequest(8, bundle2, messenger);
        }

        void sendCustomAction(String string2, Bundle bundle, ResultReceiver resultReceiver, Messenger messenger) throws RemoteException {
            Bundle bundle2 = new Bundle();
            bundle2.putString("data_custom_action", string2);
            bundle2.putBundle("data_custom_action_extras", bundle);
            bundle2.putParcelable("data_result_receiver", (Parcelable)resultReceiver);
            this.sendRequest(9, bundle2, messenger);
        }

        void unregisterCallbackMessenger(Messenger messenger) throws RemoteException {
            this.sendRequest(7, null, messenger);
        }
    }

    private static class Subscription {
        private final List<SubscriptionCallback> mCallbacks = new ArrayList<SubscriptionCallback>();
        private final List<Bundle> mOptionsList = new ArrayList<Bundle>();

        public SubscriptionCallback getCallback(Bundle bundle) {
            for (int i2 = 0; i2 < this.mOptionsList.size(); ++i2) {
                if (!MediaBrowserCompatUtils.areSameOptions((Bundle)this.mOptionsList.get(i2), (Bundle)bundle)) continue;
                return this.mCallbacks.get(i2);
            }
            return null;
        }

        public List<SubscriptionCallback> getCallbacks() {
            return this.mCallbacks;
        }

        public List<Bundle> getOptionsList() {
            return this.mOptionsList;
        }

        public boolean isEmpty() {
            return this.mCallbacks.isEmpty();
        }

        public void putCallback(Bundle bundle, SubscriptionCallback subscriptionCallback) {
            for (int i2 = 0; i2 < this.mOptionsList.size(); ++i2) {
                if (!MediaBrowserCompatUtils.areSameOptions((Bundle)this.mOptionsList.get(i2), (Bundle)bundle)) continue;
                this.mCallbacks.set(i2, subscriptionCallback);
                return;
            }
            this.mCallbacks.add(subscriptionCallback);
            this.mOptionsList.add(bundle);
        }
    }

    public static abstract class SubscriptionCallback {
        final MediaBrowser.SubscriptionCallback mSubscriptionCallbackFwk;
        WeakReference<Subscription> mSubscriptionRef;
        final IBinder mToken = new Binder();

        public SubscriptionCallback() {
            this.mSubscriptionCallbackFwk = Build.VERSION.SDK_INT >= 26 ? new SubscriptionCallbackApi26() : (Build.VERSION.SDK_INT >= 21 ? new SubscriptionCallbackApi21() : null);
        }

        public void onChildrenLoaded(String string2, List<MediaItem> list) {
        }

        public void onChildrenLoaded(String string2, List<MediaItem> list, Bundle bundle) {
        }

        public void onError(String string2) {
        }

        public void onError(String string2, Bundle bundle) {
        }

        void setSubscription(Subscription subscription) {
            this.mSubscriptionRef = new WeakReference<Subscription>(subscription);
        }

        private class SubscriptionCallbackApi21
        extends MediaBrowser.SubscriptionCallback {
            SubscriptionCallbackApi21() {
            }

            List<MediaItem> applyOptions(List<MediaItem> list, Bundle bundle) {
                if (list == null) {
                    return null;
                }
                int n2 = bundle.getInt(MediaBrowserCompat.EXTRA_PAGE, -1);
                int n3 = bundle.getInt(MediaBrowserCompat.EXTRA_PAGE_SIZE, -1);
                if (n2 == -1 && n3 == -1) {
                    return list;
                }
                int n4 = n3 * n2;
                int n5 = n4 + n3;
                if (n2 >= 0 && n3 >= 1 && n4 < list.size()) {
                    n2 = n5;
                    if (n5 > list.size()) {
                        n2 = list.size();
                    }
                    return list.subList(n4, n2);
                }
                return Collections.emptyList();
            }

            public void onChildrenLoaded(String string2, List<MediaBrowser.MediaItem> list) {
                Object object = SubscriptionCallback.this.mSubscriptionRef == null ? null : (Subscription)SubscriptionCallback.this.mSubscriptionRef.get();
                if (object == null) {
                    SubscriptionCallback.this.onChildrenLoaded(string2, MediaItem.fromMediaItemList(list));
                } else {
                    list = MediaItem.fromMediaItemList(list);
                    List<SubscriptionCallback> list2 = ((Subscription)object).getCallbacks();
                    object = ((Subscription)object).getOptionsList();
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        Bundle bundle = (Bundle)object.get(i2);
                        if (bundle == null) {
                            SubscriptionCallback.this.onChildrenLoaded(string2, list);
                            continue;
                        }
                        SubscriptionCallback.this.onChildrenLoaded(string2, this.applyOptions(list, bundle), bundle);
                    }
                }
            }

            public void onError(String string2) {
                SubscriptionCallback.this.onError(string2);
            }
        }

        private class SubscriptionCallbackApi26
        extends SubscriptionCallbackApi21 {
            SubscriptionCallbackApi26() {
            }

            public void onChildrenLoaded(String string2, List<MediaBrowser.MediaItem> list, Bundle bundle) {
                MediaSessionCompat.ensureClassLoader(bundle);
                SubscriptionCallback.this.onChildrenLoaded(string2, MediaItem.fromMediaItemList(list), bundle);
            }

            public void onError(String string2, Bundle bundle) {
                MediaSessionCompat.ensureClassLoader(bundle);
                SubscriptionCallback.this.onError(string2, bundle);
            }
        }
    }
}

