/*
 * Decompiled with CFR 0.152.
 */
package android.support.multidex;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.multidex.ZipUtil;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

final class MultiDexExtractor {
    private static final int BUFFER_SIZE = 16384;
    private static final String DEX_PREFIX = "classes";
    private static final String DEX_SUFFIX = ".dex";
    private static final String EXTRACTED_NAME_EXT = ".classes";
    private static final String EXTRACTED_SUFFIX = ".zip";
    private static final String KEY_CRC = "crc";
    private static final String KEY_DEX_NUMBER = "dex.number";
    private static final String KEY_TIME_STAMP = "timestamp";
    private static final int MAX_EXTRACT_ATTEMPTS = 3;
    private static final long NO_VALUE = -1L;
    private static final String PREFS_FILE = "multidex.version";
    private static final String TAG = "MultiDex";
    private static Method sApplyMethod;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            sApplyMethod = SharedPreferences.Editor.class.getMethod("apply", new Class[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            sApplyMethod = null;
            return;
        }
    }

    MultiDexExtractor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void apply(SharedPreferences.Editor editor) {
        if (sApplyMethod != null) {
            try {
                sApplyMethod.invoke((Object)editor, new Object[0]);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        editor.commit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Failed to close resource", (Throwable)iOException);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private static void extract(ZipFile var0, ZipEntry var1_4, File var2_6, String var3_7) throws IOException, FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 256->262)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SharedPreferences getMultiDexPreferences(Context context) {
        int n2;
        if (Build.VERSION.SDK_INT < 11) {
            n2 = 0;
            return context.getSharedPreferences(PREFS_FILE, n2);
        }
        n2 = 4;
        return context.getSharedPreferences(PREFS_FILE, n2);
    }

    private static long getTimeStamp(File file) {
        long l2;
        long l3 = l2 = file.lastModified();
        if (l2 == -1L) {
            l3 = l2 - 1L;
        }
        return l3;
    }

    private static long getZipCrc(File file) throws IOException {
        long l2;
        long l3 = l2 = ZipUtil.getZipCrc(file);
        if (l2 == -1L) {
            l3 = l2 - 1L;
        }
        return l3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isModified(Context context, File file, long l2) {
        if ((context = MultiDexExtractor.getMultiDexPreferences(context)).getLong(KEY_TIME_STAMP, -1L) != MultiDexExtractor.getTimeStamp(file)) return true;
        if (context.getLong(KEY_CRC, -1L) == l2) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<File> load(Context object, ApplicationInfo object2, File file, boolean bl) throws IOException {
        Log.i((String)TAG, (String)("MultiDexExtractor.load(" + ((ApplicationInfo)object2).sourceDir + ", " + bl + ")"));
        File file2 = new File(((ApplicationInfo)object2).sourceDir);
        long l2 = MultiDexExtractor.getZipCrc(file2);
        if (!bl && !MultiDexExtractor.isModified((Context)object, file2, l2)) {
            try {
                object = object2 = MultiDexExtractor.loadExistingExtractions((Context)object, file2, file);
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (String)"Failed to reload existing extracted secondary dex files, falling back to fresh extraction", (Throwable)iOException);
                List<File> list = MultiDexExtractor.performExtractions(file2, file);
                MultiDexExtractor.putStoredApkInfo((Context)object, MultiDexExtractor.getTimeStamp(file2), l2, list.size() + 1);
                object = list;
            }
        } else {
            Log.i((String)TAG, (String)"Detected that extraction must be performed.");
            object2 = MultiDexExtractor.performExtractions(file2, file);
            MultiDexExtractor.putStoredApkInfo((Context)object, MultiDexExtractor.getTimeStamp(file2), l2, object2.size() + 1);
            object = object2;
        }
        Log.i((String)TAG, (String)("load found " + object.size() + " secondary dex files"));
        return object;
    }

    private static List<File> loadExistingExtractions(Context object, File object2, File file) throws IOException {
        Log.i((String)TAG, (String)"loading existing secondary dex files");
        object2 = ((File)object2).getName() + EXTRACTED_NAME_EXT;
        int n2 = MultiDexExtractor.getMultiDexPreferences((Context)object).getInt(KEY_DEX_NUMBER, 1);
        object = new ArrayList(n2);
        for (int i2 = 2; i2 <= n2; ++i2) {
            File file2 = new File(file, (String)object2 + i2 + EXTRACTED_SUFFIX);
            if (file2.isFile()) {
                object.add(file2);
                if (MultiDexExtractor.verifyZipFile(file2)) continue;
                Log.i((String)TAG, (String)("Invalid zip file: " + file2));
                throw new IOException("Invalid ZIP file.");
            }
            throw new IOException("Missing extracted secondary dex file '" + file2.getPath() + "'");
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mkdirChecked(File file) throws IOException {
        file.mkdir();
        if (file.isDirectory()) return;
        File file2 = file.getParentFile();
        if (file2 == null) {
            Log.e((String)TAG, (String)("Failed to create dir " + file.getPath() + ". Parent file is null."));
            throw new IOException("Failed to create cache directory " + file.getPath());
        }
        Log.e((String)TAG, (String)("Failed to create dir " + file.getPath() + ". parent file is a dir " + file2.isDirectory() + ", a file " + file2.isFile() + ", exists " + file2.exists() + ", readable " + file2.canRead() + ", writable " + file2.canWrite()));
        throw new IOException("Failed to create cache directory " + file.getPath());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<File> performExtractions(File var0, File var1_3) throws IOException {
        block11: {
            block10: {
                var2_5 = var0.getName() + ".classes";
                MultiDexExtractor.prepareDexDir((File)var1_3, var2_5);
                var3_6 = new ArrayList<File>();
                var4_7 = new ZipFile((File)var0);
                var5_8 = 2;
                try {
                    var0 = new StringBuilder();
                    var0 = var4_7.getEntry(var0.append("classes").append(2).append(".dex").toString());
lbl9:
                    // 2 sources

                    while (var0 != null) {
                        var6_9 = new StringBuilder();
                        var6_9 = var6_9.append(var2_5).append(var5_8).append(".zip").toString();
                        var7_10 = new File((File)var1_3, (String)var6_9);
                        var3_6.add(var7_10);
                        var6_9 = new StringBuilder();
                        Log.i((String)"MultiDex", (String)var6_9.append("Extraction is needed for file ").append(var7_10).toString());
                        var8_11 = 0;
                        var9_12 = false;
                        while (var8_11 < 3 && !var9_12) {
                            var10_13 = var8_11 + 1;
                            MultiDexExtractor.extract(var4_7, (ZipEntry)var0, var7_10, var2_5);
                            var11_14 = MultiDexExtractor.verifyZipFile(var7_10);
                            var6_9 = new StringBuilder();
                            var12_15 = var6_9.append("Extraction ");
                            var6_9 = var11_14 != false ? "success" : "failed";
                            Log.i((String)"MultiDex", (String)var12_15.append((String)var6_9).append(" - length ").append(var7_10.getAbsolutePath()).append(": ").append(var7_10.length()).toString());
                            var9_12 = var11_14;
                            var8_11 = var10_13;
                            if (var11_14) continue;
                            var7_10.delete();
                            var9_12 = var11_14;
                            var8_11 = var10_13;
                            if (!var7_10.exists()) continue;
                            var6_9 = new StringBuilder();
                            Log.w((String)"MultiDex", (String)var6_9.append("Failed to delete corrupted secondary dex '").append(var7_10.getPath()).append("'").toString());
                            var9_12 = var11_14;
                            var8_11 = var10_13;
                        }
                        break block10;
                    }
                    break block11;
                }
                catch (Throwable var0_1) {
                    try {
                        var4_7.close();
                        throw var0_1;
                    }
                    catch (IOException var1_4) {
                        Log.w((String)"MultiDex", (String)"Failed to close resource", (Throwable)var1_4);
                        throw var0_1;
                    }
                }
            }
            if (var9_12) ** GOTO lbl-1000
            {
                var1_3 = new Comparable<File>();
                var0 = new IOException(var1_3.append("Could not create zip file ").append(var7_10.getAbsolutePath()).append(" for secondary dex (").append(var5_8).append(")").toString());
                throw var0;
            }
lbl-1000:
            // 1 sources

            {
                var0 = new StringBuilder();
                var0 = var4_7.getEntry(var0.append("classes").append(++var5_8).append(".dex").toString());
                ** GOTO lbl9
            }
        }
        try {
            var4_7.close();
            return var3_6;
        }
        catch (IOException var0_2) {
            Log.w((String)"MultiDex", (String)"Failed to close resource", (Throwable)var0_2);
            return var3_6;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void prepareDexDir(File file, String fileArray) throws IOException {
        MultiDexExtractor.mkdirChecked(file.getParentFile());
        MultiDexExtractor.mkdirChecked(file);
        fileArray = file.listFiles(new FileFilter((String)fileArray){
            final /* synthetic */ String val$extractedFilePrefix;
            {
                this.val$extractedFilePrefix = string2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean accept(File file) {
                if (file.getName().startsWith(this.val$extractedFilePrefix)) return false;
                return true;
            }
        });
        if (fileArray == null) {
            Log.w((String)TAG, (String)("Failed to list secondary dex dir content (" + file.getPath() + ")."));
            return;
        }
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            file = fileArray[n3];
            Log.i((String)TAG, (String)("Trying to delete old file " + file.getPath() + " of size " + file.length()));
            if (!file.delete()) {
                Log.w((String)TAG, (String)("Failed to delete old file " + file.getPath()));
            } else {
                Log.i((String)TAG, (String)("Deleted old file " + file.getPath()));
            }
            ++n3;
        }
        return;
    }

    private static void putStoredApkInfo(Context context, long l2, long l3, int n2) {
        context = MultiDexExtractor.getMultiDexPreferences(context).edit();
        context.putLong(KEY_TIME_STAMP, l2);
        context.putLong(KEY_CRC, l3);
        context.putInt(KEY_DEX_NUMBER, n2);
        MultiDexExtractor.apply((SharedPreferences.Editor)context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean verifyZipFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            try {
                zipFile.close();
                return true;
            }
            catch (IOException iOException) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    Log.w((String)TAG, (String)stringBuilder.append("Failed to close zip file: ").append(file.getAbsolutePath()).toString());
                    return false;
                }
                catch (IOException iOException2) {
                    Log.w((String)TAG, (String)("Got an IOException trying to open zip file: " + file.getAbsolutePath()), (Throwable)iOException2);
                }
                return false;
            }
        }
        catch (ZipException zipException) {
            Log.w((String)TAG, (String)("File " + file.getAbsolutePath() + " is not a valid zip file."), (Throwable)zipException);
            return false;
        }
    }

    private static class ExtractedDex
    extends File {
        public long crc = -1L;

        public ExtractedDex(File file, String string2) {
            super(file, string2);
        }
    }
}

