/*
 * Decompiled with CFR 0.152.
 */
package android.support.multidex;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.multidex.MultiDexExtractor;
import android.util.Log;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public final class MultiDex {
    private static final boolean IS_VM_MULTIDEX_CAPABLE;
    private static final int MAX_SUPPORTED_SDK_VERSION = 20;
    private static final int MIN_SDK_VERSION = 4;
    private static final String OLD_SECONDARY_FOLDER_NAME = "secondary-dexes";
    private static final String SECONDARY_FOLDER_NAME;
    static final String TAG = "MultiDex";
    private static final int VM_WITH_MULTIDEX_VERSION_MAJOR = 2;
    private static final int VM_WITH_MULTIDEX_VERSION_MINOR = 1;
    private static final Set<String> installedApk;

    static {
        SECONDARY_FOLDER_NAME = "code_cache" + File.separator + OLD_SECONDARY_FOLDER_NAME;
        installedApk = new HashSet<String>();
        IS_VM_MULTIDEX_CAPABLE = MultiDex.isVMMultidexCapable(System.getProperty("java.vm.version"));
    }

    private MultiDex() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkValidZipFiles(List<File> iterator2) {
        iterator2 = iterator2.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (MultiDexExtractor.verifyZipFile((File)iterator2.next()));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void clearOldDexDir(Context object) throws Exception {
        File file = new File(object.getFilesDir(), OLD_SECONDARY_FOLDER_NAME);
        if (!file.isDirectory()) return;
        Log.i((String)TAG, (String)("Clearing old secondary dex dir (" + file.getPath() + ")."));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            Log.w((String)TAG, (String)("Failed to list secondary dex dir content (" + file.getPath() + ")."));
            return;
        }
        for (File file2 : fileArray) {
            Log.i((String)TAG, (String)("Trying to delete old file " + file2.getPath() + " of size " + file2.length()));
            if (!file2.delete()) {
                Log.w((String)TAG, (String)("Failed to delete old file " + file2.getPath()));
                continue;
            }
            Log.i((String)TAG, (String)("Deleted old file " + file2.getPath()));
        }
        if (!file.delete()) {
            Log.w((String)TAG, (String)("Failed to delete secondary dex dir " + file.getPath()));
            return;
        }
        Log.i((String)TAG, (String)("Deleted old secondary dex dir " + file.getPath()));
    }

    private static void expandFieldArray(Object object, String object2, Object[] objectArray) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        object2 = MultiDex.findField(object, (String)object2);
        Object[] objectArray2 = (Object[])((Field)object2).get(object);
        Object[] objectArray3 = (Object[])Array.newInstance(objectArray2.getClass().getComponentType(), objectArray2.length + objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, 0, objectArray2.length);
        System.arraycopy(objectArray, 0, objectArray3, objectArray2.length, objectArray.length);
        ((Field)object2).set(object, objectArray3);
    }

    private static Field findField(Object object, String string2) throws NoSuchFieldException {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(string2);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new NoSuchFieldException("Field " + string2 + " not found in " + object.getClass());
    }

    private static Method findMethod(Object object, String string2, Class<?> ... classArray) throws NoSuchMethodException {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method method = clazz.getDeclaredMethod(string2, classArray);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new NoSuchMethodException("Method " + string2 + " with parameters " + Arrays.asList(classArray) + " not found in " + object.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ApplicationInfo getApplicationInfo(Context context) throws PackageManager.NameNotFoundException {
        Object var1_2 = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            String string2 = context.getPackageName();
            context = var1_2;
            if (packageManager == null) return context;
            if (string2 != null) return packageManager.getApplicationInfo(string2, 128);
            return var1_2;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)TAG, (String)"Failure while trying to obtain ApplicationInfo from Context. Must be running in test mode. Skip patching.", (Throwable)runtimeException);
            return var1_2;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void install(Context var0) {
        Log.i((String)"MultiDex", (String)"install");
        if (MultiDex.IS_VM_MULTIDEX_CAPABLE) {
            Log.i((String)"MultiDex", (String)"VM has multidex support, MultiDex support library is disabled.");
            return;
        }
        if (Build.VERSION.SDK_INT < 4) {
            throw new RuntimeException("Multi dex installation failed. SDK " + Build.VERSION.SDK_INT + " is unsupported. Min SDK version is " + 4 + ".");
        }
        try {
            var1_3 = MultiDex.getApplicationInfo(var0 /* !! */ );
            if (var1_3 == null) return;
            var2_4 = MultiDex.installedApk;
            synchronized (var2_4) {
                var3_5 = var1_3.sourceDir;
                if (!MultiDex.installedApk.contains(var3_5)) break block18;
            }
        }
        catch (Exception var0_1) {
            Log.e((String)"MultiDex", (String)"Multidex installation failure", (Throwable)var0_1);
            throw new RuntimeException("Multi dex installation failed (" + var0_1.getMessage() + ").");
        }
        {
            block19: {
                block18: {
                    return;
                }
                MultiDex.installedApk.add((String)var3_5);
                if (Build.VERSION.SDK_INT > 20) {
                    var3_5 = new StringBuilder();
                    Log.w((String)"MultiDex", (String)var3_5.append("MultiDex is not guaranteed to work in SDK version ").append(Build.VERSION.SDK_INT).append(": SDK version higher than ").append(20).append(" should be backed by ").append("runtime with built-in multidex capabilty but it's not the ").append("case here: java.vm.version=\"").append(System.getProperty("java.vm.version")).append("\"").toString());
                }
                try {
                    var3_5 = var0 /* !! */ .getClassLoader();
                    if (var3_5 != null) break block19;
                }
                catch (RuntimeException var0_2) {
                    Log.w((String)"MultiDex", (String)"Failure while trying to obtain Context class loader. Must be running in test mode. Skip patching.", (Throwable)var0_2);
                    return;
                }
                Log.e((String)"MultiDex", (String)"Context class loader is null. Must be running in test mode. Skip patching.");
                return;
            }
            try {
                MultiDex.clearOldDexDir(var0 /* !! */ );
            }
            catch (Throwable var4_6) {
                Log.w((String)"MultiDex", (String)"Something went wrong when trying to clear old MultiDex extraction, continuing without cleaning.", (Throwable)var4_6);
                ** continue;
            }
lbl47:
            // 2 sources

            while (true) {
                var4_7 = new File(var1_3.dataDir, MultiDex.SECONDARY_FOLDER_NAME);
                var5_8 = MultiDexExtractor.load(var0 /* !! */ , var1_3, var4_7, false);
                if (MultiDex.checkValidZipFiles(var5_8)) {
                    MultiDex.installSecondaryDexes((ClassLoader)var3_5, var4_7, var5_8);
                } else {
                    Log.w((String)"MultiDex", (String)"Files were not valid zip files.  Forcing a reload.");
                    var0 /* !! */  = MultiDexExtractor.load(var0 /* !! */ , var1_3, var4_7, true);
                    if (!MultiDex.checkValidZipFiles((List<File>)var0 /* !! */ )) {
                        var0 /* !! */  = new RuntimeException("Zip files were not valid.");
                        throw var0 /* !! */ ;
                    }
                    MultiDex.installSecondaryDexes((ClassLoader)var3_5, var4_7, (List<File>)var0 /* !! */ );
                }
                // MONITOREXIT @DISABLED, blocks:[7, 11] lbl57 : MonitorExitStatement: MONITOREXIT : var2_4
                Log.i((String)"MultiDex", (String)"install done");
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void installSecondaryDexes(ClassLoader classLoader, File file, List<File> list) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IOException {
        block6: {
            block5: {
                if (list.isEmpty()) break block5;
                if (Build.VERSION.SDK_INT < 19) break block6;
                V19.install(classLoader, list, file);
            }
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            V14.install(classLoader, list, file);
            return;
        }
        V4.install(classLoader, list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isVMMultidexCapable(String string2) {
        Object object;
        boolean bl;
        boolean bl2 = bl = false;
        if (string2 != null) {
            object = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?").matcher(string2);
            bl2 = bl;
            if (((Matcher)object).matches()) {
                try {
                    int n2 = Integer.parseInt(((Matcher)object).group(1));
                    int n3 = Integer.parseInt(((Matcher)object).group(2));
                    bl2 = n2 > 2 || n2 == 2 && n3 >= 1;
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = bl;
                }
            }
        }
        object = new StringBuilder().append("VM with version ").append(string2);
        string2 = bl2 ? " has multidex support" : " does not have multidex support";
        Log.i((String)TAG, (String)((StringBuilder)object).append(string2).toString());
        return bl2;
    }

    private static final class V14 {
        private V14() {
        }

        private static void install(ClassLoader object, List<File> list, File file) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
            object = MultiDex.findField(object, "pathList").get(object);
            MultiDex.expandFieldArray(object, "dexElements", V14.makeDexElements(object, new ArrayList<File>(list), file));
        }

        private static Object[] makeDexElements(Object object, ArrayList<File> arrayList, File file) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            return (Object[])MultiDex.findMethod(object, "makeDexElements", new Class[]{ArrayList.class, File.class}).invoke(object, arrayList, file);
        }
    }

    private static final class V19 {
        private V19() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private static void install(ClassLoader classLoader, List<File> object, File object2) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
            IOException[] iOExceptionArray = MultiDex.findField(classLoader, "pathList").get(classLoader);
            ArrayList<IOException> arrayList = new ArrayList<IOException>();
            MultiDex.expandFieldArray(iOExceptionArray, "dexElements", V19.makeDexElements(iOExceptionArray, new ArrayList<File>((Collection<File>)object), (File)object2, arrayList));
            if (arrayList.size() > 0) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    Log.w((String)MultiDex.TAG, (String)"Exception in makeDexElement", (Throwable)((IOException)object.next()));
                }
                object2 = MultiDex.findField(classLoader, "dexElementsSuppressedExceptions");
                iOExceptionArray = (IOException[])((Field)object2).get(classLoader);
                if (iOExceptionArray == null) {
                    object = arrayList.toArray(new IOException[arrayList.size()]);
                } else {
                    object = new IOException[arrayList.size() + iOExceptionArray.length];
                    arrayList.toArray((T[])object);
                    System.arraycopy(iOExceptionArray, 0, object, arrayList.size(), iOExceptionArray.length);
                }
                ((Field)object2).set(classLoader, object);
            }
        }

        private static Object[] makeDexElements(Object object, ArrayList<File> arrayList, File file, ArrayList<IOException> arrayList2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            return (Object[])MultiDex.findMethod(object, "makeDexElements", new Class[]{ArrayList.class, File.class, ArrayList.class}).invoke(object, arrayList, file, arrayList2);
        }
    }

    private static final class V4 {
        private V4() {
        }

        private static void install(ClassLoader classLoader, List<File> object) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, IOException {
            int n2 = object.size();
            Field field = MultiDex.findField(classLoader, "path");
            StringBuilder stringBuilder = new StringBuilder((String)field.get(classLoader));
            Object[] objectArray = new String[n2];
            Object[] objectArray2 = new File[n2];
            Object[] objectArray3 = new ZipFile[n2];
            Object[] objectArray4 = new DexFile[n2];
            object = object.listIterator();
            while (object.hasNext()) {
                File file = (File)object.next();
                String string2 = file.getAbsolutePath();
                stringBuilder.append(':').append(string2);
                n2 = object.previousIndex();
                objectArray[n2] = string2;
                objectArray2[n2] = file;
                objectArray3[n2] = new ZipFile(file);
                objectArray4[n2] = DexFile.loadDex((String)string2, (String)(string2 + ".dex"), (int)0);
            }
            field.set(classLoader, stringBuilder.toString());
            MultiDex.expandFieldArray(classLoader, "mPaths", objectArray);
            MultiDex.expandFieldArray(classLoader, "mFiles", objectArray2);
            MultiDex.expandFieldArray(classLoader, "mZips", objectArray3);
            MultiDex.expandFieldArray(classLoader, "mDexs", objectArray4);
        }
    }
}

