/*
 * Decompiled with CFR 0.152.
 */
package androidx.multidex;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import androidx.multidex.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

final class MultiDexExtractor
implements Closeable {
    private final FileLock cacheLock;
    private final File dexDir;
    private final FileChannel lockChannel;
    private final RandomAccessFile lockRaf;
    private final File sourceApk;
    private final long sourceCrc;

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    MultiDexExtractor(File file, File object) throws IOException {
        void iOException;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MultiDexExtractor(");
        stringBuilder.append(file.getPath());
        stringBuilder.append(", ");
        stringBuilder.append(((File)object).getPath());
        stringBuilder.append(")");
        Log.i((String)"MultiDex", (String)stringBuilder.toString());
        this.sourceApk = file;
        this.dexDir = object;
        this.sourceCrc = MultiDexExtractor.getZipCrc(file);
        file = new File((File)object, "MultiDex.lock");
        this.lockRaf = object = new RandomAccessFile(file, "rw");
        this.lockChannel = object = ((RandomAccessFile)object).getChannel();
        stringBuilder = new StringBuilder();
        stringBuilder.append("Blocking on lock ");
        stringBuilder.append(file.getPath());
        Log.i((String)"MultiDex", (String)stringBuilder.toString());
        this.cacheLock = ((FileChannel)object).lock();
        object = new StringBuilder();
        ((StringBuilder)object).append(file.getPath());
        ((StringBuilder)object).append(" locked");
        Log.i((String)"MultiDex", (String)((StringBuilder)object).toString());
        return;
        catch (Error error2) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            MultiDexExtractor.closeQuietly(this.lockChannel);
            throw file;
        }
        catch (Error error) {
        }
        catch (RuntimeException runtimeException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MultiDexExtractor.closeQuietly(this.lockRaf);
        throw iOException;
    }

    private void clearDexDir() {
        Object object = this.dexDir.listFiles(new FileFilter(){});
        if (object == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Failed to list secondary dex dir content (");
            ((StringBuilder)object).append(this.dexDir.getPath());
            ((StringBuilder)object).append(").");
            Log.w((String)"MultiDex", (String)((StringBuilder)object).toString());
            return;
        }
        for (Object object2 : object) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Trying to delete old file ");
            stringBuilder.append(((File)object2).getPath());
            stringBuilder.append(" of size ");
            stringBuilder.append(((File)object2).length());
            Log.i((String)"MultiDex", (String)stringBuilder.toString());
            if (!((File)object2).delete()) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("Failed to delete old file ");
                stringBuilder.append(((File)object2).getPath());
                Log.w((String)"MultiDex", (String)stringBuilder.toString());
                continue;
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("Deleted old file ");
            stringBuilder.append(((File)object2).getPath());
            Log.i((String)"MultiDex", (String)stringBuilder.toString());
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            Log.w((String)"MultiDex", (String)"Failed to close resource", (Throwable)iOException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extract(ZipFile closeable, ZipEntry object, File file, String object2) throws IOException, FileNotFoundException {
        closeable = ((ZipFile)closeable).getInputStream((ZipEntry)object);
        Object object3 = new StringBuilder();
        ((StringBuilder)object3).append("tmp-");
        ((StringBuilder)object3).append((String)object2);
        object2 = File.createTempFile(((StringBuilder)object3).toString(), ".zip", file.getParentFile());
        object3 = new StringBuilder();
        ((StringBuilder)object3).append("Extracting ");
        ((StringBuilder)object3).append(((File)object2).getPath());
        Log.i((String)"MultiDex", (String)((StringBuilder)object3).toString());
        FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
        Object object4 = new BufferedOutputStream(fileOutputStream);
        object3 = new ZipOutputStream((OutputStream)object4);
        object4 = new ZipEntry("classes.dex");
        ((ZipEntry)object4).setTime(((ZipEntry)object).getTime());
        ((ZipOutputStream)object3).putNextEntry((ZipEntry)object4);
        object = new byte[16384];
        int n = ((InputStream)closeable).read((byte[])object);
        while (n != -1) {
            ((ZipOutputStream)object3).write((byte[])object, 0, n);
            n = ((InputStream)closeable).read((byte[])object);
        }
        ((ZipOutputStream)object3).closeEntry();
        {
            catch (Throwable throwable) {
                ((ZipOutputStream)object3).close();
                throw throwable;
            }
        }
        try {
            ((ZipOutputStream)object3).close();
            if (((File)object2).setReadOnly()) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Renaming to ");
                ((StringBuilder)object).append(file.getPath());
                Log.i((String)"MultiDex", (String)((StringBuilder)object).toString());
                boolean bl = ((File)object2).renameTo(file);
                if (bl) {
                    return;
                }
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("Failed to rename \"");
                ((StringBuilder)object3).append(((File)object2).getAbsolutePath());
                ((StringBuilder)object3).append("\" to \"");
                ((StringBuilder)object3).append(file.getAbsolutePath());
                ((StringBuilder)object3).append("\"");
                object = new IOException(((StringBuilder)object3).toString());
                throw object;
            }
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("Failed to mark readonly \"");
            ((StringBuilder)object3).append(((File)object2).getAbsolutePath());
            ((StringBuilder)object3).append("\" (tmp of \"");
            ((StringBuilder)object3).append(file.getAbsolutePath());
            ((StringBuilder)object3).append("\")");
            object = new IOException(((StringBuilder)object3).toString());
            throw object;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            MultiDexExtractor.closeQuietly(closeable);
            ((File)object2).delete();
        }
    }

    private static SharedPreferences getMultiDexPreferences(Context context) {
        int n = Build.VERSION.SDK_INT < 11 ? 0 : 4;
        return context.getSharedPreferences("multidex.version", n);
    }

    private static long getTimeStamp(File file) {
        long l;
        long l2 = l = file.lastModified();
        if (l == -1L) {
            l2 = l - 1L;
        }
        return l2;
    }

    private static long getZipCrc(File file) throws IOException {
        long l;
        long l2 = l = ZipUtil.getZipCrc(file);
        if (l == -1L) {
            l2 = l - 1L;
        }
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isModified(Context context, File comparable, long l, String string) {
        context = MultiDexExtractor.getMultiDexPreferences(context);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("timestamp");
        if (context.getLong(stringBuilder.toString(), -1L) != MultiDexExtractor.getTimeStamp(comparable)) return true;
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(string);
        ((StringBuilder)comparable).append("crc");
        if (context.getLong(((StringBuilder)comparable).toString(), -1L) == l) return false;
        return true;
    }

    private List<ExtractedDex> loadExistingExtractions(Context object, String string) throws IOException {
        Log.i((String)"MultiDex", (String)"loading existing secondary dex files");
        CharSequence charSequence = new StringBuilder();
        charSequence.append(this.sourceApk.getName());
        charSequence.append(".classes");
        charSequence = charSequence.toString();
        object = MultiDexExtractor.getMultiDexPreferences((Context)object);
        Serializable serializable = new StringBuilder();
        ((StringBuilder)serializable).append(string);
        ((StringBuilder)serializable).append("dex.number");
        int n = object.getInt(((StringBuilder)serializable).toString(), 1);
        serializable = new ArrayList(n - 1);
        for (int i = 2; i <= n; ++i) {
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)charSequence);
            ((StringBuilder)object2).append(i);
            ((StringBuilder)object2).append(".zip");
            object2 = ((StringBuilder)object2).toString();
            object2 = new ExtractedDex(this.dexDir, (String)object2);
            if (((File)object2).isFile()) {
                ((ExtractedDex)object2).crc = MultiDexExtractor.getZipCrc((File)object2);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append("dex.crc.");
                stringBuilder.append(i);
                long l = object.getLong(stringBuilder.toString(), -1L);
                stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append("dex.time.");
                stringBuilder.append(i);
                long l2 = object.getLong(stringBuilder.toString(), -1L);
                long l3 = ((File)object2).lastModified();
                if (l2 == l3 && l == ((ExtractedDex)object2).crc) {
                    serializable.add(object2);
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Invalid extracted dex: ");
                ((StringBuilder)object).append(object2);
                ((StringBuilder)object).append(" (key \"");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("\"), expected modification time: ");
                ((StringBuilder)object).append(l2);
                ((StringBuilder)object).append(", modification time: ");
                ((StringBuilder)object).append(l3);
                ((StringBuilder)object).append(", expected crc: ");
                ((StringBuilder)object).append(l);
                ((StringBuilder)object).append(", file crc: ");
                ((StringBuilder)object).append(((ExtractedDex)object2).crc);
                throw new IOException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Missing extracted secondary dex file '");
            ((StringBuilder)object).append(((File)object2).getPath());
            ((StringBuilder)object).append("'");
            throw new IOException(((StringBuilder)object).toString());
        }
        return serializable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ExtractedDex> performExtractions() throws IOException {
        Object object = new StringBuilder();
        ((StringBuilder)object).append(this.sourceApk.getName());
        ((StringBuilder)object).append(".classes");
        String string = ((StringBuilder)object).toString();
        this.clearDexDir();
        ArrayList<ExtractedDex> arrayList = new ArrayList<ExtractedDex>();
        ZipFile zipFile = new ZipFile(this.sourceApk);
        try {
            object = new StringBuilder();
            ((StringBuilder)object).append("classes");
            ((StringBuilder)object).append(2);
            ((StringBuilder)object).append(".dex");
            object = zipFile.getEntry(((StringBuilder)object).toString());
            int n = 2;
            while (object != null) {
                Object object2 = new StringBuilder();
                ((StringBuilder)object2).append(string);
                ((StringBuilder)object2).append(n);
                ((StringBuilder)object2).append(".zip");
                object2 = ((StringBuilder)object2).toString();
                ExtractedDex extractedDex = new ExtractedDex(this.dexDir, (String)object2);
                arrayList.add(extractedDex);
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Extraction is needed for file ");
                ((StringBuilder)object2).append(extractedDex);
                Log.i((String)"MultiDex", (String)((StringBuilder)object2).toString());
                boolean bl = false;
                for (int i = 0; i < 3 && !bl; ++i) {
                    StringBuilder stringBuilder;
                    MultiDexExtractor.extract(zipFile, (ZipEntry)object, extractedDex, string);
                    try {
                        extractedDex.crc = MultiDexExtractor.getZipCrc(extractedDex);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("Failed to read crc from ");
                        stringBuilder.append(extractedDex.getAbsolutePath());
                        Log.w((String)"MultiDex", (String)stringBuilder.toString(), (Throwable)iOException);
                        bl = false;
                    }
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Extraction ");
                    object2 = bl ? "succeeded" : "failed";
                    stringBuilder.append((String)object2);
                    stringBuilder.append(" '");
                    stringBuilder.append(extractedDex.getAbsolutePath());
                    stringBuilder.append("': length ");
                    stringBuilder.append(extractedDex.length());
                    stringBuilder.append(" - crc: ");
                    stringBuilder.append(extractedDex.crc);
                    Log.i((String)"MultiDex", (String)stringBuilder.toString());
                    if (bl) continue;
                    extractedDex.delete();
                    if (!extractedDex.exists()) continue;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Failed to delete corrupted secondary dex '");
                    ((StringBuilder)object2).append(extractedDex.getPath());
                    ((StringBuilder)object2).append("'");
                    Log.w((String)"MultiDex", (String)((StringBuilder)object2).toString());
                }
                if (bl) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("classes");
                    ((StringBuilder)object).append(++n);
                    ((StringBuilder)object).append(".dex");
                    object = zipFile.getEntry(((StringBuilder)object).toString());
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Could not create zip file ");
                ((StringBuilder)object).append(extractedDex.getAbsolutePath());
                ((StringBuilder)object).append(" for secondary dex (");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append(")");
                object2 = new IOException(((StringBuilder)object).toString());
                throw object2;
            }
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Log.w((String)"MultiDex", (String)"Failed to close resource", (Throwable)iOException);
                throw throwable;
            }
        }
        try {
            zipFile.close();
            return arrayList;
        }
        catch (IOException iOException) {
            Log.w((String)"MultiDex", (String)"Failed to close resource", (Throwable)iOException);
        }
        return arrayList;
    }

    private static void putStoredApkInfo(Context context, String string, long l, long l2, List<ExtractedDex> object) {
        context = MultiDexExtractor.getMultiDexPreferences(context).edit();
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append(string);
        ((StringBuilder)object2).append("timestamp");
        context.putLong(((StringBuilder)object2).toString(), l);
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(string);
        ((StringBuilder)object2).append("crc");
        context.putLong(((StringBuilder)object2).toString(), l2);
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(string);
        ((StringBuilder)object2).append("dex.number");
        context.putInt(((StringBuilder)object2).toString(), object.size() + 1);
        object2 = object.iterator();
        int n = 2;
        while (object2.hasNext()) {
            object = (ExtractedDex)object2.next();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append("dex.crc.");
            stringBuilder.append(n);
            context.putLong(stringBuilder.toString(), ((ExtractedDex)object).crc);
            stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append("dex.time.");
            stringBuilder.append(n);
            context.putLong(stringBuilder.toString(), ((File)object).lastModified());
            ++n;
        }
        context.commit();
    }

    @Override
    public void close() throws IOException {
        this.cacheLock.release();
        this.lockChannel.close();
        this.lockRaf.close();
    }

    List<? extends File> load(Context object, String charSequence, boolean bl) throws IOException {
        List<ExtractedDex> list = new StringBuilder();
        ((StringBuilder)((Object)list)).append("MultiDexExtractor.load(");
        ((StringBuilder)((Object)list)).append(this.sourceApk.getPath());
        ((StringBuilder)((Object)list)).append(", ");
        ((StringBuilder)((Object)list)).append(bl);
        ((StringBuilder)((Object)list)).append(", ");
        ((StringBuilder)((Object)list)).append((String)charSequence);
        ((StringBuilder)((Object)list)).append(")");
        Log.i((String)"MultiDex", (String)((StringBuilder)((Object)list)).toString());
        if (this.cacheLock.isValid()) {
            if (!bl && !MultiDexExtractor.isModified((Context)object, this.sourceApk, this.sourceCrc, (String)charSequence)) {
                try {
                    list = this.loadExistingExtractions((Context)object, (String)charSequence);
                    object = list;
                }
                catch (IOException iOException) {
                    Log.w((String)"MultiDex", (String)"Failed to reload existing extracted secondary dex files, falling back to fresh extraction", (Throwable)iOException);
                    List<ExtractedDex> list2 = this.performExtractions();
                    MultiDexExtractor.putStoredApkInfo((Context)object, (String)charSequence, MultiDexExtractor.getTimeStamp(this.sourceApk), this.sourceCrc, list2);
                    object = list2;
                }
            } else {
                if (bl) {
                    Log.i((String)"MultiDex", (String)"Forced extraction must be performed.");
                } else {
                    Log.i((String)"MultiDex", (String)"Detected that extraction must be performed.");
                }
                list = this.performExtractions();
                MultiDexExtractor.putStoredApkInfo((Context)object, (String)charSequence, MultiDexExtractor.getTimeStamp(this.sourceApk), this.sourceCrc, list);
                object = list;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("load found ");
            ((StringBuilder)charSequence).append(object.size());
            ((StringBuilder)charSequence).append(" secondary dex files");
            Log.i((String)"MultiDex", (String)((StringBuilder)charSequence).toString());
            return object;
        }
        throw new IllegalStateException("MultiDexExtractor was closed");
    }

    private static class ExtractedDex
    extends File {
        public long crc = -1L;

        public ExtractedDex(File file, String string) {
            super(file, string);
        }
    }
}

