/*
 * Decompiled with CFR 0.152.
 */
package androidx.multidex;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.util.Log;
import androidx.multidex.MultiDexExtractor;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public final class MultiDex {
    private static final boolean IS_VM_MULTIDEX_CAPABLE;
    private static final Set<File> installedApk;

    static {
        installedApk = new HashSet<File>();
        IS_VM_MULTIDEX_CAPABLE = MultiDex.isVMMultidexCapable(System.getProperty("java.vm.version"));
    }

    private static void clearOldDexDir(Context object) throws Exception {
        if (((File)(object = new File(object.getFilesDir(), "secondary-dexes"))).isDirectory()) {
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append("Clearing old secondary dex dir (");
            ((StringBuilder)object2).append(((File)object).getPath());
            ((StringBuilder)object2).append(").");
            Log.i((String)"MultiDex", (String)((StringBuilder)object2).toString());
            object2 = ((File)object).listFiles();
            if (object2 == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Failed to list secondary dex dir content (");
                ((StringBuilder)object2).append(((File)object).getPath());
                ((StringBuilder)object2).append(").");
                Log.w((String)"MultiDex", (String)((StringBuilder)object2).toString());
                return;
            }
            for (Object object3 : object2) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Trying to delete old file ");
                stringBuilder.append(((File)object3).getPath());
                stringBuilder.append(" of size ");
                stringBuilder.append(((File)object3).length());
                Log.i((String)"MultiDex", (String)stringBuilder.toString());
                if (!((File)object3).delete()) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed to delete old file ");
                    stringBuilder.append(((File)object3).getPath());
                    Log.w((String)"MultiDex", (String)stringBuilder.toString());
                    continue;
                }
                stringBuilder = new StringBuilder();
                stringBuilder.append("Deleted old file ");
                stringBuilder.append(((File)object3).getPath());
                Log.i((String)"MultiDex", (String)stringBuilder.toString());
            }
            if (!((File)object).delete()) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Failed to delete secondary dex dir ");
                ((StringBuilder)object2).append(((File)object).getPath());
                Log.w((String)"MultiDex", (String)((StringBuilder)object2).toString());
            } else {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Deleted old secondary dex dir ");
                ((StringBuilder)object2).append(((File)object).getPath());
                Log.i((String)"MultiDex", (String)((StringBuilder)object2).toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doInstallation(Context object, File file, File object2, String object3, String string, boolean bl) throws IOException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException {
        Set<File> set = installedApk;
        synchronized (set) {
            Object object4;
            block22: {
                if (set.contains(file)) {
                    return;
                }
                set.add(file);
                if (Build.VERSION.SDK_INT > 20) {
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append("MultiDex is not guaranteed to work in SDK version ");
                    ((StringBuilder)object4).append(Build.VERSION.SDK_INT);
                    ((StringBuilder)object4).append(": SDK version higher than ");
                    ((StringBuilder)object4).append(20);
                    ((StringBuilder)object4).append(" should be backed by ");
                    ((StringBuilder)object4).append("runtime with built-in multidex capabilty but it's not the ");
                    ((StringBuilder)object4).append("case here: java.vm.version=\"");
                    ((StringBuilder)object4).append(System.getProperty("java.vm.version"));
                    ((StringBuilder)object4).append("\"");
                    Log.w((String)"MultiDex", (String)((StringBuilder)object4).toString());
                }
                try {
                    object4 = object.getClassLoader();
                    if (object4 != null) break block22;
                }
                catch (RuntimeException runtimeException) {
                    Log.w((String)"MultiDex", (String)"Failure while trying to obtain Context class loader. Must be running in test mode. Skip patching.", (Throwable)runtimeException);
                    return;
                }
                Log.e((String)"MultiDex", (String)"Context class loader is null. Must be running in test mode. Skip patching.");
                return;
            }
            try {
                MultiDex.clearOldDexDir(object);
            }
            catch (Throwable throwable) {
                Log.w((String)"MultiDex", (String)"Something went wrong when trying to clear old MultiDex extraction, continuing without cleaning.", (Throwable)throwable);
            }
            object3 = MultiDex.getDexDir(object, (File)object2, (String)object3);
            object2 = new MultiDexExtractor(file, (File)object3);
            file = null;
            try {
                IOException iOException2;
                block23: {
                    List<? extends File> list = ((MultiDexExtractor)object2).load((Context)object, string, false);
                    try {
                        MultiDex.installSecondaryDexes((ClassLoader)object4, (File)object3, list);
                    }
                    catch (IOException iOException2) {
                        if (!bl) break block23;
                        Log.w((String)"MultiDex", (String)"Failed to install extracted secondary dex files, retrying with forced extraction", (Throwable)iOException2);
                        MultiDex.installSecondaryDexes((ClassLoader)object4, (File)object3, ((MultiDexExtractor)object2).load((Context)object, string, true));
                    }
                    object = file;
                    if (object == null) {
                        return;
                    }
                    throw object;
                }
                throw iOException2;
            }
            finally {
                ((MultiDexExtractor)object2).close();
            }
        }
    }

    private static void expandFieldArray(Object object, String object2, Object[] objectArray) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        object2 = MultiDex.findField(object, (String)object2);
        Object[] objectArray2 = (Object[])((Field)object2).get(object);
        Object[] objectArray3 = (Object[])Array.newInstance(objectArray2.getClass().getComponentType(), objectArray2.length + objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, 0, objectArray2.length);
        System.arraycopy(objectArray, 0, objectArray3, objectArray2.length, objectArray.length);
        ((Field)object2).set(object, objectArray3);
    }

    private static Field findField(Object object, String string) throws NoSuchFieldException {
        Serializable serializable;
        for (serializable = object.getClass(); serializable != null; serializable = ((Class)serializable).getSuperclass()) {
            try {
                Field field = ((Class)serializable).getDeclaredField(string);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Field ");
        ((StringBuilder)serializable).append(string);
        ((StringBuilder)serializable).append(" not found in ");
        ((StringBuilder)serializable).append(object.getClass());
        object = new NoSuchFieldException(((StringBuilder)serializable).toString());
        throw object;
    }

    private static Method findMethod(Object object, String string, Class<?> ... classArray) throws NoSuchMethodException {
        Serializable serializable;
        for (serializable = object.getClass(); serializable != null; serializable = ((Class)serializable).getSuperclass()) {
            try {
                Method method = ((Class)serializable).getDeclaredMethod(string, classArray);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Method ");
        ((StringBuilder)serializable).append(string);
        ((StringBuilder)serializable).append(" with parameters ");
        ((StringBuilder)serializable).append(Arrays.asList(classArray));
        ((StringBuilder)serializable).append(" not found in ");
        ((StringBuilder)serializable).append(object.getClass());
        object = new NoSuchMethodException(((StringBuilder)serializable).toString());
        throw object;
    }

    private static ApplicationInfo getApplicationInfo(Context context) {
        try {
            context = context.getApplicationInfo();
            return context;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)"MultiDex", (String)"Failure while trying to obtain ApplicationInfo from Context. Must be running in test mode. Skip patching.", (Throwable)runtimeException);
            return null;
        }
    }

    private static File getDexDir(Context object, File file, String string) throws IOException {
        file = new File(file, "code_cache");
        try {
            MultiDex.mkdirChecked(file);
            object = file;
        }
        catch (IOException iOException) {
            object = new File(object.getFilesDir(), "code_cache");
            MultiDex.mkdirChecked((File)object);
        }
        object = new File((File)object, string);
        MultiDex.mkdirChecked((File)object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void install(Context object) {
        Log.i((String)"MultiDex", (String)"Installing application");
        if (IS_VM_MULTIDEX_CAPABLE) {
            Log.i((String)"MultiDex", (String)"VM has multidex support, MultiDex support library is disabled.");
            return;
        }
        if (Build.VERSION.SDK_INT < 4) {
            object = new StringBuilder();
            ((StringBuilder)object).append("MultiDex installation failed. SDK ");
            ((StringBuilder)object).append(Build.VERSION.SDK_INT);
            ((StringBuilder)object).append(" is unsupported. Min SDK version is ");
            ((StringBuilder)object).append(4);
            ((StringBuilder)object).append(".");
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        try {
            ApplicationInfo applicationInfo = MultiDex.getApplicationInfo((Context)object);
            if (applicationInfo == null) {
                Log.i((String)"MultiDex", (String)"No ApplicationInfo available, i.e. running on a test Context: MultiDex support library is disabled.");
                return;
            }
            File file = new File(applicationInfo.sourceDir);
            File file2 = new File(applicationInfo.dataDir);
            MultiDex.doInstallation((Context)object, file, file2, "secondary-dexes", "", true);
        }
        catch (Exception exception) {
            Log.e((String)"MultiDex", (String)"MultiDex installation failure", (Throwable)exception);
            object = new StringBuilder();
            ((StringBuilder)object).append("MultiDex installation failed (");
            ((StringBuilder)object).append(exception.getMessage());
            ((StringBuilder)object).append(").");
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        Log.i((String)"MultiDex", (String)"install done");
    }

    private static void installSecondaryDexes(ClassLoader classLoader, File file, List<? extends File> list) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IOException, SecurityException, ClassNotFoundException, InstantiationException {
        if (!list.isEmpty()) {
            if (Build.VERSION.SDK_INT >= 19) {
                V19.install(classLoader, list, file);
            } else if (Build.VERSION.SDK_INT >= 14) {
                V14.install(classLoader, list);
            } else {
                V4.install(classLoader, list);
            }
        }
    }

    static boolean isVMMultidexCapable(String string) {
        Object object;
        boolean bl;
        block6: {
            boolean bl2;
            bl = bl2 = false;
            if (string != null) {
                object = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?").matcher(string);
                bl = bl2;
                if (((Matcher)object).matches()) {
                    try {
                        int n = Integer.parseInt(((Matcher)object).group(1));
                        int n2 = Integer.parseInt(((Matcher)object).group(2));
                        if (n <= 2) {
                            bl = bl2;
                            if (n != 2) break block6;
                            bl = bl2;
                            if (n2 < 1) break block6;
                        }
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = bl2;
                    }
                }
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("VM with version ");
        ((StringBuilder)object).append(string);
        string = bl ? " has multidex support" : " does not have multidex support";
        ((StringBuilder)object).append(string);
        Log.i((String)"MultiDex", (String)((StringBuilder)object).toString());
        return bl;
    }

    private static void mkdirChecked(File file) throws IOException {
        file.mkdir();
        if (!file.isDirectory()) {
            StringBuilder stringBuilder;
            File file2 = file.getParentFile();
            if (file2 == null) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("Failed to create dir ");
                stringBuilder.append(file.getPath());
                stringBuilder.append(". Parent file is null.");
                Log.e((String)"MultiDex", (String)stringBuilder.toString());
            } else {
                stringBuilder = new StringBuilder();
                stringBuilder.append("Failed to create dir ");
                stringBuilder.append(file.getPath());
                stringBuilder.append(". parent file is a dir ");
                stringBuilder.append(file2.isDirectory());
                stringBuilder.append(", a file ");
                stringBuilder.append(file2.isFile());
                stringBuilder.append(", exists ");
                stringBuilder.append(file2.exists());
                stringBuilder.append(", readable ");
                stringBuilder.append(file2.canRead());
                stringBuilder.append(", writable ");
                stringBuilder.append(file2.canWrite());
                Log.e((String)"MultiDex", (String)stringBuilder.toString());
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to create directory ");
            stringBuilder.append(file.getPath());
            throw new IOException(stringBuilder.toString());
        }
    }

    private static final class V14 {
        private static final int EXTRACTED_SUFFIX_LENGTH = 4;
        private final ElementConstructor elementConstructor;

        private V14() throws ClassNotFoundException, SecurityException, NoSuchMethodException {
            ElementConstructor elementConstructor;
            Class<?> clazz = Class.forName("dalvik.system.DexPathList$Element");
            try {
                elementConstructor = new ICSElementConstructor(clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    super(clazz);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    elementConstructor = new JBMR2ElementConstructor(clazz);
                }
            }
            this.elementConstructor = elementConstructor;
        }

        static void install(ClassLoader object, List<? extends File> objectArray) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
            object = MultiDex.findField(object, "pathList").get(object);
            objectArray = new V14().makeDexElements((List<? extends File>)objectArray);
            try {
                MultiDex.expandFieldArray(object, "dexElements", objectArray);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Log.w((String)"MultiDex", (String)"Failed find field 'dexElements' attempting 'pathElements'", (Throwable)noSuchFieldException);
                MultiDex.expandFieldArray(object, "pathElements", objectArray);
            }
        }

        private Object[] makeDexElements(List<? extends File> list) throws IOException, SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
            int n = list.size();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                File file = list.get(i);
                objectArray[i] = this.elementConstructor.newInstance(file, DexFile.loadDex((String)file.getPath(), (String)V14.optimizedPathFor(file), (int)0));
            }
            return objectArray;
        }

        private static String optimizedPathFor(File object) {
            File file = ((File)object).getParentFile();
            object = ((File)object).getName();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((String)object).substring(0, ((String)object).length() - EXTRACTED_SUFFIX_LENGTH));
            stringBuilder.append(".dex");
            return new File(file, stringBuilder.toString()).getPath();
        }

        private static interface ElementConstructor {
            public Object newInstance(File var1, DexFile var2) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException;
        }

        private static class ICSElementConstructor
        implements ElementConstructor {
            private final Constructor<?> elementConstructor;

            ICSElementConstructor(Class<?> genericDeclaration) throws SecurityException, NoSuchMethodException {
                genericDeclaration = ((Class)genericDeclaration).getConstructor(File.class, ZipFile.class, DexFile.class);
                this.elementConstructor = genericDeclaration;
                ((Constructor)genericDeclaration).setAccessible(true);
            }

            @Override
            public Object newInstance(File file, DexFile dexFile) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
                return this.elementConstructor.newInstance(file, new ZipFile(file), dexFile);
            }
        }

        private static class JBMR11ElementConstructor
        implements ElementConstructor {
            private final Constructor<?> elementConstructor;

            JBMR11ElementConstructor(Class<?> genericDeclaration) throws SecurityException, NoSuchMethodException {
                genericDeclaration = ((Class)genericDeclaration).getConstructor(File.class, File.class, DexFile.class);
                this.elementConstructor = genericDeclaration;
                ((Constructor)genericDeclaration).setAccessible(true);
            }

            @Override
            public Object newInstance(File file, DexFile dexFile) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
                return this.elementConstructor.newInstance(file, file, dexFile);
            }
        }

        private static class JBMR2ElementConstructor
        implements ElementConstructor {
            private final Constructor<?> elementConstructor;

            JBMR2ElementConstructor(Class<?> genericDeclaration) throws SecurityException, NoSuchMethodException {
                genericDeclaration = ((Class)genericDeclaration).getConstructor(File.class, Boolean.TYPE, File.class, DexFile.class);
                this.elementConstructor = genericDeclaration;
                ((Constructor)genericDeclaration).setAccessible(true);
            }

            @Override
            public Object newInstance(File file, DexFile dexFile) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
                return this.elementConstructor.newInstance(file, Boolean.FALSE, file, dexFile);
            }
        }
    }

    private static final class V19 {
        static void install(ClassLoader object, List<? extends File> object2, File iOExceptionArray) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IOException {
            Object object3 = MultiDex.findField(object, "pathList").get(object);
            ArrayList<IOException> arrayList = new ArrayList<IOException>();
            MultiDex.expandFieldArray(object3, "dexElements", V19.makeDexElements(object3, new ArrayList<File>((Collection<File>)object2), (File)iOExceptionArray, arrayList));
            if (arrayList.size() > 0) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    Log.w((String)"MultiDex", (String)"Exception in makeDexElement", (Throwable)((IOException)object.next()));
                }
                object2 = MultiDex.findField(object3, "dexElementsSuppressedExceptions");
                iOExceptionArray = (IOException[])((Field)object2).get(object3);
                if (iOExceptionArray == null) {
                    object = arrayList.toArray(new IOException[arrayList.size()]);
                } else {
                    object = new IOException[arrayList.size() + iOExceptionArray.length];
                    arrayList.toArray((T[])object);
                    System.arraycopy(iOExceptionArray, 0, object, arrayList.size(), iOExceptionArray.length);
                }
                ((Field)object2).set(object3, object);
                object = new IOException("I/O exception during makeDexElement");
                ((Throwable)object).initCause(arrayList.get(0));
                throw object;
            }
        }

        private static Object[] makeDexElements(Object object, ArrayList<File> arrayList, File file, ArrayList<IOException> arrayList2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            return (Object[])MultiDex.findMethod(object, "makeDexElements", new Class[]{ArrayList.class, File.class, ArrayList.class}).invoke(object, arrayList, file, arrayList2);
        }
    }

    private static final class V4 {
        static void install(ClassLoader classLoader, List<? extends File> object) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, IOException {
            int n = object.size();
            Field field = MultiDex.findField(classLoader, "path");
            StringBuilder stringBuilder = new StringBuilder((String)field.get(classLoader));
            Object[] objectArray = new String[n];
            Object[] objectArray2 = new File[n];
            Object[] objectArray3 = new ZipFile[n];
            Object[] objectArray4 = new DexFile[n];
            object = object.listIterator();
            while (object.hasNext()) {
                Comparable<File> comparable = (File)object.next();
                String string = ((File)comparable).getAbsolutePath();
                stringBuilder.append(':');
                stringBuilder.append(string);
                n = object.previousIndex();
                objectArray[n] = string;
                objectArray2[n] = comparable;
                objectArray3[n] = new ZipFile((File)comparable);
                comparable = new StringBuilder();
                ((StringBuilder)comparable).append(string);
                ((StringBuilder)comparable).append(".dex");
                objectArray4[n] = DexFile.loadDex((String)string, (String)((StringBuilder)comparable).toString(), (int)0);
            }
            field.set(classLoader, stringBuilder.toString());
            MultiDex.expandFieldArray(classLoader, "mPaths", objectArray);
            MultiDex.expandFieldArray(classLoader, "mFiles", objectArray2);
            MultiDex.expandFieldArray(classLoader, "mZips", objectArray3);
            MultiDex.expandFieldArray(classLoader, "mDexs", objectArray4);
        }
    }
}

