/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.arch.core.internal.FastSafeIterableMap;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Lifecycling;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class LifecycleRegistry
extends Lifecycle {
    private int mAddingObserverCounter = 0;
    private boolean mHandlingEvent = false;
    private final WeakReference<LifecycleOwner> mLifecycleOwner;
    private boolean mNewEventOccurred = false;
    private FastSafeIterableMap<LifecycleObserver, ObserverWithState> mObserverMap = new FastSafeIterableMap();
    private ArrayList<Lifecycle.State> mParentStates = new ArrayList();
    private Lifecycle.State mState;

    public LifecycleRegistry(LifecycleOwner lifecycleOwner) {
        this.mLifecycleOwner = new WeakReference<LifecycleOwner>(lifecycleOwner);
        this.mState = Lifecycle.State.INITIALIZED;
    }

    private void backwardPass(LifecycleOwner lifecycleOwner) {
        Iterator iterator = this.mObserverMap.descendingIterator();
        while (iterator.hasNext() && !this.mNewEventOccurred) {
            Map.Entry entry = iterator.next();
            ObserverWithState observerWithState = (ObserverWithState)entry.getValue();
            while (observerWithState.mState.compareTo(this.mState) > 0 && !this.mNewEventOccurred && this.mObserverMap.contains((LifecycleObserver)entry.getKey())) {
                Lifecycle.Event event = LifecycleRegistry.downEvent(observerWithState.mState);
                this.pushParentState(LifecycleRegistry.getStateAfter(event));
                observerWithState.dispatchEvent(lifecycleOwner, event);
                this.popParentState();
            }
        }
    }

    private Lifecycle.State calculateTargetState(LifecycleObserver object) {
        object = this.mObserverMap.ceil((LifecycleObserver)object);
        Object object2 = null;
        object = object != null ? ((ObserverWithState)object.getValue()).mState : null;
        if (!this.mParentStates.isEmpty()) {
            object2 = this.mParentStates;
            object2 = object2.get(object2.size() - 1);
        }
        return LifecycleRegistry.min(LifecycleRegistry.min(this.mState, (Lifecycle.State)((Object)object)), object2);
    }

    private static Lifecycle.Event downEvent(Lifecycle.State state) {
        int n = 1.$SwitchMap$androidx$lifecycle$Lifecycle$State[state.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n != 4) {
                        if (n != 5) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Unexpected state value ");
                            stringBuilder.append((Object)state);
                            throw new IllegalArgumentException(stringBuilder.toString());
                        }
                        throw new IllegalArgumentException();
                    }
                    return Lifecycle.Event.ON_PAUSE;
                }
                return Lifecycle.Event.ON_STOP;
            }
            return Lifecycle.Event.ON_DESTROY;
        }
        throw new IllegalArgumentException();
    }

    private void forwardPass(LifecycleOwner lifecycleOwner) {
        SafeIterableMap.IteratorWithAdditions iteratorWithAdditions = this.mObserverMap.iteratorWithAdditions();
        while (iteratorWithAdditions.hasNext() && !this.mNewEventOccurred) {
            Map.Entry entry = (Map.Entry)iteratorWithAdditions.next();
            ObserverWithState observerWithState = (ObserverWithState)entry.getValue();
            while (observerWithState.mState.compareTo(this.mState) < 0 && !this.mNewEventOccurred && this.mObserverMap.contains((LifecycleObserver)entry.getKey())) {
                this.pushParentState(observerWithState.mState);
                observerWithState.dispatchEvent(lifecycleOwner, LifecycleRegistry.upEvent(observerWithState.mState));
                this.popParentState();
            }
        }
    }

    static Lifecycle.State getStateAfter(Lifecycle.Event event) {
        switch (1.$SwitchMap$androidx$lifecycle$Lifecycle$Event[event.ordinal()]) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unexpected event value ");
                stringBuilder.append((Object)event);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            case 6: {
                return Lifecycle.State.DESTROYED;
            }
            case 5: {
                return Lifecycle.State.RESUMED;
            }
            case 3: 
            case 4: {
                return Lifecycle.State.STARTED;
            }
            case 1: 
            case 2: 
        }
        return Lifecycle.State.CREATED;
    }

    private boolean isSynced() {
        int n = this.mObserverMap.size();
        boolean bl = true;
        if (n == 0) {
            return true;
        }
        Lifecycle.State state = ((ObserverWithState)this.mObserverMap.eldest().getValue()).mState;
        Lifecycle.State state2 = ((ObserverWithState)this.mObserverMap.newest().getValue()).mState;
        if (state != state2 || this.mState != state2) {
            bl = false;
        }
        return bl;
    }

    static Lifecycle.State min(Lifecycle.State state, Lifecycle.State state2) {
        Lifecycle.State state3 = state;
        if (state2 != null) {
            state3 = state;
            if (state2.compareTo(state) < 0) {
                state3 = state2;
            }
        }
        return state3;
    }

    private void popParentState() {
        ArrayList<Lifecycle.State> arrayList = this.mParentStates;
        arrayList.remove(arrayList.size() - 1);
    }

    private void pushParentState(Lifecycle.State state) {
        this.mParentStates.add(state);
    }

    private void sync() {
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.mLifecycleOwner.get();
        if (lifecycleOwner != null) {
            while (!this.isSynced()) {
                this.mNewEventOccurred = false;
                if (this.mState.compareTo(((ObserverWithState)this.mObserverMap.eldest().getValue()).mState) < 0) {
                    this.backwardPass(lifecycleOwner);
                }
                Map.Entry entry = this.mObserverMap.newest();
                if (this.mNewEventOccurred || entry == null || this.mState.compareTo(((ObserverWithState)entry.getValue()).mState) <= 0) continue;
                this.forwardPass(lifecycleOwner);
            }
            this.mNewEventOccurred = false;
            return;
        }
        IllegalStateException illegalStateException = new IllegalStateException("LifecycleOwner of this LifecycleRegistry is alreadygarbage collected. It is too late to change lifecycle state.");
        throw illegalStateException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Lifecycle.Event upEvent(Lifecycle.State state) {
        int n = 1.$SwitchMap$androidx$lifecycle$Lifecycle$State[state.ordinal()];
        if (n == 1) return Lifecycle.Event.ON_CREATE;
        if (n == 2) return Lifecycle.Event.ON_START;
        if (n == 3) return Lifecycle.Event.ON_RESUME;
        if (n == 4) throw new IllegalArgumentException();
        if (n == 5) return Lifecycle.Event.ON_CREATE;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unexpected state value ");
        stringBuilder.append((Object)state);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public void addObserver(LifecycleObserver lifecycleObserver) {
        Lifecycle.State state = this.mState == Lifecycle.State.DESTROYED ? Lifecycle.State.DESTROYED : Lifecycle.State.INITIALIZED;
        ObserverWithState observerWithState = new ObserverWithState(lifecycleObserver, state);
        if (this.mObserverMap.putIfAbsent(lifecycleObserver, observerWithState) != null) {
            return;
        }
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.mLifecycleOwner.get();
        if (lifecycleOwner == null) {
            return;
        }
        boolean bl = this.mAddingObserverCounter != 0 || this.mHandlingEvent;
        state = this.calculateTargetState(lifecycleObserver);
        ++this.mAddingObserverCounter;
        while (observerWithState.mState.compareTo(state) < 0 && this.mObserverMap.contains(lifecycleObserver)) {
            this.pushParentState(observerWithState.mState);
            observerWithState.dispatchEvent(lifecycleOwner, LifecycleRegistry.upEvent(observerWithState.mState));
            this.popParentState();
            state = this.calculateTargetState(lifecycleObserver);
        }
        if (!bl) {
            this.sync();
        }
        --this.mAddingObserverCounter;
    }

    static class ObserverWithState {
        LifecycleEventObserver mLifecycleObserver;
        Lifecycle.State mState;

        ObserverWithState(LifecycleObserver lifecycleObserver, Lifecycle.State state) {
            this.mLifecycleObserver = Lifecycling.lifecycleEventObserver(lifecycleObserver);
            this.mState = state;
        }

        void dispatchEvent(LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
            Lifecycle.State state = LifecycleRegistry.getStateAfter(event);
            this.mState = LifecycleRegistry.min(this.mState, state);
            this.mLifecycleObserver.onStateChanged(lifecycleOwner, event);
            this.mState = state;
        }
    }
}

