/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.ContainerHelpers;
import java.util.ConcurrentModificationException;

public class SimpleArrayMap<K, V> {
    static Object[] mBaseCache;
    static int mBaseCacheSize;
    static Object[] mTwiceBaseCache;
    static int mTwiceBaseCacheSize;
    Object[] mArray;
    int[] mHashes = ContainerHelpers.EMPTY_INTS;
    int mSize = 0;

    public SimpleArrayMap() {
        this.mArray = ContainerHelpers.EMPTY_OBJECTS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void allocArrays(int n) {
        if (n == 8) {
            synchronized (SimpleArrayMap.class) {
                Object[] objectArray = mTwiceBaseCache;
                if (objectArray != null) {
                    this.mArray = objectArray;
                    mTwiceBaseCache = (Object[])objectArray[0];
                    this.mHashes = (int[])objectArray[1];
                    objectArray[1] = null;
                    objectArray[0] = null;
                    --mTwiceBaseCacheSize;
                    return;
                }
            }
        } else if (n == 4) {
            synchronized (SimpleArrayMap.class) {
                Object[] objectArray = mBaseCache;
                if (objectArray != null) {
                    this.mArray = objectArray;
                    mBaseCache = (Object[])objectArray[0];
                    this.mHashes = (int[])objectArray[1];
                    objectArray[1] = null;
                    objectArray[0] = null;
                    --mBaseCacheSize;
                    return;
                }
            }
        }
        this.mHashes = new int[n];
        this.mArray = new Object[n << 1];
    }

    private static int binarySearchHashes(int[] nArray, int n, int n2) {
        try {
            n = ContainerHelpers.binarySearch(nArray, n, n2);
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void freeArrays(int[] nArray, Object[] objectArray, int n) {
        if (nArray.length == 8) {
            synchronized (SimpleArrayMap.class) {
                if (mTwiceBaseCacheSize >= 10) return;
                objectArray[0] = mTwiceBaseCache;
                objectArray[1] = nArray;
                n = (n << 1) - 1;
                while (true) {
                    if (n < 2) {
                        mTwiceBaseCache = objectArray;
                        ++mTwiceBaseCacheSize;
                        return;
                    }
                    objectArray[n] = null;
                    --n;
                }
            }
        }
        if (nArray.length != 4) return;
        synchronized (SimpleArrayMap.class) {
            if (mBaseCacheSize >= 10) return;
            objectArray[0] = mBaseCache;
            objectArray[1] = nArray;
            n = (n << 1) - 1;
            while (true) {
                if (n < 2) {
                    mBaseCache = objectArray;
                    ++mBaseCacheSize;
                    return;
                }
                objectArray[n] = null;
                --n;
            }
        }
    }

    int indexOf(Object object, int n) {
        int n2;
        int n3 = this.mSize;
        if (n3 == 0) {
            return -1;
        }
        int n4 = SimpleArrayMap.binarySearchHashes(this.mHashes, n3, n);
        if (n4 < 0) {
            return n4;
        }
        if (object.equals(this.mArray[n4 << 1])) {
            return n4;
        }
        for (n2 = n4 + 1; n2 < n3 && this.mHashes[n2] == n; ++n2) {
            if (!object.equals(this.mArray[n2 << 1])) continue;
            return n2;
        }
        for (n3 = n4 - 1; n3 >= 0 && this.mHashes[n3] == n; --n3) {
            if (!object.equals(this.mArray[n3 << 1])) continue;
            return n3;
        }
        return ~n2;
    }

    int indexOfNull() {
        int n;
        int n2 = this.mSize;
        if (n2 == 0) {
            return -1;
        }
        int n3 = SimpleArrayMap.binarySearchHashes(this.mHashes, n2, 0);
        if (n3 < 0) {
            return n3;
        }
        if (this.mArray[n3 << 1] == null) {
            return n3;
        }
        for (n = n3 + 1; n < n2 && this.mHashes[n] == 0; ++n) {
            if (this.mArray[n << 1] != null) continue;
            return n;
        }
        for (n2 = n3 - 1; n2 >= 0 && this.mHashes[n2] == 0; --n2) {
            if (this.mArray[n2 << 1] != null) continue;
            return n2;
        }
        return ~n;
    }

    public V put(K object, V v) {
        Object[] objectArray;
        int n;
        int n2;
        int n3 = this.mSize;
        if (object == null) {
            n2 = this.indexOfNull();
            n = 0;
        } else {
            n = object.hashCode();
            n2 = this.indexOf(object, n);
        }
        if (n2 >= 0) {
            n2 = (n2 << 1) + 1;
            Object[] objectArray2 = this.mArray;
            object = objectArray2[n2];
            objectArray2[n2] = v;
            return (V)object;
        }
        int n4 = ~n2;
        int[] nArray = this.mHashes;
        if (n3 >= nArray.length) {
            n2 = 4;
            if (n3 >= 8) {
                n2 = (n3 >> 1) + n3;
            } else if (n3 >= 4) {
                n2 = 8;
            }
            Object[] objectArray3 = this.mArray;
            this.allocArrays(n2);
            if (n3 == this.mSize) {
                objectArray = this.mHashes;
                if (objectArray.length > 0) {
                    System.arraycopy(nArray, 0, objectArray, 0, nArray.length);
                    System.arraycopy(objectArray3, 0, this.mArray, 0, objectArray3.length);
                }
                SimpleArrayMap.freeArrays(nArray, objectArray3, n3);
            } else {
                throw new ConcurrentModificationException();
            }
        }
        if (n4 < n3) {
            objectArray = this.mHashes;
            n2 = n4 + 1;
            System.arraycopy(objectArray, n4, objectArray, n2, n3 - n4);
            objectArray = this.mArray;
            System.arraycopy(objectArray, n4 << 1, objectArray, n2 << 1, this.mSize - n4 << 1);
        }
        if (n3 == (n2 = this.mSize) && n4 < (objectArray = this.mHashes).length) {
            objectArray[n4] = n;
            objectArray = this.mArray;
            n = n4 << 1;
            objectArray[n] = (int)object;
            objectArray[n + 1] = (int)v;
            this.mSize = n2 + 1;
            return null;
        }
        throw new ConcurrentModificationException();
    }
}

