/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity;

import android.os.Build;
import androidx.activity.ImmLeaksCleaner;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherOwner;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.ViewModelStore;
import androidx.savedstate.SavedStateRegistryController;
import androidx.savedstate.SavedStateRegistryOwner;

public class ComponentActivity
extends androidx.core.app.ComponentActivity
implements OnBackPressedDispatcherOwner,
LifecycleOwner,
SavedStateRegistryOwner {
    private final LifecycleRegistry mLifecycleRegistry = new LifecycleRegistry(this);
    private final OnBackPressedDispatcher mOnBackPressedDispatcher;
    private final SavedStateRegistryController mSavedStateRegistryController = SavedStateRegistryController.create(this);
    private ViewModelStore mViewModelStore;

    public ComponentActivity() {
        this.mOnBackPressedDispatcher = new OnBackPressedDispatcher(new Runnable(){});
        if (this.getLifecycle() != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.getLifecycle().addObserver(new LifecycleEventObserver(){

                    @Override
                    public void onStateChanged(LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
                        if (event == Lifecycle.Event.ON_STOP && (lifecycleOwner = (lifecycleOwner = ComponentActivity.this.getWindow()) != null ? lifecycleOwner.peekDecorView() : null) != null) {
                            lifecycleOwner.cancelPendingInputEvents();
                        }
                    }
                });
            }
            this.getLifecycle().addObserver(new LifecycleEventObserver(){

                @Override
                public void onStateChanged(LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
                    if (event == Lifecycle.Event.ON_DESTROY && !ComponentActivity.this.isChangingConfigurations()) {
                        ComponentActivity.this.getViewModelStore().clear();
                    }
                }
            });
            if (19 <= Build.VERSION.SDK_INT && Build.VERSION.SDK_INT <= 23) {
                this.getLifecycle().addObserver(new ImmLeaksCleaner(this));
            }
            return;
        }
        throw new IllegalStateException("getLifecycle() returned null in ComponentActivity's constructor. Please make sure you are lazily constructing your Lifecycle in the first call to getLifecycle() rather than relying on field initialization.");
    }

    @Override
    public Lifecycle getLifecycle() {
        return this.mLifecycleRegistry;
    }

    public ViewModelStore getViewModelStore() {
        if (this.getApplication() != null) {
            if (this.mViewModelStore == null) {
                NonConfigurationInstances nonConfigurationInstances = (NonConfigurationInstances)this.getLastNonConfigurationInstance();
                if (nonConfigurationInstances != null) {
                    this.mViewModelStore = nonConfigurationInstances.viewModelStore;
                }
                if (this.mViewModelStore == null) {
                    this.mViewModelStore = new ViewModelStore();
                }
            }
            return this.mViewModelStore;
        }
        throw new IllegalStateException("Your activity is not yet attached to the Application instance. You can't request ViewModel before onCreate call.");
    }

    static final class NonConfigurationInstances {
        ViewModelStore viewModelStore;

        NonConfigurationInstances() {
        }
    }
}

