/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.evaluation.StoringInvocationUnit;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class SimpleEnumArrayPropagator
implements ClassVisitor,
MemberVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor fieldArrayFinder = new MemberDescriptorFilter("[I", (MemberVisitor)this);
    private final MemberVisitor methodArrayPropagator = new OptimizationInfoMemberFilter(new MemberDescriptorFilter("()[I", (MemberVisitor)this));
    private final ValueFactory valueFactory = new ParticularValueFactory();
    private Value array;

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.array = null;
        programClass.fieldsAccept(this.fieldArrayFinder);
        if (this.array != null) {
            programClass.methodsAccept(this.methodArrayPropagator);
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.array = StoringInvocationUnit.getFieldValue(programField);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        ReferenceValue propagatedArray = this.valueFactory.createArrayReferenceValue("I", null, this.array.referenceValue().arrayLength(this.valueFactory));
        SimpleEnumArrayPropagator.setMethodReturnValue(programMethod, propagatedArray);
    }

    private static void setMethodReturnValue(Method method, Value value) {
        ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).setReturnValue(value);
    }
}

