/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import proguard.util.StringUtil;

public class ZipOutput {
    private static final int MAGIC_LOCAL_FILE_HEADER = 67324752;
    private static final int MAGIC_CENTRAL_DIRECTORY_FILE_HEADER = 33639248;
    private static final int MAGIC_END_OF_CENTRAL_DIRECTORY = 101010256;
    private static final int VERSION = 10;
    private static final int GENERAL_PURPOSE_FLAG = 0;
    private static final int METHOD_UNCOMPRESSED = 0;
    private static final int METHOD_COMPRESSED = 8;
    private static final boolean DEBUG = false;
    protected DataOutputStream outputStream;
    private final int uncompressedAlignment;
    private final String comment;
    private List zipEntries = new ArrayList();
    private Set zipEntryNames = new HashSet();

    public ZipOutput(OutputStream outputStream) {
        this(outputStream, 1);
    }

    public ZipOutput(OutputStream outputStream, int uncompressedAlignment) {
        this(outputStream, uncompressedAlignment, null);
    }

    public ZipOutput(OutputStream outputStream, int uncompressedAlignment, String comment) {
        this(new DataOutputStream(outputStream), uncompressedAlignment, comment);
    }

    public ZipOutput(DataOutputStream outputStream, int uncompressedAlignment, String comment) {
        this.outputStream = outputStream;
        this.uncompressedAlignment = uncompressedAlignment;
        this.comment = comment;
    }

    public ZipOutput(OutputStream outputStream, byte[] header, int uncompressedAlignment) throws IOException {
        this(outputStream, header, uncompressedAlignment, null);
    }

    public ZipOutput(OutputStream outputStream, byte[] header, int uncompressedAlignment, String comment) throws IOException {
        this(new DataOutputStream(outputStream), header, uncompressedAlignment, comment);
    }

    public ZipOutput(DataOutputStream outputStream, byte[] header, int uncompressedAlignment, String comment) throws IOException {
        this.outputStream = outputStream;
        this.uncompressedAlignment = uncompressedAlignment;
        this.comment = comment;
        if (header != null) {
            outputStream.write(header);
        }
    }

    public OutputStream createOutputStream(String name, boolean compress, int modificationTime) throws IOException {
        return this.createOutputStream(name, compress, this.uncompressedAlignment, modificationTime, null, null);
    }

    public OutputStream createOutputStream(String name, boolean compress, int uncompressedAlignment, int modificationTime) throws IOException {
        return this.createOutputStream(name, compress, uncompressedAlignment, modificationTime, null, null);
    }

    public OutputStream createOutputStream(String name, boolean compress, int uncompressedAlignment, int modificationTime, byte[] extraField, String comment) throws IOException {
        if (!this.zipEntryNames.add(name)) {
            throw new IOException("Duplicate jar entry [" + name + "]");
        }
        ZipEntry entry = new ZipEntry(name, compress, uncompressedAlignment, modificationTime, extraField, comment);
        this.zipEntries.add(entry);
        return entry.createOutputStream();
    }

    public void close() throws IOException {
        long centralDirectoryOffset = this.writeStartOfCentralDirectory();
        this.close(centralDirectoryOffset);
    }

    public void close(long centralDirectoryOffset) throws IOException {
        long centralDirectorySize = this.writeEntriesOfCentralDirectory();
        this.writeEndOfCentralDirectory(centralDirectoryOffset, centralDirectorySize);
        this.outputStream.close();
        this.outputStream = null;
        this.zipEntries = null;
        this.zipEntryNames = null;
    }

    protected long size() {
        return this.outputStream.size();
    }

    protected long writeStartOfCentralDirectory() {
        return this.outputStream.size();
    }

    protected long writeEntriesOfCentralDirectory() throws IOException {
        long offset = this.outputStream.size();
        for (int index = 0; index < this.zipEntries.size(); ++index) {
            ZipEntry entry = (ZipEntry)this.zipEntries.get(index);
            entry.writeCentralDirectoryFileHeader();
        }
        return (long)this.outputStream.size() - offset;
    }

    protected void writeEndOfCentralDirectory(long centralDirectoryOffset, long centralDirectorySize) throws IOException {
        this.writeInt(101010256);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.zipEntries.size());
        this.writeShort(this.zipEntries.size());
        this.writeInt(centralDirectorySize);
        this.writeInt(centralDirectoryOffset);
        if (this.comment == null) {
            this.writeShort(0);
        } else {
            byte[] commentBytes = StringUtil.getModifiedUtf8Bytes(this.comment);
            this.writeShort(commentBytes.length);
            this.outputStream.write(commentBytes);
        }
    }

    protected void writeShort(int value) throws IOException {
        this.outputStream.write(value);
        this.outputStream.write(value >>> 8);
    }

    protected void writeInt(int value) throws IOException {
        this.outputStream.write(value);
        this.outputStream.write(value >>> 8);
        this.outputStream.write(value >>> 16);
        this.outputStream.write(value >>> 24);
    }

    protected void writeInt(long value) throws IOException {
        this.outputStream.write((int)value);
        this.outputStream.write((int)(value >>> 8));
        this.outputStream.write((int)(value >>> 16));
        this.outputStream.write((int)(value >>> 24));
    }

    protected void writeLong(long value) throws IOException {
        this.outputStream.write((int)value);
        this.outputStream.write((int)(value >>> 8));
        this.outputStream.write((int)(value >>> 16));
        this.outputStream.write((int)(value >>> 24));
        this.outputStream.write((int)(value >>> 32));
        this.outputStream.write((int)(value >>> 40));
        this.outputStream.write((int)(value >>> 48));
        this.outputStream.write((int)(value >>> 56));
    }

    public static void main(String[] args2) {
        try {
            ZipOutput output = new ZipOutput(new FileOutputStream(args2[0]), null, 4, "Main file comment");
            PrintWriter printWriter1 = new PrintWriter(output.createOutputStream("file1.txt", false, 1, 0, new byte[]{52, 18, 4, 0, 72, 101, 108, 108, 111}, "Comment"));
            printWriter1.println("This is file 1.");
            printWriter1.println("Hello, world!");
            printWriter1.close();
            PrintWriter printWriter2 = new PrintWriter(output.createOutputStream("file2.txt", true, 1, 0, null, "Another comment"));
            printWriter2.println("This is file 2.");
            printWriter2.println("Hello, world!");
            printWriter2.close();
            PrintWriter printWriter3 = new PrintWriter(output.createOutputStream("file3.txt", false, 1, 0, null, "Last comment"));
            printWriter3.println("This is file 3.");
            printWriter3.println("Hello, world!");
            printWriter3.close();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ZipEntry {
        private boolean compressed;
        private int uncompressedAlignment;
        private int modificationTime;
        private int crc;
        private long compressedSize;
        private long uncompressedSize;
        private long offset;
        private String name;
        private byte[] extraField;
        private String comment;

        private ZipEntry(String name, boolean compressed, int uncompressedAlignment, int modificationTime, byte[] extraField, String comment) {
            this.name = name;
            this.compressed = compressed;
            this.uncompressedAlignment = uncompressedAlignment;
            this.modificationTime = modificationTime;
            this.extraField = extraField;
            this.comment = comment;
        }

        public OutputStream createOutputStream() throws IOException {
            return this.compressed ? new CompressedZipEntryOutputStream() : new UncompressedZipEntryOutputStream();
        }

        private void writeLocalFileHeader() throws IOException {
            long dataOffset;
            ZipOutput.this.writeInt(67324752);
            ZipOutput.this.writeShort(10);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeShort(this.compressed ? 8 : 0);
            ZipOutput.this.writeInt(this.modificationTime);
            ZipOutput.this.writeInt(this.crc);
            ZipOutput.this.writeInt(this.compressedSize);
            ZipOutput.this.writeInt(this.uncompressedSize);
            byte[] nameBytes = StringUtil.getModifiedUtf8Bytes(this.name);
            int nameLength = nameBytes.length;
            int extraFieldLength = this.extraField == null ? 0 : this.extraField.length;
            ZipOutput.this.writeShort(nameLength);
            int alignmentDelta = 0;
            if (!this.compressed && (alignmentDelta = (int)((dataOffset = (long)ZipOutput.this.outputStream.size() + 2L + (long)nameLength + (long)extraFieldLength) % (long)this.uncompressedAlignment)) > 0) {
                alignmentDelta = this.uncompressedAlignment - alignmentDelta;
            }
            ZipOutput.this.writeShort(extraFieldLength + alignmentDelta);
            ZipOutput.this.outputStream.write(nameBytes);
            if (this.extraField != null) {
                ZipOutput.this.outputStream.write(this.extraField);
            }
            if (alignmentDelta > 0) {
                ZipOutput.this.outputStream.write(new byte[alignmentDelta]);
            }
        }

        public void writeCentralDirectoryFileHeader() throws IOException {
            ZipOutput.this.writeInt(33639248);
            ZipOutput.this.writeShort(10);
            ZipOutput.this.writeShort(10);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeShort(this.compressed ? 8 : 0);
            ZipOutput.this.writeInt(this.modificationTime);
            ZipOutput.this.writeInt(this.crc);
            ZipOutput.this.writeInt(this.compressedSize);
            ZipOutput.this.writeInt(this.uncompressedSize);
            byte[] nameBytes = StringUtil.getModifiedUtf8Bytes(this.name);
            byte[] commentBytes = this.comment == null ? null : StringUtil.getModifiedUtf8Bytes(this.comment);
            ZipOutput.this.writeShort(nameBytes.length);
            ZipOutput.this.writeShort(this.extraField == null ? 0 : this.extraField.length);
            ZipOutput.this.writeShort(commentBytes == null ? 0 : commentBytes.length);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeInt(0);
            ZipOutput.this.writeInt(this.offset);
            ZipOutput.this.outputStream.write(nameBytes);
            if (this.extraField != null) {
                ZipOutput.this.outputStream.write(this.extraField);
            }
            if (commentBytes != null) {
                ZipOutput.this.outputStream.write(commentBytes);
            }
        }

        private class CompressedZipEntryOutputStream
        extends DeflaterOutputStream {
            private CRC32 crc32;

            private CompressedZipEntryOutputStream() {
                super((OutputStream)new ByteArrayOutputStream(16384), new Deflater(9, true), 1024);
                this.crc32 = new CRC32();
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                this.crc32.update(b, off, len);
                ZipEntry.this.uncompressedSize = ZipEntry.this.uncompressedSize + (long)len;
            }

            @Override
            public void close() throws IOException {
                super.finish();
                this.def.end();
                super.close();
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.out;
                byte[] compressedBytes = byteArrayOutputStream.toByteArray();
                ZipEntry.this.offset = ZipOutput.this.outputStream.size();
                ZipEntry.this.crc = (int)this.crc32.getValue();
                ZipEntry.this.compressedSize = compressedBytes.length;
                ZipEntry.this.writeLocalFileHeader();
                ZipOutput.this.outputStream.write(compressedBytes);
            }
        }

        private class UncompressedZipEntryOutputStream
        extends ByteArrayOutputStream {
            private CRC32 crc32;

            private UncompressedZipEntryOutputStream() {
                super(16384);
                this.crc32 = new CRC32();
            }

            @Override
            public synchronized void write(int b) {
                super.write(b);
                this.crc32.update(b);
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                this.crc32.update(b, off, len);
            }

            @Override
            public void close() throws IOException {
                super.close();
                byte[] bytes = super.toByteArray();
                ZipEntry.this.offset = ZipOutput.this.outputStream.size();
                ZipEntry.this.crc = (int)this.crc32.getValue();
                ZipEntry.this.compressedSize = bytes.length;
                ZipEntry.this.uncompressedSize = bytes.length;
                ZipEntry.this.writeLocalFileHeader();
                ZipOutput.this.outputStream.write(bytes);
            }
        }
    }
}

