/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ant.ConfigurationTask;

public class ConfigurationElement
extends FileSet {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendTo(Configuration configuration) {
        String[] fileNames;
        File baseDir;
        if (this.isReference()) {
            Object referencedObject = this.getCheckedRef(Object.class, Object.class.getName());
            if (referencedObject instanceof ConfigurationTask) {
                ConfigurationTask configurationTask = (ConfigurationTask)referencedObject;
                configurationTask.appendTo(configuration);
                return;
            }
            if (!(referencedObject instanceof AbstractFileSet)) throw new BuildException("The refid attribute doesn't point to a <proguardconfiguration> element or a <fileset> element");
            AbstractFileSet fileSet = (AbstractFileSet)referencedObject;
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            baseDir = scanner.getBasedir();
            fileNames = scanner.getIncludedFiles();
        } else {
            DirectoryScanner scanner = this.getDirectoryScanner(this.getProject());
            baseDir = scanner.getBasedir();
            fileNames = scanner.getIncludedFiles();
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getProject().getProperties());
        try {
            for (int index = 0; index < fileNames.length; ++index) {
                File configurationFile = new File(baseDir, fileNames[index]);
                try (ConfigurationParser parser = new ConfigurationParser(configurationFile, properties);){
                    parser.parse(configuration);
                    continue;
                }
            }
            return;
        }
        catch (IOException ex) {
            throw new BuildException(ex.getMessage());
        }
    }
}

