/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jsp;

import java.io.File;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class WLJspc
extends MatchingTask {
    private File destinationDirectory;
    private File sourceDirectory;
    private String destinationPackage;
    private Path compileClasspath;
    private String pathToPackage = "";
    private Vector filesToDo = new Vector();

    public void execute() throws BuildException {
        if (!this.destinationDirectory.isDirectory()) {
            throw new BuildException("destination directory " + this.destinationDirectory.getPath() + " is not valid");
        }
        if (!this.sourceDirectory.isDirectory()) {
            throw new BuildException("src directory " + this.sourceDirectory.getPath() + " is not valid");
        }
        if (this.destinationPackage == null) {
            throw new BuildException("package attribute must be present.", this.getLocation());
        }
        this.pathToPackage = this.destinationPackage.replace('.', File.separatorChar);
        DirectoryScanner ds = super.getDirectoryScanner(this.sourceDirectory);
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        this.compileClasspath = this.compileClasspath.concatSystemClasspath();
        String[] files = ds.getIncludedFiles();
        Java helperTask = new Java(this);
        helperTask.setFork(true);
        helperTask.setClassname("weblogic.jspc");
        helperTask.setTaskName(this.getTaskName());
        String[] args2 = new String[12];
        File jspFile = null;
        String parents = "";
        int j = 0;
        args2[j++] = "-d";
        args2[j++] = this.destinationDirectory.getAbsolutePath().trim();
        args2[j++] = "-docroot";
        args2[j++] = this.sourceDirectory.getAbsolutePath().trim();
        args2[j++] = "-keepgenerated";
        args2[j++] = "-compilerclass";
        args2[j++] = "sun.tools.javac.Main";
        args2[j++] = "-classpath";
        args2[j++] = this.compileClasspath.toString();
        this.scanDir(files);
        this.log("Compiling " + this.filesToDo.size() + " JSP files");
        int size = this.filesToDo.size();
        for (int i = 0; i < size; ++i) {
            String filename = (String)this.filesToDo.elementAt(i);
            jspFile = new File(filename);
            args2[j] = "-package";
            parents = jspFile.getParent();
            if (parents != null && !"".equals(parents)) {
                parents = this.replaceString(parents, File.separator, "_.");
                args2[j + 1] = this.destinationPackage + "." + "_" + parents;
            } else {
                args2[j + 1] = this.destinationPackage;
            }
            args2[j + 2] = this.sourceDirectory + File.separator + filename;
            helperTask.clearArgs();
            for (int x = 0; x < j + 3; ++x) {
                helperTask.createArg().setValue(args2[x]);
            }
            helperTask.setClasspath(this.compileClasspath);
            if (helperTask.executeJava() == 0) continue;
            this.log(filename + " failed to compile", 1);
        }
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath;
    }

    public void setSrc(File dirName) {
        this.sourceDirectory = dirName;
    }

    public void setDest(File dirName) {
        this.destinationDirectory = dirName;
    }

    public void setPackage(String packageName) {
        this.destinationPackage = packageName;
    }

    protected void scanDir(String[] files) {
        long now = new Date().getTime();
        File jspFile = null;
        String parents = null;
        String pack = "";
        for (int i = 0; i < files.length; ++i) {
            File srcFile = new File(this.sourceDirectory, files[i]);
            jspFile = new File(files[i]);
            parents = jspFile.getParent();
            if (parents != null && !"".equals(parents)) {
                parents = this.replaceString(parents, File.separator, "_/");
                pack = this.pathToPackage + File.separator + "_" + parents;
            } else {
                pack = this.pathToPackage;
            }
            String filePath = pack + File.separator + "_";
            int startingIndex = files[i].lastIndexOf(File.separator) != -1 ? files[i].lastIndexOf(File.separator) + 1 : 0;
            int endingIndex = files[i].indexOf(".jsp");
            if (endingIndex == -1) {
                this.log("Skipping " + files[i] + ". Not a JSP", 3);
                continue;
            }
            filePath = filePath + files[i].substring(startingIndex, endingIndex);
            filePath = filePath + ".class";
            File classFile = new File(this.destinationDirectory, filePath);
            if (srcFile.lastModified() > now) {
                this.log("Warning: file modified in the future: " + files[i], 1);
            }
            if (srcFile.lastModified() <= classFile.lastModified()) continue;
            this.filesToDo.addElement(files[i]);
            this.log("Recompiling File " + files[i], 3);
        }
    }

    protected String replaceString(String inpString, String escapeChars, String replaceChars) {
        String localString = "";
        int numTokens = 0;
        StringTokenizer st = new StringTokenizer(inpString, escapeChars, true);
        numTokens = st.countTokens();
        for (int i = 0; i < numTokens; ++i) {
            String test = st.nextToken();
            test = test.equals(escapeChars) ? replaceChars : test;
            localString = localString + test;
        }
        return localString;
    }
}

