/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.util.ArrayList;
import java.util.HashSet;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.KotlinModulePackage;
import proguard.resources.kotlinmodule.visitor.KotlinModulePackageVisitor;
import proguard.shrink.SimpleUsageMarker;

public class KotlinModuleShrinker
implements ResourceFileVisitor,
KotlinModulePackageVisitor {
    private final SimpleUsageMarker usageMarker;

    KotlinModuleShrinker(SimpleUsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
        kotlinModule.modulePackagesAccept(this);
    }

    @Override
    public void visitKotlinModulePackage(KotlinModule kotlinModule, KotlinModulePackage kotlinModulePart) {
        for (int k = kotlinModulePart.referencedFileFacades.size() - 1; k >= 0; --k) {
            KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata = kotlinModulePart.referencedFileFacades.get(k);
            if (this.usageMarker.isUsed(kotlinFileFacadeKindMetadata)) continue;
            kotlinModulePart.fileFacadeNames.remove(k);
            kotlinModulePart.referencedFileFacades.remove(k);
        }
        ArrayList partsToRemove = new ArrayList();
        HashSet facadesToRemove = new HashSet();
        kotlinModulePart.multiFileClassParts.forEach((partName, facadeName) -> {
            KotlinMultiFilePartKindMetadata referencedMultiFilePart = kotlinModulePart.referencedMultiFileParts.get(partName);
            if (!this.usageMarker.isUsed(referencedMultiFilePart.ownerReferencedClass)) {
                partsToRemove.add(partName);
            }
            if (!this.usageMarker.isUsed(referencedMultiFilePart.referencedFacadeClass)) {
                facadesToRemove.add(facadeName);
            }
        });
        for (String partName2 : partsToRemove) {
            kotlinModulePart.multiFileClassParts.remove(partName2);
            kotlinModulePart.referencedMultiFileParts.remove(partName2);
        }
        for (String facadeName2 : facadesToRemove) {
            kotlinModulePart.multiFileClassParts.values().removeIf(f -> f.equals(facadeName2));
        }
    }
}

