/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import proguard.obfuscate.MappingReader;
import proguard.retrace.FrameInfo;
import proguard.retrace.FramePattern;
import proguard.retrace.FrameRemapper;

public class ReTrace {
    private static final String USAGE = "Usage: java proguard.retrace.ReTrace [-regex <regex>] [-allclassnames] [-verbose] <mapping_file> [<stacktrace_file>]";
    private static final String DEFAULT_REGEX = "Default regex: ";
    private static final String REGEX_OPTION = "-regex";
    private static final String ALL_CLASS_NAMES_OPTION = "-allclassnames";
    private static final String VERBOSE_OPTION = "-verbose";
    private static final String REGULAR_EXPRESSION_CLASS_METHOD = "%c\\.%m";
    private static final String REGULAR_EXPRESSION_SOURCE_LINE = "(?:\\(\\))?(?:\\((?:%s)?(?::?%l)?(?::\\d+)?\\))?\\s*(?:~\\[.*\\])?";
    private static final String REGULAR_EXPRESSION_OPTIONAL_SOURCE_LINE_INFO = "(?:\\+\\s+[0-9]+)?";
    private static final String REGULAR_EXPRESSION_AT = ".*?\\bat\\s+%c\\.%m\\s*(?:\\+\\s+[0-9]+)?(?:\\(\\))?(?:\\((?:%s)?(?::?%l)?(?::\\d+)?\\))?\\s*(?:~\\[.*\\])?";
    private static final String REGULAR_EXPRESSION_CAST1 = ".*?\\bjava\\.lang\\.ClassCastException: %c cannot be cast to .{5,}";
    private static final String REGULAR_EXPRESSION_CAST2 = ".*?\\bjava\\.lang\\.ClassCastException: .* cannot be cast to %c";
    private static final String REGULAR_EXPRESSION_NULL_FIELD_READ = ".*?\\bjava\\.lang\\.NullPointerException: Attempt to read from field '%t %c\\.%f' on a null object reference";
    private static final String REGULAR_EXPRESSION_NULL_FIELD_WRITE = ".*?\\bjava\\.lang\\.NullPointerException: Attempt to write to field '%t %c\\.%f' on a null object reference";
    private static final String REGULAR_EXPRESSION_NULL_METHOD = ".*?\\bjava\\.lang\\.NullPointerException: Attempt to invoke (?:virtual|interface) method '%t %c\\.%m\\(%a\\)' on a null object reference";
    private static final String REGULAR_EXPRESSION_THROW = "(?:.*?[:\"]\\s+)?%c(?::.*)?";
    public static final String REGULAR_EXPRESSION = "(?:.*?\\bat\\s+%c\\.%m\\s*(?:\\+\\s+[0-9]+)?(?:\\(\\))?(?:\\((?:%s)?(?::?%l)?(?::\\d+)?\\))?\\s*(?:~\\[.*\\])?)|(?:.*?\\bjava\\.lang\\.ClassCastException: %c cannot be cast to .{5,})|(?:.*?\\bjava\\.lang\\.ClassCastException: .* cannot be cast to %c)|(?:.*?\\bjava\\.lang\\.NullPointerException: Attempt to read from field '%t %c\\.%f' on a null object reference)|(?:.*?\\bjava\\.lang\\.NullPointerException: Attempt to write to field '%t %c\\.%f' on a null object reference)|(?:.*?\\bjava\\.lang\\.NullPointerException: Attempt to invoke (?:virtual|interface) method '%t %c\\.%m\\(%a\\)' on a null object reference)|(?:(?:.*?[:\"]\\s+)?%c(?::.*)?)";
    private final String regularExpression;
    private final boolean allClassNames;
    private final boolean verbose;
    private final File mappingFile;

    public ReTrace(File mappingFile) {
        this(REGULAR_EXPRESSION, false, false, mappingFile);
    }

    public ReTrace(String regularExpression, boolean allClassNames, boolean verbose, File mappingFile) {
        this.regularExpression = regularExpression;
        this.allClassNames = allClassNames;
        this.verbose = verbose;
        this.mappingFile = mappingFile;
    }

    public void retrace(LineNumberReader stackTraceReader, PrintWriter stackTraceWriter) throws IOException {
        String obfuscatedLine;
        FramePattern pattern = new FramePattern(this.regularExpression, this.verbose);
        FrameRemapper mapper = new FrameRemapper();
        MappingReader mappingReader = new MappingReader(this.mappingFile);
        mappingReader.pump(mapper);
        while ((obfuscatedLine = stackTraceReader.readLine()) != null) {
            FrameInfo obfuscatedFrame = pattern.parse(obfuscatedLine);
            if (obfuscatedFrame != null) {
                Iterator<FrameInfo> retracedFrames = mapper.transform(obfuscatedFrame).iterator();
                String previousLine = null;
                while (retracedFrames.hasNext()) {
                    String trimmedLine;
                    FrameInfo retracedFrame = retracedFrames.next();
                    String retracedLine = pattern.format(obfuscatedLine, retracedFrame);
                    String string = trimmedLine = previousLine != null && obfuscatedFrame.getLineNumber() == 0 ? this.trim(retracedLine, previousLine) : retracedLine;
                    if (trimmedLine != null) {
                        if (this.allClassNames) {
                            trimmedLine = this.deobfuscateTokens(trimmedLine, mapper);
                        }
                        stackTraceWriter.println(trimmedLine);
                    }
                    previousLine = retracedLine;
                }
                continue;
            }
            if (this.allClassNames) {
                obfuscatedLine = this.deobfuscateTokens(obfuscatedLine, mapper);
            }
            stackTraceWriter.println(obfuscatedLine);
        }
        stackTraceWriter.flush();
    }

    private String deobfuscateTokens(String line, FrameRemapper mapper) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(line, "[]{}()/\\:;, '\"<>", true);
        while (st.hasMoreTokens()) {
            sb.append(mapper.originalClassName(st.nextToken()));
        }
        return sb.toString();
    }

    private String trim(String string1, String string2) {
        StringBuilder line = new StringBuilder(string1);
        int trimEnd = this.firstNonCommonIndex(string1, string2);
        if (trimEnd == string1.length()) {
            return null;
        }
        trimEnd = this.lastNonIdentifierIndex(string1, trimEnd) + 1;
        for (int index = 0; index < trimEnd; ++index) {
            if (Character.isWhitespace(string1.charAt(index))) continue;
            line.setCharAt(index, ' ');
        }
        return line.toString();
    }

    private int firstNonCommonIndex(String string1, String string2) {
        int index;
        for (index = 0; index < string1.length() && index < string2.length() && string1.charAt(index) == string2.charAt(index); ++index) {
        }
        return index;
    }

    private int lastNonIdentifierIndex(String line, int index) {
        while (index >= 0 && Character.isJavaIdentifierPart(line.charAt(index))) {
            --index;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) {
        int argumentIndex;
        if (args2.length < 1) {
            System.err.println(USAGE);
            System.err.println();
            System.err.println("Default regex: (?:.*?\\bat\\s+%c\\.%m\\s*(?:\\+\\s+[0-9]+)?(?:\\(\\))?(?:\\((?:%s)?(?::?%l)?(?::\\d+)?\\))?\\s*(?:~\\[.*\\])?)|(?:.*?\\bjava\\.lang\\.ClassCastException: %c cannot be cast to .{5,})|(?:.*?\\bjava\\.lang\\.ClassCastException: .* cannot be cast to %c)|(?:.*?\\bjava\\.lang\\.NullPointerException: Attempt to read from field '%t %c\\.%f' on a null object reference)|(?:.*?\\bjava\\.lang\\.NullPointerException: Attempt to write to field '%t %c\\.%f' on a null object reference)|(?:.*?\\bjava\\.lang\\.NullPointerException: Attempt to invoke (?:virtual|interface) method '%t %c\\.%m\\(%a\\)' on a null object reference)|(?:(?:.*?[:\"]\\s+)?%c(?::.*)?)");
            System.exit(-1);
        }
        String regularExpresssion = REGULAR_EXPRESSION;
        boolean verbose = false;
        boolean allClassNames = false;
        for (argumentIndex = 0; argumentIndex < args2.length; ++argumentIndex) {
            String arg = args2[argumentIndex];
            if (arg.equals(REGEX_OPTION)) {
                regularExpresssion = args2[++argumentIndex];
                continue;
            }
            if (arg.equals(ALL_CLASS_NAMES_OPTION)) {
                allClassNames = true;
                continue;
            }
            if (!arg.equals(VERBOSE_OPTION)) break;
            verbose = true;
        }
        if (argumentIndex >= args2.length) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        File mappingFile = new File(args2[argumentIndex++]);
        File stackTraceFile = argumentIndex < args2.length ? new File(args2[argumentIndex]) : null;
        try {
            LineNumberReader reader = new LineNumberReader(new BufferedReader(new InputStreamReader(stackTraceFile == null ? System.in : new FileInputStream(stackTraceFile), "UTF-8")));
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
            try {
                new ReTrace(regularExpresssion, allClassNames, verbose, mappingFile).retrace(reader, writer);
            }
            finally {
                if (stackTraceFile != null) {
                    reader.close();
                }
            }
        }
        catch (IOException ex) {
            if (verbose) {
                ex.printStackTrace();
            } else {
                System.err.println("Error: " + ex.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

