/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io.kotlin;

import java.util.HashSet;
import java.util.Set;
import kotlinx.metadata.Flag;
import kotlinx.metadata.FlagsKt;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmConstructorVisitor;
import kotlinx.metadata.KmContractVisitor;
import kotlinx.metadata.KmDeclarationContainerVisitor;
import kotlinx.metadata.KmEffectExpressionVisitor;
import kotlinx.metadata.KmEffectVisitor;
import kotlinx.metadata.KmFunctionVisitor;
import kotlinx.metadata.KmPropertyVisitor;
import kotlinx.metadata.KmTypeAliasVisitor;
import kotlinx.metadata.KmTypeParameterVisitor;
import kotlinx.metadata.KmTypeVisitor;
import kotlinx.metadata.KmValueParameterVisitor;
import kotlinx.metadata.KmVersionRequirementVisitor;
import kotlinx.metadata.jvm.JvmClassExtensionVisitor;
import kotlinx.metadata.jvm.JvmConstructorExtensionVisitor;
import kotlinx.metadata.jvm.JvmDeclarationContainerExtensionVisitor;
import kotlinx.metadata.jvm.JvmFlag;
import kotlinx.metadata.jvm.JvmFunctionExtensionVisitor;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.JvmPackageExtensionVisitor;
import kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import kotlinx.metadata.jvm.JvmTypeExtensionVisitor;
import kotlinx.metadata.jvm.JvmTypeParameterExtensionVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AllElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.kotlin.JvmFieldSignature;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataAnnotation;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.flags.KotlinClassFlags;
import proguard.classfile.kotlin.flags.KotlinCommonFlags;
import proguard.classfile.kotlin.flags.KotlinConstructorFlags;
import proguard.classfile.kotlin.flags.KotlinEffectExpressionFlags;
import proguard.classfile.kotlin.flags.KotlinFunctionFlags;
import proguard.classfile.kotlin.flags.KotlinModalityFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyAccessorFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyFlags;
import proguard.classfile.kotlin.flags.KotlinTypeAliasFlags;
import proguard.classfile.kotlin.flags.KotlinTypeFlags;
import proguard.classfile.kotlin.flags.KotlinTypeParameterFlags;
import proguard.classfile.kotlin.flags.KotlinValueParameterFlags;
import proguard.classfile.kotlin.flags.KotlinVisibilityFlags;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinContractVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectExprVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinVersionRequirementVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.util.kotlin.KotlinMetadataInitializer;
import proguard.classfile.visitor.ClassVisitor;

public class KotlinMetadataWriter
implements KotlinMetadataVisitor,
ElementValueVisitor {
    private final ClassVisitor extraClassVisitor;
    private int k;
    private int[] mv;
    private int[] bv;
    private String[] d1;
    private String[] d2;
    private int xi;
    private String xs;
    private String pn;
    private ConstantPoolEditor constantPoolEditor;
    private static ConstantPoolShrinker constantPoolShrinker = new ConstantPoolShrinker();
    private KotlinMetadataInitializer.MetadataType currentType;
    private final WarningPrinter warningPrinter;
    private boolean hasVisitedAny = false;

    public KotlinMetadataWriter(WarningPrinter warningPrinter) {
        this(warningPrinter, null);
    }

    public KotlinMetadataWriter(WarningPrinter warningPrinter, ClassVisitor extraClassVisitor) {
        this.extraClassVisitor = extraClassVisitor;
        this.warningPrinter = warningPrinter;
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        switch (kotlinMetadata.k) {
            case 1: {
                kotlinMetadata.accept(clazz, new KotlinClassConstructor());
                break;
            }
            case 2: {
                kotlinMetadata.accept(clazz, new KotlinFileFacadeConstructor());
                break;
            }
            case 3: {
                kotlinMetadata.accept(clazz, new KotlinSyntheticClassConstructor());
                break;
            }
            case 4: {
                kotlinMetadata.accept(clazz, new KotlinMultiFileFacadeConstructor());
                break;
            }
            case 5: {
                kotlinMetadata.accept(clazz, new KotlinMultiFilePartConstructor());
            }
        }
        KotlinClassMetadata md = KotlinClassMetadata.read(new KotlinClassHeader(this.k, this.mv, this.bv, this.d1, this.d2, this.xs, this.pn, this.xi));
        if (md == null) {
            this.warningPrinter.print(clazz.getName(), "Encountered corrupt Kotlin metadata in class " + clazz.getName() + ". Not processing the metadata for this class.");
            return;
        }
        this.constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
        this.hasVisitedAny = false;
        try {
            clazz.accept(new AllAttributeVisitor(new AttributeNameFilter("RuntimeVisibleAnnotations", (AttributeVisitor)new AllAnnotationVisitor(new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)new AllElementValueVisitor(this))))));
        }
        catch (IllegalArgumentException e) {
            this.warningPrinter.print(clazz.getName(), "Invalid Kotlin metadata annotation for " + clazz.getName() + " (invalid Kotlin metadata field names). Not writing the metadata for this class.");
        }
        clazz.accept(constantPoolShrinker);
        if (this.extraClassVisitor != null) {
            clazz.accept(this.extraClassVisitor);
        }
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.hasVisitedAny = true;
        this.currentType = KotlinMetadataInitializer.MetadataType.valueOf(constantElementValue.getMethodName(clazz));
        switch (this.currentType) {
            case k: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addIntegerConstant(this.k);
                break;
            }
            case xi: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addIntegerConstant(this.xi);
                break;
            }
            case xs: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addUtf8Constant(this.xs);
                break;
            }
            case pn: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addUtf8Constant(this.pn);
            }
        }
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.hasVisitedAny = true;
        this.currentType = KotlinMetadataInitializer.MetadataType.valueOf(arrayElementValue.getMethodName(clazz));
        switch (this.currentType) {
            case mv: {
                arrayElementValue.u2elementValuesCount = this.mv.length;
                ElementValue[] newMvElementValues = new ElementValue[this.mv.length];
                for (int k = 0; k < this.mv.length; ++k) {
                    newMvElementValues[k] = new ConstantElementValue('I', 0, this.constantPoolEditor.addIntegerConstant(this.mv[k]));
                }
                arrayElementValue.elementValues = newMvElementValues;
                break;
            }
            case bv: {
                arrayElementValue.u2elementValuesCount = this.bv.length;
                ElementValue[] newBvElementValues = new ElementValue[this.bv.length];
                for (int k = 0; k < this.bv.length; ++k) {
                    newBvElementValues[k] = new ConstantElementValue('I', 0, this.constantPoolEditor.addIntegerConstant(this.bv[k]));
                }
                arrayElementValue.elementValues = newBvElementValues;
                break;
            }
            case d1: {
                arrayElementValue.u2elementValuesCount = this.d1.length;
                ElementValue[] newD1ElementValues = new ElementValue[this.d1.length];
                for (int k = 0; k < this.d1.length; ++k) {
                    newD1ElementValues[k] = new ConstantElementValue('s', 0, this.constantPoolEditor.addUtf8Constant(this.d1[k]));
                }
                arrayElementValue.elementValues = newD1ElementValues;
                break;
            }
            case d2: {
                arrayElementValue.u2elementValuesCount = this.d2.length;
                ElementValue[] newD2ElementValues = new ElementValue[this.d2.length];
                for (int k = 0; k < this.d2.length; ++k) {
                    newD2ElementValues[k] = new ConstantElementValue('s', 0, this.constantPoolEditor.addUtf8Constant(this.d2[k]));
                }
                arrayElementValue.elementValues = newD2ElementValues;
            }
        }
    }

    private static JvmMethodSignature toKotlinJvmMethodSignature(proguard.classfile.kotlin.JvmMethodSignature jvmMethodSignature) {
        if (jvmMethodSignature == null) {
            return null;
        }
        return new JvmMethodSignature(jvmMethodSignature.getName(), jvmMethodSignature.getDesc());
    }

    private static kotlinx.metadata.jvm.JvmFieldSignature toKotlinJvmFieldSignature(JvmFieldSignature jvmFieldSignature) {
        if (jvmFieldSignature == null) {
            return null;
        }
        return new kotlinx.metadata.jvm.JvmFieldSignature(jvmFieldSignature.getName(), jvmFieldSignature.getDesc());
    }

    private Set<Flag> convertCommonFlags(KotlinCommonFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.hasAnnotations) {
            flagSet.add(Flag.HAS_ANNOTATIONS);
        }
        return flagSet;
    }

    private Set<Flag> convertVisibilityFlags(KotlinVisibilityFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isInternal) {
            flagSet.add(Flag.IS_INTERNAL);
        }
        if (flags.isLocal) {
            flagSet.add(Flag.IS_LOCAL);
        }
        if (flags.isPrivate) {
            flagSet.add(Flag.IS_PRIVATE);
        }
        if (flags.isProtected) {
            flagSet.add(Flag.IS_PROTECTED);
        }
        if (flags.isPublic) {
            flagSet.add(Flag.IS_PUBLIC);
        }
        if (flags.isPrivateToThis) {
            flagSet.add(Flag.IS_PRIVATE_TO_THIS);
        }
        return flagSet;
    }

    private Set<Flag> convertModalityFlags(KotlinModalityFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isAbstract) {
            flagSet.add(Flag.IS_ABSTRACT);
        }
        if (flags.isFinal) {
            flagSet.add(Flag.IS_FINAL);
        }
        if (flags.isOpen) {
            flagSet.add(Flag.IS_OPEN);
        }
        if (flags.isSealed) {
            flagSet.add(Flag.IS_SEALED);
        }
        return flagSet;
    }

    private int convertFunctionFlags(KotlinFunctionFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        flagSet.addAll(this.convertVisibilityFlags(flags.visibility));
        flagSet.addAll(this.convertModalityFlags(flags.modality));
        if (flags.isDeclaration) {
            flagSet.add(Flag.Function.IS_DECLARATION);
        }
        if (flags.isFakeOverride) {
            flagSet.add(Flag.Function.IS_FAKE_OVERRIDE);
        }
        if (flags.isDelegation) {
            flagSet.add(Flag.Function.IS_DELEGATION);
        }
        if (flags.isSynthesized) {
            flagSet.add(Flag.Function.IS_SYNTHESIZED);
        }
        if (flags.isOperator) {
            flagSet.add(Flag.Function.IS_OPERATOR);
        }
        if (flags.isInfix) {
            flagSet.add(Flag.Function.IS_INFIX);
        }
        if (flags.isInline) {
            flagSet.add(Flag.Function.IS_INLINE);
        }
        if (flags.isTailrec) {
            flagSet.add(Flag.Function.IS_TAILREC);
        }
        if (flags.isExternal) {
            flagSet.add(Flag.Function.IS_EXTERNAL);
        }
        if (flags.isSuspend) {
            flagSet.add(Flag.Function.IS_SUSPEND);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private int convertTypeFlags(KotlinTypeFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        if (flags.isNullable) {
            flagSet.add(Flag.Type.IS_NULLABLE);
        }
        if (flags.isSuspend) {
            flagSet.add(Flag.Type.IS_SUSPEND);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private int convertTypeParameterFlags(KotlinTypeParameterFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        if (flags.isReified) {
            flagSet.add(Flag.TypeParameter.IS_REIFIED);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private int convertTypeAliasFlags(KotlinTypeAliasFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        flagSet.addAll(this.convertVisibilityFlags(flags.visibility));
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private int convertPropertyFlags(KotlinPropertyFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        flagSet.addAll(this.convertVisibilityFlags(flags.visibility));
        flagSet.addAll(this.convertModalityFlags(flags.modality));
        if (flags.isDeclared) {
            flagSet.add(Flag.Property.IS_DECLARATION);
        }
        if (flags.isFakeOverride) {
            flagSet.add(Flag.Property.IS_FAKE_OVERRIDE);
        }
        if (flags.isDelegation) {
            flagSet.add(Flag.Property.IS_DELEGATION);
        }
        if (flags.isSynthesized) {
            flagSet.add(Flag.Property.IS_SYNTHESIZED);
        }
        if (flags.isVar) {
            flagSet.add(Flag.Property.IS_VAR);
        }
        if (flags.hasGetter) {
            flagSet.add(Flag.Property.HAS_GETTER);
        }
        if (flags.hasSetter) {
            flagSet.add(Flag.Property.HAS_SETTER);
        }
        if (flags.isConst) {
            flagSet.add(Flag.Property.IS_CONST);
        }
        if (flags.isLateinit) {
            flagSet.add(Flag.Property.IS_LATEINIT);
        }
        if (flags.hasConstant) {
            flagSet.add(Flag.Property.HAS_CONSTANT);
        }
        if (flags.isExternal) {
            flagSet.add(Flag.Property.IS_EXTERNAL);
        }
        if (flags.isDelegated) {
            flagSet.add(Flag.Property.IS_DELEGATED);
        }
        if (flags.isExpect) {
            flagSet.add(Flag.Property.IS_EXPECT);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private int convertPropertyJvmFlags(KotlinPropertyFlags flags) {
        return flags.isMovedFromInterfaceCompanion ? FlagsKt.flagsOf(JvmFlag.Property.IS_MOVED_FROM_INTERFACE_COMPANION) : 0;
    }

    private int convertPropertyAccessorFlags(KotlinPropertyAccessorFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        flagSet.addAll(this.convertVisibilityFlags(flags.visibility));
        flagSet.addAll(this.convertModalityFlags(flags.modality));
        if (!flags.isDefault) {
            flagSet.add(Flag.PropertyAccessor.IS_NOT_DEFAULT);
        }
        if (flags.isInline) {
            flagSet.add(Flag.PropertyAccessor.IS_INLINE);
        }
        if (flags.isExternal) {
            flagSet.add(Flag.PropertyAccessor.IS_EXTERNAL);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private int convertValueParameterFlags(KotlinValueParameterFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(this.convertCommonFlags(flags.common));
        if (flags.hasDefaultValue) {
            flagSet.add(Flag.ValueParameter.DECLARES_DEFAULT_VALUE);
        }
        if (flags.isNoInline) {
            flagSet.add(Flag.ValueParameter.IS_NOINLINE);
        }
        if (flags.isCrossInline) {
            flagSet.add(Flag.ValueParameter.IS_CROSSINLINE);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private int convertEffectExpressionFlags(KotlinEffectExpressionFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isNullCheckPredicate) {
            flagSet.add(Flag.EffectExpression.IS_NULL_CHECK_PREDICATE);
        }
        if (flags.isNegated) {
            flagSet.add(Flag.EffectExpression.IS_NEGATED);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    static /* synthetic */ int[] access$1202(KotlinMetadataWriter x0, int[] x1) {
        x0.mv = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1302(KotlinMetadataWriter x0, int[] x1) {
        x0.bv = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1402(KotlinMetadataWriter x0, String[] x1) {
        x0.d1 = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1502(KotlinMetadataWriter x0, String[] x1) {
        x0.d2 = x1;
        return x1;
    }

    private class VersionRequirementConstructor
    implements KotlinVersionRequirementVisitor {
        private KmVersionRequirementVisitor versionReqVis;
        private KmConstructorVisitor constructorVis;
        private KmClassVisitor classVis;
        private KmPropertyVisitor propertyVis;
        private KmFunctionVisitor functionVis;
        private KmTypeAliasVisitor aliasVis;

        VersionRequirementConstructor(KmConstructorVisitor constructorVis) {
            this.constructorVis = constructorVis;
        }

        VersionRequirementConstructor(KmClassVisitor classVis) {
            this.classVis = classVis;
        }

        VersionRequirementConstructor(KmPropertyVisitor propertyVis) {
            this.propertyVis = propertyVis;
        }

        VersionRequirementConstructor(KmFunctionVisitor functionVis) {
            this.functionVis = functionVis;
        }

        VersionRequirementConstructor(KmTypeAliasVisitor aliasVis) {
            this.aliasVis = aliasVis;
        }

        @Override
        public void visitClassVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.classVis.visitVersionRequirement();
        }

        @Override
        public void visitConstructorVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.constructorVis.visitVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
        }

        @Override
        public void visitPropertyVersionRequirement(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.propertyVis.visitVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
        }

        @Override
        public void visitFunctionVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.functionVis.visitVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
        }

        @Override
        public void visitTypeAliasVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis = this.aliasVis.visitVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
        }

        @Override
        public void visitAnyVersionRequirement(Clazz clazz, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.versionReqVis.visit(kotlinVersionRequirementMetadata.kind, kotlinVersionRequirementMetadata.level, kotlinVersionRequirementMetadata.errorCode, kotlinVersionRequirementMetadata.message);
            this.versionReqVis.visitVersion(kotlinVersionRequirementMetadata.major, kotlinVersionRequirementMetadata.minor, kotlinVersionRequirementMetadata.patch);
            this.versionReqVis.visitEnd();
        }
    }

    private class KotlinMultiFilePartConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor {
        private final KotlinClassMetadata.MultiFileClassPart.Writer multiPartKmdWriter;

        KotlinMultiFilePartConstructor() {
            this(new KotlinClassMetadata.MultiFileClassPart.Writer());
        }

        private KotlinMultiFilePartConstructor(KotlinClassMetadata.MultiFileClassPart.Writer multiPartKmdWriter) {
            super(multiPartKmdWriter);
            this.multiPartKmdWriter = multiPartKmdWriter;
        }

        @Override
        public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
            kotlinMultiFilePartKindMetadata.propertiesAccept(clazz, this);
            kotlinMultiFilePartKindMetadata.functionsAccept(clazz, this);
            kotlinMultiFilePartKindMetadata.typeAliasesAccept(clazz, this);
            JvmPackageExtensionVisitor ext = (JvmPackageExtensionVisitor)this.multiPartKmdWriter.visitExtensions(JvmPackageExtensionVisitor.TYPE);
            this.extensionVisitor = ext;
            kotlinMultiFilePartKindMetadata.delegatedPropertiesAccept(clazz, this);
            ext.visitEnd();
            this.multiPartKmdWriter.visitEnd();
            KotlinClassHeader header = this.multiPartKmdWriter.write(kotlinMultiFilePartKindMetadata.facadeName, kotlinMultiFilePartKindMetadata.mv, kotlinMultiFilePartKindMetadata.bv, kotlinMultiFilePartKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1202(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1302(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }
    }

    private class KotlinMultiFileFacadeConstructor
    implements KotlinMetadataVisitor {
        private KotlinMultiFileFacadeConstructor() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
            KotlinClassHeader header = new KotlinClassMetadata.MultiFileClassFacade.Writer().write(kotlinMultiFileFacadeKindMetadata.partClassNames, kotlinMultiFileFacadeKindMetadata.mv, kotlinMultiFileFacadeKindMetadata.bv, kotlinMultiFileFacadeKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1202(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1302(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }
    }

    private class KotlinSyntheticClassConstructor
    implements KotlinMetadataVisitor,
    KotlinFunctionVisitor {
        private KotlinSyntheticClassKindMetadata md;
        private final KotlinClassMetadata.SyntheticClass.Writer kmdWriter = new KotlinClassMetadata.SyntheticClass.Writer();

        KotlinSyntheticClassConstructor() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
            this.md = kotlinSyntheticClassKindMetadata;
            this.md.functionsAccept(clazz, this);
            this.kmdWriter.visitEnd();
            KotlinClassHeader header = this.kmdWriter.write(kotlinSyntheticClassKindMetadata.mv, kotlinSyntheticClassKindMetadata.bv, kotlinSyntheticClassKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1202(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1302(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitSyntheticFunction(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            KmFunctionVisitor kmdFunctionVisitor = this.kmdWriter.visitFunction(KotlinMetadataWriter.this.convertFunctionFlags(kotlinFunctionMetadata.flags), kotlinFunctionMetadata.name);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinSyntheticClassKindMetadata, new ValueParameterConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeParameterConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinSyntheticClassKindMetadata, new VersionRequirementConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinSyntheticClassKindMetadata, new ContractConstructor(kmdFunctionVisitor));
            JvmFunctionExtensionVisitor ext = (JvmFunctionExtensionVisitor)kmdFunctionVisitor.visitExtensions(JvmFunctionExtensionVisitor.TYPE);
            JvmMethodSignature jvmMethodSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinFunctionMetadata.jvmSignature);
            ext.visit(jvmMethodSignature);
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                ext.visitLambdaClassOriginName(kotlinFunctionMetadata.lambdaClassOriginName);
            }
            ext.visitEnd();
            kmdFunctionVisitor.visitEnd();
        }
    }

    private class KotlinFileFacadeConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor {
        private final KotlinClassMetadata.FileFacade.Writer facadeKmdWriter;

        KotlinFileFacadeConstructor() {
            this(new KotlinClassMetadata.FileFacade.Writer());
        }

        private KotlinFileFacadeConstructor(KotlinClassMetadata.FileFacade.Writer facadeKmdWriter) {
            super(facadeKmdWriter);
            this.facadeKmdWriter = facadeKmdWriter;
        }

        @Override
        public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
            kotlinFileFacadeKindMetadata.propertiesAccept(clazz, this);
            kotlinFileFacadeKindMetadata.functionsAccept(clazz, this);
            kotlinFileFacadeKindMetadata.typeAliasesAccept(clazz, this);
            JvmPackageExtensionVisitor ext = (JvmPackageExtensionVisitor)this.kmdWriter.visitExtensions(JvmPackageExtensionVisitor.TYPE);
            this.extensionVisitor = ext;
            kotlinFileFacadeKindMetadata.delegatedPropertiesAccept(clazz, this);
            ext.visitEnd();
            this.facadeKmdWriter.visitEnd();
            KotlinClassHeader header = this.facadeKmdWriter.write(kotlinFileFacadeKindMetadata.mv, kotlinFileFacadeKindMetadata.bv, kotlinFileFacadeKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1202(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1302(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }
    }

    private class TypeParameterConstructor
    implements KotlinTypeParameterVisitor {
        private KmTypeParameterVisitor typeParamVis;
        private KmClassVisitor classVis;
        private KmPropertyVisitor propertyVis;
        private KmFunctionVisitor functionVis;
        private KmTypeAliasVisitor aliasVis;

        TypeParameterConstructor(KmClassVisitor classVis) {
            this.classVis = classVis;
        }

        TypeParameterConstructor(KmPropertyVisitor propertyVis) {
            this.propertyVis = propertyVis;
        }

        TypeParameterConstructor(KmFunctionVisitor functionVis) {
            this.functionVis = functionVis;
        }

        TypeParameterConstructor(KmTypeAliasVisitor aliasVis) {
            this.aliasVis = aliasVis;
        }

        @Override
        public void visitClassTypeParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.typeParamVis = this.classVis.visitTypeParameter(KotlinMetadataWriter.this.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, kotlinTypeParameterMetadata.variance);
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
        }

        @Override
        public void visitPropertyTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.typeParamVis = this.propertyVis.visitTypeParameter(KotlinMetadataWriter.this.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, kotlinTypeParameterMetadata.variance);
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
        }

        @Override
        public void visitFunctionTypeParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.typeParamVis = this.functionVis.visitTypeParameter(KotlinMetadataWriter.this.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, kotlinTypeParameterMetadata.variance);
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
        }

        @Override
        public void visitAliasTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.typeParamVis = this.aliasVis.visitTypeParameter(KotlinMetadataWriter.this.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, kotlinTypeParameterMetadata.variance);
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
        }

        @Override
        public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            kotlinTypeParameterMetadata.upperBoundsAccept(clazz, new TypeConstructor(this.typeParamVis));
            JvmTypeParameterExtensionVisitor typeParamExtVis = (JvmTypeParameterExtensionVisitor)this.typeParamVis.visitExtensions(JvmTypeParameterExtensionVisitor.TYPE);
            for (KotlinMetadataAnnotation kman : kotlinTypeParameterMetadata.annotations) {
                typeParamExtVis.visitAnnotation(kman.kmAnnotation);
            }
            typeParamExtVis.visitEnd();
            this.typeParamVis.visitEnd();
        }
    }

    private class TypeConstructor
    implements KotlinTypeVisitor {
        private KmTypeVisitor typeVis;
        private KmTypeVisitor nestedTypeVis;
        private KmValueParameterVisitor valParamVis;
        private KmClassVisitor classVis;
        private KmPropertyVisitor propertyVis;
        private KmFunctionVisitor functionVis;
        private KmTypeAliasVisitor aliasVis;
        private KmTypeParameterVisitor typeParamVis;
        private KmEffectExpressionVisitor effectExpressionVis;

        TypeConstructor(KmTypeVisitor nestedTypeVis) {
            this.nestedTypeVis = nestedTypeVis;
        }

        TypeConstructor(KmValueParameterVisitor valParamVis) {
            this.valParamVis = valParamVis;
        }

        TypeConstructor(KmClassVisitor classVis) {
            this.classVis = classVis;
        }

        TypeConstructor(KmPropertyVisitor propertyVis) {
            this.propertyVis = propertyVis;
        }

        TypeConstructor(KmFunctionVisitor functionVis) {
            this.functionVis = functionVis;
        }

        TypeConstructor(KmTypeAliasVisitor aliasVis) {
            this.aliasVis = aliasVis;
        }

        TypeConstructor(KmTypeParameterVisitor typeParamVis) {
            this.typeParamVis = typeParamVis;
        }

        TypeConstructor(KmEffectExpressionVisitor effectExpressionVis) {
            this.effectExpressionVis = effectExpressionVis;
        }

        @Override
        public void visitTypeUpperBound(Clazz clazz, KotlinTypeMetadata boundedType, KotlinTypeMetadata upperBound) {
            this.typeVis = this.nestedTypeVis.visitFlexibleTypeUpperBound(KotlinMetadataWriter.this.convertTypeFlags(boundedType.flags), upperBound.flexibilityID);
            this.visitAnyType(clazz, upperBound);
        }

        @Override
        public void visitAbbreviation(Clazz clazz, KotlinTypeMetadata abbreviatedType, KotlinTypeMetadata abbreviation) {
            this.typeVis = this.nestedTypeVis.visitAbbreviatedType(KotlinMetadataWriter.this.convertTypeFlags(abbreviatedType.flags));
            this.visitAnyType(clazz, abbreviation);
        }

        @Override
        public void visitParameterUpperBound(Clazz clazz, KotlinTypeParameterMetadata boundedTypeParameter, KotlinTypeMetadata upperBound) {
            this.typeVis = this.typeParamVis.visitUpperBound(KotlinMetadataWriter.this.convertTypeFlags(upperBound.flags));
            this.visitAnyType(clazz, upperBound);
        }

        @Override
        public void visitTypeOfIsExpression(Clazz clazz, KotlinEffectExpressionMetadata kotlinEffectExprMetadata, KotlinTypeMetadata typeOfIs) {
            this.typeVis = this.effectExpressionVis.visitIsInstanceType(KotlinMetadataWriter.this.convertTypeFlags(typeOfIs.flags));
            this.visitAnyType(clazz, typeOfIs);
        }

        @Override
        public void visitTypeArgument(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata, KotlinTypeMetadata typeArgument) {
            this.typeVis = this.nestedTypeVis.visitArgument(KotlinMetadataWriter.this.convertTypeFlags(typeArgument.flags), typeArgument.variance);
            this.visitAnyType(clazz, typeArgument);
        }

        @Override
        public void visitStarProjection(Clazz clazz, KotlinTypeMetadata typeWithStarArg) {
            this.nestedTypeVis.visitStarProjection();
        }

        @Override
        public void visitOuterClass(Clazz clazz, KotlinTypeMetadata innerClass, KotlinTypeMetadata outerClass) {
            this.typeVis = this.nestedTypeVis.visitOuterType(KotlinMetadataWriter.this.convertTypeFlags(outerClass.flags));
            this.visitAnyType(clazz, outerClass);
        }

        @Override
        public void visitConstructorValParamType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitConstructorValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitSuperType(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.classVis.visitSupertype(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitPropertyType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.propertyVis.visitReturnType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitPropertyReceiverType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.propertyVis.visitReceiverParameterType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitPropertyValParamType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitPropertyValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitVarargElementType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitFunctionReturnType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.functionVis.visitReturnType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitFunctionReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.functionVis.visitReceiverParameterType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitFunctionValParamType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitFunctionValParamVarArgType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.valParamVis.visitVarargElementType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitAliasUnderlyingType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.aliasVis.visitUnderlyingType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitAliasExpandedType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.typeVis = this.aliasVis.visitExpandedType(KotlinMetadataWriter.this.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
            if (kotlinTypeMetadata.className != null) {
                String className = kotlinTypeMetadata.className.replace('$', '.');
                this.typeVis.visitClass(className);
            }
            if (kotlinTypeMetadata.typeParamID >= 0) {
                this.typeVis.visitTypeParameter(kotlinTypeMetadata.typeParamID);
            }
            if (kotlinTypeMetadata.aliasName != null) {
                this.typeVis.visitTypeAlias(kotlinTypeMetadata.aliasName);
            }
            kotlinTypeMetadata.abbreviationAccept(clazz, new TypeConstructor(this.typeVis));
            kotlinTypeMetadata.outerClassAccept(clazz, new TypeConstructor(this.typeVis));
            kotlinTypeMetadata.typeArgumentsAccept(clazz, new TypeConstructor(this.typeVis));
            kotlinTypeMetadata.upperBoundsAccept(clazz, new TypeConstructor(this.typeVis));
            JvmTypeExtensionVisitor typeExtVis = (JvmTypeExtensionVisitor)this.typeVis.visitExtensions(JvmTypeExtensionVisitor.TYPE);
            typeExtVis.visit(kotlinTypeMetadata.isRaw);
            for (KotlinMetadataAnnotation kman : kotlinTypeMetadata.annotations) {
                typeExtVis.visitAnnotation(kman.kmAnnotation);
            }
            typeExtVis.visitEnd();
            this.typeVis.visitEnd();
        }
    }

    private class ValueParameterConstructor
    implements KotlinValueParameterVisitor {
        private KmValueParameterVisitor valParamVis;
        private KmConstructorVisitor constructorVis;
        private KmPropertyVisitor propertyVis;
        private KmFunctionVisitor functionVis;

        ValueParameterConstructor(KmConstructorVisitor constructorVis) {
            this.constructorVis = constructorVis;
        }

        ValueParameterConstructor(KmPropertyVisitor propertyVis) {
            this.propertyVis = propertyVis;
        }

        ValueParameterConstructor(KmFunctionVisitor functionVis) {
            this.functionVis = functionVis;
        }

        @Override
        public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        }

        @Override
        public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.valParamVis = this.constructorVis.visitValueParameter(KotlinMetadataWriter.this.convertValueParameterFlags(kotlinValueParameterMetadata.flags), kotlinValueParameterMetadata.parameterName);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)new TypeConstructor(this.valParamVis));
            this.valParamVis.visitEnd();
        }

        @Override
        public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.valParamVis = this.propertyVis.visitSetterParameter(KotlinMetadataWriter.this.convertValueParameterFlags(kotlinValueParameterMetadata.flags), kotlinValueParameterMetadata.parameterName);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)new TypeConstructor(this.valParamVis));
            this.valParamVis.visitEnd();
        }

        @Override
        public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.valParamVis = this.functionVis.visitValueParameter(KotlinMetadataWriter.this.convertValueParameterFlags(kotlinValueParameterMetadata.flags), kotlinValueParameterMetadata.parameterName);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)new TypeConstructor(this.valParamVis));
            this.valParamVis.visitEnd();
        }
    }

    private class KotlinClassConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor,
    KotlinConstructorVisitor {
        KotlinClassMetadata.Class.Writer classKmdWriter;

        KotlinClassConstructor() {
            this(new KotlinClassMetadata.Class.Writer());
        }

        private KotlinClassConstructor(KotlinClassMetadata.Class.Writer classKmdWriter) {
            super(classKmdWriter);
            this.classKmdWriter = classKmdWriter;
        }

        @Override
        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            this.classKmdWriter.visit(this.convertClassFlags(kotlinClassKindMetadata.flags), kotlinClassKindMetadata.className.replace('$', '.'));
            if (kotlinClassKindMetadata.companionObjectName != null) {
                this.classKmdWriter.visitCompanionObject(kotlinClassKindMetadata.companionObjectName);
            }
            kotlinClassKindMetadata.propertiesAccept(clazz, this);
            kotlinClassKindMetadata.functionsAccept(clazz, this);
            kotlinClassKindMetadata.typeAliasesAccept(clazz, this);
            for (String enumEntry : kotlinClassKindMetadata.enumEntryNames) {
                this.classKmdWriter.visitEnumEntry(enumEntry);
            }
            for (String nestedClass : kotlinClassKindMetadata.nestedClassNames) {
                this.classKmdWriter.visitNestedClass(nestedClass);
            }
            for (String sealedSubClass : kotlinClassKindMetadata.sealedSubclassNames) {
                this.classKmdWriter.visitSealedSubclass(sealedSubClass.replace('$', '.'));
            }
            kotlinClassKindMetadata.constructorsAccept(clazz, this);
            kotlinClassKindMetadata.superTypesAccept(clazz, new TypeConstructor(this.classKmdWriter));
            kotlinClassKindMetadata.typeParametersAccept(clazz, new TypeParameterConstructor(this.classKmdWriter));
            kotlinClassKindMetadata.versionRequirementAccept(clazz, new VersionRequirementConstructor(this.classKmdWriter));
            JvmClassExtensionVisitor ext = (JvmClassExtensionVisitor)this.classKmdWriter.visitExtensions(JvmClassExtensionVisitor.TYPE);
            this.extensionVisitor = ext;
            kotlinClassKindMetadata.delegatedPropertiesAccept(clazz, this);
            if (kotlinClassKindMetadata.anonymousObjectOriginName != null) {
                ext.visitAnonymousObjectOriginName(kotlinClassKindMetadata.anonymousObjectOriginName);
            }
            ext.visitEnd();
            this.classKmdWriter.visitEnd();
            KotlinClassHeader header = this.classKmdWriter.write(kotlinClassKindMetadata.mv, kotlinClassKindMetadata.bv, kotlinClassKindMetadata.xi).getHeader();
            KotlinMetadataWriter.this.k = header.getKind();
            KotlinMetadataWriter.access$1202(KotlinMetadataWriter.this, header.getMetadataVersion());
            KotlinMetadataWriter.access$1302(KotlinMetadataWriter.this, header.getBytecodeVersion());
            KotlinMetadataWriter.access$1402(KotlinMetadataWriter.this, header.getData1());
            KotlinMetadataWriter.access$1502(KotlinMetadataWriter.this, header.getData2());
            KotlinMetadataWriter.this.xi = header.getExtraInt();
            KotlinMetadataWriter.this.xs = header.getExtraString();
            KotlinMetadataWriter.this.pn = header.getPackageName();
        }

        @Override
        public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
            KmConstructorVisitor constructorVis = this.classKmdWriter.visitConstructor(this.convertConstructorFlags(kotlinConstructorMetadata.flags));
            kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, new ValueParameterConstructor(constructorVis));
            kotlinConstructorMetadata.versionRequirementAccept(clazz, kotlinClassKindMetadata, new VersionRequirementConstructor(constructorVis));
            if (kotlinConstructorMetadata.jvmSignature != null) {
                JvmConstructorExtensionVisitor constExtVis = (JvmConstructorExtensionVisitor)constructorVis.visitExtensions(JvmConstructorExtensionVisitor.TYPE);
                JvmMethodSignature jvmMethodSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinConstructorMetadata.jvmSignature);
                constExtVis.visit(jvmMethodSignature);
            }
            constructorVis.visitEnd();
        }

        private int convertClassFlags(KotlinClassFlags flags) {
            HashSet<Flag> flagSet = new HashSet<Flag>();
            flagSet.addAll(KotlinMetadataWriter.this.convertCommonFlags(flags.common));
            flagSet.addAll(KotlinMetadataWriter.this.convertVisibilityFlags(flags.visibility));
            flagSet.addAll(KotlinMetadataWriter.this.convertModalityFlags(flags.modality));
            if (flags.isUsualClass) {
                flagSet.add(Flag.Class.IS_CLASS);
            }
            if (flags.isInterface) {
                flagSet.add(Flag.Class.IS_INTERFACE);
            }
            if (flags.isEnumClass) {
                flagSet.add(Flag.Class.IS_ENUM_CLASS);
            }
            if (flags.isEnumEntry) {
                flagSet.add(Flag.Class.IS_ENUM_ENTRY);
            }
            if (flags.isAnnotationClass) {
                flagSet.add(Flag.Class.IS_ANNOTATION_CLASS);
            }
            if (flags.isObject) {
                flagSet.add(Flag.Class.IS_OBJECT);
            }
            if (flags.isCompanionObject) {
                flagSet.add(Flag.Class.IS_COMPANION_OBJECT);
            }
            if (flags.isInner) {
                flagSet.add(Flag.Class.IS_INNER);
            }
            if (flags.isData) {
                flagSet.add(Flag.Class.IS_DATA);
            }
            if (flags.isExternal) {
                flagSet.add(Flag.Class.IS_EXTERNAL);
            }
            if (flags.isExpect) {
                flagSet.add(Flag.Class.IS_EXPECT);
            }
            if (flags.isInline) {
                flagSet.add(Flag.Class.IS_INLINE);
            }
            return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
        }

        private int convertConstructorFlags(KotlinConstructorFlags flags) {
            HashSet<Flag> flagSet = new HashSet<Flag>();
            flagSet.addAll(KotlinMetadataWriter.this.convertCommonFlags(flags.common));
            flagSet.addAll(KotlinMetadataWriter.this.convertVisibilityFlags(flags.visibility));
            if (flags.isPrimary) {
                flagSet.add(Flag.Constructor.IS_PRIMARY);
            }
            return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
        }
    }

    private class KotlinDeclarationContainerConstructor
    implements KotlinPropertyVisitor,
    KotlinFunctionVisitor,
    KotlinTypeAliasVisitor {
        KmDeclarationContainerVisitor kmdWriter;
        KmPropertyVisitor kmdPropertyVisitor;
        JvmDeclarationContainerExtensionVisitor extensionVisitor;

        KotlinDeclarationContainerConstructor(KmDeclarationContainerVisitor classKmdWriter) {
            this.kmdWriter = classKmdWriter;
        }

        @Override
        public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmdPropertyVisitor));
            kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmdPropertyVisitor));
            kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, new ValueParameterConstructor(this.kmdPropertyVisitor));
            kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(this.kmdPropertyVisitor));
            kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(this.kmdPropertyVisitor));
            JvmPropertyExtensionVisitor ext = (JvmPropertyExtensionVisitor)this.kmdPropertyVisitor.visitExtensions(JvmPropertyExtensionVisitor.TYPE);
            JvmMethodSignature getterSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.getterSignature);
            JvmMethodSignature setterSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.setterSignature);
            kotlinx.metadata.jvm.JvmFieldSignature backingFieldSignature = KotlinMetadataWriter.toKotlinJvmFieldSignature(kotlinPropertyMetadata.backingFieldSignature);
            ext.visit(KotlinMetadataWriter.this.convertPropertyJvmFlags(kotlinPropertyMetadata.flags), backingFieldSignature, getterSignature, setterSignature);
            if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
                ext.visitSyntheticMethodForAnnotations(KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.syntheticMethodForAnnotations));
            }
            ext.visitEnd();
            this.kmdPropertyVisitor.visitEnd();
        }

        @Override
        public void visitProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kmdPropertyVisitor = this.kmdWriter.visitProperty(KotlinMetadataWriter.this.convertPropertyFlags(kotlinPropertyMetadata.flags), kotlinPropertyMetadata.name, KotlinMetadataWriter.this.convertPropertyAccessorFlags(kotlinPropertyMetadata.getterFlags), KotlinMetadataWriter.this.convertPropertyAccessorFlags(kotlinPropertyMetadata.setterFlags));
            this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
        }

        @Override
        public void visitDelegatedProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kmdPropertyVisitor = this.extensionVisitor.visitLocalDelegatedProperty(KotlinMetadataWriter.this.convertPropertyFlags(kotlinPropertyMetadata.flags), kotlinPropertyMetadata.name, KotlinMetadataWriter.this.convertPropertyAccessorFlags(kotlinPropertyMetadata.getterFlags), KotlinMetadataWriter.this.convertPropertyAccessorFlags(kotlinPropertyMetadata.setterFlags));
            this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            KmFunctionVisitor kmdFunctionVisitor = this.kmdWriter.visitFunction(KotlinMetadataWriter.this.convertFunctionFlags(kotlinFunctionMetadata.flags), kotlinFunctionMetadata.name);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinDeclarationContainerMetadata, new ValueParameterConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(kmdFunctionVisitor));
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinDeclarationContainerMetadata, new ContractConstructor(kmdFunctionVisitor));
            JvmFunctionExtensionVisitor ext = (JvmFunctionExtensionVisitor)kmdFunctionVisitor.visitExtensions(JvmFunctionExtensionVisitor.TYPE);
            JvmMethodSignature jvmMethodSignature = KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinFunctionMetadata.jvmSignature);
            ext.visit(jvmMethodSignature);
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                ext.visitLambdaClassOriginName(kotlinFunctionMetadata.lambdaClassOriginName);
            }
            ext.visitEnd();
            kmdFunctionVisitor.visitEnd();
        }

        @Override
        public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            KmTypeAliasVisitor kmdAliasVisitor = this.kmdWriter.visitTypeAlias(KotlinMetadataWriter.this.convertTypeAliasFlags(kotlinTypeAliasMetadata.flags), kotlinTypeAliasMetadata.name);
            kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(kmdAliasVisitor));
            kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmdAliasVisitor));
            kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmdAliasVisitor));
            kotlinTypeAliasMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(kmdAliasVisitor));
            for (KotlinMetadataAnnotation antn : kotlinTypeAliasMetadata.annotations) {
                kmdAliasVisitor.visitAnnotation(antn.kmAnnotation);
            }
            kmdAliasVisitor.visitEnd();
        }

        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }
    }

    private class EffectExprConstructor
    implements KotlinEffectExprVisitor {
        private KmEffectExpressionVisitor effectExprVis;
        private KmEffectVisitor effectVis;
        private KmEffectExpressionVisitor nestedExprVis;

        private EffectExprConstructor(KmEffectVisitor effectVis) {
            this.effectVis = effectVis;
        }

        private EffectExprConstructor(KmEffectExpressionVisitor nestedExprVis) {
            this.nestedExprVis = nestedExprVis;
        }

        @Override
        public void visitAnyEffectExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.effectExprVis.visit(KotlinMetadataWriter.this.convertEffectExpressionFlags(kotlinEffectExpressionMetadata.flags), kotlinEffectExpressionMetadata.parameterIndex);
            if (kotlinEffectExpressionMetadata.hasConstantValue) {
                this.effectExprVis.visitConstantValue(kotlinEffectExpressionMetadata.constantValue);
            }
            kotlinEffectExpressionMetadata.andRightHandSideAccept(clazz, kotlinEffectMetadata, new EffectExprConstructor(this.effectExprVis));
            kotlinEffectExpressionMetadata.orRightHandSideAccept(clazz, kotlinEffectMetadata, new EffectExprConstructor(this.effectExprVis));
            kotlinEffectExpressionMetadata.typeOfIsAccept(clazz, new TypeConstructor(this.effectExprVis));
            this.effectExprVis.visitEnd();
        }

        @Override
        public void visitAndRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
            this.effectExprVis = this.nestedExprVis.visitAndArgument();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
        }

        @Override
        public void visitOrRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
            this.effectExprVis = this.nestedExprVis.visitOrArgument();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
        }

        @Override
        public void visitConstructorArgExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.effectExprVis = this.effectVis.visitConstructorArgument();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, kotlinEffectExpressionMetadata);
        }

        @Override
        public void visitConclusionExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.effectExprVis = this.effectVis.visitConclusionOfConditionalEffect();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, kotlinEffectExpressionMetadata);
        }
    }

    private class EffectConstructor
    implements KotlinEffectVisitor {
        private final KmContractVisitor kmContractVisitor;

        private EffectConstructor(KmContractVisitor kmContractVisitor) {
            this.kmContractVisitor = kmContractVisitor;
        }

        @Override
        public void visitEffect(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata, KotlinEffectMetadata kotlinEffectMetadata) {
            KmEffectVisitor kmEffectVisitor = this.kmContractVisitor.visitEffect(kotlinEffectMetadata.effectType, kotlinEffectMetadata.invocationKind);
            kotlinEffectMetadata.conclusionOfConditionalEffectAccept(clazz, new EffectExprConstructor(kmEffectVisitor));
            kotlinEffectMetadata.constructorArgumentAccept(clazz, new EffectExprConstructor(kmEffectVisitor));
            kmEffectVisitor.visitEnd();
        }
    }

    private class ContractConstructor
    implements KotlinContractVisitor {
        private KmFunctionVisitor kmdFunctionVisitor;

        ContractConstructor(KmFunctionVisitor kmdFunctionVisitor) {
            this.kmdFunctionVisitor = kmdFunctionVisitor;
        }

        @Override
        public void visitContract(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata) {
            KmContractVisitor kmContractVisitor = this.kmdFunctionVisitor.visitContract();
            kotlinContractMetadata.effectsAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, new EffectConstructor(kmContractVisitor));
            kmContractVisitor.visitEnd();
        }
    }
}

