/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.io.KotlinModuleWriter;

public class KotlinModuleDataEntryWriter
implements DataEntryWriter {
    private final ResourceFilePool resourceFilePool;
    private final DataEntryWriter dataEntryWriter;

    public KotlinModuleDataEntryWriter(ResourceFilePool resourceFilePool, DataEntryWriter dataEntryWriter) {
        this.resourceFilePool = resourceFilePool;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        KotlinModule km = (KotlinModule)this.resourceFilePool.getResourceFile(dataEntry.getName());
        if (km != null) {
            BufferedOutputStream outputStream = new BufferedOutputStream(this.dataEntryWriter.createOutputStream(dataEntry));
            km.accept(new KotlinModuleWriter(outputStream));
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "KotlinModuleDataEntryWriter");
        this.dataEntryWriter.println(pw, prefix);
    }
}

