/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.optimize.info.SideEffectClassMarker;
import proguard.optimize.info.SideEffectInstructionChecker;

public class SideEffectMethodMarker
implements MemberVisitor,
InstructionVisitor {
    private static final boolean DEBUG = System.getProperty("semm") != null;
    private final MemberVisitor extraMemberVisitor;
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(false, true);
    private final ClassVisitor sideEffectClassMarker = new OptimizationInfoClassFilter(new SideEffectClassMarker());

    public SideEffectMethodMarker() {
        this(null);
    }

    public SideEffectMethodMarker(MemberVisitor extraMemberVisitor) {
        this.extraMemberVisitor = extraMemberVisitor;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if ((programMethod.getAccessFlags() & 0x120) != 0) {
            this.markSideEffects(programClass, programMethod);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, instruction)) {
            this.markSideEffects(clazz, method);
        }
    }

    private void markSideEffects(Clazz clazz, Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.hasSideEffects() && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setSideEffects();
            if (methodOptimizationInfo.hasSideEffects()) {
                if (DEBUG) {
                    System.out.println("SideEffectMethodMarker: marking for side-effects: " + clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz));
                }
                if (this.extraMemberVisitor != null) {
                    method.accept(clazz, this.extraMemberVisitor);
                }
                if (method.getName(clazz).equals("<clinit>")) {
                    clazz.accept(this.sideEffectClassMarker);
                }
            }
        }
    }

    public static boolean hasSideEffects(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).hasSideEffects();
    }
}

