/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ClassBuilder;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.io.ExtraDataEntryNameMap;
import proguard.optimize.gson.FieldSignatureCollector;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineSerializer;
import proguard.optimize.gson.InlineSerializers;
import proguard.optimize.gson.OptimizedClassConstants;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.TypeTokenClassBuilder;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;

public class GsonSerializationOptimizer
implements MemberVisitor,
ClassVisitor,
ElementValueVisitor,
AttributeVisitor,
AnnotationVisitor {
    private static final boolean DEBUG = false;
    private static final int VALUE_VARIABLE_INDEX = ClassUtil.internalMethodParameterSize(OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY, false);
    private static final Map<String, InlineSerializer> inlineSerializers = new HashMap<String, InlineSerializer>();
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final GsonRuntimeSettings gsonRuntimeSettings;
    private final OptimizedJsonInfo serializationInfo;
    private final boolean supportExposeAnnotation;
    private final ExtraDataEntryNameMap extraDataEntryNameMap;

    public GsonSerializationOptimizer(ClassPool programClassPool, ClassPool libraryClassPool, GsonRuntimeSettings gsonRuntimeSettings, OptimizedJsonInfo serializationInfo, ExtraDataEntryNameMap extraDataEntryNameMap) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
        this.serializationInfo = serializationInfo;
        this.supportExposeAnnotation = gsonRuntimeSettings.excludeFieldsWithoutExposeAnnotation;
        this.extraDataEntryNameMap = extraDataEntryNameMap;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2accessFlags &= 0xFFFFFFFD;
        programClass.u2accessFlags |= 1;
        ClassBuilder classBuilder = new ClassBuilder(programClass);
        Integer classIndex = this.serializationInfo.classIndices.get(programClass.getName());
        String methodNameToJson = "toJson$" + classIndex;
        String methodNameToJsonBody = "toJsonBody$" + classIndex;
        classBuilder.addMethod(4097, methodNameToJson, OptimizedClassConstants.METHOD_TYPE_TO_JSON, 100, ____ -> ____.aload(2).invokevirtual("com/google/gson/stream/JsonWriter", "beginObject", "()Lcom/google/gson/stream/JsonWriter;").aload(0).aload(1).aload(2).aload(3).invokevirtual(programClass.getName(), methodNameToJsonBody, OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY).aload(2).invokevirtual("com/google/gson/stream/JsonWriter", "endObject", "()Lcom/google/gson/stream/JsonWriter;").return_(), new ProgramMemberOptimizationInfoSetter());
        this.addToJsonBodyMethod(programClass, classBuilder);
        programClass.accept(new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool));
        programClass.accept(new MethodLinker());
    }

    private void addToJsonBodyMethod(ProgramClass programClass, ClassBuilder classBuilder) {
        Integer classIndex = this.serializationInfo.classIndices.get(programClass.getName());
        String methodName = "toJsonBody$" + classIndex;
        classBuilder.addMethod(4100, methodName, OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY, 1000, ____ -> {
            programClass.fieldsAccept(new MemberAccessFilter(0, 4104, new ToJsonFieldSerializationCodeAdder(____)));
            if (programClass.getSuperClass() != null) {
                if (!programClass.getSuperClass().getName().equals("java/lang/Object")) {
                    Integer superClassIndex = this.serializationInfo.classIndices.get(programClass.getSuperClass().getName());
                    String superMethodNameToJsonBody = "toJsonBody$" + superClassIndex;
                    ____.aload(0).aload(1).aload(2).aload(3).invokevirtual(programClass.getSuperClass().getName(), superMethodNameToJsonBody, OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY);
                }
            } else {
                throw new RuntimeException("Cannot find super class of " + programClass.getName() + " for Gson optimization. Please check your configuration includes all the expected library jars.");
            }
            ____.return_();
        }, new ProgramMemberOptimizationInfoSetter());
    }

    static {
        inlineSerializers.put("Z", new InlineSerializers.InlinePrimitiveBooleanSerializer());
        inlineSerializers.put("Ljava/lang/Boolean;", new InlineSerializers.InlineBooleanSerializer());
        inlineSerializers.put("B", new InlineSerializers.InlinePrimitiveIntegerSerializer());
        inlineSerializers.put("S", new InlineSerializers.InlinePrimitiveIntegerSerializer());
        inlineSerializers.put("I", new InlineSerializers.InlinePrimitiveIntegerSerializer());
        inlineSerializers.put("Ljava/lang/String;", new InlineSerializers.InlineStringSerializer());
    }

    private class ToJsonFieldSerializationCodeAdder
    implements MemberVisitor {
        private final CompactCodeAttributeComposer ____;

        public ToJsonFieldSerializationCodeAdder(CompactCodeAttributeComposer ____) {
            this.____ = ____;
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            OptimizedJsonInfo.ClassJsonInfo classSerializationInfo = ((GsonSerializationOptimizer)GsonSerializationOptimizer.this).serializationInfo.classJsonInfos.get(programClass.getName());
            String[] jsonFieldNames = classSerializationInfo.javaToJsonFieldNames.get(programField.getName(programClass));
            String javaFieldName = programField.getName(programClass);
            if (jsonFieldNames != null) {
                String fieldDescriptor = programField.getDescriptor(programClass);
                FieldSignatureCollector signatureAttributeCollector = new FieldSignatureCollector();
                programField.attributesAccept(programClass, signatureAttributeCollector);
                boolean retrieveAdapterByTypeToken = false;
                CompactCodeAttributeComposer.Label end = this.____.createLabel();
                if (ClassUtil.isInternalClassType(fieldDescriptor)) {
                    CompactCodeAttributeComposer.Label noRecursion = this.____.createLabel();
                    this.____.aload(0).aload(0).getfield(programClass, programField).ifacmpne(noRecursion).goto_(end).label(noRecursion);
                }
                if (GsonSerializationOptimizer.this.supportExposeAnnotation && !classSerializationInfo.exposedJavaFieldNames.contains(javaFieldName)) {
                    this.____.aload(1).getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "requireExpose", "Z").ifne(end);
                }
                Integer fieldIndex = ((GsonSerializationOptimizer)GsonSerializationOptimizer.this).serializationInfo.jsonFieldIndices.get(jsonFieldNames[0]);
                this.____.aload(3).aload(2).ldc(fieldIndex).invokeinterface("proguard/optimize/gson/_OptimizedJsonWriter", "b", "(Lcom/google/gson/stream/JsonWriter;I)V");
                InlineSerializer inlineSerializer = (InlineSerializer)inlineSerializers.get(fieldDescriptor);
                if (!((GsonSerializationOptimizer)GsonSerializationOptimizer.this).gsonRuntimeSettings.registerTypeAdapterFactory && inlineSerializer != null && inlineSerializer.canSerialize(GsonSerializationOptimizer.this.programClassPool, GsonSerializationOptimizer.this.gsonRuntimeSettings)) {
                    inlineSerializer.serialize(programClass, programField, this.____, GsonSerializationOptimizer.this.gsonRuntimeSettings);
                } else {
                    this.____.aload(1);
                    switch (fieldDescriptor.charAt(0)) {
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            String className = ClassUtil.internalNumericClassNameFromPrimitiveType(fieldDescriptor.charAt(0));
                            this.____.getstatic(className, "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'L': {
                            if (signatureAttributeCollector.getFieldSignature() == null) {
                                String fieldClassName = fieldDescriptor.substring(1, fieldDescriptor.length() - 1);
                                Clazz fieldClass = GsonSerializationOptimizer.this.programClassPool.getClass(fieldClassName);
                                if (fieldClass == null) {
                                    fieldClass = GsonSerializationOptimizer.this.libraryClassPool.getClass(fieldClassName);
                                }
                                this.____.ldc(fieldClassName, fieldClass);
                                break;
                            }
                            ProgramClass typeTokenClass = new TypeTokenClassBuilder(programClass, programField, signatureAttributeCollector.getFieldSignature()).build(GsonSerializationOptimizer.this.programClassPool);
                            GsonSerializationOptimizer.this.programClassPool.addClass(typeTokenClass);
                            typeTokenClass.accept(new ClassReferenceInitializer(GsonSerializationOptimizer.this.programClassPool, GsonSerializationOptimizer.this.libraryClassPool));
                            GsonSerializationOptimizer.this.extraDataEntryNameMap.addExtraClassToClass(programClass.getName(), typeTokenClass.getName());
                            this.____.new_(typeTokenClass.getName()).dup().invokespecial(typeTokenClass.getName(), "<init>", "()V");
                            retrieveAdapterByTypeToken = true;
                            break;
                        }
                        case '[': {
                            String elementType = ClassUtil.internalTypeFromArrayType(fieldDescriptor);
                            if (ClassUtil.isInternalPrimitiveType(elementType)) {
                                String primitiveClassName = ClassUtil.internalNumericClassNameFromPrimitiveType(elementType.charAt(0));
                                Clazz fieldClass = GsonSerializationOptimizer.this.libraryClassPool.getClass(primitiveClassName);
                                this.____.ldc(fieldDescriptor, fieldClass);
                                break;
                            }
                            String className = ClassUtil.internalClassNameFromClassType(elementType);
                            Clazz fieldClass = GsonSerializationOptimizer.this.programClassPool.getClass(className);
                            if (fieldClass == null) {
                                fieldClass = GsonSerializationOptimizer.this.libraryClassPool.getClass(className);
                            }
                            this.____.ldc(fieldDescriptor, fieldClass);
                            break;
                        }
                    }
                    this.____.aload(0).getfield(programClass, programField);
                    switch (fieldDescriptor.charAt(0)) {
                        case 'Z': {
                            this.____.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                            break;
                        }
                        case 'C': {
                            this.____.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                            break;
                        }
                        case 'B': {
                            this.____.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                            break;
                        }
                        case 'S': {
                            this.____.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                            break;
                        }
                        case 'I': {
                            this.____.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                            break;
                        }
                        case 'F': {
                            this.____.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                            break;
                        }
                        case 'J': {
                            this.____.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                            break;
                        }
                        case 'D': {
                            this.____.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                        }
                    }
                    this.____.dup().astore(VALUE_VARIABLE_INDEX);
                    if (retrieveAdapterByTypeToken) {
                        this.____.invokestatic("proguard/optimize/gson/_GsonUtil", "getTypeAdapter", "(Lcom/google/gson/Gson;Lcom/google/gson/reflect/TypeToken;Ljava/lang/Object;)Lcom/google/gson/TypeAdapter;");
                    } else {
                        this.____.invokestatic("proguard/optimize/gson/_GsonUtil", "getTypeAdapter", "(Lcom/google/gson/Gson;Ljava/lang/Class;Ljava/lang/Object;)Lcom/google/gson/TypeAdapter;");
                    }
                    this.____.aload(2).aload(VALUE_VARIABLE_INDEX).invokevirtual("com/google/gson/TypeAdapter", "write", "(Lcom/google/gson/stream/JsonWriter;Ljava/lang/Object;)V");
                }
                this.____.label(end);
            }
        }
    }
}

