/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate.kotlin;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.visitor.AllKotlinPropertiesVisitor;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.util.Processable;

public class KotlinValueParameterUsageMarker
implements KotlinMetadataVisitor,
KotlinConstructorVisitor,
KotlinPropertyVisitor,
KotlinFunctionVisitor,
AttributeVisitor,
KotlinValueParameterVisitor {
    private static final Object USED = new Object();
    private boolean keepParameterInfo;

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
        kotlinDeclarationContainerMetadata.functionsAccept(clazz, this);
        kotlinDeclarationContainerMetadata.accept(clazz, new AllKotlinPropertiesVisitor(this));
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        kotlinClassKindMetadata.constructorsAccept(clazz, this);
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinClassKindMetadata);
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this);
    }

    @Override
    public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
        this.keepParameterInfo = false;
        kotlinConstructorMetadata.referencedMethodAccept(clazz, new AllAttributeVisitor(true, this));
        if (this.keepParameterInfo) {
            kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, this);
        }
    }

    @Override
    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        this.keepParameterInfo = false;
        kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        if (this.keepParameterInfo) {
            kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        }
    }

    @Override
    public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        this.keepParameterInfo = false;
        kotlinFunctionMetadata.referencedMethodAccept(clazz, new AllAttributeVisitor(true, this));
        if (this.keepParameterInfo) {
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, this);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        this.keepParameterInfo = this.keepParameterInfo || AttributeUsageMarker.isUsed(localVariableTableAttribute);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        this.keepParameterInfo = this.keepParameterInfo || AttributeUsageMarker.isUsed(localVariableTypeTableAttribute);
    }

    @Override
    public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        KotlinValueParameterUsageMarker.markAsUsed(kotlinValueParameterMetadata);
    }

    private static void markAsUsed(Processable processable) {
        processable.setProcessingInfo(USED);
    }

    static boolean isUsed(Processable processable) {
        return processable.getProcessingInfo() == USED;
    }
}

