/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.ArrayList;
import java.util.List;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.resources.file.ResourceFile;

public class InstructionSequenceBuilder {
    private final ConstantPoolEditor constantPoolEditor;
    private final List<Instruction> instructions = new ArrayList<Instruction>(256);

    public InstructionSequenceBuilder() {
        this(null, null);
    }

    public InstructionSequenceBuilder(ClassPool programClassPool, ClassPool libraryClassPool) {
        this(new MyDummyClass(), programClassPool, libraryClassPool);
    }

    public InstructionSequenceBuilder(ProgramClass targetClass) {
        this(new ConstantPoolEditor(targetClass));
    }

    public InstructionSequenceBuilder(ProgramClass targetClass, ClassPool programClassPool, ClassPool libraryClassPool) {
        this(new ConstantPoolEditor(targetClass, programClassPool, libraryClassPool));
    }

    public InstructionSequenceBuilder(ConstantPoolEditor constantPoolEditor) {
        this.constantPoolEditor = constantPoolEditor;
    }

    public ConstantPoolEditor getConstantPoolEditor() {
        return this.constantPoolEditor;
    }

    public InstructionSequenceBuilder label(Instruction instruction) {
        return this.add(instruction);
    }

    public InstructionSequenceBuilder catch_(Instruction instruction) {
        return this.add(instruction);
    }

    public InstructionSequenceBuilder appendInstruction(Instruction instruction) {
        return this.add(instruction);
    }

    public InstructionSequenceBuilder appendInstructions(Instruction[] instructions) {
        for (Instruction instruction : instructions) {
            this.add(instruction);
        }
        return this;
    }

    public Instruction[] __() {
        return this.instructions();
    }

    public Instruction[] instructions() {
        Instruction[] instructionsArray = new Instruction[this.instructions.size()];
        this.instructions.toArray(instructionsArray);
        this.instructions.clear();
        return instructionsArray;
    }

    public Constant[] constants() {
        ProgramClass targetClass = this.constantPoolEditor.getTargetClass();
        Constant[] constantPool = new Constant[targetClass.u2constantPoolCount];
        System.arraycopy(targetClass.constantPool, 0, constantPool, 0, targetClass.u2constantPoolCount);
        targetClass.u2constantPoolCount = 0;
        return constantPool;
    }

    public int size() {
        return this.instructions.size();
    }

    public InstructionSequenceBuilder nop() {
        return this.add(new SimpleInstruction(0));
    }

    public InstructionSequenceBuilder aconst_null() {
        return this.add(new SimpleInstruction(1));
    }

    public InstructionSequenceBuilder iconst(int constant) {
        return this.add(new SimpleInstruction(3, constant));
    }

    public InstructionSequenceBuilder iconst_m1() {
        return this.add(new SimpleInstruction(2));
    }

    public InstructionSequenceBuilder iconst_0() {
        return this.add(new SimpleInstruction(3));
    }

    public InstructionSequenceBuilder iconst_1() {
        return this.add(new SimpleInstruction(4));
    }

    public InstructionSequenceBuilder iconst_2() {
        return this.add(new SimpleInstruction(5));
    }

    public InstructionSequenceBuilder iconst_3() {
        return this.add(new SimpleInstruction(6));
    }

    public InstructionSequenceBuilder iconst_4() {
        return this.add(new SimpleInstruction(7));
    }

    public InstructionSequenceBuilder iconst_5() {
        return this.add(new SimpleInstruction(8));
    }

    public InstructionSequenceBuilder lconst(int constant) {
        return this.add(new SimpleInstruction(9, constant));
    }

    public InstructionSequenceBuilder lconst_0() {
        return this.add(new SimpleInstruction(9));
    }

    public InstructionSequenceBuilder lconst_1() {
        return this.add(new SimpleInstruction(10));
    }

    public InstructionSequenceBuilder fconst(int constant) {
        return this.add(new SimpleInstruction(11, constant));
    }

    public InstructionSequenceBuilder fconst_0() {
        return this.add(new SimpleInstruction(11));
    }

    public InstructionSequenceBuilder fconst_1() {
        return this.add(new SimpleInstruction(12));
    }

    public InstructionSequenceBuilder fconst_2() {
        return this.add(new SimpleInstruction(13));
    }

    public InstructionSequenceBuilder dconst(int constant) {
        return this.add(new SimpleInstruction(14, constant));
    }

    public InstructionSequenceBuilder dconst_0() {
        return this.add(new SimpleInstruction(14));
    }

    public InstructionSequenceBuilder dconst_1() {
        return this.add(new SimpleInstruction(15));
    }

    public InstructionSequenceBuilder bipush(int constant) {
        return this.add(new SimpleInstruction(16, constant));
    }

    public InstructionSequenceBuilder sipush(int constant) {
        return this.add(new SimpleInstruction(17, constant));
    }

    public InstructionSequenceBuilder ldc(int value) {
        return this.ldc_(this.constantPoolEditor.addIntegerConstant(value));
    }

    public InstructionSequenceBuilder ldc(float value) {
        return this.ldc_(this.constantPoolEditor.addFloatConstant(value));
    }

    public InstructionSequenceBuilder ldc(String string) {
        return this.ldc(string, null, null);
    }

    public InstructionSequenceBuilder ldc(Object primitiveArray) {
        return this.ldc_(this.constantPoolEditor.addPrimitiveArrayConstant(primitiveArray));
    }

    public InstructionSequenceBuilder ldc(Clazz clazz, Member member) {
        return this.ldc(member.getName(clazz), clazz, member);
    }

    public InstructionSequenceBuilder ldc(String string, Clazz referencedClass, Member referencedMember) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, referencedClass, referencedMember));
    }

    public InstructionSequenceBuilder ldc(ResourceFile resourceFile) {
        return this.ldc(resourceFile.getFileName(), resourceFile);
    }

    public InstructionSequenceBuilder ldc(String string, ResourceFile referencedResourceFile) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, referencedResourceFile));
    }

    public InstructionSequenceBuilder ldc(Clazz clazz) {
        return this.ldc(clazz.getName(), clazz);
    }

    public InstructionSequenceBuilder ldc(String typeName, Clazz referencedClass) {
        return this.ldc_(this.constantPoolEditor.addClassConstant(typeName, referencedClass));
    }

    public InstructionSequenceBuilder ldc_(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(18, constantIndex));
    }

    public InstructionSequenceBuilder ldc_w(int value) {
        return this.ldc_(this.constantPoolEditor.addIntegerConstant(value));
    }

    public InstructionSequenceBuilder ldc_w(float value) {
        return this.ldc_(this.constantPoolEditor.addFloatConstant(value));
    }

    public InstructionSequenceBuilder ldc_w(String string) {
        return this.ldc_w(string, null, null);
    }

    public InstructionSequenceBuilder ldc_w(Object primitiveArray) {
        return this.ldc_(this.constantPoolEditor.addPrimitiveArrayConstant(primitiveArray));
    }

    public InstructionSequenceBuilder ldc_w(Clazz clazz, Member member) {
        return this.ldc_w(member.getName(clazz), clazz, member);
    }

    public InstructionSequenceBuilder ldc_w(String string, Clazz referencedClass, Member referencedMember) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, referencedClass, referencedMember));
    }

    public InstructionSequenceBuilder ldc_w(ResourceFile resourceFile) {
        return this.ldc_w(resourceFile.getFileName(), resourceFile);
    }

    public InstructionSequenceBuilder ldc_w(String string, ResourceFile referencedResourceFile) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, referencedResourceFile));
    }

    public InstructionSequenceBuilder ldc_w(Clazz clazz) {
        return this.ldc_w(clazz.getName(), clazz);
    }

    public InstructionSequenceBuilder ldc_w(String typeName, Clazz referencedClass) {
        return this.ldc_(this.constantPoolEditor.addClassConstant(typeName, referencedClass));
    }

    public InstructionSequenceBuilder ldc_w_(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(19, constantIndex));
    }

    public InstructionSequenceBuilder ldc2_w(long value) {
        return this.ldc2_w(this.constantPoolEditor.addLongConstant(value));
    }

    public InstructionSequenceBuilder ldc2_w(double value) {
        return this.ldc2_w(this.constantPoolEditor.addDoubleConstant(value));
    }

    public InstructionSequenceBuilder ldc2_w(int constantIndex) {
        return this.add(new ConstantInstruction(20, constantIndex));
    }

    public InstructionSequenceBuilder iload(int variableIndex) {
        return this.add(new VariableInstruction(21, variableIndex));
    }

    public InstructionSequenceBuilder lload(int variableIndex) {
        return this.add(new VariableInstruction(22, variableIndex));
    }

    public InstructionSequenceBuilder fload(int variableIndex) {
        return this.add(new VariableInstruction(23, variableIndex));
    }

    public InstructionSequenceBuilder dload(int variableIndex) {
        return this.add(new VariableInstruction(24, variableIndex));
    }

    public InstructionSequenceBuilder aload(int variableIndex) {
        return this.add(new VariableInstruction(25, variableIndex));
    }

    public InstructionSequenceBuilder iload_0() {
        return this.add(new VariableInstruction(26));
    }

    public InstructionSequenceBuilder iload_1() {
        return this.add(new VariableInstruction(27));
    }

    public InstructionSequenceBuilder iload_2() {
        return this.add(new VariableInstruction(28));
    }

    public InstructionSequenceBuilder iload_3() {
        return this.add(new VariableInstruction(29));
    }

    public InstructionSequenceBuilder lload_0() {
        return this.add(new VariableInstruction(30));
    }

    public InstructionSequenceBuilder lload_1() {
        return this.add(new VariableInstruction(31));
    }

    public InstructionSequenceBuilder lload_2() {
        return this.add(new VariableInstruction(32));
    }

    public InstructionSequenceBuilder lload_3() {
        return this.add(new VariableInstruction(33));
    }

    public InstructionSequenceBuilder fload_0() {
        return this.add(new VariableInstruction(34));
    }

    public InstructionSequenceBuilder fload_1() {
        return this.add(new VariableInstruction(35));
    }

    public InstructionSequenceBuilder fload_2() {
        return this.add(new VariableInstruction(36));
    }

    public InstructionSequenceBuilder fload_3() {
        return this.add(new VariableInstruction(37));
    }

    public InstructionSequenceBuilder dload_0() {
        return this.add(new VariableInstruction(38));
    }

    public InstructionSequenceBuilder dload_1() {
        return this.add(new VariableInstruction(39));
    }

    public InstructionSequenceBuilder dload_2() {
        return this.add(new VariableInstruction(40));
    }

    public InstructionSequenceBuilder dload_3() {
        return this.add(new VariableInstruction(41));
    }

    public InstructionSequenceBuilder aload_0() {
        return this.add(new VariableInstruction(42));
    }

    public InstructionSequenceBuilder aload_1() {
        return this.add(new VariableInstruction(43));
    }

    public InstructionSequenceBuilder aload_2() {
        return this.add(new VariableInstruction(44));
    }

    public InstructionSequenceBuilder aload_3() {
        return this.add(new VariableInstruction(45));
    }

    public InstructionSequenceBuilder iaload() {
        return this.add(new SimpleInstruction(46));
    }

    public InstructionSequenceBuilder laload() {
        return this.add(new SimpleInstruction(47));
    }

    public InstructionSequenceBuilder faload() {
        return this.add(new SimpleInstruction(48));
    }

    public InstructionSequenceBuilder daload() {
        return this.add(new SimpleInstruction(49));
    }

    public InstructionSequenceBuilder aaload() {
        return this.add(new SimpleInstruction(50));
    }

    public InstructionSequenceBuilder baload() {
        return this.add(new SimpleInstruction(51));
    }

    public InstructionSequenceBuilder caload() {
        return this.add(new SimpleInstruction(52));
    }

    public InstructionSequenceBuilder saload() {
        return this.add(new SimpleInstruction(53));
    }

    public InstructionSequenceBuilder istore(int variableIndex) {
        return this.add(new VariableInstruction(54, variableIndex));
    }

    public InstructionSequenceBuilder lstore(int variableIndex) {
        return this.add(new VariableInstruction(55, variableIndex));
    }

    public InstructionSequenceBuilder fstore(int variableIndex) {
        return this.add(new VariableInstruction(56, variableIndex));
    }

    public InstructionSequenceBuilder dstore(int variableIndex) {
        return this.add(new VariableInstruction(57, variableIndex));
    }

    public InstructionSequenceBuilder astore(int variableIndex) {
        return this.add(new VariableInstruction(58, variableIndex));
    }

    public InstructionSequenceBuilder istore_0() {
        return this.add(new VariableInstruction(59));
    }

    public InstructionSequenceBuilder istore_1() {
        return this.add(new VariableInstruction(60));
    }

    public InstructionSequenceBuilder istore_2() {
        return this.add(new VariableInstruction(61));
    }

    public InstructionSequenceBuilder istore_3() {
        return this.add(new VariableInstruction(62));
    }

    public InstructionSequenceBuilder lstore_0() {
        return this.add(new VariableInstruction(63));
    }

    public InstructionSequenceBuilder lstore_1() {
        return this.add(new VariableInstruction(64));
    }

    public InstructionSequenceBuilder lstore_2() {
        return this.add(new VariableInstruction(65));
    }

    public InstructionSequenceBuilder lstore_3() {
        return this.add(new VariableInstruction(66));
    }

    public InstructionSequenceBuilder fstore_0() {
        return this.add(new VariableInstruction(67));
    }

    public InstructionSequenceBuilder fstore_1() {
        return this.add(new VariableInstruction(68));
    }

    public InstructionSequenceBuilder fstore_2() {
        return this.add(new VariableInstruction(69));
    }

    public InstructionSequenceBuilder fstore_3() {
        return this.add(new VariableInstruction(70));
    }

    public InstructionSequenceBuilder dstore_0() {
        return this.add(new VariableInstruction(71));
    }

    public InstructionSequenceBuilder dstore_1() {
        return this.add(new VariableInstruction(72));
    }

    public InstructionSequenceBuilder dstore_2() {
        return this.add(new VariableInstruction(73));
    }

    public InstructionSequenceBuilder dstore_3() {
        return this.add(new VariableInstruction(74));
    }

    public InstructionSequenceBuilder astore_0() {
        return this.add(new VariableInstruction(75));
    }

    public InstructionSequenceBuilder astore_1() {
        return this.add(new VariableInstruction(76));
    }

    public InstructionSequenceBuilder astore_2() {
        return this.add(new VariableInstruction(77));
    }

    public InstructionSequenceBuilder astore_3() {
        return this.add(new VariableInstruction(78));
    }

    public InstructionSequenceBuilder iastore() {
        return this.add(new SimpleInstruction(79));
    }

    public InstructionSequenceBuilder lastore() {
        return this.add(new SimpleInstruction(80));
    }

    public InstructionSequenceBuilder fastore() {
        return this.add(new SimpleInstruction(81));
    }

    public InstructionSequenceBuilder dastore() {
        return this.add(new SimpleInstruction(82));
    }

    public InstructionSequenceBuilder aastore() {
        return this.add(new SimpleInstruction(83));
    }

    public InstructionSequenceBuilder bastore() {
        return this.add(new SimpleInstruction(84));
    }

    public InstructionSequenceBuilder castore() {
        return this.add(new SimpleInstruction(85));
    }

    public InstructionSequenceBuilder sastore() {
        return this.add(new SimpleInstruction(86));
    }

    public InstructionSequenceBuilder pop() {
        return this.add(new SimpleInstruction(87));
    }

    public InstructionSequenceBuilder pop2() {
        return this.add(new SimpleInstruction(88));
    }

    public InstructionSequenceBuilder dup() {
        return this.add(new SimpleInstruction(89));
    }

    public InstructionSequenceBuilder dup_x1() {
        return this.add(new SimpleInstruction(90));
    }

    public InstructionSequenceBuilder dup_x2() {
        return this.add(new SimpleInstruction(91));
    }

    public InstructionSequenceBuilder dup2() {
        return this.add(new SimpleInstruction(92));
    }

    public InstructionSequenceBuilder dup2_x1() {
        return this.add(new SimpleInstruction(93));
    }

    public InstructionSequenceBuilder dup2_x2() {
        return this.add(new SimpleInstruction(94));
    }

    public InstructionSequenceBuilder swap() {
        return this.add(new SimpleInstruction(95));
    }

    public InstructionSequenceBuilder iadd() {
        return this.add(new SimpleInstruction(96));
    }

    public InstructionSequenceBuilder ladd() {
        return this.add(new SimpleInstruction(97));
    }

    public InstructionSequenceBuilder fadd() {
        return this.add(new SimpleInstruction(98));
    }

    public InstructionSequenceBuilder dadd() {
        return this.add(new SimpleInstruction(99));
    }

    public InstructionSequenceBuilder isub() {
        return this.add(new SimpleInstruction(100));
    }

    public InstructionSequenceBuilder lsub() {
        return this.add(new SimpleInstruction(101));
    }

    public InstructionSequenceBuilder fsub() {
        return this.add(new SimpleInstruction(102));
    }

    public InstructionSequenceBuilder dsub() {
        return this.add(new SimpleInstruction(103));
    }

    public InstructionSequenceBuilder imul() {
        return this.add(new SimpleInstruction(104));
    }

    public InstructionSequenceBuilder lmul() {
        return this.add(new SimpleInstruction(105));
    }

    public InstructionSequenceBuilder fmul() {
        return this.add(new SimpleInstruction(106));
    }

    public InstructionSequenceBuilder dmul() {
        return this.add(new SimpleInstruction(107));
    }

    public InstructionSequenceBuilder idiv() {
        return this.add(new SimpleInstruction(108));
    }

    public InstructionSequenceBuilder ldiv() {
        return this.add(new SimpleInstruction(109));
    }

    public InstructionSequenceBuilder fdiv() {
        return this.add(new SimpleInstruction(110));
    }

    public InstructionSequenceBuilder ddiv() {
        return this.add(new SimpleInstruction(111));
    }

    public InstructionSequenceBuilder irem() {
        return this.add(new SimpleInstruction(112));
    }

    public InstructionSequenceBuilder lrem() {
        return this.add(new SimpleInstruction(113));
    }

    public InstructionSequenceBuilder frem() {
        return this.add(new SimpleInstruction(114));
    }

    public InstructionSequenceBuilder drem() {
        return this.add(new SimpleInstruction(115));
    }

    public InstructionSequenceBuilder ineg() {
        return this.add(new SimpleInstruction(116));
    }

    public InstructionSequenceBuilder lneg() {
        return this.add(new SimpleInstruction(117));
    }

    public InstructionSequenceBuilder fneg() {
        return this.add(new SimpleInstruction(118));
    }

    public InstructionSequenceBuilder dneg() {
        return this.add(new SimpleInstruction(119));
    }

    public InstructionSequenceBuilder ishl() {
        return this.add(new SimpleInstruction(120));
    }

    public InstructionSequenceBuilder lshl() {
        return this.add(new SimpleInstruction(121));
    }

    public InstructionSequenceBuilder ishr() {
        return this.add(new SimpleInstruction(122));
    }

    public InstructionSequenceBuilder lshr() {
        return this.add(new SimpleInstruction(123));
    }

    public InstructionSequenceBuilder iushr() {
        return this.add(new SimpleInstruction(124));
    }

    public InstructionSequenceBuilder lushr() {
        return this.add(new SimpleInstruction(125));
    }

    public InstructionSequenceBuilder iand() {
        return this.add(new SimpleInstruction(126));
    }

    public InstructionSequenceBuilder land() {
        return this.add(new SimpleInstruction(127));
    }

    public InstructionSequenceBuilder ior() {
        return this.add(new SimpleInstruction(-128));
    }

    public InstructionSequenceBuilder lor() {
        return this.add(new SimpleInstruction(-127));
    }

    public InstructionSequenceBuilder ixor() {
        return this.add(new SimpleInstruction(-126));
    }

    public InstructionSequenceBuilder lxor() {
        return this.add(new SimpleInstruction(-125));
    }

    public InstructionSequenceBuilder iinc(int variableIndex, int constant) {
        return this.add(new VariableInstruction(-124, variableIndex, constant));
    }

    public InstructionSequenceBuilder i2l() {
        return this.add(new SimpleInstruction(-123));
    }

    public InstructionSequenceBuilder i2f() {
        return this.add(new SimpleInstruction(-122));
    }

    public InstructionSequenceBuilder i2d() {
        return this.add(new SimpleInstruction(-121));
    }

    public InstructionSequenceBuilder l2i() {
        return this.add(new SimpleInstruction(-120));
    }

    public InstructionSequenceBuilder l2f() {
        return this.add(new SimpleInstruction(-119));
    }

    public InstructionSequenceBuilder l2d() {
        return this.add(new SimpleInstruction(-118));
    }

    public InstructionSequenceBuilder f2i() {
        return this.add(new SimpleInstruction(-117));
    }

    public InstructionSequenceBuilder f2l() {
        return this.add(new SimpleInstruction(-116));
    }

    public InstructionSequenceBuilder f2d() {
        return this.add(new SimpleInstruction(-115));
    }

    public InstructionSequenceBuilder d2i() {
        return this.add(new SimpleInstruction(-114));
    }

    public InstructionSequenceBuilder d2l() {
        return this.add(new SimpleInstruction(-113));
    }

    public InstructionSequenceBuilder d2f() {
        return this.add(new SimpleInstruction(-112));
    }

    public InstructionSequenceBuilder i2b() {
        return this.add(new SimpleInstruction(-111));
    }

    public InstructionSequenceBuilder i2c() {
        return this.add(new SimpleInstruction(-110));
    }

    public InstructionSequenceBuilder i2s() {
        return this.add(new SimpleInstruction(-109));
    }

    public InstructionSequenceBuilder lcmp() {
        return this.add(new SimpleInstruction(-108));
    }

    public InstructionSequenceBuilder fcmpl() {
        return this.add(new SimpleInstruction(-107));
    }

    public InstructionSequenceBuilder fcmpg() {
        return this.add(new SimpleInstruction(-106));
    }

    public InstructionSequenceBuilder dcmpl() {
        return this.add(new SimpleInstruction(-105));
    }

    public InstructionSequenceBuilder dcmpg() {
        return this.add(new SimpleInstruction(-104));
    }

    public InstructionSequenceBuilder ifeq(int branchOffset) {
        return this.add(new BranchInstruction(-103, branchOffset));
    }

    public InstructionSequenceBuilder ifne(int branchOffset) {
        return this.add(new BranchInstruction(-102, branchOffset));
    }

    public InstructionSequenceBuilder iflt(int branchOffset) {
        return this.add(new BranchInstruction(-101, branchOffset));
    }

    public InstructionSequenceBuilder ifge(int branchOffset) {
        return this.add(new BranchInstruction(-100, branchOffset));
    }

    public InstructionSequenceBuilder ifgt(int branchOffset) {
        return this.add(new BranchInstruction(-99, branchOffset));
    }

    public InstructionSequenceBuilder ifle(int branchOffset) {
        return this.add(new BranchInstruction(-98, branchOffset));
    }

    public InstructionSequenceBuilder ificmpeq(int branchOffset) {
        return this.add(new BranchInstruction(-97, branchOffset));
    }

    public InstructionSequenceBuilder ificmpne(int branchOffset) {
        return this.add(new BranchInstruction(-96, branchOffset));
    }

    public InstructionSequenceBuilder ificmplt(int branchOffset) {
        return this.add(new BranchInstruction(-95, branchOffset));
    }

    public InstructionSequenceBuilder ificmpge(int branchOffset) {
        return this.add(new BranchInstruction(-94, branchOffset));
    }

    public InstructionSequenceBuilder ificmpgt(int branchOffset) {
        return this.add(new BranchInstruction(-93, branchOffset));
    }

    public InstructionSequenceBuilder ificmple(int branchOffset) {
        return this.add(new BranchInstruction(-92, branchOffset));
    }

    public InstructionSequenceBuilder ifacmpeq(int branchOffset) {
        return this.add(new BranchInstruction(-91, branchOffset));
    }

    public InstructionSequenceBuilder ifacmpne(int branchOffset) {
        return this.add(new BranchInstruction(-90, branchOffset));
    }

    public InstructionSequenceBuilder goto_(int branchOffset) {
        return this.add(new BranchInstruction(-89, branchOffset));
    }

    public InstructionSequenceBuilder jsr(int branchOffset) {
        return this.add(new BranchInstruction(-88, branchOffset));
    }

    public InstructionSequenceBuilder ret(int variableIndex) {
        return this.add(new VariableInstruction(-87, variableIndex));
    }

    public InstructionSequenceBuilder tableswitch(int defaultOffset, int lowCase, int highCase, int[] jumpOffsets) {
        return this.add(new TableSwitchInstruction(-86, defaultOffset, lowCase, highCase, jumpOffsets));
    }

    public InstructionSequenceBuilder lookupswitch(int defaultOffset, int[] cases, int[] jumpOffsets) {
        return this.add(new LookUpSwitchInstruction(-85, defaultOffset, cases, jumpOffsets));
    }

    public InstructionSequenceBuilder ireturn() {
        return this.add(new SimpleInstruction(-84));
    }

    public InstructionSequenceBuilder lreturn() {
        return this.add(new SimpleInstruction(-83));
    }

    public InstructionSequenceBuilder freturn() {
        return this.add(new SimpleInstruction(-82));
    }

    public InstructionSequenceBuilder dreturn() {
        return this.add(new SimpleInstruction(-81));
    }

    public InstructionSequenceBuilder areturn() {
        return this.add(new SimpleInstruction(-80));
    }

    public InstructionSequenceBuilder return_() {
        return this.add(new SimpleInstruction(-79));
    }

    public InstructionSequenceBuilder getstatic(Clazz clazz, Field field) {
        return this.getstatic(clazz.getName(), field.getName(clazz), field.getDescriptor(clazz), clazz, field);
    }

    public InstructionSequenceBuilder getstatic(String className, String name, String descriptor) {
        return this.getstatic(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder getstatic(String className, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.getstatic(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedField));
    }

    public InstructionSequenceBuilder getstatic(int constantIndex) {
        return this.add(new ConstantInstruction(-78, constantIndex));
    }

    public InstructionSequenceBuilder putstatic(Clazz clazz, Field field) {
        return this.putstatic(clazz.getName(), field.getName(clazz), field.getDescriptor(clazz), clazz, field);
    }

    public InstructionSequenceBuilder putstatic(String className, String name, String descriptor) {
        return this.putstatic(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder putstatic(String className, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.putstatic(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedField));
    }

    public InstructionSequenceBuilder putstatic(int constantIndex) {
        return this.add(new ConstantInstruction(-77, constantIndex));
    }

    public InstructionSequenceBuilder getfield(Clazz clazz, Field field) {
        return this.getfield(clazz.getName(), field.getName(clazz), field.getDescriptor(clazz), clazz, field);
    }

    public InstructionSequenceBuilder getfield(String className, String name, String descriptor) {
        return this.getfield(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder getfield(String className, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.getfield(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedField));
    }

    public InstructionSequenceBuilder getfield(int constantIndex) {
        return this.add(new ConstantInstruction(-76, constantIndex));
    }

    public InstructionSequenceBuilder putfield(Clazz clazz, Field field) {
        return this.putfield(clazz.getName(), field.getName(clazz), field.getDescriptor(clazz), clazz, field);
    }

    public InstructionSequenceBuilder putfield(String className, String name, String descriptor) {
        return this.putfield(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder putfield(String className, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.putfield(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedField));
    }

    public InstructionSequenceBuilder putfield(int constantIndex) {
        return this.add(new ConstantInstruction(-75, constantIndex));
    }

    public InstructionSequenceBuilder invokevirtual(Clazz clazz, Method method) {
        return this.invokevirtual(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public InstructionSequenceBuilder invokevirtual(String className, String name, String descriptor) {
        return this.invokevirtual(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder invokevirtual(int classIndex, String name, String descriptor) {
        return this.invokevirtual(this.constantPoolEditor.addMethodrefConstant(classIndex, name, descriptor, null, null));
    }

    public InstructionSequenceBuilder invokevirtual(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.invokevirtual(this.constantPoolEditor.addMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod));
    }

    public InstructionSequenceBuilder invokevirtual(int constantIndex) {
        return this.add(new ConstantInstruction(-74, constantIndex));
    }

    public InstructionSequenceBuilder invokespecial(Clazz clazz, Method method) {
        return this.invokespecial(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public InstructionSequenceBuilder invokespecial(String className, String name, String descriptor) {
        return this.invokespecial(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder invokespecial(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.invokespecial(this.constantPoolEditor.addMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod));
    }

    public InstructionSequenceBuilder invokespecial_interface(Clazz clazz, Method method) {
        return this.invokespecial_interface(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public InstructionSequenceBuilder invokespecial_interface(String className, String name, String descriptor) {
        return this.invokespecial_interface(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder invokespecial_interface(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.invokespecial(this.constantPoolEditor.addInterfaceMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod));
    }

    public InstructionSequenceBuilder invokespecial(int constantIndex) {
        return this.add(new ConstantInstruction(-73, constantIndex));
    }

    public InstructionSequenceBuilder invokestatic(Clazz clazz, Method method) {
        return this.invokestatic(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public InstructionSequenceBuilder invokestatic(String className, String name, String descriptor) {
        return this.invokestatic(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder invokestatic(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.invokestatic(this.constantPoolEditor.addMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod));
    }

    public InstructionSequenceBuilder invokestatic_interface(Clazz clazz, Method method) {
        return this.invokestatic_interface(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public InstructionSequenceBuilder invokestatic_interface(String className, String name, String descriptor) {
        return this.invokestatic_interface(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder invokestatic_interface(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.invokestatic(this.constantPoolEditor.addInterfaceMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod));
    }

    public InstructionSequenceBuilder invokestatic(int constantIndex) {
        return this.add(new ConstantInstruction(-72, constantIndex));
    }

    public InstructionSequenceBuilder invokeinterface(Clazz clazz, Method method) {
        return this.invokeinterface(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public InstructionSequenceBuilder invokeinterface(String className, String name, String descriptor) {
        return this.invokeinterface(className, name, descriptor, null, null);
    }

    public InstructionSequenceBuilder invokeinterface(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        int invokeinterfaceConstant = ClassUtil.internalMethodParameterSize(descriptor, false) << 8;
        return this.invokeinterface(this.constantPoolEditor.addInterfaceMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod), invokeinterfaceConstant);
    }

    public InstructionSequenceBuilder invokeinterface(int constantIndex, int constant) {
        return this.add(new ConstantInstruction(-71, constantIndex, constant));
    }

    public InstructionSequenceBuilder invokedynamic(int bootStrapMethodIndex, String name, String descriptor) {
        return this.invokedynamic(bootStrapMethodIndex, name, descriptor, null);
    }

    public InstructionSequenceBuilder invokedynamic(int bootStrapMethodIndex, String name, String descriptor, Clazz[] referencedClasses) {
        return this.invokedynamic(this.constantPoolEditor.addInvokeDynamicConstant(bootStrapMethodIndex, name, descriptor, referencedClasses));
    }

    public InstructionSequenceBuilder invokedynamic(int constantIndex) {
        return this.add(new ConstantInstruction(-70, constantIndex));
    }

    public InstructionSequenceBuilder new_(Clazz clazz) {
        return this.new_(clazz.getName(), clazz);
    }

    public InstructionSequenceBuilder new_(String className) {
        return this.new_(className, null);
    }

    public InstructionSequenceBuilder new_(String className, Clazz referencedClass) {
        return this.new_(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public InstructionSequenceBuilder new_(int constantIndex) {
        return this.add(new ConstantInstruction(-69, constantIndex));
    }

    public InstructionSequenceBuilder newarray(int constant) {
        return this.add(new SimpleInstruction(-68, constant));
    }

    public InstructionSequenceBuilder anewarray(Clazz elementType) {
        return this.anewarray(elementType.getName(), elementType);
    }

    public InstructionSequenceBuilder anewarray(String elementTypeName, Clazz referencedClass) {
        return this.anewarray(this.constantPoolEditor.addClassConstant(elementTypeName, referencedClass));
    }

    public InstructionSequenceBuilder anewarray(int constantIndex) {
        return this.add(new ConstantInstruction(-67, constantIndex));
    }

    public InstructionSequenceBuilder arraylength() {
        return this.add(new SimpleInstruction(-66));
    }

    public InstructionSequenceBuilder athrow() {
        return this.add(new SimpleInstruction(-65));
    }

    public InstructionSequenceBuilder checkcast(Clazz type) {
        return this.checkcast(type.getName(), type);
    }

    public InstructionSequenceBuilder checkcast(String typeName) {
        return this.checkcast(typeName, null);
    }

    public InstructionSequenceBuilder checkcast(String typeName, Clazz referencedClass) {
        return this.checkcast(this.constantPoolEditor.addClassConstant(typeName, referencedClass));
    }

    public InstructionSequenceBuilder checkcast(int constantIndex) {
        return this.add(new ConstantInstruction(-64, constantIndex));
    }

    public InstructionSequenceBuilder instanceof_(Clazz type) {
        return this.instanceof_(type.getName(), type);
    }

    public InstructionSequenceBuilder instanceof_(String typeName, Clazz referencedClass) {
        return this.instanceof_(this.constantPoolEditor.addClassConstant(typeName, referencedClass));
    }

    public InstructionSequenceBuilder instanceof_(int constantIndex) {
        return this.add(new ConstantInstruction(-63, constantIndex));
    }

    public InstructionSequenceBuilder monitorenter() {
        return this.add(new SimpleInstruction(-62));
    }

    public InstructionSequenceBuilder monitorexit() {
        return this.add(new SimpleInstruction(-61));
    }

    public InstructionSequenceBuilder wide() {
        return this.add(new SimpleInstruction(-60));
    }

    public InstructionSequenceBuilder multianewarray(Clazz type) {
        return this.multianewarray(type.getName(), type);
    }

    public InstructionSequenceBuilder multianewarray(String typeName) {
        return this.multianewarray(typeName, null);
    }

    public InstructionSequenceBuilder multianewarray(String typeName, Clazz referencedClass) {
        return this.multianewarray(this.constantPoolEditor.addClassConstant(typeName, referencedClass));
    }

    public InstructionSequenceBuilder multianewarray(int constantIndex) {
        return this.add(new ConstantInstruction(-59, constantIndex));
    }

    public InstructionSequenceBuilder ifnull(int branchOffset) {
        return this.add(new BranchInstruction(-58, branchOffset));
    }

    public InstructionSequenceBuilder ifnonnull(int branchOffset) {
        return this.add(new BranchInstruction(-57, branchOffset));
    }

    public InstructionSequenceBuilder goto_w(int branchOffset) {
        return this.add(new BranchInstruction(-56, branchOffset));
    }

    public InstructionSequenceBuilder jsr_w(int branchOffset) {
        return this.add(new BranchInstruction(-55, branchOffset));
    }

    public InstructionSequenceBuilder pushPrimitive(Object value, char type) {
        switch (type) {
            case 'Z': {
                return (Boolean)value != false ? this.iconst_1() : this.iconst_0();
            }
            case 'B': 
            case 'I': 
            case 'S': {
                return this.pushInt(((Number)value).intValue());
            }
            case 'C': {
                return this.ldc(((Character)value).charValue());
            }
            case 'J': {
                return this.ldc2_w((Long)value);
            }
            case 'F': {
                return this.ldc(((Float)value).floatValue());
            }
            case 'D': {
                return this.ldc2_w((Double)value);
            }
        }
        throw new IllegalArgumentException("" + type);
    }

    public InstructionSequenceBuilder pushPrimitiveOrString(Object value, String type) {
        return this.pushPrimitiveOrString(value, type, true);
    }

    public InstructionSequenceBuilder pushPrimitiveOrString(Object value, String type, boolean allowBoxing) {
        if (type == null) {
            throw new IllegalArgumentException("Null type found for value: " + value);
        }
        char primitiveType = type.charAt(0);
        if (type.equals("Ljava/lang/String;")) {
            return this.ldc((String)value);
        }
        if (allowBoxing && primitiveType == 'L') {
            return this.pushBoxedPrimitive(value, type);
        }
        if (!allowBoxing && primitiveType == 'L') {
            String internalPrimitiveClassName = ClassUtil.internalClassNameFromType(type);
            if (internalPrimitiveClassName == null) {
                throw new IllegalArgumentException("Invalid type: " + type);
            }
            primitiveType = ClassUtil.internalPrimitiveTypeFromNumericClassName(internalPrimitiveClassName);
        }
        return this.pushPrimitive(value, primitiveType);
    }

    public InstructionSequenceBuilder pushBoxedPrimitive(Object value, String type) {
        String internalPrimitiveClassName = ClassUtil.internalClassNameFromType(type);
        if (internalPrimitiveClassName == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        char primitiveType = ClassUtil.internalPrimitiveTypeFromNumericClassName(internalPrimitiveClassName);
        String className = ClassUtil.internalClassNameFromType(type);
        this.pushPrimitive(value, primitiveType);
        return this.invokestatic(className, "valueOf", String.format("(%c)%s", Character.valueOf(primitiveType), type));
    }

    public InstructionSequenceBuilder pushInt(int value) {
        switch (value) {
            case -1: {
                return this.iconst_m1();
            }
            case 0: {
                return this.iconst_0();
            }
            case 1: {
                return this.iconst_1();
            }
            case 2: {
                return this.iconst_2();
            }
            case 3: {
                return this.iconst_3();
            }
            case 4: {
                return this.iconst_4();
            }
            case 5: {
                return this.iconst_5();
            }
        }
        return value == (byte)value ? this.bipush(value) : (value == (short)value ? this.sipush(value) : this.ldc(value));
    }

    public InstructionSequenceBuilder pushFloat(float value) {
        return value == 0.0f ? this.fconst_0() : (value == 1.0f ? this.fconst_1() : (value == 2.0f ? this.fconst_2() : this.ldc(value)));
    }

    public InstructionSequenceBuilder pushLong(long value) {
        return value == 0L ? this.lconst_0() : (value == 1L ? this.lconst_1() : this.ldc2_w(value));
    }

    public InstructionSequenceBuilder pushDouble(double value) {
        return value == 0.0 ? this.dconst_0() : (value == 1.0 ? this.dconst_1() : this.ldc2_w(value));
    }

    public InstructionSequenceBuilder pushNewArray(String type, int size) {
        this.pushInt(size);
        return ClassUtil.isInternalPrimitiveType(type) ? this.newarray(InstructionUtil.arrayTypeFromInternalType(type.charAt(0))) : this.anewarray(type, null);
    }

    public InstructionSequenceBuilder pushPrimitiveOrStringArray(String type, Object[] values2) {
        String internalClassType = ClassUtil.internalClassTypeFromType(type);
        this.pushNewArray(internalClassType, values2.length);
        this.dup();
        for (int i = 0; i < values2.length; ++i) {
            this.pushInt(i);
            this.pushPrimitiveOrString(values2[i], type);
            this.storeToArray(internalClassType);
            if (i == values2.length - 1) continue;
            this.dup();
        }
        return this.nop();
    }

    public InstructionSequenceBuilder pushDefault(String type) {
        switch (type.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.iconst_0();
            }
            case 'J': {
                return this.lconst_0();
            }
            case 'F': {
                return this.fconst_0();
            }
            case 'D': {
                return this.dconst_0();
            }
        }
        return this.aconst_null();
    }

    public InstructionSequenceBuilder load(int variableIndex, String type) {
        return this.load(variableIndex, type.charAt(0));
    }

    public InstructionSequenceBuilder load(int variableIndex, char type) {
        switch (type) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.iload(variableIndex);
            }
            case 'J': {
                return this.lload(variableIndex);
            }
            case 'F': {
                return this.fload(variableIndex);
            }
            case 'D': {
                return this.dload(variableIndex);
            }
        }
        return this.aload(variableIndex);
    }

    public InstructionSequenceBuilder store(int variableIndex, String type) {
        return this.store(variableIndex, type.charAt(0));
    }

    public InstructionSequenceBuilder store(int variableIndex, char type) {
        switch (type) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.istore(variableIndex);
            }
            case 'J': {
                return this.lstore(variableIndex);
            }
            case 'F': {
                return this.fstore(variableIndex);
            }
            case 'D': {
                return this.dstore(variableIndex);
            }
        }
        return this.astore(variableIndex);
    }

    public InstructionSequenceBuilder storeToArray(String elementType) {
        switch (elementType.charAt(0)) {
            case 'B': 
            case 'Z': {
                return this.bastore();
            }
            case 'C': {
                return this.castore();
            }
            case 'S': {
                return this.sastore();
            }
            case 'I': {
                return this.iastore();
            }
            case 'J': {
                return this.lastore();
            }
            case 'F': {
                return this.fastore();
            }
            case 'D': {
                return this.dastore();
            }
        }
        return this.aastore();
    }

    public InstructionSequenceBuilder loadFromArray(String elementType) {
        switch (elementType.charAt(0)) {
            case 'B': 
            case 'Z': {
                return this.baload();
            }
            case 'C': {
                return this.caload();
            }
            case 'S': {
                return this.saload();
            }
            case 'I': {
                return this.iaload();
            }
            case 'J': {
                return this.laload();
            }
            case 'F': {
                return this.faload();
            }
            case 'D': {
                return this.daload();
            }
        }
        return this.aaload();
    }

    private InstructionSequenceBuilder add(Instruction instruction) {
        this.instructions.add(instruction);
        return this;
    }

    public static void main(String[] args2) {
        InstructionSequenceBuilder builder = new InstructionSequenceBuilder();
        Instruction[] instructions = builder.iconst_2().istore_0().iinc(0, 2).iload_0().ldc(12).iadd().putstatic("com/example/SomeClass", "someField", "I", null, null).instructions();
        Constant[] constants = builder.constants();
        System.out.println("Instructions:");
        for (Instruction instruction : instructions) {
            System.out.println(instruction);
        }
        System.out.println();
        System.out.println("Constants:");
        for (int index = 0; index < constants.length; ++index) {
            System.out.println("#" + index + ": " + constants[index]);
        }
    }

    private static class MyDummyClass
    extends ProgramClass {
        public MyDummyClass() {
            super(2949123, 1, new Constant[256], 0, 0, 0);
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

