/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LibraryClassFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.classfile.visitor.SignatureAttributeReferencedClassVisitor;
import proguard.optimize.gson.DuplicateJsonFieldNameChecker;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.LocalOrAnonymousClassChecker;
import proguard.optimize.gson.TypeParameterClassChecker;

public class GsonDomainClassFinder
implements ClassVisitor {
    public static final boolean DEBUG = false;
    private final GsonRuntimeSettings gsonRuntimeSettings;
    private final ClassPool gsonDomainClassPool;
    private final WarningPrinter warningPrinter;
    private final ClassPool unoptimizedClassPool = new ClassPool();
    private final LocalOrAnonymousClassChecker localOrAnonymousClassChecker = new LocalOrAnonymousClassChecker();
    private final TypeParameterClassChecker typeParameterClassChecker = new TypeParameterClassChecker();
    private final DuplicateJsonFieldNameChecker duplicateFieldNameChecker = new DuplicateJsonFieldNameChecker();
    private Queue<ClassAnalysisCommand> toProcess = new ArrayDeque<ClassAnalysisCommand>();

    public GsonDomainClassFinder(GsonRuntimeSettings gsonRuntimeSettings, ClassPool gsonDomainClassPool, WarningPrinter warningPrinter) {
        this.gsonRuntimeSettings = gsonRuntimeSettings;
        this.gsonDomainClassPool = gsonDomainClassPool;
        this.warningPrinter = warningPrinter;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.toProcess.add(new ClassAnalysisCommand(programClass, true));
        HierarchyClassVisitor recursiveVisitor = new HierarchyClassVisitor(true);
        HierarchyClassVisitor hierarchyClassVisitor = new HierarchyClassVisitor(false);
        while (!this.toProcess.isEmpty()) {
            ClassAnalysisCommand toAnalyse = this.toProcess.poll();
            this.handleDomainClass(toAnalyse.programClass, recursiveVisitor, toAnalyse.recursive ? hierarchyClassVisitor : null);
        }
    }

    private void handleDomainClass(ProgramClass programClass, ClassVisitor recursiveVisitor, ClassVisitor hierarchyClassVisitor) {
        if (this.gsonDomainClassPool.getClass(programClass.getName()) == null && this.unoptimizedClassPool.getClass(programClass.getName()) == null) {
            programClass.accept(this.localOrAnonymousClassChecker);
            if (this.localOrAnonymousClassChecker.isLocalOrAnonymous()) {
                return;
            }
            if (this.librarySuperClassCount(programClass) != 0) {
                this.note(programClass, "Warning: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it is or inherits from a library class."));
                return;
            }
            if (this.gsonSuperClassCount(programClass) != 0) {
                this.note(programClass, "Warning: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it is or inherits from a GSON API class."));
                return;
            }
            this.typeParameterClassChecker.hasFieldWithTypeParameter = false;
            programClass.hierarchyAccept(true, true, false, false, this.typeParameterClassChecker);
            if (this.typeParameterClassChecker.hasFieldWithTypeParameter) {
                this.note(programClass, "Warning: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it uses generic type variables."));
                return;
            }
            this.duplicateFieldNameChecker.hasDuplicateJsonFieldNames = false;
            programClass.hierarchyAccept(true, true, false, false, this.duplicateFieldNameChecker);
            if (this.duplicateFieldNameChecker.hasDuplicateJsonFieldNames) {
                this.note(programClass, "Warning: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it contains duplicate field names in its JSON representation."));
                return;
            }
            ClassCounter typeAdapterClassCounter = new ClassCounter();
            programClass.hierarchyAccept(true, true, false, false, new ClassPresenceFilter(this.gsonRuntimeSettings.typeAdapterClassPool, typeAdapterClassCounter, null));
            if (typeAdapterClassCounter.getCount() > 0) {
                this.note(programClass, "Warning: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because a custom type adapter is registered for it."));
                return;
            }
            AnnotationFinder annotationFinder = new AnnotationFinder();
            programClass.hierarchyAccept(true, true, false, false, new MultiClassVisitor(new AllAttributeVisitor(true, new AllAnnotationVisitor(new AnnotationTypeFilter("Lcom/google/gson/annotations/JsonAdapter;", (AnnotationVisitor)annotationFinder)))));
            if (annotationFinder.found) {
                this.note(programClass, "Warning: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it contains a JsonAdapter annotation."));
                return;
            }
            if ((programClass.getAccessFlags() & 0x200) == 0) {
                this.gsonDomainClassPool.addClass(programClass);
                int requiredUnsetAccessFlags = 4096;
                if (!this.gsonRuntimeSettings.excludeFieldsWithModifiers) {
                    requiredUnsetAccessFlags |= 0x88;
                }
                programClass.fieldsAccept(new MemberAccessFilter(0, requiredUnsetAccessFlags, new MultiMemberVisitor(new MemberDescriptorReferencedClassVisitor(recursiveVisitor), new AllAttributeVisitor(new SignatureAttributeReferencedClassVisitor(recursiveVisitor)))));
            }
            if (hierarchyClassVisitor != null && (programClass.getAccessFlags() & 0x4000) == 0) {
                programClass.hierarchyAccept(false, true, false, true, hierarchyClassVisitor);
            }
        }
    }

    private int librarySuperClassCount(ProgramClass programClass) {
        ClassCounter nonObjectLibrarySuperClassCounter = new ClassCounter();
        programClass.hierarchyAccept(true, true, false, false, new LibraryClassFilter(new ClassNameFilter(Arrays.asList("!java/lang/Object", "!java/lang/Enum"), (ClassVisitor)nonObjectLibrarySuperClassCounter)));
        return nonObjectLibrarySuperClassCounter.getCount();
    }

    private int gsonSuperClassCount(ProgramClass programClass) {
        ClassCounter gsonSuperClassCounter = new ClassCounter();
        programClass.hierarchyAccept(true, true, false, false, new ProgramClassFilter(new ClassNameFilter("com/google/gson/**", (ClassVisitor)gsonSuperClassCounter)));
        return gsonSuperClassCounter.getCount();
    }

    private void note(ProgramClass programClass, String note) {
        if (this.warningPrinter != null && !this.isKept(programClass)) {
            this.warningPrinter.print(programClass.getName(), note);
            this.warningPrinter.print(programClass.getName(), "      You should consider including dexguard-gson.pro or keeping this class and its members in your configuration as follows:");
            this.warningPrinter.print(programClass.getName(), "      -keep class " + ClassUtil.externalClassName(programClass.getName()) + " { *; }");
        }
        this.unoptimizedClassPool.addClass(programClass);
    }

    private boolean isKept(ProgramClass programClass) {
        if ((programClass.getProcessingFlags() & 0x100000) != 0 && (programClass.getProcessingFlags() & 0x400000) != 0) {
            UnkeptFieldFinder unkeptFieldFinder = new UnkeptFieldFinder();
            programClass.fieldsAccept(unkeptFieldFinder);
            return !unkeptFieldFinder.found;
        }
        return false;
    }

    private static class ClassAnalysisCommand {
        public final ProgramClass programClass;
        public final boolean recursive;

        private ClassAnalysisCommand(ProgramClass programClass, boolean recursive) {
            this.programClass = programClass;
            this.recursive = recursive;
        }
    }

    private class UnkeptFieldFinder
    implements MemberVisitor {
        private boolean found;

        private UnkeptFieldFinder() {
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            this.found = this.found || !this.isKept(programField);
        }

        private boolean isKept(ProgramField programField) {
            return (programField.getProcessingFlags() & 0x100000) != 0 && (programField.getProcessingFlags() & 0x400000) != 0;
        }
    }

    private class AnnotationFinder
    implements AnnotationVisitor {
        private boolean found;

        private AnnotationFinder() {
        }

        @Override
        public void visitAnnotation(Clazz clazz, Annotation annotation) {
            this.found = true;
        }
    }

    private class HierarchyClassVisitor
    implements ClassVisitor {
        private final boolean recursive;

        private HierarchyClassVisitor(boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            GsonDomainClassFinder.this.toProcess.add(new ClassAnalysisCommand(programClass, this.recursive));
        }
    }
}

