/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.io.PrintWriter;
import proguard.Configuration;
import proguard.backport.DefaultInterfaceMethodConverter;
import proguard.backport.JSR310Converter;
import proguard.backport.LambdaExpressionConverter;
import proguard.backport.StaticInterfaceMethodConverter;
import proguard.backport.StreamSupportConverter;
import proguard.backport.StringConcatenationConverter;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeToClassVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.BootstrapMethodsAttributeShrinker;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.InstructionSequencesReplacer;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVersionSetter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.io.ExtraDataEntryNameMap;

public class Backporter {
    private final Configuration configuration;

    public Backporter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool, ExtraDataEntryNameMap extraDataEntryNameMap) {
        int conversionWarningCount;
        ClassPoolFiller modifiedClassCollector;
        ClassPool modifiedClasses;
        int targetClassVersion = this.configuration.targetClassVersion;
        if (this.configuration.verbose) {
            System.out.println("Backporting class files...");
        }
        PrintWriter err = new PrintWriter(System.err, true);
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        InstructionCounter replacedStringConcatCounter = new InstructionCounter();
        ClassCounter lambdaExpressionCounter = new ClassCounter();
        MemberCounter staticInterfaceMethodCounter = new MemberCounter();
        MemberCounter defaultInterfaceMethodCounter = new MemberCounter();
        InstructionCounter replacedMethodCallCounter = new InstructionCounter();
        InstructionCounter replacedStreamsMethodCallCounter = new InstructionCounter();
        InstructionCounter replacedTimeMethodCallCounter = new InstructionCounter();
        if (targetClassVersion < 0x350000) {
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
            programClassPool.classesAccept(new ClassVersionFilter(0x350000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new MultiClassVisitor(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeEditor(codeAttributeEditor, new StringConcatenationConverter(replacedStringConcatCounter, codeAttributeEditor)))), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(programClassPool, libraryClassPool)))))));
        }
        if (targetClassVersion < 0x340000) {
            ClassPool filteredClasses = new ClassPool();
            programClassPool.classesAccept(new ClassVersionFilter(0x340000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new ClassPoolFiller(filteredClasses))))));
            filteredClasses.classesAccept(new MultiClassVisitor(new LambdaExpressionConverter(programClassPool, libraryClassPool, extraDataEntryNameMap, lambdaExpressionCounter), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(programClassPool, libraryClassPool)));
            ClassPool interfaceClasses = new ClassPool();
            programClassPool.classesAccept(new ClassVersionFilter(0x340000, new ClassAccessFilter(512, 0, new ClassPoolFiller(interfaceClasses))));
            ClassPool modifiedClasses2 = new ClassPool();
            ClassPoolFiller modifiedClassCollector2 = new ClassPoolFiller(modifiedClasses2);
            interfaceClasses.classesAccept(new MultiClassVisitor(new StaticInterfaceMethodConverter(programClassPool, libraryClassPool, extraDataEntryNameMap, modifiedClassCollector2, staticInterfaceMethodCounter), new DefaultInterfaceMethodConverter(modifiedClassCollector2, defaultInterfaceMethodCounter)));
            modifiedClasses2.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool));
        }
        if (targetClassVersion < 0x330000) {
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder(programClassPool, libraryClassPool);
            Instruction[][][] instructions = new Instruction[][][]{{____.invokestatic("java/util/Objects", "requireNonNull", "(Ljava/lang/Object;)Ljava/lang/Object;").__(), ____.dup().invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;").pop().__()}, {____.invokevirtual("java/util/Throwable", "addSuppressed", "(Ljava/lang/Throwable;)V").__(), ____.pop().pop().__()}};
            Constant[] constants = ____.constants();
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeEditor(null, codeAttributeEditor, new InstructionSequencesReplacer(constants, instructions, null, codeAttributeEditor, (InstructionVisitor)replacedMethodCallCounter)))));
        }
        if (targetClassVersion < 0x340000) {
            ClassCounter streamSupportClasses = new ClassCounter();
            ClassNameFilter streamSupportVisitor = new ClassNameFilter("java8/**", (ClassVisitor)streamSupportClasses);
            programClassPool.classesAccept(streamSupportVisitor);
            libraryClassPool.classesAccept(streamSupportVisitor);
            if (streamSupportClasses.getCount() > 0) {
                WarningPrinter streamSupportWarningPrinter = new WarningPrinter(err, this.configuration.warn);
                modifiedClasses = new ClassPool();
                modifiedClassCollector = new ClassPoolFiller(modifiedClasses);
                programClassPool.classesAccept(new ClassNameFilter("!java8/**", (ClassVisitor)new StreamSupportConverter(programClassPool, libraryClassPool, streamSupportWarningPrinter, modifiedClassCollector, replacedStreamsMethodCallCounter)));
                modifiedClasses.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool));
                conversionWarningCount = streamSupportWarningPrinter.getWarningCount();
                if (conversionWarningCount > 0) {
                    err.println("Warning: there were " + conversionWarningCount + " Java 8 stream API method calls that could not be backported.");
                    err.println("      You should check if a your project setup is correct (compileSdkVersion, streamsupport dependency).");
                    err.println("      For more information, consult the section 'Integration->Gradle Plugin->Java 8 stream API support' in our manual");
                }
            }
        }
        if (targetClassVersion < 0x340000) {
            ClassCounter threetenClasses = new ClassCounter();
            ClassNameFilter threetenClassVisitor = new ClassNameFilter("org/threeten/bp/**", (ClassVisitor)threetenClasses);
            programClassPool.classesAccept(threetenClassVisitor);
            libraryClassPool.classesAccept(threetenClassVisitor);
            if (threetenClasses.getCount() > 0) {
                WarningPrinter threetenWarningPrinter = new WarningPrinter(err, this.configuration.warn);
                modifiedClasses = new ClassPool();
                modifiedClassCollector = new ClassPoolFiller(modifiedClasses);
                programClassPool.classesAccept(new ClassNameFilter("!org/threeten/bp/**", (ClassVisitor)new JSR310Converter(programClassPool, libraryClassPool, threetenWarningPrinter, modifiedClassCollector, replacedTimeMethodCallCounter)));
                modifiedClasses.classesAccept(new ClassReferenceInitializer(programClassPool, libraryClassPool));
                conversionWarningCount = threetenWarningPrinter.getWarningCount();
                if (conversionWarningCount > 0) {
                    err.println("Warning: there were " + conversionWarningCount + " Java 8 time API method calls that could not be backported.");
                    err.println("      You should check if a your project setup is correct (compileSdkVersion, threetenbp dependency).");
                    err.println("      For more information, consult the section 'Integration->Gradle Plugin->Java 8 time API support' in our manual");
                }
            }
        }
        if (targetClassVersion != 0) {
            programClassPool.classesAccept(new ClassVersionSetter(targetClassVersion));
        }
        if (this.configuration.verbose) {
            System.out.println("  Number of converted string concatenations:     " + replacedStringConcatCounter.getCount());
            System.out.println("  Number of converted lambda expressions:        " + lambdaExpressionCounter.getCount());
            System.out.println("  Number of converted static interface methods:  " + staticInterfaceMethodCounter.getCount());
            System.out.println("  Number of converted default interface methods: " + defaultInterfaceMethodCounter.getCount());
            System.out.println("  Number of replaced Java 7+ method calls:       " + replacedMethodCallCounter.getCount());
            System.out.println("  Number of replaced Java 8 stream method calls: " + replacedStreamsMethodCallCounter.getCount());
            System.out.println("  Number of replaced Java 8 time method calls:   " + replacedTimeMethodCallCounter.getCount());
        }
    }
}

