/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.KotlinModulePackage;
import proguard.resources.kotlinmodule.visitor.KotlinModulePackageVisitor;
import proguard.shrink.SimpleUsageMarker;

public class KotlinModuleUsageMarker
implements ResourceFileVisitor,
KotlinModulePackageVisitor {
    private final SimpleUsageMarker usageMarker;
    private boolean isUsed = false;

    public KotlinModuleUsageMarker(SimpleUsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
        this.isUsed = false;
        kotlinModule.modulePackagesAccept(this);
        if (this.isUsed) {
            this.usageMarker.markAsUsed(kotlinModule);
        }
    }

    @Override
    public void visitKotlinModulePackage(KotlinModule kotlinModule, KotlinModulePackage kotlinModulePart) {
        this.isUsed |= kotlinModulePart.referencedFileFacades.stream().anyMatch(this.usageMarker::isUsed) || kotlinModulePart.referencedMultiFileParts.values().stream().anyMatch(mfp -> this.usageMarker.isUsed(mfp.referencedFacadeClass));
    }
}

