/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.file.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import proguard.io.DataEntry;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryToken;
import proguard.io.DataEntryTokenType;
import proguard.io.DataEntryTokenizer;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.ResourceJavaReference;
import proguard.resources.file.visitor.ResourceFileVisitor;

public class ResourceFileDataEntryReader
implements DataEntryReader {
    private final ResourceFileVisitor resourceFileVisitor;
    private final DataEntryFilter adaptedDataEntryFilter;

    public ResourceFileDataEntryReader(ResourceFileVisitor resourceFileVisitor) {
        this(resourceFileVisitor, null);
    }

    public ResourceFileDataEntryReader(ResourceFileVisitor resourceFileVisitor, DataEntryFilter adaptedDataEntryFilter) {
        this.resourceFileVisitor = resourceFileVisitor;
        this.adaptedDataEntryFilter = adaptedDataEntryFilter;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        if (!dataEntry.isDirectory()) {
            ResourceFile resourceFile = new ResourceFile(dataEntry.getName(), 0L);
            if (this.adaptedDataEntryFilter != null && this.adaptedDataEntryFilter.accepts(dataEntry)) {
                resourceFile.references = this.collectJavaReferences(dataEntry);
            }
            this.resourceFileVisitor.visitResourceFile(resourceFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ResourceJavaReference> collectJavaReferences(DataEntry dataEntry) throws IOException {
        HashSet<ResourceJavaReference> set = new HashSet<ResourceJavaReference>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(dataEntry.getInputStream()));
        try {
            DataEntryToken token;
            DataEntryTokenizer tokenizer = new DataEntryTokenizer(reader);
            while ((token = tokenizer.nextToken()) != null) {
                if (token.type != DataEntryTokenType.JAVA_IDENTIFIER) continue;
                set.add(new ResourceJavaReference(token.string));
            }
        }
        finally {
            dataEntry.closeInputStream();
        }
        return set;
    }
}

