/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.ReferenceTracingValueFactory;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.ParameterTracingInvocationUnit;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.optimize.info.ReferenceEscapeChecker;
import proguard.optimize.info.SideEffectClassChecker;

public class ParameterEscapeMarker
implements MemberVisitor,
AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ParameterVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraMemberVisitor;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private final ReferenceEscapeChecker referenceEscapeChecker;
    private final boolean runReferenceEscapeChecker;
    private final MemberVisitor parameterMarker = new AllParameterVisitor(true, this);
    private Clazz referencingClass;
    private Method referencingMethod;
    private int referencingOffset;
    private int referencingPopCount;
    private boolean isReturnValueEscaping;
    private boolean isReturnValueModified;

    public ParameterEscapeMarker() {
        this(null);
    }

    public ParameterEscapeMarker(MemberVisitor extraMemberVisitor) {
        this(new BasicValueFactory(), extraMemberVisitor);
    }

    public ParameterEscapeMarker(ValueFactory valueFactory, MemberVisitor extraMemberVisitor) {
        this(valueFactory, new ReferenceTracingValueFactory(valueFactory), extraMemberVisitor);
    }

    public ParameterEscapeMarker(ValueFactory valueFactory, ReferenceTracingValueFactory tracingValueFactory, MemberVisitor extraMemberVisitor) {
        this(new PartialEvaluator(tracingValueFactory, new ParameterTracingInvocationUnit(new BasicInvocationUnit(tracingValueFactory)), true, tracingValueFactory), true, extraMemberVisitor);
    }

    public ParameterEscapeMarker(PartialEvaluator partialEvaluator, boolean runPartialEvaluator, MemberVisitor extraMemberVisitor) {
        this(partialEvaluator, runPartialEvaluator, new ReferenceEscapeChecker(partialEvaluator, false), true, extraMemberVisitor);
    }

    public ParameterEscapeMarker(PartialEvaluator partialEvaluator, boolean runPartialEvaluator, ReferenceEscapeChecker referenceEscapeChecker, boolean runReferenceEscapeChecker, MemberVisitor extraMemberVisitor) {
        this.extraMemberVisitor = extraMemberVisitor;
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = runPartialEvaluator;
        this.referenceEscapeChecker = referenceEscapeChecker;
        this.runReferenceEscapeChecker = runReferenceEscapeChecker;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int accessFlags = programMethod.getAccessFlags();
        if ((accessFlags & 0x100) != 0) {
            this.markModifiedParameters((Clazz)programClass, (Method)programMethod, -1L);
            this.markEscapingParameters((Clazz)programClass, (Method)programMethod, -1L);
            this.markReturnedParameters((Clazz)programClass, (Method)programMethod, -1L);
            this.markAnythingModified(programClass, programMethod);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (this.runReferenceEscapeChecker) {
            this.referenceEscapeChecker.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 83: {
                this.markModifiedParameters(clazz, method, offset, simpleInstruction.stackPopCount(clazz) - 1);
                this.markEscapingParameters(clazz, method, offset, 0);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                this.markModifiedParameters(clazz, method, offset, simpleInstruction.stackPopCount(clazz) - 1);
                break;
            }
            case -80: {
                this.markReturnedParameters(clazz, method, offset, 0);
                break;
            }
            case -65: {
                this.markEscapingParameters(clazz, method, offset, 0);
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -78: 
            case -69: 
            case -67: 
            case -59: 
            case 18: 
            case 19: {
                this.referencingClass = clazz;
                this.referencingMethod = method;
                this.referencingOffset = offset;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -77: {
                this.markAnythingModified(clazz, method);
                this.markEscapingParameters(clazz, method, offset, 0);
                break;
            }
            case -76: {
                this.markEscapingParameters(clazz, method, offset, 0);
                break;
            }
            case -75: {
                this.markModifiedParameters(clazz, method, offset, constantInstruction.stackPopCount(clazz) - 1);
                this.markEscapingParameters(clazz, method, offset, 0);
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -70: {
                this.referencingClass = clazz;
                this.referencingMethod = method;
                this.referencingOffset = offset;
                this.referencingPopCount = constantInstruction.stackPopCount(clazz);
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Clazz referencedClass = stringConstant.referencedClass;
        if (referencedClass == null || SideEffectClassChecker.mayHaveSideEffects(clazz, referencedClass)) {
            this.markAnythingModified(this.referencingClass, this.referencingMethod);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        Clazz referencedClass = classConstant.referencedClass;
        if (referencedClass == null || SideEffectClassChecker.mayHaveSideEffects(clazz, referencedClass)) {
            this.markAnythingModified(this.referencingClass, this.referencingMethod);
        }
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.markAnythingModified(this.referencingClass, this.referencingMethod);
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        clazz.constantPoolEntryAccept(fieldrefConstant.u2classIndex, this);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        Method referencedMethod = anyMethodrefConstant.referencedMethod;
        if (referencedMethod == null || ParameterEscapeMarker.modifiesAnything(referencedMethod) || SideEffectClassChecker.mayHaveSideEffects(clazz, anyMethodrefConstant.referencedClass, referencedMethod)) {
            this.markAnythingModified(this.referencingClass, this.referencingMethod);
        }
        if (referencedMethod == null) {
            for (int parameterOffset = 0; parameterOffset < this.referencingPopCount; ++parameterOffset) {
                int stackEntryIndex = this.referencingPopCount - parameterOffset - 1;
                this.markEscapingParameters(this.referencingClass, this.referencingMethod, this.referencingOffset, stackEntryIndex);
                this.markModifiedParameters(this.referencingClass, this.referencingMethod, this.referencingOffset, stackEntryIndex);
            }
        } else {
            this.isReturnValueEscaping = this.referenceEscapeChecker.isInstanceEscaping(this.referencingOffset);
            this.isReturnValueModified = this.referenceEscapeChecker.isInstanceModified(this.referencingOffset);
            anyMethodrefConstant.referencedMethodAccept(this.parameterMarker);
        }
    }

    @Override
    public void visitParameter(Clazz clazz, Member member, int parameterIndex, int parameterCount, int parameterOffset, int parameterSize, String parameterType, Clazz referencedClass) {
        if (!ClassUtil.isInternalPrimitiveType(parameterType.charAt(0))) {
            Method method = (Method)member;
            if (ParameterEscapeMarker.isParameterEscaping(method, parameterIndex) || ParameterEscapeMarker.isParameterReturned(method, parameterIndex) && this.isReturnValueEscaping) {
                this.markEscapingParameters(this.referencingClass, this.referencingMethod, this.referencingOffset, parameterSize - parameterOffset - 1);
            }
            if (ParameterEscapeMarker.isParameterModified(method, parameterIndex) || ParameterEscapeMarker.isParameterReturned(method, parameterIndex) && this.isReturnValueModified) {
                this.markModifiedParameters(this.referencingClass, this.referencingMethod, this.referencingOffset, parameterSize - parameterOffset - 1);
            }
        }
    }

    private void reportSideEffect(Clazz clazz, Method method) {
        if (this.extraMemberVisitor != null) {
            method.accept(clazz, this.extraMemberVisitor);
        }
    }

    private void markEscapingParameters(Clazz clazz, Method method, int consumerOffset, int stackEntryIndex) {
        ReferenceValue referenceValue;
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(consumerOffset);
        Value stackEntry = stackBefore.getTop(stackEntryIndex);
        if (stackEntry.computationalType() == 5 && (referenceValue = stackEntry.referenceValue()).isNull() != 1) {
            this.markEscapingParameters(clazz, method, referenceValue);
        }
    }

    private void markEscapingParameters(Clazz clazz, Method method, ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue producers = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int producerCount = producers.instructionOffsetCount();
        for (int index = 0; index < producerCount; ++index) {
            if (!producers.isMethodParameter(index)) continue;
            this.markParameterEscaping(clazz, method, producers.methodParameter(index));
        }
    }

    private void markParameterEscaping(Clazz clazz, Method method, int parameterIndex) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.isParameterEscaping(parameterIndex) && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setParameterEscaping(parameterIndex);
            if (methodOptimizationInfo.isParameterEscaping(parameterIndex)) {
                this.reportSideEffect(clazz, method);
            }
        }
    }

    private void markEscapingParameters(Clazz clazz, Method method, long escapingParameters) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        long oldEscapingParameters = methodOptimizationInfo.getEscapingParameters();
        if (((oldEscapingParameters ^ 0xFFFFFFFFFFFFFFFFL) & escapingParameters) != 0L && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).updateEscapingParameters(escapingParameters);
            if (methodOptimizationInfo.getEscapingParameters() != oldEscapingParameters) {
                this.reportSideEffect(clazz, method);
            }
        }
    }

    public static boolean isParameterEscaping(Method method, int parameterIndex) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).isParameterEscaping(parameterIndex);
    }

    public static long getEscapingParameters(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getEscapingParameters();
    }

    private void markReturnedParameters(Clazz clazz, Method method, int returnOffset, int stackEntryIndex) {
        ReferenceValue referenceValue;
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(returnOffset);
        Value stackEntry = stackBefore.getTop(stackEntryIndex);
        if (stackEntry.computationalType() == 5 && (referenceValue = stackEntry.referenceValue()).isNull() != 1 && this.mayReturnType(clazz, method, referenceValue)) {
            this.markReturnedParameters(clazz, method, referenceValue);
        }
    }

    private void markReturnedParameters(Clazz clazz, Method method, ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue producers = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int producerCount = producers.instructionOffsetCount();
        for (int index = 0; index < producerCount; ++index) {
            if (producers.isMethodParameter(index)) {
                this.markParameterReturned(clazz, method, producers.methodParameter(index));
                continue;
            }
            if (producers.isFieldValue(index)) {
                this.markReturnsExternalValues(clazz, method);
                continue;
            }
            if (!producers.isNewinstance(index) && !producers.isExceptionHandler(index)) continue;
            this.markReturnsNewInstances(clazz, method);
        }
    }

    private void markParameterReturned(Clazz clazz, Method method, int parameterIndex) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.returnsParameter(parameterIndex) && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setParameterReturned(parameterIndex);
            if (methodOptimizationInfo.returnsParameter(parameterIndex)) {
                this.reportSideEffect(clazz, method);
            }
        }
    }

    private void markReturnedParameters(Clazz clazz, Method method, long returnedParameters) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        long oldReturnedParameters = methodOptimizationInfo.getReturnedParameters();
        if (((oldReturnedParameters ^ 0xFFFFFFFFFFFFFFFFL) & returnedParameters) != 0L && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).updateReturnedParameters(returnedParameters);
            if (methodOptimizationInfo.getReturnedParameters() != oldReturnedParameters) {
                this.reportSideEffect(clazz, method);
            }
        }
    }

    public static boolean isParameterReturned(Method method, int parameterIndex) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).returnsParameter(parameterIndex);
    }

    public static long getReturnedParameters(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getReturnedParameters();
    }

    private void markReturnsNewInstances(Clazz clazz, Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.returnsNewInstances() && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setReturnsNewInstances();
            if (methodOptimizationInfo.returnsNewInstances()) {
                this.reportSideEffect(clazz, method);
            }
        }
    }

    public static boolean returnsNewInstances(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).returnsNewInstances();
    }

    private void markReturnsExternalValues(Clazz clazz, Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.returnsExternalValues() && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setReturnsExternalValues();
            if (methodOptimizationInfo.returnsExternalValues()) {
                this.reportSideEffect(clazz, method);
            }
        }
    }

    public static boolean returnsExternalValues(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).returnsExternalValues();
    }

    private boolean mayReturnType(Clazz clazz, Method method, ReferenceValue referenceValue) {
        String returnType = ClassUtil.internalMethodReturnType(method.getDescriptor(clazz));
        Clazz[] referencedClasses = method instanceof ProgramMethod ? ((ProgramMethod)method).referencedClasses : ((LibraryMethod)method).referencedClasses;
        Clazz referencedClass = referencedClasses == null || !ClassUtil.isInternalClassType(returnType) ? null : referencedClasses[referencedClasses.length - 1];
        return referenceValue.instanceOf(returnType, referencedClass) != -1;
    }

    private void markModifiedParameters(Clazz clazz, Method method, int offset, int stackEntryIndex) {
        ReferenceValue referenceValue;
        TracedStack stackBefore = this.partialEvaluator.getStackBefore(offset);
        Value stackEntry = stackBefore.getTop(stackEntryIndex);
        if (stackEntry.computationalType() == 5 && (referenceValue = stackEntry.referenceValue()).isNull() != 1) {
            this.markModifiedParameters(clazz, method, referenceValue);
        }
    }

    private void markModifiedParameters(Clazz clazz, Method method, ReferenceValue referenceValue) {
        TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
        InstructionOffsetValue producers = tracedReferenceValue.getTraceValue().instructionOffsetValue();
        int producerCount = producers.instructionOffsetCount();
        for (int index = 0; index < producerCount; ++index) {
            if (producers.isMethodParameter(index)) {
                this.markParameterModified(clazz, method, producers.methodParameter(index));
                continue;
            }
            if (producers.isNewinstance(index) || producers.isExceptionHandler(index)) continue;
            this.markModifiedParameters(clazz, method, ParameterEscapeMarker.getEscapingParameters(method));
            this.markAnythingModified(clazz, method);
        }
    }

    private void markParameterModified(Clazz clazz, Method method, int parameterIndex) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.isParameterModified(parameterIndex) && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setParameterModified(parameterIndex);
            if (methodOptimizationInfo.isParameterModified(parameterIndex)) {
                this.reportSideEffect(clazz, method);
            }
        }
    }

    private void markModifiedParameters(Clazz clazz, Method method, long modifiedParameters) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        long oldModifiedParameters = methodOptimizationInfo.getModifiedParameters();
        if (((oldModifiedParameters ^ 0xFFFFFFFFFFFFFFFFL) & modifiedParameters) != 0L && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).updateModifiedParameters(modifiedParameters);
            if (methodOptimizationInfo.getModifiedParameters() != oldModifiedParameters) {
                this.reportSideEffect(clazz, method);
            }
        }
    }

    public static boolean isParameterModified(Method method, int parameterIndex) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).isParameterModified(parameterIndex);
    }

    public static long getModifiedParameters(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).getModifiedParameters();
    }

    private void markAnythingModified(Clazz clazz, Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.modifiesAnything() && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setModifiesAnything();
            if (methodOptimizationInfo.modifiesAnything()) {
                this.reportSideEffect(clazz, method);
            }
        }
    }

    public static boolean modifiesAnything(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).modifiesAnything();
    }
}

