/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.kotlin.visitor.AllFunctionsVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinFunctionFilter;
import proguard.classfile.visitor.MemberVisitor;

public class MethodToKotlinFunctionVisitor
implements MemberVisitor {
    private final KotlinFunctionVisitor kotlinFunctionVisitor;

    public MethodToKotlinFunctionVisitor(KotlinFunctionVisitor kotlinFunctionVisitor) {
        this.kotlinFunctionVisitor = kotlinFunctionVisitor;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programClass.kotlinMetadataAccept(new AllFunctionsVisitor(new KotlinFunctionFilter(func -> programMethod.equals(func.referencedMethod), this.kotlinFunctionVisitor)));
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        libraryClass.kotlinMetadataAccept(new AllFunctionsVisitor(new KotlinFunctionFilter(func -> libraryMethod.equals(func.referencedMethod), this.kotlinFunctionVisitor)));
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
    }
}

