/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.RecordComponentInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.util.SimpleProcessable;

public abstract class Attribute
extends SimpleProcessable {
    public static final String BOOTSTRAP_METHODS = "BootstrapMethods";
    public static final String SOURCE_FILE = "SourceFile";
    public static final String SOURCE_DIR = "SourceDir";
    public static final String RECORD = "Record";
    public static final String INNER_CLASSES = "InnerClasses";
    public static final String ENCLOSING_METHOD = "EnclosingMethod";
    public static final String NEST_HOST = "NestHost";
    public static final String NEST_MEMBERS = "NestMembers";
    public static final String PERMITTED_SUBCLASSES = "PermittedSubclasses";
    public static final String DEPRECATED = "Deprecated";
    public static final String SYNTHETIC = "Synthetic";
    public static final String SIGNATURE = "Signature";
    public static final String CONSTANT_VALUE = "ConstantValue";
    public static final String METHOD_PARAMETERS = "MethodParameters";
    public static final String EXCEPTIONS = "Exceptions";
    public static final String CODE = "Code";
    public static final String STACK_MAP = "StackMap";
    public static final String STACK_MAP_TABLE = "StackMapTable";
    public static final String LINE_NUMBER_TABLE = "LineNumberTable";
    public static final String LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    public static final String LOCAL_VARIABLE_TYPE_TABLE = "LocalVariableTypeTable";
    public static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    public static final String RUNTIME_INVISIBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations";
    public static final String RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = "RuntimeVisibleParameterAnnotations";
    public static final String RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = "RuntimeInvisibleParameterAnnotations";
    public static final String RUNTIME_VISIBLE_TYPE_ANNOTATIONS = "RuntimeVisibleTypeAnnotations";
    public static final String RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = "RuntimeInvisibleTypeAnnotations";
    public static final String ANNOTATION_DEFAULT = "AnnotationDefault";
    public static final String MODULE = "Module";
    public static final String MODULE_MAIN_CLASS = "ModuleMainClass";
    public static final String MODULE_PACKAGES = "ModulePackages";
    public static final String SOURCE_DEBUG_EXTENSION = "SourceDebugExtension";
    public static final String CHARACTER_RANGE_TABLE = "CharacterRangeTable";
    public static final String COMPILATION_I_D = "CompilationID";
    public static final String SOURCE_I_D = "SourceID";
    public int u2attributeNameIndex;

    protected Attribute() {
    }

    protected Attribute(int u2attributeNameIndex) {
        this.u2attributeNameIndex = u2attributeNameIndex;
    }

    public String getAttributeName(Clazz clazz) {
        return clazz.getString(this.u2attributeNameIndex);
    }

    public void accept(Clazz clazz, AttributeVisitor attributeVisitor) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + attributeVisitor.getClass().getName() + "] on a class");
    }

    public void accept(Clazz clazz, Field field, AttributeVisitor attributeVisitor) {
        if (field != null) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + attributeVisitor.getClass().getName() + " on a field");
        }
        this.accept(clazz, attributeVisitor);
    }

    public void accept(Clazz clazz, Method method, AttributeVisitor attributeVisitor) {
        if (method != null) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + attributeVisitor.getClass().getName() + " on a method");
        }
        this.accept(clazz, (Field)null, attributeVisitor);
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, AttributeVisitor attributeVisitor) {
        if (codeAttribute != null) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + attributeVisitor.getClass().getName() + " on code");
        }
        this.accept(clazz, method, attributeVisitor);
    }

    public void accept(Clazz clazz, RecordComponentInfo recordComponentInfo, AttributeVisitor attributeVisitor) {
        if (recordComponentInfo != null) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + attributeVisitor.getClass().getName() + " on a record component");
        }
        this.accept(clazz, attributeVisitor);
    }
}

