/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintWriter;
import proguard.Configuration;
import proguard.ConfigurationChecker;
import proguard.ConfigurationParser;
import proguard.ConfigurationWriter;
import proguard.GPL;
import proguard.Initializer;
import proguard.InputReader;
import proguard.OutputWriter;
import proguard.SeedPrinter;
import proguard.Targeter;
import proguard.UpToDateChecker;
import proguard.backport.Backporter;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.editor.ClassElementSorter;
import proguard.classfile.editor.LineNumberTableAttributeTrimmer;
import proguard.classfile.editor.NamedAttributeDeleter;
import proguard.classfile.io.kotlin.KotlinMetadataWriter;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.util.ArrayInitializationReplacer;
import proguard.classfile.util.PrimitiveArrayConstantReplacer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.configuration.ConfigurationLoggingAdder;
import proguard.configuration.InitialStateInfo;
import proguard.evaluation.IncompleteClassHierarchyException;
import proguard.io.ExtraDataEntryNameMap;
import proguard.mark.Marker;
import proguard.obfuscate.Obfuscator;
import proguard.optimize.Optimizer;
import proguard.optimize.gson.GsonOptimizer;
import proguard.optimize.peephole.LineNumberLinearizer;
import proguard.preverify.Preverifier;
import proguard.preverify.SubroutineInliner;
import proguard.resources.file.ResourceFilePool;
import proguard.shrink.Shrinker;
import proguard.strip.KotlinAnnotationStripper;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.PrintWriterUtil;

public class ProGuard {
    public static final String VERSION = "ProGuard, version " + ProGuard.getVersion();
    private final Configuration configuration;
    private ClassPool programClassPool = new ClassPool();
    private final ClassPool libraryClassPool = new ClassPool();
    private final ResourceFilePool resourceFilePool = new ResourceFilePool();
    private InitialStateInfo initialStateInfo;
    private final ExtraDataEntryNameMap extraDataEntryNameMap = new ExtraDataEntryNameMap();

    public ProGuard(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute() throws IOException {
        System.out.println(VERSION);
        GPL.check();
        try {
            if (this.configuration.printConfiguration != null) {
                this.printConfiguration();
            }
            new ConfigurationChecker(this.configuration).check();
            if (this.configuration.programJars != null && this.configuration.programJars.hasOutput() && new UpToDateChecker(this.configuration).check()) {
                return;
            }
            if (this.configuration.targetClassVersion != 0) {
                this.configuration.backport = true;
            }
            this.readInput();
            if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
                this.clearPreverification();
            }
            if (this.configuration.printSeeds != null || this.configuration.backport || this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify || this.configuration.addConfigurationDebugging || this.configuration.keepKotlinMetadata) {
                this.initialize();
                this.mark();
            }
            if (this.configuration.addConfigurationDebugging) {
                this.initialStateInfo = new InitialStateInfo(this.programClassPool);
            }
            if (this.configuration.keepKotlinMetadata) {
                this.stripKotlinMetadataAnnotations();
            }
            if (this.configuration.optimize || this.configuration.obfuscate) {
                this.introducePrimitiveArrayConstants();
            }
            if (this.configuration.backport) {
                this.backport();
            }
            if (this.configuration.addConfigurationDebugging) {
                this.addConfigurationLogging();
            }
            if (this.configuration.printSeeds != null) {
                this.printSeeds();
            }
            if (this.configuration.preverify || this.configuration.android) {
                this.inlineSubroutines();
            }
            if (this.configuration.shrink) {
                this.shrink();
            }
            if (this.configuration.optimize) {
                this.optimizeGson();
            }
            if (this.configuration.optimize) {
                for (int optimizationPass = 0; optimizationPass < this.configuration.optimizationPasses && this.optimize(optimizationPass + 1, this.configuration.optimizationPasses); ++optimizationPass) {
                    if (!this.configuration.shrink) continue;
                    this.configuration.printUsage = null;
                    this.configuration.whyAreYouKeeping = null;
                    this.shrink();
                }
                this.linearizeLineNumbers();
            }
            if (this.configuration.obfuscate) {
                this.obfuscate();
            }
            if (this.configuration.keepKotlinMetadata) {
                this.keepKotlinMetadata();
            }
            if (this.configuration.optimize || this.configuration.obfuscate) {
                this.expandPrimitiveArrayConstants();
            }
            if (this.configuration.targetClassVersion != 0) {
                this.target();
            }
            if (this.configuration.preverify) {
                this.preverify();
            }
            if (this.configuration.optimize || this.configuration.preverify) {
                this.trimLineNumbers();
            }
            if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
                this.sortClassElements();
            }
            if (this.configuration.programJars.hasOutput()) {
                this.writeOutput();
            }
            if (this.configuration.dump != null) {
                this.dump();
            }
        }
        catch (IncompleteClassHierarchyException e) {
            System.err.println();
            System.err.println("It appears you are missing some classes resulting in an incomplete class hierarchy, " + System.lineSeparator() + "please refer to the troubleshooting page in the manual: " + System.lineSeparator() + "https://www.guardsquare.com/en/products/proguard/manual/troubleshooting#superclass");
        }
    }

    private void printConfiguration() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing configuration to [" + PrintWriterUtil.fileName(this.configuration.printConfiguration) + "]...");
        }
        PrintWriter pw = PrintWriterUtil.createPrintWriterOut(this.configuration.printConfiguration);
        try {
            new ConfigurationWriter(pw).write(this.configuration);
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.printConfiguration, pw);
        }
    }

    private void readInput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Reading input...");
        }
        new InputReader(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.resourceFilePool);
    }

    private void initialize() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Initializing...");
        }
        new Initializer(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.resourceFilePool);
    }

    private void mark() {
        if (this.configuration.verbose) {
            System.out.println("Marking classes and class members to be kept...");
        }
        new Marker(this.configuration).mark(this.programClassPool, this.libraryClassPool);
    }

    private void stripKotlinMetadataAnnotations() {
        new KotlinAnnotationStripper().execute(this.configuration, this.programClassPool, this.libraryClassPool);
    }

    private void introducePrimitiveArrayConstants() {
        this.programClassPool.classesAccept(new ArrayInitializationReplacer());
    }

    private void expandPrimitiveArrayConstants() {
        this.programClassPool.classesAccept(new PrimitiveArrayConstantReplacer());
    }

    private void backport() {
        new Backporter(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.extraDataEntryNameMap);
    }

    private void addConfigurationLogging() throws IOException {
        new ConfigurationLoggingAdder().execute(this.programClassPool, this.libraryClassPool, this.extraDataEntryNameMap);
    }

    private void keepKotlinMetadata() {
        if (this.configuration.verbose) {
            System.out.println("Adapting Kotlin metadata...");
        }
        WarningPrinter warningPrinter = new WarningPrinter(new PrintWriter(System.out, true));
        ClassCounter counter = new ClassCounter();
        this.programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinMetadataWriter(warningPrinter, counter)));
        if (this.configuration.verbose) {
            System.out.println("  Number of Kotlin classes adapted:              " + counter.getCount());
        }
    }

    private void target() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Setting target versions...");
        }
        new Targeter(this.configuration).execute(this.programClassPool);
    }

    private void printSeeds() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing kept classes, fields, and methods...");
        }
        PrintWriter pw = PrintWriterUtil.createPrintWriterOut(this.configuration.printSeeds);
        try {
            new SeedPrinter(pw).write(this.configuration, this.programClassPool, this.libraryClassPool);
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.printSeeds, pw);
        }
    }

    private void shrink() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Shrinking...");
            if (this.configuration.whyAreYouKeeping != null) {
                System.out.println("Explaining why classes and class members are being kept...");
            }
            if (this.configuration.printUsage != null) {
                System.out.println("Printing usage to [" + PrintWriterUtil.fileName(this.configuration.printUsage) + "]...");
            }
        }
        this.programClassPool = new Shrinker(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.resourceFilePool);
    }

    private void inlineSubroutines() {
        if (this.configuration.verbose) {
            System.out.println("Inlining subroutines...");
        }
        new SubroutineInliner(this.configuration).execute(this.programClassPool);
    }

    private void optimizeGson() throws IOException {
        if (this.programClassPool.getClass("com/google/gson/Gson") != null && (this.configuration.optimizations == null || new ListParser(new NameParser()).parse(this.configuration.optimizations).matches("library/gson"))) {
            if (this.configuration.verbose) {
                System.out.println("Optimizing usages of Gson library...");
            }
            new GsonOptimizer().execute(this.programClassPool, this.libraryClassPool, this.extraDataEntryNameMap, this.configuration);
        }
    }

    private boolean optimize(int currentPass, int maxPasses) throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Optimizing (pass " + currentPass + "/" + maxPasses + ")...");
        }
        return new Optimizer(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.extraDataEntryNameMap);
    }

    private void obfuscate() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Obfuscating...");
        }
        new Obfuscator(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.resourceFilePool);
    }

    private void linearizeLineNumbers() {
        this.programClassPool.classesAccept(new LineNumberLinearizer());
    }

    private void trimLineNumbers() {
        this.programClassPool.classesAccept(new AllAttributeVisitor(true, new LineNumberTableAttributeTrimmer()));
    }

    private void clearPreverification() {
        this.programClassPool.classesAccept(new ClassVersionFilter(0x320000, new AllMethodVisitor(new AllAttributeVisitor(new NamedAttributeDeleter("StackMapTable")))));
    }

    private void preverify() {
        if (this.configuration.verbose) {
            System.out.println("Preverifying...");
        }
        new Preverifier(this.configuration).execute(this.programClassPool);
    }

    private void sortClassElements() {
        this.programClassPool.classesAccept(new ClassElementSorter());
    }

    private void writeOutput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Writing output...");
        }
        new OutputWriter(this.configuration).execute(this.programClassPool, this.initialStateInfo, this.resourceFilePool, this.extraDataEntryNameMap);
    }

    private void dump() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing classes to [" + PrintWriterUtil.fileName(this.configuration.dump) + "]...");
        }
        PrintWriter pw = PrintWriterUtil.createPrintWriterOut(this.configuration.dump);
        try {
            this.programClassPool.classesAccept(new ClassPrinter(pw));
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.dump, pw);
        }
    }

    public static String getVersion() {
        String version;
        Package pack = ProGuard.class.getPackage();
        if (pack != null && (version = pack.getImplementationVersion()) != null) {
            return version;
        }
        return "undefined";
    }

    public static void main(String[] args2) {
        if (args2.length == 0) {
            System.out.println(VERSION);
            System.out.println("Usage: java proguard.ProGuard [options ...]");
            System.exit(1);
        }
        Configuration configuration = new Configuration();
        try {
            try (ConfigurationParser parser = new ConfigurationParser(args2, System.getProperties());){
                parser.parse(configuration);
            }
            new ProGuard(configuration).execute();
        }
        catch (Exception ex) {
            if (configuration.verbose) {
                ex.printStackTrace();
            } else {
                System.err.println("Error: " + ex.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

