/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.NonPrivateMemberMarker;

public class MemberPrivatizer
implements MemberVisitor {
    private final MemberVisitor extraMemberVisitor;

    public MemberPrivatizer() {
        this(null);
    }

    public MemberPrivatizer(MemberVisitor extraMemberVisitor) {
        this.extraMemberVisitor = extraMemberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (NonPrivateMemberMarker.canBeMadePrivate(programField)) {
            programField.u2accessFlags = AccessUtil.replaceAccessFlags(programField.u2accessFlags, 2);
            if (this.extraMemberVisitor != null) {
                this.extraMemberVisitor.visitProgramField(programClass, programField);
            }
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (NonPrivateMemberMarker.canBeMadePrivate(programMethod)) {
            programMethod.u2accessFlags = AccessUtil.replaceAccessFlags(programMethod.u2accessFlags, 2);
            if (this.extraMemberVisitor != null) {
                this.extraMemberVisitor.visitProgramMethod(programClass, programMethod);
            }
        }
    }
}

