/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ProGuard;
import proguard.ant.ConfigurationElement;
import proguard.ant.ConfigurationTask;
import proguard.classfile.util.ClassUtil;

public class ProGuardTask
extends ConfigurationTask {
    public void setConfiguration(File configurationFile) throws BuildException {
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.getProject().getProperties());
            URL configUrl = ConfigurationElement.class.getResource(configurationFile.toString());
            try (ConfigurationParser parser = configUrl != null ? new ConfigurationParser(configUrl, properties) : new ConfigurationParser(configurationFile, properties);){
                parser.parse(this.configuration);
            }
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), e);
        }
    }

    public void setOutjar(String parameters) {
        throw new BuildException("Use the <outjar> nested element instead of the 'outjar' attribute");
    }

    public void setSkipnonpubliclibraryclasses(boolean skipNonPublicLibraryClasses) {
        this.configuration.skipNonPublicLibraryClasses = skipNonPublicLibraryClasses;
    }

    public void setSkipnonpubliclibraryclassmembers(boolean skipNonPublicLibraryClassMembers) {
        this.configuration.skipNonPublicLibraryClassMembers = skipNonPublicLibraryClassMembers;
    }

    public void setTarget(String target) {
        this.configuration.targetClassVersion = ClassUtil.internalClassVersion(target);
        if (this.configuration.targetClassVersion == 0) {
            throw new BuildException("Unsupported target '" + target + "'");
        }
    }

    public void setForceprocessing(boolean forceProcessing) {
        this.configuration.lastModified = forceProcessing ? Long.MAX_VALUE : 0L;
    }

    public void setPrintseeds(File printSeeds) {
        this.configuration.printSeeds = this.optionalFile(printSeeds);
    }

    public void setShrink(boolean shrink) {
        this.configuration.shrink = shrink;
    }

    public void setPrintusage(File printUsage) {
        this.configuration.printUsage = this.optionalFile(printUsage);
    }

    public void setOptimize(boolean optimize) {
        this.configuration.optimize = optimize;
    }

    public void setOptimizationpasses(int optimizationPasses) {
        this.configuration.optimizationPasses = optimizationPasses;
    }

    public void setAllowaccessmodification(boolean allowAccessModification) {
        this.configuration.allowAccessModification = allowAccessModification;
    }

    public void setMergeinterfacesaggressively(boolean mergeinterfacesaggressively) {
        this.configuration.mergeInterfacesAggressively = mergeinterfacesaggressively;
    }

    public void setObfuscate(boolean obfuscate) {
        this.configuration.obfuscate = obfuscate;
    }

    public void setPrintmapping(File printMapping) {
        this.configuration.printMapping = this.optionalFile(printMapping);
    }

    public void setApplymapping(File applyMapping) {
        this.configuration.applyMapping = this.resolvedFile(applyMapping);
    }

    public void setObfuscationdictionary(File obfuscationDictionary) {
        this.configuration.obfuscationDictionary = this.resolvedURL(obfuscationDictionary);
    }

    public void setClassobfuscationdictionary(File classObfuscationDictionary) {
        this.configuration.classObfuscationDictionary = this.resolvedURL(classObfuscationDictionary);
    }

    public void setPackageobfuscationdictionary(File packageObfuscationDictionary) {
        this.configuration.packageObfuscationDictionary = this.resolvedURL(packageObfuscationDictionary);
    }

    public void setOverloadaggressively(boolean overloadAggressively) {
        this.configuration.overloadAggressively = overloadAggressively;
    }

    public void setUseuniqueclassmembernames(boolean useUniqueClassMemberNames) {
        this.configuration.useUniqueClassMemberNames = useUniqueClassMemberNames;
    }

    public void setUsemixedcaseclassnames(boolean useMixedCaseClassNames) {
        this.configuration.useMixedCaseClassNames = useMixedCaseClassNames;
    }

    public void setFlattenpackagehierarchy(String flattenPackageHierarchy) {
        this.configuration.flattenPackageHierarchy = ClassUtil.internalClassName(flattenPackageHierarchy);
    }

    public void setRepackageclasses(String repackageClasses) {
        this.configuration.repackageClasses = ClassUtil.internalClassName(repackageClasses);
    }

    public void setDefaultpackage(String defaultPackage) {
        this.configuration.repackageClasses = ClassUtil.internalClassName(defaultPackage);
    }

    public void setKeepparameternames(boolean keepParameterNames) {
        this.configuration.keepParameterNames = keepParameterNames;
    }

    public void setRenamesourcefileattribute(String newSourceFileAttribute) {
        this.configuration.newSourceFileAttribute = newSourceFileAttribute;
    }

    public void setPreverify(boolean preverify) {
        this.configuration.preverify = preverify;
    }

    public void setMicroedition(boolean microEdition) {
        this.configuration.microEdition = microEdition;
    }

    public void setAndroid(boolean android) {
        this.configuration.android = android;
    }

    public void setVerbose(boolean verbose) {
        this.configuration.verbose = verbose;
    }

    public void setNote(boolean note) {
        if (note) {
            if (this.configuration.note != null && this.configuration.note.isEmpty()) {
                this.configuration.note = null;
            }
        } else {
            this.configuration.note = new ArrayList<String>();
        }
    }

    public void setWarn(boolean warn) {
        if (warn) {
            if (this.configuration.warn != null && this.configuration.warn.isEmpty()) {
                this.configuration.warn = null;
            }
        } else {
            this.configuration.warn = new ArrayList<String>();
        }
    }

    public void setIgnorewarnings(boolean ignoreWarnings) {
        this.configuration.ignoreWarnings = ignoreWarnings;
    }

    public void setPrintconfiguration(File printConfiguration) {
        this.configuration.printConfiguration = this.optionalFile(printConfiguration);
    }

    public void setDump(File dump) {
        this.configuration.dump = this.optionalFile(dump);
    }

    public void setAddconfigurationdebugging(boolean addConfigurationDebugging) {
        this.configuration.addConfigurationDebugging = addConfigurationDebugging;
    }

    public void setKeepkotlinmetadata(boolean keepKotlinMetadata) {
        this.configuration.keepKotlinMetadata = keepKotlinMetadata;
    }

    @Override
    public void execute() throws BuildException {
        try {
            ProGuard proGuard = new ProGuard(this.configuration);
            proGuard.execute();
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), e);
        }
    }

    private File optionalFile(File file) {
        String fileName = file.getName();
        return fileName.equalsIgnoreCase("false") || fileName.equalsIgnoreCase("no") || fileName.equalsIgnoreCase("off") ? null : (fileName.equalsIgnoreCase("true") || fileName.equalsIgnoreCase("yes") || fileName.equalsIgnoreCase("on") ? Configuration.STD_OUT : this.resolvedFile(file));
    }

    private URL resolvedURL(File file) {
        try {
            return this.resolvedFile(file).toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private File resolvedFile(File file) {
        return file.isAbsolute() ? file : new File(this.getProject().getBaseDir(), file.getName());
    }
}

